<?php


/* Los headers permiten acceso desde otro dominio (CORS) a nuestro REST API o desde un cliente remoto via HTTP
 * Removiendo las lineas header() limitamos el acceso a nuestro RESTfull API a el mismo dominio
 * Nótese los métodos permitidos en Access-Control-Allow-Methods. Esto nos permite limitar los métodos de consulta a nuestro RESTfull API
 * Mas información: https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS
 **/

$dominioPermitido = "http://localhost:3000";

// header("Access-Control-Allow-Origin: $dominioPermitido"); // Para restringir desde dónde se pueden hacer peticines
// header("Access-Control-Allow-Headers: content-type");

header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: PUT, GET, POST, DELETE, OPTIONS');
header("Access-Control-Allow-Headers: X-Requested-With");
header('Content-Type: text/html; charset=utf-8');
header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');

include_once '../include/config.php';

require_once("../../include/dbcommon.php"); // DataBase PHPRunner

// DEBUG batch
$debugCode = true;
custom_error(1,"URL ejecutada: ".$_SERVER["REQUEST_URI"]); // To debug

use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
// use Selective\BasePath\BasePathMiddleware;
use Slim\Factory\AppFactory;

require_once __DIR__ . '/../libs/autoload.php';  // Biblioteca de SLIM

$app = AppFactory::create();
$app->addRoutingMiddleware();
// $app->add(new BasePathMiddleware($app)); // No usar si se ejecuta en subdirectorio
$app->addErrorMiddleware(true, true, true);
$app->addBodyParsingMiddleware();

$app->setBasePath(SCRIPTS_DIR); // Indica el directorio desde dónde está trabajando

// --------------------------------------------------------------------------------------

/* Usando GET para consultar los orders */

$app->get('/orders/list', function(Request $request, Response $response, array $args) {
    
    $responseBody = array();
    global $errorMessages;
  
    require_once '../include/DBorders.php';
    $orders = new DBorders();

    $respuesta = $orders->list();

    if ($respuesta[0] == true ) {  
        $responseBody["error"] = false;
        $responseBody["message"] = "Videojuegos cargados: " . count($respuesta[2]); 
        $responseBody["orders"] = $respuesta[2];
        // $response->getBody()->write(json_encode($responseBody));
        
        $response->getBody()->write('{"data":'.json_encode($respuesta[2], JSON_NUMERIC_CHECK).'}');
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    } else {
        $responseBody["error"] = true;
        $responseBody["message_num"] = '999';
        $responseBody["message"] = $respuesta[1];
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(500);
    }

});
// --------------------------------------------------------------------------------------

/* Usando put para View, Update, Delete de un videojuego */

$app->post('/orders/{action}/{id}', function(Request $request, Response $response, array $args) {
    
    $responseBody = array();
    global $errorMessages;
    
    include_once '../include/function.php';
    
        // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id'] = $args['id'];
    
    custom_error(2,"Action: ". $param['action']." ID: ".$param['id']); // To debug
    
    $verify = verifyRequiredParams(array('action','id'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(400);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('view','update','delete','add')) || !is_numeric($param['id']))  { // Si la acción es correcta y el id es un número
        $response->getBody()->write(json_encode($verify));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(400);
    }
    $action = $param['action'];
    $id = $param['id'];

    require_once '../include/DBorders.php';
    $orders = new DBorders();
    
    if ($action == 'view' || $action == 'delete') {
        
        $respuesta = $orders->$action($id); // Ejecutar la operación
    }
    if ($action == 'update' || $action == 'add') {
        
         /*
        $param2 = file_get_contents('php://input');  // Only JSON
        $param2 = urldecode($param2);
        custom_error(3,"En bruto: ". print_r($param2,true)); // To debug       
        $param2 = substr($param2,7); // quita etiqueta del JSON
        custom_error(3,"En JSON: ". print_r($param2,true)); // To debug
        $param2 = json_decode($param2, true);  // Only JSON
        custom_error(3,"Fields: ". print_r($param2,true)); // To debug
        */
	// check for required params by Forms
        // $param2 = $request->getParsedBody();
        $param2 = file_get_contents('php://input');  // Only JSON
        $param_array = explode("&", $param2);
        foreach ($param_array as &$var) {
            $var_array = explode("=",$var);
            if ($var_array[0] == 'values') {
                $param2 = urldecode($var_array[1]); // El JSON está en el campo "values"
            }
        }
        $param2 = json_decode($param2, true);  // Only JSON
        
        custom_error(4,"Fields: ". print_r($param2,true)); // To debug
        
        // Field SELECT `OrderID`, `CustomerID`, `OrderDate`, `ShippedDate`, `Freight`, 
        //               `ShipCity`, `ShipCountry`, `TotalOrder` FROM devExtre_tabla
        $verify = verifyParams(array('CustomerID','OrderDate','ShippedDate','Freight','ShipCity','ShipCountry','TotalOrder'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(400);
            }
        $param2 = adaptDates(array('OrderDate','ShippedDate'), $param2, $request, $response); // Adapta los campos de fecha
        $respuesta = $orders->$action($id,$param2); // Ejecutar la operación
        }
    
    if ($respuesta[0] == false ) { // Ha existido error
        $responseBody["error"] = true;
        $responseBody["message_num"] = '999';
        $responseBody["message"] = $errorMessages['999'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(500);
    }
    // Todo Ok
    $responseBody["error"] = false;
    $responseBody["message_num"] = '004';
    $responseBody["message"] = $errorMessages['004']; 
    $responseBody["orders"] = $respuesta[2];
    // $response->getBody()->write(json_encode($responseBody));
    
    $response->getBody()->write(json_encode($respuesta[2], JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);

});





/* corremos la aplicación */
$app->run();

