$(() => {
    // const URL = 'https://js.devexpress.com/Demos/Mvc/api/DataGridWebApi';
    const URL = 'http://localhost/devextreme_php/restapi/v1';

    function number_format(number, decimals, dec_point, thousands_sep) {
      //   example 1: number_format(1234.56);
      //   returns 1: '1,235'
      //   example 2: number_format(1234.56, 2, ',', ' ');
      //   returns 2: '1 234,56'
      //   example 3: number_format(1234.5678, 2, '.', '');
      //   returns 3: '1234.57'
      //   example 4: number_format(67, 2, ',', '.');
      //   returns 4: '67,00'
      //   example 5: number_format(1000);
      //   returns 5: '1,000'
      //   example 6: number_format(67.311, 2);
      //   returns 6: '67.31'
      //   example 7: number_format(1000.55, 1);
      //   returns 7: '1,000.6'
      //   example 8: number_format(67000, 5, ',', '.');
      //   returns 8: '67.000,00000'
      //   example 9: number_format(0.9, 0);
      //   returns 9: '1'
      //  example 10: number_format('1.20', 2);
      //  returns 10: '1.20'
      //  example 11: number_format('1.20', 4);
      //  returns 11: '1.2000'
      //  example 12: number_format('1.2000', 3);
      //  returns 12: '1.200'
      //  example 13: number_format('1 000,50', 2, '.', ' ');
      //  returns 13: '100 050.00'
      //  example 14: number_format(1e-8, 8, '.', '');
      //  returns 14: '0.00000001'
    
      number = (number + '')
        .replace(/[^0-9+\-Ee.]/g, '');
      var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function(n, prec) {
          var k = Math.pow(10, prec);
          return '' + (Math.round(n * k) / k)
            .toFixed(prec);
        };
      // Fix for IE parseFloat(0.55).toFixed(0) = 0;
      s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
        .split('.');
      if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
      }
      if ((s[1] || '')
        .length < prec) {
        s[1] = s[1] || '';
        s[1] += new Array(prec - s[1].length + 1)
          .join('0');
      }
      return s.join(dec);
    }
  
    const loadPanel = $('#loadPanel').dxLoadPanel({
      position: {
        of: '#gridContainer',
      },
      visible: false,
    }).dxLoadPanel('instance');
  
    loadPanel.show();
    sendRequest(`${URL}/orders/list`)
      .always(() => { loadPanel.hide(); })
      .then((data) => {
        dataGrid.option('dataSource', data);
      });
  
    const dataGrid = $('#gridContainer').dxDataGrid({
      keyExpr: 'OrderID',
      showBorders: true,
		height: 650,

		 headerFilter: {
			visible: true
		 },
		 paging: {
			pageSize: 10
		 },
		 pager: {
			showPageSizeSelector: true,
			allowedPageSizes: [2,5, 10, 20, 'all'],
		 },
		 searchPanel: {
			visible: true,
			width: 240,
			placeholder: 'Search...'
		 },
      
      dataSource: [],
      editing: {
        mode: 'row',
        allowAdding: true,
        allowUpdating: true,
        allowDeleting: true,
      },
      repaintChangesOnly: true,
      onOptionChanged(e) {
        if (e.name === 'editing') {
          const editRowKey = e.component.option('editing.editRowKey');
          let changes = e.component.option('editing.changes');
  
          $('#editRowKey').text(editRowKey === null ? 'null' : editRowKey);
  
          changes = changes.map((change) => ({
            type: change.type,
            key: change.type !== 'insert' ? change.key : undefined,
            data: change.data,
          }));
  
          $('#changes').text(JSON.stringify(changes, null, ' '));
        }
      },
      onSaving(e) {
        const change = e.changes[0];
  
        if (change) {
          e.cancel = true;
          loadPanel.show();
          e.promise = saveChange(URL, change)
            .always(() => { loadPanel.hide(); })
            .then((data) => {
              let orders = e.component.option('dataSource');
  
              if (change.type === 'insert') {
                change.data = data;
              }
              orders = DevExpress.data.applyChanges(orders, [change], { keyExpr: 'OrderID' });
  
              e.component.option({
                dataSource: orders,
                editing: {
                  editRowKey: null,
                  changes: [],
                },
              });
            });
        }
      },
      //`OrderID`, `CustomerID`, `OrderDate`, `ShippedDate`, `Freight`, 
      //`ShipCity`, `ShipCountry`, `TotalOrder`
      
      columns: [{
        dataField: 'OrderID',
        allowEditing: false,
      }, {
        dataField: 'CustomerID',
        allowEditing: false,
      }, {
        dataField: 'ShipCountry',
        allowEditing: false,
      }, {
        dataField: 'ShipCity',
        allowEditing: false,
      }, {
        dataField: 'ShippedDate',
        dataType: 'date',
        format: "shortDate",
        allowEditing: false,
      }, {
        dataField: 'OrderDate',
        dataType: 'date',
        format: "shortDate",
      }, {
        dataField: 'Freight',
        datatype: 'number',
        encodeHtml: false,
        alignment: 'right',
        format: function (value) {
          
          formattedValue="<div  style=\" color: blue \">"
          +number_format(value,2,',','.') +"</div>";
          return formattedValue;
        },
      }, {
        dataField: 'TotalOrder',
        caption: 'Total Orden',
        encodeHtml: false,
        alignment: 'right',
        datatype: 'number',
        format: function (value) {
          value<0?formattedValue="<div  style=\" color: red \">"+number_format(value,2,',','.') +"</div>":
          formattedValue=value>0?number_format(value,2,',','.'):null;
          return formattedValue;
        }
      }
      ],
    }).dxDataGrid('instance');
  
    function saveChange(url, change) {
      const msg = JSON.stringify(change.data);
      const key = change.key;

      switch (change.type) {
        case 'insert':
          return sendRequest(`${url}/orders/add/0`, 'POST', { values: JSON.stringify(change.data) });
        case 'update':
          return sendRequest(`${url}/orders/update/${change.key}`, 'POST', {  key: change.key, values: JSON.stringify(change.data) });
        case 'remove':
          return sendRequest(`${url}/orders/delete/${change.key}`, 'POST', { key: change.key });
        default:
          return null;
      }
    }
  
    function sendRequest(url, method = 'GET', data) {
      const d = $.Deferred();
  
      $.ajax(url, {
        method,
        data,
        cache: false,
        xhrFields: { withCredentials: true },
      }).then((result) => {
        d.resolve(method === 'GET' ? result.data : result);
      }, (xhr) => {
        d.reject(xhr.responseJSON ? xhr.responseJSON.Message : xhr.statusText);
      });
  
      return d.promise();
    }
  });
  