/*
Función para borrar contenido del campo Select2
*/
function clearSelect2(ctrl){
var field = ctrl.valContId;
$('#select2-'+field+'-container').html('');
$('#'+field).html('');
}

/*
Función para cargar variables de sesión en el server
Parámetros:
  - name: Key de $_SESSION.
  - value: Valor a poner en variable de sessión
  - ctrField: Campo "control", del lookup destino (sólo para Select2)
*/
function setSession(name,value,ctrField = null){
var destination = '';
if ( ctrField != null) {
  destination = ctrField.valContId;
}
$.ajax({
    async: false,
     cache: false,
     type: 'POST',  //  SEND with POST method
     url: 'setSession_ajax.php',  // Destination file (the PHP that manages the data)
     data: { 
      name: name,
      value: value,
      fieldDest: destination
      } // Data that are sent
     }).done(function( msg ) {  // Function that runs if everything has gone well
      console.log("Response the Function setSession: "+msg );
      
     }).fail(function (jqXHR, textStatus, errorThrown){ // Function that runs if something has gone wrong
      // We show the message with the error that has been produced
      console.log("The following error occured: "+ textStatus +" "+ errorThrown);
    });
}


/*
Función para hacer los AutoFill manualmente para solucionar esta función con los Plugins
Parámetros:
  - url: Url absoluta o relativa de la ejecución Ajax
  - ctrlParam: Objeto Control del campo que se enviará cómo parámetro
  - fieldControlArray: Array de objetos Control que será los receptores de los valores devueltos. Se aplicarán por orden

Autofill function manually to solve this function with plugins
Parameters:
- url: absolute or relative url of Ajax execution
- ctrlParam: Control object of the field that will be sent as parameter
- fieldControlArray: array of control objects that will be the receptors of the returned values. Will be applied in order
*/
function AutoFill(url,crtlParam, fieldControlArray){

    pvalue = crtlParam.getValue(); // We collect the value of the field from the form
   ajaxUrl = url;
    // Setting function and receives response with AJAX
    $.ajax({
    async: false,
     cache: false,
     type: 'POST',  //  SEND with POST method
     url: ajaxUrl,  // Destination file (the PHP that manages the data)
     data: { param: pvalue} // Data that are sent
     }).done(function( msg ) {  // Function that runs if everything has gone well
      msgArr = msg.split(";");
      if ( msgArr[0] == '1' ) { // Is OK
      for (let i = 0; i < fieldControlArray.length; i++) {
        var ctrl = fieldControlArray[i];
        ctrl.setValue(msgArr[i+2]); // Put Value
        console.log("Correct operation, recovered value: "+ msgArr[i+2]);
      } 
      } else { // Is KO
        // alert("The following error occured: "+msgArr[2]);
      console.log("The following error occured: "+msgArr[2]);
      }
     }).fail(function (jqXHR, textStatus, errorThrown){ // Function that runs if something has gone wrong
      // We show the message with the error that has been produced
      console.log("The following error occured: "+ textStatus +" "+ errorThrown);
    });
  }