import * as React from 'react';
import './style.css';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Unstable_Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';
import Rating from '@mui/material/Rating';
// import Typography from '@mui/material/Typography';
import StarIcon from '@mui/icons-material/Star';
import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

const labels = {
  1: 'Useless',
  2: 'Poor',
  3: 'Ok',
  4: 'Good',
  5: 'Excellent',
};

function getLabelText(value) {
  return `${value} Star${value !== 1 ? 's' : ''}, ${labels[value]}`;
}

function VideoAdd(props) {
  
  const [validacionForms, setValidacionForms] = React.useState(true);
  const [errorForms, setErrorForms] = React.useState('');

  const [nombre, setNombre] = React.useState('');
  const [errorNombre, setErrorNombre] = React.useState(false);
  const [helperNombre, setHelperNombre] = React.useState('');

  const [precio, setPrecio] = React.useState('');
  const [errorPrecio, setErrorPrecio] = React.useState(false);
  const [helperPrecio, setHelperPrecio] = React.useState('');

  const [calificacion, setCalificacion] = React.useState(1);
  const [hover, setHover] = React.useState(-1);


  const saveForms = (e) => { 
    // console.log("Incia el proceso de salvado de datos");

    e.preventDefault();

    if (!errorNombre && !errorPrecio && nombre !== '' && precio !== '' ) { // se han introducido los valores de los campos
      
      setValidacionForms(true); // Quitamos errores del formulario
      setErrorForms('');

      const options = {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(
            {
              "nombre": nombre,
              "precio": precio,
              "calificacion": calificacion
            }
        )
      };
     //  console.log("valor del campo options: ",options);

      fetch(`${Config.RUTA_API}/add/0`,options)
        .then((response) =>response.json())
        .then((result) => postSave() )
        .catch((error) => console.log("Error en actualizacion de datos: ",error))


    } else {
      // console.log("Errores en validacion de datos");

      setValidacionForms(false); // Ponemos los errores del formulario
      
      var Error = 'Falta la entrada de los datos o la información de estos campos está mal: ';
      
      if (errorNombre) {
        Error = Error +' (Nombre) ';
      }
      if (errorPrecio) {
         Error = Error +' (Precio) ';
      }
      setErrorForms(Error);
    }
  };

  const postSave = () => { 
    console.log("Iniciando en postSave()");
    setNombre("");
    setPrecio("");
    setCalificacion(1);

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Record added!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    // props.navigate(Config.URL_APP+'/');
  }

  const handleValidationNombre = (e) => {
    setNombre(e.target.value);
    const reg = new RegExp("^([0-9a-zA-Z ,:áéíóúüñÑ]){1,50}$");
    if (! reg.test(e.target.value)) {
      setHelperNombre('Entrada inválida para "Nombre"');
    } else {
      setHelperNombre(' ');
    }
    setErrorNombre(!reg.test(e.target.value));


    console.log("Name, Error: "+errorNombre);
    console.log("Name, Helper: "+helperNombre);    
  };
  const handleValidationPrecio = (e) => {
    setPrecio(e.target.value);
    const reg = new RegExp("^[0-9]{1,10}(.[0-9]{1,2})?$");
    if (! reg.test(e.target.value)) {
      setHelperPrecio('Entrada inválida para "Precio"');
    } else {
      setHelperPrecio(' ');
    }
    setErrorPrecio(!reg.test(e.target.value));

    console.log("Precio, Error: "+errorPrecio);
    console.log("Precio, Helper: "+helperPrecio); 
  };


  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h2 className="head_title">Agregar videojuego</h2>
    </div>


    <div className='panel-videoAdd'>
      <div className='box-videoAdd'>

        <Box component="form" noValidate autoComplete="off" >  
                  {/*
                  sx={{ width: '100%',
                  boxShadow: 4,
                  border: 2,
                  borderColor: 'primary.light',
                  '& .MuiDataGrid-cell:hover': {
                    color: 'primary.main',
                  },
                  
                }} */}
          <Grid container spacing={2}>
            <Grid xs={12}>
                <TextField  
                  error={errorNombre} 
                  required 
                  id="nombre" 
                  label="Nombre" 
                  variant="standard"
                  type= 'text'    
                  sx={{ width: '500px' }}  
                  helperText={helperNombre}
                  value={nombre}
                  onChange={(e) => handleValidationNombre(e)}
                />
            </Grid>
            <Grid xs={12} >
                <TextField  
                  error={errorPrecio} 
                  required 
                  id="precio" 
                  label="Precio" 
                  variant="standard"   
                  type= 'text' 
                  sx={{ width: '100px' }}  
                  helperText={helperPrecio}
                  value={precio}
                  onChange={(e) => handleValidationPrecio(e)}
                  />
            </Grid>
            <Grid xs={12} >
              <span className='label-field'>
                Calificación
              </span>
              <Rating
                name="calificacion"
                value={calificacion}
                precision={1}
                // sx={{ m: 1, width: '300px' }}  
                getLabelText={getLabelText}
                onChange={(event, newValue) => { setCalificacion(newValue); }}
                onChangeActive={(event, newHover) => { setHover(newHover); }}
                emptyIcon={<StarIcon style={{ opacity: 0.55 }} fontSize="inherit" />}
              />
                {calificacion !== null && (
                    <Box sx={{ ml: 0 }}>{labels[hover !== -1 ? hover : calificacion]}</Box>
                )}

            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"  onClick={(e) =>props.navigate(Config.URL_APP+'/')}>Volver a List</Button>
              {/* <Button variant="outlined" type='reset'>Restaurar Valores</Button> */}
          </Stack>
          {
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>

          }
        </Box>
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter( VideoAdd);