import React from 'react';

import Config from '../config';
import VideoList from '../videoList';
import VideoAdd from '../videoAdd';
import VideoEdit from '../videoEdit';
import NotFound from '../notFound';


import { Routes, Route } from "react-router-dom";

class Router extends React.Component{
    constructor(props){
        super(props);
        this.state={
            logado: false,
            username: '',
        }
    }

    render()
    {
        return (
            <>
                <Routes>
                    <Route
                        path={`${Config.URL_APP}/`}
                        element={<VideoList />} />
                    <Route
                        path={`${Config.URL_APP}/VideoAdd`}
                        element={<VideoAdd />} />
                    <Route path={`${Config.URL_APP}/VideoEdit/:id`}
                        element={<VideoEdit />} />
                    <Route
                        path="*"
                        element={<NotFound />} />
                </Routes>
            </>
        );
    }
}
export default Router;