import * as React from 'react';
import './style.css';

import {
  DataGrid,
  // GridToolbarContainer,
  GridActionsCellItem,
  GridToolbar,
} from '@mui/x-data-grid';

// import Box from '@mui/material/Box';
import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
import EditIcon from '@mui/icons-material/Edit';

// import SaveIcon from '@mui/icons-material/Save';
// import CancelIcon from '@mui/icons-material/Close';

import DeleteIcon from '@mui/icons-material/Delete';

import Rating from '@mui/material/Rating';
// import Typography from '@mui/material/Typography';
// import { toast } from 'react-toastify';
import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';

import {useEffect} from 'react';

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

const currencyFormatter = new Intl.NumberFormat('es-ES', {
  style: 'currency',
  currency: 'EUR',
});

function renderRating(params) {
  return <Rating readOnly value={params.value} />;
}

function  VideosList(props) {
  
  const [rows, setRows] = React.useState(null);
  const [refresh, setRefresh] = React.useState(true);

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => { 
      if (refresh ) {
        fetch(`${Config.RUTA_API}/list`)
        .then((response) => response.json())
        .then(data =>{
            setRows(data);
            setRefresh(false);
            console.log("I have been mounted");
          }) 
        .catch(err => {
          console.log(err);
          // return {} //(or [], or an empty return, or any return at all)
          })
      }
    }, [refresh]);


  const deleteRow = React.useCallback(
    (id) => () => {
      console.log("Registro a eliminar: ",id);

      const row = rows.find((rowid) => rowid.id === id);

      console.log("Datos del registro seleccionado: ",row);

      const text = `¿Eliminar registro: ${row.nombre} ?`; // ${row.nombre}

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        text: text,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {
            console.log("Comfirmed OK",response);

            const options = {
              method: "POST",
              mode: "no-cors",
              headers: {
                  "Content-Type": "application/json", 
                  "charset": "utf-8"
              },
              body: JSON.stringify(
                {}
              )
            };

            fetch(`${Config.RUTA_API}/delete/${id}`,options)  // Delete Rown in Server
            .then((response) => response.text())
            .then(data =>{
              setRows((prevRows) => prevRows.filter((row) => row.id !== id));
              console.log("Delete row ID: ",id);

              MySwal.fire({
                icon: 'info',
                title: 'Record delete!!!!',
                text: '',
                timer: 1000,
                timerProgressBar: true,
                toast: true,
                position: "center",
                footer: ''
               })
              }) 
            .catch(err => {
              console.log('Error in Server: ',err);
              setRefresh(true);  // Reload Data from Server
              })
            
          } else {
            console.log("Comfirmed KO",response);
          }
        })
    },
    [rows],
  );

  const editRow = React.useCallback(
    (id) => () => {
      props.navigate(Config.URL_APP+"/VideoEdit/"+id);

      /*
      setRows((prevRows) =>
        prevRows.map((row) =>
          row.id === id ? { ...row, isAdmin: !row.isAdmin } : row,
        ),
      );
      */
    },
    [props],
  );


  const addRow = (event) => {
    props.navigate(Config.URL_APP+'/VideoAdd');
  };


  const columns = React.useMemo(
    () => [
      { field: 'id', type: 'number', width: 40}, 
      { field: 'nombre', headerName: 'Nombre', type: 'string', width: 300 }, 
      { field: 'precio', headerName: 'Precio', type: 'number',  valueFormatter: (value) => currencyFormatter.format(value),
        cellClassName: 'font-tabular-nums', width: 120 }, 
      { field: 'calificacion', headerName: 'Clasificación', type: 'string', width: 180, 
        renderCell: renderRating,
        sortable: false
      },
      {
        field: 'actions',
        headerName: 'Acciones',
        type: 'actions',
        width: 120,
        getActions: (params) => [
          <GridActionsCellItem
          icon={<EditIcon />}
          label="Edit"
          // className="textPrimary"
          onClick={editRow(params.id)}
          color="inherit"
        />,
          <GridActionsCellItem
            icon={<DeleteIcon />}
            label="Delete"
            // className="textPrimary"
            onClick={deleteRow(params.id)}
            color="inherit"
          />,

        ],
      },
    ],
    [deleteRow, editRow],
  );

  const [rowSelectionModel, setRowSelectionModel] = React.useState([]);


  return (
    <>
    <Nav />
    <div className='titlePage'>
            <h2 className="head_title">Listado de Videojuegos</h2>
    </div>
    <ThemeProvider theme={theme}>

    <div className='titleButtons' >
      <Button color="primary" startIcon={<AddIcon />} onClick={(event) => addRow(event)}>
          Add record
      </Button>
    </div>

        <div className='panel'>
          <div className='box-videoList'>

          <DataGrid autoHeight columns={columns} rows={rows}
                        initialState={{
                          pagination: {
                            paginationModel: { page: 0, pageSize: 5 },
                          },
                        }}
                        pageSizeOptions={[5, 10, 15, 20]}
                        
                        localeText={{
                          MuiTablePagination: {
                            labelDisplayedRows: ({ from, to, count }) =>
                              `${from} - ${to} de ${count === -1 ? `mayor qué ${to}` : count}`,
                          },
                        }}
                        /*
                        sx={{
                          boxShadow: 4,
                          border: 2,
                          borderColor: 'primary.light',
                          '& .MuiDataGrid-cell:hover': {
                            color: 'primary.main',
                          },
                        }}
                          */
                        enableRowNumbers
                        slots={{
                          toolbar: GridToolbar,
                        }}
                        onRowSelectionModelChange={(newRowSelectionModel) => {
                          setRowSelectionModel(newRowSelectionModel);
                          console.log(newRowSelectionModel);
                        }}
                        rowSelectionModel={rowSelectionModel}
                      />
          </div>  
        </div>
        
      </ThemeProvider>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( VideosList );