import React from "react";
import { Navigate, Outlet } from "react-router-dom";
import { useAuth } from "../hooks/AuthProvider";
import Config from '../components/config';

const PrivateRoute = () => {
  const user = useAuth();
  const urlLogin = Config.URL_APP+"/login";
  if (!user.token) return <Navigate to={urlLogin} />;
  return <Outlet />;
};

export default PrivateRoute;
