import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import EditIcon from '@mui/icons-material/Edit';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';
// import Rating from '@mui/material/Rating';
// import Typography from '@mui/material/Typography';
// import StarIcon from '@mui/icons-material/Star';

import { Select, MenuItem, InputLabel } from '@mui/material';

// import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';
import { useParams } from "react-router-dom";

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function UserConnect(props) {


  const [refresh, setRefresh] = useState(true);

  const auth = useAuth();
 
  const [in_login, setIn_login] = useState('');
  const [in_nombre, setIn_nombre] = useState('');
  const [in_email, setIn_email] = useState('');


  // const { id } = useParams()                                        // Parámetro con el "id" de XXXXXXXXX

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);

  // Notificación error grave
    function errorNotification(code, message) {
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }

    // Cargar los datos del Server cuando se carga y recarga la página
    const fetchUser = async () =>
    {
      if (refresh) {        // Para intentar que sólo sea una vez
        setRefresh(false);

        const url = Config.RUTA_API + "/userConnect" 
        // console.log("Valor de URL: ",url);
        const formData = new FormData();
        const config = {
          headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "token-user": auth.token
          },
        };
        try {  
          const response = await axios.post(url,formData,config) 
         
              var data = response.data;
              var datos = response.data.data;
              // console.log("Respuesta del fetch(uer): ",data);
              // console.log("Respuesta del fetch(user/Datos): ",datos);
  
              setIn_login(datos.Login);
              setIn_nombre(datos.NombreyApellidos);
              setIn_email(datos.email);

              if (data.error === true )  { 
                console.log("Hay un error: ",data.message);
                errorNotification(data.error,data.message);
              }
                
            }
          catch(error) {
              console.log("Error get User", error);
              errorNotification('000',error);
            }
      }
    };

    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      // console.log("Ejecutándose 'useEffect");

      fetchUser();
       }, [refresh]);

  // LogOut
  const Logout = (e) => { 
    
    // auth.LogOut(); // Cierre de sessión

    props.navigate(Config.URL_APP+'/logout');
  };


  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h3 className="head_title">Datos del ususario conectado</h3>
    </div>
    <div className='panel-compraView'>
      <div className='box-compraView'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
          <Grid xs={12}>
            <TextField  
                  required={true}
                  id="login"
                  name="login" 
                  label="Login" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                 
                  value={in_login || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  />           
            </Grid>
            <Grid xs={12} >
                <TextField  
                  required={true}
                  id="nombre"
                  name="nombre" 
                  label="Nombre" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  value={in_nombre || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  />
            </Grid>
            <Grid xs={12} >
                <TextField  
                  required={true}
                  id="email"
                  name="email" 
                  label="Email" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  value={in_email || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  />
            </Grid>
            
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained"  onClick={(e) =>Logout()}>Cerrar sesión</Button>
          </Stack>
        </Box>
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(UserConnect);