import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import ReplySharpIcon from '@mui/icons-material/ReplySharp';

// import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);


function UserAdd(props) {

  const auth = useAuth();

  // console.log("Grupo al que está identificado: ",auth.groupName);
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
    id: "",
    nombre: "",
    email: ''

  });
  const [row, setRow] = useState([]);  // Para validación de usuarios

  const [errorEmail, setErrorEmail] = useState(false);
  const [helperEmail, setHelperEmail] = useState('');

  // Notificación error grave
    function errorNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }


  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutando 'useEffect() en userAdd", auth);

  }, [auth]);


 
     // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
  
    if (input.email === '' || errorEmail ) {
      setHelperEmail('Hay que facilitar un Email Válido');
      setErrorEmail(true);
      existeError = true;
      Error += ' (Email) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/user/add/0";
      const formData = new FormData();
        formData.append('id', row.id);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {
            
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Record: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Record: ", error); 
          errorNotification('000', error)
        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Nuevo Grupo creado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })

    props.navigate(Config.URL_APP+'/userList');
  }

  const handleValidationEmail = (e) => {
    const { name, value } = e.target;

    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^[a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*@[a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,5}$");
    if (! reg.test(e.target.value)) {
      setHelperEmail('Entrada inválida para "Email"');
    } else {
      setHelperEmail('');
    }
    setErrorEmail(!reg.test(e.target.value));

    if ( reg.test(e.target.value)) {
    // si está bien formado hay que verificar que existe en Base de datos

    const url = Config.RUTA_API + "/userSearchEmail";
    const formData = new FormData();
      formData.append('email', value);
    const config = {
      headers: {
          "Content-Type": "application/x-www-form-urlencoded",
          "token-user": auth.token
      },
    };
    axios.post(url, formData, config)

      .then((response) => {
        const res = response.data;
        // console.log("Respuesta del fetch: ",res);
        if (res.error === true) {
          setHelperEmail(res.message);
          setErrorEmail(true);
        } else {
          setRow(res.data);
          setHelperEmail('Email Verificado!!!');
          setErrorEmail(false);
        }
      })
      .catch((error) => {
        console.error("Error send Record: ", error);
        setValidacionForms(false); 
        setErrorForms("Error send Record: ", error); 
        errorNotification('000', error)
      });
    }
  
  };
  
  return (
    <>
    <Nav />
    <div className='titlePage'>
        <h3 className="head_title">Alta de usuario al grupo: {localStorage.getItem("listaCompra")} </h3>
    </div>
    <ThemeProvider theme={theme}>
    <div className='panel-compraAdd'>
      <div className='box-compraAdd'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
            <Grid xs={12}>
              <TextField  
                  error={errorEmail} 
                  required={true}
                  id="email"
                  name="email" 
                  label="Email" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperEmail}
                  value={input.email }
                  onChange={(e) => handleValidationEmail(e)}
                  />
            </Grid>

          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"  startIcon={<ReplySharpIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/userList')}>Volver</Button> 
          </Stack>
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
        </Box>
      </div>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter( UserAdd);