import * as React from 'react';
import {useState} from 'react';
import './style.css';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

// import Swal from 'sweetalert2'
// import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import { useNavigate } from 'react-router-dom';

import { useAuth } from "../../hooks/AuthProvider";

import Leyenda from '../leyenda';
import Nav2 from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function Login(props) {
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
    username: "",
    password: "",
  });

  const [errorUsername, setErrorUsername] = useState(false);
  const [helperUsername, setHelperUsername] = useState('');

  const [errorPassword, setErrorPassword] = useState(false);
  const [helperPassword, setHelperPassword] = useState('');

  
  const auth = useAuth();
  // console.log("Función AUTH: ",auth);

  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
   
      const reg1 = new RegExp("^([0-9a-zA-Z]){5,16}$");
      if (! reg1.test(input.username)) {
        setHelperUsername('Número de caracterestes incorrecto');
        setErrorUsername(true);
        existeError = true;
        Error += ' (Username) ';
      }
      //const reg2 = new RegExp('^(?=\\w*\\d)(?=\\w*[A-Z])(?=\\w*[a-z])\\S{8,16}$');
      const reg2 = new RegExp('^([0-9a-zA-Z@#$%&]){5,16}$');
      if (! reg2.test(input.password)) {
        setHelperPassword('No se ajusta a las reglas de Password');
        setErrorPassword(true);
        existeError = true;
        Error += ' (Password) ';
      }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/login";
      const formData = new FormData();
        formData.append('login', input.username);
        formData.append('password', input.password);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {
            // console.log("Login a guardar: ",input.username);
            auth.loginAction( input.username,res.token); // Cacheo de datos de autenticación
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
  
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Login: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Login: ", error); 

        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario
      
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {

    // console.log("Iniciando en postSave()");

    props.navigate(Config.URL_APP+'/selectgroup');
  }

  const handleValidationUsername = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^([0-9a-zA-Z]){0,16}$");
    if (! reg.test(e.target.value)) {
      setHelperUsername('Entrada inválida para "Username"');
    } else {
      setHelperUsername('');
    }
    setErrorUsername(!reg.test(e.target.value)); 
  };

  const handleValidationPassword = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));

    // const reg = new RegExp('^(?=\\w*\\d)(?=\\w*[A-Z])(?=\\w*[a-z])\\S{8,16}$');
    const reg = new RegExp("^([0-9a-zA-Z@#$%&]){0,16}$");
    if (! reg.test(e.target.value)) {
      setHelperPassword('Entrada inválida para "Password"');
    } else {
      setHelperPassword('');
    }
    setErrorPassword(!reg.test(e.target.value));
  };


  return (
    <>
    <Nav2 /> 
    <div className='titlePage'>
        <h3 className="head_title">Identificación del Usuario</h3>
    </div>


    <div className='panel-login'>
      <div className='box-login'>

        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2} >
            <Grid xs={12}>
                <TextField  
                  error={errorUsername} 
                  required 
                  id="username" 
                  name="username"
                  label="User Name" 
                  variant="standard"
                  type= 'text'    
                  className= 'CustomField'  
                  helperText={helperUsername}
                  value={input.username}
                  onChange={(e) => handleValidationUsername(e)}
                />
            </Grid>
            <Grid xs={12} >
                <TextField  
                  error={errorPassword} 
                  required 
                  id="password"
                  name="password" 
                  label="Password" 
                  variant="standard"   
                  type= 'password' 
                  className= 'CustomField' 
                  helperText={helperPassword}
                  value={input.password}
                  onChange={(e) => handleValidationPassword(e)}
                  />
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"  onClick={(e) =>props.navigate(Config.URL_APP+'/register')}>Nuevo Usuario</Button>
          </Stack>
          {
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
          }
        </Box>
      </div>
    </div>
    <div className='panel-leyenda1'>
      <div className='panel-leyenda2'>
        <Leyenda />
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(Login);