import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import EditIcon from '@mui/icons-material/Edit';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';
// import Rating from '@mui/material/Rating';
// import Typography from '@mui/material/Typography';
// import StarIcon from '@mui/icons-material/Star';

import { Select, MenuItem, InputLabel } from '@mui/material';

// import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';
import { useParams } from "react-router-dom";

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function ProductoView(props) {


  const [unidad, setUnidad] = useState([
    {
      "idct_unidad": 0,
      "Titulo": ""
    }
  ]);
  const [producto, setProducto] = useState(
    {

    }
  );
  const [refresh, setRefresh] = useState(true);

  const auth = useAuth();
 
  const [in_producto, setIn_producto] = useState('');
  const [in_cantidad, setIn_cantidad] = useState('');
  const [in_unidad, setIn_unidad] = useState('');


  const { id } = useParams()                                        // Parámetro con el "id" de la Compra

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);
  
  // const auth = useAuth();
  // console.log("Función AUTH: ",auth);

  // Notificación error grave
    function errorNotification(code, message) {
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }

    function renderFoto() {
      if (producto.foto !== null ) {
        var imagen= Config.URL_FILES+producto.foto;
        // console.log("URL de la imagen: ", imagen);
        return (<div> <img className="imageProducto" src={imagen} alt="imagen de Producto" /> </div>)
    }
    }

    // Cargar los datos del Server cuando se carga y recarga la página
    const fetchProducto = async () =>
    {
      if (refresh) {        // Para intentar que sólo sea una vez
        setRefresh(false);

        // fetchProductos();
        fetchUnidades();

        const url = Config.RUTA_API + "/producto/view/"+id; 
        // console.log("Valor de URL: ",url);
        const formData = new FormData();
        const config = {
          headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "token-user": auth.token
          },
        };
        try {  
          const response = await axios.post(url,formData,config) 
         
              var data = response.data;
              var datos = response.data.data;
              // console.log("Respuesta del fetch(compra): ",data);
              // console.log("Respuesta del fetch(compra/Datos): ",datos);
  
              setProducto(datos);
              // console.log("Valor de 'compra':",compras);
              setIn_producto(datos.Nombre);
              setIn_cantidad(datos.Cantidad);
              setIn_unidad(datos.ct_unidad_idct_unidad);
              // console.log("valor de 'in_producto':",in_producto);
              // console.log("Valor de Data:",datos.Nombre);

              if (data.error === true )  { 
                console.log("Hay un error: ",data.message);
                errorNotification(data.error,data.message);
              }
                
            }
          catch(error) {
              console.log("Error get Producto", error);
              errorNotification('000',error);
            }
      }
    };

// Cargar los datos del Server cuando se carga y recarga la página
function fetchUnidades() 
{

  const url = Config.RUTA_API + "/listadoUnidades"; 
  const formData = new FormData();
  const config = {
    headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "token-user": auth.token
    },
  };

    axios.post(url,formData,config) 
    .then((response) => {       
        var data = response.data;
        // console.log("Respuesta del fetch(Unidades): ",data);
        setUnidad(data);

        if (data.error === true )  { 
          console.log("Hay un error: ",data.message);
          errorNotification(data.error,data.message);
        } else {
          // console.log("Registros de respuesta: ", data.length);
        }
          
      })
    .catch((error) => {
        console.log("Error get Listados Producto", error);
        errorNotification('000',error);
      })
};
    
    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      console.log("Ejecutándose 'useEffect");

      fetchProducto();
       }, [refresh]);


  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h3 className="head_title">Visualizar Producto</h3>
    </div>
    <div className='panel-compraView'>
      <div className='box-compraView'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
          <Grid xs={12}>
            <TextField  
                  required={true}
                  id="producto"
                  name="producto" 
                  label="Producto" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                 
                  value={in_producto || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  />           
            </Grid>

            <Grid xs={12} >
                <TextField  
                  required={true}
                  id="cantidad"
                  name="cantidad" 
                  label="Cantidad" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                 
                  value={in_cantidad || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  />
            </Grid>
            <Grid xs={12}>
                <InputLabel id="select-label">Unidad/Medida *</InputLabel>
                <Select 
                 
                  id="unidad" 
                  name="unidad"
                  label="Unidad" 
                  required={true}
                  variant="standard"   
                  className= 'CustomField'  
                  value={in_unidad || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                >
                {unidad.map((row, index) => (
                  <MenuItem key={row.idct_unidad}  value={row.idct_unidad}> {row.Titulo} 
                  </MenuItem> 
                ))}
                </Select>
            </Grid>
            <Grid xs={12}>
                <InputLabel id="select-label">Foto</InputLabel>
                {renderFoto()}
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained"  onClick={(e) =>props.navigate(Config.URL_APP+'/productoList')}>Volver</Button>
              <Button variant="outlined" startIcon={<EditIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/productoEdit/'+id)}>Editar</Button>
          </Stack>
        </Box>
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(ProductoView);