import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import AddIcon from '@mui/icons-material/Add';
// import EditIcon from '@mui/icons-material/Edit';
// import CheckedIcon from '@mui/icons-material/ShoppingCart';
import FilterIcon from '@mui/icons-material/Search';
import ReplySharpIcon from '@mui/icons-material/ReplySharp';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';
// import Rating from '@mui/material/Rating';
// import Typography from '@mui/material/Typography';
// import StarIcon from '@mui/icons-material/Star';

import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';
import { useParams } from "react-router-dom";

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function CompraEdit(props) {

  const [rows, setRows] = useState([
    {
      "idct_producto": 0,
      "ct_grupo_idct_grupo": 0,
      "Nombre": "",
      "Cantidad": 0,
      "ct_unidad_idct_unidad": 0,
      "unidad": "",
      "Foto": "",
      "FechaUltCambio": "",
      "UsuarioUltCambio": 0
    }
  ]);

  const [unidad, setUnidad] = useState([
    {
      "idct_unidad": 0,
      "Titulo": ""
    }
  ]);
  const [compras, setCompras] = useState(
    {
      "id": 63,
      "ct_grupo_idct_grupo": 2,
      "ct_producto_idct_producto": 5,
      "Nombre": "Uvas",
      "Cantidad": 1,
      "ct_unidad_idct_unidad": 2,
      "Unidad": "Kilos",
      "foto": "../Documentos/Compra/c13adae72b76986b6bacb5931ffb4f27032f46f0827f4f4346a56bf0919c1d71_wh4wl2w3.jpg",
      "FechaUltCambio": "2024-03-31 20:51:56",
      "UsuarioUltCambio": 1,
      "LoginUltCambio": "admin",
      "Comprado": 0,
      "FechaComprado": null,
      "UsuarioComprado": null,
      "LoginComprado": null
    }
  );


  const [refresh, setRefresh] = useState(true);


  const auth = useAuth();
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

 
  const [in_producto, setIn_producto] = useState('');
  const [in_cantidad, setIn_cantidad] = useState('');
  const [in_unidad, setIn_unidad] = useState('');


  const [errorProducto, setErrorProducto] = useState(false);
  const [helperProducto, setHelperProducto] = useState('');

  const [errorCantidad, setErrorCantidad] = useState(false);
  const [helperCantidad, setHelperCantidad] = useState('');

  const [errorUnidad, setErrorUnidad] = useState(false);
  const [helperUnidad, setHelperUnidad] = useState('');

  const { id } = useParams()                                        // Parámetro con el "id" de la Compra

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);
  
  // const auth = useAuth();
  // console.log("Función AUTH: ",auth);

  // Notificación error grave
    function errorNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }

    // const sleep = ms => new Promise(r => setTimeout(r, ms));

    // Cargar los datos del Server cuando se carga y recarga la página
    const fetchCompra = async () =>
    {
      if (refresh) {        // Para intentar que sólo sea una vez
        setRefresh(false);

        fetchProductos();
        fetchUnidades();

        // await sleep(2000);

        const url = Config.RUTA_API + "/compra/view/"+id; 
        // console.log("Valor de URL: ",url);
        const formData = new FormData();
        const config = {
          headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "token-user": auth.token
          },
        };
        try {  
          const response = await axios.post(url,formData,config) 
         
              var data = response.data;
              var datos = response.data.data;
              // console.log("Respuesta del fetch(compra): ",data);
              // console.log("Respuesta del fetch(compra/Datos): ",datos);
  
              setCompras(datos);
              // console.log("Valor de 'compra':",compras);
              setIn_producto(datos.ct_producto_idct_producto);
              setIn_cantidad(datos.Cantidad);
              setIn_unidad(datos.ct_unidad_idct_unidad);
              // console.log("valor de 'in_producto':",in_producto);
              // console.log("Valor de Data:",datos.Nombre);

              if (data.error === true )  { 
                console.log("Hay un error: ",data.message);
                errorNotification(data.error,data.message);
              }
                
            }
          catch(error) {
              console.log("Error get Listados Producto", error);
              errorNotification('000',error);
            }
      }
    };

    // Cargar los datos del Server cuando se carga y recarga la página
    function fetchProductos()  
    {

      const url = Config.RUTA_API + "/listadoProductos"; 
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };
        axios.post(url,formData,config)
        .then((response) => {      
            var data = response.data;
            // console.log("Respuesta del fetch(Productos): ",data);


            if (data.error === true )  { 
              console.log("Hay un error: ",data.message);
              errorNotification(data.error,data.message);
            } else {
              setRows(data);
              // console.log("Registros de respuesta: ", data.length);
            }
              
          })
        .catch((error) => {
            console.log("Error get Listados Producto", error);
            errorNotification('000',error);
          })
    };

// Cargar los datos del Server cuando se carga y recarga la página
function fetchUnidades() 
{

  const url = Config.RUTA_API + "/listadoUnidades"; 
  const formData = new FormData();
  const config = {
    headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "token-user": auth.token
    },
  };

    axios.post(url,formData,config) 
    .then((response) => {       
        var data = response.data;
        // console.log("Respuesta del fetch(Unidades): ",data);
        setUnidad(data);

        if (data.error === true )  { 
          console.log("Hay un error: ",data.message);
          errorNotification(data.error,data.message);
        } else {
          // console.log("Registros de respuesta: ", data.length);
        }
          
      })
    .catch((error) => {
        console.log("Error get Listados Producto", error);
        errorNotification('000',error);
      })
};
    
  
    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      // console.log("Ejecutándose 'useEffect");

      fetchCompra();
       }, [refresh]);

  // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
  
    if (in_producto === '') {
      setHelperProducto('Hay que seleccionar un Producto');
      setErrorProducto(true);
      existeError = true;
      Error += ' (Producto) ';
    }
    if (in_cantidad === '') {
      setHelperCantidad('Hay indicar una Cantidad');
      setErrorCantidad(true);
      existeError = true;
      Error += ' (Cantidad) ';
    }
    if (in_unidad === '') {
      setHelperUnidad('Hay que informar de las unidades o medidas');
      setErrorUnidad(true);
      existeError = true;
      Error += ' (Unidad) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/compra/update/"+id;
      const formData = new FormData();
        formData.append('idct_producto', in_producto);
        formData.append('cantidad', in_cantidad);
        formData.append('unidad', in_unidad);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      }; 
      axios.post(url, formData, config)
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) { 
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Register: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Register: ", error); 
          errorNotification('000', error)
        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario 
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Producto de Lista actualizado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    props.navigate(Config.URL_APP+'/compraList');
  }

  const handleValidationProducto = (e) => {
    const { name, value } = e.target;

    const row = rows.find((rowid) => rowid.idct_producto === value);

    // console.log("Datos del Producto: ",row);
    setIn_producto(row.idct_producto);
    setIn_cantidad(row.Cantidad);
    setIn_unidad(row.ct_unidad_idct_unidad);    
  };

  const handleValidationCantidad = (e) => {
    const { name, value } = e.target;
    setIn_cantidad(value);

    // const reg = new RegExp("^[0-9]{1,10}(.[0-9]{1,3})?$");
    const reg = new RegExp("^[0-9]{1,10}$");
    if (! reg.test(e.target.value)) {
      setHelperCantidad('Entrada inválida para "Cantidad"');
    } else {
      setHelperCantidad('');
    }
    setErrorCantidad(!reg.test(e.target.value));
  };

  const handleValidationUnidad = (e) => {
    const { name, value } = e.target;
    setIn_unidad(value);    
  };

  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h3 className="head_title">Editar artículo de la lista</h3>
    </div>
    <div className='panel-compraAdd'>
      <div className='box-compraAdd'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
          <Grid xs={12}>
                <InputLabel id="select-label">Selecciona el Producto *</InputLabel>
                <Select 
                  error={errorProducto} 
                  id="producto" 
                  name="producto"
                  label="Producto" 
                  required={false}
                  variant="standard"   
                  className= 'CustomField'  
                  value={in_producto || ''}
                  onChange={handleValidationProducto}
                >
                {rows.map((row, index) => (
                  <MenuItem key={row.idct_producto}  value={row.idct_producto}> {row.Nombre} 
                  </MenuItem> 
                ))}
                </Select>
                {errorProducto && <FormHelperText>{helperProducto}</FormHelperText>}
            </Grid>

            <Grid xs={12} >
                <TextField  
                  error={errorCantidad} 
                  required={true}
                  id="cantidad"
                  name="cantidad" 
                  label="Cantidad" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperCantidad}
                  value={in_cantidad || ''}
                  onChange={(e) => handleValidationCantidad(e)}
                  />
            </Grid>
            <Grid xs={12}>
                <InputLabel id="select-label">Unidad/Medida *</InputLabel>
                <Select 
                  error={errorUnidad} 
                  id="unidad" 
                  name="unidad"
                  label="Unidad" 
                  required={true}
                  variant="standard"   
                  className= 'CustomField'  
                  value={in_unidad || ''}
                  onChange={handleValidationUnidad}
                >
                {unidad.map((row, index) => (
                  <MenuItem key={row.idct_unidad}  value={row.idct_unidad}> {row.Titulo} 
                  </MenuItem> 
                ))}
                </Select>
                {errorUnidad && <FormHelperText>{helperUnidad}</FormHelperText>}
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"  startIcon={<ReplySharpIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/compraList')}>Volver</Button> 
              <Button variant="outlined" startIcon={<FilterIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/compraView/'+id)}>Ver</Button>
          </Stack>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="outlined"  startIcon={<AddIcon />} onClick={(e) =>props.navigate(Config.URL_APP+'/productoList')}>Producto</Button>
          </Stack>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              
          </Stack>
          {
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
          }
        </Box>
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(CompraEdit);