import * as React from 'react';
import {useState} from 'react';
import './style.css';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import { useNavigate } from 'react-router-dom';

// import { useAuth } from "../../hooks/AuthProvider";

import Nav2 from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};


function Register(props) {
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
    username: "",
    password: "",
    password2: "",
    name: "",
    email: "",
  });

  const [errorUsername, setErrorUsername] = useState(false);
  const [helperUsername, setHelperUsername] = useState('');

  const [errorPassword, setErrorPassword] = useState(false);
  const [helperPassword, setHelperPassword] = useState('');

  const [errorPassword2, setErrorPassword2] = useState(false);
  const [helperPassword2, setHelperPassword2] = useState('');

  const [errorName, setErrorName] = useState(false);
  const [helperName, setHelperName] = useState('');

  const [errorEmail, setErrorEmail] = useState(false);
  const [helperEmail, setHelperEmail] = useState('');

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);
  
  // const auth = useAuth();
  // console.log("Función AUTH: ",auth);

  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
   
      const reg1 = new RegExp("^([0-9a-zA-Z]){5,16}$");
      if (! reg1.test(input.username)) {
        setHelperUsername('Número de caracterestes incorrecto');
        setErrorUsername(true);
        existeError = true;
        Error += ' (Username) ';
      }
      //const reg2 = new RegExp('^(?=\\w*\\d)(?=\\w*[A-Z])(?=\\w*[a-z])\\S{8,16}$');
      const reg2 = new RegExp('^([0-9a-zA-Z@#$%&]){5,16}$');
      if (! reg2.test(input.password)) {
        setHelperPassword('No se ajusta a las reglas de Password');
        setErrorPassword(true);
        existeError = true;
        Error += ' (Password) ';
      }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/register";
      const formData = new FormData();
        formData.append('login', input.username);
        formData.append('password', input.password);
        formData.append('nombre', input.name);
        formData.append('email', input.email);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {
            
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
  
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Register: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Register: ", error); 

        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario
      
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {

    // console.log("Iniciando en postSave()");

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Nuevo Usuario creado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    props.navigate(Config.URL_APP+'/login');
  }

  const handleValidationUsername = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^([0-9a-zA-Z]){0,16}$");
    if (! reg.test(e.target.value)) {
      setHelperUsername('Entrada inválida para "Username"');
    } else {
      setHelperUsername('');
    }
    setErrorUsername(!reg.test(e.target.value)); 
  };

  const handleValidationPassword = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));

    // const reg = new RegExp('^(?=\\w*\\d)(?=\\w*[A-Z])(?=\\w*[a-z])\\S{8,16}$');
    const reg = new RegExp("^([0-9a-zA-Z@#$%&]){0,16}$");
    if (! reg.test(e.target.value)) {
      setHelperPassword('Entrada inválida para "Password"');
      setErrorPassword(true);
    } else {
      setHelperPassword('');
      setErrorPassword(false);
    }
  };

  const handleValidationPassword2 = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));
    
    // const reg = new RegExp('^(?=\\w*\\d)(?=\\w*[A-Z])(?=\\w*[a-z])\\S{8,16}$');
    const reg = new RegExp("^([0-9a-zA-Z@#$%&]){0,16}$");
    if (! reg.test(e.target.value)) {
      setHelperPassword2('Entrada inválida para "Repetición Password"');
      setErrorPassword2(true);
    } else {
      setHelperPassword2('');
      setErrorPassword2(false);
    }
    var password = input.password;
    // console.log("Primera password: ",password);
    if (e.target.value !== password ) {
      setHelperPassword2('Las dos Password no son iguales');
      setErrorPassword2(true);
    }
  };

  const handleValidationName = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^([a-zA-Z áéíóúÁÉÍÓÚ ñÑ -]){0,40}$");
    if (! reg.test(e.target.value)) {
      setHelperName('Entrada inválida para "Nombre"');
    } else {
      setHelperName('');
    }
    setErrorName(!reg.test(e.target.value)); 
  };

  const handleValidationEmail = (e) => {

    const { name, value } = e.target;
    setInput((prev) => ({
      ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^[a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*@[a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,5}$");
    if (! reg.test(e.target.value)) {
      setHelperEmail('Entrada inválida para "Email"');
    } else {
      setHelperEmail('');
    }
    setErrorEmail(!reg.test(e.target.value)); 
  };


  return (
    <>
    <Nav2 /> 
    <div className='titlePage'>
        <h3 className="head_title">Crear Nuevo Usuario</h3>
    </div>


    <div className='panel-register'>
      <div className='box-register'>

        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
            <Grid xs={12}>
                <TextField  
                  error={errorUsername} 
                  required 
                  id="username" 
                  name="username"
                  label="User Name" 
                  variant="standard"
                  type= 'text'    
                  className= 'CustomField'  
                  helperText={helperUsername}
                  value={input.username}
                  onChange={(e) => handleValidationUsername(e)}
                />
            </Grid>
            <Grid xs={12} >
                <TextField  
                  error={errorPassword} 
                  required 
                  id="password"
                  name="password" 
                  label="Password" 
                  variant="standard"   
                  type= 'password' 
                  className= 'CustomField'  
                  helperText={helperPassword}
                  value={input.password}
                  onChange={(e) => handleValidationPassword(e)}
                  />
            </Grid>
            <Grid xs={12} >
                <TextField  
                  error={errorPassword2} 
                  required 
                  id="password2"
                  name="password2" 
                  label="Repetición de Password" 
                  variant="standard"   
                  type= 'password' 
                  className= 'CustomField'  
                  helperText={helperPassword2}
                  value={input.password2}
                  onChange={(e) => handleValidationPassword2(e)}
                  />
            </Grid>
            <Grid xs={12}>
                <TextField  
                  error={errorName} 
                  required 
                  id="name" 
                  name="name"
                  label="Nombre" 
                  variant="standard"
                  type= 'text'    
                  className= 'CustomField'  
                  helperText={helperName}
                  value={input.name}
                  onChange={(e) => handleValidationName(e)}
                />
            </Grid>
            <Grid xs={12}>
                <TextField  
                  error={errorEmail} 
                  required 
                  id="email" 
                  name="email"
                  label="Email" 
                  variant="standard"
                  type= 'text'    
                  className= 'CustomField'  
                  helperText={helperEmail}
                  value={input.email}
                  onChange={(e) => handleValidationEmail(e)}
                />
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
          </Stack>
          {
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>

          }
        </Box>
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(Register);