import React from "react";
import { Navigate, Outlet } from "react-router-dom";
import { useAuth } from "../hooks/AuthProvider";
import Config from '../components/config';

const AdminRoute = () => {
  const user = useAuth();
  const url = Config.URL_APP+"/compraList";
  if (user.adminGroup === null) return <Navigate to={url} />;
  return <Outlet />;
};

export default AdminRoute;
