import * as React from 'react';
import './style.css';

import {
  DataGrid,
  GridToolbarContainer,
  GridToolbarColumnsButton,
  GridToolbarFilterButton,
  GridToolbarDensitySelector,
  GridToolbarExport,
  GridActionsCellItem,
  // GridToolbar,
} from '@mui/x-data-grid';

// import Box from '@mui/material/Box';
import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
import EditIcon from '@mui/icons-material/Edit';
import CheckedIcon from '@mui/icons-material/ShoppingCart';
import FilterIcon from '@mui/icons-material/Search';
import CachedIcon from '@mui/icons-material/Cached';

// import SaveIcon from '@mui/icons-material/Save';
// import CancelIcon from '@mui/icons-material/Close';

import DeleteIcon from '@mui/icons-material/Delete';

// import Rating from '@mui/material/Rating';
// import Typography from '@mui/material/Typography';
// import { toast } from 'react-toastify';
import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";
import {useEffect, useState} from 'react';

// import { esES } from '@mui/material/locale';
import { esES } from '@mui/x-data-grid/locales';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
// import Logo from '../logo';
import Config from '../config';


const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function renderFoto(params) {
  if (params.value !== null ) {
    var imagen= Config.URL_FILES+params.value;
    // console.log("URL de la imagen: ", imagen);
  return (<div> <img src={imagen} alt="imagen de Compra" width="72"  /> </div>)
}
}


function  CompraList(props) {

  const [rows, setRows] = useState(null);
  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);

  const auth = useAuth();

  // console.log("Usuario conectado: ",auth.user);
  // console.log("Usuario Administrador",auth.adminGroup);

  // Notificación error grave
  function errorNotification(code, message) {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    props.navigate(Config.URL_APP+'/logout');
  }

   // Para la primera carga, tomar la lista de Producctos que corresponde
  const getSituacion = () => {                 
    if ( localStorage.getItem("situacionLista") === null ) {
      localStorage.setItem("situacionLista",'pendientes'); // Si no existe
    }
    var situacionLista = localStorage.getItem("situacionLista");
    var situaciones = ['pendientes','hoy','comprados']; // Posibles botones
   if (! (situaciones.includes(situacionLista))) {  //true o false si existe o no
      localStorage.setItem("situacionLista",'pendientes');
   }
  }

  // Cargar los datos del Server cuando se carga y recarga la página
  const fetchCompra = async () => {
    // console.log("Valor de la variable Refresh: ",refresh);
    if (refresh) {        // Para intentar que sólo sea una vez
      setRefresh(false);

      var formWitdh = window.innerWidth;
      // console.log("Ancho de pantalla: ",formWitdh);
      if (formWitdh < 768 ) {
        setIsMobile(true);
        console.log("Configuarado para Móvil ");
      }

      getSituacion();     // Para saber la opción de acceso
      var situacion = localStorage.getItem("situacionLista");
      const url = Config.RUTA_API + "/listadoCompra/" + situacion;
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };
      try {  
        const response = await axios.post(url,formData,config)     
            var data = response.data;
            // console.log("Respuesta del fetch: ",data);
            setRows(data);
            
            if (data.error === true )  { 
              console.log("Hay un error: ",data.message);
              errorNotification(data.error, data.message);
            } else {
              // console.log("Registros de respuesta: ", data.length);
            }
              
          }
      catch(error) {
            console.error("Error get Lista Compra ", error);
            errorNotification('000', error);
          }
    }
  };
  

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    console.log("Ejecutándose 'useEffect");
    fetchCompra();
     }, [refresh ]);


  const deleteRow = React.useCallback((id) => () => 
    {
      // console.log("Registro a eliminar: ",id);

      const row = rows.find((rowid) => rowid.id === id);

      const text = `¿Eliminar registro de: ${row.Nombre} ?`; // ${row.nombre}
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        text: text,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {
            // console.log("Comfirmed OK",response);

             // Acceso al server y status de la operación
            const url = Config.RUTA_API + "/compra/delete/"+id;
            const formData = new FormData();
            const config = {
              headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "token-user": auth.token
                },
              };  
            axios.post(url, formData, config)
        
              .then((response) => {
                const res = response.data;
                // console.log("Respuesta del fetch: ",res);
                if (res.error === false) {
                    setRows((prevRows) => prevRows.filter((row) => row.id !== id));
                    // console.log("Delete row ID: ",id);
      
                    MySwal.fire({
                      icon: 'info',
                      title: 'Producto eliminado!!!!',
                      text: '',
                      timer: 1000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                  } else {
                    MySwal.fire({
                      icon: 'error',
                      title: res.message,
                      text: '',
                      timer: 3000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                }
              })
            .catch((error) => {
              console.error("Error delete Producto: ", error);
              setRefresh(true);  // Reload Data from Server
            })
          }
        })
    },
    [rows, auth.token],
  );

  // Comprar o descomprar roducto 
  const checkRow = React.useCallback((id) => () => 
    {
      const row = rows.find((rowid) => rowid.id === id);
      setRows((prevRows) => prevRows.filter((row) => row.id !== id));
      // console.log("Datos del registro seleccionado: ",row);

      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/compra/check/"+id;
      const formData = new FormData();
      const config = {
        headers: {
          "Content-Type": "application/x-www-form-urlencoded",
          "token-user": auth.token
          },
        };  
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {
              // console.log("Check row ID: ",id);
          }  
        })
      .catch((error) => {
        console.error("Error check Producto: ", error);
        setRefresh(true);  // Reload Data from Server
      })
    },
    [rows,auth.token],
  );

  const editRow = React.useCallback(
    (id) => () => {
      props.navigate(Config.URL_APP+"/compraEdit/"+id);

    },
    [props],
  );


  const addRow = (event) => {
    props.navigate(Config.URL_APP+'/compraAdd');
  };

  function CustomToolbar() {
    return (

      <GridToolbarContainer>
        <GridToolbarColumnsButton />
        <GridToolbarFilterButton />
        { isMobile ? '' 
          : <GridToolbarDensitySelector /> 
        }
        <GridToolbarExport />
      </GridToolbarContainer>
    );
  }


  const columns = React.useMemo(
    () => [
      {
        field: 'actions',
        hideable: false,
        headerName: 'Acciones',
        type: 'actions',
        flex: 1,
        minWidth: 100,
        getActions: (params) => [
          <GridActionsCellItem
            icon={<CheckedIcon />}
            label="Comprar"
            // className="textPrimary"
            onClick={checkRow(params.id)}
            color="inherit"
          />,
            <GridActionsCellItem
            icon={<EditIcon />}
            label="Edit"
            // className="textPrimary"
            onClick={editRow(params.id)}
            color="inherit"
          />,
          <GridActionsCellItem
            icon={<DeleteIcon />}
            label="Delete"
            // className="textPrimary"
            onClick={deleteRow(params.id)}
            color="inherit"
          />,
        ],
      },
      //  { field: 'id', type: 'number', width: 40}, 
      { field: 'Nombre', hideable: false, headerName: 'Nombre', type: 'string', flex: 2
        //, minWidth: 100, maxWidth: 250 
        }, 
      { field: 'Cantidad', headerName: 'Cantidad', type: 'number', flex: 1 },
      { field: 'Unidad', headerName: 'Unidad', type: 'string', Flex: 1 },
      { field: 'foto' , headerName: 'Foto', type: 'string', renderCell: renderFoto, sortable: false, flex:0.8 },
      { field: 'Comprado', headerName: 'Comprado', type: 'boolean', flex:0.5 },

    ],
    [deleteRow, editRow, checkRow],
  );

  const [rowSelectionModel, setRowSelectionModel] = React.useState([]); // Para control del registro seleccionado en el GRID

  // Cambio de la Lista de Productos.
  const changeList = (param) => {
    localStorage.setItem("situacionLista",param);
    setRefresh('true');
  }

  return (
    <>
    <Nav />
    <div className='titlePage'>
            <h3 className="head_title">Compras de {localStorage.getItem("listaCompra")} </h3>
    </div>
    <ThemeProvider theme={theme}>

      <div className='titleButtons' >
        <Button className="buttonTab" color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
        <Button className="buttonTab" color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
      </div>
      <div className='titleButtons' >
        {localStorage.getItem("situacionLista") === 'pendientes' ?
        <Button className="buttonTab" color="secondary" variant="contained" startIcon={<FilterIcon />} onClick={(event) => changeList('pendientes')}>
            Pendientes
        </Button>
        :
        <Button className="buttonTab" color="secondary" variant="outlined" startIcon={<FilterIcon />} onClick={(event) => changeList('pendientes')}>
            Pendientes
        </Button>}
        <span>&nbsp;</span>
        {localStorage.getItem("situacionLista") === 'hoy'?
        <Button className="buttonTab" color="secondary" variant="contained" startIcon={<FilterIcon />} onClick={(event) => changeList('hoy')}>
            Hoy
        </Button>
        :
        <Button className="buttonTab" color="secondary" variant="outlined" startIcon={<FilterIcon />} onClick={(event) => changeList('hoy')}>
            Hoy
        </Button>}
        <span>&nbsp;</span>
        {localStorage.getItem("situacionLista") === 'comprados'?
        <Button className="buttonTab" color="secondary" variant="contained" startIcon={<FilterIcon />} onClick={(event) => changeList('comprados')}>
            Comprados
        </Button>
        :
        <Button className="buttonTab" color="secondary" variant="outlined" startIcon={<FilterIcon />} onClick={(event) => changeList('comprados')}>
            Comprados
        </Button>}
      </div>
        <div className='panel'>
          <div className='box-compraList'>

          { isMobile ?
          <DataGrid
            columns={columns} 
            rows={rows}  
            initialState={{
              pagination: {
                paginationModel: { page: 0, pageSize: 100 },
              },
              columns: { 
                columnVisibilityModel: {
                  foto: false,
                  Comprado: false,
                },
              },
              }}
              pageSizeOptions={[5, 10, 15, 20, 100]}
              enableRowNumbers
              slots={{
                toolbar: CustomToolbar,
              }}
              onRowSelectionModelChange={(newRowSelectionModel) => {
                // Aquí el control del registro seleccionado. 
                setRowSelectionModel(newRowSelectionModel);
                // console.log(newRowSelectionModel);
                const idSelected = newRowSelectionModel[0];
                props.navigate(Config.URL_APP+'/compraView/'+idSelected);

              }}
              rowSelectionModel={rowSelectionModel}
            />
            : ''}
            {! isMobile ?
            <DataGrid autoHeight columns={columns} rows={rows}
              initialState={{
                pagination: {
                  paginationModel: { page: 0, pageSize: 100 },
                },
                columns: { 
                  columnVisibilityModel: {
                  },
                },
              }}
              pageSizeOptions={[5, 10, 15, 20, 100]}
              enableRowNumbers
              slots={{
                toolbar: CustomToolbar,
              }}
              onRowSelectionModelChange={(newRowSelectionModel) => {
                // Aquí el control del registro seleccionado. 
                setRowSelectionModel(newRowSelectionModel);
                // console.log(newRowSelectionModel);
                const idSelected = newRowSelectionModel[0];
                props.navigate(Config.URL_APP+'/compraView/'+idSelected);

              }}
              rowSelectionModel={rowSelectionModel}
            />
            : ''}
          </div>  
        </div>
        
      </ThemeProvider>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( CompraList );