import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import ReplySharpIcon from '@mui/icons-material/ReplySharp';

// import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);


function GrupoAdd(props) {

  const auth = useAuth();

  // console.log("Grupo al que está identificado: ",auth.groupName);
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
    grupo: "",
    descripcion: ""
  });

  const [errorGrupo, setErrorGrupo] = useState(false);
  const [helperGrupo, setHelperGrupo] = useState('');

  const [errorDescripcion, setErrorDescripcion] = useState(false);
  const [helperDescripcion, setHelperDescripcion] = useState('');

  const [menu, setMenu] = useState(false);

  // Notificación error grave
    function errorNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }


  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutando 'useEffect() en grupoAdd", auth);
    if (auth.groupName === null) {
      setMenu(false);
    } else {
      setMenu(true);
    }
  }, [auth]);


     // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
  
    if (input.grupo === '' || errorGrupo ) {
      setHelperGrupo('Hay que facilitar un Grupo Válido');
      setErrorGrupo(true);
      existeError = true;
      Error += ' (Grupo) ';
    }

    if ( errorDescripcion ) {
      setHelperDescripcion('Hay que facilitar una Descripción Válida');
      setErrorDescripcion(true);
      existeError = true;
      Error += ' (Descripción) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/grupo/add/0";
      const formData = new FormData();
        formData.append('Nombre', input.grupo);
        formData.append('Descripcion', input.descripcion);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };
      
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {
            
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
  
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Register: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Register: ", error); 
          errorNotification('000', error)

        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario
      
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Nuevo Grupo creado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    if (auth.groupName === null ) {
        props.navigate(Config.URL_APP+'/selectgroup');
    } else {
        props.navigate(Config.URL_APP+'/grupoList');
    }
  }

  const handleValidationGrupo = (e) => {
    const { name, value } = e.target;
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^([a-zA-Z0-9_áéíóúüñÑ -]){3,50}$");
    if (! reg.test(e.target.value)) {
      setHelperGrupo('Entrada inválida para "Nombre de grupo"');
    } else {
      setHelperGrupo('');
    }
    setErrorGrupo(!reg.test(e.target.value));
  };

  const handleValidationDescripcion = (e) => {
    const { name, value } = e.target;
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^([a-zA-Z0-9_áéíóúüñÑ, -]){0,200}$");
    if (! reg.test(e.target.value)) {
      setHelperDescripcion('Entrada inválida para "Descripción"');
    } else {
      setHelperDescripcion('');
    }
    setErrorDescripcion(!reg.test(e.target.value));
  };

  
  return (
    <>
    <Nav />
    <div className='titlePage'>
        <h3 className="head_title">Añadir Grupo</h3>
    </div>
    <ThemeProvider theme={theme}>
    <div className='panel-compraAdd'>
      <div className='box-compraAdd'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
            <Grid xs={12}>
              <TextField  
                  error={errorGrupo} 
                  required={false}
                  id="grupo"
                  name="grupo" 
                  label="Grupo" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperGrupo}
                  value={input.grupo }
                  onChange={(e) => handleValidationGrupo(e)}
                  />
            </Grid>
            <Grid xs={12}>
              <TextField  
                  error={errorDescripcion} 
                  required={false}
                  id="descripcion"
                  name="descripcion" 
                  label="Descripcion" 
                  variant="standard" 
                  type= 'text' 
                  multiline
                  maxRows={4}
                  className= 'CustomField'  
                  helperText={helperDescripcion}
                  value={input.Descripcion }
                  onChange={(e) => handleValidationDescripcion(e)}
                  />
            </Grid>

          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              {menu?
              <Button variant="outlined"  startIcon={<ReplySharpIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/grupoList')}>Volver</Button> 
              :''}
          </Stack>
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
        </Box>
      </div>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter( GrupoAdd);