import * as React from 'react';
import './style.css';

import {
  DataGrid,
  GridToolbarContainer,
  GridToolbarColumnsButton,
  GridToolbarFilterButton,
  GridToolbarDensitySelector,
  GridToolbarExport,
  GridActionsCellItem,
  // GridToolbar,
} from '@mui/x-data-grid';

// import Box from '@mui/material/Box';
import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
import EditIcon from '@mui/icons-material/Edit';
// import CheckedIcon from '@mui/icons-material/ShoppingCart';
// import FilterIcon from '@mui/icons-material/Search';
import CachedIcon from '@mui/icons-material/Cached';

import DeleteIcon from '@mui/icons-material/Delete';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";
import {useEffect, useState} from 'react';

// import { esES } from '@mui/material/locale';
import { esES } from '@mui/x-data-grid/locales';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';


const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function  GrupoList(props) {
 
  const [rows, setRows] = useState(null);

  // const [users, setUsers] = useState(null);  // API  /usersGroupList
  
  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);

  const auth = useAuth();

  // Notificación error grave
  function errorNotification(code, message) {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    props.navigate(Config.URL_APP+'/logout');
  }

  // Cargar los datos del Server cuando se carga y recarga la página
  const fetchGrupo= async () => {
    // console.log("Valor de la variable Refresh: ",refresh);
    if (refresh) {        // Para intentar que sólo sea una vez
      setRefresh(false);

      var formWitdh = window.innerWidth;
      // console.log("Ancho de pantalla: ",formWitdh);
      if (formWitdh < 768) {
        setIsMobile(true);
        // console.log("Configuarado para móvil ");
      }

      const url = Config.RUTA_API + "/grupoList";
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };
      try {  
        const response = await axios.post(url,formData,config)     
            var data = response.data;
            // console.log("Respuesta del fetch: ",data);
            
            if (data.error === true )  { 
              console.log("Hay un error: ",data.message);
              errorNotification(data.error, data.message);
            } else {
              setRows(data);
            }
              
          }
      catch(error) {
            console.error("Error get Lista Grupos ", error);
            errorNotification('000', error);
          }
    }
  };
  

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutándose 'useEffect");
    fetchGrupo();
     }, [refresh]);


  const deleteRow = React.useCallback((id) => () => 
    {
      // console.log("Registro a eliminar: ",id);

      const row = rows.find((rowid) => rowid.id === id);

      var msg = '';
      if (row.Login === null ) {
        msg = `¿<b>Te quieres dar de baja</b> <br>del Grupo: ${row.Nombre} ?`;
      } else {
        msg = `¿Quieres <b>ELIMINAR el Grupo:</b> ${row.Nombre}? <br><br><b>TODA LA INFORMACIÓN ASOCIADA (Lista, Productos, Usuarios del Grupo) será Eliminada</b>`;
      }
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        html: msg,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {
            // console.log("Comfirmed OK",response);

             // Acceso al server y status de la operación
            const url = Config.RUTA_API + "/grupo/delete/"+id;
            const formData = new FormData();
            const config = {
              headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "token-user": auth.token
                },
              };  
            axios.post(url, formData, config)
        
              .then((response) => {
                const res = response.data;
                // console.log("Respuesta del fetch: ",res);
                if (res.error === false) {
                    setRows((prevRows) => prevRows.filter((row) => row.id !== id));
                    // console.log("Delete row ID: ",id);
      
                    MySwal.fire({
                      icon: 'info',
                      title: 'Grupo eliminado!!!!',
                      text: '',
                      timer: 1000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                    if ( row.Nombre === auth.groupName ) { // Si ha eliminado del grupo al que está conectado
                      props.navigate(Config.URL_APP+'/logout');
                    }
                  } else {
                    errorNotification(res.code, res.message);
                }
              })
            .catch((error) => {
              console.error("Error delete Grupo: ", error);
              setRefresh(true);  // Reload Data from Server
            })
          }
        })
    },
    [rows, auth.token],
  );

 
  const editRow = React.useCallback(
    (id) => () => {
      const row = rows.find((rowid) => rowid.id === id);
     
      if (row.Login === null) {  // No es administrador del Grupo y no puede modificar
        const text = `<p>¡¡¡ No eres administrador de: <b> ${row.Nombre}</b> !!!</p><p><b>No puedes modificar el Grupo.</b></p>`; // ${row.nombre}
        const MySwal = withReactContent(Swal); 
        MySwal.fire({
          title: "<h3>Acción no se puede ejecutar</h3>",
          icon: "info",
          html: text,
          showCloseButton: true,
          showCancelButton: false,
          focusConfirm: false,
          closeButtonText: 'OK',
          // confirmButtonAriaLabel: "Thumbs up, great!",
          // cancelButtonText: `<i class="fa fa-thumbs-down"></i>`,
          // cancelButtonAriaLabel: "Thumbs down"
        });
      } else {
        props.navigate(Config.URL_APP+'/grupoEdit/'+id);
      }

    },
    [rows],
  );


  const addRow = (event) => {
    props.navigate(Config.URL_APP+'/grupoAdd');
  };

  function CustomToolbar() {
    return (

      <GridToolbarContainer>
        <GridToolbarColumnsButton />
        <GridToolbarFilterButton />
        { isMobile ? '' 
          : <GridToolbarDensitySelector /> 
        }
        <GridToolbarExport />
      </GridToolbarContainer>
    );
  }

  const isRowEditable = (row) => {
    // console.log(" Datos del registro: ",row);
    if (row.Login === null) {
      return false
    } else {
      return true
    }
  }

  const columns = React.useMemo(
    () => [
      {
        field: 'actions',
        hideable: false,
        headerName: 'Acciones',
        type: 'actions',
        minWidth: 75,
        getActions: ({ id, row }) => {
          if (isRowEditable(row)) {
            return [
                <GridActionsCellItem
                  icon={<EditIcon />}
                  label="Edit"
                  // className="textPrimary"
                  onClick={editRow(id)}
                  color="inherit"
                />,
                <GridActionsCellItem
                icon={<DeleteIcon />}
                label="Delete"
                // className="textPrimary"
                onClick={deleteRow(id)}
                color="inherit"
              />,
            ];
          } else {
            return[
              <GridActionsCellItem
              icon={<DeleteIcon />}
              label="Delete"
              // className="textPrimary"
              onClick={deleteRow(id)}
              color="inherit"
            />,
          ]}
        }

      },
      //  { field: 'groupId', type: 'number', width: 40}, 
      { field: 'Nombre', hideable: false, headerName: 'Nombre', type: 'string', minWidth: 200 }, 
      { field: 'NombreUsuario', headerName: 'Administrador', type: 'string', minWidth: 200 },
    ],
    [deleteRow, editRow],
  );


  return (
    <>
    <Nav />
    <div className='titlePage'>
            <h3 className="head_title">Estos son tus Grupos / Listas de Compra </h3>
    </div>
    <ThemeProvider theme={theme}>


      <div className='titleButtons' >
        <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
        <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>
            Nuevo
        </Button>
      </div>

        <div className='panel'>
          <div className='box-compraList'>
           <DataGrid  columns={columns} rows={rows}
              initialState={{
                pagination: {
                  paginationModel: { page: 0, pageSize: 100 },
                },
                columns: {
                  columnVisibilityModel: {

                  },
                },
              }}
              autosizeOptions={{
                columns: ['Nombre', 'Login'],
                includeOutliers: true,
                includeHeaders: true,
              }}
              pageSizeOptions={[5, 10, 15, 20, 100]}
              // enableRowNumbers
              slots={{
                toolbar: CustomToolbar,
              }}

            />
          </div>  
        </div>
        
      </ThemeProvider>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( GrupoList );