import * as React from 'react';
import {useEffect, useState} from 'react';

import { useNavigate } from 'react-router-dom';
import { useAuth } from "../../hooks/AuthProvider";
import axios from 'axios';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import Config from '../config';

const withRouter = (Component) => {
    const Wrapper = (props) => {
      const navigate = useNavigate();
      return <Component navigate={navigate} {...props} />;
    };
    return Wrapper;
  };

  function Logout(props) {

    const [refresh, setRefresh] = useState(true);

    const auth = useAuth();
    // const navigate = useNavigate();

        // Notificación error grave
        function errorNotification(code, message) {
          const MySwal = withReactContent(Swal); 
          MySwal.fire({
            icon: 'error',
            title: message,
            text: '',
            timer: 5000,
            timerProgressBar: true,
            toast: true,
            position: "center",
            footer: ''
          })
          props.navigate(Config.URL_APP+'/login');
        }

    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      console.log("Ejecutándose 'useEffect' en Logout");

      // setRefresh(false);

      const url = Config.RUTA_API + "/logout"; 
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
           },
      };

      axios.post(url,formData,config) 
      .then((response) => {       
          var data = response;

          if (data.error === true )  { 
            console.log("Hay un error: ",data.message);
            errorNotification(data.error,data.message);
          } else {
            auth.logOut(); // Cierre sesión
            props.navigate(Config.URL_APP+'/login');
          }
            
        })
      .catch((error) => {
          console.log("Error get Listados Producto", error);
          errorNotification('000',error);
        })
    
      }, [refresh,auth]);

    return (
      <>
      </>
    );
}
// IMPORTANT ----------------------------------------
export default withRouter(Logout);

