import * as React from 'react';
import Card from '@mui/material/Card';
import CardActions from '@mui/material/CardActions';
import CardContent from '@mui/material/CardContent';
import CardMedia from '@mui/material/CardMedia';
import Button from '@mui/material/Button';
import DeleteIcon from '@mui/icons-material/Delete';
import EditIcon from '@mui/icons-material/Edit';
import CheckedIcon from '@mui/icons-material/ShoppingCart';


import Typography from '@mui/material/Typography';

import Config from '../config';

function renderFoto(params) {
  if (params !== null ) {
    var imagen= Config.URL_FILES+params;
    // console.log("URL de la imagen: ", imagen);
  // return (<div> <img src={imagen} alt="imagen de Compra" width="72"  /> </div>)
  return (imagen)
  }
}

export default function viewItem({item, onButtonClick}) {
  // console.log("Valores de Item: ",item);
  const imageItem = renderFoto(item.foto2);

  const handleButtonClick = (id, action) => {
    // Lógica cuando se hace clic en un botón dentro de Detalle
    //   console.log("Se ha pulsado un botón, id: "+ id, action);
    onButtonClick(id,action);
  };

  return (
    <div className='box-item' >
    <Card>
      <CardContent>
        <Typography gutterBottom variant="h5" sx={{ width: 331, display: 'block' }}>
          {item.Nombre}
        </Typography>
        <Typography variant="body2" sx={{ color: 'text.secondary', display: 'inline' }}>
          <Typography variant="subtitle2"  sx={{ display: 'inline' }}>Cantidad: </Typography>
          {item.Cantidad} {item.Unidad}
        </Typography>
      </CardContent>
      { (item.foto2 !== null ) ?
        <CardMedia
        sx={{ height: 224 }}
        image = {imageItem}
      />
      : ''}
      <CardActions>
        <Button size="small" variant="outlined" startIcon={<CheckedIcon/>} onClick={(event) => handleButtonClick(item.id,'comprar')}>Comprar</Button>
        <Button size="small" variant="outlined" startIcon={<EditIcon/>} onClick={(event) => handleButtonClick(item.id,'editar')} >Editar</Button>
        <Button size="small" variant="outlined" startIcon={<DeleteIcon/>} onClick={(event) => handleButtonClick(item.id,'eliminar')} >Borrar</Button>
      </CardActions>
    </Card>
    </div>
  );
}
