import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import AddIcon from '@mui/icons-material/Add';
// import EditIcon from '@mui/icons-material/Edit';
// import CheckedIcon from '@mui/icons-material/ShoppingCart';
import FilterIcon from '@mui/icons-material/Search';
import ReplySharpIcon from '@mui/icons-material/ReplySharp';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';
// import FormGroup from '@mui/material/FormGroup';
// import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';

// ++++++++++++++++++++++++++++++++++++ FILE ++++++++++++++++++++++++++++++++
import { styled } from '@mui/material/styles';
import CloudUploadIcon from '@mui/icons-material/CloudUpload';
// ++++++++++++++++++++++++++++++++++++ FILE ++++++++++++++++++++++++++++++++

import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';
import { useParams } from "react-router-dom";

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

// ++++++++++++++++++++++++++++++++++ File ++++++++++++++++++++++++++++++
const VisuallyHiddenInput = styled('input')({
  clip: 'rect(0 0 0 0)',
  clipPath: 'inset(50%)',
  height: 1,
  overflow: 'hidden',
  position: 'absolute',
  bottom: 0,
  left: 0,
  whiteSpace: 'nowrap',
  width: 1,
});
// ++++++++++++++++++++++++++++++++++ File ++++++++++++++++++++++++++++++

function ProductoEdit(props) {

  const [unidad, setUnidad] = useState([
    {
      "idct_unidad": 0,
      "Titulo": ""
    }
  ]);
 
  const [producto, setProducto] = useState(
    {

    }
  );

  const [refresh, setRefresh] = useState(true);


  const auth = useAuth();
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

 
  const [in_producto, setIn_producto] = useState('');
  const [in_cantidad, setIn_cantidad] = useState('');
  const [in_unidad, setIn_unidad] = useState('');
  const [in_deleteFoto, setIn_deleteFoto] = useState(false);


  const [errorProducto, setErrorProducto] = useState(false);
  const [helperProducto, setHelperProducto] = useState('');

  const [errorCantidad, setErrorCantidad] = useState(false);
  const [helperCantidad, setHelperCantidad] = useState('');

  const [errorUnidad, setErrorUnidad] = useState(false);
  const [helperUnidad, setHelperUnidad] = useState('');

    // ++++++++++++++++++++++++++++++++++ File ++++++++++++++++++++++++++++++
    const [file, setFile] = useState();
    const [uploadedFile, setUploadedFile] = useState();
    const [errorFile, setErrorFile] = useState(false);
    const [helperFile, setHelperFile] = useState('');
    // ++++++++++++++++++++++++++++++++++ File ++++++++++++++++++++++++++++++

  const { id } = useParams()                                        // Parámetro con el "id" de la Compra

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);
  
  // const auth = useAuth();
  // console.log("Función AUTH: ",auth);

  // Notificación error grave
    function errorNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }

    
function renderFoto() {
  if (producto.foto !== null ) {
    var imagen= Config.URL_FILES+producto.foto;
    // console.log("URL de la imagen: ", imagen);
  return (<div> <img className="imageProducto" src={imagen} alt="imagen de Producto" /> </div>)
}
}


    // const sleep = ms => new Promise(r => setTimeout(r, ms));

    // Cargar los datos del Server cuando se carga y recarga la página
    const fetchProducto = async () =>
    {
      if (refresh) {        // Para intentar que sólo sea una vez
        setRefresh(false);

        fetchUnidades();

        const url = Config.RUTA_API + "/producto/view/"+id; 
        // console.log("Valor de URL: ",url);
        const formData = new FormData();
        const config = {
          headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "token-user": auth.token
          },
        };
        try {  
          const response = await axios.post(url,formData,config) 
         
              var data = response.data;
              var datos = response.data.data;
              // console.log("Respuesta del fetch(compra): ",data);
              // console.log("Respuesta del fetch(compra/Datos): ",datos);
  
              setProducto(datos);
              // console.log("Valor de 'compra':",compras);
              setIn_producto(datos.Nombre);
              setIn_cantidad(datos.Cantidad);
              setIn_unidad(datos.ct_unidad_idct_unidad);
              // console.log("valor de 'in_producto':",in_producto);
              // console.log("Valor de Data:",datos.Nombre);

              if (data.error === true )  { 
                console.log("Hay un error: ",data.message);
                errorNotification(data.error,data.message);
              }
                
            }
          catch(error) {
              console.log("Error get Listados Producto", error);
              errorNotification('000',error);
            }
      }
    };

// Cargar los datos del Server cuando se carga y recarga la página
function fetchUnidades() 
{

  const url = Config.RUTA_API + "/listadoUnidades"; 
  const formData = new FormData();
  const config = {
    headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "token-user": auth.token
    },
  };

    axios.post(url,formData,config) 
    .then((response) => {       
        var data = response.data;
        // console.log("Respuesta del fetch(Unidades): ",data);
        setUnidad(data);

        if (data.error === true )  { 
          console.log("Hay un error: ",data.message);
          errorNotification(data.error,data.message);
        } else {
          // console.log("Registros de respuesta: ", data.length);
        }
          
      })
    .catch((error) => {
        console.log("Error get Unidades", error);
        errorNotification('000',error);
      })
};
    
  
    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      console.log("Ejecutándose 'useEffect");

      fetchProducto();
       }, [refresh]);

  // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
  
    if (in_producto === '') {
      setHelperProducto('Hay que seleccionar un Producto');
      setErrorProducto(true);
      existeError = true;
      Error += ' (Producto) ';
    }
    if (in_cantidad === '') {
      setHelperCantidad('Hay indicar una Cantidad');
      setErrorCantidad(true);
      existeError = true;
      Error += ' (Cantidad) ';
    }
    if (in_unidad === '') {
      setHelperUnidad('Hay que informar de las unidades o medidas');
      setErrorUnidad(true);
      existeError = true;
      Error += ' (Unidad) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/producto/update/"+id;
      const formData = new FormData();
        formData.append('Nombre', in_producto);
        formData.append('cantidad', in_cantidad);
        formData.append('unidad', in_unidad);
        formData.append('deletefoto', in_deleteFoto);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      }; 
      axios.post(url, formData, config)
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) { 
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Register: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Register: ", error); 
          errorNotification('000', error)
        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario 
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Producto actualizado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    props.navigate(Config.URL_APP+'/productoList');
  }

  const handleValidationCantidad = (e) => {

    const { name, value } = e.target;

      setIn_cantidad(value);

      // const reg = new RegExp("^[0-9]{1,10}(.[0-9]{1,3})?$");
      const reg = new RegExp("^[0-9]{1,10}$");
      if (! reg.test(e.target.value)) {
        setHelperCantidad('Entrada inválida para "Cantidad"');
      } else {
        setHelperCantidad('');
      }
      setErrorCantidad(!reg.test(e.target.value));

  };

  const handleValidationProducto = (e) => {
    const { name, value } = e.target;
    setIn_producto(value);

    //  var regxp = /^([a-zA-Z0-9_-áéíóúñÑ]){3,60}$/;
    const reg = new RegExp("^([a-zA-Z0-9_áéíóúüñÑ -]){3,60}$");
    if (! reg.test(e.target.value)) {
      setHelperProducto('Entrada inválida para "Nombre de producto"');
    } else {
      setHelperProducto('');
    }
    setErrorProducto(!reg.test(e.target.value));
  };

  const handleValidationUnidad = (e) => {
    const { name, value } = e.target;
    setIn_unidad(value);    
  };

  const handleChangeDeleteFoto = (e) => {
    // const { name, value } = e.target;
    // console.log("Valor de check: ",e.target.checked);
    setIn_deleteFoto(e.target.checked);
  };


  // ++++++++++++++++++++++++++++++++++++ File +++++++++++++++++++++++++++++++++
  function handleChangeFile(event) {
    var file = event.target.files[0];
    // console.log("datos del fichero subido: ",file);
    if ( file.type === 'image/jpeg' || file.type === 'image/png' ) { // ¿Es una imagen ?
      handleSubmitFile(event);
      setErrorForms("");
      setValidacionForms(true);
    } else {
      setErrorFile(true);
      const textError = "Sólo se admiten ficheros JPEG y PNG";
      setHelperFile(textError);
      setErrorForms(textError);
      setValidacionForms(false);
    }
  }
  
  function handleSubmitFile(event) {
    event.preventDefault();
    setFile(event.target.files[0]);
    const file = event.target.files[0];
    // console.log("datos del fichero subido: ",event.target.files[0]);

    const url = Config.RUTA_API + "/image/add";
    const formData = new FormData();
    formData.append('file', file);
    formData.append('filename', file.name);
    const config = {
      headers: {
        'content-type': 'multipart/form-data',
        "token-user": auth.token
      },
    };
    axios.post(url, formData, config)
      .then((response) => {
        // console.log("Respuesta del Ajax de image/add: ",response.data);
        setUploadedFile(response.data.filename);
        setErrorFile(true);
        setHelperFile("Se ha guardado el fichero: "+response.data.filename);
      })
      .catch((error) => {
        console.error("Error uploading file: ", error);
        setErrorFile(true);
        setHelperFile(error);
      });
  }
  // ++++++++++++++++++++++++++++++++++++ File +++++++++++++++++++++++++++++++++

  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h3 className="head_title">Editar Producto</h3>
    </div>
    <div className='panel-compraAdd'>
      <div className='box-compraAdd'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
          <Grid xs={12}>
              <TextField  
                  error={errorProducto} 
                  required={true}
                  id="producto"
                  name="producto" 
                  label="Nombre" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperProducto}
                  value={in_producto || ''}
                  onChange={(e) => handleValidationProducto(e)}
                  />

            </Grid>
            <Grid xs={12} >
                <TextField  
                  error={errorCantidad} 
                  required={true}
                  id="cantidad"
                  name="cantidad" 
                  label="Cantidad" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperCantidad}
                  value={in_cantidad || ''}
                  onChange={(e) => handleValidationCantidad(e)}
                  />
            </Grid>
            <Grid xs={12}>
                <InputLabel id="select-label">Unidad/Medida *</InputLabel>
                <Select 
                  error={errorUnidad} 
                  id="unidad" 
                  name="unidad"
                  label="Unidad" 
                  required={true}
                  variant="standard"   
                  className= 'CustomField'  
                  value={in_unidad || ''}
                  onChange={handleValidationUnidad}
                >
                {unidad.map((row, index) => (
                  <MenuItem key={row.idct_unidad}  value={row.idct_unidad}> {row.Titulo} 
                  </MenuItem> 
                ))}
                </Select>
                {errorUnidad && <FormHelperText>{helperUnidad}</FormHelperText>}
            </Grid>
            <Grid xs={12}>
                <InputLabel id="select-label">Foto</InputLabel>
                {renderFoto()}
            </Grid>
            <Grid xs={12}>
            <Checkbox
                // checked={in_deleteFoto}
                onChange={handleChangeDeleteFoto}
                inputProps={{ 'aria-label': 'controlled' }}
              /> Eliminar Foto?
            </Grid>
          </Grid>
            <Grid container spacing={2}>
            <Grid xs={12}>
              <Button
                component="label"
                role={undefined}
                variant="contained"
                tabIndex={-1}
                startIcon={<CloudUploadIcon />}
              >
                Upload Imagen (jpeg o png)
                <VisuallyHiddenInput
                  type="file"
                  onChange={(event) => {
                      // console.log(event.target.files);
                      handleChangeFile(event);}}
                  // multiple
                />
              </Button>
              {errorFile && <FormHelperText>{helperFile}</FormHelperText>}
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"  startIcon={<ReplySharpIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/productoList')}>Volver</Button> 
              <Button variant="outlined" startIcon={<FilterIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/productoView/'+id)}>Ver</Button>
          </Stack>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              
          </Stack>
          {
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
          }
        </Box>
      </div>
    </div>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(ProductoEdit);