import * as React from 'react';
import {useState} from 'react';
import './style.css';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
// import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import { useNavigate } from 'react-router-dom';

import { useAuth } from "../../hooks/AuthProvider";

import {useEffect} from 'react';
import Nav from '../nav';
import Config from '../config';


const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};


function SelectGroup(props) {
  const [mostrarScreen, setMostrarScreen] = useState(false);

  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
      groupId: '',
      Nombre: '',
      Administrador: '',
      Login: ''
  });

  const [errorGroupid, setErrorGroupid] = useState(false);
  const [helperGroupid, setHelperGroupid] = useState('');

  const [groups, setGroups] = React.useState([{
    groupId: '',
    Nombre: '',
    Administrador: '',
    Login: '',
  }]);
  const [refresh, setRefresh] = React.useState(true);

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);
  
  const auth = useAuth();

  // Notificación error grave
  function errorNotification(code, message) {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    props.navigate(Config.URL_APP+'/logout');
  }

    // Notificación No tiene Grupo asignado
    function noGrupoNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 10000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/grupoAdd');
    }

  // Acceso a los datos del LOOKUP de Grupos
  const fetchGroup = async () => {
    // console.log("Valor de la variable Refresh: ",refresh);
    localStorage.removeItem("listaCompra"); // Eliminar, si existe, el nombre de la Lista
    if (refresh) {                          // Para intentar que sólo sea una vez
      setRefresh(false);
      const url = Config.RUTA_API + "/listGroup";
      const config = {
        headers: {
            "Content-Type": "application/json",
            "token-user": auth.token
        },
      };
      try {  
        const response = await axios.get(url, config)     
            var data = response.data;
            // console.log("Respuesta del fetch: ",data);
            if (data.error === true )  { 
              if (data.message_num !== '011') {
                  errorNotification(data.code,data.message);
                } else {
                  // No tiene asignado grupo de Compra
                  noGrupoNotification(data.code,data.message);
                }
            } else {
              setGroups(data);
              if (data.length === 1 ) {
                var row = data[0];
                // console.log("Datos de la única Lista: ",row);
                asigancionGupoAutomatico(row); // 
              } else {
                setMostrarScreen(true);   // Para que muestre pantalla de selección
              }   
            }
          }
      catch(error) {
            console.error("Error send Listado de Grupos: ", error);
            setValidacionForms(false); 
            setErrorForms("Error send Listado de Grupos: ", error); 
          }
    }
  };
  
  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    console.log("Ejecutándose 'useEffect");
    fetchGroup();
     }, []);

  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    // console.log("En 'saveForms, info de 'input':",input);
    if (input.groupId === '') {
      setValidacionForms(false); // No se ha introducido ningún valor
      setErrorForms('Es necesario fijar la Lista de Compra, con la que desea trabajar');
    }
    if (validacionForms) { // se han introducido los valores de los campos

      localStorage.setItem("listaCompra", input.Nombre);   // Guardamos el nombre para las demás pantallas

      auth.groupAction(input.Nombre,input.Login);     // Salva información del grupo

      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/selectGroup";
      const formData = new FormData();
        formData.append('grupo', input.groupId);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };     
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {           
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación 
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);
          }
        })
        .catch((error) => {
          console.error("Error send Seleción del Grupo: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Seleción del Grupo: ", error); 
        }); 
    } else {
      setErrorGroupid(true); // Ponemos error en el campo de entrada
      setHelperGroupid("Es necesario seleccionar un valor");
    }
  };

  const postSave = (e) => {

    // console.log("Iniciando en postSave()");
    props.navigate(Config.URL_APP+'/compraList');
  }

  // Para el caso de que el ususario sólo tiene una lista de Compra disponible
  const asigancionGupoAutomatico= (row) =>{
    // console.log("Ejecutándose 'asigancionGupoAutomatico' !!!!", row);

    localStorage.setItem("listaCompra", row.Nombre);   // Guardamos el nombre para las demás pantallas
    
    auth.groupAction(row.Nombre,row.Login);     // Salva información del grupo
    
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Usuario se conecta a la lista: '+row.Nombre +'!!!!',
      text: '',
      timer: 3000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    props.navigate(Config.URL_APP+'/compraList');
  }


  const handleValidationGroupId = (e) => {
    // console.log("Datos del Select: ",e.target);
    // console.log("Datos del JSON: ",groups);
    // console.log("número de elementos de Groups: ",groups.length);
    var row = groups.find(p => p.groupId === e.target.value);
    // console.log("Registro seleccionado: ",row);
    setInput(row);
    // console.log("Valores de entrada: ",input);

  };

  // Renderizar de forma Condicional
  function renderContent() {
      if (mostrarScreen) { 
        // console.log ("muestra Pantalla Selección ",mostrarScreen);
        return (
          <>
            <div className='titlePage'>
                <h2 className="head_title">Seleccionar Grupo</h2>
            </div>

            <div className='panel-selectGroup'>
              <div className='box-selectGroup'>

                <Box component="form" noValidate autoComplete="off" >  
                  <Grid container spacing={2}>
                    <Grid xs={12}>
                        <InputLabel id="select-label">Selecciona el Grupo de la Compra *</InputLabel>
                        <Select 
                          error={errorGroupid} 
                          id="GroupId" 
                          name="GroupId"
                          label="Grupo de Compra" 
                          required={false}
                          variant="standard"   
                          className= 'CustomField'  
                          value={input.groupId}
                          onChange={handleValidationGroupId}
                        >
                        {groups.map((grupo, index) => (
                          <MenuItem key={grupo.groupId}  value={grupo.groupId}> {grupo.Nombre} 
                          </MenuItem> 
                        ))}
                        </Select>
                        {errorGroupid && <FormHelperText>{helperGroupid}</FormHelperText>}
                    </Grid>
                  </Grid>
                  <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
                    <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
                  </Stack>
                  {
                  <Stack sx={{ width: '100%' }} spacing={2}>
                    { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
                  </Stack>

                  }
                </Box>
              </div>
            </div>
          </>
        );
    } else {
        return (
          <>
            <p>Redireccionando automáticamente</p>
          </>
        );
    }
  }
  return (
    <>
     <Nav />
      {renderContent()}
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(SelectGroup);