import { useContext, createContext, useState } from "react";

const AuthContext = createContext();

const AuthProvider = ({ children }) => {

  const [user, setUser] = useState(localStorage.getItem("siteUser") || null);
  const [token, setToken] = useState(localStorage.getItem("site") || "");
  const [groupName, setGroupName] = useState(localStorage.getItem("siteGroup") || null);
  const [adminGroup, setAdminGroup] = useState(localStorage.getItem("siteAdmin") || null);

 

  const loginAction = (user,token) => {

      setUser(user);
      setToken(token);
      localStorage.setItem("site", token);  // si se quita, no se puede hacer "reload" de la página
      localStorage.setItem("siteUser", user);  // si se quita, no se puede hacer "reload" de la página

  };
  const groupAction = (group,admin) => {

    setGroupName(group);
    setAdminGroup(admin);
    localStorage.setItem("siteGroup", group);  // si se quita, no se puede hacer "reload" de la página
    localStorage.setItem("siteAdmin", admin);  // si se quita, no se puede hacer "reload" de la página
  };

  const logOut = () => {
    setUser(null);
    setToken("");
    setGroupName(null);
    setAdminGroup(null);

    localStorage.removeItem("site");
    localStorage.removeItem("siteUser");
    localStorage.removeItem("siteGroup");
    localStorage.removeItem("siteAdmin");

    localStorage.removeItem("listaCompra"); 
    localStorage.removeItem("situacionLista");


  };

  return (
    <AuthContext.Provider value={{ token, user, groupName, adminGroup, loginAction, logOut, groupAction  }}>
      {children}
    </AuthContext.Provider>
  );


};

export default AuthProvider;

export const useAuth = () => {
  return useContext(AuthContext);
};
