import { BrowserRouter as Router, Route, Routes } from "react-router-dom";
import * as React from 'react';

import Config from './components/config';
import Login from "./components/login";
import Logout from "./components/logout";
import Register from "./components/register";
import SelectGroup from "./components/selectGroup";
import CompraList from "./components/compraList";
import CompraAdd from "./components/compraAdd";
import CompraEdit from "./components/compraEdit";
import CompraView from "./components/compraView";
import ProductoList from "./components/productoList";
import ProductoAdd from "./components/productoAdd";
import ProductoEdit from "./components/productoEdit";
import ProductoView from "./components/productoView";
import GrupoList from "./components/grupoList";
import GrupoAdd from "./components/grupoAdd";
import GrupoEdit from "./components/grupoEdit";
import UserList from "./components/userList";
import UserAdd from "./components/userAdd";
import TestList from "./components/testList";

import UserConnect from "./components/userConnect";
import NotFound from "./components/notFound";
import AuthProvider from "./hooks/AuthProvider";

import PrivateRoute from "./router/route";
// import AdminRoute from "./router/routeAdmin";

function App() {

  return (
    <div className="App">
      <Router>
        <AuthProvider>
          <Routes>
            <Route path={`${Config.URL_APP}/`} element={<Login />} />
            <Route path={`${Config.URL_APP}/login`} element={<Login />} />
            <Route path={`${Config.URL_APP}/register`} element={<Register />} />
            <Route element={<PrivateRoute />}>
              <Route path={`${Config.URL_APP}/userconnect`} element={<UserConnect />} />
              <Route path={`${Config.URL_APP}/logout`} element={<Logout />} />
              <Route path={`${Config.URL_APP}/selectgroup`} element={<SelectGroup />} />   
              <Route path={`${Config.URL_APP}/compraList`} element={<CompraList />} />
              <Route path={`${Config.URL_APP}/compraAdd`} element={<CompraAdd />} />
              <Route path={`${Config.URL_APP}/compraEdit/:id`} element={<CompraEdit />} />
              <Route path={`${Config.URL_APP}/compraView/:id`} element={<CompraView />} />
              <Route path={`${Config.URL_APP}/productoList`} element={<ProductoList />} />
              <Route path={`${Config.URL_APP}/productoAdd`} element={<ProductoAdd />} />
              <Route path={`${Config.URL_APP}/productoEdit/:id`} element={<ProductoEdit />} />
              <Route path={`${Config.URL_APP}/productoView/:id`} element={<ProductoView />} />
              <Route path={`${Config.URL_APP}/grupoList`} element={<GrupoList />} />
              <Route path={`${Config.URL_APP}/grupoAdd`} element={<GrupoAdd />} />
              <Route path={`${Config.URL_APP}/grupoEdit/:id`} element={<GrupoEdit />} />
              <Route path={`${Config.URL_APP}/userList`} element={<UserList />} />

              <Route path={`${Config.URL_APP}/testList`} element={<TestList />} />

              if (auth.adminGroup !== null ) {  // Administrador del Grupo
                <Route path={`${Config.URL_APP}/userAdd`} element={<UserAdd />} />
              }
            </Route>
            {/* Other routes  */}
            <Route path="*" element={<NotFound />} />
           
          </Routes>
        </AuthProvider>
      </Router>
    </div>
  );
}

export default App;
