import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

// import { styled } from '@mui/material/styles';
import Grid from '@mui/material/Grid2';

import ReplySharpIcon from '@mui/icons-material/ReplySharp';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Alert from '@mui/material/Alert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";

import { useNavigate } from 'react-router-dom';
import { useParams } from "react-router-dom";

import Nav from '../nav';
import Config from '../config';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

function GrupoEdit(props) {

  const [users, setUsers] = useState([{
    idct_usuario: '',
    NombreyApellidos: ''
  }]);
 
  const [grupo, setGrupo] = useState(null);

  const [refresh, setRefresh] = useState(true);


  const auth = useAuth();
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [in_grupo, setIn_grupo] = useState('');
  const [in_administrador, setIn_administrador] = useState(null);

  const [errorGrupo, setErrorGrupo] = useState(false);
  const [helperGrupo, setHelperGrupo] = useState('');

  const [errorAdministrador, setErrorAdministrador] = useState(false);
  const [helperAdministrador, setHelperAdministrador] = useState('');

  const { id } = useParams()                                        // Parámetro con el "id" de la Compra

  // Notificación error grave
    function errorNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      props.navigate(Config.URL_APP+'/logout');
    }

    // const sleep = ms => new Promise(r => setTimeout(r, ms));

    // Cargar los datos del Server cuando se carga y recarga la página
    const fetchGrupo = async () =>
    {
      if (refresh) {        // Para intentar que sólo sea una vez
        setRefresh(false);

        fetchUsuarios();

        const url = Config.RUTA_API + "/grupo/view/"+id; 
        // console.log("Valor de URL: ",url);
        const formData = new FormData();
        const config = {
          headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "token-user": auth.token
          },
        };
        try {  
          const response = await axios.post(url,formData,config) 
         
              var data = response.data;
              var datos = response.data.data;
              console.log("Respuesta del fetch(compra): ",data);
              // console.log("Respuesta del fetch(compra/Datos): ",datos);
              if (data.error === true )  { 
                console.log("Hay un error: ",data.message);
                errorNotification(data.error,data.message);
              } else {
                setGrupo(datos);
                setIn_grupo(datos.Nombre);
                setIn_administrador(datos.Administrador);
              }
                
            }
          catch(error) {
              console.log("Error get View Grupo", error);
              errorNotification('000',error);
            }
      }
    };

// Cargar los datos del Server cuando se carga y recarga la página
function fetchUsuarios() 
{

  const url = Config.RUTA_API + "/usersGroupList"; 
  const formData = new FormData();
  const config = {
    headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "token-user": auth.token
    },
  };

    axios.post(url,formData,config) 
    .then((response) => {       
        var data = response.data;

        if (data.error === true )  { 
          console.log("Hay un error: ",data.message);
          errorNotification(data.error,data.message);
        } else {
          console.log("Usuarios del grupo: ",data)
          setUsers(data);
        }
          
      })
    .catch((error) => {
        console.log("Error get Usuarios", error);
        errorNotification('000',error);
      })
};
    
  
    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      console.log("Ejecutándose 'useEffect");

      fetchGrupo();
       }, [refresh]);

  // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
  
    if (in_grupo === '' || errorGrupo ) {
      setHelperGrupo('Hay que facilitar un Grupo Valido');
      setErrorGrupo(true);
      existeError = true;
      Error += ' (Grupo) ';
    }
    if (in_administrador === '') {
      setHelperAdministrador('Hay indicar un Administrador');
      setErrorAdministrador(true);
      existeError = true;
      Error += ' (Administrador) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");
      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/grupo/update/"+id;
      const formData = new FormData();
        formData.append('Nombre', in_grupo);
        formData.append('Administrador', in_administrador);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      }; 
      axios.post(url, formData, config)
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) { 
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Register: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Register: ", error); 
          errorNotification('000', error)
        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario 
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Grupo actualizado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })
    props.navigate(Config.URL_APP+'/grupoList');
  }

  const handleValidationAdministrador = (e) => {

    const { name, value } = e.target;

      setIn_administrador(value);
  };

  const handleValidationGrupo = (e) => {
    const { name, value } = e.target;
    setIn_grupo(value);

    //  var regxp = /^([a-zA-Z0-9_-áéíóúñÑ]){3,60}$/;
    const reg = new RegExp("^([a-zA-Z0-9_áéíóúüñÑ -]){3,50}$");
    if (! reg.test(e.target.value)) {
      setHelperGrupo('Entrada inválida para "Nombre de Grupo"');
    } else {
      setHelperGrupo('');
    }
    setErrorGrupo(!reg.test(e.target.value));
  };


  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h3 className="head_title">Editar Grupo</h3>
    </div>

    <ThemeProvider theme={theme}>
    <div className='panel-compraAdd'>
      <div className='box-compraAdd'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
          <Grid xs={12}>
              <TextField  
                  error={errorGrupo} 
                  required={true}
                  id="grupo"
                  name="grupo" 
                  label="Grupo" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperGrupo}
                  value={in_grupo || ''}
                  onChange={(e) => handleValidationGrupo(e)}
                  />

            </Grid>
            <Grid xs={12}>
                <InputLabel id="select-label">Administrador</InputLabel>
                <Select 
                  error={errorAdministrador} 
                  id="administrador" 
                  name="administrador"
                  label="Administrador" 
                  required={true}
                  variant="standard"   
                  className= 'CustomField'  
                  value={in_administrador || ''}
                  onChange={handleValidationAdministrador}
                >
                {users.map((row, index) => (
                  <MenuItem key={row.idct_usuario}  value={row.idct_usuario}> {row.NombreyApellidos} 
                  </MenuItem> 
                ))}
                </Select>
                {errorAdministrador && <FormHelperText>{helperAdministrador}</FormHelperText>}
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"  startIcon={<ReplySharpIcon />}  onClick={(e) =>props.navigate(Config.URL_APP+'/grupoList')}>Volver</Button> 
          </Stack>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              
          </Stack>
          {
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
          }
        </Box>
      </div>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(GrupoEdit);