import * as React from 'react';
import './style.css';

import {
  DataGrid,
  GridToolbarContainer,
  GridToolbarColumnsButton,
  GridToolbarFilterButton,
  GridToolbarDensitySelector,
  GridToolbarExport,
  GridActionsCellItem,
  // GridToolbar,
} from '@mui/x-data-grid';

// import Box from '@mui/material/Box';
import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
// import EditIcon from '@mui/icons-material/Edit';
// import CheckedIcon from '@mui/icons-material/ShoppingCart';
// import FilterIcon from '@mui/icons-material/Search';
import CachedIcon from '@mui/icons-material/Cached';

import DeleteIcon from '@mui/icons-material/Delete';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import axios from 'axios';
import { useAuth } from "../../hooks/AuthProvider";
import {useEffect, useState} from 'react';

// import { esES } from '@mui/material/locale';
import { esES } from '@mui/x-data-grid/locales';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';


const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function  UserList(props) {
 
  const [rows, setRows] = useState(null);

  // const [users, setUsers] = useState(null);  // API  /usersGroupList
  
  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);

  const auth = useAuth();
  // console.log("(userList) datos de autorizacion: ",auth);

  // Notificación error grave
  function errorNotification(code, message) {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    props.navigate(Config.URL_APP+'/logout');
  }

  // Cargar los datos del Server cuando se carga y recarga la página
  const fetchGrupo= async () => {
    // console.log("Valor de la variable Refresh: ",refresh);
    if (refresh) {        // Para intentar que sólo sea una vez
      setRefresh(false);

      var formWitdh = window.innerWidth;
      // console.log("Ancho de pantalla: ",formWitdh);
      if (formWitdh < 768) {
        setIsMobile(true);
        // console.log("Configuarado para móvil ");
      }

      const url = Config.RUTA_API + "/userList";
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "token-user": auth.token
        },
      };
      try {  
        const response = await axios.post(url,formData,config)     
            var data = response.data;
            // console.log("Respuesta del fetch: ",data);
            
            if (data.error === true )  { 
              console.log("Hay un error: ",data.message);
              errorNotification(data.error, data.message);
            } else {
              setRows(data);
            }
              
          }
      catch(error) {
            console.error("Error get Lista Grupos ", error);
            errorNotification('000', error);
          }
    }
  };
  

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutándose 'useEffect");
    fetchGrupo();
     }, [refresh]);


  const deleteRow = React.useCallback((id) => () => 
    {
      // console.log("Registro a eliminar: ",id);

      const row = rows.find((rowid) => rowid.id === id);

      const msg = `¿<b>Quieres dar de baja del Grupo <br>al usuario:</b>  ${row.NombreyApellidos} <b>?</b>`;

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        html: msg,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {
            // console.log("Comfirmed OK",response);

             // Acceso al server y status de la operación
            const url = Config.RUTA_API + "/user/delete/"+id;
            const formData = new FormData();
            const config = {
              headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "token-user": auth.token
                },
              };  
            axios.post(url, formData, config)
        
              .then((response) => {
                const res = response.data;
                // console.log("Respuesta del fetch: ",res);
                if (res.error === false) {
                    setRows((prevRows) => prevRows.filter((row) => row.id !== id));
                    // console.log("Delete row ID: ",id);
      
                    MySwal.fire({
                      icon: 'info',
                      title: 'Usuario eliminado del Grupo!!!!',
                      text: '',
                      timer: 1000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                } else {
                    errorNotification(res.code, res.message);
                }
              })
            .catch((error) => {
              console.error("Error delete Usuario: ", error);
              setRefresh(true);  // Reload Data from Server
            })
          }
        })
    },
    [rows, auth.token],
  );

 

  const addRow = (event) => {
    props.navigate(Config.URL_APP+'/userAdd');
  };


  function CustomToolbar() {
    return (

      <GridToolbarContainer>
        <GridToolbarColumnsButton />
        <GridToolbarFilterButton />
        { isMobile ? '' 
          : <GridToolbarDensitySelector /> 
        }
        <GridToolbarExport />
      </GridToolbarContainer>
    );
  }

  const isRowEditable = (row) => {
    // console.log(" Datos del registro: ",row);
    if (auth.adminGroup !== null && auth.user !== row.Login ) {
      return true 
    } else {
      return false
    }
  }

  const columns = React.useMemo(
    () => [
      {
        field: 'actions',
        hideable: false,
        headerName: 'Acción',
        type: 'actions',
        minWidth: 75,
        getActions: ({ id, row }) => {
          if (isRowEditable(row)) {
            return [
                <GridActionsCellItem
                icon={<DeleteIcon />}
                label="Delete"
                // className="textPrimary"
                onClick={deleteRow(id)}
                color="inherit"
              />,
            ];
          } else {
            return [

            ];
          }
        }

      },
      //  { field: 'groupId', type: 'number', width: 40}, 
      { field: 'NombreyApellidos', hideable: false, headerName: 'Nombre Usuario', type: 'string', minWidth: 200 }, 
      { field: 'email', headerName: 'Email', type: 'string', minWidth: 200 },
    ],
    [deleteRow],
  );


  return (
    <>
    <Nav />
    <div className='titlePage'>
            <h3 className="head_title">Listado de usuarios del grupo: {localStorage.getItem("listaCompra")}  </h3>
    </div>
    <ThemeProvider theme={theme}>


      <div className='titleButtons' >
        <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
        <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>
            Nuevo
        </Button>
      </div>

        <div className='panel'>
          <div className='box-compraList'>
           <DataGrid  columns={columns} rows={rows}
              initialState={{
                pagination: {
                  paginationModel: { page: 0, pageSize: 100 },
                },
                columns: {
                  columnVisibilityModel: {

                  },
                },
              }}
              autosizeOptions={{
                columns: ['NombreyApellidos', 'email'],
                includeOutliers: true,
                includeHeaders: true,
              }}
              pageSizeOptions={[5, 10, 15, 20, 100]}
              // enableRowNumbers
              slots={{
                toolbar: CustomToolbar,
              }}

            />
          </div>  
        </div>
        
      </ThemeProvider>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( UserList );