import { useEffect, useRef } from "react";
import anychart from "anychart";

/**
 * SimplePieChart Component
 * Encapsulated React component rendering a basic AnyChart Pie Chart.
 * No props required; all chart-related logic is self-contained.
 */
const SimplePieChart = () => {
  // Scope: References
  // We use a `ref` to keep track of the AnyChart chart instance for proper cleanup
  const chartRef = useRef(null);

  useEffect(() => {
    /**
     * MAIN CHART LOGIC STARTS HERE
     * This function sets up the chart, adds data, and customizes its appearance.
     * 
     */
    const drawChart = () => {

      // Define the data to be displayed in the pie chart.
      const data = [
        { x: "Cycling", value: 10.25 },
        { x: "Swimming", value: 12 },
        { x: "Running", value: 18 },
        { x: "Hiking", value: 11 },
        { x: "Alpinism", value: 9 },
      ];


      // Ensure the chart is only created once to avoid duplicates.
      if (!chartRef.current) {
        console.log("Se va a iniciar  el recurso 'cartRef'");
        // Create the pie chart instance
        const chart = anychart.pie(data);

        anychart.theme('lightEarth');

        anychart.format.outputLocale('es-es');

        // Set your licence key before you create chart.
        anychart.licenseKey('xlinesoft-9faa5dd-332123fd'); 
        // Set logo source.
        // You can't customize credits without a license key. See https://www.anychart.com/buy/ to learn more.
        var credits = chart.credits();
        credits.enabled(false);
        credits.logoSrc('');

        // Add a title to the chart
        chart.title("Activity Distribution");

        var tooltip = chart.tooltip();
        tooltip.format("Valor: {%value} \nVotos válido: {%value}{type:number,decimalsCount:2}%");

        // Specify the container for the chart and draw it
        chart.container("container");
        chart.draw();

        // Save the chart instance to the ref for cleanup on unmount
        chartRef.current = chart;
      }
    };

    // Call the chart-drawing function when the component is mounted
    drawChart();

    // Dispose of the chart instance when the component is unmounted
    return () => {
      if (chartRef.current) {
        console.log("Se está limpiando el recurso 'cartRef'");
        chartRef.current.dispose();
        chartRef.current = null;
      }
    };
  }, []); // Dependency array ensures this effect runs only once


  return (
    <>
      {/* This is where the AnyChart Pie Chart will be rendered */}
      <div id="container" style={{ width: "100%", height: "600px" }}></div>
    </>
  );
};

export default SimplePieChart;
