import * as React from 'react';
import {useEffect, useState} from 'react';

import { useRef } from "react";
import anychart from "anychart";

import './style.css';
import Grid from '@mui/material/Grid2';
import Box from '@mui/material/Box';
import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';

import Tab from '@mui/material/Tab';
import TabContext from '@mui/lab/TabContext';
import TabList from '@mui/lab/TabList';
import TabPanel from '@mui/lab/TabPanel';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';
import Semidonut from './semidonut';
import VotosMunicipios from './votosmunicipios';

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function DashBoard(props) {

  const [rows, setRows] = useState([
    {
      "id": 29,
      "Orden": 33,
      "EsAsamblea": 1,
      "Titulo": "2019-AM",
      "Descripcion": "2019 - Asamblea de Madrid",
      "TipoConvocatoria_idTipoConvocatoria": 1,
      "EsFicticia": 0,
      "Orden_Ana": 32
    }
  ]);

  const [convocatoria, setConvocatoria] = useState([
    {
      "id": 29,
      "Orden": 33,
      "EsAsamblea": 1,
      "Titulo": "2019-AM",
      "Descripcion": "2019 - Asamblea de Madrid",
      "TipoConvocatoria_idTipoConvocatoria": 1,
      "EsFicticia": 0,
      "Orden_Ana": 32
    }
  ]);

  const chartRef = useRef(null);

  const [escanos, setEscanos] = useState([{}]);

  const [votosMunicipios, setVotosMunicipios] = useState([{}]);
  const [colors, setColors] = useState([{}]);

  const [refresh, setRefresh] = useState(true);

  const [valueTabs, setValueTabs] = React.useState('1');

  const handleChangeTabs = (event, newValue) => {
    setValueTabs(newValue);
  };

  // var formWitdh = window.innerWidth;
  // console.log("Ancho de pantalla: ",formWitdh);

  // Notificación error grave
    function errorNotification(code, message) {

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
      // props.navigate(Config.URL_APP+'/logout');
    }

    // Cargar los datos del Server cuando se carga y recarga la página
    const fetchCovocatorias = async () => {
     
      if (refresh) {        // Para intentar que sólo sea una vez
        setRefresh(false);
        const url = Config.RUTA_API + "/convocatoriasList"; 
        const formData = new FormData();
        const config = {
          headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "Authorization": Config.AUTHORIZATION
          },
        };
        try {  
          const response = await axios.post(url,formData,config)     
              var resp = response.data;
              var data = resp.data;
              console.log("Respuesta del fetch 'Convocatorias': ",resp);
              // console.log("Data: ",data);
              // console.log("Primer Registro: ",data[0]);
              setRows(data);
              setConvocatoria(data[0]);
              fetchEscanos(data[0].id);           // Accede a información de Escaños
              fetchVotosMunicipios(data[0].id);   // Accede a información de Votos por Municipios
              if (resp.error === true )  { 
                console.log("Hay un error: ",resp.message);
                errorNotification(resp.error,resp.message);
              } else {
                // console.log("Registros de respuesta: ", resp.data.length);
              }
                
            }
        catch(error) {
              console.log("Error Post - Información del Server- DashBorad", error);
              errorNotification('999',error);
            }
      }
    };

      // Cargar los datos del Server cuando se carga y recarga la página
      const fetchEscanos = async ( id) => {
    
        if (id !== undefined) {        // Para intentar que sólo sea una vez
 
            const url = Config.RUTA_API + "/escanosList"; 
            const formData = new FormData();
            formData.append('id',id);
            const config = {
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Authorization": Config.AUTHORIZATION
            },
            };
            try {  
            const response = await axios.post(url,formData,config)     
                var resp = response.data;
                var data = resp.data;
                console.log("Respuesta del fetch 'Escaños': ",resp);
                // console.log("Data: ",data);
                // console.log("Primer Registro: ",data[0]);
                setEscanos(data);

                if (resp.error === true )  { 
                    console.log("Hay un error: ",resp.message);
                    errorNotification(resp.error,resp.message);
                } else {
                    // console.log("Registros de respuesta: ", resp.data.length);
                }
                    
                }
            catch(error) {
                console.log("Error Post - Información del Server -Escanos", error);
                errorNotification('999',error);
                }
        }
    };

    
      // Cargar los datos del Server cuando se carga y recarga la página
      const fetchVotosMunicipios = async ( id) => {
    
        if (id !== undefined) {        // Para intentar que sólo sea una vez

            const url = Config.RUTA_API + "/municipiosList"; 
            const formData = new FormData();
            formData.append('id',id);
            const config = {
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Authorization": Config.AUTHORIZATION
            },
            };
            try {  
            const response = await axios.post(url,formData,config)     
                var resp = response.data;
                var data = resp.data;
                var colors = resp.colors;
                console.log("Respuesta del fetch 'Municipios': ",resp);
                // console.log("Data: ",data);
                // console.log("Primer Registro: ",data[0]);
                setVotosMunicipios(data);
                setColors(colors);

                if (resp.error === true )  { 
                    console.log("Hay un error: ",resp.message);
                    errorNotification(resp.error,resp.message);
                } else {
                    // console.log("Registros de respuesta: ", resp.data.length);
                }
                    
                }
            catch(error) {
                console.log("Error Post - Información del Server -VotosMunicipios", error);
                errorNotification('999',error);
                }
        }
    };
 
 
    // Cargar los datos del Server cuando se carga la página
    useEffect(() => {
      console.log("Ejecutándose 'useEffect");
      fetchCovocatorias();
       }, [refresh]);

  const handleConvocatoria = (e) => {
    const { name, value } = e.target;
    const row = rows.find((rowid) => rowid.id === value);
    // console.log("Datos del Producto: ",row);
    setConvocatoria(row);
    // console.log("Datos de Input: ",input);
    fetchEscanos(row.id);           // Reload data Escaños
    fetchVotosMunicipios(row.id);   // Reload data Votos por Municipios

  };

  return (
    <>
    <Nav /> 
    <div className='titlePage'>
        <h3 className="head_title">Datos Electorales de Comunidad de Madrid</h3>
    </div>

    <div className='panel'>
      <div className='box'>
        <Box component="form" noValidate autoComplete="off" >  
          <Grid container spacing={2}>
          <Grid xs={12}>
                <InputLabel id="select-label">Selecciona la Convocatoria *</InputLabel>
                <Select 
                  // error={error} 
                  id="convacotaria" 
                  name="convacotaria"
                  label="Convacotaria" 
                  required={false}
                  variant="standard"   
                  className= 'CustomField'  
                  value={convocatoria.id ?? ''}
                  onChange={handleConvocatoria}
                >
                {rows.map((row, index) => (
                  <MenuItem key={row.id}  value={row.id}> {row.Descripcion} 
                  </MenuItem> 
                ))}
                </Select>
            </Grid>
          </Grid>
        </Box>
      </div>
    </div>

      <div className='panel-tabs'>
      <TabContext value={valueTabs} >
      <div>
            <Box sx={{ mx: 'auto', displayPrint: 'block',  alignItem: 'center', alignContent: 'center' , width: 300 }}>
            
              <TabList 
                    onChange={handleChangeTabs}
                    textColor="secondary"
                    indicatorColor="secondary" 
                    aria-label="lab API tabs example"
                  >
                <Tab label="Escaños" value="1" />
                <Tab label="Votos por Municipio" value="2" />
              </TabList>

            </Box>
        </div> 
        <TabPanel value="1"> 
          { escanos.length !== 1?
          <Semidonut id={convocatoria.id} title={convocatoria.Descripcion} escanos={escanos} /> 
          : ''}
          </TabPanel>
        <TabPanel value="2">
        { votosMunicipios.length > 1?
          <VotosMunicipios id={convocatoria.id} title={convocatoria.Descripcion} votosmunicipios={votosMunicipios}  colors={colors}/> 
          : ''}
        </TabPanel>
      </TabContext>
      </div>     
    </>
  );
}

// IMPORTANT ----------------------------------------
export default withRouter(DashBoard);