import { useEffect, useRef } from "react";
import anychart from "anychart";
// import Swal from 'sweetalert2'
// import withReactContent from 'sweetalert2-react-content'
// import axios from 'axios';
import Config from "../config";


const Semidonut = ({ id, title, escanos }) => {
  // Scope: References
  // We use a `ref` to keep track of the AnyChart chart instance for proper cleanup
  console.log("Inciando Semidonut. id: "+id+" Title: "+title+" Escaños:",escanos);
   
  const chartRef = useRef(null);


  useEffect(() => {

    // console.log("Ejecutándose 'useEffect");
    drawChart();

    // +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    // Dispose of the chart instance when the component is unmounted
    return () => {
      if (chartRef.current) {
        console.log("Se está limpiando el recurso 'cartRef'");
        chartRef.current.dispose();
        chartRef.current = null;
      }
    };
  }, [escanos]); // Dependency array ensures this effect runs only once


  // Función construct Grphics
  const drawChart = () => {
    
    var data = [{}];
    data = [...escanos];

    console.log("Empezamos a crear el Chart. Datos: ",data);
    // Cálculo de total de Escaños.
    let totalEscanos = 0;
    let i = 0;
    while (i < data.length) {
        totalEscanos = totalEscanos + data[i].value;
        i++;
    }
    // Ensure the chart is only created once to avoid duplicates.
    if (!chartRef.current) {
        console.log("Se va a iniciar  el recurso 'cartRef'");
        // var data = rows;

        // calculate total value
        var halfOfTotal = data.reduce((total, currentRow) => { 
            return total + currentRow.value
                }, 0);

        // add the second half that equals initial total
        data.push({x: "hidden", value: halfOfTotal, fill: '#000 0'});

        var chart = anychart.pie(data);

        // anychart.theme('lightEarth');
        anychart.format.outputLocale('es-es');

        // Set your licence key before you create chart.
        anychart.licenseKey(Config.ANYCHART_LICENSE); 
        // Set logo source.
        // You can't customize credits without a license key. See https://www.anychart.com/buy/ to learn more.
        var credits = chart.credits();
        credits.enabled(false);
        credits.logoSrc('');

        // Add a title to the chart
        chart.title(title);

        // turn on chart animation
        // chart.animation(true);
        // apply custom start angle
        chart.startAngle(-90);
        //set the inner radius
        //  (to turn the pie chart into a doughnut chart)
        chart.innerRadius("50%");
        chart.padding(0).margin(0);

        // hide the half of the chart beyond the stage
        // chart.bounds(0, '50%', '100%', '100%');
        chart.padding(0, 0, '-90%', 0);
        
        // set chart labels position to outside
        // chart.labels().enabled(false).position('outside');
        chart.labels().enabled(true);
            
        chart.labels()
        .fontSize(11)
        .fontColor('white')
        .format("{%value}");

        var tooltip = chart.tooltip();
        tooltip.format("Escaños: {%value}\nVotos válido: {%porvotos}{type:number,decimalsCount:2}%");

        // create standalone label and set settings
        var label = anychart.standalones.label();
            label
            .enabled(true)
            .text(totalEscanos+'\n escaños  \n \n \n \n')
            .width('100%')
            .height('100%')
            // .adjustFontSize(true, true)
            // .minFontSize(8)
            // .maxFontSize(20)
            // .fontColor('#178ACC')
            .position('center')
            .anchor('center')
            .hAlign('center')
            .vAlign('middle');

        // set label to center content of chart
        chart.center().content(label);

        chart.legend(false);

        // Set event listener on the chart.
        chart.listen("pointClick", function(e){
            var index = e.iterator.getIndex();
            console.log('Click en Item (index): '+ index);
            // var row = data.row(index);
            console.log('Click en Item : '+ e.iterator.get("x"));
            console.debug(e.iterator);
        });

        // Specify the container for the chart and draw it
        chart.container("semidonut");
        chart.draw();

        // Save the chart instance to the ref for cleanup on unmount
        chartRef.current = chart;
    }
  };

  return (
    <>
      {/* This is where the AnyChart Graphics Chart will be rendered */}
      <div id="semidonut" style={{ width: "100%", height: "300px" }}></div>
    </>
  );
};

export default Semidonut;
