import { useEffect, useRef } from "react";
import anychart from "anychart";
// import Swal from 'sweetalert2'
// import withReactContent from 'sweetalert2-react-content'
// import axios from 'axios';
import Config from "../config";
import MunicipiosMadrid from './MunicipiosMadrid';


const VotosMunicipios = ({ id, title, votosmunicipios, colors }) => {
  // Scope: References
  // We use a `ref` to keep track of the AnyChart chart instance for proper cleanup
  console.log("Inciando Semidonut. id: "+id+" Title: "+title+" Votos:",votosmunicipios);
   
  const chartRef = useRef(null);

  useEffect(() => {

    // console.log("Ejecutándose 'useEffect");
    drawChart();

    // +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    // Dispose of the chart instance when the component is unmounted
    return () => {
      if (chartRef.current) {
        console.log("Se está limpiando el recurso 'cartRef'");
        chartRef.current.dispose();
        chartRef.current = null;
      }
    };
  }, [votosmunicipios]); // Dependency array ensures this effect runs only once


  // Función construct Grphics
  const drawChart = () => {
    
    var dataSet = [{}];
    dataSet = [...votosmunicipios];

    console.log("Empezamos a crear el Chart. Datos: ",dataSet);
  
    // Ensure the chart is only created once to avoid duplicates.
    if (!chartRef.current) {
        console.log("Se va a iniciar  el recurso 'cartRef'");
   
        // set map Geo data
        var chart = anychart.map();
        var geojson = JSON.parse(MunicipiosMadrid); 
        chart.geoData(geojson);	

        // anychart.theme('lightEarth');
        anychart.format.outputLocale('es-es');
        // Set your licence key before you create chart.
        anychart.licenseKey(Config.ANYCHART_LICENSE); 
        // Set logo source.
        // You can't customize credits without a license key. See https://www.anychart.com/buy/ to learn more.
        var credits = chart.credits();
        credits.enabled(false);
        credits.logoSrc('');

        // Add a title to the chart
        chart.title(title);
        // set map title settings using html
        /*
        chart.title()
        .enabled(true)
        .useHtml(true)
        .padding(10, 0)
        .hAlign('center')
        .fontFamily("'Verdana', Helvetica, Arial, sans-serif")
        .text(
          '<span style="color:#7c868e; font-size: 18px">'+title+'</span>'
        );
        */
        
        chart.padding([0, 0, 0, 0]);
        // set the series
        var series = chart.choropleth(dataSet);

        // líneas de division
        series.stroke('0.5 #FFF');
        series.hovered()
                .fill('#EAFE5F')
                .stroke(anychart.color.darken('#EAFE5F'));
        series.selected()
                .fill('#EAFE5F')
                .stroke(anychart.color.darken('#EAFE5F'));
        series.labels()
                .enabled(true)
                .fontSize(10)
                .fontColor('#212121')
                .format('{%value}');

        // set tooltip settings
        series
                .tooltip()
                .position('left-center')
                .anchor('left-center')
                .offsetX(5)
                .offsetY(0)
                .titleFormat('{%name}')
                .format('Partido más votado: {%Titulo}\n'+
                    'Votos recibidos: {%voto}{type:number}\n'+
                    '% Votos: {%PorcVotos}{type:number,decimalsCount:2}%\n'+
                    'Censo: {%censo}{type:number}\n'+
                    'Votos válidos: {%valido}{type:number}\n'+
                    'Votos en Blancos: {%blanco}{type:number}\n'+
                    'Votos Nulos: {%nulo}{type:number}'
                  );

        // disable labels
        series.labels(false);

        // Colors Scale
        series.colorScale(anychart.scales.ordinalColor(colors));chart.colorRange(false);

        chart.listen("pointClick", function(e){

          var index = e.iterator.getIndex();
          // console.log('Click en Item (index): ', index);
        
          // var row = data.row(index);
        
          // console.log('Click en Item : ', e.iterator.get("id"));
          // console.debug(e.iterator);
        })

        // Specify the container for the chart and draw it
        chart.container("votosmunicipios");
        chart.draw();

        // Save the chart instance to the ref for cleanup on unmount
        chartRef.current = chart;
    }
  };

  return (
    <>
      {/* This is where the AnyChart Graphics Chart will be rendered */}
      <div id="votosmunicipios" style={{ width: "100%", height: "450px" }}></div>
    </>
  );
};

export default VotosMunicipios;
