<?php

/**
 *
 * @About:      Gestión de Datos Electorales de la Comunidad de Madrid
 * @File:       DbElecciones.php
 * @Date:       $Date:$ Ene 2025
 * @Version:    $Rev:$ 1.0
 * @Developer:  fernando humanes
 **/

    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Selective\BasePath\BasePathMiddleware;
    use Slim\Factory\AppFactory;

class DbElecciones
{

    private $connDB;

    function __construct()
    {
        global $conn;               // Connection data base of PHPRunner
        $this->connDB = $conn;      // No se usa esta conexión si está integrado con PHPRunner
    }

    /*
    * Listado de Convocatorias
    */
    public function convocatorias(Request $request,Response $response)
    {
        global $errorMessages;
        
        $sql = "
        SELECT
        idConvocatoria id,
        Orden,
        EsAsamblea,
        Titulo,
        Descripcion,
        TipoConvocatoria_idTipoConvocatoria,
        EsFicticia,
        Orden_Ana
        FROM convocatoria
        WHERE (EsAsamblea = 1)
        ORDER BY Orden ";
        $rs = DB::Query($sql);
        $data_arr = array();
        while( $data = $rs->fetchAssoc() )
        {
            $data_arr[] = $data;
        }
        return $data_arr;
        
    }
/*
* Listado de Convocatorias
*/
    public function escanos($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        SELECT 
        Codigo x, 
        Titulo titulo, 
        Color fill, 
        Votos votos, 
        PorcVotos porvotos, 
        Escanos value
        FROM escanos 
        join candidatura on (Candidatura_idCandidatura = idCandidatura)
        where Escanos <> 0 and Convocatoria_idConvocatoria = $id 
        order by Escanos desc";
        $rs = DB::Query($sql);
        $data_arr = array();
        while( $data = $rs->fetchAssoc() ) 
        {
            $data_arr[] = $data;
        }
        return $data_arr;       
    }
/*
* Listado de Datos electorales por Municipio de la convocatoria del parámetro
*/
    public function municipios($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        SELECT
        v.Convocatoria_idConvocatoria,
        lpad(v.Municipio,3,'0') id,
        m.NombreMunicipio name,
        v.idCandidatura value,
        v.Codigo,
        v.Titulo,
        v.Color,
        v.Votos voto,
        v.PorcVotos,
        e.censo,
        e.Validos valido,
        e.Blanco blanco,
        e.Nulo nulo
        FROM v_municipio_voto v
        join
        (select Convocatoria_idConvocatoria,
        Municipio,
        max(Votos) votos
        from v_municipio_voto m
        group by Convocatoria_idConvocatoria,Municipio ) as ma
        on (
        v.Convocatoria_idConvocatoria = ma.Convocatoria_idConvocatoria and
        v.Municipio =ma.Municipio and
        v.Votos = ma.Votos)
        left join municipio m on m.NumeroMunicipio = v.Municipio
        left join elecmunitotal e on v.Municipio= e.Municipio and v.Convocatoria_idConvocatoria = e.Convocatoria_idConvocatoria
        where v.Convocatoria_idConvocatoria=$id";
        $rs = DB::Query($sql);
        $data_arr = array();
        $color_arr = array();
        while( $data = $rs->fetchAssoc() ) 
        {
            $data_arr[] = $data;
            $color_arr[$data['value']]=$data['Color'];
        }
        $colors = array();
        foreach ($color_arr as $key=>$value){
            $colors[]=array(
                "from" => $key,
                "to" => $key,
                "color" => $value
            );
        }
        
        return [$data_arr,$colors];       
    }

}
