<?php

/**
 *
 * @About:      Gestión de COMPRA
 * @File:       DbCOMPRA.php
 * @Date:       $Date:$ ADec. 2024
 * @Version:    $Rev:$ 1.0
 * @Developer:  fernando humanes
 **/

    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Selective\BasePath\BasePathMiddleware;
    use Slim\Factory\AppFactory;

class DbCompra
{

    private $connDB;

    function __construct()
    {
        global $conn;               // Connection data base of PHPRunner
        $this->connDB = $conn;      // No se usa esta conexión si está integrado con PHPRunner
    }

    public function createSession($param, Request $request, Response $response)
    {   
        // global $conn; // Connection data base of PHPRunner
        $login = $param['login'];
        $password = md5($param['password']);
        // $password = MD5($password );
        
        // Delete session expired
        $now = now();
        $param2 = array();
        $sql = "SELECT uuid  FROM compra_session_api WHERE dateOfExpiry < '$now'";
        $rs = DB::Query($sql);
        while ($data = $rs->fetchAssoc()) {
            $param2['uuid'] = $data['uuid'];
            $this->deleteSession($param2, $request, $response); // Borra ficheros temporales y Borra session
        }
      
        // Check User and password
        $sql = "SELECT * FROM ct_usuario WHERE Login = '$login' AND Password= '$password' AND active = 1";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (!is_array($data)) {
            return false;
        }
        // Delete field "password"
        unset($data['Password']);

        $userPriv = array();
        $userPriv['dataUser']=$data; // Save info of User identified
        $uuid = $this->guidv4();
        // Save session in Data Base
        $data2 = array();
        $data2["uuid"] = $uuid;
        // $data2["session"]  = session_id();  // No se usa en la actualidad
        $data2["creationDate"]  = now();
        $data2["dateOfExpiry"]  = date('Y-m-d H:i:s', (strtotime ("+15 Minute")));
        $data2['sessionVariables'] = json_encode($userPriv,JSON_NUMERIC_CHECK);
        DB::Insert("compra_session_api", $data2 );
        
        return array("uuid"=>$uuid);
    }
    
    /**
    * Revisa si la consulta contiene un Header "Token" para validar y recuperar session
    */
   public function controlSession(Request $request, Response $response)
   {
       global $errorMessages;
       // Getting request headers
       $headers = $request->getHeaders();
       // Debug
       // custom_error(2,"Header: ".json_encode($headers, true)); // To debug
       // Verifying Authorization Header
       if (isset($headers['token-user'])) {
           // get the api key
           $token = $headers['token-user'];
           $token = $token[0];
           $rs = DB::Query("SELECT * FROM compra_session_api WHERE uuid = '$token'");
           $data = $rs->fetchAssoc();
           if (!$data)
           {
               // Token is not present in control session table
               $responseBody["error"] = true;
               $responseBody["message_num"] = '005';
               $responseBody["message"] = $errorMessages['005']; 
               // Error 401
               return $responseBody;
           }

           // validating token
           if ($data['dateOfExpiry'] < now()) { // Expiry

               // Expiry
               $responseBody["error"] = true;
               $responseBody["message_num"] = '007';
               $responseBody["message"] = $errorMessages['007']; 
               // Error 401
               return $responseBody;
           } else {
               //procede utilizar el recurso o metodo del llamado

               // Update date of Expiry the Token
               $data2 = array();
               $keyvalues2 = array();
               $data2["dateOfExpiry"] = date('Y-m-d H:i:s', (strtotime ("+15 Minute")));
               $keyvalues2["id_compra_session_api"] = $data["id_compra_session_api"];
               DB::Update("compra_session_api", $data2, $keyvalues2 );

               return $token;  // Return UUID, for logout
           }
       } else {
           // api key is missing in header
           $responseBody["error"] = true;
           $responseBody["message_num"] = '006';
           $responseBody["message"] = $errorMessages['006']; 
           // error 400
           return $responseBody;
       }
   }
    
    /*
     * Logout session
     */
    public function deleteSession($param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $uuid = $param['uuid'];

        $sql = "SELECT * FROM compra_session_api WHERE uuid = '$uuid' ";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (!is_array($data)) {
            // No existe la session
            $responseBody = array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '002';
            $responseBody["message"] = $errorMessages['002'];
            // Error 401
            return $responseBody;
        }
        // delete session

        // Control de ficheros temporales
        $userInfo = $this->openSession($uuid);
        if (!is_array($userInfo)) { // Significa que no hay error
            $userPriv = json_decode($userInfo, true);
            unlink($userPriv['dataFile']['file']); // Borrado del fichero Temporal
            unlink($userPriv['dataFile']['thumbnail']);       
        }
        
        $data = array();
        $data["uuid"] = $uuid;
        DB::Delete("compra_session_api", $data );
        
        return true;
    }
    
    /*
     * Registrar nuevo usuario
     */
    public function registerUser($param, Request $request, Response $response )
    {
        global $errorMessages;
        $responseBody = array();
        
        $email = $param['email'];
        $login = $param['login']; 
        $sql = "SELECT * FROM ct_usuario WHERE email = '$email' or Login = '$login' ";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (is_array($data)) {
            // Ya existe otro usuario con ese mismo email
            $responseBody = array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '010';
            $responseBody["message"] = $errorMessages['010'];
            // Error 401
            return $responseBody;
        }
        
        $data = array();
        $data["Login"] = $param['login'];
        $data["Password"] = md5($param['password']);
        $data["NombreyApellidos"] = $param['nombre'];
        $data["email"] = $param['email'];
        $data["active"] = 1;
        $data["FechaUltCambio"] = now();
        DB::Insert("ct_usuario", $data );
        return true;
        
    }
    
     /*
     * Recuperar información de la sesión
     
    public function openSession($uuid, Request $request, Response $response )
    {
        global $errorMessages;

        $sql = "SELECT * FROM compra_session_api WHERE uuid = '$uuid' ";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (!is_array($data)) {
            // No existe la session
            $responseBody = array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '002';
            $responseBody["message"] = $errorMessages['002'];
            // Error 400
            return $responseBody;
        }
        $json = $data['sessionVariables'];

        return $json;    
    }
   */
    /**
    * Recupera los datos de sesión (Usuarios, ...) del UUID facilitado
    */
   public function openSession($uuid)
   {
       global $errorMessages;

       $token = $uuid;
       $rs = DB::Query("SELECT * FROM compra_session_api WHERE uuid = '$token'");
       $data = $rs->fetchAssoc();
       if (!$data)
       {
           // Token is not present in control session table
           $responseBody["error"] = true;
           $responseBody["message_num"] = '005';
           $responseBody["message"] = $errorMessages['005']; 
           // Error 401
           return $responseBody;
       }
       return $data['sessionVariables'];
   }
    
     /*
     * Salvar información de la sesión
   
    public function saveSession($uuid,$newJson, Request $request, Response $response )
    {
        global $errorMessages;

        $sql = "SELECT * FROM compra_session_api WHERE uuid = '$uuid' ";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (!is_array($data)) {
            // No existe la session
            $responseBody = array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '002';
            $responseBody["message"] = $errorMessages['002'];
            // Error 400
            return $responseBody;
        }
        // Update the record with id=50 in the 'Cars' table
 
        $data = array();
        $keyvalues = array();
        $data["sessionVariables"] =$newJson;
        $keyvalues["uuid"] = $uuid;
        DB::Update("compra_session_api", $data, $keyvalues );
        
        return true;    
    }
    */
    /**
    * Salva los datos de sesión (Usuarios, ...) del UUID facilitado
   */
   public function saveSession($uuid,$newVariables)
   {
       global $errorMessages;

       $token = $uuid;
       $rs = DB::Query("SELECT * FROM compra_session_api WHERE uuid = '$token'");
       $data = $rs->fetchAssoc();
       if (!$data)
       {
           // Token is not present in control session table
           $responseBody["error"] = true;
           $responseBody["message_num"] = '005';
           $responseBody["message"] = $errorMessages['005']; 
           // Error 401
           return $responseBody;
       }
       // Update the record with id=50 in the 'Cars' table
       $id = $data['id_compra_session_api'];
       $data = array();
       $keyvalues = array();
       $data["sessionVariables"] = $newVariables;
       $keyvalues["id_compra_session_api"] = $id;
       DB::Update("compra_session_api", $data, $keyvalues );
       
       return true;
   }
    /*
    * Listado de Grupos del Usuario Conectadoo
    */
    public function listadoGrupos($userPriv, $uuid ,Request $request,Response $response)
    {
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];

        $sql = "SELECT
                t1.`ct_grupo_idct_grupo` groupId,
                t2.`Nombre`, 
                t2.`Administrador`,
                t3.`Login` Login
                FROM ct_usuario_grupo t1
                JOIN ct_grupo t2 on (t1.`ct_grupo_idct_grupo` = t2.`idct_grupo`)
                LEFT JOIN ct_usuario t3 on (t2.`Administrador` = t3.`idct_usuario` and t3.`idct_usuario`= $idUser)
                WHERE t1.`ct_usuario_idct_usuario` = $idUser";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (!is_array($data)) {
            // No existe ningín grupo
            $responseBody = array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '011';
            $responseBody["message"] = $errorMessages['011'];
            // Error 400
            return $responseBody;
        }
        $data_arr = array();
        $data_arr[] = $data;
        while( $data = $rs->fetchAssoc() ) // Lectura de los 2º grupos
        {
            $data_arr[] = $data;
        }
        if (count($data_arr) == 0) {  // No dispone de nignuna Lista de Compra
            $newSession = array();
            $newSession['dataUser'] = $userPriv['dataUser']; // Copiamos los datos del Usuario
            $newSession['dataGroup'] = $data_arr[0];
            $newSession = json_encode($newSession,JSON_NUMERIC_CHECK);
            $verify = $this->saveSession($uuid,$newSession);      
        }
        if (count($data_arr) == 1) {  // Si sólo un Grupo, automáticamente se selecciona
            $newSession = array();
            $newSession['dataUser'] = $userPriv['dataUser']; // Copiamos los datos del Usuario
            $newSession['dataGroup'] = $data_arr[0];
            $newSession = json_encode($newSession,JSON_NUMERIC_CHECK);
            $verify = $this->saveSession($uuid,$newSession);      
        }
        return $data_arr;
        
    }
    
    /*
    * 
    */
    public function seleccionGrupo($userPriv, $uuid, $param, Request $request,Response $response)
    {
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $param['grupo'];

        $sql = "SELECT
                t1.`ct_grupo_idct_grupo` groupId,
                t2.`Nombre`, t2.`Administrador`,
                t3.`Login` Administrador
                FROM ct_usuario_grupo t1
                JOIN ct_grupo t2 on (t1.`ct_grupo_idct_grupo` = t2.`idct_grupo`)
                LEFT JOIN ct_usuario t3 on (t2.`Administrador` = t3.`idct_usuario` and t3.`idct_usuario`= $idUser)
                WHERE t1.`ct_usuario_idct_usuario` = $idUser AND t1.`ct_grupo_idct_grupo` = $group " ;
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc();
        if (!is_array($data)) {
            // No existe ningín grupo
            $responseBody = array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '011';
            $responseBody["message"] = $errorMessages['011'];
            // Error 400
            return $responseBody;
        }
        $data_arr = array();
        $data_arr[] = $data;
        while( $data = $rs->fetchAssoc() ) // Lectura de los 2º grupos
        {
            $data_arr[] = $data;
        }
        if (count($data_arr) == 1) {  // Si sólo un Grupo, automáticamente se selecciona
            $newSession = array();
            $newSession['dataUser'] = $userPriv['dataUser']; // Copiamos los datos del Usuario
            $newSession['dataGroup'] = $data_arr[0];
            $newSession = json_encode($newSession,JSON_NUMERIC_CHECK);
            $verify = $this->saveSession($uuid,$newSession);      
        }
        return true;
    }
        
    /*
    * List artículos comprados pendientes, hoy, comprados
    */
    public function listadoCompra($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $group = $userPriv['dataGroup']['groupId'];
        
        if ($action == 'pendientes') {
            $sql = 
"SELECT
idlista_compra id,
lista_compra.ct_grupo_idct_grupo,
ct_producto_idct_producto,
ct_producto.Nombre Nombre,
lista_compra.Cantidad,
lista_compra.ct_unidad_idct_unidad,
ct_unidad.Titulo Unidad,
ct_producto.Foto  foto,
lista_compra.FechaUltCambio,
lista_compra.UsuarioUltCambio,
user1.Login LoginUltCambio,
Comprado,
FechaComprado,
UsuarioComprado,
user2.Login LoginComprado
FROM lista_compra
join ct_producto on (idct_producto = ct_producto_idct_producto)
left join ct_unidad on (lista_compra.ct_unidad_idct_unidad = ct_unidad.idct_unidad)
left join ct_usuario user1 on (lista_compra.UsuarioUltCambio = user1.idct_usuario)
left join ct_usuario user2 on (UsuarioComprado = user2.idct_usuario)
WHERE lista_compra.ct_grupo_idct_grupo = $group
AND Comprado = 0" ;
        }
        if ($action == 'comprados') {
            $sql = 
"SELECT
idlista_compra id,
lista_compra.ct_grupo_idct_grupo,
ct_producto_idct_producto,
ct_producto.Nombre Nombre,
lista_compra.Cantidad,
lista_compra.ct_unidad_idct_unidad,
ct_unidad.Titulo Unidad,
ct_producto.Foto  foto,
lista_compra.FechaUltCambio,
lista_compra.UsuarioUltCambio,
user1.Login LoginUltCambio,
Comprado,
FechaComprado,
UsuarioComprado,
user2.Login LoginComprado
FROM lista_compra
join ct_producto on (idct_producto = ct_producto_idct_producto)
left join ct_unidad on (lista_compra.ct_unidad_idct_unidad = ct_unidad.idct_unidad)
left join ct_usuario user1 on (lista_compra.UsuarioUltCambio = user1.idct_usuario)
left join ct_usuario user2 on (UsuarioComprado = user2.idct_usuario)
WHERE lista_compra.ct_grupo_idct_grupo = $group
AND Comprado = 1" ;
        }
        if ($action == 'hoy') {
            $sql = 
"SELECT
idlista_compra id,
lista_compra.ct_grupo_idct_grupo,
ct_producto_idct_producto,
ct_producto.Nombre Nombre,
lista_compra.Cantidad,
lista_compra.ct_unidad_idct_unidad,
ct_unidad.Titulo Unidad,
ct_producto.Foto  foto,
lista_compra.FechaUltCambio,
lista_compra.UsuarioUltCambio,
user1.Login LoginUltCambio,
Comprado,
FechaComprado,
UsuarioComprado,
user2.Login LoginComprado
FROM lista_compra
join ct_producto on (idct_producto = ct_producto_idct_producto)
left join ct_unidad on (lista_compra.ct_unidad_idct_unidad = ct_unidad.idct_unidad)
left join ct_usuario user1 on (lista_compra.UsuarioUltCambio = user1.idct_usuario)
left join ct_usuario user2 on (UsuarioComprado = user2.idct_usuario)
WHERE lista_compra.ct_grupo_idct_grupo = $group
AND Comprado = 1
AND date(FechaComprado) = date(now())" ;
        }
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {   
            $fileArray = my_json_decode($data["foto"]);
            $data["foto"]= $fileArray[0]['thumbnail'];
            $data["foto2"]= $fileArray[0]['name'];
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);;   
    }
    
    /*
    * List de Productos de una lista
    */
    public function listadoProductos($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
"SELECT
c.idct_producto,
c.ct_grupo_idct_grupo,
c.Nombre,
c.Cantidad,
c.ct_unidad_idct_unidad,
u.Titulo unidad,
c.Foto,
c.FechaUltCambio,
c.UsuarioUltCambio,
c.UsuarioUltCambio
FROM ct_producto c
JOIN ct_unidad u on (c.ct_unidad_idct_unidad = u.idct_unidad)
WHERE c.ct_grupo_idct_grupo = $group
ORDER BY c.Nombre" ;
 
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $fileArray = my_json_decode($data["Foto"]);
            $data["Foto"]= $fileArray[0]['name'];
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);  
    }
    /*
    * List de Unidades
    */
    public function listadoUnidades($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = "SELECT idct_unidad, Titulo FROM ct_unidad";
 
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);  
    }    
    
    /*
    * Actualizar artículos para indicarque se ha Comprado o dejado de Comprar
    */
    public function checkCompra($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId']; 
        $sql = 
        "SELECT
        idlista_compra,
        ct_grupo_idct_grupo,
        ct_producto_idct_producto,
        Cantidad,
        ct_unidad_idct_unidad,
        FechaUltCambio,
        UsuarioUltCambio,
        Comprado,
        FechaComprado,
        UsuarioComprado
        FROM lista_compra
        WHERE idlista_compra = $id " ;
   
        $rs = DB::Query($sql);
        while( $data_read = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $comprado = $data_read['Comprado'];
            if ($comprado == '0') {
                $data = array();
                $keyvalues = array();
                $data["Comprado"] = "1";
                $data["FechaComprado"]  = now();
                $data["UsuarioComprado"] = $idUser;
                $keyvalues["idlista_compra"] = $id;
                DB::Update("lista_compra", $data, $keyvalues );
            } else {
                $data = array();
                $keyvalues = array();
                $data["Comprado"] = "0";
                $data["FechaComprado"]  = null;
                $data["UsuarioComprado"] = null;
                $keyvalues["idlista_compra"] = $id;
                DB::Update("lista_compra", $data, $keyvalues );
                
            }       
        }     
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        return $responseBody;
      
    } 
    // -------------------------------------------------------------------------------------------------
    /*
    * añadir artículos a lista de Compra
    */
    public function addCompra($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['idct_producto'];
        $group = $userPriv['dataGroup']['groupId']; 
        
        /*
        $sql = "SELECT * FROM ct_producto WHERE idct_producto = $id";
        $rs = DB::Query($sql);
        $data_read = $rs->fetchAssoc(); // Lectura del registro Producto
        */
        // Insert a record into the 'lista_compra' table
        $data = array();
        $data["ct_grupo_idct_grupo"] = $group;
        $data["ct_producto_idct_producto"]  = $param['idct_producto'];
        $data["Cantidad"] = $param['cantidad'];
        $data["ct_unidad_idct_unidad"] = $param['unidad'];
        $data["FechaUltCambio"] = now();
        $data["UsuarioUltCambio"] = $idUser;
        DB::Insert("lista_compra", $data );
        
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '012';
        $responseBody["message"] = $errorMessages['012'];
        return $responseBody;
    }
    
    /*
    * Actualizar artículos a lista de Compra
    */
    public function updateCompra($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId']; 

        // Update a record into the 'lista_compra' table
        $data2 = array();
        $keyvalues2 = array();
        $data2["ct_grupo_idct_grupo"] = $group;
        $data2["ct_producto_idct_producto"]  = $param['idct_producto'];
        $data2["Cantidad"] = $param['cantidad'];
        $data2["ct_unidad_idct_unidad"] = $param['unidad'];
        $data2["FechaUltCambio"] = now();
        $data2["UsuarioUltCambio"] = $idUser;
        $keyvalues2['idlista_compra'] = $id;
        DB::Update("lista_compra", $data2,$keyvalues2 );
               
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '012';
        $responseBody["message"] = $errorMessages['012'];
        return $responseBody;

    }
    
    
    /*
    * Eliminar artículos a lista de Compra
    */
    public function deleteCompra($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $data = array();
        $data["idlista_compra"] = $id;
        DB::Delete("lista_compra", $data );
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        return $responseBody;
    }
        
    /*
    * View artículos a lista de Compra
    */
    public function viewCompra($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
        "SELECT
        idlista_compra id,
        lista_compra.ct_grupo_idct_grupo,
        ct_producto_idct_producto,
        ct_producto.Nombre Nombre,
        lista_compra.Cantidad,
        lista_compra.ct_unidad_idct_unidad,
        ct_unidad.Titulo Unidad,
        ct_producto.Foto  foto,
        lista_compra.FechaUltCambio,
        lista_compra.UsuarioUltCambio,
        user1.Login LoginUltCambio,
        Comprado,
        FechaComprado,
        UsuarioComprado,
        user2.Login LoginComprado
        FROM lista_compra
        join ct_producto on (idct_producto = ct_producto_idct_producto)
        left join ct_unidad on (lista_compra.ct_unidad_idct_unidad = ct_unidad.idct_unidad)
        left join ct_usuario user1 on (lista_compra.UsuarioUltCambio = user1.idct_usuario)
        left join ct_usuario user2 on (UsuarioComprado = user2.idct_usuario)
        WHERE idlista_compra = $id " ;
   
        $data_arr= array();
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc(); // Lectura de los registros
   
        $fileArray = my_json_decode($data["foto"]);
        $data["foto"]= $fileArray[0]['name'];
        $data_arr[] = $data;
    
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        $responseBody["data"] = $data;
        return $responseBody;

    }
    
    /*
    * List de Productos de una lista
    */
    public function listadoProductoGrupo($userPriv, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
"SELECT
c.idct_producto id,
c.ct_grupo_idct_grupo,
c.Nombre,
c.Cantidad,
c.ct_unidad_idct_unidad,
u.Titulo Unidad,
c.Foto foto, 
c.FechaUltCambio,
c.UsuarioUltCambio,
c.UsuarioUltCambio
FROM ct_producto c
JOIN ct_unidad u on (c.ct_unidad_idct_unidad = u.idct_unidad)
WHERE c.ct_grupo_idct_grupo = $group
ORDER BY c.Nombre" ;
 
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $fileArray = my_json_decode($data["foto"]);
            $data["foto"]= $fileArray[0]['thumbnail'];
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);  
    }
   // -------------------------------------------------------------------------------------------------
    /*
    * añadir artículos Productos de un grupo
    */
    public function addProducto($userPriv, $uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['idct_producto'];
        $group = $userPriv['dataGroup']['groupId'];
        
        // Guarda ficheros de fotos
        $dataFile = $userPriv['dataFile'];
        $data = array();
        if ($dataFile <> null ) { // Existe fichero de imagen
            $dir = FILES_DIR;
            $filename = $dataFile['filename'];
            $part = explode(".", $filename);
            $filename1 = $part[0].'_'.time().'.'.$part[1];
            $filename2 = 'TH_'.$part[0].'_'.time().'.'.$part[1];
            $dirFile1 = $dir.$filename1;
            $dirFile2 = $dir.$filename2;
            copy($dataFile['file'], $dirFile1);
            copy($dataFile['thumbnail'], $dirFile2);
            
            // get information about uploaded files
            $fileArray = array();
            $fileArray[0]['name'] = FILES_DIR_SHORT.$filename1;
            $fileArray[0]['usrName'] = $dataFile['filename'];
            $fileArray[0]['size'] = $dataFile['size'];
            $fileArray[0]['type'] = $dataFile['type'];
            $fileArray[0]['thumbnail'] = FILES_DIR_SHORT.$filename2;
            $fileArray[0]['thumbnail_size'] = $dataFile['thumbnail_size'];
            $fileArray[0]['thumbnail_type'] = $dataFile['type'];
            $fileArray[0]['searchStr'] = $dataFile['filename'];
            $data["Foto"] = my_json_encode($fileArray);
            custom_error(4019,"Antes de llamar a 'deleteDataFile': ". print_r($userPriv,true)); // To debug
            $this->deleteDataFile($userPriv, $uuid, $request, $response); // Delete ficheros temporales
        }

        // Insert a record into the 'lista_compra' table
        
        $data["ct_grupo_idct_grupo"] = $group;
        $data["Cantidad"] = $param['cantidad'];
        $data["Nombre"] = $param['Nombre'];
        $data["ct_unidad_idct_unidad"] = $param['unidad'];
        $data["FechaUltCambio"] = now();
        $data["UsuarioUltCambio"] = $idUser;
        DB::Insert("ct_producto", $data );
        
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '012';
        $responseBody["message"] = $errorMessages['012'];
        return $responseBody;
    }
    
    /*
    * Actualizar artículos a lista de Compra
    */
    public function updateProducto($userPriv,$uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId'];        
        // Guarda ficheros de fotos
        $dataFile = $userPriv['dataFile'];
        
        $data2 = array();               // For Update
        $keyvalues2 = array();
        custom_error(40011,"Producto -Update = Param: ".print_r($param, true)); // To debug
        if ($dataFile <> null || $param['deletefoto'] === 'true') {
            // Hay que eliminar fotos.
            $sql = "SELECT idct_producto, Foto FROM ct_producto  WHERE idct_producto = $id";
            $rs = DB::Query($sql);
            $data = $rs->fetchAssoc(); // Lectura de los registros
            $fileArray = my_json_decode($data["Foto"]);     
            foreach ($fileArray as $row) {
                $file = FILES_ROOT.$row["name"];
                unlink($file);                      // Borrado del fichero        
                $file = FILES_ROOT.$row["thumbnail"];
                unlink($file);                      // Borrado del fichero          
            }
            $data2['Foto']="";
        }
        $data = array();
        if ($dataFile <> null ) { // Existe fichero de imagen
            $dir = FILES_DIR;
            $filename = $dataFile['filename'];
            $part = explode(".", $filename);
            $filename1 = $part[0].'_'.time().'.'.$part[1];
            $filename2 = 'TH_'.$part[0].'_'.time().'.'.$part[1];
            $dirFile1 = $dir.$filename1;
            $dirFile2 = $dir.$filename2;
            copy($dataFile['file'], $dirFile1);
            copy($dataFile['thumbnail'], $dirFile2);
            
            // get information about uploaded files
            $fileArray = array();
            $fileArray[0]['name'] = FILES_DIR_SHORT.$filename1;
            $fileArray[0]['usrName'] = $dataFile['filename'];
            $fileArray[0]['size'] = $dataFile['size'];
            $fileArray[0]['type'] = $dataFile['type'];
            $fileArray[0]['thumbnail'] = FILES_DIR_SHORT.$filename2;
            $fileArray[0]['thumbnail_size'] = $dataFile['thumbnail_size'];
            $fileArray[0]['thumbnail_type'] = $dataFile['type'];
            $fileArray[0]['searchStr'] = $dataFile['filename'];
            $data2["Foto"] = my_json_encode($fileArray);
            $this->deleteDataFile($userPriv, $uuid, $request, $response); // Delete ficheros temporales
        }
        
        // Update a record into the 'lista_compra' table
        $data2["Cantidad"] = $param['cantidad'];
        $data2["Nombre"] = $param['Nombre'];
        $data2["ct_unidad_idct_unidad"] = $param['unidad'];
        $data2["FechaUltCambio"] = now();
        $data2["UsuarioUltCambio"] = $idUser;
        $keyvalues2['idct_producto'] = $id;
        DB::Update("ct_producto", $data2,$keyvalues2 );
               
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '012';
        $responseBody["message"] = $errorMessages['012'];
        return $responseBody;

    }
    
    
    /*
    * Eliminar artículos a lista de Compra
    */
    public function deleteProducto($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId'];
        
        // Borrado de la Lista, si está en alguna
        $data = array();
        $data["ct_producto_idct_producto"] = $id;
        DB::Delete("lista_compra", $data );
         
        // Antes de Borras, hay que eliminar fotos.
        $sql = "SELECT idct_producto, Foto FROM ct_producto  WHERE idct_producto = $id";
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc(); // Lectura de los registros
        $fileArray = my_json_decode($data["Foto"]);     
        foreach ($fileArray as $row) {
            $file = FILES_ROOT.$row["name"];
            unlink($file);                      // Borrado del fichero        
            $file = FILES_ROOT.$row["thumbnail"];
            unlink($file);                      // Borrado del fichero          
        }
        
         // Borrado del Producto
        $data = array();
        $data["idct_producto"] = $id;
        DB::Delete("ct_producto", $data );
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        return $responseBody;
    }
        
    /*
    * View artículos a lista de Compra
    */
    public function viewProducto($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_producto'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
        "SELECT
        idct_producto id,
        ct_producto.ct_grupo_idct_grupo,
        ct_producto.Nombre Nombre,
        ct_producto.Cantidad,
        ct_producto.ct_unidad_idct_unidad,
        ct_unidad.Titulo Unidad,
        ct_producto.Foto  foto,
        ct_producto.FechaUltCambio,
        ct_producto.UsuarioUltCambio,
        user1.Login LoginUltCambio
        FROM ct_producto
        left join ct_unidad on (ct_producto.ct_unidad_idct_unidad = ct_unidad.idct_unidad)
        left join ct_usuario user1 on (ct_producto.UsuarioUltCambio = user1.idct_usuario)
        WHERE idct_producto = $id" ;
   
        $data_arr= array();
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc(); // Lectura de los registros
   
        $fileArray = my_json_decode($data["foto"]);
        $data["foto"]= $fileArray[0]['name'];
        $data_arr[] = $data;
    
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        $responseBody["data"] = $data;
        return $responseBody;
    }
    
    /*
    * List de Productos de una lista
    */
    public function listadoUsersGroup($userPriv, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
"SELECT
u.idct_usuario,
u.NombreyApellidos
FROM ct_usuario_grupo g
JOIN ct_usuario u ON (g.ct_usuario_idct_usuario = u.idct_usuario )
WHERE g.ct_grupo_idct_grupo = $group" ;
 
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);  
    }
    
    /*
    * List de Productos de una lista
    */
    public function listadoGruposUser($userPriv, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
"SELECT
t1.`ct_grupo_idct_grupo` id,
t2.`Nombre`,
t2.`Administrador`,
t3.NombreyApellidos NombreUsuario,
t3.`Login` Login
FROM ct_usuario_grupo t1
JOIN ct_grupo t2 on (t1.`ct_grupo_idct_grupo` = t2.`idct_grupo`)
LEFT JOIN ct_usuario t3 on (t2.`Administrador` = t3.`idct_usuario` and t3.`idct_usuario`= $idUser)
WHERE t1.`ct_usuario_idct_usuario` = $idUser" ;
 
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);  
    }
   // -------------------------------------------------------------------------------------------------
    /*
    * añadir artículos Productos de un grupo
    */
    public function addGrupo($userPriv, $uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['idct_row'];
        $group = $userPriv['dataGroup']['groupId'];

        // Insert a record into the 'Grupo' table
        $data = array(); 
        $data["Nombre"] = $param['Nombre'];
        $data["FechaAlta"] = now();
        $data["Administrador"] = $idUser;
        $data["Descripcion"] = $param['Descripcion'];
        // custom_error(40020,"Grupo -Add: ".print_r($data, true)); // To debug
        DB::Insert("ct_grupo", $data );
        $idGrupo = DB::LastId();
        
        // Insert a record into the 'usuario_grupo' table
        $data = array(); 
        $data["ct_grupo_idct_grupo"] = $idGrupo;
        $data["ct_usuario_idct_usuario"] = $idUser;
        // custom_error(40021,"Usuario_grupo -Add: ".print_r($data, true)); // To debug
        DB::Insert("ct_usuario_grupo", $data );    
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '012';
        $responseBody["message"] = $errorMessages['012'];
        return $responseBody;
    }
    
    /*
    * Actualizar artículos a lista de Compra
    */
    public function updateGrupo($userPriv,$uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_row'];
        $group = $userPriv['dataGroup']['groupId'];        

        $data2 = array();
        $keyvalues2= array();
        // Update a record into the 'lista_compra' table
        $data2["Nombre"] = $param['Nombre'];
        $data2["Administrador"] = $param['Administrador'];
 
        $keyvalues2['idct_grupo'] = $id;
        DB::Update("ct_grupo", $data2,$keyvalues2 );
               
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '019';
        $responseBody["message"] = $errorMessages['019'];
        return $responseBody;
    } 
    /*
    * Eliminar artículos a lista de Compra
    */
    public function deleteGrupo($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_row'];
        $group = $userPriv['dataGroup']['groupId'];
        
        // Borrado de usuario_grupo'
        $data = array();
        $data["ct_grupo_idct_grupo"] = $id;
        $data["ct_usuario_idct_usuario"] = $idUser;
        DB::Delete("ct_usuario_grupo", $data );
        custom_error(40031,"Borrado tabla 'ct_usuario_grupo': ".print_r($data, true)); // To debug
         
        // Antes de Borras, hay que identificar el tipo de borrado
        $sql = "SELECT * FROM ct_grupo  WHERE idct_grupo = $id";
        $rs = DB::Query($sql);
        $data2 = $rs->fetchAssoc(); // Lectura de los registros

        if ( $data2["Administrador"] == $idUser ) {  // Se está borrado un Grupo entero y toda su información asociada
            // Borrado de los usuarios del grupo
            $data = array();
            $data["ct_grupo_idct_grupo"] = $id;
            DB::Delete("ct_usuario_grupo", $data );
            custom_error(40032,"Borrado tabla 'ct_usuario_grupo': ".print_r($data, true)); // To debug
            // Borrado de la Lista de Compra
            $data = array();
            $data["ct_grupo_idct_grupo"] = $id;
            DB::Delete("lista_compra", $data );
            custom_error(40033,"Borrado tabla 'lista_compra': ".print_r($data, true)); // To debug
            // Antes de BorraR Producto, hay que eliminar fotos.
            $data = array();
            $sql = "SELECT idct_producto, Foto FROM ct_producto  WHERE ct_grupo_idct_grupo = $id";
            $rs = DB::Query($sql);
            while( $data = $rs->fetchAssoc() ) {
                $fileArray = my_json_decode($data["Foto"]);     
                foreach ($fileArray as $row) {
                    $file = FILES_ROOT.$row["name"];
                    unlink($file);                      // Borrado del fichero        
                    $file = FILES_ROOT.$row["thumbnail"];
                    unlink($file);                      // Borrado del fichero          
                }
            }
            // Borrado de los Producto
            $data = array();
            $data["ct_grupo_idct_grupo"] = $id;
            DB::Delete("ct_producto", $data );
            custom_error(40034,"Borrado tabla 'ct_producto': ".print_r($data, true)); // To debug
            
            // Borrado del Grupo
            $data = array();
            $data["idct_grupo"] = $id;
            DB::Delete("ct_grupo", $data );
            custom_error(40035,"Borrado tabla 'ct_grupo': ".print_r($data, true)); // To debug
        }
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        return $responseBody;
    }
/*
    * View artículos a lista de Compra
    */
    public function viewGrupo($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_row'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
        "SELECT
t2.idct_grupo,
t2.Nombre,
t2.Administrador,
t3.NombreyApellidos NombreUsuario,
t3.Login Login
FROM ct_grupo t2
LEFT JOIN ct_usuario t3 on (t2.Administrador = t3.idct_usuario)
WHERE
t2.idct_grupo = $id" ;
   
        $data_arr= array();
        $rs = DB::Query($sql);
        $data = $rs->fetchAssoc(); // Lectura de los registros  
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        $responseBody["data"] = $data;
        return $responseBody;
    }    
    
 /*
    * List de Usuarios de un Grupo para LIST
    */
    public function listadoUsersInGroup($userPriv, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $group = $userPriv['dataGroup']['groupId'];
        
        $sql = 
"SELECT
u.idct_usuario id,
u.Login,
u.NombreyApellidos,
u.email,
u.active
FROM ct_usuario_grupo g
JOIN ct_usuario u ON (g.ct_usuario_idct_usuario = u.idct_usuario )
WHERE g.ct_grupo_idct_grupo = $group" ;
 
        $data_arr= array();
        $rs = DB::Query($sql);
        while( $data = $rs->fetchAssoc() ) // Lectura de los registros
        {
            $data_arr[] = $data;
        }
        return json_encode($data_arr,JSON_NUMERIC_CHECK);  
    }   
 // -------------------------------------------------------------------------------------------------
 
    /*
    * añadir usuario a  un grupo
    */
    public function addUser($userPriv, $uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id'];
        $group = $userPriv['dataGroup']['groupId'];

        // Insert a record into the 'Usuario_Grupo' table
        $data = array();
        $data["ct_grupo_idct_grupo"] = $group;
        $data["ct_usuario_idct_usuario"] = $id;
        DB::Insert("ct_usuario_grupo", $data );
        
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '022';
        $responseBody["message"] = $errorMessages['022'];
        return $responseBody;
    }   
  /*
    * Eliminar artículos a lista de Compra
    */
    public function deleteUser($userPriv ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $action = $param['action'];
        $id = $param['id_row'];
        $group = $userPriv['dataGroup']['groupId'];
        
        // Borrado de usuario_grupo'
        $data = array();
        $data["ct_grupo_idct_grupo"] = $group;
        $data["ct_usuario_idct_usuario"] = $id;
        DB::Delete("ct_usuario_grupo", $data );
        // custom_error(40031,"Borrado tabla 'ct_usuario_grupo': ".print_r($data, true)); // To debug
         
        $responseBody= array();
        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        return $responseBody;
    }  

    // -------------------------------------------------------------------------------------------------
    /*
    * Buscar usuario por Email
    */
    public function userSearchEmail($userPriv, $uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $email = $param['email'];
        $group = $userPriv['dataGroup']['groupId'];

        // Buscar Usuario
        $dataUser = array();
        $rs = DB::Query("SELECT
        idct_usuario id,
        Login,
        NombreyApellidos Nombre,
        email
        FROM ct_usuario
        WHERE email = '$email'");
        while( $data = $rs->fetchAssoc() )
        {
            $dataUser = $data;
        }
        $id = $dataUser['id'];
        $dataGroup = array();
        if ( $dataUser['id'] <> null ) { // Si ha recuperado algún usuario
            $rs = DB::Query("SELECT idct_usuario_grupo id, ct_grupo_idct_grupo, ct_usuario_idct_usuario FROM ct_usuario_grupo
               WHERE ct_grupo_idct_grupo=$group and ct_usuario_idct_usuario =$id");
            $dataGroup = $rs->fetchAssoc();
        }
        
        $responseBody= array();
        if ( $id <> null && $dataGroup['ct_usuario_idct_usuario'] <> $id ){ // Todo OK
            $responseBody["error"] = false;
            $responseBody["message_num"] = '000';
            $responseBody["message"] = 'Todo Ok';
            $responseBody["data"] = $dataUser;
            return $responseBody;
        }
        if ( $id == null ) { // No existe ningún usuario con ese email
            $responseBody["error"] = true;
            $responseBody["message_num"] = '020';
            $responseBody["message"] = $errorMessages['020'];;
            return $responseBody;
        }
        // El usuario ya está dado de alta en el grupo
        $responseBody["error"] = true;
        $responseBody["message_num"] = '021';
        $responseBody["message"] = $errorMessages['021'];
        return $responseBody;
    } 
    
    // -------------------------------------------------------------------------------------------------
    /*
    * Acceso a los datos del ususario conectado
    */
    public function userConnect($userPriv, $uuid , Request $request, Response $response)
    {   
        global $errorMessages;
        
        $idUser = $userPriv['dataUser']['idct_usuario'];
        $email = $param['email'];
        $group = $userPriv['dataGroup']['groupId'];

        // Buscar Usuario
        $dataUser = array();
        $rs = DB::Query("SELECT
        -- idct_usuario id,
        Login,
        NombreyApellidos,
        email
        FROM ct_usuario
        WHERE idct_usuario = $idUser");
        while( $data = $rs->fetchAssoc() )
        {
            $dataUser = $data;
        }
        
        $responseBody= array();
            $responseBody["error"] = false;
            $responseBody["message_num"] = '000';
            $responseBody["message"] = 'Todo Ok';
            $responseBody["data"] = $dataUser;
            return $responseBody;
    } 
    
    
    
    
    
    /*
    * Eliminación de la información temporal de Ficheros
    */
    public function deleteDataFile($userPriv, $uuid , Request $request, Response $response)
    {   
        global $errorMessages;
        
        if (isset($userPriv['dataFile'])) { // Si existe contenido
            custom_error(4020,"File borrar: ". print_r($userPriv['dataFile']['file'],true)); // To debug
            unlink($userPriv['dataFile']['file']); // Borrado del fichero Temporal
            unlink($userPriv['dataFile']['thumbnail']);
            
            $newUserPriv = array();
            $newUserPriv['dataUser'] = $userPriv['dataUser'];
            $newUserPriv['dataGroup'] = $userPriv['dataGroup'];
            $userPriv = $newUserPriv;
            $newJson = json_encode($userPriv,JSON_NUMERIC_CHECK);
            $this->saveSession($uuid,$newJson, $request,$response ); // Save Session API
            
            
        }
        return $userPriv;
    }
    /*
    * Crear la información temporal de Ficheros
    */
    public function createDataFile($userPriv, $uuid ,$param, Request $request, Response $response)
    {   
        global $errorMessages;
        
        $userPriv = $this->deleteDataFile($userPriv, $uuid, $request, $response); // Borrado de datos anteriores
        
        // handle single input with single file upload
        $uploadedFile = $param['file'];
        $dataFile = array();
        custom_error(4001,"Upload: ". print_r($uploadedFile,true)); // To debug
        if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
        // if ($uploadedFile) {
            custom_error(4002,"File OK: ". print_r($uploadedFile,true)); // To debug
            custom_error(4004,"Type: ". print_r($uploadedFile->getClientMediaType(),true)); // To debug
            custom_error(4005,"Size: ". print_r($uploadedFile->getSize(),true)); // To debug
            
            $dataFile['filename'] = $uploadedFile->getClientFilename();
            $dataFile['type'] = $uploadedFile->getClientMediaType();
            
            $tempFile = tempnam(sys_get_temp_dir(), 'CO_'); // Crear fichero Temporal
            $uploadedFile->moveTo($tempFile); // Guarda contenido en este fichero
  
            // ++++++++++++++++++++++++++++++ Resize imagen +++++++++++++++++++++++++++++
            list($width, $height) = getimagesize($tempFile);
            
            // Obtener los datos EXIF de la imagen (si están disponibles)
            if ($dataFile['type'] == 'image/jpeg') {  // JPEG
                    $source = imagecreatefromjpeg($tempFile);
                } else {
                    $source = imagecreatefrompng($tempFile); 
            }
            $exif = exif_read_data($tempFile);
            custom_error(4006,"Datos de Exif: ". print_r($exif,true)); // To debug
            // Verificar si los datos EXIF contienen la información de orientación
            $orientation = $exif['Orientation'];
            if ( $orientation <> null) {
                // Rotar la imagen según la orientación EXIF
                switch ($orientation) {
                    case 3:
                        // Rotar 180 grados
                        $source = imagerotate($source, 180, 0);
                        break;
                    case 6:
                        // Rotar 90 grados en sentido horario
                        $source = imagerotate($source, 270, 0);
                        // Invierto $width, $height
                        $aux = $width;
                        $width = $height;
                        $height = $aux;
                        break;
                    case 8:
                        // Rotar 90 grados en sentido antihorario
                        $source = imagerotate($source, 90, 0);
                        // Invierto $width, $height
                        $aux = $width;
                        $width = $height;
                        $height = $aux;
                        break;
                }
            }        
            custom_error(4010,"Size image: ".$width.' - '.$height); // To debug
            $thumbFile = tempnam(sys_get_temp_dir(), 'TH_'); // Crear fichero Temporal
            $origFile = tempnam(sys_get_temp_dir(), 'CO_'); // Crear fichero Temporal
            $percent1 = (300)/$width;                       // Tamaño completo iamgen
            $newwidth1 = $width * $percent1;
            $newheight1 = $height * $percent1;
            $percent2 = (72)/$width;                       // Tamaño thumbnail imagen
            $newwidth2 = $width * $percent2;
            $newheight2 = $height * $percent2;
            $orig = imagecreatetruecolor($newwidth1, $newheight1);
            $thumb = imagecreatetruecolor($newwidth2, $newheight2);
            

            if ($dataFile['type'] == 'image/jpeg') {  // JPEG
               // $source = imagecreatefromjpeg($tempFile);
               imagecopyresized($orig, $source, 0, 0, 0, 0, $newwidth1, $newheight1, $width, $height);
               imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth2, $newheight2, $width, $height);
               imagejpeg($orig,$origFile);
               imagejpeg($thumb,$thumbFile);
            } else {                                   // PNG
               // $source = imagecreatefrompng($tempFile);
               imagecopyresized($orig, $source, 0, 0, 0, 0, $newwidth1, $newheight1, $width, $height);
               imagecopyresized($thumb, $source, 0, 0, 0, 0, $newwidth2, $newheight2, $width, $height);
               imagepng($orig,$origFile);
               imagepng($thumb,$thumbFile);
                
            }
            unlink($tempFile);  // Eliminamos temporal
            
            $dataFile['size'] = filesize($origFile);            
            $dataFile['file'] = $origFile;
            $dataFile['thumbnail']= $thumbFile;
            $dataFile['thumbnail_size']= filesize($thumbFile);
            $userPriv['dataFile'] = $dataFile;  // Actualizo con nuevos datos.
            
            $newJson = json_encode($userPriv,JSON_NUMERIC_CHECK);
            $this->saveSession($uuid,$newJson, $request,$response ); // Save Session API
            
            return $userPriv;
        } else {
            $responseBody= array();
            $responseBody["error"] = true;
            $responseBody["message_num"] = '016';
            $responseBody["message"] = $errorMessages['016'];
            return $responseBody;
        }
        
    }
    
    
    
     

    private function guidv4($data = null) {
        // Generate 16 bytes (128 bits) of random data or use the data passed into the function.
        $data = $data ?? random_bytes(16);
        assert(strlen($data) == 16);
    
        // Set version to 0100
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        // Set bits 6-7 to 10
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
    
        // Output the 36 character UUID.
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    } 

    private function RemoveSpecialCharFile($str) // To normalize filer name
{
    $res = preg_replace('([^A-Za-z0-9_. ])', ' ', $str);
		$res = str_replace(' ','_',$res);
    return $res;
}

}
