<?php
/**
 *
 * @About:      API Interface
 * @File:       index.php
 * @Date:       $Date:$ Ene 2025
 * @Version:    $Rev:$ 1.0
 * @Developer:  Federico Guzman || Modificado por Fernando Humanes para PHP 8.1
 **/

/* Los headers permiten acceso desde otro dominio (CORS) a nuestro REST API o desde un cliente remoto via HTTP
 * Removiendo las lineas header() limitamos el acceso a nuestro RESTfull API a el mismo dominio
 * Nótese los métodos permitidos en Access-Control-Allow-Methods. Esto nos permite limitar los métodos de consulta a nuestro RESTfull API
 * Mas información: https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS
 **/

// $dominioPermitido = "http://localhost:3000";

// header("Access-Control-Allow-Origin: $dominioPermitido"); // Para restringir desde dónde se pueden hacer peticines
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, authorization, Authorization, token-user ");
// header("Access-Control-Allow-Headers: *");

header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: PUT, GET, POST, DELETE, OPTIONS');
// header("Access-Control-Allow-Headers: X-Requested-With");
header('Content-Type: text/html; charset=utf-8');
header('Content-Type: multipart/form-data');
header('Content-Type: application/x-www-form-urlencoded');
header('Content-Type: application/json');
header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');

// session_cache_limiter(false);

include_once '../include/Config.php';  // Configuration Rest Api
require_once("../../include/dbcommon.php"); // DataBase PHPRunner

// Debug
$debugCode = false;
custom_error(1,"URL ejecutada: ".$_SERVER["REQUEST_URI"]); // To debug
// $debugCode = false;

// use App\Models\Db;  // Utilizamos la conexión de PHPRunner
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Selective\BasePath\BasePathMiddleware;
use Slim\Factory\AppFactory;

require_once __DIR__ . '/../libs/autoload.php';   // Library SLIM v4

$app = AppFactory::create();

$app->addRoutingMiddleware();
// $app->add(new BasePathMiddleware($app)); // No usar si se ejecuta en subdirectorio
$app->addErrorMiddleware(true, true, true);
$app->addBodyParsingMiddleware();

$app->setBasePath(SCRIPTS_DIR);             // Indica el directorio desde donde está trabajando

// --------------------------------------------------------------------------------------

/* Usando POST pata obtener las convocatorias de la Base de datos */

$app->post('/convocatoriasList', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbElecciones.php';
    $db = new DbElecciones();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    /* Obtener el listado de Convocatorias */
    $list = $db->convocatorias($request, $response);

        $responseBody["error"] = false;
        $responseBody["message_num"] = '000';
        $responseBody["message"] = '';
        $responseBody["data"] = $list;
        $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
});

// --------------------------------------------------------------------------------------

// Listado de escaños de la convocatoria que pasa por Parámetro
$app->post('/escanosList', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbElecciones.php';
    $db = new DbElecciones();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }

    // check for required params
    $param = $request->getParsedBody();

    $verify = verifyRequiredParams(array('id'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    /* Obtener el listado de Convocatorias */
    $list = $db->escanos($param, $request, $response);

    $responseBody["error"] = false;
    $responseBody["message_num"] = '000';
    $responseBody["message"] = '';
    $responseBody["data"] = $list;
    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});

// --------------------------------------------------------------------------------------
// Listado de Datos electorales por Municipios  de la convocatoria que pasa por Parámetro
$app->post('/municipiosList', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbElecciones.php';
    $db = new DbElecciones();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }

    // check for required params
    $param = $request->getParsedBody();

    $verify = verifyRequiredParams(array('id'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    /* Obtener el listado de Convocatorias */
    $list = $db->municipios($param, $request, $response);

    $responseBody["error"] = false;
    $responseBody["message_num"] = '000';
    $responseBody["message"] = '';
    $responseBody["data"] = $list[0];
    $responseBody["colors"] = $list[1];
    // $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    $response->getBody()->write(json_encode($responseBody));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});

// --------------------------------------------------------------------------------------


/* Runner the aplication */
$app->run();


