<?php

/**
 *
 * @About:      API Interface
 * @File:       index.php
 * @Date:       $Date:$ Agosot0 -2022
 * @Version:    $Rev:$ 1.0
 * @Developer:  Federico Guzman || Modificado por Fernando Humanes para PHP 8.1
 **/

/* Los headers permiten acceso desde otro dominio (CORS) a nuestro REST API o desde un cliente remoto via HTTP
 * Removiendo las lineas header() limitamos el acceso a nuestro RESTfull API a el mismo dominio
 * Nótese los métodos permitidos en Access-Control-Allow-Methods. Esto nos permite limitar los métodos de consulta a nuestro RESTfull API
 * Mas información: https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS
 **/

// $dominioPermitido = "http://localhost:3000";

// header("Access-Control-Allow-Origin: $dominioPermitido"); // Para restringir desde dónde se pueden hacer peticines
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, authorization, Authorization, token-user ");
// header("Access-Control-Allow-Headers: *");


header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: PUT, GET, POST, DELETE, OPTIONS');
// header("Access-Control-Allow-Headers: X-Requested-With");
header('Content-Type: text/html; charset=utf-8');
header('Content-Type: multipart/form-data');
header('Content-Type: application/x-www-form-urlencoded');
header('Content-Type: application/json');
header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');

// session_cache_limiter(false);

include_once '../include/Config.php';  // Configuration Rest Api

require_once("../../include/dbcommon.php"); // DataBase PHPRunner

// Debug
$debugCode = false;
custom_error(1,"URL ejecutada: ".$_SERVER["REQUEST_URI"]); // To debug
// $debugCode = false;

// use App\Models\Db;  // Utilizamos la conexión de PHPRunner
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Selective\BasePath\BasePathMiddleware;
use Slim\Factory\AppFactory;

require_once __DIR__ . '/../libs/autoload.php';   // Library SLIM v4

$app = AppFactory::create();

$app->addRoutingMiddleware();
// $app->add(new BasePathMiddleware($app)); // No usar si se ejecuta en subdirectorio
$app->addErrorMiddleware(true, true, true);
$app->addBodyParsingMiddleware();

$app->setBasePath(SCRIPTS_DIR);             // Indica el directorio desde donde está trabajando

// --------------------------------------------------------------------------------------

/* Usando POST para Crear la autenticación de los usuarios */

$app->post('/login', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(400);
    }
    // check for required params
    $param = $request->getParsedBody();
    // custom_error(1001,"Param: ".print_r($param, true)); // To debug
    $verify = verifyRequiredParams(array('login', 'password'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $data = $request->getParsedBody();

    $responseBody = array();
    $param = array();
    //capturamos los parametros recibidos y los almacenamos como un nuevo array
    $param['login']  = $data['login'];
    $param['password'] = $data['password'];
    
    /* Podemos crear un metodo que almacene el nuevo auto, por ejemplo: */
    $login = $db->createSession($param, $request, $response);

    if ( is_array($login) ) {
        $responseBody["error"] = false;
        $responseBody["message_num"] = '001';
        $responseBody["message"] = $errorMessages['001'];
        $responseBody["token"] = $login['uuid'];
        $response->getBody()->write(json_encode($responseBody));

        // session_write_close();  // Save Session // No se usa

        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    } else {
        $responseBody["error"] = true;
        $responseBody["message_num"] = '002';
        $responseBody["message"] = $errorMessages['002'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
});

// --------------------------------------------------------------------------------------

/* Usando POST para Cerrar la autenticación de los usuarios */

$app->post('/logout', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }

    $responseBody = array();
    $param = array();
    //capturamos los parametros recibidos y los almacenamos como un nuevo array
    $param['uuid']  = $verify;
    
    /* Podemos crear un metodo que almacene el nuevo auto, por ejemplo: */
    $login = $db->deleteSession($param, $request, $response);

    if ( !is_array($login) ) {
        $responseBody["error"] = false;
        $responseBody["message_num"] = '008';
        $responseBody["message"] = $errorMessages['008'];
        $responseBody["token"] = $param['uuid'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    } else {
        $responseBody["error"] = true;
        $responseBody["message_num"] = '002';
        $responseBody["message"] = $errorMessages['002'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
});

// --------------------------------------------------------------------------------------

/* Usando POST para crear nuevo usuario */

$app->post('/register', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();
    
    $responseBody = array();

    // check for required params
    $param = $request->getParsedBody();
    $verify = verifyRequiredParams(array('nombre','login','password','email'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    /* Podemos crear un metodo que almacene el nuevo auto, por ejemplo: */
    $respuesta = $db->registerUser($param, $request, $response);

    if ( !is_array($respuesta) ) {
        $responseBody["error"] = false;
        $responseBody["message_num"] = '009';
        $responseBody["message"] = $errorMessages['009'];
        $responseBody["usuario"] = $param['email'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    } else {
        // $responseBody["error"] = true;
        // $responseBody["message_num"] = '002';
        // $responseBody["message"] = $errorMessages['002'];
        $response->getBody()->write(json_encode($respuesta));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
});
// --------------------------------------------------------------------------------------

/* Listado el grupo (de compras) al que se asocia en la sessión */

$app->get('/listGroup', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;  // UUID del usuario conectado
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    // $idUser = $userPriv['dataUser']['idct_usuario'];      // Acceso a la información del Usuario

    $responseBody = array();
    
    $verify = $db->listadoGrupos($userPriv, $uuid, $request, $response); // Listado de Grupos del Usuario
    
    if ($verify['error']) { // Si ha habido error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $responseBody["error"] = false;
    $responseBody["message_num"] = '000';
    $responseBody["message"] = ''; 
    $response->getBody()->write(json_encode($verify,JSON_NUMERIC_CHECK));

    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);

});
// --------------------------------------------------------------------------------------

/* Usando POST para Añadir  Documentos del directorio posicionado */

$app->post('/selectGroup', function(Request $request, Response $response) {

    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    // check for required params
    $param = $request->getParsedBody();

    $verify = verifyRequiredParams(array('grupo'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);

    $verify = $db->seleccionGrupo($userPriv, $uuid, $param ,$request, $response);  // Fijar el grupo
    
    if ($verify['error']) { // Si ha habido error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $responseBody["error"] = false;
    $responseBody["message_num"] = '000';
    $responseBody["message"] = ''; 
    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));

    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});

// --------------------------------------------------------------------------------------

/* 
 * Listado de los producto de la lista de Compra según estado (pendientes,hoy,comprados)
 */
$app->post('/listadoCompra/{action}', function(Request $request, Response $response, array $args) {

    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    // check for required params
    $param = array();
    $param['action'] = $args['action'];

    $verify = verifyRequiredParams(array('action'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('pendientes','hoy','comprados')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '013';
        $responseBody["message"] = $errorMessages['013'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    $responseBody = groupInSession($userPriv);// Control de existen de lista de Compra
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    $data = $db->listadoCompra($userPriv,$param,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);

});
/* 
 * Listado de los producto de la lista de Compra 
 */
$app->post('/listadoProductos', function(Request $request, Response $response, array $args) {

    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra(); 

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);

    $data = $db->listadoProductos($userPriv,$param,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
/* 
 * Listado de las Unidades
 */
$app->post('/listadoUnidades', function(Request $request, Response $response, array $args) {

    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();   

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    
    $data = $db->listadoUnidades($userPriv,$param,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update, delete y check comprado..... del Producto de una lista 
*/
$app->post('/compra/{action}/{id_producto}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();
    
    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id_producto'] = $args['id_producto'];

    $verify = verifyRequiredParams(array('action','id_producto'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add','view','update','delete','check')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '013';
        $responseBody["message"] = $errorMessages['013'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    
    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('idct_producto','cantidad','unidad'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addCompra($userPriv,$param2,$request, $response );
        break;
    case 'view':
        $data = $db->viewCompra($userPriv,$param,$request, $response );
        break;
    case 'update':
                // check for required params
        $param2 = $request->getParsedBody();
        $param2['action'] = $args['action'];
        $param2['id_producto'] = $args['id_producto'];

        $verify = verifyRequiredParams(array('idct_producto','cantidad','unidad'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->updateCompra($userPriv,$param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteCompra($userPriv,$param,$request, $response );
        break;
    case 'check':
        $data = $db->checkCompra($userPriv,$param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});
// --------------------------------------------------------------------------------------
/* 
 * Listado de los producto de la lista de Compra según estado
 */
$app->post('/productoList', function(Request $request, Response $response, array $args) {

    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    $responseBody = groupInSession($userPriv);// Control de existen de lista de Compra
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }         
    $data = $db->listadoProductoGrupo($userPriv,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update y delete  del Producto de una lista */

$app->post('/producto/{action}/{id_producto}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra(); 
    
    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id_producto'] = $args['id_producto'];

    $verify = verifyRequiredParams(array('action','id_producto'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add','view','update','delete')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '015';
        $responseBody["message"] = $errorMessages['015'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);

    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('Nombre','cantidad','unidad'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addProducto($userPriv, $uuid, $param2,$request, $response );
        break;
    case 'view':
        $data = $db->viewProducto($userPriv,$param,$request, $response );
        break;
    case 'update':
                // check for required params
        $param2 = $request->getParsedBody();
        $param2['action'] = $args['action'];
        $param2['id_producto'] = $args['id_producto'];
        // custom_error(40010,"Producto -Update = Param: ".print_r($param2, true)); // To debug

        $verify = verifyRequiredParams(array('Nombre','cantidad','unidad','deletefoto'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->updateProducto($userPriv,$uuid, $param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteProducto($userPriv,$param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});
/* 
 * Listado de los Grupos del ususario conectado
 */
$app->post('/usersGroupList', function(Request $request, Response $response, array $args) {

    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra(); 

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    $responseBody = groupInSession($userPriv);// Control de existen de lista de Compra
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }         
    $data = $db->listadoUsersGroup($userPriv,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
/* 
 * Listado de los Grupos del ususario conectado
 */
$app->post('/grupoList', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    $responseBody = groupInSession($userPriv);// Control de existen de lista de Compra
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }         
    $data = $db->listadoGruposUser($userPriv,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update y delete  del Producto de una lista */
$app->post('/grupo/{action}/{id_row}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();
    
    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id_row'] = $args['id_row'];

    $verify = verifyRequiredParams(array('action','id_row'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add', 'view' ,'update','delete')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '018';
        $responseBody["message"] = $errorMessages['018'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);

    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('Nombre','Descripcion'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addGrupo($userPriv, $uuid, $param2,$request, $response );
        break;
     case 'view':
        $data = $db->viewGrupo($userPriv,$param,$request, $response );
        break;
    case 'update':
                // check for required params
        $param2 = $request->getParsedBody();
        $param2['action'] = $args['action'];
        $param2['id_row'] = $args['id_row'];
        // custom_error(40010,"Producto -Update = Param: ".print_r($param2, true)); // To debug

        $verify = verifyRequiredParams(array('Nombre','Administrador'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->updateGrupo($userPriv,$uuid, $param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteGrupo($userPriv,$param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});
/* 
 * Listado de los usuarios del Grupo del ususario conectado
 */
$app->post('/userList', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    $responseBody = groupInSession($userPriv);// Control de existen de lista de Compra
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }         
    $data = $db->listadoUsersInGroup($userPriv,$request, $response );   // Control acceso la directorio y documento

    $response->getBody()->write($data);
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});

// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update y delete  del Producto de una lista */
$app->post('/user/{action}/{id_row}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();
    
    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id_row'] = $args['id_row'];

    $verify = verifyRequiredParams(array('action','id_row'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add','delete')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '018';
        $responseBody["message"] = $errorMessages['018'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);

    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('id'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addUser($userPriv, $uuid, $param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteUser($userPriv,$param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});
/* 
 * Listado de los usuarios del Grupo del ususario conectado
 */
$app->post('/userSearchEmail', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();   

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    
    $responseBody = groupInSession($userPriv);// Control de existen de lista de Compra
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    // check for required params
    $param = $request->getParsedBody();

    $verify = verifyRequiredParams(array('email'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $data = $db->userSearchEmail($userPriv, $uuid, $param,$request, $response );

    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
/* 
 * Listado de los usuarios del Grupo del ususario conectado
 */
$app->post('/userConnect', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();  

    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    
    $responseBody = groupInSession($userPriv);// Control de existen Grupo
    if ( is_array($responseBody)) {     // Falta Lista de compra
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
    $data = $db->userConnect($userPriv, $uuid, $request, $response );

    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});







// --------------------------------------------------------------------------------------
/* Usando POST para add nueva imagen Teporal */

$app->post('/image/add', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbCompra.php';
    $db = new DbCompra();
    // custom_error(4,"Inicio ejecución /mage/add "); // To debug
    
    // Verify Token of Access
    $verify = $db->controlSession($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $uuid = $verify;
    
    // check for required params
    $param = $request->getParsedBody();
    // custom_error(5,"Contenido de PARAM ",print_r($param,true)); // To debug

    $verify = verifyRequiredParams(array('filename'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    $userInfo = $db->openSession($uuid); 
    $userPriv = json_decode($userInfo, true);
    
    $uploadedFiles = $request->getUploadedFiles(); // Recupra nombres de ficheros temporales.
    // custom_error(1,"Contenido de UPLOADFILES ",print_r($uploadFiles,true)); // To debug
    $uploadedFile = $uploadedFiles['file'];
    $param['file'] = $uploadedFile;

    $data = $db->createDataFile($userPriv, $uuid ,$param, $request, $response);
    
    if ($data['error'] == true ) {
        $response->getBody()->write(json_encode($data));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    $responseBody= array();
    $responseBody["error"] = false;
    $responseBody["message_num"] = '017';
    $responseBody["message"] = $errorMessages['017'];
    $responseBody["filename"] = $param['filename'];   
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});

/* corremos la aplicación */
$app->run();

/*********************** USEFULL FUNCTIONS **************************************/

