<?php
/**
 * PHP Restore MySQL Database
 * @author harisrozak and Modify for FHumanes
 */
 
// To debug PHP code on the server
function custom_error($number,$text){ // Function to produce the error file
    $ddf = fopen(__DIR__ .'/../error.log','a');
    fwrite($ddf,"[".date("r")."] Error $number: $text\r\n");
    fclose($ddf);
}


custom_error(1,"Se inicia el proceso del Restore de la BD"); // To debug

// require_once("../include/dbcommon.php"); // DataBase PHPRunner

// $file_restore = $params["file_restore"];

custom_error(2,"El fichero solicitado para el Restore es: ".$file_restore); // To debug
$_SESSION['db_file_restore'] = __DIR__.'/backup_files/'.$file_restore;

$ResetDB = new ResetDB();

$message_user = '';

$message_user = $ResetDB->do_reset();

custom_error(4,"Se ha acabado el proceso de Recuperacion con: ".$message_user); // To debug

unset($_SESSION['db_file_restore']); 

Class ResetDB
{	
	function __construct()
	{	
		$this->cred['host']	= $_SESSION['db_host'];
		$this->cred['user']	= $_SESSION['db_user'];
		$this->cred['passwd'] 	= $_SESSION['db_pwd'];
        $this->cred['port'] 	= $_SESSION['db_port'];
		$this->cred['dbName'] 	= $_SESSION['db_sys_dbname'];
		$this->cred['dumpdir'] 	= $_SESSION['db_file_restore'];
		$this->cred['prefix']	= "";
                
		$this->mysqli = new mysqli($this->cred['host'],$this->cred['user'],$this->cred['passwd'],$this->cred['dbName'],$this->cred['port']);
	}

	public function do_reset()
	{
		$connection = $this->connection();

		if($connection['status'])
		{
			$this->drop_tables();
			$this->restore_tables();

			return "Restore database finished! See file 'error.log' for detail";
		}
		else
		{
			return 'Error: '. $connection['message'];
		}
	}

	private function connection()
	{
		$return = array(
			'status' => true,
			'message' => 'Invalid credential'
		);

		// mysql connect check		
		if($this->mysqli->connect_errno) {
			$return['status'] = false;
			$return['message'] = "Connection failed: %s\n".$this->mysqli->connect_errno;			
		}

		return $return;
	}

	private function drop_tables()
	{
		$prefix = $this->cred['prefix']; // default wordpress
		$prefix_woo = $this->cred['prefix'].'woocommerce_'; // woocomerce

		$sql = "DROP TABLE IF EXISTS {$prefix}commentmeta,{$prefix}comments,{$prefix}links,
			{$prefix}options,{$prefix}postmeta,{$prefix}posts,{$prefix}terms,
			{$prefix}term_relationships,{$prefix}term_taxonomy,
			{$prefix}usermeta,{$prefix}users,
			{$prefix_woo}attribute_taxonomies,{$prefix_woo}downloadable_product_permissions,
			{$prefix_woo}order_itemmeta,{$prefix_woo}order_items,
			{$prefix_woo}tax_rates,{$prefix_woo}tax_rate_locations,
			{$prefix_woo}termmeta;";

		$this->mysqli->query($sql) or die($this->mysqli->error);
	}

	private function restore_tables()
	{
		$templine = '';
		$lines = file($this->cred['dumpdir']);
	
		foreach ($lines as $line)
		{
			if (substr($line, 0, 2) == '--' || $line == '')
			continue;

			$templine .= $line;
	
			if (substr(trim($line), -1, 1) == ';')
			{
				$this->mysqli->query($templine) or custom_error(3,"Error en sentencia: ".print('Error performing query \'<strong>' . $templine . '\': ' . mysql_error() . '<br /><br />'));
				$templine = '';
			}
		}
	}
}
