<?php

/**
 *
 * @About:      Gestión de Datos Electorales de la Comunidad de Madrid
 * @File:       DbElecciones.php
 * @Date:       $Date:$ Ene 2025
 * @Version:    $Rev:$ 1.0
 * @Developer:  fernando humanes
 **/

    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Selective\BasePath\BasePathMiddleware;
    use Slim\Factory\AppFactory;

class DbLicense
{

    private $connDB;

    function __construct()
    {
        global $conn;               // Connection data base of PHPRunner
        $this->connDB = $conn;      // No se usa esta conexión si está integrado con PHPRunner
    }
    /*
     * Grabar el registro de LOG de Accesos
     */
    private function writeLogOk($data)
    {
        $data['status']= 1;
        DB::Insert("access_log", $data );
        return;
    }
    
    private function writeLogKo($data)
    {
        $data['status']= 0;
        DB::Insert("access_log", $data );
        return;
    }

    /*
    * Listado de Convocatorias
    */
    public function conexEmpresa($param, Request $request,Response $response)
    {
        global $errorMessages;
        $apiKey = $param['apiKey'];

        $date_log = $now = date("Y-m-d H:i.s");
        $acces_log = ['corporateName'=>'','apiKey'=>$apiKey,'IP'=>$_SERVER['REMOTE_ADDR'],'petitionDate'=>$date_log,'status'=>'0'];
        
        if ($apiKey == null) {
            $this->writeLogKo($acces_log);
            return ['error' => true,"message_num" => '004',"message" => $errorMessages['004']] ;  // error;  // error
        }      
        $sql = "
        SELECT
        *
        FROM company_license
        WHERE apiKey = '$apiKey'";
        $rs = DB::Query($sql);

        $data = $rs->fetchAssoc();
        if ( $data == null ) {
            $this->writeLogKo($acces_log);
            return ['error' => true,"message_num" => '005',"message" => $errorMessages['005']] ;  // error
        }
        $acces_log['corporateName'] = $data['corporateName'];
        
        $now = date("Y-m-d");
        if ($data['InService'] <> 1 ) {
            $this->writeLogKo($acces_log);
            return ['error' => true,"message_num" => '006',"message" => $errorMessages['006']] ;  // error
        }
        if (! ( $data['InitialServiceDate'] <= $now && $data['FinalServiceDate'] >= $now) ) {
            $this->writeLogKo($acces_log);
            return ['error' => true,"message_num" => '007',"message" => $errorMessages['007']] ;  // error
        }
        $this->writeLogOk($acces_log);
        return ['error' => false,"message_num" => '000',"message" => "", "data" => $data ];
        
    }

}
