<?php 

// Database connection || Conexión a la base de datos

require_once __DIR__ . '/unirest_3.0.4/autoload.php';
require_once __DIR__.'/notifyError.php';
// Identification of the company || Identificación de la Empresa 
$key_business = '3eb4ad35fcceaafcf192a1a810593577';

// Control para verificar que se ha identificado en esta aplicación. Requerido por compartir identificación cookie de de sessión
// Control to verify that it has been identified in this application. Required for sharing cookie of session
if (isset($_SESSION['key_business'])) {
    if ($_SESSION['key_business'] <> $key_business ){
        unset($_SESSION['key_business']);
        //**********  Redirect to another page  ************
        header("Location: login.php?a=logout"); // User session is closed if not entry into this || Se cierra sesión de usuario si no se ha entrada en esta
        exit();
    }
} else {
    $response = Unirest\Request::post("http://localhost/license/restapi/v1/conexEmpresa/".$key_business,
        array("Authorization" => "3d524a53c110e4c22463b10ed32cef9d")
		);
		$a = $response->code;        // HTTP Status code
		$b = $response->headers;     // Headers
		$c = $response->body;        // Parsed body
		$d = $response->raw_body;    // Unparsed body
		$f = json_decode($d,true);

    if ($a <> 200 || !is_array($f)){
        NotifyError("Se ha producido error al conectar con el servidor de licencias. Error: ".$a." Message: ".$d);
        exit();
    }
    if ($f['error']){
        NotifyError("Se ha producido error al acceder al contrato de la Empresa. Error: ".$f['message']);
        exit();        
    }
    
    $_SESSION['business_data'] =$f['data'];
    $_SESSION['key_business'] = $key_business; 
}
$host=$_SESSION['business_data']['DbHostConnection'];
$user=$_SESSION['business_data']['DbUserConnection'];
$pwd=$_SESSION['business_data']['DbPwdConnection'];
$port=$_SESSION['business_data']['DbPortConnection']<> null?$f['data']['DbPortConnection']:3306;
$sys_dbname=$_SESSION['business_data']['DbDbnameConnection'];  // Database


// Company customization variables || Variables de personalización de la Empresa
$_SESSION['business']=$_SESSION['business_data']['corporateName'];
$_SESSION["app-title"] = $_SESSION['business_data']['corporateName'];  // Mandatory that they are session variables || Obligatorio que sean variables de sesión 
// All the variables that are required || Todas las variables que se requieram
