/*!
 * TOAST UI Grid
 * @version 4.21.22 | Wed Jan 10 2024
 * @author NHN Cloud. FE Development Lab
 * @license MIT
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("tui-date-picker"), require("tui-pagination"), require("xlsx"));
	else if(typeof define === 'function' && define.amd)
		define(["tui-date-picker", "tui-pagination", "xlsx"], factory);
	else if(typeof exports === 'object')
		exports["Grid"] = factory(require("tui-date-picker"), require("tui-pagination"), require("xlsx"));
	else
		root["tui"] = root["tui"] || {}, root["tui"]["Grid"] = factory(root["tui"]["DatePicker"], root["tui"]["Pagination"], root["XLSX"]);
})(window, function(__WEBPACK_EXTERNAL_MODULE__44__, __WEBPACK_EXTERNAL_MODULE__122__, __WEBPACK_EXTERNAL_MODULE__129__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/dist";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 63);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getLongestText = exports.pixelToNumber = exports.isBetween = exports.silentSplice = exports.convertDataToText = exports.convertTextToData = exports.endsWith = exports.startsWith = exports.uniqByProp = exports.uniq = exports.pick = exports.omit = exports.pruneObject = exports.debounce = exports.convertToNumber = exports.fromArray = exports.isEmpty = exports.isNil = exports.isString = exports.isNumber = exports.isBoolean = exports.isNull = exports.isUndefined = exports.isBlank = exports.last = exports.range = exports.clamp = exports.setDefaultProp = exports.encodeHTMLEntity = exports.hasOwnProp = exports.forEachObject = exports.isObject = exports.isFunction = exports.createMapFromArray = exports.removeArrayItem = exports.assign = exports.deepCopy = exports.deepCopyArray = exports.deepMergedCopy = exports.mapProp = exports.findOffsetIndex = exports.findPrevIndex = exports.findIndexes = exports.findPropIndex = exports.findIndex = exports.someProp = exports.some = exports.findProp = exports.find = exports.includes = exports.pipe = exports.sum = exports.arrayEqual = exports.shallowEqual = void 0;
var tslib_1 = __webpack_require__(1);
var CUSTOM_LF_SUBCHAR = '___tui_grid_lf___';
var CUSTOM_CR_SUBCHAR = '___tui_grid_cr___';
var LF = '\n';
var CR = '\r';
var CUSTOM_LF_REGEXP = new RegExp(CUSTOM_LF_SUBCHAR, 'g');
var CUSTOM_CR_REGEXP = new RegExp(CUSTOM_CR_SUBCHAR, 'g');
function shallowEqual(o1, o2) {
    for (var key in o1) {
        if (o1[key] !== o2[key]) {
            return false;
        }
    }
    for (var key in o2) {
        if (!(key in o1)) {
            return false;
        }
    }
    return true;
}
exports.shallowEqual = shallowEqual;
function arrayEqual(a1, a2) {
    if (a1.length !== a2.length) {
        return false;
    }
    for (var i = 0, len = a1.length; i < len; i += 1) {
        if (a1[i] !== a2[i]) {
            return false;
        }
    }
    return true;
}
exports.arrayEqual = arrayEqual;
function sum(nums) {
    return nums.reduce(function (acc, num) { return acc + num; }, 0);
}
exports.sum = sum;
function pipe(initVal) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return args.reduce(function (acc, fn) { return fn(acc); }, initVal);
}
exports.pipe = pipe;
function includes(arr, searchItem, searchIndex) {
    if (typeof searchIndex === 'number' && arr[searchIndex] !== searchItem) {
        return false;
    }
    for (var _i = 0, arr_1 = arr; _i < arr_1.length; _i++) {
        var item = arr_1[_i];
        if (item === searchItem) {
            return true;
        }
    }
    return false;
}
exports.includes = includes;
// eslint-disable-next-line consistent-return
function find(predicate, arr) {
    for (var _i = 0, arr_2 = arr; _i < arr_2.length; _i++) {
        var item = arr_2[_i];
        if (predicate(item)) {
            return item;
        }
    }
}
exports.find = find;
function findProp(propName, value, arr) {
    return find(function (item) { return item[propName] === value; }, arr);
}
exports.findProp = findProp;
function some(predicate, arr) {
    return !!find(predicate, arr);
}
exports.some = some;
function someProp(propName, value, arr) {
    return !!findProp(propName, value, arr);
}
exports.someProp = someProp;
function findIndex(predicate, arr) {
    for (var i = 0, len = arr.length; i < len; i += 1) {
        if (predicate(arr[i])) {
            return i;
        }
    }
    return -1;
}
exports.findIndex = findIndex;
function findPropIndex(propName, value, arr) {
    return findIndex(function (item) { return item[propName] === value; }, arr);
}
exports.findPropIndex = findPropIndex;
function findIndexes(predicate, arr) {
    return arr.reduce(function (acc, v, idx) { return (predicate(v) ? tslib_1.__spreadArrays(acc, [idx]) : acc); }, []);
}
exports.findIndexes = findIndexes;
function findPrevIndex(arr, predicate) {
    var index = findIndex(predicate, arr);
    var positiveIndex = index <= 0 ? 0 : index - 1;
    return index >= 0 ? positiveIndex : arr.length - 1;
}
exports.findPrevIndex = findPrevIndex;
function findOffsetIndex(offsets, targetOffset) {
    return findPrevIndex(offsets, function (offset) { return offset > targetOffset; });
}
exports.findOffsetIndex = findOffsetIndex;
function mapProp(propName, arr) {
    return arr.map(function (item) { return item[propName]; });
}
exports.mapProp = mapProp;
function deepMergedCopy(targetObj, obj) {
    var resultObj = tslib_1.__assign({}, targetObj);
    Object.keys(obj).forEach(function (prop) {
        if (isObject(resultObj[prop])) {
            if (Array.isArray(obj[prop])) {
                resultObj[prop] = deepCopyArray(obj[prop]);
            }
            else if (resultObj.hasOwnProperty(prop)) {
                resultObj[prop] = deepMergedCopy(resultObj[prop], obj[prop]);
            }
            else {
                resultObj[prop] = deepCopy(obj[prop]);
            }
        }
        else {
            resultObj[prop] = obj[prop];
        }
    });
    return resultObj;
}
exports.deepMergedCopy = deepMergedCopy;
function deepCopyArray(items) {
    return items.map(function (item) {
        if (isObject(item)) {
            return Array.isArray(item) ? deepCopyArray(item) : deepCopy(item);
        }
        return item;
    });
}
exports.deepCopyArray = deepCopyArray;
function deepCopy(obj) {
    var resultObj = {};
    var keys = Object.keys(obj);
    if (!keys.length) {
        return obj;
    }
    keys.forEach(function (prop) {
        if (isObject(obj[prop])) {
            resultObj[prop] = Array.isArray(obj[prop]) ? deepCopyArray(obj[prop]) : deepCopy(obj[prop]);
        }
        else {
            resultObj[prop] = obj[prop];
        }
    });
    return resultObj;
}
exports.deepCopy = deepCopy;
function assign(targetObj, obj) {
    Object.keys(obj).forEach(function (prop) {
        if (targetObj.hasOwnProperty(prop) && typeof targetObj[prop] === 'object') {
            if (Array.isArray(obj[prop])) {
                targetObj[prop] = obj[prop];
            }
            else {
                assign(targetObj[prop], obj[prop]);
            }
        }
        else {
            targetObj[prop] = obj[prop];
        }
    });
}
exports.assign = assign;
function removeArrayItem(targetItem, arr) {
    var targetIdx = findIndex(function (item) { return item === targetItem; }, arr);
    if (targetIdx !== -1) {
        arr.splice(targetIdx, 1);
    }
    return arr;
}
exports.removeArrayItem = removeArrayItem;
function createMapFromArray(arr, propName) {
    var resultMap = {};
    arr.forEach(function (item) {
        var key = String(item[propName]);
        resultMap[key] = item;
    });
    return resultMap;
}
exports.createMapFromArray = createMapFromArray;
function isFunction(obj) {
    return typeof obj === 'function';
}
exports.isFunction = isFunction;
function isObject(obj) {
    return typeof obj === 'object' && obj !== null;
}
exports.isObject = isObject;
function forEachObject(fn, obj) {
    for (var key in obj) {
        if (obj.hasOwnProperty(key)) {
            fn(obj[key], key, obj);
        }
    }
}
exports.forEachObject = forEachObject;
function hasOwnProp(obj, key) {
    return obj.hasOwnProperty(key);
}
exports.hasOwnProp = hasOwnProp;
function encodeHTMLEntity(html) {
    var entities = {
        '"': 'quot',
        '&': 'amp',
        '<': 'lt',
        '>': 'gt',
        "'": '#39',
    };
    return html.replace(/[<>&"']/g, function (match) { return "&" + entities[match] + ";"; });
}
exports.encodeHTMLEntity = encodeHTMLEntity;
function setDefaultProp(obj, key, defValue) {
    if (isUndefined(obj[key]) || isNull(obj[key])) {
        obj[key] = defValue;
    }
}
exports.setDefaultProp = setDefaultProp;
/**
 * Returns a number whose value is limited to the given range.
 * @param value - A number to force within given min-max range
 * @param min - The lower boundary of the output range
 * @param max - The upper boundary of the output range
 * @returns A number in the range [min, max]
 * @example
 *      // limit the output of this computation to between 0 and 255
 *      value = clamp(value, 0, 255);
 */
function clamp(value, min, max) {
    var _a;
    if (min > max) {
        _a = [min, max], max = _a[0], min = _a[1];
    }
    return Math.max(min, Math.min(value, max));
}
exports.clamp = clamp;
function range(end) {
    var arr = [];
    for (var i = 0; i < end; i += 1) {
        arr.push(i);
    }
    return arr;
}
exports.range = range;
function last(arr) {
    return arr[arr.length - 1];
}
exports.last = last;
function isBlank(value) {
    if (typeof value === 'string') {
        return !value.length;
    }
    return typeof value === 'undefined' || value === null;
}
exports.isBlank = isBlank;
function isUndefined(value) {
    return typeof value === 'undefined';
}
exports.isUndefined = isUndefined;
function isNull(value) {
    return value === null;
}
exports.isNull = isNull;
function isBoolean(value) {
    return typeof value === 'boolean';
}
exports.isBoolean = isBoolean;
function isNumber(value) {
    return typeof value === 'number';
}
exports.isNumber = isNumber;
function isString(value) {
    return typeof value === 'string';
}
exports.isString = isString;
function isNil(value) {
    return isUndefined(value) || isNull(value);
}
exports.isNil = isNil;
/**
 * check the emptiness(included null) of object or array. if obj parameter is null or undefind, return true
 * @param obj - target object or array
 * @returns the emptiness of obj
 */
function isEmpty(obj) {
    return (isNull(obj) ||
        isUndefined(obj) ||
        (!isUndefined(obj.length) && obj.length === 0) ||
        Object.keys(obj).length === 0);
}
exports.isEmpty = isEmpty;
function fromArray(value) {
    return Array.prototype.slice.call(value);
}
exports.fromArray = fromArray;
function convertToNumber(value) {
    if (typeof value === 'number' || isNaN(value) || isBlank(value)) {
        return value;
    }
    return Number(value);
}
exports.convertToNumber = convertToNumber;
function debounce(fn, wait, immediate) {
    if (immediate === void 0) { immediate = false; }
    var timeout = null;
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var later = function () {
            timeout = -1;
            if (!immediate) {
                fn.apply(void 0, args);
            }
        };
        var callNow = immediate && !timeout;
        if (timeout) {
            clearTimeout(timeout);
        }
        timeout = window.setTimeout(later, wait);
        if (callNow) {
            fn.apply(void 0, args);
        }
    };
}
exports.debounce = debounce;
function pruneObject(obj) {
    var pruned = {};
    forEachObject(function (value, key) {
        if (!isUndefined(value) && !isNull(value)) {
            pruned[key] = value;
        }
    }, obj);
    return pruned;
}
exports.pruneObject = pruneObject;
function omit(obj) {
    var propNames = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        propNames[_i - 1] = arguments[_i];
    }
    var resultMap = {};
    Object.keys(obj).forEach(function (key) {
        if (!includes(propNames, key)) {
            resultMap[key] = obj[key];
        }
    });
    return resultMap;
}
exports.omit = omit;
function pick(obj) {
    var propNames = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        propNames[_i - 1] = arguments[_i];
    }
    var resultMap = {};
    Object.keys(obj).forEach(function (key) {
        if (includes(propNames, key)) {
            resultMap[key] = obj[key];
        }
    });
    return resultMap;
}
exports.pick = pick;
function uniq(arr) {
    return arr.filter(function (name, index) { return arr.indexOf(name) === index; });
}
exports.uniq = uniq;
function uniqByProp(propName, arr) {
    return arr.filter(function (obj, index) { return findPropIndex(propName, obj[propName], arr) === index; });
}
exports.uniqByProp = uniqByProp;
function startsWith(str, targetStr) {
    return targetStr.slice(0, str.length) === str;
}
exports.startsWith = startsWith;
function endsWith(str, targetStr) {
    var index = targetStr.lastIndexOf(str);
    return index !== -1 && index + str.length === targetStr.length;
}
exports.endsWith = endsWith;
function removeDoubleQuotes(text) {
    if (text.match(CUSTOM_LF_REGEXP)) {
        return text.substring(1, text.length - 1).replace(/""/g, '"');
    }
    return text;
}
function replaceNewlineToSubchar(text) {
    return text.replace(/"([^"]|"")*"/g, function (value) {
        return value.replace(LF, CUSTOM_LF_SUBCHAR).replace(CR, CUSTOM_CR_SUBCHAR);
    });
}
function convertTextToData(text) {
    // Each newline cell data is wrapping double quotes in the text and
    // newline characters should be replaced with substitution characters temporarily
    // before spliting the text by newline characters.
    text = replaceNewlineToSubchar(text);
    return text
        .split(/\r?\n/)
        .map(function (row) {
        return row
            .split('\t')
            .map(function (column) {
            return removeDoubleQuotes(column).replace(CUSTOM_LF_REGEXP, LF).replace(CUSTOM_CR_REGEXP, CR);
        });
    });
}
exports.convertTextToData = convertTextToData;
function convertDataToText(data, delimiter) {
    return data.map(function (row) { return "\"" + row.join("\"" + delimiter + "\"") + "\""; }).join('\n');
}
exports.convertDataToText = convertDataToText;
function silentSplice(arr, start, deleteCount) {
    var _a;
    var items = [];
    for (var _i = 3; _i < arguments.length; _i++) {
        items[_i - 3] = arguments[_i];
    }
    return (_a = Array.prototype.splice).call.apply(_a, tslib_1.__spreadArrays([arr, start, deleteCount], items));
}
exports.silentSplice = silentSplice;
function isBetween(value, start, end) {
    return start <= value && value <= end;
}
exports.isBetween = isBetween;
function pixelToNumber(pixelString) {
    var regExp = new RegExp(/[0-9]+px/);
    return regExp.test(pixelString) ? parseInt(pixelString.replace('px', ''), 10) : 0;
}
exports.pixelToNumber = pixelToNumber;
function getLongestText(texts) {
    return texts.reduce(function (acc, text) { return (text.length > acc.length ? text : acc); }, '');
}
exports.getLongestText = getLongestText;


/***/ }),
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__extends", function() { return __extends; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__assign", function() { return __assign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__rest", function() { return __rest; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__decorate", function() { return __decorate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__param", function() { return __param; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__metadata", function() { return __metadata; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__awaiter", function() { return __awaiter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__generator", function() { return __generator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__exportStar", function() { return __exportStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__values", function() { return __values; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__read", function() { return __read; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__spread", function() { return __spread; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__spreadArrays", function() { return __spreadArrays; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__await", function() { return __await; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__asyncGenerator", function() { return __asyncGenerator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__asyncDelegator", function() { return __asyncDelegator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__asyncValues", function() { return __asyncValues; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__makeTemplateObject", function() { return __makeTemplateObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__importStar", function() { return __importStar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__importDefault", function() { return __importDefault; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__classPrivateFieldGet", function() { return __classPrivateFieldGet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "__classPrivateFieldSet", function() { return __classPrivateFieldSet; });
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __exportStar(m, exports) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result.default = mod;
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, privateMap) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to get private field on non-instance");
    }
    return privateMap.get(receiver);
}

function __classPrivateFieldSet(receiver, privateMap, value) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to set private field on non-instance");
    }
    privateMap.set(receiver, value);
    return value;
}


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isElementScrollable = exports.getComputedFontStyle = exports.getTextWidth = exports.setClipboardSelection = exports.isSupportWindowClipboardData = exports.convertTableToData = exports.getCoordinateWithOffset = exports.setCursorStyle = exports.appendStyleElement = exports.getCellAddress = exports.isParentExistWithClassNames = exports.findParentByClassName = exports.findParentByTagName = exports.hasClass = exports.isDatePickerElement = exports.cls = exports.dataAttr = void 0;
var common_1 = __webpack_require__(0);
var CLS_PREFIX = 'tui-grid-';
exports.dataAttr = {
    ROW_KEY: 'data-row-key',
    COLUMN_NAME: 'data-column-name',
    COLUMN_INDEX: 'data-column-index',
    GRID_ID: 'data-grid-id',
};
function cls() {
    var names = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        names[_i] = arguments[_i];
    }
    var result = [];
    for (var _a = 0, names_1 = names; _a < names_1.length; _a++) {
        var name = names_1[_a];
        var className = void 0;
        if (Array.isArray(name)) {
            className = name[0] ? name[1] : null;
        }
        else {
            className = name;
        }
        if (className) {
            result.push("" + CLS_PREFIX + className);
        }
    }
    return result.join(' ');
}
exports.cls = cls;
function isSvgElement(el) {
    var _a;
    return ((_a = el.namespaceURI) === null || _a === void 0 ? void 0 : _a.indexOf('svg')) !== -1;
}
function isDatePickerElement(el) {
    var currentEl = el;
    if (isSvgElement(el)) {
        return false;
    }
    while (currentEl && currentEl.className.split(' ').indexOf('tui-datepicker') === -1) {
        currentEl = currentEl.parentElement;
    }
    return !!currentEl;
}
exports.isDatePickerElement = isDatePickerElement;
function hasClass(el, className) {
    return !isSvgElement(el) && el.className.split(' ').indexOf(cls(className)) !== -1;
}
exports.hasClass = hasClass;
function findParentByTagName(el, tagName) {
    var currentEl = el;
    while (currentEl && currentEl.tagName.toLowerCase() !== tagName) {
        currentEl = currentEl.parentElement;
    }
    return currentEl;
}
exports.findParentByTagName = findParentByTagName;
function findParentByClassName(el, className) {
    var currentEl = el;
    while (currentEl && !hasClass(currentEl, className)) {
        currentEl = currentEl.parentElement;
    }
    return currentEl;
}
exports.findParentByClassName = findParentByClassName;
function isParentExistWithClassNames(el, classNames) {
    return classNames.some(function (className) { return !common_1.isNull(findParentByClassName(el, className)); });
}
exports.isParentExistWithClassNames = isParentExistWithClassNames;
function getCellAddress(el) {
    var cellElement = findParentByTagName(el, 'td');
    if (!cellElement) {
        return null;
    }
    var rowKey = cellElement.getAttribute(exports.dataAttr.ROW_KEY);
    var columnName = cellElement.getAttribute(exports.dataAttr.COLUMN_NAME);
    if (common_1.isNull(rowKey)) {
        return null;
    }
    return {
        rowKey: Number(rowKey),
        columnName: columnName,
    };
}
exports.getCellAddress = getCellAddress;
/**
 * create style element and append it into the head element.
 * @param {String} id - element id
 * @param {String} cssString - css string
 */
function appendStyleElement(id, cssString) {
    var style = document.createElement('style');
    style.type = 'text/css';
    style.id = id;
    style.appendChild(document.createTextNode(cssString));
    document.getElementsByTagName('head')[0].appendChild(style);
}
exports.appendStyleElement = appendStyleElement;
function setCursorStyle(type) {
    document.body.style.cursor = type;
}
exports.setCursorStyle = setCursorStyle;
function getCoordinateWithOffset(pageX, pageY) {
    var pageXWithOffset = pageX - window.pageXOffset;
    var pageYWithOffset = pageY - window.pageYOffset;
    return [pageXWithOffset, pageYWithOffset];
}
exports.getCoordinateWithOffset = getCoordinateWithOffset;
function setDataInSpanRange(value, data, colspanRange, rowspanRange) {
    var startColspan = colspanRange[0], endColspan = colspanRange[1];
    var startRowspan = rowspanRange[0], endRowspan = rowspanRange[1];
    for (var rowIdx = startRowspan; rowIdx < endRowspan; rowIdx += 1) {
        for (var columnIdx = startColspan; columnIdx < endColspan; columnIdx += 1) {
            data[rowIdx][columnIdx] = startRowspan === rowIdx && startColspan === columnIdx ? value : ' ';
        }
    }
}
function convertTableToData(rows) {
    var data = [];
    var colspanRange, rowspanRange;
    for (var index = 0; index < rows.length; index += 1) {
        data[index] = [];
    }
    common_1.fromArray(rows).forEach(function (tr, rowIndex) {
        var columnIndex = 0;
        common_1.fromArray(tr.cells).forEach(function (td) {
            var text = td.textContent || td.innerText;
            while (data[rowIndex][columnIndex]) {
                columnIndex += 1;
            }
            colspanRange = [columnIndex, columnIndex + (td.colSpan || 1)];
            rowspanRange = [rowIndex, rowIndex + (td.rowSpan || 1)];
            setDataInSpanRange(text, data, colspanRange, rowspanRange);
            columnIndex = colspanRange[1];
        });
    });
    return data;
}
exports.convertTableToData = convertTableToData;
function isSupportWindowClipboardData() {
    return !!window.clipboardData;
}
exports.isSupportWindowClipboardData = isSupportWindowClipboardData;
function setClipboardSelection(node) {
    if (node) {
        var range = document.createRange();
        var selection = window.getSelection();
        selection.removeAllRanges();
        range.selectNodeContents(node);
        selection.addRange(range);
    }
}
exports.setClipboardSelection = setClipboardSelection;
function getTextWidth(text, bodyArea) {
    if (!bodyArea) {
        return 0;
    }
    var tdForMeasure = document.createElement('td');
    tdForMeasure.className = cls('cell', 'cell-has-input');
    tdForMeasure.style.position = 'absolute';
    var cellForMeasure = document.createElement('div');
    cellForMeasure.textContent = text;
    cellForMeasure.className = cls('cell-content');
    tdForMeasure.appendChild(cellForMeasure);
    bodyArea.appendChild(tdForMeasure);
    var width = cellForMeasure.clientWidth;
    bodyArea.removeChild(tdForMeasure);
    return Math.ceil(width);
}
exports.getTextWidth = getTextWidth;
function getComputedFontStyle(selector) {
    var firstCellNode = document.querySelector("." + cls(selector));
    var walker = document.createTreeWalker(firstCellNode, 4);
    var node = firstCellNode;
    while (walker.nextNode()) {
        node = walker.currentNode;
        if (node.nodeType === 3) {
            node = node.parentElement;
            break;
        }
    }
    var compStyle = getComputedStyle(node);
    var fontSize = compStyle.getPropertyValue('font-size');
    var fontWeight = compStyle.getPropertyValue('font-weight');
    var fontFamily = compStyle.getPropertyValue('font-family');
    return fontWeight + " " + fontSize + " " + fontFamily;
}
exports.getComputedFontStyle = getComputedFontStyle;
exports.isElementScrollable = function (element) {
    var offsetHeight = element.offsetHeight, offsetWidth = element.offsetWidth, scrollHeight = element.scrollHeight, scrollWidth = element.scrollWidth, scrollTop = element.scrollTop, scrollLeft = element.scrollLeft;
    return {
        canScrollUp: scrollTop > 0,
        canScrollDown: scrollTop + offsetHeight < scrollHeight,
        canScrollLeft: scrollLeft > 0,
        canScrollRight: scrollLeft + offsetWidth < scrollWidth,
    };
};


/***/ }),
/* 3 */
/***/ (function(__webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return h; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createElement", function() { return h; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cloneElement", function() { return cloneElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createRef", function() { return createRef; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Component", function() { return Component; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "rerender", function() { return rerender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "options", function() { return options; });
var VNode = function VNode() {};

var options = {};

var stack = [];

var EMPTY_CHILDREN = [];

function h(nodeName, attributes) {
	var children = EMPTY_CHILDREN,
	    lastSimple,
	    child,
	    simple,
	    i;
	for (i = arguments.length; i-- > 2;) {
		stack.push(arguments[i]);
	}
	if (attributes && attributes.children != null) {
		if (!stack.length) stack.push(attributes.children);
		delete attributes.children;
	}
	while (stack.length) {
		if ((child = stack.pop()) && child.pop !== undefined) {
			for (i = child.length; i--;) {
				stack.push(child[i]);
			}
		} else {
			if (typeof child === 'boolean') child = null;

			if (simple = typeof nodeName !== 'function') {
				if (child == null) child = '';else if (typeof child === 'number') child = String(child);else if (typeof child !== 'string') simple = false;
			}

			if (simple && lastSimple) {
				children[children.length - 1] += child;
			} else if (children === EMPTY_CHILDREN) {
				children = [child];
			} else {
				children.push(child);
			}

			lastSimple = simple;
		}
	}

	var p = new VNode();
	p.nodeName = nodeName;
	p.children = children;
	p.attributes = attributes == null ? undefined : attributes;
	p.key = attributes == null ? undefined : attributes.key;

	if (options.vnode !== undefined) options.vnode(p);

	return p;
}

function extend(obj, props) {
  for (var i in props) {
    obj[i] = props[i];
  }return obj;
}

function applyRef(ref, value) {
  if (ref != null) {
    if (typeof ref == 'function') ref(value);else ref.current = value;
  }
}

var defer = typeof Promise == 'function' ? Promise.resolve().then.bind(Promise.resolve()) : setTimeout;

function cloneElement(vnode, props) {
  return h(vnode.nodeName, extend(extend({}, vnode.attributes), props), arguments.length > 2 ? [].slice.call(arguments, 2) : vnode.children);
}

var IS_NON_DIMENSIONAL = /acit|ex(?:s|g|n|p|$)|rph|ows|mnc|ntw|ine[ch]|zoo|^ord/i;

var items = [];

function enqueueRender(component) {
	if (!component._dirty && (component._dirty = true) && items.push(component) == 1) {
		(options.debounceRendering || defer)(rerender);
	}
}

function rerender() {
	var p;
	while (p = items.pop()) {
		if (p._dirty) renderComponent(p);
	}
}

function isSameNodeType(node, vnode, hydrating) {
	if (typeof vnode === 'string' || typeof vnode === 'number') {
		return node.splitText !== undefined;
	}
	if (typeof vnode.nodeName === 'string') {
		return !node._componentConstructor && isNamedNode(node, vnode.nodeName);
	}
	return hydrating || node._componentConstructor === vnode.nodeName;
}

function isNamedNode(node, nodeName) {
	return node.normalizedNodeName === nodeName || node.nodeName.toLowerCase() === nodeName.toLowerCase();
}

function getNodeProps(vnode) {
	var props = extend({}, vnode.attributes);
	props.children = vnode.children;

	var defaultProps = vnode.nodeName.defaultProps;
	if (defaultProps !== undefined) {
		for (var i in defaultProps) {
			if (props[i] === undefined) {
				props[i] = defaultProps[i];
			}
		}
	}

	return props;
}

function createNode(nodeName, isSvg) {
	var node = isSvg ? document.createElementNS('http://www.w3.org/2000/svg', nodeName) : document.createElement(nodeName);
	node.normalizedNodeName = nodeName;
	return node;
}

function removeNode(node) {
	var parentNode = node.parentNode;
	if (parentNode) parentNode.removeChild(node);
}

function setAccessor(node, name, old, value, isSvg) {
	if (name === 'className') name = 'class';

	if (name === 'key') {} else if (name === 'ref') {
		applyRef(old, null);
		applyRef(value, node);
	} else if (name === 'class' && !isSvg) {
		node.className = value || '';
	} else if (name === 'style') {
		if (!value || typeof value === 'string' || typeof old === 'string') {
			node.style.cssText = value || '';
		}
		if (value && typeof value === 'object') {
			if (typeof old !== 'string') {
				for (var i in old) {
					if (!(i in value)) node.style[i] = '';
				}
			}
			for (var i in value) {
				node.style[i] = typeof value[i] === 'number' && IS_NON_DIMENSIONAL.test(i) === false ? value[i] + 'px' : value[i];
			}
		}
	} else if (name === 'dangerouslySetInnerHTML') {
		if (value) node.innerHTML = value.__html || '';
	} else if (name[0] == 'o' && name[1] == 'n') {
		var useCapture = name !== (name = name.replace(/Capture$/, ''));
		name = name.toLowerCase().substring(2);
		if (value) {
			if (!old) node.addEventListener(name, eventProxy, useCapture);
		} else {
			node.removeEventListener(name, eventProxy, useCapture);
		}
		(node._listeners || (node._listeners = {}))[name] = value;
	} else if (name !== 'list' && name !== 'type' && !isSvg && name in node) {
		try {
			node[name] = value == null ? '' : value;
		} catch (e) {}
		if ((value == null || value === false) && name != 'spellcheck') node.removeAttribute(name);
	} else {
		var ns = isSvg && name !== (name = name.replace(/^xlink:?/, ''));

		if (value == null || value === false) {
			if (ns) node.removeAttributeNS('http://www.w3.org/1999/xlink', name.toLowerCase());else node.removeAttribute(name);
		} else if (typeof value !== 'function') {
			if (ns) node.setAttributeNS('http://www.w3.org/1999/xlink', name.toLowerCase(), value);else node.setAttribute(name, value);
		}
	}
}

function eventProxy(e) {
	return this._listeners[e.type](options.event && options.event(e) || e);
}

var mounts = [];

var diffLevel = 0;

var isSvgMode = false;

var hydrating = false;

function flushMounts() {
	var c;
	while (c = mounts.shift()) {
		if (options.afterMount) options.afterMount(c);
		if (c.componentDidMount) c.componentDidMount();
	}
}

function diff(dom, vnode, context, mountAll, parent, componentRoot) {
	if (!diffLevel++) {
		isSvgMode = parent != null && parent.ownerSVGElement !== undefined;

		hydrating = dom != null && !('__preactattr_' in dom);
	}

	var ret = idiff(dom, vnode, context, mountAll, componentRoot);

	if (parent && ret.parentNode !== parent) parent.appendChild(ret);

	if (! --diffLevel) {
		hydrating = false;

		if (!componentRoot) flushMounts();
	}

	return ret;
}

function idiff(dom, vnode, context, mountAll, componentRoot) {
	var out = dom,
	    prevSvgMode = isSvgMode;

	if (vnode == null || typeof vnode === 'boolean') vnode = '';

	if (typeof vnode === 'string' || typeof vnode === 'number') {
		if (dom && dom.splitText !== undefined && dom.parentNode && (!dom._component || componentRoot)) {
			if (dom.nodeValue != vnode) {
				dom.nodeValue = vnode;
			}
		} else {
			out = document.createTextNode(vnode);
			if (dom) {
				if (dom.parentNode) dom.parentNode.replaceChild(out, dom);
				recollectNodeTree(dom, true);
			}
		}

		out['__preactattr_'] = true;

		return out;
	}

	var vnodeName = vnode.nodeName;
	if (typeof vnodeName === 'function') {
		return buildComponentFromVNode(dom, vnode, context, mountAll);
	}

	isSvgMode = vnodeName === 'svg' ? true : vnodeName === 'foreignObject' ? false : isSvgMode;

	vnodeName = String(vnodeName);
	if (!dom || !isNamedNode(dom, vnodeName)) {
		out = createNode(vnodeName, isSvgMode);

		if (dom) {
			while (dom.firstChild) {
				out.appendChild(dom.firstChild);
			}
			if (dom.parentNode) dom.parentNode.replaceChild(out, dom);

			recollectNodeTree(dom, true);
		}
	}

	var fc = out.firstChild,
	    props = out['__preactattr_'],
	    vchildren = vnode.children;

	if (props == null) {
		props = out['__preactattr_'] = {};
		for (var a = out.attributes, i = a.length; i--;) {
			props[a[i].name] = a[i].value;
		}
	}

	if (!hydrating && vchildren && vchildren.length === 1 && typeof vchildren[0] === 'string' && fc != null && fc.splitText !== undefined && fc.nextSibling == null) {
		if (fc.nodeValue != vchildren[0]) {
			fc.nodeValue = vchildren[0];
		}
	} else if (vchildren && vchildren.length || fc != null) {
			innerDiffNode(out, vchildren, context, mountAll, hydrating || props.dangerouslySetInnerHTML != null);
		}

	diffAttributes(out, vnode.attributes, props);

	isSvgMode = prevSvgMode;

	return out;
}

function innerDiffNode(dom, vchildren, context, mountAll, isHydrating) {
	var originalChildren = dom.childNodes,
	    children = [],
	    keyed = {},
	    keyedLen = 0,
	    min = 0,
	    len = originalChildren.length,
	    childrenLen = 0,
	    vlen = vchildren ? vchildren.length : 0,
	    j,
	    c,
	    f,
	    vchild,
	    child;

	if (len !== 0) {
		for (var i = 0; i < len; i++) {
			var _child = originalChildren[i],
			    props = _child['__preactattr_'],
			    key = vlen && props ? _child._component ? _child._component.__key : props.key : null;
			if (key != null) {
				keyedLen++;
				keyed[key] = _child;
			} else if (props || (_child.splitText !== undefined ? isHydrating ? _child.nodeValue.trim() : true : isHydrating)) {
				children[childrenLen++] = _child;
			}
		}
	}

	if (vlen !== 0) {
		for (var i = 0; i < vlen; i++) {
			vchild = vchildren[i];
			child = null;

			var key = vchild.key;
			if (key != null) {
				if (keyedLen && keyed[key] !== undefined) {
					child = keyed[key];
					keyed[key] = undefined;
					keyedLen--;
				}
			} else if (min < childrenLen) {
					for (j = min; j < childrenLen; j++) {
						if (children[j] !== undefined && isSameNodeType(c = children[j], vchild, isHydrating)) {
							child = c;
							children[j] = undefined;
							if (j === childrenLen - 1) childrenLen--;
							if (j === min) min++;
							break;
						}
					}
				}

			child = idiff(child, vchild, context, mountAll);

			f = originalChildren[i];
			if (child && child !== dom && child !== f) {
				if (f == null) {
					dom.appendChild(child);
				} else if (child === f.nextSibling) {
					removeNode(f);
				} else {
					dom.insertBefore(child, f);
				}
			}
		}
	}

	if (keyedLen) {
		for (var i in keyed) {
			if (keyed[i] !== undefined) recollectNodeTree(keyed[i], false);
		}
	}

	while (min <= childrenLen) {
		if ((child = children[childrenLen--]) !== undefined) recollectNodeTree(child, false);
	}
}

function recollectNodeTree(node, unmountOnly) {
	var component = node._component;
	if (component) {
		unmountComponent(component);
	} else {
		if (node['__preactattr_'] != null) applyRef(node['__preactattr_'].ref, null);

		if (unmountOnly === false || node['__preactattr_'] == null) {
			removeNode(node);
		}

		removeChildren(node);
	}
}

function removeChildren(node) {
	node = node.lastChild;
	while (node) {
		var next = node.previousSibling;
		recollectNodeTree(node, true);
		node = next;
	}
}

function diffAttributes(dom, attrs, old) {
	var name;

	for (name in old) {
		if (!(attrs && attrs[name] != null) && old[name] != null) {
			setAccessor(dom, name, old[name], old[name] = undefined, isSvgMode);
		}
	}

	for (name in attrs) {
		if (name !== 'children' && name !== 'innerHTML' && (!(name in old) || attrs[name] !== (name === 'value' || name === 'checked' ? dom[name] : old[name]))) {
			setAccessor(dom, name, old[name], old[name] = attrs[name], isSvgMode);
		}
	}
}

var recyclerComponents = [];

function createComponent(Ctor, props, context) {
	var inst,
	    i = recyclerComponents.length;

	if (Ctor.prototype && Ctor.prototype.render) {
		inst = new Ctor(props, context);
		Component.call(inst, props, context);
	} else {
		inst = new Component(props, context);
		inst.constructor = Ctor;
		inst.render = doRender;
	}

	while (i--) {
		if (recyclerComponents[i].constructor === Ctor) {
			inst.nextBase = recyclerComponents[i].nextBase;
			recyclerComponents.splice(i, 1);
			return inst;
		}
	}

	return inst;
}

function doRender(props, state, context) {
	return this.constructor(props, context);
}

function setComponentProps(component, props, renderMode, context, mountAll) {
	if (component._disable) return;
	component._disable = true;

	component.__ref = props.ref;
	component.__key = props.key;
	delete props.ref;
	delete props.key;

	if (typeof component.constructor.getDerivedStateFromProps === 'undefined') {
		if (!component.base || mountAll) {
			if (component.componentWillMount) component.componentWillMount();
		} else if (component.componentWillReceiveProps) {
			component.componentWillReceiveProps(props, context);
		}
	}

	if (context && context !== component.context) {
		if (!component.prevContext) component.prevContext = component.context;
		component.context = context;
	}

	if (!component.prevProps) component.prevProps = component.props;
	component.props = props;

	component._disable = false;

	if (renderMode !== 0) {
		if (renderMode === 1 || options.syncComponentUpdates !== false || !component.base) {
			renderComponent(component, 1, mountAll);
		} else {
			enqueueRender(component);
		}
	}

	applyRef(component.__ref, component);
}

function renderComponent(component, renderMode, mountAll, isChild) {
	if (component._disable) return;

	var props = component.props,
	    state = component.state,
	    context = component.context,
	    previousProps = component.prevProps || props,
	    previousState = component.prevState || state,
	    previousContext = component.prevContext || context,
	    isUpdate = component.base,
	    nextBase = component.nextBase,
	    initialBase = isUpdate || nextBase,
	    initialChildComponent = component._component,
	    skip = false,
	    snapshot = previousContext,
	    rendered,
	    inst,
	    cbase;

	if (component.constructor.getDerivedStateFromProps) {
		state = extend(extend({}, state), component.constructor.getDerivedStateFromProps(props, state));
		component.state = state;
	}

	if (isUpdate) {
		component.props = previousProps;
		component.state = previousState;
		component.context = previousContext;
		if (renderMode !== 2 && component.shouldComponentUpdate && component.shouldComponentUpdate(props, state, context) === false) {
			skip = true;
		} else if (component.componentWillUpdate) {
			component.componentWillUpdate(props, state, context);
		}
		component.props = props;
		component.state = state;
		component.context = context;
	}

	component.prevProps = component.prevState = component.prevContext = component.nextBase = null;
	component._dirty = false;

	if (!skip) {
		rendered = component.render(props, state, context);

		if (component.getChildContext) {
			context = extend(extend({}, context), component.getChildContext());
		}

		if (isUpdate && component.getSnapshotBeforeUpdate) {
			snapshot = component.getSnapshotBeforeUpdate(previousProps, previousState);
		}

		var childComponent = rendered && rendered.nodeName,
		    toUnmount,
		    base;

		if (typeof childComponent === 'function') {

			var childProps = getNodeProps(rendered);
			inst = initialChildComponent;

			if (inst && inst.constructor === childComponent && childProps.key == inst.__key) {
				setComponentProps(inst, childProps, 1, context, false);
			} else {
				toUnmount = inst;

				component._component = inst = createComponent(childComponent, childProps, context);
				inst.nextBase = inst.nextBase || nextBase;
				inst._parentComponent = component;
				setComponentProps(inst, childProps, 0, context, false);
				renderComponent(inst, 1, mountAll, true);
			}

			base = inst.base;
		} else {
			cbase = initialBase;

			toUnmount = initialChildComponent;
			if (toUnmount) {
				cbase = component._component = null;
			}

			if (initialBase || renderMode === 1) {
				if (cbase) cbase._component = null;
				base = diff(cbase, rendered, context, mountAll || !isUpdate, initialBase && initialBase.parentNode, true);
			}
		}

		if (initialBase && base !== initialBase && inst !== initialChildComponent) {
			var baseParent = initialBase.parentNode;
			if (baseParent && base !== baseParent) {
				baseParent.replaceChild(base, initialBase);

				if (!toUnmount) {
					initialBase._component = null;
					recollectNodeTree(initialBase, false);
				}
			}
		}

		if (toUnmount) {
			unmountComponent(toUnmount);
		}

		component.base = base;
		if (base && !isChild) {
			var componentRef = component,
			    t = component;
			while (t = t._parentComponent) {
				(componentRef = t).base = base;
			}
			base._component = componentRef;
			base._componentConstructor = componentRef.constructor;
		}
	}

	if (!isUpdate || mountAll) {
		mounts.push(component);
	} else if (!skip) {

		if (component.componentDidUpdate) {
			component.componentDidUpdate(previousProps, previousState, snapshot);
		}
		if (options.afterUpdate) options.afterUpdate(component);
	}

	while (component._renderCallbacks.length) {
		component._renderCallbacks.pop().call(component);
	}if (!diffLevel && !isChild) flushMounts();
}

function buildComponentFromVNode(dom, vnode, context, mountAll) {
	var c = dom && dom._component,
	    originalComponent = c,
	    oldDom = dom,
	    isDirectOwner = c && dom._componentConstructor === vnode.nodeName,
	    isOwner = isDirectOwner,
	    props = getNodeProps(vnode);
	while (c && !isOwner && (c = c._parentComponent)) {
		isOwner = c.constructor === vnode.nodeName;
	}

	if (c && isOwner && (!mountAll || c._component)) {
		setComponentProps(c, props, 3, context, mountAll);
		dom = c.base;
	} else {
		if (originalComponent && !isDirectOwner) {
			unmountComponent(originalComponent);
			dom = oldDom = null;
		}

		c = createComponent(vnode.nodeName, props, context);
		if (dom && !c.nextBase) {
			c.nextBase = dom;

			oldDom = null;
		}
		setComponentProps(c, props, 1, context, mountAll);
		dom = c.base;

		if (oldDom && dom !== oldDom) {
			oldDom._component = null;
			recollectNodeTree(oldDom, false);
		}
	}

	return dom;
}

function unmountComponent(component) {
	if (options.beforeUnmount) options.beforeUnmount(component);

	var base = component.base;

	component._disable = true;

	if (component.componentWillUnmount) component.componentWillUnmount();

	component.base = null;

	var inner = component._component;
	if (inner) {
		unmountComponent(inner);
	} else if (base) {
		if (base['__preactattr_'] != null) applyRef(base['__preactattr_'].ref, null);

		component.nextBase = base;

		removeNode(base);
		recyclerComponents.push(component);

		removeChildren(base);
	}

	applyRef(component.__ref, null);
}

function Component(props, context) {
	this._dirty = true;

	this.context = context;

	this.props = props;

	this.state = this.state || {};

	this._renderCallbacks = [];
}

extend(Component.prototype, {
	setState: function setState(state, callback) {
		if (!this.prevState) this.prevState = this.state;
		this.state = extend(extend({}, this.state), typeof state === 'function' ? state(this.state, this.props) : state);
		if (callback) this._renderCallbacks.push(callback);
		enqueueRender(this);
	},
	forceUpdate: function forceUpdate(callback) {
		if (callback) this._renderCallbacks.push(callback);
		renderComponent(this, 2);
	},
	render: function render() {}
});

function render(vnode, parent, merge) {
  return diff(merge, vnode, {}, false, parent, false);
}

function createRef() {
	return {};
}

var preact = {
	h: h,
	createElement: h,
	cloneElement: cloneElement,
	createRef: createRef,
	Component: Component,
	render: render,
	rerender: rerender,
	options: options
};

/* harmony default export */ __webpack_exports__["default"] = (preact);

//# sourceMappingURL=preact.mjs.map


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.connect = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var observable_1 = __webpack_require__(5);
function connect(selector, forceUpdate) {
    return function (WrappedComponent) {
        var _a;
        return _a = /** @class */ (function (_super) {
                tslib_1.__extends(class_1, _super);
                function class_1() {
                    return _super !== null && _super.apply(this, arguments) || this;
                }
                class_1.prototype.setStateUsingSelector = function (ownProps) {
                    if (selector) {
                        this.setState(selector(this.context.store, ownProps));
                        if (forceUpdate) {
                            this.forceUpdate();
                        }
                    }
                };
                class_1.prototype.componentWillMount = function () {
                    var _this = this;
                    if (selector) {
                        this.unobserve = observable_1.observe(function () {
                            _this.setStateUsingSelector(_this.props);
                        });
                    }
                };
                class_1.prototype.componentWillReceiveProps = function (nextProps) {
                    this.setStateUsingSelector(nextProps);
                };
                class_1.prototype.componentWillUnmount = function () {
                    if (this.unobserve) {
                        this.unobserve();
                    }
                };
                class_1.prototype.render = function () {
                    var _a = this, props = _a.props, state = _a.state;
                    var dispatch = this.context.dispatch;
                    return preact_1.h(WrappedComponent, tslib_1.__assign({}, props, state, { dispatch: dispatch }));
                };
                return class_1;
            }(preact_1.Component)),
            _a.displayName = "Connect:" + WrappedComponent.name,
            _a;
    };
}
exports.connect = connect;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.asyncInvokeObserver = exports.batchObserver = exports.unobservedInvoke = exports.getOriginObject = exports.notify = exports.observable = exports.unobservable = exports.partialObservable = exports.observe = exports.isObservable = exports.getRunningObservers = exports.observerInfoMap = void 0;
var common_1 = __webpack_require__(0);
var array_1 = __webpack_require__(66);
var generateObserverId = (function () {
    var lastId = 0;
    return function () {
        lastId += 1;
        return "@observer" + lastId;
    };
})();
// store all observer info
exports.observerInfoMap = {};
// observerId stack for managing recursive observing calls
var observerIdStack = [];
var queue = [];
var observerIdMap = {};
var pending = false;
var paused = false;
function batchUpdate(observerId) {
    if (!observerIdMap[observerId]) {
        observerIdMap[observerId] = true;
        queue.push(observerId);
    }
    if (!pending) {
        flush();
    }
}
function clearQueue() {
    queue = [];
    observerIdMap = {};
    pending = false;
}
function getRunningObservers() {
    return queue.map(function (id) { return exports.observerInfoMap[id].name; }).filter(function (name) { return name; });
}
exports.getRunningObservers = getRunningObservers;
function callObserver(observerId) {
    observerIdStack.push(observerId);
    exports.observerInfoMap[observerId].fn(exports.observerInfoMap[observerId].key);
    observerIdStack.pop();
    delete exports.observerInfoMap[observerId].key;
}
function flush() {
    pending = true;
    for (var index = 0; index < queue.length; index += 1) {
        var observerId = queue[index];
        observerIdMap[observerId] = false;
        callObserver(observerId);
    }
    clearQueue();
}
function run(observerId, key) {
    var sync = exports.observerInfoMap[observerId].sync;
    exports.observerInfoMap[observerId].key = key;
    if (sync) {
        callObserver(observerId);
    }
    else {
        batchUpdate(observerId);
    }
}
function setValue(storage, resultObj, observerIdSet, key, value) {
    if (storage[key] !== value) {
        if (Array.isArray(value)) {
            array_1.patchArrayMethods(value, resultObj, key);
        }
        storage[key] = value;
        Object.keys(observerIdSet).forEach(function (observerId) {
            run(observerId, 'setValue');
        });
    }
}
function isObservable(resultObj) {
    return common_1.isObject(resultObj) && common_1.hasOwnProp(resultObj, '__storage__');
}
exports.isObservable = isObservable;
function observe(fn, sync, name) {
    if (sync === void 0) { sync = false; }
    if (name === void 0) { name = ''; }
    var observerId = generateObserverId();
    exports.observerInfoMap[observerId] = { fn: fn, targetObserverIdSets: [], sync: sync, name: name };
    run(observerId, 'observe');
    // return unobserve function
    return function () {
        exports.observerInfoMap[observerId].targetObserverIdSets.forEach(function (idSet) {
            delete idSet[observerId];
        });
        delete exports.observerInfoMap[observerId];
    };
}
exports.observe = observe;
// eslint-disable-next-line max-params
function makeObservableData(obj, resultObj, key, storage, propObserverIdSetMap, sync) {
    var getter = (Object.getOwnPropertyDescriptor(obj, key) || {}).get;
    var observerIdSet = (propObserverIdSetMap[key] = {});
    Object.defineProperty(resultObj, key, {
        configurable: true,
        enumerable: true,
        get: function () {
            var observerId = common_1.last(observerIdStack);
            if (!paused && observerId && !observerIdSet[observerId]) {
                observerIdSet[observerId] = true;
                exports.observerInfoMap[observerId].targetObserverIdSets.push(observerIdSet);
            }
            return storage[key];
        },
    });
    if (common_1.isFunction(getter)) {
        observe(function () {
            var value = getter.call(resultObj);
            setValue(storage, resultObj, observerIdSet, key, value);
        }, sync);
    }
    else {
        // has to add 'as' type assertion and refer the below typescript issue
        // In general, the constraint Record<string, XXX> doesn't actually ensure that an argument has a string index signature,
        // it merely ensures that the properties of the argument are assignable to type XXX.
        // So, in the example above you could effectively pass any object and the function could write to any property without any checks.
        // https://github.com/microsoft/TypeScript/issues/31661
        storage[key] = obj[key];
        if (Array.isArray(storage[key])) {
            array_1.patchArrayMethods(storage[key], resultObj, key);
        }
        Object.defineProperty(resultObj, key, {
            set: function (value) {
                setValue(storage, resultObj, observerIdSet, key, value);
            },
        });
    }
}
function partialObservable(obj, key) {
    var storage = obj.__storage__;
    var propObserverIdSetMap = obj.__propObserverIdSetMap__;
    makeObservableData(obj, obj, key, storage, propObserverIdSetMap);
}
exports.partialObservable = partialObservable;
function unobservable(obj, keys) {
    if (keys === void 0) { keys = []; }
    if (isObservable(obj)) {
        var originObject_1 = getOriginObject(obj);
        keys.forEach(function (key) {
            delete obj[key];
            obj[key] = originObject_1[key];
        });
        delete obj.__storage__;
    }
}
exports.unobservable = unobservable;
function observable(obj, sync) {
    if (sync === void 0) { sync = false; }
    if (Array.isArray(obj)) {
        throw new Error('Array object cannot be Reactive');
    }
    if (isObservable(obj)) {
        return obj;
    }
    var storage = {};
    var propObserverIdSetMap = {};
    var resultObj = {};
    Object.defineProperties(resultObj, {
        __storage__: { value: storage, configurable: true },
        __propObserverIdSetMap__: { value: propObserverIdSetMap },
    });
    Object.keys(obj).forEach(function (key) {
        makeObservableData(obj, resultObj, key, storage, propObserverIdSetMap, sync);
    });
    return resultObj;
}
exports.observable = observable;
function notifyUnit(obj, key) {
    Object.keys(obj.__propObserverIdSetMap__[key]).forEach(function (observerId) {
        run(observerId, key.toString());
    });
}
function notify(obj) {
    var keys = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        keys[_i - 1] = arguments[_i];
    }
    if (isObservable(obj)) {
        keys.forEach(function (key) { return notifyUnit(obj, key); });
    }
}
exports.notify = notify;
function getOriginObject(obj) {
    var result = {};
    common_1.forEachObject(function (value, key) {
        result[key] = isObservable(value) ? getOriginObject(value) : value;
    }, obj.__storage__);
    return common_1.isEmpty(result) ? obj : result;
}
exports.getOriginObject = getOriginObject;
function unobservedInvoke(fn) {
    paused = true;
    fn();
    paused = false;
}
exports.unobservedInvoke = unobservedInvoke;
function batchObserver(fn) {
    pending = true;
    fn();
    pending = false;
}
exports.batchObserver = batchObserver;
var asyncTimer = null;
function asyncInvokeObserver(fn) {
    if (common_1.isNull(asyncTimer)) {
        asyncTimer = setTimeout(function () {
            fn();
            asyncTimer = null;
        });
    }
}
exports.asyncInvokeObserver = asyncInvokeObserver;


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getCheckStateChangedRowkeysInRange = exports.changeRawDataToOriginDataForTree = exports.getOmittedInternalProp = exports.createChangeInfo = exports.getFormattedValue = exports.getRowKeyByIndexWithPageRange = exports.getRowIndexPerPage = exports.isClientPagination = exports.isScrollPagination = exports.getMaxRowKey = exports.isFiltered = exports.isSorted = exports.getCreatedRowInfos = exports.getCreatedRowInfo = exports.getRemovedClassName = exports.getAddedClassName = exports.getLoadingState = exports.getRowHeight = exports.isInitialSortState = exports.isSortable = exports.getUniqColumnData = exports.findRowByRowKey = exports.findIndexByRowKey = exports.getConditionalRows = exports.getRemoveRowInfoList = exports.getCheckedRowInfoList = exports.isEditableCell = exports.getCellAddressByIndex = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var instance_1 = __webpack_require__(9);
var column_1 = __webpack_require__(12);
var data_1 = __webpack_require__(15);
var data_2 = __webpack_require__(23);
var data_3 = __webpack_require__(14);
var validation_1 = __webpack_require__(27);
var observable_1 = __webpack_require__(5);
function getCellAddressByIndex(_a, rowIndex, columnIndex) {
    var data = _a.data, column = _a.column;
    return {
        rowKey: data.filteredViewData[rowIndex].rowKey,
        columnName: column.visibleColumns[columnIndex].name,
    };
}
exports.getCellAddressByIndex = getCellAddressByIndex;
function isEditableCell(store, rowIndex, columnName) {
    var data = store.data, column = store.column;
    var filteredIndex = data.filteredIndex, filteredViewData = data.filteredViewData;
    if (filteredIndex && common_1.isNil(filteredIndex[rowIndex])) {
        return false;
    }
    // get index based on whole data(not filtered data)
    var index = filteredIndex ? filteredIndex[rowIndex] : rowIndex;
    data_3.makeObservable({ store: store, rowIndex: index, silent: true });
    var _a = filteredViewData[rowIndex].valueMap[columnName], disabled = _a.disabled, editable = _a.editable;
    return !column_1.isHiddenColumn(column, columnName) && editable && !disabled;
}
exports.isEditableCell = isEditableCell;
function getCheckedRowInfoList(_a) {
    var data = _a.data;
    var targetRows = {
        rowIndices: [],
        rows: [],
        nextRows: [],
    };
    data.rawData.reduce(function (acc, row, index) {
        if (row._attributes.checked) {
            acc.rowIndices.push(index);
            acc.rows.push(row);
            acc.nextRows.push(data.rawData[index + 1]);
        }
        return acc;
    }, targetRows);
    return targetRows;
}
exports.getCheckedRowInfoList = getCheckedRowInfoList;
function getRemoveRowInfoList(_a, rowKeys) {
    var data = _a.data;
    var targetRows = {
        rowIndices: [],
        rows: [],
        nextRows: [],
    };
    data.rawData.reduce(function (acc, row, index) {
        var rowKeyIndex = rowKeys.indexOf(row.rowKey);
        if (rowKeyIndex !== -1) {
            acc.rowIndices.push(index);
            acc.rows.push(row);
            acc.nextRows.push(data.rawData[index + 1]);
            rowKeys.splice(rowKeyIndex, 1);
        }
        return acc;
    }, targetRows);
    return targetRows;
}
exports.getRemoveRowInfoList = getRemoveRowInfoList;
function getConditionalRows(_a, conditions) {
    var data = _a.data;
    var rawData = data.rawData;
    if (common_1.isFunction(conditions)) {
        return rawData.filter(conditions);
    }
    var result = rawData;
    Object.keys(conditions).forEach(function (key) {
        result = result.filter(function (row) { return row[key] === conditions[key]; });
    });
    return result;
}
exports.getConditionalRows = getConditionalRows;
function findIndexByRowKey(data, column, id, rowKey, filtered) {
    if (filtered === void 0) { filtered = true; }
    if (common_1.isNil(rowKey)) {
        return -1;
    }
    var filteredRawData = data.filteredRawData, rawData = data.rawData;
    var targetData = filtered ? filteredRawData : rawData;
    var dataManager = instance_1.getDataManager(id);
    var modified = dataManager ? dataManager.isMixedOrder() : false;
    if (isSorted(data) || column.keyColumnName || modified) {
        return common_1.findPropIndex('rowKey', rowKey, targetData);
    }
    var start = 0;
    var end = targetData.length - 1;
    while (start <= end) {
        var mid = Math.floor((start + end) / 2);
        var comparedRowKey = targetData[mid].rowKey;
        if (rowKey > comparedRowKey) {
            start = mid + 1;
        }
        else if (rowKey < comparedRowKey) {
            end = mid - 1;
        }
        else {
            return mid;
        }
    }
    return -1;
}
exports.findIndexByRowKey = findIndexByRowKey;
function findRowByRowKey(data, column, id, rowKey, filtered) {
    if (filtered === void 0) { filtered = true; }
    var targetData = filtered ? data.filteredRawData : data.rawData;
    return targetData[findIndexByRowKey(data, column, id, rowKey, filtered)];
}
exports.findRowByRowKey = findRowByRowKey;
function getUniqColumnData(targetData, column, columnName) {
    var columnInfo = column.allColumnMap[columnName];
    var uniqColumnData = common_1.uniqByProp(columnName, targetData.map(function (data) {
        var _a;
        return (tslib_1.__assign(tslib_1.__assign({}, data), (_a = {}, _a[columnName] = common_1.isNil(data[columnName]) ? '' : data[columnName], _a)));
    }));
    return uniqColumnData.map(function (row) {
        var value = row[columnName];
        var formatterProps = {
            row: row,
            value: value,
            column: columnInfo,
        };
        var relationListItems = row._relationListItemMap[columnName];
        return data_2.getFormattedValue(formatterProps, columnInfo.formatter, value, relationListItems);
    });
}
exports.getUniqColumnData = getUniqColumnData;
function isSortable(sortState, column, columnName) {
    if (columnName === 'sortKey') {
        return true;
    }
    var _a = column.allColumnMap[columnName], sortable = _a.sortable, hidden = _a.hidden;
    return sortState.useClient && !hidden && sortable;
}
exports.isSortable = isSortable;
function isInitialSortState(_a) {
    var columns = _a.columns;
    return columns.length === 1 && columns[0].columnName === 'sortKey';
}
exports.isInitialSortState = isInitialSortState;
function getRowHeight(row, defaultRowHeight) {
    var _a = row._attributes, height = _a.height, tree = _a.tree;
    var rowHeight = tree && tree.hidden ? 0 : height;
    return common_1.isNumber(rowHeight) ? rowHeight : defaultRowHeight;
}
exports.getRowHeight = getRowHeight;
function getLoadingState(rawData) {
    return rawData.length ? 'DONE' : 'EMPTY';
}
exports.getLoadingState = getLoadingState;
function getAddedClassName(className, prevClassNames) {
    var classNames = className.split(' ');
    var columnClassNames = prevClassNames ? prevClassNames : [];
    return common_1.uniq(tslib_1.__spreadArrays(classNames, columnClassNames));
}
exports.getAddedClassName = getAddedClassName;
function getRemovedClassName(className, prevClassNames) {
    var classNames = className.split(' ');
    var removedClassNames = prevClassNames;
    classNames.forEach(function (clsName) {
        common_1.removeArrayItem(clsName, removedClassNames);
    });
    return removedClassNames;
}
exports.getRemovedClassName = getRemovedClassName;
function getCreatedRowInfo(store, rowIndex, row, rowKey) {
    data_1.generateDataCreationKey();
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var prevRow = rawData[rowIndex - 1];
    var options = { prevRow: prevRow, lazyObservable: true };
    if (!common_1.isUndefined(rowKey)) {
        row.rowKey = rowKey;
    }
    var index = getMaxRowKey(data);
    var rawRow = data_1.createRawRow(id, tslib_1.__assign(tslib_1.__assign({}, column.emptyRow), row), index, column, options);
    var viewRow = { rowKey: row.rowKey, sortKey: row.sortKey, uniqueKey: row.uniqueKey };
    return { rawRow: rawRow, viewRow: viewRow, prevRow: prevRow };
}
exports.getCreatedRowInfo = getCreatedRowInfo;
function getCreatedRowInfos(store, indexedRows) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var index = getMaxRowKey(data);
    return indexedRows.map(function (_a, i) {
        var rowIndex = _a.rowIndex, row = _a.row, orgRow = _a.orgRow;
        data_1.generateDataCreationKey();
        var prevRow = rawData[rowIndex - 1];
        var options = { prevRow: prevRow, lazyObservable: true };
        var rawRow = data_1.createRawRow(id, tslib_1.__assign(tslib_1.__assign({}, column.emptyRow), row), index + i, column, options);
        var viewRow = { rowKey: row.rowKey, sortKey: row.sortKey, uniqueKey: row.uniqueKey };
        return { rowIndex: rowIndex, row: { rawRow: rawRow, viewRow: viewRow, prevRow: prevRow }, orgRow: orgRow };
    });
}
exports.getCreatedRowInfos = getCreatedRowInfos;
function isSorted(data) {
    return data.sortState.columns[0].columnName !== 'sortKey';
}
exports.isSorted = isSorted;
function isFiltered(data) {
    return !common_1.isNull(data.filters);
}
exports.isFiltered = isFiltered;
function getMaxRowKey(data) {
    return Math.max.apply(Math, tslib_1.__spreadArrays([-1], common_1.mapProp('rowKey', data.rawData))) + 1;
}
exports.getMaxRowKey = getMaxRowKey;
function isScrollPagination(_a, useClient) {
    var pageOptions = _a.pageOptions;
    if (common_1.isUndefined(useClient)) {
        return pageOptions.type === 'scroll';
    }
    return useClient && pageOptions.type === 'scroll';
}
exports.isScrollPagination = isScrollPagination;
function isClientPagination(_a) {
    var pageOptions = _a.pageOptions;
    return !common_1.isEmpty(pageOptions) && pageOptions.useClient && pageOptions.type === 'pagination';
}
exports.isClientPagination = isClientPagination;
function getRowIndexPerPage(data, rowIndex) {
    return isClientPagination(data) ? rowIndex % data.pageOptions.perPage : rowIndex;
}
exports.getRowIndexPerPage = getRowIndexPerPage;
function getRowKeyByIndexWithPageRange(data, rowIndex) {
    if (isClientPagination(data)) {
        rowIndex += data.pageRowRange[0];
    }
    return data.filteredRawData[rowIndex].rowKey;
}
exports.getRowKeyByIndexWithPageRange = getRowKeyByIndexWithPageRange;
function getFormattedValue(store, rowKey, columnName) {
    var data = store.data, column = store.column, id = store.id;
    var rowIndex = findIndexByRowKey(data, column, id, rowKey, false);
    var viewData = data.viewData;
    if (rowIndex !== -1) {
        data_3.makeObservable({ store: store, rowIndex: rowIndex });
        var viewCell = viewData[rowIndex].valueMap[columnName];
        return viewCell ? viewCell.formattedValue : null;
    }
    return null;
}
exports.getFormattedValue = getFormattedValue;
function createChangeInfo(store, row, columnName, pastingValue, index) {
    var id = store.id, column = store.column;
    var rowKey = row.rowKey;
    var prevChange = { rowKey: rowKey, columnName: columnName, value: row[columnName], nextValue: pastingValue };
    var nextChange = { rowKey: rowKey, columnName: columnName, prevValue: row[columnName], value: pastingValue };
    var changeValue = function () {
        var value = prevChange.value, nextValue = prevChange.nextValue;
        validation_1.replaceColumnUniqueInfoMap(id, column, {
            rowKey: rowKey,
            columnName: columnName,
            prevValue: value,
            value: nextValue,
        });
        nextChange.value = nextValue;
        row[columnName] = nextValue;
        return index;
    };
    return { prevChange: prevChange, nextChange: nextChange, changeValue: changeValue };
}
exports.createChangeInfo = createChangeInfo;
function getOmittedInternalProp(row) {
    var additaional = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        additaional[_i - 1] = arguments[_i];
    }
    return common_1.omit.apply(void 0, tslib_1.__spreadArrays([observable_1.getOriginObject(row), 'sortKey',
        'uniqueKey',
        'rowSpanMap',
        '_relationListItemMap',
        '_disabledPriority'], additaional));
}
exports.getOmittedInternalProp = getOmittedInternalProp;
function changeRowToOriginRowForTree(row) {
    var originRow = getOmittedInternalProp(row, 'rowKey', '_attributes');
    if (originRow._children) {
        originRow._children = originRow._children.map(function (childRow) {
            return changeRowToOriginRowForTree(childRow);
        });
    }
    return originRow;
}
function changeRawDataToOriginDataForTree(rawData) {
    return rawData
        .filter(function (row) { var _a, _b; return common_1.isNil((_b = (_a = row._attributes) === null || _a === void 0 ? void 0 : _a.tree) === null || _b === void 0 ? void 0 : _b.parentRowKey); })
        .map(function (row) { return changeRowToOriginRowForTree(row); });
}
exports.changeRawDataToOriginDataForTree = changeRawDataToOriginDataForTree;
function getCheckStateChangedRowkeysInRange(store, checkState, range) {
    var data = store.data;
    var filteredRawData = data.filteredRawData;
    var rowKeys = [];
    for (var i = range[0]; i < range[1]; i += 1) {
        if (filteredRawData[i]._attributes.checked !== checkState) {
            rowKeys.push(getRowKeyByIndexWithPageRange(data, i));
        }
    }
    return rowKeys;
}
exports.getCheckStateChangedRowkeysInRange = getCheckStateChangedRowkeysInRange;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getEventBus = exports.createEventBus = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var instance_1 = __webpack_require__(9);
var eventBusMap = {};
function createEventBus(id) {
    var listenersMap = {};
    eventBusMap[id] = {
        on: function (eventName, func) {
            var listeners = listenersMap[eventName];
            listenersMap[eventName] = listeners ? tslib_1.__spreadArrays(listeners, [func]) : [func];
        },
        off: function (eventName, func) {
            var listeners = listenersMap[eventName];
            if (listeners) {
                if (func) {
                    listenersMap[eventName] = common_1.removeArrayItem(func, listeners);
                }
                else {
                    delete listenersMap[eventName];
                }
            }
        },
        trigger: function (eventName, gridEvent) {
            if (listenersMap[eventName]) {
                var instance = instance_1.getInstance(id);
                gridEvent.setInstance(instance);
                listenersMap[eventName].forEach(function (func) {
                    func(gridEvent);
                });
            }
        },
    };
    return eventBusMap[id];
}
exports.createEventBus = createEventBus;
function getEventBus(id) {
    return eventBusMap[id];
}
exports.getEventBus = getEventBus;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TEXT_EDITOR_MAX_HEIGHT = exports.FILTER_LEFT_POSITION_ADJUSTMENT = exports.OCCUPIED_HEIGHT_BY_CELL_LAYOUY = exports.DEFAULT_SUB_CONTEXT_MENU_TOP = exports.HORIZONTAL_PADDING_OF_CELL = exports.VERTICAL_PADDING_OF_CELL = exports.DISABLED_PRIORITY_COLUMN = exports.DISABLED_PRIORITY_ROW = exports.DISABLED_PRIORITY_CELL = exports.DISABLED_PRIORITY_NONE = exports.DEFAULT_PER_PAGE = exports.RIGHT_MOUSE_BUTTON = exports.TREE_CELL_HORIZONTAL_PADDING = exports.TREE_INDENT_WIDTH = exports.FILTER_DEBOUNCE_TIME = void 0;
exports.FILTER_DEBOUNCE_TIME = 50;
exports.TREE_INDENT_WIDTH = 22;
exports.TREE_CELL_HORIZONTAL_PADDING = 19;
exports.RIGHT_MOUSE_BUTTON = 2;
exports.DEFAULT_PER_PAGE = 20;
exports.DISABLED_PRIORITY_NONE = 'NONE';
exports.DISABLED_PRIORITY_CELL = 'CELL';
exports.DISABLED_PRIORITY_ROW = 'ROW';
exports.DISABLED_PRIORITY_COLUMN = 'COLUMN';
exports.VERTICAL_PADDING_OF_CELL = 3;
exports.HORIZONTAL_PADDING_OF_CELL = 10;
exports.DEFAULT_SUB_CONTEXT_MENU_TOP = -6;
exports.OCCUPIED_HEIGHT_BY_CELL_LAYOUY = 9;
exports.FILTER_LEFT_POSITION_ADJUSTMENT = 2;
exports.TEXT_EDITOR_MAX_HEIGHT = 29.5;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getPaginationManager = exports.getDataManager = exports.getDataProvider = exports.getInstance = exports.registerDataSources = exports.register = void 0;
var common_1 = __webpack_require__(0);
var currentId = 0;
var instanceMap = {};
function generateId() {
    currentId += 1;
    return currentId;
}
function register(instance) {
    var id = generateId();
    if (!common_1.isObject(instanceMap[id])) {
        instanceMap[id] = {};
    }
    instanceMap[id].grid = instance;
    return id;
}
exports.register = register;
function registerDataSources(id, dataProvider, dataManager, paginationManager) {
    instanceMap[id].dataProvider = dataProvider;
    instanceMap[id].dataManager = dataManager;
    instanceMap[id].paginationManager = paginationManager;
}
exports.registerDataSources = registerDataSources;
function getInstance(id) {
    return instanceMap[id].grid;
}
exports.getInstance = getInstance;
function getDataProvider(id) {
    return instanceMap[id].dataProvider;
}
exports.getDataProvider = getDataProvider;
function getDataManager(id) {
    return instanceMap[id].dataManager;
}
exports.getDataManager = getDataManager;
function getPaginationManager(id) {
    return instanceMap[id].paginationManager;
}
exports.getPaginationManager = getPaginationManager;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(2);
var common_1 = __webpack_require__(0);
var column_1 = __webpack_require__(11);
function getTargetInfo(nativeEvent) {
    var targetType = 'etc';
    var target = nativeEvent.target;
    var cell = dom_1.findParentByTagName(target, 'td');
    var rowKey, columnName;
    if (cell) {
        var address = dom_1.getCellAddress(cell);
        if (address) {
            rowKey = address.rowKey;
            columnName = address.columnName;
            targetType = column_1.isRowHeader(address.columnName) ? 'rowHeader' : 'cell';
        }
        else {
            targetType = 'dummy';
        }
    }
    else {
        cell = dom_1.findParentByTagName(target, 'th');
        if (cell) {
            columnName = cell.getAttribute(dom_1.dataAttr.COLUMN_NAME);
            targetType = 'columnHeader';
        }
    }
    return common_1.pruneObject({
        nativeEvent: nativeEvent,
        targetType: targetType,
        rowKey: rowKey,
        columnName: columnName,
    });
}
/**
 * Event class for public event of Grid
 * @module event/gridEvent
 * @param {Object} data - Event data for handler
 */
var GridEvent = /** @class */ (function () {
    function GridEvent(_a) {
        if (_a === void 0) { _a = {}; }
        var event = _a.event, props = tslib_1.__rest(_a, ["event"]);
        this.stopped = false;
        if (event) {
            this.assignData(getTargetInfo(event));
        }
        if (props) {
            this.assignData(props);
        }
    }
    /**
     * Stops propogation of this event.
     * @memberof event/gridEvent
     */
    GridEvent.prototype.stop = function () {
        this.stopped = true;
    };
    GridEvent.prototype.isStopped = function () {
        return this.stopped;
    };
    GridEvent.prototype.assignData = function (data) {
        common_1.assign(this, data);
    };
    GridEvent.prototype.setInstance = function (instance) {
        common_1.assign(this, { instance: instance });
    };
    return GridEvent;
}());
exports.default = GridEvent;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isDragColumn = exports.isCheckboxColumn = exports.isRowNumColumn = exports.isRowHeader = void 0;
var common_1 = __webpack_require__(0);
function isRowHeader(columnName) {
    return common_1.includes(['_number', '_checked', '_draggable'], columnName);
}
exports.isRowHeader = isRowHeader;
function isRowNumColumn(columnName) {
    return columnName === '_number';
}
exports.isRowNumColumn = isRowNumColumn;
function isCheckboxColumn(columnName) {
    return columnName === '_checked';
}
exports.isCheckboxColumn = isCheckboxColumn;
function isDragColumn(columnName) {
    return columnName === '_draggable';
}
exports.isDragColumn = isDragColumn;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isDraggableColumn = exports.isDisabledColumn = exports.isAllColumnsVisible = exports.getColumnSide = exports.getChildHeaderCount = exports.getHierarchyMaxRowCount = exports.convertHierarchyToData = exports.getComplexColumnsHierarchy = exports.getRemovedHiddenChildColumns = exports.getColumnHierarchy = exports.isComplexHeader = exports.isHiddenColumn = exports.isParentColumnHeader = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var tree_1 = __webpack_require__(21);
function isParentColumnHeader(complexColumnHeaders, name) {
    return !!complexColumnHeaders.length && common_1.some(function (item) { return item.name === name; }, complexColumnHeaders);
}
exports.isParentColumnHeader = isParentColumnHeader;
function isHiddenColumn(column, columnName) {
    return column.allColumnMap[columnName].hidden;
}
exports.isHiddenColumn = isHiddenColumn;
function isComplexHeader(column, columnName) {
    return common_1.some(function (_a) {
        var name = _a.name, hideChildHeaders = _a.hideChildHeaders, childNames = _a.childNames;
        return !!(name === columnName || (hideChildHeaders && common_1.includes(childNames, columnName)));
    }, column.complexColumnHeaders);
}
exports.isComplexHeader = isComplexHeader;
function getColumnHierarchy(column, complexColumnHeaders, mergedComplexColumns) {
    var complexColumns = mergedComplexColumns || [];
    if (column) {
        complexColumns.push(column);
        if (complexColumnHeaders) {
            complexColumnHeaders.forEach(function (complexColumnHeader) {
                if (common_1.includes(complexColumnHeader.childNames, column.name)) {
                    getColumnHierarchy(complexColumnHeader, complexColumnHeaders, complexColumns);
                }
            });
        }
    }
    return complexColumns;
}
exports.getColumnHierarchy = getColumnHierarchy;
function getRemovedHiddenChildColumns(hierarchies) {
    return hierarchies.map(function (columns) {
        if (columns.length > 1) {
            // The hideChildHeaders option always exists in the second column to last.
            var hideChildHeaders = columns[columns.length - 2].hideChildHeaders;
            if (hideChildHeaders) {
                columns.pop();
            }
        }
        return columns;
    });
}
exports.getRemovedHiddenChildColumns = getRemovedHiddenChildColumns;
function getComplexColumnsHierarchy(columns, complexColumnHeaders) {
    return getRemovedHiddenChildColumns(columns.map(function (column) { return getColumnHierarchy(column, complexColumnHeaders).reverse(); }));
}
exports.getComplexColumnsHierarchy = getComplexColumnsHierarchy;
function convertHierarchyToData(hierarchy) {
    var maxRowCount = getHierarchyMaxRowCount(hierarchy);
    var data = [];
    hierarchy.forEach(function (colunms) {
        for (var i = 0; i < maxRowCount; i += 1) {
            if (!Array.isArray(data[i])) {
                data.push([]);
            }
            var colInfo = colunms[i < colunms.length ? i : colunms.length - 1];
            data[i].push(colInfo.header);
        }
    });
    return data;
}
exports.convertHierarchyToData = convertHierarchyToData;
function getHierarchyMaxRowCount(hierarchies) {
    return Math.max.apply(Math, tslib_1.__spreadArrays([0], common_1.mapProp('length', hierarchies)));
}
exports.getHierarchyMaxRowCount = getHierarchyMaxRowCount;
function getChildHeaderCount(columns, complexColumns, name) {
    var count = 0;
    var leafColumn = common_1.someProp('name', name, columns);
    if (!leafColumn) {
        var complexColumn = common_1.findProp('name', name, complexColumns);
        if (complexColumn) {
            complexColumn.childNames.forEach(function (childName) {
                var leafChildColumn = common_1.someProp('name', childName, columns);
                count += leafChildColumn ? 1 : getChildHeaderCount(columns, complexColumns, childName);
            });
        }
    }
    return count;
}
exports.getChildHeaderCount = getChildHeaderCount;
function getColumnSide(column, columnName) {
    return common_1.someProp('name', columnName, column.visibleColumnsBySideWithRowHeader.R) ? 'R' : 'L';
}
exports.getColumnSide = getColumnSide;
function isAllColumnsVisible(column) {
    var columnsWithoutRowHeader = column.columnsWithoutRowHeader, visibleColumns = column.visibleColumns;
    return columnsWithoutRowHeader.length === visibleColumns.length;
}
exports.isAllColumnsVisible = isAllColumnsVisible;
function isDisabledColumn(column, columnName) {
    var targetColumn = common_1.find(function (_a) {
        var name = _a.name;
        return name === columnName;
    }, column.allColumns);
    return !!(targetColumn === null || targetColumn === void 0 ? void 0 : targetColumn.disabled);
}
exports.isDisabledColumn = isDisabledColumn;
function isDraggableColumn(store, columnName) {
    var column = store.column;
    return (column.draggable &&
        isAllColumnsVisible(column) &&
        column.complexColumnHeaders.length === 0 &&
        !tree_1.isTreeColumnName(column, columnName) &&
        !isDisabledColumn(column, columnName));
}
exports.isDraggableColumn = isDraggableColumn;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getRowSpanOfColumn = exports.isRowSpanEnabled = exports.getMaxRowSpanCount = exports.getRowSpanByRowKey = exports.getRowSpanBottomIndex = exports.getRowSpanTopIndex = exports.getRowSpan = exports.getVerticalPosWithRowSpan = exports.getRowRangeWithRowSpan = exports.getMaxRowSpanRange = void 0;
var common_1 = __webpack_require__(0);
var selection_1 = __webpack_require__(22);
function getMainRowSpan(columnName, rowSpan, data) {
    var mainRow = rowSpan.mainRow, mainRowKey = rowSpan.mainRowKey;
    if (mainRow) {
        return rowSpan;
    }
    var mainRowIndex = common_1.findPropIndex('rowKey', mainRowKey, data);
    return data[mainRowIndex].rowSpanMap[columnName];
}
function getRowSpanRange(rowRange, colRange, visibleColumns, data) {
    var startColumnIndex = colRange[0], endColumnIndex = colRange[1];
    var startRowIndex = rowRange[0], endRowIndex = rowRange[1];
    for (var index = startColumnIndex; index <= endColumnIndex; index += 1) {
        var filteredRawData = data.filteredRawData;
        var startRowSpanMap = filteredRawData[startRowIndex].rowSpanMap;
        var endRowSpanMap = filteredRawData[endRowIndex].rowSpanMap;
        var columnName = visibleColumns[index].name;
        // get top row index of topmost rowSpan
        if (startRowSpanMap[columnName]) {
            var mainRowKey = startRowSpanMap[columnName].mainRowKey;
            var topRowSpanIndex = common_1.findPropIndex('rowKey', mainRowKey, filteredRawData);
            startRowIndex = startRowIndex > topRowSpanIndex ? topRowSpanIndex : startRowIndex;
        }
        // get bottom row index of bottommost rowSpan
        if (endRowSpanMap[columnName]) {
            var _a = endRowSpanMap[columnName], mainRowKey = _a.mainRowKey, spanCount = _a.spanCount;
            var bottomRowSpanIndex = common_1.findPropIndex('rowKey', mainRowKey, filteredRawData) + spanCount - 1;
            endRowIndex = endRowIndex < bottomRowSpanIndex ? bottomRowSpanIndex : endRowIndex;
        }
    }
    return startRowIndex !== rowRange[0] || endRowIndex !== rowRange[1]
        ? getRowSpanRange([startRowIndex, endRowIndex], colRange, visibleColumns, data)
        : [startRowIndex, endRowIndex];
}
function getMaxRowSpanRange(rowRange, colRange, visibleColumns, focusRowIndex, data) {
    var sortedColRange = selection_1.getSortedRange(colRange);
    var endRowIndex = rowRange[1];
    var startRowIndex = rowRange[0];
    // if start row index is different from focused index,
    // change start row index to focused row index for getting proper row range
    startRowIndex =
        !common_1.isNull(focusRowIndex) && startRowIndex !== focusRowIndex ? focusRowIndex : startRowIndex;
    var sortedRowRange = selection_1.getSortedRange([startRowIndex, endRowIndex]);
    var _a = getRowSpanRange(sortedRowRange, sortedColRange, visibleColumns, data), startRowSpanIndex = _a[0], endRowSpanIndex = _a[1];
    return startRowIndex > endRowIndex
        ? [endRowSpanIndex, startRowSpanIndex]
        : [startRowSpanIndex, endRowSpanIndex];
}
exports.getMaxRowSpanRange = getMaxRowSpanRange;
function getRowRangeWithRowSpan(rowRange, colRange, column, rowIndex, data) {
    if (isRowSpanEnabled(data.sortState, column)) {
        return getMaxRowSpanRange(rowRange, colRange, column.visibleColumnsWithRowHeader, rowIndex, data);
    }
    return rowRange;
}
exports.getRowRangeWithRowSpan = getRowRangeWithRowSpan;
function getVerticalPosWithRowSpan(columnName, rowSpan, rowCoords, data) {
    var mainRowSpan = getMainRowSpan(columnName, rowSpan, data);
    var mainRowIndex = common_1.findPropIndex('rowKey', mainRowSpan.mainRowKey, data);
    var spanCount = mainRowSpan.spanCount;
    var top = rowCoords.offsets[mainRowIndex];
    var bottom = top;
    for (var count = 0; count < spanCount; count += 1) {
        bottom += rowCoords.heights[mainRowIndex + count];
    }
    return [top, bottom];
}
exports.getVerticalPosWithRowSpan = getVerticalPosWithRowSpan;
function getRowSpan(rowIndex, columnName, data) {
    var rowSpanMap = data[rowIndex].rowSpanMap;
    return rowSpanMap[columnName];
}
exports.getRowSpan = getRowSpan;
/*
 * get top row index of specific rowSpan cell
 */
function getRowSpanTopIndex(rowIndex, columnName, data) {
    var rowSpan = getRowSpan(rowIndex, columnName, data);
    if (!rowSpan) {
        return rowIndex;
    }
    return common_1.findPropIndex('rowKey', rowSpan.mainRowKey, data);
}
exports.getRowSpanTopIndex = getRowSpanTopIndex;
/*
 * get bottom row index of specific rowSpan cell
 */
function getRowSpanBottomIndex(rowIndex, columnName, data) {
    var rowSpan = getRowSpan(rowIndex, columnName, data);
    if (!rowSpan) {
        return rowIndex;
    }
    var mainRowIndex = common_1.findPropIndex('rowKey', rowSpan.mainRowKey, data);
    return mainRowIndex + rowSpan.spanCount - 1;
}
exports.getRowSpanBottomIndex = getRowSpanBottomIndex;
function getRowSpanByRowKey(rowKey, columnName, data) {
    var rowIndex = common_1.findPropIndex('rowKey', rowKey, data);
    if (rowIndex === -1) {
        return null;
    }
    return getRowSpan(rowIndex, columnName, data) || null;
}
exports.getRowSpanByRowKey = getRowSpanByRowKey;
/*
 * get max rowSpan count in all columns that have rowSpan
 */
function getMaxRowSpanCount(rowIndex, data) {
    var _a;
    var rowSpanMap = (_a = data[rowIndex]) === null || _a === void 0 ? void 0 : _a.rowSpanMap;
    if (common_1.isEmpty(rowSpanMap)) {
        return 0;
    }
    return Object.keys(rowSpanMap).reduce(function (acc, columnName) { return Math.max(acc, rowSpanMap[columnName].spanCount); }, 0);
}
exports.getMaxRowSpanCount = getMaxRowSpanCount;
function isRowSpanEnabled(sortState, column) {
    return (sortState.columns[0].columnName === 'sortKey' || !!(column === null || column === void 0 ? void 0 : column.visibleRowSpanEnabledColumns.length));
}
exports.isRowSpanEnabled = isRowSpanEnabled;
function getRowSpanOfColumn(data, columnName, perPage) {
    var rowSpanOfColumn = {};
    var rowSpan = {};
    var mainRowKey = null;
    var mainRowValue = null;
    data.forEach(function (_a, index) {
        var rowKey = _a.rowKey, _b = columnName, value = _a[_b];
        var isRowInNextPage = perPage && index !== 0 && index % perPage === 0;
        if (mainRowValue !== value || isRowInNextPage) {
            if (!common_1.isNull(mainRowKey) && rowSpan[columnName] !== 1) {
                rowSpanOfColumn[mainRowKey] = rowSpan;
            }
            rowSpan = {};
            rowSpan[columnName] = 1;
            mainRowKey = rowKey;
            mainRowValue = value;
        }
        else {
            rowSpan[columnName] += 1;
        }
    });
    if (!common_1.isNull(mainRowKey) && rowSpan[columnName] !== 1) {
        rowSpanOfColumn[mainRowKey] = rowSpan;
    }
    return rowSpanOfColumn;
}
exports.getRowSpanOfColumn = getRowSpanOfColumn;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.removeRows = exports.appendRows = exports.scrollToNext = exports.moveRow = exports.setRows = exports.setRow = exports.updateRowNumber = exports.setCheckedAllRows = exports.setLoadingState = exports.removeColumnClassName = exports.addColumnClassName = exports.removeCellClassName = exports.addCellClassName = exports.removeRowClassName = exports.addRowClassName = exports.resetData = exports.clearData = exports.removeRow = exports.appendRow = exports.setRowCheckDisabled = exports.setCellDisabled = exports.setColumnDisabled = exports.setRowDisabled = exports.setDisabled = exports.setDisabledAllCheckbox = exports.uncheckAll = exports.checkAll = exports.setCheckboxBetween = exports.uncheck = exports.check = exports.setColumnValues = exports.setAllRowAttribute = exports.setRowsAttributeInRange = exports.setRowAttribute = exports.isUpdatableRowAttr = exports.setValue = exports.makeObservable = exports.updateHeights = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var data_1 = __webpack_require__(15);
var observable_1 = __webpack_require__(5);
var selection_1 = __webpack_require__(16);
var eventBus_1 = __webpack_require__(7);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var instance_1 = __webpack_require__(9);
var tree_1 = __webpack_require__(30);
var rowSpan_1 = __webpack_require__(13);
var focus_1 = __webpack_require__(18);
var tree_2 = __webpack_require__(20);
var sort_1 = __webpack_require__(28);
var data_2 = __webpack_require__(6);
var summary_1 = __webpack_require__(26);
var filter_1 = __webpack_require__(36);
var viewport_1 = __webpack_require__(25);
var column_1 = __webpack_require__(11);
var pagination_1 = __webpack_require__(37);
var rowSpan_2 = __webpack_require__(24);
var lazyObservable_1 = __webpack_require__(31);
var validation_1 = __webpack_require__(27);
var column_2 = __webpack_require__(32);
var renderState_1 = __webpack_require__(50);
var constant_1 = __webpack_require__(8);
function getIndexRangeOfCheckbox(_a, startRowKey, targetRowKey) {
    var data = _a.data, column = _a.column, id = _a.id;
    var filtered = data_2.isFiltered(data);
    var from = data_2.findIndexByRowKey(data, column, id, startRowKey, filtered);
    var to = data_2.findIndexByRowKey(data, column, id, targetRowKey, filtered);
    return from < to ? [from, to + 1] : [to, from + 1];
}
function updateHeightsWithFilteredData(store) {
    var data = store.data, focus = store.focus;
    var filteredRawData = data.filteredRawData;
    var rowKey = focus.rowKey;
    if (!filteredRawData.some(function (row) { return row.rowKey === rowKey; })) {
        focus_1.initFocus(store);
    }
    updateHeights(store);
}
function updateHeights(store) {
    var data = store.data, rowCoords = store.rowCoords, dimension = store.dimension;
    var pageOptions = data.pageOptions, pageRowRange = data.pageRowRange, filteredRawData = data.filteredRawData;
    var rowHeight = dimension.rowHeight;
    rowCoords.heights = pageOptions.useClient
        ? filteredRawData.slice.apply(filteredRawData, pageRowRange).map(function (row) { return data_2.getRowHeight(row, rowHeight); })
        : filteredRawData.map(function (row) { return data_2.getRowHeight(row, rowHeight); });
}
exports.updateHeights = updateHeights;
function makeObservable(_a) {
    var store = _a.store, rowIndex = _a.rowIndex, _b = _a.silent, silent = _b === void 0 ? false : _b, _c = _a.lazyObservable, lazyObservable = _c === void 0 ? false : _c, _d = _a.forced, forced = _d === void 0 ? false : _d;
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData, viewData = data.viewData;
    var treeColumnName = column.treeColumnName;
    var rawRow = rawData[rowIndex];
    if (!forced && observable_1.isObservable(rawRow)) {
        return;
    }
    if (treeColumnName) {
        var parentRow = data_2.findRowByRowKey(data, column, id, rawRow._attributes.tree.parentRowKey);
        rawData[rowIndex] = tree_2.createTreeRawRow(id, rawRow, parentRow || null, column, {
            lazyObservable: lazyObservable,
        });
    }
    else {
        rawData[rowIndex] = data_1.createRawRow(id, rawRow, rowIndex, column, { lazyObservable: lazyObservable });
    }
    viewData[rowIndex] = data_1.createViewRow(id, rawData[rowIndex], rawData, column);
    if (!silent) {
        observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    }
}
exports.makeObservable = makeObservable;
function setValue(store, rowKey, columnName, value, checkCellState) {
    if (checkCellState === void 0) { checkCellState = false; }
    var gridEvent;
    var column = store.column, data = store.data, id = store.id;
    var eventBus = eventBus_1.getEventBus(id);
    var rawData = data.rawData, viewData = data.viewData, sortState = data.sortState;
    var allColumnMap = column.allColumnMap, columnsWithoutRowHeader = column.columnsWithoutRowHeader;
    var rowIndex = data_2.findIndexByRowKey(data, column, id, rowKey, false);
    var targetRow = rawData[rowIndex];
    if (!targetRow || targetRow[columnName] === value) {
        return;
    }
    if (checkCellState) {
        makeObservable({ store: store, rowIndex: rowIndex });
        var _a = viewData[rowIndex].valueMap[columnName], disabled = _a.disabled, editable = _a.editable;
        if (disabled || !editable) {
            return;
        }
    }
    rowSpan_2.resetRowSpan(store);
    var targetColumn = common_1.findProp('name', columnName, columnsWithoutRowHeader);
    var orgValue = targetRow[columnName];
    // @TODO: 'onBeforeChange' event is deprecated. This event will be replaced with 'beforeChange' event
    if (targetColumn && targetColumn.onBeforeChange) {
        gridEvent = new gridEvent_1.default({ rowKey: rowKey, columnName: columnName, value: orgValue, nextValue: value });
        targetColumn.onBeforeChange(gridEvent);
        if (gridEvent.isStopped()) {
            rowSpan_2.updateRowSpan(store);
            return;
        }
    }
    var change = { rowKey: rowKey, columnName: columnName, value: orgValue, nextValue: value };
    gridEvent = new gridEvent_1.default({ origin: 'cell', changes: [change] });
    /**
     * Occurs before one or more cells is changed
     * @event Grid#beforeChange
     * @property {string} origin - The type of change('paste', 'delete', 'cell')
     * @property {Array.<object>} changes - rowKey, column name, original values and next values before changing the values
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('beforeChange', gridEvent);
    if (gridEvent.isStopped()) {
        rowSpan_2.updateRowSpan(store);
        return;
    }
    value = change.nextValue;
    var rowSpanMap = targetRow.rowSpanMap;
    var columns = sortState.columns;
    var index = common_1.findPropIndex('columnName', columnName, columns);
    validation_1.replaceColumnUniqueInfoMap(id, column, { rowKey: rowKey, columnName: columnName, prevValue: orgValue, value: value });
    targetRow[columnName] = value;
    data_1.setRowRelationListItems(targetRow, allColumnMap);
    if (index !== -1) {
        sort_1.sort(store, columnName, columns[index].ascending, true, false);
    }
    setTimeout(function () {
        updateHeightsWithFilteredData(store);
    });
    summary_1.updateSummaryValueByCell(store, columnName, { orgValue: orgValue, value: value });
    instance_1.getDataManager(id).push('UPDATE', [targetRow]);
    if (!common_1.isEmpty(rowSpanMap) && rowSpanMap[columnName] && rowSpan_1.isRowSpanEnabled(sortState, column)) {
        var spanCount = rowSpanMap[columnName].spanCount;
        // update sub rows value
        for (var count = 1; count < spanCount; count += 1) {
            rawData[rowIndex + count][columnName] = value;
            summary_1.updateSummaryValueByCell(store, columnName, { orgValue: orgValue, value: value });
            instance_1.getDataManager(id).push('UPDATE', [rawData[rowIndex + count]]);
        }
    }
    column_2.setAutoResizingColumnWidths(store);
    // @TODO: 'onAfterChange' event is deprecated. This event will be replaced with 'afterChange' event
    if (targetColumn && targetColumn.onAfterChange) {
        gridEvent = new gridEvent_1.default({ rowKey: rowKey, columnName: columnName, value: value, prevValue: orgValue });
        targetColumn.onAfterChange(gridEvent);
    }
    gridEvent = new gridEvent_1.default({
        origin: 'cell',
        changes: [{ rowKey: rowKey, columnName: columnName, value: value, prevValue: orgValue }],
    });
    /**
     * Occurs after one or more cells is changed
     * @event Grid#afterChange
     * @property {string} origin - The type of change('paste', 'delete', 'cell')
     * @property {Array.<object>} changes - rowKey, column name, previous values and changed values after changing the values
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('afterChange', gridEvent);
    rowSpan_2.updateRowSpan(store);
}
exports.setValue = setValue;
function isUpdatableRowAttr(name, checkDisabled) {
    return !(name === 'checked' && checkDisabled);
}
exports.isUpdatableRowAttr = isUpdatableRowAttr;
function setRowAttribute(_a, rowKey, attrName, value) {
    var data = _a.data, column = _a.column, id = _a.id;
    var targetRow = data_2.findRowByRowKey(data, column, id, rowKey, false);
    // https://github.com/microsoft/TypeScript/issues/34293
    if (targetRow && isUpdatableRowAttr(attrName, targetRow._attributes.checkDisabled)) {
        targetRow._attributes[attrName] = value;
    }
}
exports.setRowAttribute = setRowAttribute;
function setRowsAttributeInRange(store, attrName, value, range) {
    var _a;
    (_a = store.data.filteredRawData).slice.apply(_a, range).forEach(function (row) {
        if (isUpdatableRowAttr(attrName, row._attributes.checkDisabled)) {
            row._attributes[attrName] = value;
        }
    });
}
exports.setRowsAttributeInRange = setRowsAttributeInRange;
function setAllRowAttribute(_a, attrName, value, allPage) {
    var data = _a.data;
    if (allPage === void 0) { allPage = true; }
    var filteredRawData = data.filteredRawData;
    var range = allPage ? [0, filteredRawData.length] : data.pageRowRange;
    filteredRawData.slice.apply(filteredRawData, range).forEach(function (row) {
        if (isUpdatableRowAttr(attrName, row._attributes.checkDisabled)) {
            // https://github.com/microsoft/TypeScript/issues/34293
            row._attributes[attrName] = value;
        }
    });
}
exports.setAllRowAttribute = setAllRowAttribute;
function setColumnValues(store, columnName, value, checkCellState) {
    if (checkCellState === void 0) { checkCellState = false; }
    if (checkCellState) {
        // @TODO: find more practical way to make observable
        lazyObservable_1.createObservableData(store, true);
    }
    var id = store.id, data = store.data, column = store.column;
    data.rawData.forEach(function (targetRow, index) {
        var valid = true;
        if (checkCellState) {
            var _a = data.viewData[index].valueMap[columnName], disabled = _a.disabled, editable = _a.editable;
            valid = !disabled && editable;
        }
        if (targetRow[columnName] !== value && valid) {
            validation_1.replaceColumnUniqueInfoMap(id, column, {
                rowKey: targetRow.rowKey,
                columnName: columnName,
                prevValue: targetRow[columnName],
                value: value,
            });
            targetRow[columnName] = value;
            instance_1.getDataManager(id).push('UPDATE', [targetRow]);
        }
    });
    summary_1.updateSummaryValueByColumn(store, columnName, { value: value });
    validation_1.forceValidateUniquenessOfColumn(data.rawData, column, columnName);
    column_2.setAutoResizingColumnWidths(store);
    rowSpan_2.updateRowSpan(store);
}
exports.setColumnValues = setColumnValues;
function check(store, rowKey) {
    var id = store.id, column = store.column, data = store.data;
    var allColumnMap = column.allColumnMap, _a = column.treeColumnName, treeColumnName = _a === void 0 ? '' : _a;
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default({ rowKey: rowKey });
    data.clickedCheckboxRowkey = rowKey;
    setRowAttribute(store, rowKey, 'checked', true);
    if (allColumnMap[treeColumnName]) {
        tree_1.changeTreeRowsCheckedState(store, rowKey, true);
    }
    observable_1.asyncInvokeObserver(function () {
        setCheckedAllRows(store);
    });
    /**
     * Occurs when a checkbox in row header is checked
     * @event Grid#check
     * @property {number | string} [rowKey] - rowKey of the checked row(when single check via click)
     * @property {Array<number | string>} [rowKeys] - rowKeys of the checked rows(when multiple check via shift-click)
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('check', gridEvent);
}
exports.check = check;
function uncheck(store, rowKey) {
    var id = store.id, column = store.column, data = store.data;
    var allColumnMap = column.allColumnMap, _a = column.treeColumnName, treeColumnName = _a === void 0 ? '' : _a;
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default({ rowKey: rowKey });
    data.clickedCheckboxRowkey = rowKey;
    setRowAttribute(store, rowKey, 'checked', false);
    if (allColumnMap[treeColumnName]) {
        tree_1.changeTreeRowsCheckedState(store, rowKey, false);
    }
    observable_1.asyncInvokeObserver(function () {
        setCheckedAllRows(store);
    });
    /**
     * Occurs when a checkbox in row header is unchecked
     * @event Grid#uncheck
     * @property {number | string} [rowKey] - rowKey of the unchecked row(when single check via click)
     * @property {Array<number | string>} [rowKeys] - rowKeys of the unchecked rows(when multiple unchecked via shift-click)
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('uncheck', gridEvent);
}
exports.uncheck = uncheck;
function setCheckboxBetween(store, value, startRowKey, endRowKey) {
    var data = store.data, id = store.id;
    var clickedCheckboxRowkey = data.clickedCheckboxRowkey;
    var targetRowKey = endRowKey || clickedCheckboxRowkey;
    var eventBus = eventBus_1.getEventBus(id);
    if (common_1.isNil(targetRowKey)) {
        if (value) {
            check(store, startRowKey);
        }
        else {
            uncheck(store, startRowKey);
        }
        return;
    }
    var range = getIndexRangeOfCheckbox(store, startRowKey, targetRowKey);
    var checkStateChangedRowkeys = data_2.getCheckStateChangedRowkeysInRange(store, value, range);
    var eventArgs = { rowKey: startRowKey, rowKeys: checkStateChangedRowkeys };
    var gridEventBefore = new gridEvent_1.default(eventArgs);
    /**
     * Occurs before the http request is sent
     * @event Grid#beforeRequest
     * @type {module:event/gridEvent}
     * @property {XMLHttpRequest} xhr - Current XMLHttpRequest instance
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('beforeCheckBetween', gridEventBefore);
    if (gridEventBefore.isStopped()) {
        if (value) {
            check(store, startRowKey);
        }
        else {
            uncheck(store, startRowKey);
        }
        return;
    }
    data.clickedCheckboxRowkey = startRowKey;
    setRowsAttributeInRange(store, 'checked', value, range);
    setCheckedAllRows(store);
    var gridEvent = new gridEvent_1.default(eventArgs);
    eventBus.trigger(value ? 'check' : 'uncheck', gridEvent);
}
exports.setCheckboxBetween = setCheckboxBetween;
function checkAll(store, allPage) {
    var id = store.id;
    setAllRowAttribute(store, 'checked', true, allPage);
    setCheckedAllRows(store);
    observable_1.notify(store.data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default();
    /**
     * Occurs when a checkbox in header is checked(checked all checkbox in row header)
     * @event Grid#checkAll
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('checkAll', gridEvent);
}
exports.checkAll = checkAll;
function uncheckAll(store, allPage) {
    var id = store.id;
    setAllRowAttribute(store, 'checked', false, allPage);
    setCheckedAllRows(store);
    observable_1.notify(store.data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default();
    /**
     * Occurs when a checkbox in header is unchecked(unchecked all checkbox in row header)
     * @event Grid#uncheckAll
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('uncheckAll', gridEvent);
}
exports.uncheckAll = uncheckAll;
function setDisabledAllCheckbox(_a) {
    var data = _a.data;
    var rawData = data.rawData;
    data.disabledAllCheckbox =
        !!rawData.length && rawData.every(function (row) { return row._attributes.checkDisabled; });
}
exports.setDisabledAllCheckbox = setDisabledAllCheckbox;
function setRowOrColumnDisabled(target, disabled) {
    if (target.disabled === disabled) {
        observable_1.notify(target, 'disabled');
    }
    else {
        target.disabled = disabled;
    }
}
// @TODO consider the client pagination with disabled
function setDisabled(store, disabled) {
    var data = store.data, column = store.column;
    data.rawData.forEach(function (row) {
        row._disabledPriority = {};
        setAllRowAttribute(store, 'disabled', disabled);
        setAllRowAttribute(store, 'checkDisabled', disabled);
    });
    column.columnsWithoutRowHeader.forEach(function (columnInfo) {
        columnInfo.disabled = disabled;
    });
    data.disabledAllCheckbox = disabled;
}
exports.setDisabled = setDisabled;
function setRowDisabled(store, disabled, rowKey, withCheckbox) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey, false);
    if (row) {
        var _attributes = row._attributes, _disabledPriority_1 = row._disabledPriority;
        column.allColumns.forEach(function (columnInfo) {
            _disabledPriority_1[columnInfo.name] = constant_1.DISABLED_PRIORITY_ROW;
        });
        if (withCheckbox) {
            _attributes.checkDisabled = disabled;
            setDisabledAllCheckbox(store);
        }
        setRowOrColumnDisabled(_attributes, disabled);
    }
}
exports.setRowDisabled = setRowDisabled;
function setColumnDisabled(_a, disabled, columnName) {
    var data = _a.data, column = _a.column;
    if (column_1.isRowHeader(columnName)) {
        return;
    }
    data.rawData.forEach(function (row) {
        row._disabledPriority[columnName] = constant_1.DISABLED_PRIORITY_COLUMN;
    });
    setRowOrColumnDisabled(column.allColumnMap[columnName], disabled);
}
exports.setColumnDisabled = setColumnDisabled;
function setCellDisabled(store, disabled, rowKey, columnName) {
    var data = store.data, column = store.column, id = store.id;
    if (column_1.isRowNumColumn(columnName) || column_1.isDragColumn(columnName)) {
        return;
    }
    var row = data_2.findRowByRowKey(data, column, id, rowKey, false);
    if (row) {
        var _attributes = row._attributes, _disabledPriority = row._disabledPriority;
        _disabledPriority[columnName] = disabled ? constant_1.DISABLED_PRIORITY_CELL : constant_1.DISABLED_PRIORITY_NONE;
        if (column_1.isCheckboxColumn(columnName)) {
            _attributes.checkDisabled = disabled;
            setDisabledAllCheckbox(store);
        }
        observable_1.notify(row, '_disabledPriority');
    }
}
exports.setCellDisabled = setCellDisabled;
function setRowCheckDisabled(store, disabled, rowKey) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey, false);
    if (row) {
        row._attributes.checkDisabled = disabled;
        setDisabledAllCheckbox(store);
    }
}
exports.setRowCheckDisabled = setRowCheckDisabled;
function appendRow(store, row, options) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData, viewData = data.viewData, sortState = data.sortState, pageOptions = data.pageOptions;
    var _a = options.at, at = _a === void 0 ? rawData.length : _a, extendPrevRowSpan = options.extendPrevRowSpan;
    var _b = data_2.getCreatedRowInfo(store, at, row), rawRow = _b.rawRow, viewRow = _b.viewRow, prevRow = _b.prevRow;
    var inserted = at !== rawData.length;
    common_1.silentSplice(rawData, at, 0, rawRow);
    common_1.silentSplice(viewData, at, 0, viewRow);
    makeObservable({ store: store, rowIndex: at });
    pagination_1.updatePageOptions(store, { totalCount: pageOptions.totalCount + 1 });
    updateHeights(store);
    if (inserted) {
        sort_1.updateSortKey(data, at);
    }
    sort_1.sortByCurrentState(store);
    if (rowSpan_1.isRowSpanEnabled(sortState, column)) {
        if (prevRow) {
            rowSpan_2.updateRowSpanWhenAppending(rawData, prevRow, extendPrevRowSpan || false);
        }
        rowSpan_2.updateRowSpan(store);
    }
    instance_1.getDataManager(id).push('CREATE', [rawRow], inserted);
    summary_1.updateSummaryValueByRow(store, rawRow, { type: 'APPEND' });
    postUpdateAfterManipulation(store, at, 'DONE', [rawRow]);
}
exports.appendRow = appendRow;
function removeRow(store, rowKey, options) {
    var data = store.data, id = store.id, focus = store.focus, column = store.column;
    var rawData = data.rawData, viewData = data.viewData, sortState = data.sortState;
    var rowIndex = data_2.findIndexByRowKey(data, column, id, rowKey, false);
    if (rowIndex === -1) {
        return;
    }
    var removedRow = {};
    var nextRow = rawData[rowIndex + 1];
    pagination_1.updatePageWhenRemovingRow(store, 1);
    validation_1.removeUniqueInfoMap(id, rawData[rowIndex], column);
    observable_1.batchObserver(function () {
        removedRow = rawData.splice(rowIndex, 1)[0];
    });
    viewData.splice(rowIndex, 1);
    updateHeights(store);
    if (!common_1.someProp('rowKey', focus.rowKey, rawData)) {
        focus_1.initFocus(store);
    }
    selection_1.initSelection(store);
    if (nextRow && rowSpan_1.isRowSpanEnabled(sortState, column)) {
        rowSpan_2.updateRowSpanWhenRemoving(rawData, removedRow, nextRow, options.keepRowSpanData || false);
    }
    if (rowIndex !== rawData.length) {
        sort_1.updateSortKey(data, removedRow.sortKey + 1, false);
    }
    instance_1.getDataManager(id).push('DELETE', [removedRow]);
    summary_1.updateSummaryValueByRow(store, removedRow, { type: 'REMOVE' });
    postUpdateAfterManipulation(store, rowIndex, data_2.getLoadingState(rawData));
}
exports.removeRow = removeRow;
function clearData(store) {
    var data = store.data, id = store.id, rowCoords = store.rowCoords;
    validation_1.createNewValidationMap(id);
    viewport_1.initScrollPosition(store);
    focus_1.initFocus(store);
    selection_1.initSelection(store);
    sort_1.initSortState(data);
    filter_1.initFilter(store);
    rowCoords.heights = [];
    data.rawData = [];
    data.viewData = [];
    pagination_1.updatePageOptions(store, { totalCount: 0, page: 1 }, true);
    summary_1.updateAllSummaryValues(store);
    setLoadingState(store, 'EMPTY');
    setCheckedAllRows(store);
    instance_1.getDataManager(id).clearAll();
}
exports.clearData = clearData;
function resetData(store, inputData, options) {
    var data = store.data, column = store.column, id = store.id;
    var sortState = options.sortState, filterState = options.filterState, pageState = options.pageState;
    validation_1.createNewValidationMap(id);
    var _a = data_1.createData(id, inputData, column, { lazyObservable: true }), rawData = _a.rawData, viewData = _a.viewData;
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default();
    viewport_1.initScrollPosition(store);
    focus_1.initFocus(store);
    selection_1.initSelection(store);
    sort_1.resetSortState(store, sortState);
    filter_1.resetFilterState(store, filterState);
    pagination_1.resetPageState(store, rawData.length, pageState);
    data.rawData = rawData;
    data.viewData = viewData;
    updateHeights(store);
    summary_1.updateAllSummaryValues(store);
    setLoadingState(store, data_2.getLoadingState(rawData));
    setCheckedAllRows(store);
    instance_1.getDataManager(id).setOriginData(inputData);
    instance_1.getDataManager(id).clearAll();
    column_2.setColumnWidthsByText(store);
    rowSpan_2.updateRowSpan(store);
    setTimeout(function () {
        /**
         * Occurs when the grid data is updated and the grid is rendered onto the DOM
         * The event occurs only in the following API as below.
         * 'resetData', 'restore', 'reloadData', 'readData', 'setPerPage' with 'dataSource', using 'dataSource'
         * @event Grid#onGridUpdated
         * @property {Grid} instance - Current grid instance
         */
        eventBus.trigger('onGridUpdated', gridEvent);
    });
}
exports.resetData = resetData;
function addRowClassName(store, rowKey, className) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey, false);
    if (row) {
        var rowClassMap = row._attributes.className.row;
        var isExist = common_1.includes(rowClassMap, className);
        if (!isExist) {
            rowClassMap.push(className);
            observable_1.notify(row._attributes, 'className');
        }
    }
}
exports.addRowClassName = addRowClassName;
function removeRowClassName(store, rowKey, className) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey, false);
    if (row) {
        common_1.removeArrayItem(className, row._attributes.className.row);
        observable_1.notify(row._attributes, 'className');
    }
}
exports.removeRowClassName = removeRowClassName;
function addClassNameToAttribute(row, columnName, className) {
    var columnClassNames = row._attributes.className.column[columnName];
    row._attributes.className.column[columnName] = data_2.getAddedClassName(className, columnClassNames);
    observable_1.notify(row._attributes, 'className');
}
function removeClassNameToAttribute(row, columnName, className) {
    var columnClassNames = row._attributes.className.column[columnName];
    if (columnClassNames) {
        row._attributes.className.column[columnName] = data_2.getRemovedClassName(className, columnClassNames);
    }
    observable_1.notify(row._attributes, 'className');
}
function addCellClassName(store, rowKey, columnName, className) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey, false);
    if (row) {
        addClassNameToAttribute(row, columnName, className);
    }
}
exports.addCellClassName = addCellClassName;
function removeCellClassName(store, rowKey, columnName, className) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        removeClassNameToAttribute(row, columnName, className);
    }
}
exports.removeCellClassName = removeCellClassName;
function addColumnClassName(_a, columnName, className) {
    var data = _a.data;
    var rawData = data.rawData;
    rawData.forEach(function (row) {
        addClassNameToAttribute(row, columnName, className);
    });
}
exports.addColumnClassName = addColumnClassName;
function removeColumnClassName(_a, columnName, className) {
    var data = _a.data;
    var rawData = data.rawData;
    rawData.forEach(function (row) {
        removeClassNameToAttribute(row, columnName, className);
    });
}
exports.removeColumnClassName = removeColumnClassName;
function setLoadingState(_a, state) {
    var data = _a.data;
    data.loadingState = state;
}
exports.setLoadingState = setLoadingState;
function setCheckedAllRows(_a) {
    var data = _a.data;
    var filteredRawData = data.filteredRawData, pageRowRange = data.pageRowRange;
    var result = false;
    if (filteredRawData.length) {
        var enableCheckRows = filteredRawData
            .slice.apply(filteredRawData, pageRowRange).filter(function (row) { return !row._attributes.checkDisabled; });
        result = !!enableCheckRows.length && enableCheckRows.every(function (row) { return row._attributes.checked; });
    }
    data.checkedAllRows = result;
}
exports.setCheckedAllRows = setCheckedAllRows;
function updateRowNumber(_a, startIndex) {
    var data = _a.data;
    var rawData = data.rawData;
    for (var idx = startIndex; idx < rawData.length; idx += 1) {
        rawData[idx]._attributes.rowNum = idx + 1;
    }
}
exports.updateRowNumber = updateRowNumber;
function setRow(store, rowIndex, row) {
    var data = store.data, id = store.id, column = store.column;
    var rawData = data.rawData, viewData = data.viewData, sortState = data.sortState;
    var orgRow = rawData[rowIndex];
    if (!orgRow) {
        return;
    }
    validation_1.removeUniqueInfoMap(id, orgRow, column);
    row.sortKey = orgRow.sortKey;
    var _a = data_2.getCreatedRowInfo(store, rowIndex, row, orgRow.rowKey), rawRow = _a.rawRow, viewRow = _a.viewRow, prevRow = _a.prevRow;
    common_1.silentSplice(rawData, rowIndex, 1, rawRow);
    common_1.silentSplice(viewData, rowIndex, 1, viewRow);
    makeObservable({ store: store, rowIndex: rowIndex });
    sort_1.sortByCurrentState(store);
    if (prevRow && rowSpan_1.isRowSpanEnabled(sortState, column)) {
        rowSpan_2.updateRowSpanWhenAppending(rawData, prevRow, false);
    }
    instance_1.getDataManager(id).push('UPDATE', [rawRow]);
    setTimeout(function () {
        updateHeightsWithFilteredData(store);
    });
    summary_1.updateSummaryValueByRow(store, rawRow, { type: 'SET', orgRow: orgRow });
    postUpdateAfterManipulation(store, rowIndex, 'DONE');
    rowSpan_2.updateRowSpan(store);
}
exports.setRow = setRow;
function spliceContinuousRowInfos(data, continuousRowInfo) {
    var rawData = data.rawData, viewData = data.viewData;
    var startRowIndex = continuousRowInfo.rowIndices[0];
    var sizeOfContinuousRowInfos = continuousRowInfo.rowIndices.length;
    common_1.silentSplice.apply(void 0, tslib_1.__spreadArrays([rawData, startRowIndex, sizeOfContinuousRowInfos], continuousRowInfo.rawRows));
    common_1.silentSplice.apply(void 0, tslib_1.__spreadArrays([viewData, startRowIndex, sizeOfContinuousRowInfos], continuousRowInfo.viewRows));
}
function setRows(store, rows) {
    var data = store.data, column = store.column, id = store.id, viewport = store.viewport;
    var rawData = data.rawData, sortState = data.sortState;
    var rowRange = viewport.rowRange;
    var sortedIndexedRows = rows
        .map(function (row) {
        var rowIndex = data_2.findIndexByRowKey(data, column, id, row.rowKey, false);
        var orgRow = rawData[rowIndex];
        validation_1.removeUniqueInfoMap(id, orgRow, column);
        row.sortKey = orgRow.sortKey;
        return { rowIndex: rowIndex, row: row, orgRow: orgRow };
    })
        .sort(function (prev, current) { return prev.rowIndex - current.rowIndex; });
    var createdRowInfos = data_2.getCreatedRowInfos(store, sortedIndexedRows);
    var continuousRowInfo = {
        rowIndices: [],
        rawRows: [],
        viewRows: [],
    };
    createdRowInfos.forEach(function (_a) {
        var rowIndex = _a.rowIndex, row = _a.row;
        var rawRow = row.rawRow, viewRow = row.viewRow;
        if (continuousRowInfo.rowIndices.length === 0 ||
            common_1.last(continuousRowInfo.rowIndices) === rowIndex - 1) {
            continuousRowInfo.rowIndices.push(rowIndex);
            continuousRowInfo.rawRows.push(rawRow);
            continuousRowInfo.viewRows.push(viewRow);
        }
        else {
            spliceContinuousRowInfos(data, continuousRowInfo);
            continuousRowInfo = {
                rowIndices: [rowIndex],
                rawRows: [rawRow],
                viewRows: [viewRow],
            };
        }
    });
    spliceContinuousRowInfos(data, continuousRowInfo);
    createdRowInfos
        .filter(function (_a) {
        var rowIndex = _a.rowIndex;
        return common_1.isBetween(rowIndex, rowRange[0], rowRange[1]);
    })
        .forEach(function (_a) {
        var rowIndex = _a.rowIndex;
        return makeObservable({ store: store, rowIndex: rowIndex, silent: false, lazyObservable: true });
    });
    if (rowSpan_1.isRowSpanEnabled(sortState, column)) {
        createdRowInfos
            .filter(function (_a) {
            var prevRow = _a.row.prevRow;
            return !!prevRow;
        })
            .forEach(function (_a) {
            var prevRow = _a.row.prevRow;
            return rowSpan_2.updateRowSpanWhenAppending(rawData, prevRow, false);
        });
    }
    instance_1.getDataManager(id).push('UPDATE', createdRowInfos.map(function (_a) {
        var row = _a.row;
        return row.rawRow;
    }));
    sort_1.sortByCurrentState(store);
    postUpdateAfterManipulation(store, createdRowInfos[0].rowIndex, 'DONE');
    setTimeout(function () {
        updateHeightsWithFilteredData(store);
    });
    rowSpan_2.updateRowSpan(store);
    summary_1.updateAllSummaryValues(store);
}
exports.setRows = setRows;
function moveRow(store, rowKey, targetIndex) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData, viewData = data.viewData;
    if (!rawData[targetIndex] || data_2.isSorted(data) || data_2.isFiltered(data)) {
        return;
    }
    var currentIndex = data_2.findIndexByRowKey(data, column, id, rowKey, false);
    if (currentIndex === -1) {
        return;
    }
    var minIndex = Math.min(currentIndex, targetIndex);
    var rawRow = common_1.silentSplice(rawData, currentIndex, 1)[0];
    var viewRow = common_1.silentSplice(viewData, currentIndex, 1)[0];
    observable_1.batchObserver(function () {
        rawData.splice(targetIndex, 0, rawRow);
    });
    viewData.splice(targetIndex, 0, viewRow);
    renderState_1.fitRowHeightWhenMovingRow(store, currentIndex, targetIndex);
    sort_1.resetSortKey(data, minIndex);
    updateRowNumber(store, minIndex);
    instance_1.getDataManager(id).push('UPDATE', [rawRow], true);
}
exports.moveRow = moveRow;
function scrollToNext(store) {
    var data = store.data, id = store.id;
    var _a = data.pageOptions, page = _a.page, totalCount = _a.totalCount, perPage = _a.perPage, useClient = _a.useClient;
    if (data_2.isScrollPagination(data)) {
        if (useClient) {
            data.pageOptions.page += 1;
            observable_1.notify(data, 'pageOptions');
            sort_1.sortByCurrentState(store);
            updateHeights(store);
            setCheckedAllRows(store);
        }
        else if (page * perPage < totalCount) {
            data.pageOptions.page += 1;
            instance_1.getDataProvider(id).readData(data.pageOptions.page);
        }
    }
}
exports.scrollToNext = scrollToNext;
function appendRows(store, inputData) {
    var data = store.data, column = store.column, id = store.id;
    var startIndex = data.rawData.length;
    var _a = data_1.createData(id, inputData, column, { lazyObservable: true }), rawData = _a.rawData, viewData = _a.viewData;
    if (!column.keyColumnName) {
        var rowKey_1 = data_2.getMaxRowKey(data);
        rawData.forEach(function (row, index) {
            row.rowKey = rowKey_1 + index;
        });
        viewData.forEach(function (row, index) {
            row.rowKey = rowKey_1 + index;
        });
    }
    var newRawData = data.rawData.concat(rawData);
    var newViewData = data.viewData.concat(viewData);
    data.rawData = newRawData;
    data.viewData = newViewData;
    sort_1.resetSortKey(data, startIndex);
    sort_1.sortByCurrentState(store);
    updateHeights(store);
    rawData.forEach(function (rawRow) { return instance_1.getDataManager(id).push('CREATE', [rawRow]); });
    postUpdateAfterManipulation(store, startIndex, 'DONE', rawData);
    rowSpan_2.updateRowSpan(store);
}
exports.appendRows = appendRows;
function removeRows(store, targetRows) {
    var data = store.data, id = store.id, focus = store.focus, column = store.column;
    var sortState = data.sortState, viewData = data.viewData, rawData = data.rawData;
    var rowIndexes = targetRows.rowIndices, rows = targetRows.rows, nextRows = targetRows.nextRows;
    var deletedCount = rowIndexes.length;
    pagination_1.updatePageWhenRemovingRow(store, deletedCount);
    rowIndexes.forEach(function (rowIndex, i) {
        var nextRow = nextRows[i];
        var removedRow = common_1.silentSplice(rawData, rowIndex - i, 1)[0];
        common_1.silentSplice(viewData, rowIndex - i, 1);
        validation_1.removeUniqueInfoMap(id, removedRow, column);
        if (nextRow) {
            if (rowSpan_1.isRowSpanEnabled(sortState, column)) {
                rowSpan_2.updateRowSpanWhenRemoving(rawData, removedRow, nextRow, false);
            }
        }
        instance_1.getDataManager(id).push('DELETE', [removedRow]);
    });
    sort_1.resetSortKey(data, 0);
    observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    updateHeights(store);
    if (common_1.someProp('rowKey', focus.rowKey, rows)) {
        focus_1.initFocus(store);
    }
    selection_1.initSelection(store);
    summary_1.updateAllSummaryValues(store);
    postUpdateAfterManipulation(store, rowIndexes[0], data_2.getLoadingState(rawData));
}
exports.removeRows = removeRows;
function postUpdateAfterManipulation(store, rowIndex, state, rows) {
    setLoadingState(store, state);
    updateRowNumber(store, rowIndex);
    setDisabledAllCheckbox(store);
    setCheckedAllRows(store);
    validation_1.forceValidateUniquenessOfColumns(store.data.rawData, store.column);
    column_2.setAutoResizingColumnWidths(store, rows);
}


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.createData = exports.createRawRow = exports.setRowRelationListItems = exports.createViewRow = exports.createRowSpan = exports.generateDataCreationKey = void 0;
var tslib_1 = __webpack_require__(1);
var observable_1 = __webpack_require__(5);
var column_1 = __webpack_require__(11);
var common_1 = __webpack_require__(0);
var tree_1 = __webpack_require__(20);
var validation_1 = __webpack_require__(27);
var data_1 = __webpack_require__(6);
var data_2 = __webpack_require__(23);
var constant_1 = __webpack_require__(8);
var dataCreationKey = '';
function generateDataCreationKey() {
    dataCreationKey = "@dataKey" + Date.now();
    return dataCreationKey;
}
exports.generateDataCreationKey = generateDataCreationKey;
function getRelationCbResult(fn, relationParams) {
    var result = common_1.isFunction(fn) ? fn(relationParams) : null;
    return common_1.isUndefined(result) ? null : result;
}
function getEditable(fn, relationParams) {
    var result = getRelationCbResult(fn, relationParams);
    return result === null ? true : result;
}
function getDisabled(fn, relationParams) {
    var result = getRelationCbResult(fn, relationParams);
    return result === null ? false : result;
}
function getListItems(fn, relationParams) {
    return getRelationCbResult(fn, relationParams) || [];
}
function getRowHeaderValue(row, columnName) {
    if (column_1.isRowNumColumn(columnName)) {
        return row._attributes.rowNum;
    }
    if (column_1.isCheckboxColumn(columnName)) {
        return row._attributes.checked;
    }
    return '';
}
function createRowSpan(mainRow, rowKey, count, spanCount) {
    return { mainRow: mainRow, mainRowKey: rowKey, count: count, spanCount: spanCount };
}
exports.createRowSpan = createRowSpan;
function createViewCell(id, row, column, _a) {
    var _b = _a.isDataModified, isDataModified = _b === void 0 ? false : _b, prevInvalidStates = _a.prevInvalidStates, _c = _a.relationInfo, relationInfo = _c === void 0 ? {} : _c;
    var _d = relationInfo.relationMatched, relationMatched = _d === void 0 ? true : _d, relationListItems = relationInfo.relationListItems;
    var name = column.name, formatter = column.formatter, editor = column.editor, validation = column.validation, defaultValue = column.defaultValue;
    var value = column_1.isRowHeader(name) ? getRowHeaderValue(row, name) : row[name];
    if (common_1.isNil(value) && !common_1.isNil(defaultValue)) {
        value = defaultValue;
    }
    if (!relationMatched) {
        value = '';
    }
    var formatterProps = { row: row, column: column, value: value };
    var _e = row._attributes, disabled = _e.disabled, checkDisabled = _e.checkDisabled, classNameAttr = _e.className;
    var columnDisabled = !!column.disabled;
    var rowDisabled = column_1.isCheckboxColumn(name) ? checkDisabled : disabled;
    var columnClassName = common_1.isUndefined(classNameAttr.column[name]) ? [] : classNameAttr.column[name];
    var className = tslib_1.__spreadArrays(classNameAttr.row, columnClassName).join(' ');
    var _disabledPriority = row._disabledPriority[name];
    var cellDisabled = rowDisabled || columnDisabled;
    if (_disabledPriority === constant_1.DISABLED_PRIORITY_CELL) {
        cellDisabled = true;
    }
    else if (_disabledPriority === constant_1.DISABLED_PRIORITY_NONE) {
        cellDisabled = false;
    }
    else if (_disabledPriority === constant_1.DISABLED_PRIORITY_COLUMN) {
        cellDisabled = columnDisabled;
    }
    else if (_disabledPriority === constant_1.DISABLED_PRIORITY_ROW) {
        cellDisabled = rowDisabled;
    }
    var usePrevInvalidStates = !isDataModified && !common_1.isNil(prevInvalidStates);
    var invalidStates = usePrevInvalidStates
        ? prevInvalidStates
        : validation_1.getValidationCode({ id: id, value: row[name], row: row, validation: validation, columnName: name });
    return {
        editable: !!editor,
        className: className,
        disabled: cellDisabled,
        invalidStates: invalidStates,
        formattedValue: data_2.getFormattedValue(formatterProps, formatter, value, relationListItems),
        value: value,
    };
}
function createRelationViewCell(id, name, row, _a) {
    var columnMap = _a.columnMap, valueMap = _a.valueMap;
    var _b = valueMap[name], editable = _b.editable, disabled = _b.disabled, value = _b.value;
    var _c = columnMap[name].relationMap, relationMap = _c === void 0 ? {} : _c;
    Object.keys(relationMap).forEach(function (targetName) {
        var _a = relationMap[targetName], editableCallback = _a.editable, disabledCallback = _a.disabled, listItemsCallback = _a.listItems;
        var relationCbParams = { value: value, editable: editable, disabled: disabled, row: row };
        var targetEditable = getEditable(editableCallback, relationCbParams);
        var targetDisabled = getDisabled(disabledCallback, relationCbParams);
        var targetListItems = getListItems(listItemsCallback, relationCbParams);
        var targetValue = row[targetName];
        var targetEditor = columnMap[targetName].editor;
        var targetEditorOptions = targetEditor === null || targetEditor === void 0 ? void 0 : targetEditor.options;
        var relationMatched = common_1.isFunction(listItemsCallback)
            ? common_1.someProp('value', targetValue, targetListItems)
            : true;
        var cellData = createViewCell(id, row, columnMap[targetName], {
            relationInfo: {
                relationMatched: relationMatched,
                relationListItems: targetListItems,
            },
        });
        if (!targetEditable) {
            cellData.editable = false;
        }
        if (targetDisabled) {
            cellData.disabled = true;
        }
        // should set the relation list to relationListItemMap for preventing to share relation list in other rows
        if (targetEditorOptions) {
            targetEditorOptions.relationListItemMap = targetEditorOptions.relationListItemMap || {};
            targetEditorOptions.relationListItemMap[row.rowKey] = targetListItems;
        }
        valueMap[targetName] = cellData;
    });
}
function createViewRow(id, row, rawData, column) {
    var rowKey = row.rowKey, sortKey = row.sortKey, rowSpanMap = row.rowSpanMap, uniqueKey = row.uniqueKey;
    var columnMap = column.columnMapWithRelation;
    var treeColumnName = column.treeColumnName, _a = column.treeIcon, treeIcon = _a === void 0 ? true : _a, treeIndentWidth = column.treeIndentWidth;
    var initValueMap = {};
    Object.keys(columnMap).forEach(function (name) {
        initValueMap[name] = null;
    });
    var cachedValueMap = {};
    var valueMap = observable_1.observable(initValueMap);
    var __unobserveFns__ = [];
    Object.keys(columnMap).forEach(function (name) {
        var _a = columnMap[name], related = _a.related, relationMap = _a.relationMap, className = _a.className;
        if (className) {
            row._attributes.className.column[name] = className.split(' ');
        }
        // add condition expression to prevent to call watch function recursively
        if (!related) {
            __unobserveFns__.push(observable_1.observe(function (calledBy) {
                var _a;
                var isDataModified = calledBy !== 'className';
                cachedValueMap[name] = createViewCell(id, row, columnMap[name], {
                    isDataModified: isDataModified,
                    prevInvalidStates: (_a = cachedValueMap[name]) === null || _a === void 0 ? void 0 : _a.invalidStates,
                });
                valueMap[name] = cachedValueMap[name];
            }));
        }
        if (relationMap && Object.keys(relationMap).length) {
            __unobserveFns__.push(observable_1.observe(function () {
                createRelationViewCell(id, name, row, { columnMap: columnMap, valueMap: valueMap });
            }));
        }
    });
    return tslib_1.__assign({ rowKey: rowKey,
        sortKey: sortKey,
        uniqueKey: uniqueKey,
        rowSpanMap: rowSpanMap,
        valueMap: valueMap,
        __unobserveFns__: __unobserveFns__ }, (treeColumnName && {
        treeInfo: tree_1.createTreeCellInfo(rawData, row, treeIndentWidth, treeIcon),
    }));
}
exports.createViewRow = createViewRow;
function getAttributes(row, index, lazyObservable, disabled) {
    var defaultAttr = {
        rowNum: index + 1,
        checked: false,
        disabled: disabled,
        checkDisabled: disabled,
        className: {
            row: [],
            column: {},
        },
    };
    if (row._attributes) {
        if (common_1.isBoolean(row._attributes.disabled) && common_1.isUndefined(row._attributes.checkDisabled)) {
            row._attributes.checkDisabled = row._attributes.disabled;
        }
        if (!common_1.isUndefined(row._attributes.className)) {
            row._attributes.className = tslib_1.__assign({ row: [], column: {} }, row._attributes.className);
        }
    }
    var attributes = tslib_1.__assign(tslib_1.__assign({}, defaultAttr), row._attributes);
    return lazyObservable ? attributes : observable_1.observable(attributes);
}
function createRelationListItems(name, row, columnMap) {
    var _a = columnMap[name], _b = _a.relationMap, relationMap = _b === void 0 ? {} : _b, editor = _a.editor;
    var _c = row._attributes, checkDisabled = _c.checkDisabled, rowDisabled = _c.disabled;
    var editable = !!editor;
    var disabled = column_1.isCheckboxColumn(name) ? checkDisabled : rowDisabled;
    var value = row[name];
    var relationCbParams = { value: value, editable: editable, disabled: disabled, row: row };
    var relationListItemMap = {};
    Object.keys(relationMap).forEach(function (targetName) {
        relationListItemMap[targetName] = getListItems(relationMap[targetName].listItems, relationCbParams);
    });
    return relationListItemMap;
}
function setRowRelationListItems(row, columnMap) {
    var relationListItemMap = tslib_1.__assign({}, row._relationListItemMap);
    Object.keys(columnMap).forEach(function (name) {
        common_1.assign(relationListItemMap, createRelationListItems(name, row, columnMap));
    });
    row._relationListItemMap = relationListItemMap;
}
exports.setRowRelationListItems = setRowRelationListItems;
function createMainRowSpanMap(rowSpan, rowKey) {
    var mainRowSpanMap = {};
    if (!rowSpan) {
        return mainRowSpanMap;
    }
    Object.keys(rowSpan).forEach(function (columnName) {
        var spanCount = rowSpan[columnName];
        mainRowSpanMap[columnName] = createRowSpan(true, rowKey, spanCount, spanCount);
    });
    return mainRowSpanMap;
}
function createSubRowSpan(prevRowSpanMap) {
    var subRowSpanMap = {};
    Object.keys(prevRowSpanMap).forEach(function (columnName) {
        var prevRowSpan = prevRowSpanMap[columnName];
        var mainRowKey = prevRowSpan.mainRowKey, count = prevRowSpan.count, spanCount = prevRowSpan.spanCount;
        if (spanCount > 1 && spanCount > 1 - count) {
            var subRowCount = count >= 0 ? -1 : count - 1;
            subRowSpanMap[columnName] = createRowSpan(false, mainRowKey, subRowCount, spanCount);
        }
    });
    return subRowSpanMap;
}
function createRowSpanMap(row, rowSpan, prevRow) {
    var rowKey = row.rowKey;
    var mainRowSpanMap = {};
    var subRowSpanMap = {};
    if (!common_1.isEmpty(rowSpan)) {
        mainRowSpanMap = createMainRowSpanMap(rowSpan, rowKey);
    }
    if (prevRow) {
        var prevRowSpanMap = prevRow.rowSpanMap;
        if (!common_1.isEmpty(prevRowSpanMap)) {
            subRowSpanMap = createSubRowSpan(prevRowSpanMap);
        }
    }
    return tslib_1.__assign(tslib_1.__assign({}, mainRowSpanMap), subRowSpanMap);
}
function createRawRow(id, row, index, column, options) {
    var _a, _b;
    if (options === void 0) { options = {}; }
    // this rowSpan variable is attribute option before creating rowSpanDataMap
    var rowSpan = (_a = row._attributes) === null || _a === void 0 ? void 0 : _a.rowSpan;
    var keyColumnName = options.keyColumnName, prevRow = options.prevRow, _c = options.lazyObservable, lazyObservable = _c === void 0 ? false : _c, _d = options.disabled, disabled = _d === void 0 ? false : _d;
    if (keyColumnName) {
        row.rowKey = row[keyColumnName];
    }
    else if (common_1.isUndefined(row.rowKey)) {
        row.rowKey = index;
    }
    row.sortKey = common_1.isNumber(row.sortKey) ? row.sortKey : index;
    row.uniqueKey = dataCreationKey + "-" + row.rowKey;
    row._attributes = getAttributes(row, index, lazyObservable, disabled);
    row._attributes.rowSpan = rowSpan;
    row._disabledPriority = row._disabledPriority || {};
    row.rowSpanMap = (_b = row.rowSpanMap) !== null && _b !== void 0 ? _b : createRowSpanMap(row, rowSpan, prevRow);
    setRowRelationListItems(row, column.columnMapWithRelation);
    if (column.autoResizingColumn.length) {
        data_2.setMaxTextMap(column, row);
    }
    if (lazyObservable) {
        validation_1.addUniqueInfoMap(id, row, column);
    }
    return (lazyObservable ? row : observable_1.observable(row));
}
exports.createRawRow = createRawRow;
function createData(id, data, column, _a) {
    var _b = _a.lazyObservable, lazyObservable = _b === void 0 ? false : _b, prevRows = _a.prevRows, _c = _a.disabled, disabled = _c === void 0 ? false : _c;
    generateDataCreationKey();
    var keyColumnName = column.keyColumnName, _d = column.treeColumnName, treeColumnName = _d === void 0 ? '' : _d;
    var rawData;
    // Notify when using deprecated option "_attribute.rowSpan".
    var isUseRowSpanOption = data.some(function (row) { var _a; return (_a = row._attributes) === null || _a === void 0 ? void 0 : _a.rowSpan; });
    if (isUseRowSpanOption) {
        // eslint-disable-next-line no-console
        console.warn('The option "_attribute.rowSpan" is deprecated. Please use rowSpan option of column.\nFollow example: http://nhn.github.io/tui.grid/latest/tutorial-example29-dynamic-row-span');
    }
    if (treeColumnName) {
        rawData = tree_1.createTreeRawData({
            id: id,
            data: data,
            column: column,
            keyColumnName: keyColumnName,
            lazyObservable: lazyObservable,
            disabled: disabled,
        });
    }
    else {
        rawData = data.map(function (row, index, rows) {
            return createRawRow(id, row, index, column, {
                keyColumnName: keyColumnName,
                prevRow: prevRows ? prevRows[index] : rows[index - 1],
                lazyObservable: lazyObservable,
                disabled: disabled,
            });
        });
    }
    var viewData = rawData.map(function (row) {
        return lazyObservable
            ? { rowKey: row.rowKey, sortKey: row.sortKey, uniqueKey: row.uniqueKey }
            : createViewRow(id, row, rawData, column);
    });
    return { rawData: rawData, viewData: viewData };
}
exports.createData = createData;
var cachedFilteredIndex = {};
function applyFilterToRawData(rawData, filters, columnMap) {
    var data = rawData;
    cachedFilteredIndex = {};
    if (filters) {
        data = filters.reduce(function (acc, filter) {
            var conditionFn = filter.conditionFn, columnName = filter.columnName;
            var formatter = columnMap[columnName].formatter;
            return acc.filter(function (row, index) {
                var value = row[columnName];
                var relationListItems = row._relationListItemMap[columnName];
                var formatterProps = { row: row, column: columnMap[columnName], value: value };
                var filtered = conditionFn(data_2.getFormattedValue(formatterProps, formatter, value, relationListItems));
                // cache the filtered index for performance
                if (acc === rawData && filtered) {
                    cachedFilteredIndex[row.rowKey] = index;
                }
                else if (!filtered) {
                    cachedFilteredIndex[row.rowKey] = null;
                }
                return filtered;
            });
        }, rawData);
    }
    return data;
}
function createPageOptions(userPageOptions, rawData) {
    var pageOptions = (common_1.isEmpty(userPageOptions)
        ? {}
        : tslib_1.__assign(tslib_1.__assign({ useClient: false, page: 1, perPage: constant_1.DEFAULT_PER_PAGE, type: 'pagination' }, userPageOptions), { totalCount: userPageOptions.useClient ? rawData.length : userPageOptions.totalCount }));
    if (pageOptions.type === 'pagination') {
        pageOptions.position = pageOptions.position || 'bottom';
        pageOptions.visiblePages = pageOptions.visiblePages || 10;
    }
    return pageOptions;
}
function create(_a) {
    var data = _a.data, column = _a.column, userPageOptions = _a.pageOptions, useClientSort = _a.useClientSort, disabled = _a.disabled, id = _a.id;
    var _b = createData(id, data, column, { lazyObservable: true, disabled: disabled }), rawData = _b.rawData, viewData = _b.viewData;
    var sortState = {
        useClient: useClientSort,
        columns: [
            {
                columnName: 'sortKey',
                ascending: true,
            },
        ],
    };
    var pageOptions = createPageOptions(userPageOptions, rawData);
    return observable_1.observable({
        rawData: rawData,
        viewData: viewData,
        sortState: sortState,
        pageOptions: pageOptions,
        checkedAllRows: rawData.length ? !rawData.some(function (row) { return !row._attributes.checked; }) : false,
        disabledAllCheckbox: disabled,
        filters: null,
        loadingState: rawData.length ? 'DONE' : 'EMPTY',
        clickedCheckboxRowkey: null,
        get filteredRawData() {
            var _a;
            if (this.filters) {
                // should filter the sliced data which is displayed in viewport in case of client infinite scrolling
                var targetData = data_1.isScrollPagination(this, true)
                    ? (_a = this.rawData).slice.apply(_a, this.pageRowRange) : this.rawData;
                return applyFilterToRawData(targetData, this.filters, column.allColumnMap);
            }
            return this.rawData;
        },
        get filteredIndex() {
            var _a = this, filteredRawData = _a.filteredRawData, filters = _a.filters;
            return filters
                ? filteredRawData
                    .filter(function (row) { return !common_1.isNull(cachedFilteredIndex[row.rowKey]); })
                    .map(function (row) { return cachedFilteredIndex[row.rowKey]; })
                : null;
        },
        get filteredViewData() {
            var _this = this;
            return this.filters
                ? this.filteredIndex.map(function (index) { return _this.viewData[index]; })
                : this.viewData;
        },
        get pageRowRange() {
            var _a = this.pageOptions, useClient = _a.useClient, type = _a.type, page = _a.page, perPage = _a.perPage;
            var start = 0;
            // should calculate the range through all rawData in case of client infinite scrolling
            var end = data_1.isScrollPagination(this, true) ? this.rawData.length : this.filteredViewData.length;
            if (useClient) {
                var pageRowLastIndex = page * perPage;
                if (type === 'pagination') {
                    start = (page - 1) * perPage;
                }
                end = pageRowLastIndex > 0 && pageRowLastIndex < end ? pageRowLastIndex : end;
            }
            return [start, end];
        },
    });
}
exports.create = create;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.initSelection = exports.setSelection = exports.changeSelectionRange = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var eventBus_1 = __webpack_require__(7);
var selection_1 = __webpack_require__(22);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var rowSpan_1 = __webpack_require__(13);
function changeSelectionRange(selection, inputRange, id) {
    if (!selection_1.isSameInputRange(selection.inputRange, inputRange)) {
        selection.inputRange = inputRange;
        var eventBus = eventBus_1.getEventBus(id);
        var gridEvent = new gridEvent_1.default({ range: selection.rangeWithRowHeader });
        /**
         * Occurs when selecting cells
         * @event Grid#selection
         * @property {Object} range - Range of selection
         * @property {Array} range.start - Info of start cell (ex: [rowKey, columnName])
         * @property {Array} range.end - Info of end cell (ex: [rowKey, columnName])
         * @property {Grid} instance - Current grid instance
         */
        eventBus.trigger('selection', gridEvent);
    }
}
exports.changeSelectionRange = changeSelectionRange;
function setSelection(store, range) {
    var _a;
    var selection = store.selection, data = store.data, column = store.column, id = store.id;
    var visibleColumnsWithRowHeader = column.visibleColumnsWithRowHeader, rowHeaderCount = column.rowHeaderCount;
    var viewData = data.viewData;
    var rowLength = viewData.length;
    var columnLength = visibleColumnsWithRowHeader.length;
    var startRowIndex = common_1.clamp(range.start[0], 0, rowLength - 1);
    var endRowIndex = common_1.clamp(range.end[0], 0, rowLength - 1);
    var startColumnIndex = common_1.clamp(range.start[1] + rowHeaderCount, rowHeaderCount, columnLength - 1);
    var endColumnIndex = common_1.clamp(range.end[1] + rowHeaderCount, rowHeaderCount, columnLength - 1);
    _a = rowSpan_1.getRowRangeWithRowSpan([startRowIndex, endRowIndex], [startColumnIndex, endColumnIndex], column, null, data), startRowIndex = _a[0], endRowIndex = _a[1];
    var inputRange = {
        row: [startRowIndex, endRowIndex],
        column: [startColumnIndex, endColumnIndex],
    };
    changeSelectionRange(selection, inputRange, id);
}
exports.setSelection = setSelection;
function initSelection(store) {
    store.selection.inputRange = null;
}
exports.initSelection = initSelection;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isArrowKey = exports.isNonPrintableKey = exports.keyEventGenerate = exports.getKeyStrokeString = exports.keyStrokeCommandMap = exports.keyboardEventCommandMap = exports.keyboardEventTypeMap = exports.keyNameMap = void 0;
var common_1 = __webpack_require__(0);
exports.keyNameMap = {
    8: 'backspace',
    9: 'tab',
    13: 'enter',
    16: 'shift',
    17: 'ctrl',
    27: 'esc',
    37: 'left',
    38: 'up',
    39: 'right',
    40: 'down',
    65: 'a',
    67: 'c',
    86: 'v',
    32: 'space',
    33: 'pageUp',
    34: 'pageDown',
    36: 'home',
    35: 'end',
    46: 'del',
};
exports.keyboardEventTypeMap = {
    move: 'move',
    edit: 'edit',
    remove: 'remove',
    select: 'select',
    clipboard: 'clipboard',
};
exports.keyboardEventCommandMap = {
    up: 'up',
    down: 'down',
    left: 'left',
    right: 'right',
    pageUp: 'pageUp',
    pageDown: 'pageDown',
    firstColumn: 'firstColumn',
    lastColumn: 'lastColumn',
    currentCell: 'currentCell',
    nextCell: 'nextCell',
    prevCell: 'prevCell',
    firstCell: 'firstCell',
    lastCell: 'lastCell',
    all: 'all',
    copy: 'copy',
    paste: 'paste',
};
/**
 * K-V object for matching keystroke and event command
 * K: keystroke (order : ctrl -> shift -> keyName)
 * V: [key event type, command]
 * @type {Object}
 * @ignore
 */
exports.keyStrokeCommandMap = {
    up: ['move', 'up'],
    down: ['move', 'down'],
    left: ['move', 'left'],
    right: ['move', 'right'],
    pageUp: ['move', 'pageUp'],
    pageDown: ['move', 'pageDown'],
    home: ['move', 'firstColumn'],
    end: ['move', 'lastColumn'],
    enter: ['edit', 'currentCell'],
    space: ['edit', 'currentCell'],
    tab: ['edit', 'nextCell'],
    backspace: ['remove'],
    del: ['remove'],
    'shift-tab': ['edit', 'prevCell'],
    'shift-up': ['select', 'up'],
    'shift-down': ['select', 'down'],
    'shift-left': ['select', 'left'],
    'shift-right': ['select', 'right'],
    'shift-pageUp': ['select', 'pageUp'],
    'shift-pageDown': ['select', 'pageDown'],
    'shift-home': ['select', 'firstColumn'],
    'shift-end': ['select', 'lastColumn'],
    'ctrl-a': ['select', 'all'],
    'ctrl-c': ['clipboard', 'copy'],
    'ctrl-v': ['clipboard', 'paste'],
    'ctrl-home': ['move', 'firstCell'],
    'ctrl-end': ['move', 'lastCell'],
    'ctrl-shift-home': ['select', 'firstCell'],
    'ctrl-shift-end': ['select', 'lastCell'],
};
/**
 * Returns the keyStroke string
 * @param {Event} ev - Keyboard event
 * @returns {String}
 * @ignore
 */
function getKeyStrokeString(ev) {
    var keys = [];
    var keyCode = ev.keyCode, ctrlKey = ev.ctrlKey, metaKey = ev.metaKey, shiftKey = ev.shiftKey;
    if (ctrlKey || metaKey) {
        keys.push('ctrl');
    }
    if (shiftKey) {
        keys.push('shift');
    }
    if (keyCode in exports.keyNameMap) {
        keys.push(exports.keyNameMap[keyCode]);
    }
    return keys.join('-');
}
exports.getKeyStrokeString = getKeyStrokeString;
function keyEventGenerate(ev) {
    var keyStroke = getKeyStrokeString(ev);
    var commandInfo = exports.keyStrokeCommandMap[keyStroke];
    return commandInfo
        ? {
            keyStroke: keyStroke,
            type: commandInfo[0],
            command: commandInfo[1],
        }
        : {};
}
exports.keyEventGenerate = keyEventGenerate;
function isNonPrintableKey(keyCode) {
    var keys = [
        'shift',
        'ctrl',
        'esc',
        'left',
        'up',
        'right',
        'down',
        'pageUp',
        'pageDown',
        'end',
        'home',
    ];
    var key = exports.keyNameMap[keyCode];
    return common_1.includes(keys, key);
}
exports.isNonPrintableKey = isNonPrintableKey;
function isArrowKey(keyName) {
    return common_1.includes(['up', 'down', 'left', 'right'], keyName);
}
exports.isArrowKey = isArrowKey;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.setFocusInfo = exports.saveAndFinishEditing = exports.initFocus = exports.changeFocus = exports.finishEditing = exports.startEditing = void 0;
var tslib_1 = __webpack_require__(1);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var eventBus_1 = __webpack_require__(7);
var data_1 = __webpack_require__(6);
var focus_1 = __webpack_require__(45);
var rowSpan_1 = __webpack_require__(13);
var data_2 = __webpack_require__(14);
var common_1 = __webpack_require__(0);
var column_1 = __webpack_require__(12);
function startEditing(store, rowKey, columnName) {
    var data = store.data, focus = store.focus, column = store.column, id = store.id;
    var filteredRawData = data.filteredRawData;
    var foundIndex = data_1.findIndexByRowKey(data, column, id, rowKey);
    if (foundIndex === -1) {
        return;
    }
    // makes the data observable to judge editable, disable of the cell
    data_2.makeObservable({ store: store, rowIndex: data_1.findIndexByRowKey(data, column, id, rowKey, false) });
    if (!data_1.isEditableCell(store, foundIndex, columnName)) {
        return;
    }
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default({
        rowKey: rowKey,
        columnName: columnName,
        value: filteredRawData[foundIndex][columnName],
    });
    /**
     * Occurs when editing the cell is started
     * @event Grid#editingStart
     * @property {number} rowKey - rowKey of the target cell
     * @property {number} columnName - columnName of the target cell
     * @property {number | string | boolean | null | undefined} value - value of the editing cell
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('editingStart', gridEvent);
    if (!gridEvent.isStopped()) {
        focus.forcedDestroyEditing = false;
        focus.navigating = false;
        focus.editingAddress = { rowKey: rowKey, columnName: columnName };
    }
}
exports.startEditing = startEditing;
// @TODO: Events should be separated(ex.'editingFinish', 'editingCanceled')
function finishEditing(_a, rowKey, columnName, value, editingInfo) {
    var focus = _a.focus, id = _a.id;
    if (focus_1.isEditingCell(focus, rowKey, columnName)) {
        focus.editingAddress = null;
        focus.navigating = true;
    }
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default(tslib_1.__assign({ rowKey: rowKey, columnName: columnName, value: value }, editingInfo));
    /**
     * Occurs when editing the cell is finished
     * @event Grid#editingFinish
     * @property {number} rowKey - rowKey of the target cell
     * @property {number} columnName - columnName of the target cell
     * @property {number | string | boolean | null | undefined} value - value of the editing cell
     * @property {Grid} instance - Current grid instance
     * @property {boolean} save - Whether to save the value
     * @property {boolean} triggeredByKey - Whether to trigger the event by key
     */
    eventBus.trigger('editingFinish', gridEvent);
}
exports.finishEditing = finishEditing;
function changeFocus(store, rowKey, columnName, id) {
    var data = store.data, focus = store.focus, column = store.column;
    if (focus_1.isFocusedCell(focus, rowKey, columnName) ||
        (columnName && column_1.isHiddenColumn(column, columnName))) {
        return;
    }
    var rawData = data.rawData, sortState = data.sortState;
    var eventBus = eventBus_1.getEventBus(id);
    var gridEvent = new gridEvent_1.default({
        rowKey: rowKey,
        columnName: columnName,
        prevColumnName: focus.columnName,
        prevRowKey: focus.rowKey,
    });
    /**
     * Occurs when focused cell is about to change
     * @event Grid#focusChange
     * @property {number} rowKey - rowKey of the target cell
     * @property {number} columnName - columnName of the target cell
     * @property {number} prevRowKey - rowKey of the currently focused cell
     * @property {number} prevColumnName - columnName of the currently focused cell
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('focusChange', gridEvent);
    if (!gridEvent.isStopped()) {
        var focusRowKey = rowKey;
        if (rowKey && columnName && rowSpan_1.isRowSpanEnabled(sortState, column)) {
            var rowSpan = rowSpan_1.getRowSpanByRowKey(rowKey, columnName, rawData);
            if (rowSpan) {
                focusRowKey = rowSpan.mainRowKey;
            }
        }
        focus.prevColumnName = focus.columnName;
        focus.prevRowKey = focus.rowKey;
        focus.columnName = columnName;
        focus.rowKey = focusRowKey;
    }
}
exports.changeFocus = changeFocus;
function initFocus(_a) {
    var focus = _a.focus;
    focus.editingAddress = null;
    focus.navigating = false;
    focus.rowKey = null;
    focus.columnName = null;
    focus.prevRowKey = null;
    focus.prevColumnName = null;
}
exports.initFocus = initFocus;
function saveAndFinishEditing(store, value) {
    // @TODO: remove 'value' paramter
    // saveAndFinishEditing(store: Store)
    var focus = store.focus, data = store.data, column = store.column, id = store.id;
    var editingAddress = focus.editingAddress;
    if (!editingAddress) {
        return;
    }
    var rowKey = editingAddress.rowKey, columnName = editingAddress.columnName;
    // makes the data observable to judge editable, disable of the cell.
    data_2.makeObservable({ store: store, rowIndex: data_1.findIndexByRowKey(data, column, id, rowKey, false) });
    // if value is 'undefined', editing result is saved and finished.
    if (common_1.isUndefined(value)) {
        focus.forcedDestroyEditing = true;
        focus.editingAddress = null;
        focus.navigating = true;
        return;
    }
    data_2.setValue(store, rowKey, columnName, value);
    finishEditing(store, rowKey, columnName, value, { save: true });
}
exports.saveAndFinishEditing = saveAndFinishEditing;
function setFocusInfo(store, rowKey, columnName, navigating) {
    var focus = store.focus, id = store.id;
    focus.navigating = navigating;
    changeFocus(store, rowKey, columnName, id);
}
exports.setFocusInfo = setFocusInfo;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = __webpack_require__(1);
var messages = {
    en: {
        display: {
            noData: 'No data.',
            loadingData: 'Loading data.',
            resizeHandleGuide: 'You can change the width of the column by mouse drag, and initialize the width by double-clicking.',
        },
        net: {
            confirmCreate: 'Are you sure you want to create {{count}} data?',
            confirmUpdate: 'Are you sure you want to update {{count}} data?',
            confirmDelete: 'Are you sure you want to delete {{count}} data?',
            confirmModify: 'Are you sure you want to modify {{count}} data?',
            noDataToCreate: 'No data to create.',
            noDataToUpdate: 'No data to update.',
            noDataToDelete: 'No data to delete.',
            noDataToModify: 'No data to modify.',
            failResponse: 'An error occurred while requesting data.\nPlease try again.',
        },
        filter: {
            contains: 'Contains',
            eq: 'Equals',
            ne: 'Not equals',
            start: 'Starts with',
            end: 'Ends with',
            after: 'After',
            afterEq: 'After or Equal',
            before: 'Before',
            beforeEq: 'Before or Equal',
            apply: 'Apply',
            clear: 'Clear',
            selectAll: 'Select All',
            emptyValue: 'Empty Value',
        },
        contextMenu: {
            copy: 'Copy',
            copyColumns: 'Copy Columns',
            copyRows: 'Copy Rows',
            export: 'Export',
            txtExport: 'Text Export',
            csvExport: 'CSV Export',
            excelExport: 'Excel Export',
        },
    },
    pt: {
        display: {
            noData: 'Nenhuma informação.',
            loadingData: 'Carregando informações.',
            resizeHandleGuide: 'Você pode alterar a largura da coluna arrastando o mouse e inicializar a largura clicando duas vezes.',
        },
        net: {
            confirmCreate: 'Tem certeza que deseja criar {{count}} dados?',
            confirmUpdate: 'Tem ceretza que deseja atualizar {{count}} dados?',
            confirmDelete: 'Tem certeza que deseja apagar {{count}} dados?',
            confirmModify: 'Tem certeza que deseja modificar {{count}} dados?',
            noDataToCreate: 'Não há informação a criar.',
            noDataToUpdate: 'Não há informação a atualizar.',
            noDataToDelete: 'Não há informação a apagar.',
            noDataToModify: 'Não há informação a modificar.',
            failResponse: 'Um erro ocorreu euquanto processava sua solicitação.\nPor favor, tente novamente.',
        },
        filter: {
            contains: 'Contém',
            eq: 'Igual',
            ne: 'Diferente de',
            start: 'Começa com',
            end: 'Termina com',
            after: 'Depois',
            afterEq: 'Depois ou igual',
            before: 'Antes',
            beforeEq: 'Antes ou igual',
            apply: 'Aplicar',
            clear: 'Limpar',
            selectAll: 'Selecionar tudo',
            emptyValue: 'Está vazio',
        },
        contextMenu: {
            copy: 'Copiar',
            copyColumns: 'Copiar colunas',
            copyRows: 'Copiar linhas',
            export: 'Exportar',
            txtExport: 'Exportar Texto',
            csvExport: 'Exportar CSV',
            excelExport: 'Exportar Excel',
        },
    },
    es: {
        display: {
            noData: 'No hay información.',
            loadingData: 'Cargando información.',
            resizeHandleGuide: 'Puedes cambiar el ancho de la columna arrastrando el ratón e inicializar el ancho haciendo doble clic.',
        },
        net: {
            confirmCreate: '¿Estás seguro que quieres crear {{count}} filas?',
            confirmUpdate: '¿Estás seguro que quieres actualizar {{count}} filas?',
            confirmDelete: '¿Estás seguro que quieres eliminar {{count}} filas?',
            confirmModify: '¿Estás seguro que quieres modificar {{count}} filas?',
            noDataToCreate: 'No hay información para crear.',
            noDataToUpdate: 'No hay información para actualizar.',
            noDataToDelete: 'No hay información para eliminar.',
            noDataToModify: 'No hay información para modificar.',
            failResponse: 'Se produjo un error al solicitar datos. \nVuelve a intentarlo.',
        },
        filter: {
            contains: 'Contiene',
            eq: 'Igual',
            ne: 'Distinto',
            start: 'Empieza con',
            end: 'Termina en',
            after: 'Después',
            afterEq: 'Después o Igual',
            before: 'Antes',
            beforeEq: 'Antes o Igual',
            apply: 'Aplicar',
            clear: 'Limpiar',
            selectAll: 'Seleccionar Todo',
            emptyValue: 'Vaciar Valor',
        },
        contextMenu: {
            copy: 'Copiar',
            copyColumns: 'Copiar Columnas',
            copyRows: 'Copiar Filas',
            export: 'exportar',
            txtExport: 'Texto exportar',
            csvExport: 'CSV exportar',
            excelExport: 'Excel exportar',
        },
    },
    ko: {
        display: {
            noData: '데이터가 존재하지 않습니다.',
            loadingData: '데이터를 불러오는 중입니다.',
            resizeHandleGuide: '마우스 드래그하여 컬럼 너비를 조정할 수 있고, 더블 클릭으로 컬럼 너비를 초기화할 수 있습니다.',
        },
        net: {
            confirmCreate: '{{count}}건의 데이터를 생성하겠습니까?',
            confirmUpdate: '{{count}}건의 데이터를 수정하겠습니까?',
            confirmDelete: '{{count}}건의 데이터를 삭제하겠습니까?',
            confirmModify: '{{count}}건의 데이터를 처리하겠습니까?',
            noDataToCreate: '생성할 데이터가 없습니다.',
            noDataToUpdate: '수정할 데이터가 없습니다.',
            noDataToDelete: '삭제할 데이터가 없습니다.',
            noDataToModify: '처리할 데이터가 없습니다.',
            failResponse: '데이터 요청 중에 에러가 발생하였습니다.\n다시 시도하여 주시기 바랍니다.',
        },
        filter: {
            contains: 'Contains',
            eq: 'Equals',
            ne: 'Not equals',
            start: 'Starts with',
            end: 'Ends with',
            after: 'After',
            afterEq: 'After or Equal',
            before: 'Before',
            beforeEq: 'Before or Equal',
            apply: 'Apply',
            clear: 'Clear',
            selectAll: 'Select All',
            emptyValue: 'Empty Value',
        },
        contextMenu: {
            copy: '복사',
            copyColumns: '열 복사',
            copyRows: '행 복사',
            export: '내보내기',
            txtExport: 'Text로 내보내기',
            csvExport: 'CSV로 내보내기',
            excelExport: '엑셀로 내보내기',
        },
    },
    nl: {
        display: {
            noData: 'Geen data.',
            loadingData: 'Data aan het laden.',
            resizeHandleGuide: 'Je kunt de kolombreedte verschuiven met de muis, of terugbrengen naar standaard door dubbel te klikken',
        },
        net: {
            confirmCreate: 'Weet je zeker dat je {{count}} nieuwe wilt maken?',
            confirmUpdate: 'Weet je zeker dat je {{count}} stuk(s) wilt bijwerken?',
            confirmDelete: 'Weet je zeker dat je {{count}} stuk(s) wilt verwijderen?',
            confirmModify: 'Weet je zeker dat je {{count}} stuk(s) wilt aanpassen?',
            noDataToCreate: 'Niets om aan te maken.',
            noDataToUpdate: 'Niets om bij te werken.',
            noDataToDelete: 'Niets om te verwijderen.',
            noDataToModify: 'Niets om aan te passen.',
            failResponse: 'Er ging iets mis tijdens het ophalen van de data.\nProbeer het nog eens.',
        },
        filter: {
            contains: 'Bevat',
            eq: 'Is',
            ne: 'Is niet',
            start: 'Begint met',
            end: 'Eindigt met',
            after: 'Na',
            afterEq: 'Na of gelijk aan',
            before: 'Voor',
            beforeEq: 'Voor of gelijk aan',
            apply: 'Toepassen',
            clear: 'Leeg maken',
            selectAll: 'Selecteer alle',
            emptyValue: 'Lege waarde',
        },
        contextMenu: {
            copy: 'Kopieer',
            copyColumns: 'Kopieer kolommen',
            copyRows: 'Kopieer rijen',
            export: 'Exporteer',
            txtExport: 'Maak Tekst Export',
            csvExport: 'Maak CSV Export',
            excelExport: 'Maak Excel Export',
        },
    },
    it: {
        display: {
            noData: 'Nessun dato.',
            loadingData: 'Caricamento dati.',
            resizeHandleGuide: 'È possibile modificare la larghezza della colonna trascinando il mouse e inizializzare la larghezza facendo doppio clic.',
        },
        net: {
            confirmCreate: 'Sei sicuro di voler creare {{count}} dati?',
            confirmUpdate: 'Sei sicuro di voler aggiornare {{count}} dati?',
            confirmDelete: 'Sei sicuro di voler eliminare {{count}} dati?',
            confirmModify: 'Sei sicuro di voler modificare {{count}} dati?',
            noDataToCreate: 'Nessun dato da creare.',
            noDataToUpdate: 'Nessun dato da aggiornare.',
            noDataToDelete: 'Nessun dato da eliminare.',
            noDataToModify: 'Nessun dato da modificare.',
            failResponse: 'Si è verificato un errore durante la richiesta dei dati.\nPer favore riprova.',
        },
        filter: {
            contains: 'Contiene',
            eq: 'Uguale',
            ne: 'Non è uguale',
            start: 'Inizia con',
            end: 'Finisce con',
            after: 'Dopo',
            afterEq: 'Dopo o Uguale',
            before: 'Prima',
            beforeEq: 'Prima o Uguale',
            apply: 'Applicare',
            clear: 'Chiari',
            selectAll: 'Seleziona tutto',
            emptyValue: 'Valore vuoto',
        },
        contextMenu: {
            copy: 'Copia',
            copyColumns: 'Copia colonne',
            copyRows: 'Copia righe',
            export: 'Esportare',
            txtExport: 'Esportazione Testo',
            csvExport: 'Esportazione CSV',
            excelExport: 'Esportazione Excel',
        },
    },
};
var messageMap = {};
/**
 * Flatten message map
 * @param {object} data - Messages
 * @returns {object} Flatten message object (key format is 'key.subKey')
 * @ignore
 */
function flattenMessageMap(data) {
    if (data === void 0) { data = {}; }
    var obj = {};
    var newKey;
    Object.keys(data).forEach(function (key) {
        var keyWithType = key;
        var groupMessages = data[keyWithType];
        Object.keys(groupMessages).forEach(function (subKey) {
            newKey = key + "." + subKey;
            obj[newKey] = groupMessages[subKey];
        });
    });
    return obj;
}
/**
 * Replace text
 * @param {string} text - Text including handlebar expression
 * @param {Object} values - Replaced values
 * @returns {string} Replaced text
 */
function replaceText(text, values) {
    return text
        ? text.replace(/\{\{(\w*)\}\}/g, function (_, prop) { return (values.hasOwnProperty(prop) ? values[prop] : ''); })
        : '';
}
exports.default = {
    /**
     * Set messages
     * @param {string} localeCode - Code to set locale messages and
     *     this is the language or language-region combination. (ex: en-US)
     * @param {object} [data] - Messages using in Grid
     */
    setLanguage: function (localeCode, data) {
        var localeMessages = messages[localeCode];
        if (!localeMessages && !data) {
            throw new Error('You should set messages to map the locale code.');
        }
        var newData = flattenMessageMap(data);
        if (localeMessages) {
            var originData = flattenMessageMap(localeMessages);
            messageMap = tslib_1.__assign(tslib_1.__assign({}, originData), newData);
        }
        else {
            messageMap = newData;
        }
    },
    /**
     * Get message
     * @param {string} key - Key to find message (ex: 'net.confirmCreate')
     * @param {object} [replacements] - Values to replace string
     * @returns {string} Message
     */
    get: function (key, replacements) {
        if (replacements === void 0) { replacements = {}; }
        var message = messageMap[key];
        return replaceText(message, replacements);
    },
};


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getTreeIndentWidth = exports.createTreeCellInfo = exports.createTreeRawData = exports.flattenTreeData = exports.createTreeRawRow = exports.clearTreeRowKeyMap = void 0;
var tslib_1 = __webpack_require__(1);
var data_1 = __webpack_require__(15);
var tree_1 = __webpack_require__(21);
var observable_1 = __webpack_require__(5);
var common_1 = __webpack_require__(0);
var constant_1 = __webpack_require__(8);
var treeRowKeyMap = {};
function clearTreeRowKeyMap(id) {
    delete treeRowKeyMap[id];
}
exports.clearTreeRowKeyMap = clearTreeRowKeyMap;
function generateTreeRowKey(id) {
    var _a;
    treeRowKeyMap[id] = (_a = treeRowKeyMap[id]) !== null && _a !== void 0 ? _a : -1;
    treeRowKeyMap[id] += 1;
    return treeRowKeyMap[id];
}
function addChildRowKey(row, childRow) {
    var tree = row._attributes.tree;
    var rowKey = childRow.rowKey;
    if (tree && !common_1.includes(tree.childRowKeys, rowKey)) {
        tree.childRowKeys.push(rowKey);
    }
    if (!common_1.someProp('rowKey', rowKey, row._children)) {
        row._children.push(childRow);
    }
    row._leaf = false;
}
function insertChildRowKey(row, childRow, offset) {
    var tree = row._attributes.tree;
    var rowKey = childRow.rowKey;
    if (tree && !common_1.includes(tree.childRowKeys, rowKey)) {
        tree.childRowKeys.splice(offset, 0, rowKey);
    }
    if (!common_1.someProp('rowKey', rowKey, row._children)) {
        row._children.splice(offset, 0, childRow);
    }
    row._leaf = false;
}
function getTreeCellInfo(rawData, row, treeIndentWidth, useIcon) {
    var depth = tree_1.getDepth(rawData, row);
    var indentWidth = getTreeIndentWidth(depth, treeIndentWidth, useIcon);
    return {
        depth: depth,
        indentWidth: indentWidth,
        leaf: tree_1.isLeaf(row),
        expanded: tree_1.isExpanded(row),
    };
}
function createTreeRawRow(id, row, parentRow, column, options) {
    if (options === void 0) { options = {}; }
    var childRowKeys = [];
    if (row._attributes && row._attributes.tree) {
        childRowKeys = row._attributes.tree.childRowKeys;
    }
    var keyColumnName = options.keyColumnName, offset = options.offset, _a = options.lazyObservable, lazyObservable = _a === void 0 ? false : _a, _b = options.disabled, disabled = _b === void 0 ? false : _b;
    if (!row._children) {
        row._children = [];
        row._leaf = true;
    }
    // generate new tree rowKey when row doesn't have rowKey
    var targetTreeRowKey = common_1.isUndefined(row.rowKey) ? generateTreeRowKey(id) : Number(row.rowKey);
    var rawRow = data_1.createRawRow(id, row, targetTreeRowKey, column, {
        keyColumnName: keyColumnName,
        lazyObservable: lazyObservable,
        disabled: disabled,
    });
    var defaultAttributes = {
        parentRowKey: parentRow ? parentRow.rowKey : null,
        childRowKeys: childRowKeys,
        hidden: parentRow ? !tree_1.isExpanded(parentRow) || tree_1.isHidden(parentRow) : false,
    };
    if (parentRow) {
        if (!common_1.isUndefined(offset)) {
            insertChildRowKey(parentRow, rawRow, offset);
        }
        else {
            addChildRowKey(parentRow, rawRow);
        }
    }
    var tree = tslib_1.__assign(tslib_1.__assign({}, defaultAttributes), { expanded: row._attributes.expanded });
    rawRow._attributes.tree = lazyObservable ? tree : observable_1.observable(tree);
    return rawRow;
}
exports.createTreeRawRow = createTreeRawRow;
function flattenTreeData(id, data, parentRow, column, options) {
    var flattenedRows = [];
    data.forEach(function (row) {
        var rawRow = createTreeRawRow(id, row, parentRow, column, options);
        flattenedRows.push(rawRow);
        if (Array.isArray(row._children)) {
            if (row._children.length) {
                flattenedRows.push.apply(flattenedRows, flattenTreeData(id, row._children, rawRow, column, options));
            }
        }
    });
    return flattenedRows;
}
exports.flattenTreeData = flattenTreeData;
function createTreeRawData(_a) {
    var id = _a.id, data = _a.data, column = _a.column, keyColumnName = _a.keyColumnName, _b = _a.lazyObservable, lazyObservable = _b === void 0 ? false : _b, _c = _a.disabled, disabled = _c === void 0 ? false : _c;
    // only reset the rowKey on lazy observable data
    if (lazyObservable) {
        treeRowKeyMap[id] = -1;
    }
    return flattenTreeData(id, data, null, column, {
        keyColumnName: keyColumnName,
        lazyObservable: lazyObservable,
        disabled: disabled,
    });
}
exports.createTreeRawData = createTreeRawData;
function createTreeCellInfo(rawData, row, treeIndentWidth, useIcon, lazyObservable) {
    if (lazyObservable === void 0) { lazyObservable = false; }
    var treeCellInfo = getTreeCellInfo(rawData, row, treeIndentWidth, useIcon);
    var treeInfo = lazyObservable ? treeCellInfo : observable_1.observable(treeCellInfo);
    if (!lazyObservable) {
        observable_1.observe(function () {
            treeInfo.expanded = tree_1.isExpanded(row);
            treeInfo.leaf = tree_1.isLeaf(row);
        });
    }
    return treeInfo;
}
exports.createTreeCellInfo = createTreeCellInfo;
function getTreeIndentWidth(depth, treeIndentWidth, showIcon) {
    var indentWidth = treeIndentWidth !== null && treeIndentWidth !== void 0 ? treeIndentWidth : constant_1.TREE_INDENT_WIDTH;
    return constant_1.TREE_INDENT_WIDTH + (depth - 1) * indentWidth + (showIcon ? constant_1.TREE_INDENT_WIDTH : 0);
}
exports.getTreeIndentWidth = getTreeIndentWidth;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getRootParentRow = exports.traverseDescendantRows = exports.traverseAncestorRows = exports.getDepth = exports.isRootChildRow = exports.isExpanded = exports.isLeaf = exports.isHidden = exports.isTreeColumnName = exports.getChildRowKeys = exports.getParentRowKey = exports.getStartIndexToAppendRow = exports.getDescendantRows = exports.getAncestorRows = exports.getChildRows = exports.getParentRow = void 0;
var observable_1 = __webpack_require__(5);
var data_1 = __webpack_require__(6);
var common_1 = __webpack_require__(0);
function getParentRow(store, rowKey, plainObj) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_1.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        var parentRowKey = getParentRowKey(row);
        var parentRow = data_1.findRowByRowKey(data, column, id, parentRowKey);
        if (parentRow) {
            return plainObj ? observable_1.getOriginObject(parentRow) : parentRow;
        }
    }
    return null;
}
exports.getParentRow = getParentRow;
function getChildRows(store, rowKey, plainObj) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_1.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        var childRowKeys = getChildRowKeys(row);
        return childRowKeys.map(function (childRowKey) {
            var childRow = data_1.findRowByRowKey(data, column, id, childRowKey);
            return plainObj ? observable_1.getOriginObject(childRow) : childRow;
        });
    }
    return [];
}
exports.getChildRows = getChildRows;
function getAncestorRows(store, rowKey) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var row = data_1.findRowByRowKey(data, column, id, rowKey);
    var ancestorRows = [];
    if (row) {
        traverseAncestorRows(rawData, row, function (parentRow) {
            ancestorRows.unshift(observable_1.getOriginObject(parentRow));
        });
    }
    return ancestorRows;
}
exports.getAncestorRows = getAncestorRows;
function getDescendantRows(store, rowKey) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var row = data_1.findRowByRowKey(data, column, id, rowKey);
    var childRows = [];
    if (row) {
        traverseDescendantRows(rawData, row, function (childRow) {
            childRows.push(observable_1.getOriginObject(childRow));
        });
    }
    return childRows;
}
exports.getDescendantRows = getDescendantRows;
function getStartIndexToAppendRow(store, parentRow, offset) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var startIdx;
    if (parentRow) {
        if (offset) {
            var childRowKeys = getChildRowKeys(parentRow);
            var prevChildRowKey = childRowKeys[offset - 1];
            var prevChildRowIdx = data_1.findIndexByRowKey(data, column, id, prevChildRowKey);
            var descendantRowsCount = getDescendantRows(store, prevChildRowKey).length;
            startIdx = prevChildRowIdx + descendantRowsCount + 1;
        }
        else {
            startIdx = data_1.findIndexByRowKey(data, column, id, parentRow.rowKey) + 1;
            if (common_1.isUndefined(offset)) {
                startIdx += getDescendantRows(store, parentRow.rowKey).length;
            }
        }
    }
    else {
        startIdx = common_1.isUndefined(offset) ? rawData.length : offset;
    }
    return startIdx;
}
exports.getStartIndexToAppendRow = getStartIndexToAppendRow;
function getParentRowKey(row) {
    var tree = row._attributes.tree;
    return tree && tree.parentRowKey !== row.rowKey ? tree.parentRowKey : null;
}
exports.getParentRowKey = getParentRowKey;
function getChildRowKeys(row) {
    var tree = row._attributes.tree;
    return tree ? tree.childRowKeys.slice() : [];
}
exports.getChildRowKeys = getChildRowKeys;
function isTreeColumnName(column, columnName) {
    return column.treeColumnName === columnName;
}
exports.isTreeColumnName = isTreeColumnName;
function isHidden(_a) {
    var _attributes = _a._attributes;
    var tree = _attributes.tree;
    return !!(tree && tree.hidden);
}
exports.isHidden = isHidden;
function isLeaf(_a) {
    var _attributes = _a._attributes, _leaf = _a._leaf;
    var tree = _attributes.tree;
    return !!tree && !tree.childRowKeys.length && !!_leaf;
}
exports.isLeaf = isLeaf;
function isExpanded(row) {
    var tree = row._attributes.tree;
    return !!(tree && tree.expanded);
}
exports.isExpanded = isExpanded;
function isRootChildRow(row) {
    var tree = row._attributes.tree;
    return !!tree && common_1.isNull(tree.parentRowKey);
}
exports.isRootChildRow = isRootChildRow;
function getDepth(rawData, row) {
    var parentRow = row;
    var depth = 0;
    do {
        depth += 1;
        parentRow = common_1.findProp('rowKey', getParentRowKey(parentRow), rawData);
    } while (parentRow);
    return depth;
}
exports.getDepth = getDepth;
function traverseAncestorRows(rawData, row, iteratee) {
    var parentRowKey = getParentRowKey(row);
    var parentRow;
    while (!common_1.isNull(parentRowKey)) {
        parentRow = common_1.findProp('rowKey', parentRowKey, rawData);
        iteratee(parentRow);
        parentRowKey = parentRow ? getParentRowKey(parentRow) : null;
    }
}
exports.traverseAncestorRows = traverseAncestorRows;
function traverseDescendantRows(rawData, row, iteratee) {
    var childRowKeys = getChildRowKeys(row);
    var rowKey, childRow;
    while (childRowKeys.length) {
        rowKey = childRowKeys.shift();
        childRow = common_1.findProp('rowKey', rowKey, rawData);
        iteratee(childRow);
        if (childRow) {
            childRowKeys = childRowKeys.concat(getChildRowKeys(childRow));
        }
    }
}
exports.traverseDescendantRows = traverseDescendantRows;
function getRootParentRow(rawData, row) {
    var rootParentRow = row;
    do {
        var parentRow = common_1.findProp('rowKey', getParentRowKey(rootParentRow), rawData);
        if (!parentRow) {
            break;
        }
        rootParentRow = parentRow;
    } while (rootParentRow);
    return rootParentRow;
}
exports.getRootParentRow = getRootParentRow;


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getSelectionRange = exports.isSameInputRange = exports.getSortedRange = exports.getChildColumnRange = exports.getLeafChildColumnNames = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var column_1 = __webpack_require__(12);
function sortByVisibleColumns(visibleColumnsWithRowHeader, childNames) {
    var result = [];
    visibleColumnsWithRowHeader.forEach(function (column) {
        if (common_1.includes(childNames, column.name)) {
            result.push(column.name);
        }
    });
    return result;
}
function getLeafChildColumnNames(complexColumnHeaders, name) {
    var column = common_1.findProp('name', name, complexColumnHeaders);
    if (!column) {
        return [name];
    }
    var result = [];
    column.childNames.forEach(function (childName) {
        if (column_1.isParentColumnHeader(complexColumnHeaders, childName)) {
            result = tslib_1.__spreadArrays(result, getLeafChildColumnNames(complexColumnHeaders, childName));
        }
        else {
            result = tslib_1.__spreadArrays(result, [childName]);
        }
    });
    return result;
}
exports.getLeafChildColumnNames = getLeafChildColumnNames;
function getChildColumnRange(visibleColumnsWithRowHeader, complexColumnHeaders, name) {
    var unsortedChildNames = getLeafChildColumnNames(complexColumnHeaders, name);
    var childNames = sortByVisibleColumns(visibleColumnsWithRowHeader, unsortedChildNames);
    var startIndex = common_1.findPropIndex('name', childNames[0], visibleColumnsWithRowHeader);
    var endIndex = common_1.findPropIndex('name', childNames[childNames.length - 1], visibleColumnsWithRowHeader);
    return [startIndex, endIndex];
}
exports.getChildColumnRange = getChildColumnRange;
function getSortedRange(range) {
    return range[0] > range[1] ? [range[1], range[0]] : range;
}
exports.getSortedRange = getSortedRange;
function isSameInputRange(inp1, inp2) {
    if (common_1.isNull(inp1) || common_1.isNull(inp2)) {
        return inp1 === inp2;
    }
    return (inp1.column[0] === inp2.column[0] &&
        inp1.column[1] === inp2.column[1] &&
        inp1.row[0] === inp2.row[0] &&
        inp1.row[1] === inp2.row[1]);
}
exports.isSameInputRange = isSameInputRange;
function getSelectionRange(range, pageOptions) {
    if (!common_1.isEmpty(pageOptions)) {
        var row = range.row, column = range.column;
        var perPage = pageOptions.perPage, page = pageOptions.page;
        var prevPageRowCount = (page - 1) * perPage;
        return {
            row: [row[0] - prevPageRowCount, row[1] - prevPageRowCount],
            column: column,
        };
    }
    return range;
}
exports.getSelectionRange = getSelectionRange;


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getFormattedValue = exports.createFormattedValue = exports.getMaxTextMap = exports.setMaxColumnTextMap = exports.setMaxTextMap = exports.initMaxTextMap = void 0;
var listItemText_1 = __webpack_require__(67);
var common_1 = __webpack_require__(0);
var maxTextMap = {};
function initMaxTextMap() {
    maxTextMap = {};
}
exports.initMaxTextMap = initMaxTextMap;
function setMaxTextMap(column, row) {
    column.autoResizingColumn.forEach(function (columnInfo) {
        var name = columnInfo.name;
        var formattedValue = createFormattedValue(row, columnInfo);
        if (!maxTextMap[name] || maxTextMap[name].formattedValue.length < formattedValue.length) {
            setMaxColumnTextMap(name, formattedValue, row);
        }
    });
}
exports.setMaxTextMap = setMaxTextMap;
function setMaxColumnTextMap(columnName, formattedValue, row) {
    maxTextMap[columnName] = { formattedValue: formattedValue, row: row };
}
exports.setMaxColumnTextMap = setMaxColumnTextMap;
function getMaxTextMap() {
    return maxTextMap;
}
exports.getMaxTextMap = getMaxTextMap;
function createFormattedValue(row, columnInfo) {
    var name = columnInfo.name, formatter = columnInfo.formatter, defaultValue = columnInfo.defaultValue;
    var formatterProps = { row: row, column: columnInfo, value: row[name] };
    return getFormattedValue(formatterProps, formatter, row[name] || defaultValue, row._relationListItemMap[name]);
}
exports.createFormattedValue = createFormattedValue;
function getFormattedValue(props, formatter, defaultValue, relationListItems) {
    var value;
    if (formatter === 'listItemText') {
        value = listItemText_1.listItemText(props, relationListItems);
    }
    else if (common_1.isFunction(formatter)) {
        value = formatter(props);
    }
    else if (common_1.isString(formatter)) {
        value = formatter;
    }
    else {
        value = defaultValue;
    }
    var strValue = getCellDisplayValue(value);
    if (strValue && props.column.escapeHTML) {
        return common_1.encodeHTMLEntity(strValue);
    }
    return strValue;
}
exports.getFormattedValue = getFormattedValue;
function getCellDisplayValue(value) {
    if (common_1.isNil(value)) {
        return '';
    }
    return String(value);
}


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.resetRowSpan = exports.updateMainRowSpan = exports.updateRowSpan = exports.updateRowSpanWhenRemoving = exports.updateRowSpanWhenAppending = void 0;
var data_1 = __webpack_require__(15);
var common_1 = __webpack_require__(0);
var observable_1 = __webpack_require__(5);
var rowSpan_1 = __webpack_require__(13);
var constant_1 = __webpack_require__(8);
function updateRowSpanWhenAppending(data, prevRow, extendPrevRowSpan) {
    var prevRowSpanMap = prevRow.rowSpanMap;
    if (common_1.isEmpty(prevRowSpanMap)) {
        return;
    }
    Object.keys(prevRowSpanMap).forEach(function (columnName) {
        var prevRowSpan = prevRowSpanMap[columnName];
        if (prevRowSpan) {
            var count = prevRowSpan.count, keyRow = prevRowSpan.mainRow, mainRowKey = prevRowSpan.mainRowKey;
            var mainRow = keyRow ? prevRow : common_1.findProp('rowKey', mainRowKey, data);
            var mainRowSpan = mainRow.rowSpanMap[columnName];
            var startOffset = keyRow || extendPrevRowSpan ? 1 : -count + 1;
            // keep rowSpan state when appends row in the middle of rowSpan
            if (mainRowSpan.spanCount > startOffset ||
                (mainRowSpan.spanCount === 1 && startOffset === 1)) {
                mainRowSpan.count += 1;
                mainRowSpan.spanCount += 1;
                updateSubRowSpan(data, mainRow, columnName, 1, mainRowSpan.spanCount);
            }
        }
    });
}
exports.updateRowSpanWhenAppending = updateRowSpanWhenAppending;
function updateRowSpanWhenRemoving(data, removedRow, nextRow, keepRowSpanData) {
    var removedRowSpanMap = removedRow.rowSpanMap;
    if (common_1.isEmpty(removedRowSpanMap)) {
        return;
    }
    Object.keys(removedRowSpanMap).forEach(function (columnName) {
        var removedRowSpan = removedRowSpanMap[columnName];
        var count = removedRowSpan.count, keyRow = removedRowSpan.mainRow, mainRowKey = removedRowSpan.mainRowKey;
        var mainRow, spanCount;
        if (keyRow) {
            mainRow = nextRow;
            spanCount = count - 1;
            if (spanCount > 1) {
                var mainRowSpan = mainRow.rowSpanMap[columnName];
                mainRowSpan.mainRowKey = mainRow.rowKey;
                mainRowSpan.mainRow = true;
            }
            if (keepRowSpanData) {
                mainRow[columnName] = removedRow[columnName];
            }
        }
        else {
            mainRow = common_1.findProp('rowKey', mainRowKey, data);
            spanCount = mainRow.rowSpanMap[columnName].spanCount - 1;
        }
        if (spanCount > 1) {
            var mainRowSpan = mainRow.rowSpanMap[columnName];
            mainRowSpan.count = spanCount;
            mainRowSpan.spanCount = spanCount;
            updateSubRowSpan(data, mainRow, columnName, 1, spanCount);
        }
        else {
            delete mainRow.rowSpanMap[columnName];
        }
    });
}
exports.updateRowSpanWhenRemoving = updateRowSpanWhenRemoving;
function updateRowSpan(store) {
    var data = store.data, column = store.column;
    var filteredRawData = data.filteredRawData, pageOptions = data.pageOptions;
    var perPageOption = pageOptions.perPage;
    var rowSpans = {};
    var perPage = !common_1.isEmpty(pageOptions) && !perPageOption ? constant_1.DEFAULT_PER_PAGE : perPageOption;
    if (column.visibleRowSpanEnabledColumns.length > 0) {
        resetRowSpan(store, true);
        column.visibleRowSpanEnabledColumns.forEach(function (_a) {
            var name = _a.name;
            var rowSpanOfColumn = rowSpan_1.getRowSpanOfColumn(filteredRawData, name, perPage);
            Object.keys(rowSpanOfColumn).forEach(function (rowKey) {
                if (rowSpans[rowKey]) {
                    rowSpans[rowKey][name] = rowSpanOfColumn[rowKey][name];
                }
                else {
                    rowSpans[rowKey] = rowSpanOfColumn[rowKey];
                }
            });
        });
        Object.keys(rowSpans).forEach(function (rowKey) {
            var row = common_1.find(function (_a) {
                var key = _a.rowKey;
                return "" + key === rowKey;
            }, filteredRawData);
            updateMainRowSpan(filteredRawData, row, rowSpans[rowKey]);
        });
        observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    }
}
exports.updateRowSpan = updateRowSpan;
function updateMainRowSpan(data, mainRow, rowSpan) {
    if (rowSpan) {
        var rowKey_1 = mainRow.rowKey, rowSpanMap_1 = mainRow.rowSpanMap;
        Object.keys(rowSpan).forEach(function (columnName) {
            var spanCount = rowSpan[columnName];
            rowSpanMap_1[columnName] = data_1.createRowSpan(true, rowKey_1, spanCount, spanCount);
            updateSubRowSpan(data, mainRow, columnName, 1, spanCount);
        });
    }
}
exports.updateMainRowSpan = updateMainRowSpan;
function updateSubRowSpan(data, mainRow, columnName, startOffset, spanCount) {
    var mainRowIndex = common_1.findPropIndex('rowKey', mainRow.rowKey, data);
    for (var offset = startOffset; offset < spanCount; offset += 1) {
        var row = data[mainRowIndex + offset];
        row.rowSpanMap[columnName] = data_1.createRowSpan(false, mainRow.rowKey, -offset, spanCount);
    }
}
function resetRowSpan(_a, slient) {
    var data = _a.data, column = _a.column;
    if (slient === void 0) { slient = false; }
    if (column.visibleRowSpanEnabledColumns.length <= 0) {
        return;
    }
    data.rawData.forEach(function (_a) {
        var rowSpanMap = _a.rowSpanMap;
        Object.keys(rowSpanMap).forEach(function (columnName) {
            delete rowSpanMap[columnName];
        });
    });
    if (!slient) {
        observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    }
}
exports.resetRowSpan = resetRowSpan;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.initScrollPosition = exports.setScrollTop = exports.setScrollLeft = exports.setScrollToSelection = exports.setScrollToFocus = void 0;
var viewport_1 = __webpack_require__(79);
function setScrollPosition(viewport, changedScrollTop, changedScrollLeft) {
    if (changedScrollLeft !== null) {
        viewport.scrollLeft = changedScrollLeft;
    }
    if (changedScrollTop !== null) {
        viewport.scrollTop = changedScrollTop;
    }
}
function setScrollToFocus(store) {
    var _a = store.focus, cellPosRect = _a.cellPosRect, side = _a.side, viewport = store.viewport;
    if (cellPosRect === null || side === null) {
        return;
    }
    var _b = viewport_1.getChangedScrollPosition(store, side), changedScrollLeft = _b[0], changedScrollTop = _b[1];
    setScrollPosition(viewport, changedScrollTop, changedScrollLeft);
}
exports.setScrollToFocus = setScrollToFocus;
function setScrollToSelection(store) {
    var _a = store.columnCoords, widths = _a.widths, columnOffsets = _a.offsets, _b = store.rowCoords, heights = _b.heights, rowOffsets = _b.offsets, inputRange = store.selection.inputRange, viewport = store.viewport;
    if (!inputRange) {
        return;
    }
    var rowIndex = inputRange.row[1];
    var columnIndex = inputRange.column[1];
    var cellSide = columnIndex > widths.L.length - 1 ? 'R' : 'L';
    var rightSideColumnIndex = columnIndex < widths.L.length ? widths.L.length : columnIndex - widths.L.length;
    var left = columnOffsets[cellSide][rightSideColumnIndex];
    var right = left + widths[cellSide][rightSideColumnIndex];
    var top = rowOffsets[rowIndex];
    var bottom = top + heights[rowIndex];
    var cellPosRect = { left: left, right: right, top: top, bottom: bottom };
    var _c = viewport_1.getChangedScrollPosition(store, cellSide, cellPosRect), changedScrollLeft = _c[0], changedScrollTop = _c[1];
    setScrollPosition(viewport, changedScrollTop, changedScrollLeft);
}
exports.setScrollToSelection = setScrollToSelection;
function setScrollLeft(_a, scrollLeft) {
    var viewport = _a.viewport;
    viewport.scrollLeft = scrollLeft;
}
exports.setScrollLeft = setScrollLeft;
function setScrollTop(_a, scrollTop) {
    var viewport = _a.viewport;
    viewport.scrollTop = scrollTop;
}
exports.setScrollTop = setScrollTop;
function initScrollPosition(_a) {
    var viewport = _a.viewport;
    viewport.scrollLeft = 0;
    viewport.scrollTop = 0;
}
exports.initScrollPosition = initScrollPosition;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.updateAllSummaryValues = exports.updateSummaryValueByRow = exports.updateSummaryValueByColumn = exports.updateSummaryValueByCell = exports.setSummaryColumnContent = void 0;
var tslib_1 = __webpack_require__(1);
var summary_1 = __webpack_require__(47);
var common_1 = __webpack_require__(0);
var summary_2 = __webpack_require__(48);
var observable_1 = __webpack_require__(5);
function setSummaryColumnContent(_a, columnName, columnContent) {
    var summary = _a.summary, data = _a.data;
    var castedColumnContent = summary_1.castToSummaryColumnContent(columnContent);
    var content = summary_1.extractSummaryColumnContent(castedColumnContent, null);
    summary.summaryColumnContents[columnName] = content;
    summary.summaryValues[columnName] = summary_2.createSummaryValue(content, columnName, data);
    observable_1.notify(summary, 'summaryValues');
}
exports.setSummaryColumnContent = setSummaryColumnContent;
function updateSummaryValue(_a, columnName, type, options) {
    var summary = _a.summary, data = _a.data;
    var content = summary.summaryColumnContents[columnName];
    if (!content || !content.useAutoSummary) {
        return;
    }
    var summaryValue = summary.summaryValues[columnName];
    var orgValue = Number(options.orgValue) || 0;
    var value = Number(options.value) || 0;
    var cntVariation = options.type === 'APPEND' ? 1 : -1;
    var columnFilter = common_1.findProp('columnName', columnName, data.filters || []);
    var hasColumnFilter = !!(columnFilter && common_1.isFunction(columnFilter.conditionFn));
    var included = hasColumnFilter && columnFilter.conditionFn(value);
    var sum = summaryValue.sum, min = summaryValue.min, max = summaryValue.max, cnt = summaryValue.cnt;
    var _b = summaryValue.filtered, filteredSum = _b.sum, filteredMin = _b.min, filteredMax = _b.max, filteredCnt = _b.cnt;
    switch (type) {
        case 'UPDATE_COLUMN':
            sum = value * cnt;
            min = value;
            max = value;
            if (hasColumnFilter) {
                filteredCnt = included ? filteredCnt : 0;
                filteredSum = included ? value * filteredCnt : 0;
                filteredMin = included ? value : 0;
                filteredMax = included ? value : 0;
            }
            break;
        case 'UPDATE_CELL':
            sum = sum - orgValue + value;
            if (hasColumnFilter) {
                var orgIncluded = columnFilter.conditionFn(orgValue);
                if (!orgIncluded && included) {
                    filteredSum = filteredSum + value;
                    filteredCnt += 1;
                }
                else if (orgIncluded && !included) {
                    filteredSum = filteredSum - orgValue;
                    filteredCnt -= 1;
                }
                else if (orgIncluded && included) {
                    filteredSum = filteredSum - orgValue + value;
                }
            }
            break;
        case 'UPDATE_ROW':
            cnt += cntVariation;
            sum = sum + cntVariation * value;
            if (hasColumnFilter && included) {
                filteredSum = filteredSum + cntVariation * value;
                filteredCnt += cntVariation;
            }
            break;
        default:
        // do nothing;
    }
    var avg = sum / cnt;
    var filteredAvg = filteredSum / filteredCnt;
    var columnData = data.rawData.map(function (row) { return Number(row[columnName]); });
    min = Math.min.apply(Math, tslib_1.__spreadArrays([value], columnData));
    max = Math.max.apply(Math, tslib_1.__spreadArrays([value], columnData));
    if (hasColumnFilter) {
        var filteredColumnData = data.filteredRawData.map(function (row) { return Number(row[columnName]); });
        filteredMin = Math.min.apply(Math, tslib_1.__spreadArrays([value], filteredColumnData));
        filteredMax = Math.max.apply(Math, tslib_1.__spreadArrays([value], filteredColumnData));
    }
    summary.summaryValues[columnName] = {
        sum: sum,
        min: min,
        max: max,
        avg: avg,
        cnt: cnt,
        filtered: hasColumnFilter
            ? {
                sum: filteredSum,
                min: filteredMin,
                max: filteredMax,
                avg: filteredAvg,
                cnt: filteredCnt,
            }
            : { sum: sum, min: min, max: max, avg: avg, cnt: cnt },
    };
    observable_1.notify(summary, 'summaryValues');
}
function updateSummaryValueByCell(store, columnName, options) {
    updateSummaryValue(store, columnName, 'UPDATE_CELL', options);
}
exports.updateSummaryValueByCell = updateSummaryValueByCell;
function updateSummaryValueByColumn(store, columnName, options) {
    updateSummaryValue(store, columnName, 'UPDATE_COLUMN', options);
}
exports.updateSummaryValueByColumn = updateSummaryValueByColumn;
function updateSummaryValueByRow(store, row, options) {
    var summary = store.summary, column = store.column;
    var type = options.type, orgRow = options.orgRow;
    var summaryColumns = column.allColumns.filter(function (_a) {
        var name = _a.name;
        return !!summary.summaryColumnContents[name];
    });
    summaryColumns.forEach(function (_a) {
        var name = _a.name;
        if (type === 'SET') {
            updateSummaryValue(store, name, 'UPDATE_CELL', { orgValue: orgRow[name], value: row[name] });
        }
        else {
            updateSummaryValue(store, name, 'UPDATE_ROW', { type: type, value: row[name] });
        }
    });
}
exports.updateSummaryValueByRow = updateSummaryValueByRow;
function updateAllSummaryValues(_a) {
    var summary = _a.summary, data = _a.data, column = _a.column;
    var summaryColumns = column.allColumns.filter(function (_a) {
        var name = _a.name;
        return !!summary.summaryColumnContents[name];
    });
    summaryColumns.forEach(function (_a) {
        var name = _a.name;
        var content = summary.summaryColumnContents[name];
        summary.summaryValues[name] = summary_2.createSummaryValue(content, name, data);
    });
    observable_1.notify(summary, 'summaryValues');
}
exports.updateAllSummaryValues = updateAllSummaryValues;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getValidationCode = exports.forceValidateUniquenessOfColumn = exports.forceValidateUniquenessOfColumns = exports.replaceColumnUniqueInfoMap = exports.removeUniqueInfoMap = exports.addUniqueInfoMap = exports.invokeWithUniqueValidationColumn = exports.createNewValidationMap = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var observable_1 = __webpack_require__(5);
var instance_1 = __webpack_require__(9);
var data_1 = __webpack_require__(6);
var instanceValidationMap = {};
var isValidatingUniquenessMap = {};
function createNewValidationMap(id) {
    instanceValidationMap[id] = {};
}
exports.createNewValidationMap = createNewValidationMap;
function invokeWithUniqueValidationColumn(column, fn) {
    column.validationColumns.forEach(function (_a) {
        var name = _a.name, validation = _a.validation;
        if (validation.unique) {
            fn(name);
        }
    });
}
exports.invokeWithUniqueValidationColumn = invokeWithUniqueValidationColumn;
function addUniqueInfoMap(id, row, column) {
    invokeWithUniqueValidationColumn(column, function (name) {
        return addColumnUniqueInfoMap(id, row.rowKey, name, row[name]);
    });
}
exports.addUniqueInfoMap = addUniqueInfoMap;
function removeUniqueInfoMap(id, row, column) {
    invokeWithUniqueValidationColumn(column, function (name) {
        return removeColumnUniqueInfoMap(id, row.rowKey, name, row[name]);
    });
}
exports.removeUniqueInfoMap = removeUniqueInfoMap;
function removeColumnUniqueInfoMap(id, rowKey, columnName, cellValue) {
    var value = String(cellValue);
    var uniqueInfoMap = instanceValidationMap[id];
    if (uniqueInfoMap && uniqueInfoMap[value] && uniqueInfoMap[value][columnName]) {
        uniqueInfoMap[value][columnName] = uniqueInfoMap[value][columnName].filter(function (targetRowKey) { return targetRowKey !== rowKey; });
    }
}
function addColumnUniqueInfoMap(id, rowKey, columnName, cellValue) {
    var value = String(cellValue);
    var uniqueInfoMap = instanceValidationMap[id];
    uniqueInfoMap[value] = uniqueInfoMap[value] || {};
    uniqueInfoMap[value][columnName] = uniqueInfoMap[value][columnName] || [];
    uniqueInfoMap[value][columnName].push(rowKey);
}
function replaceColumnUniqueInfoMap(id, column, _a) {
    var rowKey = _a.rowKey, columnName = _a.columnName, prevValue = _a.prevValue, value = _a.value;
    if (common_1.some(function (_a) {
        var name = _a.name;
        return name === columnName;
    }, column.validationColumns)) {
        removeColumnUniqueInfoMap(id, rowKey, columnName, prevValue);
        addColumnUniqueInfoMap(id, rowKey, columnName, value);
    }
}
exports.replaceColumnUniqueInfoMap = replaceColumnUniqueInfoMap;
function forceValidateUniquenessOfColumns(rawData, column) {
    if (rawData.length) {
        // trick for forcing to validate the uniqueness
        invokeWithUniqueValidationColumn(column, function (name) { return observable_1.notify(rawData[0], name); });
    }
}
exports.forceValidateUniquenessOfColumns = forceValidateUniquenessOfColumns;
function forceValidateUniquenessOfColumn(rawData, column, columnName) {
    if (common_1.some(function (_a) {
        var name = _a.name;
        return name === columnName;
    }, column.validationColumns) && rawData.length) {
        // trick for forcing to validate the uniqueness
        observable_1.notify(rawData[0], columnName);
    }
}
exports.forceValidateUniquenessOfColumn = forceValidateUniquenessOfColumn;
function hasDuplicateValue(id, columnName, cellValue) {
    var _a;
    var value = String(cellValue);
    var uniqueInfoMap = instanceValidationMap[id];
    return !!(uniqueInfoMap && uniqueInfoMap[value] && ((_a = uniqueInfoMap[value][columnName]) === null || _a === void 0 ? void 0 : _a.length) > 1);
}
function validateDataUniqueness(id, value, columnName, invalidStates) {
    if (hasDuplicateValue(id, columnName, value)) {
        invalidStates.push({ code: 'UNIQUE' });
    }
    // prevent recursive call of 'validateDataUniqueness' when scrolling or manipulating the data
    if (!isValidatingUniquenessMap[columnName] &&
        !common_1.includes(observable_1.getRunningObservers(), 'lazyObservable')) {
        var rawData_1 = [];
        observable_1.unobservedInvoke(function () {
            // @TODO: should get the latest rawData through function(not private field of the grid instance)
            // @ts-ignore
            rawData_1 = instance_1.getInstance(id).store.data.rawData;
        });
        isValidatingUniquenessMap[columnName] = true;
        rawData_1.forEach(function (row) {
            if (observable_1.isObservable(row)) {
                observable_1.notify(row, columnName);
            }
        });
        setTimeout(function () {
            isValidatingUniquenessMap[columnName] = false;
        });
    }
}
function validateCustomValidator(row, value, columnName, validatorFn, invalidStates) {
    var originRow = data_1.getOmittedInternalProp(row);
    observable_1.unobservedInvoke(function () {
        var result = validatorFn(value, originRow, columnName);
        var _a = (common_1.isBoolean(result)
            ? { valid: result }
            : result), valid = _a.valid, meta = _a.meta;
        if (!valid) {
            invalidStates.push(tslib_1.__assign({ code: 'VALIDATOR_FN' }, meta));
        }
    });
}
function getValidationCode(_a) {
    var id = _a.id, value = _a.value, row = _a.row, columnName = _a.columnName, validation = _a.validation;
    var invalidStates = [];
    if (!validation) {
        return invalidStates;
    }
    var required = validation.required, dataType = validation.dataType, min = validation.min, max = validation.max, regExp = validation.regExp, unique = validation.unique, validatorFn = validation.validatorFn;
    if (required && common_1.isBlank(value)) {
        invalidStates.push({ code: 'REQUIRED' });
    }
    if (unique) {
        validateDataUniqueness(id, value, columnName, invalidStates);
    }
    if (common_1.isFunction(validatorFn)) {
        validateCustomValidator(row, value, columnName, validatorFn, invalidStates);
    }
    if (dataType === 'string' && !common_1.isString(value)) {
        invalidStates.push({ code: 'TYPE_STRING' });
    }
    if (regExp && common_1.isString(value) && !regExp.test(value)) {
        invalidStates.push({ code: 'REGEXP', regExp: regExp });
    }
    var numberValue = common_1.convertToNumber(value);
    if (dataType === 'number' && !common_1.isNumber(numberValue)) {
        invalidStates.push({ code: 'TYPE_NUMBER' });
    }
    if (common_1.isNumber(min) && common_1.isNumber(numberValue) && numberValue < min) {
        invalidStates.push({ code: 'MIN', min: min });
    }
    if (common_1.isNumber(max) && common_1.isNumber(numberValue) && numberValue > max) {
        invalidStates.push({ code: 'MAX', max: max });
    }
    return invalidStates;
}
exports.getValidationCode = getValidationCode;


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.resetSortState = exports.sortByCurrentState = exports.resetSortKey = exports.updateSortKey = exports.emitAfterSort = exports.emitBeforeSort = exports.initSortState = exports.unsort = exports.sort = exports.changeSortState = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var observable_1 = __webpack_require__(5);
var sort_1 = __webpack_require__(78);
var eventBus_1 = __webpack_require__(7);
var data_1 = __webpack_require__(14);
var data_2 = __webpack_require__(6);
var column_1 = __webpack_require__(12);
var sort_2 = __webpack_require__(46);
var rowSpan_1 = __webpack_require__(24);
function createSortedViewData(rawData) {
    return rawData.map(function (_a) {
        var rowKey = _a.rowKey, sortKey = _a.sortKey, uniqueKey = _a.uniqueKey;
        return ({ rowKey: rowKey, sortKey: sortKey, uniqueKey: uniqueKey });
    });
}
function sortData(store) {
    var data = store.data, column = store.column, viewport = store.viewport;
    var sortState = data.sortState, rawData = data.rawData, viewData = data.viewData, pageRowRange = data.pageRowRange;
    var columns = sortState.columns;
    var sortedColumns = columns.map(function (sortedColumn) {
        var _a;
        return (tslib_1.__assign(tslib_1.__assign({}, sortedColumn), { comparator: (_a = column.allColumnMap[sortedColumn.columnName]) === null || _a === void 0 ? void 0 : _a.comparator }));
    });
    if (data_2.isScrollPagination(data, true)) {
        // should sort the sliced data which is displayed in viewport in case of client infinite scrolling
        var targetRawData = rawData.slice.apply(rawData, pageRowRange);
        targetRawData.sort(sort_1.sortRawData(sortedColumns));
        var targetViewData = createSortedViewData(targetRawData);
        data.rawData = targetRawData.concat(rawData.slice(pageRowRange[1]));
        data.viewData = targetViewData.concat(viewData.slice(pageRowRange[1]));
    }
    else {
        rawData.sort(sort_1.sortRawData(sortedColumns));
        data.viewData = createSortedViewData(rawData);
    }
    var rowKeysInViewport = viewport.rows.map(function (_a) {
        var rowKey = _a.rowKey;
        return rowKey;
    });
    data.rawData.forEach(function (rawRow, index) {
        var rowKey = rawRow.rowKey;
        if (observable_1.isObservable(rawRow) || rowKeysInViewport.includes(rowKey)) {
            data_1.makeObservable({
                store: store,
                rowIndex: index,
                silent: false,
                lazyObservable: false,
                forced: true,
            });
        }
    });
}
function setInitialSortState(data) {
    data.sortState.columns = [{ columnName: 'sortKey', ascending: true }];
}
function setSortStateForEmptyState(data) {
    if (!data.sortState.columns.length) {
        setInitialSortState(data);
    }
}
function toggleSortAscending(data, index, ascending, sortingType, cancelable) {
    var defaultAscending = sortingType === 'asc';
    if (defaultAscending === ascending && cancelable) {
        data.sortState.columns.splice(index, 1);
    }
    else {
        data.sortState.columns[index].ascending = ascending;
    }
}
function changeSingleSortState(data, columnName, ascending, sortingType, cancelable) {
    var sortState = data.sortState;
    var columns = sortState.columns;
    var sortedColumn = { columnName: columnName, ascending: ascending };
    if (columns.length === 1 && columns[0].columnName === columnName) {
        var columnIndex = common_1.findPropIndex('columnName', columnName, sortState.columns);
        toggleSortAscending(data, columnIndex, ascending, sortingType, cancelable);
    }
    else {
        data.sortState.columns = [sortedColumn];
    }
}
function changeMultiSortState(data, columnName, ascending, sortingType, cancelable) {
    var sortedColumn = { columnName: columnName, ascending: ascending };
    var sortState = data.sortState;
    var columns = sortState.columns;
    var columnIndex = common_1.findPropIndex('columnName', columnName, columns);
    if (columnIndex === -1) {
        data.sortState.columns = data_2.isInitialSortState(sortState)
            ? [sortedColumn]
            : tslib_1.__spreadArrays(columns, [sortedColumn]);
    }
    else {
        toggleSortAscending(data, columnIndex, ascending, sortingType, cancelable);
    }
}
function changeSortState(_a, columnName, ascending, multiple, cancelable) {
    var data = _a.data, column = _a.column;
    if (cancelable === void 0) { cancelable = true; }
    if (columnName === 'sortKey') {
        setInitialSortState(data);
    }
    else {
        var sortingType = column.allColumnMap[columnName].sortingType;
        if (multiple) {
            changeMultiSortState(data, columnName, ascending, sortingType, cancelable);
        }
        else {
            changeSingleSortState(data, columnName, ascending, sortingType, cancelable);
        }
        setSortStateForEmptyState(data);
    }
    if (!data.sortState.useClient) {
        observable_1.notify(data, 'sortState');
    }
}
exports.changeSortState = changeSortState;
function applySortedData(store) {
    sortData(store);
    observable_1.notify(store.data, 'sortState');
    data_1.updateRowNumber(store, 0);
    data_1.setCheckedAllRows(store);
}
function sort(store, columnName, ascending, multiple, cancelable) {
    if (multiple === void 0) { multiple = false; }
    if (cancelable === void 0) { cancelable = true; }
    var data = store.data, column = store.column;
    var sortState = data.sortState;
    if (column_1.isComplexHeader(column, columnName) || !data_2.isSortable(sortState, column, columnName)) {
        return;
    }
    var cancelSort = sort_2.isCancelSort(store, columnName, ascending, cancelable);
    var gridEvent = emitBeforeSort(store, cancelSort, { columnName: columnName, ascending: ascending, multiple: multiple });
    if (gridEvent.isStopped()) {
        return;
    }
    changeSortState(store, columnName, ascending, multiple, cancelable);
    applySortedData(store);
    emitAfterSort(store, cancelSort, columnName);
    rowSpan_1.updateRowSpan(store);
}
exports.sort = sort;
function unsort(store, columnName) {
    if (columnName === void 0) { columnName = 'sortKey'; }
    var data = store.data, column = store.column;
    var sortState = data.sortState;
    if (column_1.isComplexHeader(column, columnName) || !data_2.isSortable(sortState, column, columnName)) {
        return;
    }
    emitBeforeSort(store, true, { columnName: columnName, multiple: true });
    if (columnName === 'sortKey') {
        setInitialSortState(data);
    }
    else {
        var index = common_1.findPropIndex('columnName', columnName, data.sortState.columns);
        if (index !== -1) {
            data.sortState.columns.splice(index, 1);
            setSortStateForEmptyState(data);
        }
    }
    applySortedData(store);
    emitAfterSort(store, true, columnName);
    rowSpan_1.updateRowSpan(store);
}
exports.unsort = unsort;
function initSortState(data) {
    setInitialSortState(data);
    observable_1.notify(data, 'sortState');
}
exports.initSortState = initSortState;
function emitBeforeSort(store, cancelSort, eventParams) {
    var id = store.id, data = store.data;
    var eventBus = eventBus_1.getEventBus(id);
    var eventType = cancelSort ? 'beforeUnsort' : 'beforeSort';
    var gridEvent = sort_2.createSortEvent(eventType, tslib_1.__assign(tslib_1.__assign({}, eventParams), { sortState: data.sortState }));
    eventBus.trigger(eventType, gridEvent);
    return gridEvent;
}
exports.emitBeforeSort = emitBeforeSort;
function emitAfterSort(store, cancelSort, columnName) {
    var id = store.id, data = store.data;
    var eventBus = eventBus_1.getEventBus(id);
    // @TODO: `sort` event will be deprecated. This event is replaced with `afterSort` event
    var eventTypes = (cancelSort ? ['afterUnsort'] : ['afterSort', 'sort']);
    eventTypes.forEach(function (eventType) {
        var gridEvent = sort_2.createSortEvent(eventType, { columnName: columnName, sortState: data.sortState });
        eventBus.trigger(eventType, gridEvent);
    });
}
exports.emitAfterSort = emitAfterSort;
function updateSortKey(data, sortKey, appended) {
    if (appended === void 0) { appended = true; }
    var incremental = appended ? 1 : -1;
    var rawData = data.rawData, viewData = data.viewData;
    for (var idx = 0; idx < rawData.length; idx += 1) {
        if (rawData[idx].sortKey >= sortKey) {
            rawData[idx].sortKey += incremental;
            viewData[idx].sortKey += incremental;
        }
    }
    if (appended) {
        rawData[sortKey].sortKey = sortKey;
        viewData[sortKey].sortKey = sortKey;
    }
}
exports.updateSortKey = updateSortKey;
function resetSortKey(data, start) {
    var rawData = data.rawData, viewData = data.viewData;
    for (var idx = start; idx < rawData.length; idx += 1) {
        rawData[idx].sortKey = idx;
        viewData[idx].sortKey = idx;
    }
}
exports.resetSortKey = resetSortKey;
function sortByCurrentState(store) {
    var data = store.data;
    if (data_2.isSorted(data)) {
        var _a = data.sortState.columns[0], columnName = _a.columnName, ascending = _a.ascending;
        sort(store, columnName, ascending, true, false);
    }
}
exports.sortByCurrentState = sortByCurrentState;
function resetSortState(store, sortState) {
    var data = store.data, column = store.column;
    if (sortState) {
        var columnName = sortState.columnName, ascending = sortState.ascending, multiple = sortState.multiple;
        var _a = column.allColumnMap[columnName], sortingType = _a.sortingType, sortable = _a.sortable;
        if (sortable) {
            var cancelable = common_1.isUndefined(ascending);
            var nextAscending = cancelable ? sortingType === 'asc' : ascending;
            changeSortState(store, columnName, nextAscending, multiple, cancelable);
            observable_1.notify(data, 'sortState');
        }
    }
    else {
        initSortState(data);
    }
}
exports.resetSortState = resetSortState;


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.composeConditionFn = exports.getFilterConditionFn = exports.getUnixTime = exports.createFilterSelectOption = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var i18n_1 = tslib_1.__importDefault(__webpack_require__(19));
var filterSelectOption;
function createFilterSelectOption() {
    if (!filterSelectOption) {
        filterSelectOption = {
            number: {
                eq: '=',
                lt: '<',
                gt: '>',
                lte: '<=',
                gte: '>=',
                ne: '!=',
            },
            text: {
                contain: i18n_1.default.get('filter.contains'),
                eq: i18n_1.default.get('filter.eq'),
                ne: i18n_1.default.get('filter.ne'),
                start: i18n_1.default.get('filter.start'),
                end: i18n_1.default.get('filter.end'),
            },
            date: {
                eq: i18n_1.default.get('filter.eq'),
                ne: i18n_1.default.get('filter.ne'),
                after: i18n_1.default.get('filter.after'),
                afterEq: i18n_1.default.get('filter.afterEq'),
                before: i18n_1.default.get('filter.before'),
                beforeEq: i18n_1.default.get('filter.beforeEq'),
            },
        };
    }
    return filterSelectOption;
}
exports.createFilterSelectOption = createFilterSelectOption;
function getUnixTime(value) {
    return parseInt((new Date(String(value)).getTime() / 1000).toFixed(0), 10);
}
exports.getUnixTime = getUnixTime;
function getPredicateWithType(code, type, inputValue) {
    var convertFn = {
        number: Number,
        text: String,
        select: String,
        date: getUnixTime,
    }[type];
    return code === 'eq'
        ? function (cellValue) { return convertFn(cellValue) === convertFn(inputValue); }
        : function (cellValue) { return convertFn(cellValue) !== convertFn(inputValue); };
}
function getFilterConditionFn(code, inputValue, type) {
    switch (code) {
        case 'eq':
        case 'ne':
            return getPredicateWithType(code, type, inputValue);
        case 'lt':
            return function (cellValue) { return Number(cellValue) < Number(inputValue); };
        case 'gt':
            return function (cellValue) { return Number(cellValue) > Number(inputValue); };
        case 'lte':
            return function (cellValue) { return Number(cellValue) <= Number(inputValue); };
        case 'gte':
            return function (cellValue) { return Number(cellValue) >= Number(inputValue); };
        case 'contain':
            return function (cellValue) {
                return common_1.isString(cellValue) && common_1.isString(inputValue) && cellValue.indexOf(inputValue) !== -1;
            };
        case 'start':
            return function (cellValue) {
                return common_1.isString(cellValue) && common_1.isString(inputValue) && common_1.startsWith(inputValue, cellValue);
            };
        case 'end':
            return function (cellValue) {
                return common_1.isString(cellValue) && common_1.isString(inputValue) && common_1.endsWith(inputValue, cellValue);
            };
        case 'after':
            return function (cellValue) { return getUnixTime(cellValue) > getUnixTime(inputValue); };
        case 'afterEq':
            return function (cellValue) { return getUnixTime(cellValue) >= getUnixTime(inputValue); };
        case 'before':
            return function (cellValue) { return getUnixTime(cellValue) < getUnixTime(inputValue); };
        case 'beforeEq':
            return function (cellValue) { return getUnixTime(cellValue) <= getUnixTime(inputValue); };
        default:
            throw new Error('code not available.');
    }
}
exports.getFilterConditionFn = getFilterConditionFn;
function composeConditionFn(fns, operator) {
    return function (value) {
        return fns.reduce(function (acc, fn) {
            return operator === 'OR' ? acc || fn(value) : acc && fn(value);
        }, operator !== 'OR');
    };
}
exports.composeConditionFn = composeConditionFn;


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.moveTreeRow = exports.removeTreeRow = exports.appendTreeRow = exports.changeTreeRowsCheckedState = exports.collapseAll = exports.collapseByRowKey = exports.expandAll = exports.expandByRowKey = exports.removeExpandedAttr = void 0;
var tslib_1 = __webpack_require__(1);
var data_1 = __webpack_require__(15);
var data_2 = __webpack_require__(6);
var observable_1 = __webpack_require__(5);
var instance_1 = __webpack_require__(9);
var data_3 = __webpack_require__(14);
var tree_1 = __webpack_require__(21);
var eventBus_1 = __webpack_require__(7);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var tree_2 = __webpack_require__(20);
var common_1 = __webpack_require__(0);
var dom_1 = __webpack_require__(2);
var lazyObservable_1 = __webpack_require__(31);
var column_1 = __webpack_require__(12);
var data_4 = __webpack_require__(23);
var constant_1 = __webpack_require__(8);
var column_2 = __webpack_require__(32);
function changeExpandedAttr(row, expanded) {
    var tree = row._attributes.tree;
    if (tree) {
        row._attributes.expanded = expanded;
        tree.expanded = expanded;
    }
}
function changeHiddenAttr(row, hidden) {
    var tree = row._attributes.tree;
    if (tree) {
        tree.hidden = hidden;
    }
}
function expand(store, row, recursive) {
    var rowKey = row.rowKey;
    var eventBus = eventBus_1.getEventBus(store.id);
    var gridEvent = new gridEvent_1.default({ rowKey: rowKey });
    /**
     * Occurs when the row having child rows is expanded
     * @event Grid#expand
     * @type {module:event/gridEvent}
     * @property {number|string} rowKey - rowKey of the expanded row
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('expand', gridEvent);
    if (gridEvent.isStopped()) {
        return;
    }
    var data = store.data, rowCoords = store.rowCoords, dimension = store.dimension, column = store.column, id = store.id, viewport = store.viewport, columnCoords = store.columnCoords;
    var heights = rowCoords.heights;
    changeExpandedAttr(row, true);
    var childRowKeys = tree_1.getChildRowKeys(row);
    updateTreeColumnWidth(childRowKeys, column, columnCoords, dimension, data.rawData);
    childRowKeys.forEach(function (childRowKey) {
        var childRow = data_2.findRowByRowKey(data, column, id, childRowKey);
        if (!childRow) {
            return;
        }
        changeHiddenAttr(childRow, false);
        if (!tree_1.isLeaf(childRow) && (tree_1.isExpanded(childRow) || recursive)) {
            expand(store, childRow, recursive);
        }
        var index = data_2.findIndexByRowKey(data, column, id, childRowKey);
        heights[index] = data_2.getRowHeight(childRow, dimension.rowHeight);
    });
    if (childRowKeys.length) {
        observable_1.notify(rowCoords, 'heights');
        observable_1.notify(viewport, 'rowRange');
    }
}
function updateTreeColumnWidth(childRowKeys, column, columnCoords, dimension, rawData) {
    var visibleColumnsBySideWithRowHeader = column.visibleColumnsBySideWithRowHeader, treeIcon = column.treeIcon, allColumnMap = column.allColumnMap, treeIndentWidth = column.treeIndentWidth;
    var treeColumnName = column.treeColumnName;
    var treeColumnSide = column_1.getColumnSide(column, treeColumnName);
    var treeColumnIndex = common_1.findPropIndex('name', treeColumnName, column.visibleColumnsBySide[treeColumnSide]);
    var columnInfo = visibleColumnsBySideWithRowHeader[treeColumnSide][treeColumnIndex];
    // @TODO: auto resizing is operated with 'autoResizing' option
    // 'resizable' condition should be deprecated in next version
    if (columnInfo.resizable || columnInfo.autoResizing) {
        var maxWidth = getChildTreeNodeMaxWidth(childRowKeys, rawData, columnInfo, treeIndentWidth, treeIcon);
        var prevWidth = columnCoords.widths[treeColumnSide][treeColumnIndex] + dimension.cellBorderWidth;
        allColumnMap[treeColumnName].baseWidth = Math.max(prevWidth, maxWidth);
        allColumnMap[treeColumnName].fixedWidth = true;
    }
}
function getChildTreeNodeMaxWidth(childRowKeys, rawData, column, treeIndentWidth, useIcon) {
    var maxLength = 0;
    var bodyArea = document.querySelector("." + dom_1.cls('rside-area') + " ." + dom_1.cls('body-container') + " ." + dom_1.cls('table'));
    var getMaxWidth = childRowKeys.reduce(function (acc, rowKey) {
        var row = common_1.findProp('rowKey', rowKey, rawData);
        var formattedValue = data_4.createFormattedValue(row, column);
        if (formattedValue.length > maxLength) {
            maxLength = formattedValue.length;
            acc = function () {
                return dom_1.getTextWidth(formattedValue, bodyArea) +
                    tree_2.getTreeIndentWidth(tree_1.getDepth(rawData, row), treeIndentWidth, useIcon) +
                    constant_1.TREE_CELL_HORIZONTAL_PADDING;
            };
        }
        return acc;
    }, function () { return 0; });
    return getMaxWidth();
}
function collapse(store, row, recursive) {
    var rowKey = row.rowKey;
    var eventBus = eventBus_1.getEventBus(store.id);
    var gridEvent = new gridEvent_1.default({ rowKey: rowKey });
    /**
     * Occurs when the row having child rows is collapsed
     * @event Grid#collapse
     * @type {module:event/gridEvent}
     * @property {number|string} rowKey - rowKey of the collapsed row
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('collapse', gridEvent);
    if (gridEvent.isStopped()) {
        return;
    }
    var data = store.data, rowCoords = store.rowCoords, column = store.column, id = store.id;
    var heights = rowCoords.heights;
    changeExpandedAttr(row, false);
    var childRowKeys = tree_1.getChildRowKeys(row);
    childRowKeys.forEach(function (childRowKey) {
        var childRow = data_2.findRowByRowKey(data, column, id, childRowKey);
        if (!childRow) {
            return;
        }
        changeHiddenAttr(childRow, true);
        observable_1.unobservable(childRow._attributes.tree, ['hidden']);
        if (!tree_1.isLeaf(childRow)) {
            if (recursive) {
                collapse(store, childRow, recursive);
            }
            else {
                tree_1.getDescendantRows(store, childRowKey).forEach(function (_a) {
                    var descendantRowKey = _a.rowKey;
                    var index = data_2.findIndexByRowKey(data, column, id, descendantRowKey);
                    changeHiddenAttr(data.filteredRawData[index], true);
                    heights[index] = 0;
                });
            }
        }
        var index = data_2.findIndexByRowKey(data, column, id, childRowKey);
        heights[index] = 0;
    });
    observable_1.notify(rowCoords, 'heights');
}
function setCheckedState(row, state) {
    if (row && data_3.isUpdatableRowAttr('checked', row._attributes.checkDisabled)) {
        row._attributes.checked = state;
    }
}
function changeAncestorRowsCheckedState(store, rowKey) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var row = data_2.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        tree_1.traverseAncestorRows(rawData, row, function (parentRow) {
            var childRowKeys = tree_1.getChildRowKeys(parentRow);
            var checkedChildRows = childRowKeys.filter(function (childRowKey) {
                var childRow = data_2.findRowByRowKey(data, column, id, childRowKey);
                return !!childRow && childRow._attributes.checked;
            });
            var checked = childRowKeys.length === checkedChildRows.length;
            setCheckedState(parentRow, checked);
        });
    }
}
function changeDescendantRowsCheckedState(store, rowKey, state) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var row = data_2.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        tree_1.traverseDescendantRows(rawData, row, function (childRow) {
            setCheckedState(childRow, state);
        });
    }
}
function removeChildRowKey(row, rowKey) {
    var tree = row._attributes.tree;
    if (tree) {
        common_1.removeArrayItem(rowKey, tree.childRowKeys);
        if (row._children) {
            var index = common_1.findPropIndex('rowKey', rowKey, row._children);
            if (index !== -1) {
                row._children.splice(index, 1);
            }
        }
        if (!tree.childRowKeys.length) {
            row._leaf = true;
        }
        observable_1.notify(tree, 'childRowKeys');
    }
}
function removeExpandedAttr(row) {
    var tree = row._attributes.tree;
    if (tree) {
        tree.expanded = false;
    }
}
exports.removeExpandedAttr = removeExpandedAttr;
function expandByRowKey(store, rowKey, recursive) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        expand(store, row, recursive);
    }
}
exports.expandByRowKey = expandByRowKey;
function expandAll(store) {
    store.data.rawData.forEach(function (row) {
        if (tree_1.isRootChildRow(row) && !tree_1.isLeaf(row)) {
            expand(store, row, true);
        }
    });
}
exports.expandAll = expandAll;
function collapseByRowKey(store, rowKey, recursive) {
    var data = store.data, column = store.column, id = store.id;
    var row = data_2.findRowByRowKey(data, column, id, rowKey);
    if (row) {
        collapse(store, row, recursive);
    }
}
exports.collapseByRowKey = collapseByRowKey;
function collapseAll(store) {
    store.data.rawData.forEach(function (row) {
        if (tree_1.isRootChildRow(row) && !tree_1.isLeaf(row)) {
            collapse(store, row, true);
        }
    });
}
exports.collapseAll = collapseAll;
function changeTreeRowsCheckedState(store, rowKey, state) {
    var _a = store.column, treeColumnName = _a.treeColumnName, treeCascadingCheckbox = _a.treeCascadingCheckbox;
    if (treeColumnName && treeCascadingCheckbox) {
        changeDescendantRowsCheckedState(store, rowKey, state);
        changeAncestorRowsCheckedState(store, rowKey);
    }
}
exports.changeTreeRowsCheckedState = changeTreeRowsCheckedState;
// @TODO: consider tree disabled state with cascading
function appendTreeRow(store, row, options) {
    var data = store.data, column = store.column, rowCoords = store.rowCoords, dimension = store.dimension, id = store.id;
    var rawData = data.rawData, viewData = data.viewData;
    var heights = rowCoords.heights;
    var parentRowKey = options.parentRowKey, offset = options.offset, movingRow = options.movingRow;
    var parentRow = data_2.findRowByRowKey(data, column, id, parentRowKey);
    var startIdx = tree_1.getStartIndexToAppendRow(store, parentRow, offset);
    var rawRows = tree_2.flattenTreeData(id, [row], parentRow, column, {
        keyColumnName: column.keyColumnName,
        offset: offset,
    });
    var modificationType = movingRow ? 'UPDATE' : 'CREATE';
    lazyObservable_1.fillMissingColumnData(column, rawRows);
    var viewRows = rawRows.map(function (rawRow) { return data_1.createViewRow(id, rawRow, rawData, column); });
    common_1.silentSplice.apply(void 0, tslib_1.__spreadArrays([rawData, startIdx, 0], rawRows));
    common_1.silentSplice.apply(void 0, tslib_1.__spreadArrays([viewData, startIdx, 0], viewRows));
    var rowHeights = rawRows.map(function (rawRow) {
        changeTreeRowsCheckedState(store, rawRow.rowKey, rawRow._attributes.checked);
        instance_1.getDataManager(id).push(modificationType, [rawRow], true);
        return data_2.getRowHeight(rawRow, dimension.rowHeight);
    });
    observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
    heights.splice.apply(heights, tslib_1.__spreadArrays([startIdx, 0], rowHeights));
    postUpdateAfterManipulation(store, startIdx, rawRows);
}
exports.appendTreeRow = appendTreeRow;
// @TODO: consider tree disabled state with cascading
function removeTreeRow(store, rowKey, movingRow) {
    var data = store.data, rowCoords = store.rowCoords, id = store.id, column = store.column;
    var rawData = data.rawData, viewData = data.viewData;
    var heights = rowCoords.heights;
    var parentRow = tree_1.getParentRow(store, rowKey);
    var modificationType = movingRow ? 'UPDATE' : 'DELETE';
    data_3.uncheck(store, rowKey);
    if (parentRow) {
        removeChildRowKey(parentRow, rowKey);
        if (!tree_1.getChildRowKeys(parentRow).length) {
            removeExpandedAttr(parentRow);
        }
    }
    var startIdx = data_2.findIndexByRowKey(data, column, id, rowKey);
    var deleteCount = tree_1.getDescendantRows(store, rowKey).length + 1;
    var removedRows = [];
    observable_1.batchObserver(function () {
        removedRows = rawData.splice(startIdx, deleteCount);
    });
    viewData.splice(startIdx, deleteCount);
    heights.splice(startIdx, deleteCount);
    for (var i = removedRows.length - 1; i >= 0; i -= 1) {
        instance_1.getDataManager(id).push(modificationType, [removedRows[i]]);
    }
    postUpdateAfterManipulation(store, startIdx, rawData);
}
exports.removeTreeRow = removeTreeRow;
function postUpdateAfterManipulation(store, rowIndex, rows) {
    data_3.setLoadingState(store, data_2.getLoadingState(store.data.rawData));
    data_3.updateRowNumber(store, rowIndex);
    data_3.setCheckedAllRows(store);
    column_2.setAutoResizingColumnWidths(store, rows);
}
function moveTreeRow(store, rowKey, targetIndex, options) {
    var data = store.data, column = store.column, id = store.id;
    var rawData = data.rawData;
    var targetRow = rawData[targetIndex];
    if (!targetRow || data_2.isSorted(data) || data_2.isFiltered(data)) {
        return;
    }
    var currentIndex = data_2.findIndexByRowKey(data, column, id, rowKey, false);
    var row = rawData[currentIndex];
    if (currentIndex === -1 ||
        currentIndex === targetIndex ||
        row._attributes.disabled ||
        (targetRow._attributes.disabled && options.appended)) {
        return;
    }
    var childRows = tree_1.getDescendantRows(store, rowKey);
    var minIndex = Math.min(currentIndex, targetIndex);
    var moveToChild = common_1.some(function (childRow) { return childRow.rowKey === targetRow.rowKey; }, childRows);
    if (!moveToChild) {
        removeTreeRow(store, rowKey, true);
        var originRow = observable_1.getOriginObject(row);
        instance_1.getDataManager(id).push('UPDATE', [targetRow], true);
        instance_1.getDataManager(id).push('UPDATE', [row], true);
        if (options.appended) {
            appendTreeRow(store, originRow, { parentRowKey: targetRow.rowKey, movingRow: true });
        }
        else {
            var parentRowKey = targetRow._attributes.tree.parentRowKey;
            var parentIndex = data_2.findIndexByRowKey(data, column, id, parentRowKey);
            var offset = targetIndex > currentIndex ? targetIndex - (childRows.length + 1) : targetIndex;
            // calculate the offset based on parent row
            if (parentIndex !== -1) {
                var parentRow = rawData[parentIndex];
                offset = parentRow._attributes.tree.childRowKeys.indexOf(targetRow.rowKey);
            }
            // to resolve the index for moving last index
            if (options.moveToLast) {
                parentRowKey = null;
                offset = rawData.length;
            }
            appendTreeRow(store, originRow, { parentRowKey: parentRowKey, offset: offset, movingRow: true });
        }
        postUpdateAfterManipulation(store, minIndex);
    }
}
exports.moveTreeRow = moveTreeRow;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createObservableData = exports.fillMissingColumnData = void 0;
var tslib_1 = __webpack_require__(1);
var observable_1 = __webpack_require__(5);
var data_1 = __webpack_require__(15);
var data_2 = __webpack_require__(6);
var tree_1 = __webpack_require__(20);
var common_1 = __webpack_require__(0);
function getDataToBeObservable(acc, row, viewRow, index, treeColumnName) {
    if (treeColumnName && row._attributes.tree.hidden) {
        return acc;
    }
    if (!observable_1.isObservable(row) ||
        (viewRow && row.rowKey === viewRow.rowKey && !observable_1.isObservable(viewRow.valueMap))) {
        acc.rows.push(row);
        acc.targetIndexes.push(index);
    }
    return acc;
}
function createOriginData(data, rowRange, treeColumnName) {
    var start = rowRange[0], end = rowRange[1];
    var viewData = data.viewData.slice(start, end);
    return data.rawData
        .slice(start, end)
        .reduce(function (acc, row, index) {
        return getDataToBeObservable(acc, row, viewData[index], index + start, treeColumnName);
    }, {
        rows: [],
        targetIndexes: [],
    });
}
function createFilteredOriginData(data, rowRange, treeColumnName) {
    var start = rowRange[0], end = rowRange[1];
    var rawData = data.rawData, viewData = data.viewData;
    return data
        .filteredIndex.slice(start, end)
        .reduce(function (acc, rowIndex) {
        return getDataToBeObservable(acc, rawData[rowIndex], viewData[rowIndex], rowIndex, treeColumnName);
    }, { rows: [], targetIndexes: [] });
}
function changeToObservableData(id, column, data, originData) {
    var targetIndexes = originData.targetIndexes, rows = originData.rows;
    var rawData = data.rawData;
    fillMissingColumnData(column, rows);
    // prevRows is needed to create rowSpan
    var prevRows = targetIndexes.map(function (targetIndex) { return data.rawData[targetIndex - 1]; });
    for (var index = 0, end = rows.length; index < end; index += 1) {
        var targetIndex = targetIndexes[index];
        var rawRow = data_1.createRawRow(id, rows[index], index, column, {
            lazyObservable: false,
            prevRow: prevRows[index],
            keyColumnName: column.keyColumnName,
        });
        var viewRow = data_1.createViewRow(id, rawRow, rawData, column);
        common_1.silentSplice(data.rawData, targetIndex, 1, rawRow);
        common_1.silentSplice(data.viewData, targetIndex, 1, viewRow);
    }
    observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
}
function changeToObservableTreeData(id, column, data, originData) {
    var rows = originData.rows;
    var rawData = data.rawData, viewData = data.viewData;
    fillMissingColumnData(column, rows);
    // create new creation key for updating the observe function of hoc component
    data_1.generateDataCreationKey();
    rows.forEach(function (row) {
        var parentRow = data_2.findRowByRowKey(data, column, id, row._attributes.tree.parentRowKey);
        var rawRow = tree_1.createTreeRawRow(id, row, parentRow || null, column);
        var viewRow = data_1.createViewRow(id, rawRow, rawData, column);
        var foundIndex = data_2.findIndexByRowKey(data, column, id, rawRow.rowKey);
        common_1.silentSplice(rawData, foundIndex, 1, rawRow);
        common_1.silentSplice(viewData, foundIndex, 1, viewRow);
    });
    observable_1.notify(data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
}
function fillMissingColumnData(column, rawData) {
    for (var i = 0; i < rawData.length; i += 1) {
        rawData[i] = tslib_1.__assign(tslib_1.__assign({}, column.emptyRow), rawData[i]);
    }
}
exports.fillMissingColumnData = fillMissingColumnData;
function createObservableData(_a, allRowRange) {
    var column = _a.column, data = _a.data, viewport = _a.viewport, id = _a.id;
    if (allRowRange === void 0) { allRowRange = false; }
    var rowRange = allRowRange ? [0, data.rawData.length] : viewport.rowRange;
    var treeColumnName = column.treeColumnName;
    var originData = data.filters && !allRowRange
        ? createFilteredOriginData(data, rowRange, treeColumnName)
        : createOriginData(data, rowRange, treeColumnName);
    if (!originData.rows.length) {
        return;
    }
    if (treeColumnName) {
        changeToObservableTreeData(id, column, data, originData);
    }
    else {
        changeToObservableData(id, column, data, originData);
    }
}
exports.createObservableData = createObservableData;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.moveColumn = exports.setColumnWidthsByText = exports.setAutoResizingColumnWidths = exports.changeColumnHeadersByName = exports.setComplexColumnHeaders = exports.showColumn = exports.hideColumn = exports.resetColumnWidths = exports.setColumns = exports.setColumnWidth = exports.setFrozenColumnCount = void 0;
var tslib_1 = __webpack_require__(1);
var column_1 = __webpack_require__(33);
var data_1 = __webpack_require__(15);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var eventBus_1 = __webpack_require__(7);
var focus_1 = __webpack_require__(18);
var observable_1 = __webpack_require__(5);
var sort_1 = __webpack_require__(28);
var filter_1 = __webpack_require__(36);
var selection_1 = __webpack_require__(16);
var common_1 = __webpack_require__(0);
var viewport_1 = __webpack_require__(25);
var dom_1 = __webpack_require__(2);
var data_2 = __webpack_require__(23);
var tree_1 = __webpack_require__(20);
var tree_2 = __webpack_require__(21);
var constant_1 = __webpack_require__(8);
var rowSpan_1 = __webpack_require__(24);
var column_2 = __webpack_require__(11);
var column_3 = __webpack_require__(12);
function setFrozenColumnCount(_a, count) {
    var column = _a.column;
    column.frozenCount = count;
}
exports.setFrozenColumnCount = setFrozenColumnCount;
function getCellWidthToBeResized(columns, range, resizeAmount, startWidths) {
    var widths = [];
    var startIdx = range[0], endIdx = range[1];
    var rangeLength = endIdx - startIdx + 1;
    var delta = resizeAmount / rangeLength;
    for (var idx = 0; idx < rangeLength; idx += 1) {
        var columnIdx = startIdx + idx;
        var minWidth = columns[columnIdx].minWidth;
        var width = Math.max(startWidths[idx] + delta, minWidth);
        widths.push(width);
    }
    return widths;
}
function setColumnWidth(_a, side, range, resizeAmount, startWidths) {
    var column = _a.column, id = _a.id;
    var eventBus = eventBus_1.getEventBus(id);
    var columns = column.visibleColumnsBySideWithRowHeader[side];
    var startIdx = range[0], endIdx = range[1];
    var resizedColumns = [];
    var widths = getCellWidthToBeResized(columns, range, resizeAmount, startWidths);
    for (var idx = startIdx; idx <= endIdx; idx += 1) {
        resizedColumns.push({
            columnName: columns[idx].name,
            width: widths[idx - startIdx],
        });
    }
    var gridEvent = new gridEvent_1.default({ resizedColumns: resizedColumns });
    /**
     * Occurs when column is resized
     * @event Grid#columnResize
     * @property {Array} resizedColumns - state about resized columns
     * @property {number} resizedColumns.columnName - columnName of the target cell
     * @property {number} resizedColumns.width - width of the resized column
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('columnResize', gridEvent);
    if (!gridEvent.isStopped()) {
        widths.forEach(function (width, idx) {
            var columnIdx = startIdx + idx;
            var item = columns[columnIdx];
            item.baseWidth = width;
            item.fixedWidth = true;
        });
    }
}
exports.setColumnWidth = setColumnWidth;
function setColumns(store, optColumns) {
    var column = store.column, data = store.data, id = store.id;
    var _a = column.dataForColumnCreation, columnOptions = _a.columnOptions, copyOptions = _a.copyOptions, treeColumnOptions = _a.treeColumnOptions, rowHeaders = _a.rowHeaders;
    var relationColumns = optColumns.reduce(function (acc, _a) {
        var _b = _a.relations, relations = _b === void 0 ? [] : _b;
        return acc.concat(column_1.createRelationColumns(relations)).filter(function (columnName, index) {
            var foundIndex = acc.indexOf(columnName);
            return foundIndex === -1 || foundIndex === index;
        });
    }, []);
    var columnInfos = optColumns.map(function (optColumn) {
        return column_1.createColumn(optColumn, columnOptions, relationColumns, copyOptions, treeColumnOptions, column.columnHeaderInfo, !!optColumn.disabled);
    });
    var dataCreationKey = data_1.generateDataCreationKey();
    viewport_1.initScrollPosition(store);
    focus_1.initFocus(store);
    selection_1.initSelection(store);
    column.allColumns = tslib_1.__spreadArrays(rowHeaders, columnInfos);
    data.viewData.forEach(function (viewRow) {
        if (Array.isArray(viewRow.__unobserveFns__)) {
            viewRow.__unobserveFns__.forEach(function (fn) { return fn(); });
        }
    });
    data.rawData = data.rawData.map(function (row) {
        var newRow = tslib_1.__assign(tslib_1.__assign({}, column.emptyRow), row);
        newRow.uniqueKey = dataCreationKey + "-" + row.rowKey;
        return newRow;
    });
    data.viewData = data.rawData.map(function (row) {
        return observable_1.isObservable(row)
            ? data_1.createViewRow(id, row, data.rawData, column)
            : { rowKey: row.rowKey, sortKey: row.sortKey, uniqueKey: row.uniqueKey };
    });
    filter_1.initFilter(store);
    sort_1.unsort(store);
    setColumnWidthsByText(store);
}
exports.setColumns = setColumns;
function resetColumnWidths(_a, widths) {
    var column = _a.column;
    column.visibleColumns.forEach(function (columnInfo, idx) {
        columnInfo.baseWidth = widths[idx];
        columnInfo.autoResizing = false;
    });
}
exports.resetColumnWidths = resetColumnWidths;
function setColumnsHiddenValue(column, columnName, hidden) {
    var allColumnMap = column.allColumnMap, complexColumnHeaders = column.complexColumnHeaders;
    if (complexColumnHeaders.length) {
        var complexColumn = common_1.findProp('name', columnName, complexColumnHeaders);
        if (complexColumn) {
            complexColumn.childNames.forEach(function (childName) {
                allColumnMap[childName].hidden = hidden;
            });
            return;
        }
    }
    allColumnMap[columnName].hidden = hidden;
}
function hideColumn(store, columnName) {
    var column = store.column, focus = store.focus;
    if (focus.columnName === columnName) {
        focus_1.initFocus(store);
    }
    selection_1.initSelection(store);
    filter_1.unfilter(store, columnName);
    sort_1.unsort(store, columnName);
    setColumnsHiddenValue(column, columnName, true);
}
exports.hideColumn = hideColumn;
function showColumn(store, columnName) {
    setColumnsHiddenValue(store.column, columnName, false);
    rowSpan_1.updateRowSpan(store);
}
exports.showColumn = showColumn;
function setComplexColumnHeaders(store, complexColumnHeaders) {
    store.column.complexColumnHeaders = complexColumnHeaders;
}
exports.setComplexColumnHeaders = setComplexColumnHeaders;
function changeColumnHeadersByName(_a, columnsMap) {
    var column = _a.column;
    var complexColumnHeaders = column.complexColumnHeaders, allColumnMap = column.allColumnMap;
    Object.keys(columnsMap).forEach(function (columnName) {
        var col = allColumnMap[columnName];
        if (col) {
            col.header = columnsMap[columnName];
        }
        if (complexColumnHeaders.length) {
            var complexCol = common_1.findProp('name', columnName, complexColumnHeaders);
            if (complexCol) {
                complexCol.header = columnsMap[columnName];
            }
        }
    });
    observable_1.notify(column, 'allColumns');
}
exports.changeColumnHeadersByName = changeColumnHeadersByName;
function setAutoResizingColumnWidths(store, targetData) {
    var autoResizingColumn = store.column.autoResizingColumn;
    var rawData = targetData || store.data.rawData;
    if (!rawData.length || !autoResizingColumn.length) {
        return;
    }
    data_2.initMaxTextMap();
    var maxTextMap = data_2.getMaxTextMap();
    rawData.forEach(function (row) {
        autoResizingColumn.forEach(function (columnInfo) {
            var name = columnInfo.name;
            var formattedValue = data_2.createFormattedValue(row, columnInfo);
            if (!maxTextMap[name] || maxTextMap[name].formattedValue.length < formattedValue.length) {
                data_2.setMaxColumnTextMap(name, formattedValue, row);
            }
        });
    });
    setColumnWidthsByText(store);
}
exports.setAutoResizingColumnWidths = setAutoResizingColumnWidths;
function setColumnWidthsByText(store) {
    var autoResizingColumn = store.column.autoResizingColumn;
    var bodyArea = document.querySelector("." + dom_1.cls('rside-area') + " ." + dom_1.cls('body-container') + " ." + dom_1.cls('table'));
    if (store.data.rawData.length && autoResizingColumn.length) {
        autoResizingColumn.forEach(function (_a) {
            var name = _a.name;
            setColumnWidthByText(store, name, bodyArea);
        });
    }
}
exports.setColumnWidthsByText = setColumnWidthsByText;
function setColumnWidthByText(_a, columnName, bodyArea) {
    var data = _a.data, column = _a.column;
    var allColumnMap = column.allColumnMap, treeColumnName = column.treeColumnName, treeIcon = column.treeIcon, treeIndentWidth = column.treeIndentWidth;
    var maxTextMap = data_2.getMaxTextMap();
    var _b = maxTextMap[columnName], formattedValue = _b.formattedValue, row = _b.row;
    var width = dom_1.getTextWidth(formattedValue, bodyArea);
    if (treeColumnName) {
        width +=
            tree_1.getTreeIndentWidth(tree_2.getDepth(data.rawData, row), treeIndentWidth, treeIcon) +
                constant_1.TREE_CELL_HORIZONTAL_PADDING;
    }
    allColumnMap[columnName].baseWidth = Math.max(allColumnMap[columnName].minWidth, width);
    allColumnMap[columnName].fixedWidth = true;
}
function moveColumn(store, columnName, targetIndex) {
    var column = store.column;
    var allColumns = column.allColumns;
    if (!column_3.isAllColumnsVisible(column) || column.complexColumnHeaders.length > 0) {
        return;
    }
    var originIndex = common_1.findIndex(function (_a) {
        var name = _a.name;
        return name === columnName;
    }, allColumns);
    var columnToMove = allColumns[originIndex];
    var targetColumnName = allColumns[targetIndex].name;
    if (columnName === targetColumnName ||
        column_2.isRowHeader(targetColumnName) ||
        tree_2.isTreeColumnName(column, targetColumnName)) {
        return;
    }
    focus_1.setFocusInfo(store, null, null, false);
    selection_1.initSelection(store);
    allColumns.splice(originIndex, 1);
    allColumns.splice(targetIndex, 0, columnToMove);
}
exports.moveColumn = moveColumn;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.createColumn = exports.createRelationColumns = exports.createColumnFilterOption = exports.validateRelationColumn = void 0;
var tslib_1 = __webpack_require__(1);
var observable_1 = __webpack_require__(5);
var column_1 = __webpack_require__(11);
var common_1 = __webpack_require__(0);
var default_1 = __webpack_require__(68);
var manager_1 = __webpack_require__(69);
var rowHeaderInput_1 = __webpack_require__(76);
var rowHeaderDraggable_1 = __webpack_require__(77);
var constant_1 = __webpack_require__(8);
var DEF_ROW_HEADER_INPUT = '<input type="checkbox" name="_checked" />';
var ROW_HEADER = 40;
var COLUMN = 50;
var rowHeadersMap = {
    rowNum: '_number',
    checkbox: '_checked',
    draggable: '_draggable',
};
function validateRelationColumn(columnInfos) {
    var checked = {};
    function checkCircularRelation(column, relations) {
        var name = column.name, relationMap = column.relationMap;
        relations.push(name);
        checked[name] = true;
        if (common_1.uniq(relations).length !== relations.length) {
            throw new Error('Cannot create circular reference between relation columns');
        }
        if (!common_1.isUndefined(relationMap)) {
            Object.keys(relationMap).forEach(function (targetName) {
                var targetColumn = common_1.findProp('name', targetName, columnInfos);
                // copy the 'relation' array to prevent to push all relation column into same array
                checkCircularRelation(targetColumn, tslib_1.__spreadArrays(relations));
            });
        }
    }
    columnInfos.forEach(function (column) {
        if (!checked[column.name]) {
            checkCircularRelation(column, []);
        }
    });
}
exports.validateRelationColumn = validateRelationColumn;
function createBuiltInEditorOptions(editorType, options) {
    var editInfo = manager_1.editorMap[editorType];
    return {
        type: editInfo[0],
        options: tslib_1.__assign(tslib_1.__assign({}, editInfo[1]), options),
    };
}
function createEditorOptions(editor) {
    if (common_1.isFunction(editor)) {
        return { type: editor };
    }
    if (common_1.isString(editor)) {
        return createBuiltInEditorOptions(editor);
    }
    if (common_1.isObject(editor)) {
        return common_1.isString(editor.type)
            ? createBuiltInEditorOptions(editor.type, editor.options)
            : editor;
    }
    return null;
}
function createRendererOptions(renderer) {
    if (common_1.isFunction(renderer)) {
        return { type: renderer };
    }
    if (common_1.isObject(renderer) && !common_1.isFunction(renderer) && common_1.isFunction(renderer.type)) {
        return renderer;
    }
    var defaultRenderer = { type: default_1.DefaultRenderer };
    return common_1.isObject(renderer)
        ? tslib_1.__assign(tslib_1.__assign({}, defaultRenderer), renderer)
        : defaultRenderer;
}
function createTreeInfo(treeColumnOptions, name) {
    if (treeColumnOptions && treeColumnOptions.name === name) {
        var _a = treeColumnOptions.useIcon, useIcon = _a === void 0 ? true : _a;
        return { tree: { useIcon: useIcon } };
    }
    return null;
}
function createRelationMap(relations) {
    var relationMap = {};
    relations.forEach(function (relation) {
        var editable = relation.editable, disabled = relation.disabled, listItems = relation.listItems, _a = relation.targetNames, targetNames = _a === void 0 ? [] : _a;
        targetNames.forEach(function (targetName) {
            relationMap[targetName] = {
                editable: editable,
                disabled: disabled,
                listItems: listItems,
            };
        });
    });
    return relationMap;
}
function createColumnHeaderInfo(name, columnHeaderInfo) {
    var columnHeaders = columnHeaderInfo.columnHeaders, defaultAlign = columnHeaderInfo.align, defaultVAlign = columnHeaderInfo.valign;
    var columnOption = common_1.findProp('name', name, columnHeaders);
    var headerAlign = columnOption && columnOption.align ? columnOption.align : defaultAlign;
    var headerVAlign = columnOption && columnOption.valign ? columnOption.valign : defaultVAlign;
    var headerRenderer = columnOption && columnOption.renderer ? columnOption.renderer : null;
    return {
        headerAlign: headerAlign,
        headerVAlign: headerVAlign,
        headerRenderer: headerRenderer,
    };
}
function createColumnFilterOption(filter) {
    var defaultOption = {
        type: common_1.isObject(filter) ? filter.type : filter,
        showApplyBtn: false,
        showClearBtn: false,
    };
    if (common_1.isString(filter)) {
        if (filter === 'select') {
            return tslib_1.__assign(tslib_1.__assign({}, defaultOption), { operator: 'OR' });
        }
    }
    if (common_1.isObject(filter)) {
        return tslib_1.__assign(tslib_1.__assign({}, defaultOption), (filter.type === 'select'
            ? common_1.omit(filter, 'showApplyBtn', 'showClearBtn', 'operator', 'options')
            : filter));
    }
    return defaultOption;
}
exports.createColumnFilterOption = createColumnFilterOption;
function createRelationColumns(relations) {
    var relationColumns = [];
    relations.forEach(function (relation) {
        var _a = relation.targetNames, targetNames = _a === void 0 ? [] : _a;
        targetNames.forEach(function (targetName) {
            relationColumns.push(targetName);
        });
    });
    return relationColumns;
}
exports.createRelationColumns = createRelationColumns;
// eslint-disable-next-line max-params
function createColumn(column, columnOptions, relationColumns, gridCopyOptions, treeColumnOptions, columnHeaderInfo, disabled) {
    var name = column.name, header = column.header, width = column.width, minWidth = column.minWidth, align = column.align, hidden = column.hidden, resizable = column.resizable, editor = column.editor, renderer = column.renderer, relations = column.relations, sortable = column.sortable, sortingType = column.sortingType, copyOptions = column.copyOptions, validation = column.validation, formatter = column.formatter, onBeforeChange = column.onBeforeChange, onAfterChange = column.onAfterChange, whiteSpace = column.whiteSpace, ellipsis = column.ellipsis, valign = column.valign, defaultValue = column.defaultValue, escapeHTML = column.escapeHTML, ignored = column.ignored, filter = column.filter, className = column.className, comparator = column.comparator, customHeader = column.customHeader;
    var editorOptions = createEditorOptions(editor);
    var rendererOptions = createRendererOptions(renderer);
    var filterOptions = filter ? createColumnFilterOption(filter) : null;
    var _a = createColumnHeaderInfo(name, columnHeaderInfo), headerAlign = _a.headerAlign, headerVAlign = _a.headerVAlign, headerRenderer = _a.headerRenderer;
    var useRowSpanOption = column.rowSpan && !treeColumnOptions.name && !common_1.includes(relationColumns, column.name);
    var rowSpan = useRowSpanOption ? column.rowSpan : false;
    return observable_1.observable(tslib_1.__assign(tslib_1.__assign(tslib_1.__assign({ name: name,
        escapeHTML: escapeHTML, header: header || (customHeader === null || customHeader === void 0 ? void 0 : customHeader.textContent) || name, hidden: Boolean(hidden), resizable: common_1.isUndefined(resizable) ? Boolean(columnOptions.resizable) : Boolean(resizable), align: align || 'left', fixedWidth: typeof width === 'number', copyOptions: tslib_1.__assign(tslib_1.__assign({}, gridCopyOptions), copyOptions), baseWidth: (width === 'auto' ? 0 : width) || 0, minWidth: minWidth || columnOptions.minWidth || COLUMN, relationMap: createRelationMap(relations || []), related: common_1.includes(relationColumns, name), sortable: sortable, sortingType: sortingType || 'asc', validation: validation ? tslib_1.__assign({}, validation) : {}, renderer: rendererOptions, formatter: formatter,
        onBeforeChange: onBeforeChange,
        onAfterChange: onAfterChange,
        whiteSpace: whiteSpace,
        ellipsis: ellipsis, valign: valign || 'middle', defaultValue: defaultValue,
        ignored: ignored }, (!!editorOptions && { editor: editorOptions })), createTreeInfo(treeColumnOptions, name)), { headerAlign: headerAlign,
        headerVAlign: headerVAlign, filter: filterOptions, headerRenderer: headerRenderer,
        className: className,
        disabled: disabled,
        comparator: comparator, autoResizing: width === 'auto', rowSpan: rowSpan,
        customHeader: customHeader }));
}
exports.createColumn = createColumn;
function createRowHeader(data, columnHeaderInfo) {
    var rowHeader = common_1.isString(data)
        ? { name: rowHeadersMap[data] }
        : tslib_1.__assign({ name: rowHeadersMap[data.type] }, common_1.omit(data, 'type'));
    var name = rowHeader.name, header = rowHeader.header, align = rowHeader.align, valign = rowHeader.valign, renderer = rowHeader.renderer, width = rowHeader.width, minWidth = rowHeader.minWidth;
    var baseMinWith = common_1.isNumber(minWidth) ? minWidth : ROW_HEADER;
    var baseWidth = (width === 'auto' ? baseMinWith : width) || baseMinWith;
    var rowNumColumn = column_1.isRowNumColumn(name);
    var defaultHeader = rowNumColumn ? 'No. ' : DEF_ROW_HEADER_INPUT;
    var rendererOptions = renderer || {
        type: rowNumColumn ? default_1.DefaultRenderer : rowHeaderInput_1.RowHeaderInputRenderer,
    };
    var _a = createColumnHeaderInfo(name, columnHeaderInfo), headerAlign = _a.headerAlign, headerVAlign = _a.headerVAlign, headerRenderer = _a.headerRenderer;
    return observable_1.observable({
        name: name,
        header: header || defaultHeader,
        hidden: false,
        resizable: false,
        align: align || 'center',
        valign: valign || 'middle',
        renderer: createRendererOptions(rendererOptions),
        fixedWidth: true,
        baseWidth: baseWidth,
        escapeHTML: false,
        minWidth: baseMinWith,
        headerAlign: headerAlign,
        headerVAlign: headerVAlign,
        headerRenderer: headerRenderer,
        autoResizing: false,
    });
}
function createComplexColumnHeaders(column, columnHeaderInfo) {
    var header = column.header, name = column.name, childNames = column.childNames, renderer = column.renderer, hideChildHeaders = column.hideChildHeaders, _a = column.resizable, resizable = _a === void 0 ? false : _a;
    var headerAlign = column.headerAlign || columnHeaderInfo.align;
    var headerVAlign = column.headerVAlign || columnHeaderInfo.valign;
    return observable_1.observable({
        header: header,
        name: name,
        childNames: childNames,
        headerAlign: headerAlign,
        headerVAlign: headerVAlign,
        headerRenderer: renderer || null,
        hideChildHeaders: hideChildHeaders,
        resizable: resizable,
    });
}
function createDraggableRowHeader(rowHeaderColumn) {
    var renderer = common_1.isObject(rowHeaderColumn)
        ? rowHeaderColumn.renderer
        : { type: rowHeaderDraggable_1.RowHeaderDraggableRenderer };
    var draggableColumn = {
        name: '_draggable',
        header: '',
        hidden: false,
        resizable: false,
        align: 'center',
        valign: 'middle',
        renderer: createRendererOptions(renderer),
        baseWidth: ROW_HEADER,
        minWidth: ROW_HEADER,
        fixedWidth: true,
        autoResizing: false,
        escapeHTML: false,
        headerAlign: 'center',
        headerVAlign: 'middle',
    };
    return draggableColumn;
}
function create(_a) {
    var columns = _a.columns, columnOptions = _a.columnOptions, rowHeaders = _a.rowHeaders, copyOptions = _a.copyOptions, keyColumnName = _a.keyColumnName, treeColumnOptions = _a.treeColumnOptions, complexColumns = _a.complexColumns, align = _a.align, valign = _a.valign, columnHeaders = _a.columnHeaders, disabled = _a.disabled, draggable = _a.draggable;
    var relationColumns = columns.reduce(function (acc, _a) {
        var relations = _a.relations;
        acc = acc.concat(createRelationColumns(relations || []));
        return acc.filter(function (columnName, idx) { return acc.indexOf(columnName) === idx; });
    }, []);
    var columnHeaderInfo = { columnHeaders: columnHeaders, align: align, valign: valign };
    var rowHeaderInfos = [];
    if (draggable) {
        var rowHeaderColumn = null;
        var index = common_1.findIndex(function (rowHeader) {
            return (common_1.isString(rowHeader) && rowHeader === 'draggable') ||
                rowHeader.type === 'draggable';
        }, rowHeaders);
        if (index !== -1) {
            rowHeaderColumn = rowHeaders.splice(index, 1)[0];
        }
        rowHeaderInfos.push(createDraggableRowHeader(rowHeaderColumn));
    }
    rowHeaders.forEach(function (rowHeader) {
        return rowHeaderInfos.push(createRowHeader(rowHeader, columnHeaderInfo));
    });
    var columnInfos = columns.map(function (column) {
        return createColumn(column, columnOptions, relationColumns, copyOptions, treeColumnOptions, columnHeaderInfo, !!(disabled || column.disabled));
    });
    validateRelationColumn(columnInfos);
    var allColumns = rowHeaderInfos.concat(columnInfos);
    var treeColumnName = treeColumnOptions.name, _b = treeColumnOptions.useIcon, treeIcon = _b === void 0 ? true : _b, _c = treeColumnOptions.useCascadingCheckbox, treeCascadingCheckbox = _c === void 0 ? true : _c, _d = treeColumnOptions.indentWidth, treeIndentWidth = _d === void 0 ? constant_1.TREE_INDENT_WIDTH : _d;
    var complexColumnHeaders = complexColumns.map(function (column) {
        return createComplexColumnHeaders(column, columnHeaderInfo);
    });
    return observable_1.observable(tslib_1.__assign({ keyColumnName: keyColumnName,
        allColumns: allColumns,
        complexColumnHeaders: complexColumnHeaders,
        columnHeaderInfo: columnHeaderInfo, frozenCount: columnOptions.frozenCount || 0, draggable: draggable, dataForColumnCreation: {
            copyOptions: copyOptions,
            columnOptions: columnOptions,
            treeColumnOptions: treeColumnOptions,
            relationColumns: relationColumns,
            rowHeaders: rowHeaderInfos,
        }, get allColumnMap() {
            return common_1.createMapFromArray(this.allColumns, 'name');
        }, get rowHeaderCount() {
            return rowHeaderInfos.length;
        }, get visibleColumns() {
            return this.allColumns.slice(this.rowHeaderCount).filter(function (_a) {
                var hidden = _a.hidden;
                return !hidden;
            });
        },
        get visibleColumnsWithRowHeader() {
            return this.allColumns.filter(function (_a) {
                var hidden = _a.hidden;
                return !hidden;
            });
        }, get visibleColumnsBySide() {
            return {
                L: this.visibleColumns.slice(0, this.frozenCount),
                R: this.visibleColumns.slice(this.frozenCount),
            };
        }, get visibleColumnsBySideWithRowHeader() {
            var frozenLastIndex = this.rowHeaderCount + this.frozenCount;
            return {
                L: this.visibleColumnsWithRowHeader.slice(0, frozenLastIndex),
                R: this.visibleColumnsWithRowHeader.slice(frozenLastIndex),
            };
        },
        get visibleRowSpanEnabledColumns() {
            return this.visibleColumns.filter(function (_a) {
                var rowSpan = _a.rowSpan;
                return rowSpan;
            });
        },
        get defaultValues() {
            return this.allColumns
                .filter(function (_a) {
                var defaultValue = _a.defaultValue;
                return Boolean(defaultValue);
            })
                .map(function (_a) {
                var name = _a.name, defaultValue = _a.defaultValue;
                return ({ name: name, value: defaultValue });
            });
        }, get visibleFrozenCount() {
            return this.visibleColumnsBySideWithRowHeader.L.length;
        }, get validationColumns() {
            return this.allColumns.filter(function (_a) {
                var validation = _a.validation;
                return !common_1.isEmpty(validation);
            });
        },
        get ignoredColumns() {
            return this.allColumns.filter(function (_a) {
                var ignored = _a.ignored;
                return ignored;
            }).map(function (_a) {
                var name = _a.name;
                return name;
            });
        },
        get columnMapWithRelation() {
            // copy the array to prevent to affect allColumns property
            var copiedColumns = tslib_1.__spreadArrays(this.allColumns);
            copiedColumns.sort(function (columnA, columnB) {
                var _a, _b;
                var hasRelationMapA = !common_1.isEmpty(columnA.relationMap);
                var hasRelationMapB = !common_1.isEmpty(columnB.relationMap);
                if (hasRelationMapA && hasRelationMapB) {
                    if ((_a = columnA.relationMap) === null || _a === void 0 ? void 0 : _a[columnB.name]) {
                        return -1;
                    }
                    return ((_b = columnB.relationMap) === null || _b === void 0 ? void 0 : _b[columnA.name]) ? 1 : 0;
                }
                if (hasRelationMapA) {
                    return -1;
                }
                return hasRelationMapB ? 1 : 0;
            });
            return common_1.createMapFromArray(copiedColumns, 'name');
        }, get columnsWithoutRowHeader() {
            return this.allColumns.slice(this.rowHeaderCount);
        }, get emptyRow() {
            return this.columnsWithoutRowHeader.reduce(function (acc, _a) {
                var _b;
                var name = _a.name;
                return (tslib_1.__assign(tslib_1.__assign({}, acc), (_b = {}, _b[name] = null, _b)));
            }, {});
        },
        get autoResizingColumn() {
            return this.columnsWithoutRowHeader.filter(function (_a) {
                var autoResizing = _a.autoResizing;
                return autoResizing;
            });
        } }, (treeColumnName && { treeColumnName: treeColumnName, treeIcon: treeIcon, treeCascadingCheckbox: treeCascadingCheckbox, treeIndentWidth: treeIndentWidth })));
}
exports.create = create;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getListItems = void 0;
var common_1 = __webpack_require__(0);
function getListItems(props) {
    var _a;
    var _b = (_a = props.columnInfo.editor.options) !== null && _a !== void 0 ? _a : {}, listItems = _b.listItems, relationListItemMap = _b.relationListItemMap;
    if (!common_1.isEmpty(relationListItemMap) && Array.isArray(relationListItemMap[props.rowKey])) {
        return relationListItemMap[props.rowKey];
    }
    return listItems;
}
exports.getListItems = getListItems;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.setLayerPosition = exports.moveLayer = exports.getContainerElement = exports.setOpacity = void 0;
var common_1 = __webpack_require__(0);
var dom_1 = __webpack_require__(2);
var INDENT = 5;
var SCROLL_BAR_WIDTH = 17;
var SCROLL_BAR_HEIGHT = 17;
function exceedGridViewport(top, left, _a) {
    var bodyHeight = _a.bodyHeight, bodyWidth = _a.bodyWidth, headerHeight = _a.headerHeight, leftSideWidth = _a.leftSideWidth;
    return !(common_1.isBetween(top, headerHeight, bodyHeight + headerHeight) &&
        common_1.isBetween(left, leftSideWidth, bodyWidth));
}
function setOpacity(el, opacity) {
    el.style.opacity = String(opacity);
}
exports.setOpacity = setOpacity;
function getContainerElement(el) {
    return dom_1.findParentByClassName(el, 'container');
}
exports.getContainerElement = getContainerElement;
function moveLayer(layerEl, initLayerPos, gridRect) {
    var top = initLayerPos.top, left = initLayerPos.left;
    var initBodyScrollTop = gridRect.initBodyScrollTop, initBodyScrollLeft = gridRect.initBodyScrollLeft, bodyScrollTop = gridRect.bodyScrollTop, bodyScrollLeft = gridRect.bodyScrollLeft;
    var newTop = top + initBodyScrollTop - bodyScrollTop;
    var newLeft = left + initBodyScrollLeft - bodyScrollLeft;
    if (exceedGridViewport(newTop, newLeft, gridRect)) {
        layerEl.style.zIndex = '-100';
        layerEl.style.top = '0px';
        layerEl.style.left = '0px';
    }
    else {
        layerEl.style.zIndex = '';
        layerEl.style.top = newTop + "px";
        layerEl.style.left = newLeft + "px";
    }
}
exports.moveLayer = moveLayer;
function setLayerPosition(innerEl, layerEl, childEl, startBottom) {
    if (startBottom === void 0) { startBottom = false; }
    var containerRect = getContainerElement(innerEl).getBoundingClientRect();
    var innerHeight = window.innerHeight, innerWidth = window.innerWidth;
    var _a = innerEl.getBoundingClientRect(), left = _a.left, top = _a.top, bottom = _a.bottom;
    var _b = layerEl.getBoundingClientRect(), layerHeight = _b.height, layerWidth = _b.width;
    var layerTop = startBottom ? bottom : top + INDENT;
    var childElHeight = 0;
    var childElWidth = 0;
    if (childEl) {
        var _c = childEl.getBoundingClientRect(), height = _c.height, width = _c.width;
        childElHeight = height;
        childElWidth = width;
    }
    var totalHeight = layerHeight + childElHeight;
    var totalWidth = layerWidth || childElWidth;
    layerEl.style.top = (layerTop + totalHeight > innerHeight - SCROLL_BAR_WIDTH
        ? innerHeight - totalHeight - INDENT - SCROLL_BAR_WIDTH
        : layerTop) - containerRect.top + "px";
    layerEl.style.left = (left + totalWidth > innerWidth - SCROLL_BAR_HEIGHT
        ? innerWidth - totalWidth - INDENT - SCROLL_BAR_HEIGHT
        : left) - containerRect.left + "px";
}
exports.setLayerPosition = setLayerPosition;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.resetFilterState = exports.emitAfterFilter = exports.initFilter = exports.setFilter = exports.unfilter = exports.clearFilter = exports.updateFilters = exports.filter = exports.setActiveFilterState = exports.clearActiveFilterState = exports.applyActiveFilterState = exports.setActiveColumnAddress = exports.setActiveSelectFilterState = exports.toggleSelectAllCheckbox = exports.setActiveFilterOperator = void 0;
var observable_1 = __webpack_require__(5);
var common_1 = __webpack_require__(0);
var filter_1 = __webpack_require__(29);
var data_1 = __webpack_require__(6);
var column_1 = __webpack_require__(33);
var viewport_1 = __webpack_require__(25);
var selection_1 = __webpack_require__(16);
var focus_1 = __webpack_require__(18);
var eventBus_1 = __webpack_require__(7);
var column_2 = __webpack_require__(12);
var data_2 = __webpack_require__(14);
var summary_1 = __webpack_require__(26);
var filter_2 = __webpack_require__(49);
var pagination_1 = __webpack_require__(37);
var rowSpan_1 = __webpack_require__(24);
function initLayerAndScrollAfterFiltering(store) {
    var data = store.data;
    viewport_1.initScrollPosition(store);
    selection_1.initSelection(store);
    focus_1.initFocus(store);
    pagination_1.updatePageOptions(store, { totalCount: data.filteredRawData.length, page: 1 });
    data_2.updateHeights(store);
    data_2.setCheckedAllRows(store);
}
function setActiveFilterOperator(store, operator) {
    var column = store.column, filterLayerState = store.filterLayerState;
    var activeFilterState = filterLayerState.activeFilterState;
    var columnInfo = column.allColumnMap[activeFilterState.columnName];
    var columnFilterOption = columnInfo.filter;
    activeFilterState.operator = operator;
    if (!columnFilterOption.showApplyBtn) {
        columnFilterOption.operator = operator;
        applyActiveFilterState(store);
    }
}
exports.setActiveFilterOperator = setActiveFilterOperator;
function toggleSelectAllCheckbox(store, checked) {
    var column = store.column, filterLayerState = store.filterLayerState, data = store.data;
    var activeFilterState = filterLayerState.activeFilterState;
    var columnName = activeFilterState.columnName;
    var columnInfo = column.allColumnMap[columnName];
    if (checked) {
        var columnData = data_1.getUniqColumnData(data.rawData, column, columnName);
        activeFilterState.state = columnData.map(function (value) { return ({ code: 'eq', value: value }); });
    }
    else {
        activeFilterState.state = [];
    }
    if (!columnInfo.filter.showApplyBtn) {
        applyActiveFilterState(store);
    }
}
exports.toggleSelectAllCheckbox = toggleSelectAllCheckbox;
function setActiveSelectFilterState(store, value, checked) {
    var column = store.column, filterLayerState = store.filterLayerState;
    var activeFilterState = filterLayerState.activeFilterState;
    var columnName = filterLayerState.activeColumnAddress.name;
    var columnInfo = column.allColumnMap[columnName];
    if (checked) {
        activeFilterState.state.push({ value: value, code: 'eq' });
    }
    else {
        var index = common_1.findPropIndex('value', value, activeFilterState.state);
        activeFilterState.state.splice(index, 1);
    }
    if (!columnInfo.filter.showApplyBtn) {
        applyActiveFilterState(store);
    }
    else {
        observable_1.notify(filterLayerState, 'activeFilterState');
    }
}
exports.setActiveSelectFilterState = setActiveSelectFilterState;
function setActiveColumnAddress(store, address) {
    var data = store.data, column = store.column, filterLayerState = store.filterLayerState;
    var filters = data.filters, filteredRawData = data.filteredRawData;
    filterLayerState.activeColumnAddress = address;
    if (!address) {
        filterLayerState.activeFilterState = null;
        return;
    }
    var columnName = address.name;
    var _a = column.allColumnMap[columnName].filter, type = _a.type, operator = _a.operator;
    var initialState = [];
    if (filters) {
        var prevFilter = common_1.findProp('columnName', columnName, filters);
        if (prevFilter) {
            initialState = prevFilter.state;
        }
    }
    if (type === 'select' && !initialState.length) {
        var columnData = data_1.getUniqColumnData(filteredRawData, column, columnName);
        initialState = columnData.map(function (value) { return ({ code: 'eq', value: value }); });
    }
    filterLayerState.activeFilterState = {
        columnName: columnName,
        type: type,
        operator: operator,
        state: initialState,
    };
}
exports.setActiveColumnAddress = setActiveColumnAddress;
function applyActiveFilterState(store) {
    var filterLayerState = store.filterLayerState, data = store.data, column = store.column;
    var columnName = filterLayerState.activeColumnAddress.name;
    var _a = filterLayerState.activeFilterState, state = _a.state, type = _a.type, operator = _a.operator;
    var validState = state.filter(function (item) { return String(item.value).length; });
    if (type !== 'select' && !validState.length) {
        unfilter(store, columnName);
        return;
    }
    filterLayerState.activeFilterState.state = state;
    if (type === 'select') {
        var columnData_1 = data_1.getUniqColumnData(data.rawData, column, columnName);
        var updatedState = state.filter(function (_a) {
            var value = _a.value;
            return columnData_1.includes(value);
        });
        filterLayerState.activeFilterState.state = updatedState;
        if (columnData_1.length === updatedState.length) {
            unfilter(store, columnName);
            return;
        }
    }
    var fns = state.map(function (_a) {
        var code = _a.code, value = _a.value;
        return filter_1.getFilterConditionFn(code, value, type);
    });
    filter(store, columnName, filter_1.composeConditionFn(fns, operator), state);
}
exports.applyActiveFilterState = applyActiveFilterState;
function clearActiveFilterState(store) {
    var filterLayerState = store.filterLayerState;
    var activeFilterState = filterLayerState.activeFilterState;
    activeFilterState.state = [];
    unfilter(store, activeFilterState.columnName);
    observable_1.notify(filterLayerState, 'activeFilterState');
}
exports.clearActiveFilterState = clearActiveFilterState;
function setActiveFilterState(store, state, filterIndex) {
    var column = store.column, filterLayerState = store.filterLayerState;
    var columnName = filterLayerState.activeColumnAddress.name;
    var columnInfo = column.allColumnMap[columnName];
    filterLayerState.activeFilterState.state[filterIndex] = state;
    if (!columnInfo.filter.showApplyBtn) {
        applyActiveFilterState(store);
    }
    else {
        observable_1.notify(filterLayerState, 'activeFilterState');
    }
}
exports.setActiveFilterState = setActiveFilterState;
function filter(store, columnName, conditionFn, state) {
    var column = store.column;
    var columnFilterInfo = column.allColumnMap[columnName].filter;
    if (column_2.isComplexHeader(column, columnName) ||
        !columnFilterInfo ||
        column_2.isHiddenColumn(column, columnName)) {
        return;
    }
    var type = columnFilterInfo.type, operator = columnFilterInfo.operator;
    var nextColumnFilterState = { columnName: columnName, type: type, conditionFn: conditionFn, state: state, operator: operator };
    var gridEvent = emitBeforeFilter(store, 'beforeFilter', nextColumnFilterState);
    if (gridEvent.isStopped()) {
        return;
    }
    pagination_1.updatePageOptions(store, { page: 1 });
    updateFilters(store, columnName, nextColumnFilterState);
    initLayerAndScrollAfterFiltering(store);
    summary_1.updateAllSummaryValues(store);
    emitAfterFilter(store, 'afterFilter', columnName);
    rowSpan_1.updateRowSpan(store);
}
exports.filter = filter;
function updateFilters(_a, columnName, nextColumnFilterState) {
    var data = _a.data;
    var filters = data.filters || [];
    var filterIndex = common_1.findPropIndex('columnName', columnName, filters);
    if (filterIndex >= 0) {
        filters.splice(filterIndex, 1, nextColumnFilterState);
    }
    else {
        data.filters = filters.concat(nextColumnFilterState);
    }
}
exports.updateFilters = updateFilters;
function clearFilter(_a, columnName) {
    var data = _a.data;
    var filters = data.filters || [];
    var filterIndex = common_1.findPropIndex('columnName', columnName, filters);
    if (filterIndex >= 0) {
        if (filters.length === 1) {
            data.filters = null;
        }
        else {
            filters.splice(filterIndex, 1);
        }
    }
}
exports.clearFilter = clearFilter;
function clearAll(store) {
    var gridEvent = emitBeforeFilter(store, 'beforeUnfilter', { columnName: null });
    if (gridEvent.isStopped()) {
        return;
    }
    initFilter(store);
    initLayerAndScrollAfterFiltering(store);
    summary_1.updateAllSummaryValues(store);
    emitAfterFilter(store, 'afterUnfilter', null);
}
function unfilter(store, columnName) {
    var data = store.data, column = store.column;
    var filters = data.filters;
    if (!columnName) {
        clearAll(store);
        return;
    }
    if (column_2.isComplexHeader(column, columnName) || column_2.isHiddenColumn(column, columnName)) {
        return;
    }
    if (filters) {
        var gridEvent = emitBeforeFilter(store, 'beforeUnfilter', { columnName: columnName });
        if (gridEvent.isStopped()) {
            return;
        }
        clearFilter(store, columnName);
        initLayerAndScrollAfterFiltering(store);
        summary_1.updateAllSummaryValues(store);
        emitAfterFilter(store, 'afterUnfilter', columnName);
    }
    rowSpan_1.updateRowSpan(store);
}
exports.unfilter = unfilter;
function setFilter(store, columnName, filterOpt) {
    var column = store.column;
    var filterOptions = column_1.createColumnFilterOption(filterOpt);
    var index = common_1.findPropIndex('name', columnName, column.allColumns);
    if (index !== -1) {
        if (column.allColumns[index].filter) {
            unfilter(store, columnName);
        }
        column.allColumns[index].filter = filterOptions;
        observable_1.notify(column, 'allColumns');
    }
}
exports.setFilter = setFilter;
function initFilter(store) {
    var filterLayerState = store.filterLayerState, data = store.data;
    filterLayerState.activeFilterState = null;
    filterLayerState.activeColumnAddress = null;
    data.filters = null;
}
exports.initFilter = initFilter;
function emitBeforeFilter(store, eventType, eventParams) {
    var eventBus = eventBus_1.getEventBus(store.id);
    var gridEvent = filter_2.createFilterEvent(store, eventType, eventParams);
    eventBus.trigger(eventType, gridEvent);
    return gridEvent;
}
function emitAfterFilter(store, eventType, columnName) {
    var id = store.id;
    var eventBus = eventBus_1.getEventBus(id);
    // @TODO: `filter` event will be deprecated. This event is replaced with `afterFilter` event
    var eventTypes = (eventType === 'afterFilter'
        ? ['afterFilter', 'filter']
        : ['afterUnfilter']);
    eventTypes.forEach(function (type) {
        var gridEvent = filter_2.createFilterEvent(store, type, { columnName: columnName });
        eventBus.trigger(type, gridEvent);
    });
}
exports.emitAfterFilter = emitAfterFilter;
function resetFilterState(store, filterState) {
    if (filterState) {
        var columnFilterState = filterState.columnFilterState, columnName = filterState.columnName;
        var columnFilterOption = store.column.allColumnMap[columnName].filter;
        if (columnFilterOption) {
            if (columnFilterState) {
                var nextState = {
                    conditionFn: function () { return true; },
                    type: columnFilterOption.type,
                    state: columnFilterState,
                    columnName: columnName,
                    operator: columnFilterOption.operator,
                };
                updateFilters(store, columnName, nextState);
            }
            else {
                clearFilter(store, columnName);
            }
        }
    }
    else {
        initFilter(store);
    }
}
exports.resetFilterState = resetFilterState;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.resetPageState = exports.updatePageWhenRemovingRow = exports.movePage = exports.updatePageOptions = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var data_1 = __webpack_require__(6);
var viewport_1 = __webpack_require__(25);
var selection_1 = __webpack_require__(16);
var focus_1 = __webpack_require__(18);
var data_2 = __webpack_require__(14);
var summary_1 = __webpack_require__(26);
var observable_1 = __webpack_require__(5);
function updatePageOptions(_a, pageOptions, forceUpdatePage) {
    var data = _a.data;
    if (forceUpdatePage === void 0) { forceUpdatePage = false; }
    var orgPageOptions = data.pageOptions;
    if (!common_1.isEmpty(orgPageOptions)) {
        // if infinite scrolling is applied, page number should be not reset to know the last loaded page
        if (!forceUpdatePage && data_1.isScrollPagination(data)) {
            delete pageOptions.page;
        }
        var newPageOptions = tslib_1.__assign(tslib_1.__assign({}, orgPageOptions), pageOptions);
        if (!common_1.shallowEqual(newPageOptions, orgPageOptions)) {
            data.pageOptions = newPageOptions;
        }
    }
}
exports.updatePageOptions = updatePageOptions;
function movePage(store, page) {
    var data = store.data;
    viewport_1.initScrollPosition(store);
    data.pageOptions.page = page;
    observable_1.notify(data, 'pageOptions');
    data_2.updateHeights(store);
    selection_1.initSelection(store);
    focus_1.initFocus(store);
    data_2.setCheckedAllRows(store);
    summary_1.updateAllSummaryValues(store);
}
exports.movePage = movePage;
function updatePageWhenRemovingRow(store, deletedCount) {
    var pageOptions = store.data.pageOptions;
    if (!common_1.isEmpty(pageOptions)) {
        var perPage = pageOptions.perPage, totalCount = pageOptions.totalCount, page = pageOptions.page;
        var modifiedLastPage = Math.floor((totalCount - deletedCount) / perPage);
        if ((totalCount - deletedCount) % perPage) {
            modifiedLastPage += 1;
        }
        updatePageOptions(store, {
            totalCount: totalCount - deletedCount,
            page: (modifiedLastPage < page ? modifiedLastPage : page) || 1,
        }, true);
    }
}
exports.updatePageWhenRemovingRow = updatePageWhenRemovingRow;
function resetPageState(store, totalCount, pageState) {
    var pageOptions = pageState ? common_1.pruneObject(pageState) : { page: 1, totalCount: totalCount };
    updatePageOptions(store, pageOptions, true);
}
exports.resetPageState = resetPageState;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.findRowIndexByPosition = exports.findColumnIndexByPosition = exports.getColumnNameRange = exports.getOverflowFromMousePosition = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
function getTotalColumnOffsets(widths, cellBorderWidth) {
    var totalWidths = tslib_1.__spreadArrays(widths.L, widths.R);
    var offsets = [0];
    for (var i = 1, len = totalWidths.length; i < len; i += 1) {
        offsets.push(offsets[i - 1] + totalWidths[i - 1] + cellBorderWidth);
    }
    return offsets;
}
function getScrolledPosition(_a, dimension, leftSideWidth) {
    var pageX = _a.pageX, pageY = _a.pageY, scrollLeft = _a.scrollLeft, scrollTop = _a.scrollTop;
    var _b = getPositionFromBodyArea(pageX, pageY, dimension), bodyPositionX = _b.x, bodyPositionY = _b.y;
    var scrollX = bodyPositionX > leftSideWidth ? scrollLeft : 0;
    var scrolledPositionX = bodyPositionX + scrollX;
    var scrolledPositionY = bodyPositionY + scrollTop;
    return {
        x: scrolledPositionX,
        y: scrolledPositionY,
    };
}
function judgeOverflow(_a, _b) {
    var containerX = _a.x, containerY = _a.y;
    var bodyHeight = _b.bodyHeight, bodyWidth = _b.bodyWidth;
    var overflowY = 0;
    var overflowX = 0;
    if (containerY < 0) {
        overflowY = -1;
    }
    else if (containerY > bodyHeight) {
        overflowY = 1;
    }
    if (containerX < 0) {
        overflowX = -1;
    }
    else if (containerX > bodyWidth) {
        overflowX = 1;
    }
    return {
        x: overflowX,
        y: overflowY,
    };
}
function getPositionFromBodyArea(pageX, pageY, dimension) {
    var offsetLeft = dimension.offsetLeft, offsetTop = dimension.offsetTop, tableBorderWidth = dimension.tableBorderWidth, cellBorderWidth = dimension.cellBorderWidth, headerHeight = dimension.headerHeight, summaryHeight = dimension.summaryHeight, summaryPosition = dimension.summaryPosition;
    var adjustedSummaryHeight = summaryPosition === 'top' ? summaryHeight : 0;
    return {
        x: pageX - offsetLeft,
        y: pageY -
            (offsetTop + headerHeight + adjustedSummaryHeight + cellBorderWidth + tableBorderWidth),
    };
}
function getOverflowFromMousePosition(pageX, pageY, bodyWidth, dimension) {
    var bodyHeight = dimension.bodyHeight;
    var _a = getPositionFromBodyArea(pageX, pageY, dimension), x = _a.x, y = _a.y;
    return judgeOverflow({ x: x, y: y }, { bodyWidth: bodyWidth, bodyHeight: bodyHeight });
}
exports.getOverflowFromMousePosition = getOverflowFromMousePosition;
function getColumnNameRange(store, dragStartData, dragData, elementInfo) {
    var allColumns = store.column.allColumns;
    var scrollTop = elementInfo.scrollTop, scrollLeft = elementInfo.scrollLeft;
    var startPageX = dragStartData.pageX, startPageY = dragStartData.pageY;
    var endPageX = dragData.pageX, endPageY = dragData.pageY;
    var startViewInfo = { pageX: startPageX, pageY: startPageY, scrollTop: scrollTop, scrollLeft: scrollLeft };
    var endViewInfo = { pageX: endPageX, pageY: endPageY, scrollTop: scrollTop, scrollLeft: scrollLeft };
    var startColumnIndex = findColumnIndexByPosition(store, startViewInfo);
    var endColumnIndex = findColumnIndexByPosition(store, endViewInfo);
    var startColumnName = allColumns[startColumnIndex].name;
    var endColumnName = allColumns[endColumnIndex].name;
    return [startColumnName, endColumnName];
}
exports.getColumnNameRange = getColumnNameRange;
function findColumnIndexByPosition(store, viewInfo) {
    var dimension = store.dimension, columnCoords = store.columnCoords;
    var widths = columnCoords.widths, areaWidth = columnCoords.areaWidth;
    var totalColumnOffsets = getTotalColumnOffsets(widths, dimension.cellBorderWidth);
    var scrolledPosition = getScrolledPosition(viewInfo, dimension, areaWidth.L);
    return common_1.findOffsetIndex(totalColumnOffsets, scrolledPosition.x);
}
exports.findColumnIndexByPosition = findColumnIndexByPosition;
function findRowIndexByPosition(store, viewInfo) {
    var dimension = store.dimension, columnCoords = store.columnCoords, rowCoords = store.rowCoords;
    var areaWidth = columnCoords.areaWidth;
    var scrolledPosition = getScrolledPosition(viewInfo, dimension, areaWidth.L);
    return common_1.findOffsetIndex(rowCoords.offsets, scrolledPosition.y);
}
exports.findRowIndexByPosition = findRowIndexByPosition;


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ColGroup = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var hoc_1 = __webpack_require__(4);
var dom_1 = __webpack_require__(2);
var ColGroupComp = /** @class */ (function (_super) {
    tslib_1.__extends(ColGroupComp, _super);
    function ColGroupComp() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ColGroupComp.prototype.render = function (_a) {
        var _b;
        var columns = _a.columns, widths = _a.widths, borderWidth = _a.borderWidth;
        var attrs = (_b = {}, _b[dom_1.dataAttr.COLUMN_NAME] = name, _b);
        return (preact_1.h("colgroup", null, columns.map(function (_a, idx) {
            var name = _a.name;
            return (preact_1.h("col", tslib_1.__assign({ key: name }, attrs, { style: { width: widths[idx] + borderWidth } })));
        })));
    };
    return ColGroupComp;
}(preact_1.Component));
exports.ColGroup = hoc_1.connect(function (_a, _b) {
    var _c;
    var columnCoords = _a.columnCoords, viewport = _a.viewport, dimension = _a.dimension, column = _a.column;
    var side = _b.side, useViewport = _b.useViewport;
    return ({
        widths: useViewport && side === 'R'
            ? (_c = columnCoords.widths[side]).slice.apply(_c, viewport.colRange) : columnCoords.widths[side],
        columns: useViewport && side === 'R'
            ? viewport.columns
            : column.visibleColumnsBySideWithRowHeader[side],
        borderWidth: dimension.cellBorderWidth,
    });
})(ColGroupComp);


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.downloadBlob = exports.isSupportMsSaveOrOpenBlob = exports.isMobile = exports.isEdge = void 0;
function isEdge() {
    var rEdge = /Edge\/(\d+)\./;
    return rEdge.exec(window.navigator.userAgent);
}
exports.isEdge = isEdge;
function isMobile() {
    return /Android|BlackBerry|iPhone|iPad|iPod|Opera Mini|IEMobile|WPDesktop/i.test(navigator.userAgent);
}
exports.isMobile = isMobile;
function isSupportMsSaveOrOpenBlob() {
    return !!window.navigator.msSaveOrOpenBlob;
}
exports.isSupportMsSaveOrOpenBlob = isSupportMsSaveOrOpenBlob;
function downloadBlob(blob, format, fileName) {
    var fullFileName = fileName + "." + format;
    if (isSupportMsSaveOrOpenBlob()) {
        window.navigator.msSaveOrOpenBlob(blob, fullFileName);
    }
    else {
        var targetLink = document.createElement('a');
        targetLink.download = fullFileName;
        if (typeof targetLink.download === 'undefined') {
            targetLink.setAttribute('target', '_blank');
        }
        targetLink.href = window.URL.createObjectURL(blob);
        targetLink.click();
    }
}
exports.downloadBlob = downloadBlob;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getText = exports.copyDataToRange = exports.getRangeToPaste = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var data_1 = __webpack_require__(14);
var observable_1 = __webpack_require__(5);
function getCustomValue(customValue, value, rowAttrs, column) {
    return typeof customValue === 'function' ? customValue(value, rowAttrs, column) : customValue;
}
function getTextWithCopyOptionsApplied(valueMap, rawData, column) {
    var text = valueMap.value;
    var copyOptions = column.copyOptions, editor = column.editor;
    var editorOptions = editor && editor.options;
    // priority: customValue > useListItemText > useFormattedValue > original Data
    if (copyOptions) {
        if (copyOptions.customValue) {
            text = getCustomValue(copyOptions.customValue, valueMap.value, rawData, column);
        }
        else if (copyOptions.useListItemText && (editorOptions === null || editorOptions === void 0 ? void 0 : editorOptions.listItems)) {
            var listItems_1 = editorOptions.listItems;
            var value = valueMap.value;
            var valueList = [value];
            var result_1 = [];
            if (typeof value === 'string') {
                valueList = value.split(',');
            }
            valueList.forEach(function (val) {
                var listItem = common_1.find(function (item) { return item.value === val; }, listItems_1);
                result_1.push(listItem ? listItem.text : val);
            });
            text = result_1.join(',');
        }
        else if (copyOptions.useFormattedValue) {
            text = "" + valueMap.formattedValue;
        }
    }
    if (typeof text === 'undefined' || text === null) {
        return '';
    }
    return String(text);
}
function getObservableList(store, filteredViewData, start, end) {
    var rowList = [];
    for (var i = start; i <= end; i += 1) {
        if (!observable_1.isObservable(filteredViewData[i].valueMap)) {
            data_1.makeObservable({ store: store, rowIndex: i, silent: true });
            if (i === end) {
                observable_1.notify(store.data, 'rawData', 'filteredRawData', 'viewData', 'filteredViewData');
            }
        }
        rowList.push(filteredViewData[i]);
    }
    return rowList;
}
function getValuesToString(store, ranges) {
    var visibleColumnsWithRowHeader = store.column.visibleColumnsWithRowHeader, _a = store.data, filteredViewData = _a.filteredViewData, filteredRawData = _a.filteredRawData;
    var rowRange = ranges.rowRange, columnRange = ranges.columnRange;
    if (!rowRange || !columnRange) {
        return '';
    }
    var rowList = getObservableList.apply(void 0, tslib_1.__spreadArrays([store, filteredViewData], rowRange));
    var columnInRange = visibleColumnsWithRowHeader.slice(columnRange[0], columnRange[1] + 1);
    return rowList
        .map(function (_a) {
        var valueMap = _a.valueMap;
        return columnInRange
            .map(function (targetColumn) {
            return getTextWithCopyOptionsApplied(valueMap[targetColumn.name], filteredRawData, targetColumn);
        })
            .join('\t');
    })
        .join('\n');
}
function getRangeToPaste(store, pasteData) {
    var originalRange = store.selection.originalRange, _a = store.focus, totalColumnIndex = _a.totalColumnIndex, originalRowIndex = _a.originalRowIndex, visibleColumnsWithRowHeader = store.column.visibleColumnsWithRowHeader;
    var startRowIndex, startColumnIndex;
    if (originalRange) {
        startRowIndex = originalRange.row[0];
        startColumnIndex = originalRange.column[0];
    }
    else {
        startRowIndex = originalRowIndex;
        startColumnIndex = totalColumnIndex;
    }
    var endRowIndex = pasteData.length + startRowIndex - 1;
    var endColumnIndex = Math.min(pasteData[0].length + startColumnIndex, visibleColumnsWithRowHeader.length) - 1;
    return {
        row: [startRowIndex, endRowIndex],
        column: [startColumnIndex, endColumnIndex],
    };
}
exports.getRangeToPaste = getRangeToPaste;
function copyDataToRange(range, pasteData) {
    var rowLength = range.row[1] - range.row[0] + 1;
    var colLength = range.column[1] - range.column[0] + 1;
    var dataRowLength = pasteData.length;
    var dataColLength = pasteData[0].length;
    var rowDupCount = Math.floor(rowLength / dataRowLength) - 1;
    var colDupCount = Math.floor(colLength / dataColLength) - 1;
    var result = tslib_1.__spreadArrays(pasteData);
    for (var i = 0; i < rowDupCount; i += 1) {
        pasteData.forEach(function (row) {
            result.push(row.slice(0));
        });
    }
    result.forEach(function (row) {
        var rowData = row.slice(0);
        for (var i = 0; i < colDupCount; i += 1) {
            row.push.apply(row, rowData);
        }
    });
    return result;
}
exports.copyDataToRange = copyDataToRange;
function getText(store, ranges) {
    var _a, _b;
    var originalRange = store.selection.originalRange, _c = store.focus, originalRowIndex = _c.originalRowIndex, totalColumnIndex = _c.totalColumnIndex;
    var rowRange = (_a = ranges === null || ranges === void 0 ? void 0 : ranges.rowRange) !== null && _a !== void 0 ? _a : originalRange === null || originalRange === void 0 ? void 0 : originalRange.row;
    var columnRange = (_b = ranges === null || ranges === void 0 ? void 0 : ranges.columnRange) !== null && _b !== void 0 ? _b : originalRange === null || originalRange === void 0 ? void 0 : originalRange.column;
    // set focus index when there is no selection area
    if (common_1.isNil(rowRange) && !common_1.isNull(originalRowIndex)) {
        rowRange = [originalRowIndex, originalRowIndex];
    }
    if (common_1.isNil(columnRange) && !common_1.isNull(totalColumnIndex)) {
        columnRange = [totalColumnIndex, totalColumnIndex];
    }
    return getValuesToString(store, { rowRange: rowRange, columnRange: columnRange });
}
exports.getText = getText;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createAjaxConfig = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
function createAjaxConfig(target) {
    var configKeys = [
        'contentType',
        'withCredentials',
        'mimeType',
        'headers',
        'serializer',
    ];
    return common_1.pick.apply(void 0, tslib_1.__spreadArrays([target], configKeys));
}
exports.createAjaxConfig = createAjaxConfig;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

/*! @license DOMPurify 2.3.9 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.3.9/LICENSE */

(function (global, factory) {
   true ? module.exports = factory() :
  undefined;
})(this, (function () { 'use strict';

  function _typeof(obj) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    }, _typeof(obj);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct;
    } else {
      _construct = function _construct(Parent, args, Class) {
        var a = [null];
        a.push.apply(a, args);
        var Constructor = Function.bind.apply(Parent, a);
        var instance = new Constructor();
        if (Class) _setPrototypeOf(instance, Class.prototype);
        return instance;
      };
    }

    return _construct.apply(null, arguments);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var hasOwnProperty = Object.hasOwnProperty,
      setPrototypeOf = Object.setPrototypeOf,
      isFrozen = Object.isFrozen,
      getPrototypeOf = Object.getPrototypeOf,
      getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
  var freeze = Object.freeze,
      seal = Object.seal,
      create = Object.create; // eslint-disable-line import/no-mutable-exports

  var _ref = typeof Reflect !== 'undefined' && Reflect,
      apply = _ref.apply,
      construct = _ref.construct;

  if (!apply) {
    apply = function apply(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }

  if (!freeze) {
    freeze = function freeze(x) {
      return x;
    };
  }

  if (!seal) {
    seal = function seal(x) {
      return x;
    };
  }

  if (!construct) {
    construct = function construct(Func, args) {
      return _construct(Func, _toConsumableArray(args));
    };
  }

  var arrayForEach = unapply(Array.prototype.forEach);
  var arrayPop = unapply(Array.prototype.pop);
  var arrayPush = unapply(Array.prototype.push);
  var stringToLowerCase = unapply(String.prototype.toLowerCase);
  var stringMatch = unapply(String.prototype.match);
  var stringReplace = unapply(String.prototype.replace);
  var stringIndexOf = unapply(String.prototype.indexOf);
  var stringTrim = unapply(String.prototype.trim);
  var regExpTest = unapply(RegExp.prototype.test);
  var typeErrorCreate = unconstruct(TypeError);
  function unapply(func) {
    return function (thisArg) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return apply(func, thisArg, args);
    };
  }
  function unconstruct(func) {
    return function () {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return construct(func, args);
    };
  }
  /* Add properties to a lookup table */

  function addToSet(set, array, transformCaseFunc) {
    transformCaseFunc = transformCaseFunc ? transformCaseFunc : stringToLowerCase;

    if (setPrototypeOf) {
      // Make 'in' and truthy checks like Boolean(set.constructor)
      // independent of any properties defined on Object.prototype.
      // Prevent prototype setters from intercepting set as a this value.
      setPrototypeOf(set, null);
    }

    var l = array.length;

    while (l--) {
      var element = array[l];

      if (typeof element === 'string') {
        var lcElement = transformCaseFunc(element);

        if (lcElement !== element) {
          // Config presets (e.g. tags.js, attrs.js) are immutable.
          if (!isFrozen(array)) {
            array[l] = lcElement;
          }

          element = lcElement;
        }
      }

      set[element] = true;
    }

    return set;
  }
  /* Shallow clone an object */

  function clone(object) {
    var newObject = create(null);
    var property;

    for (property in object) {
      if (apply(hasOwnProperty, object, [property])) {
        newObject[property] = object[property];
      }
    }

    return newObject;
  }
  /* IE10 doesn't support __lookupGetter__ so lets'
   * simulate it. It also automatically checks
   * if the prop is function or getter and behaves
   * accordingly. */

  function lookupGetter(object, prop) {
    while (object !== null) {
      var desc = getOwnPropertyDescriptor(object, prop);

      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }

        if (typeof desc.value === 'function') {
          return unapply(desc.value);
        }
      }

      object = getPrototypeOf(object);
    }

    function fallbackValue(element) {
      console.warn('fallback value for', element);
      return null;
    }

    return fallbackValue;
  }

  var html$1 = freeze(['a', 'abbr', 'acronym', 'address', 'area', 'article', 'aside', 'audio', 'b', 'bdi', 'bdo', 'big', 'blink', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'content', 'data', 'datalist', 'dd', 'decorator', 'del', 'details', 'dfn', 'dialog', 'dir', 'div', 'dl', 'dt', 'element', 'em', 'fieldset', 'figcaption', 'figure', 'font', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meter', 'nav', 'nobr', 'ol', 'optgroup', 'option', 'output', 'p', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'section', 'select', 'shadow', 'small', 'source', 'spacer', 'span', 'strike', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'track', 'tt', 'u', 'ul', 'var', 'video', 'wbr']); // SVG

  var svg$1 = freeze(['svg', 'a', 'altglyph', 'altglyphdef', 'altglyphitem', 'animatecolor', 'animatemotion', 'animatetransform', 'circle', 'clippath', 'defs', 'desc', 'ellipse', 'filter', 'font', 'g', 'glyph', 'glyphref', 'hkern', 'image', 'line', 'lineargradient', 'marker', 'mask', 'metadata', 'mpath', 'path', 'pattern', 'polygon', 'polyline', 'radialgradient', 'rect', 'stop', 'style', 'switch', 'symbol', 'text', 'textpath', 'title', 'tref', 'tspan', 'view', 'vkern']);
  var svgFilters = freeze(['feBlend', 'feColorMatrix', 'feComponentTransfer', 'feComposite', 'feConvolveMatrix', 'feDiffuseLighting', 'feDisplacementMap', 'feDistantLight', 'feFlood', 'feFuncA', 'feFuncB', 'feFuncG', 'feFuncR', 'feGaussianBlur', 'feImage', 'feMerge', 'feMergeNode', 'feMorphology', 'feOffset', 'fePointLight', 'feSpecularLighting', 'feSpotLight', 'feTile', 'feTurbulence']); // List of SVG elements that are disallowed by default.
  // We still need to know them so that we can do namespace
  // checks properly in case one wants to add them to
  // allow-list.

  var svgDisallowed = freeze(['animate', 'color-profile', 'cursor', 'discard', 'fedropshadow', 'font-face', 'font-face-format', 'font-face-name', 'font-face-src', 'font-face-uri', 'foreignobject', 'hatch', 'hatchpath', 'mesh', 'meshgradient', 'meshpatch', 'meshrow', 'missing-glyph', 'script', 'set', 'solidcolor', 'unknown', 'use']);
  var mathMl$1 = freeze(['math', 'menclose', 'merror', 'mfenced', 'mfrac', 'mglyph', 'mi', 'mlabeledtr', 'mmultiscripts', 'mn', 'mo', 'mover', 'mpadded', 'mphantom', 'mroot', 'mrow', 'ms', 'mspace', 'msqrt', 'mstyle', 'msub', 'msup', 'msubsup', 'mtable', 'mtd', 'mtext', 'mtr', 'munder', 'munderover']); // Similarly to SVG, we want to know all MathML elements,
  // even those that we disallow by default.

  var mathMlDisallowed = freeze(['maction', 'maligngroup', 'malignmark', 'mlongdiv', 'mscarries', 'mscarry', 'msgroup', 'mstack', 'msline', 'msrow', 'semantics', 'annotation', 'annotation-xml', 'mprescripts', 'none']);
  var text = freeze(['#text']);

  var html = freeze(['accept', 'action', 'align', 'alt', 'autocapitalize', 'autocomplete', 'autopictureinpicture', 'autoplay', 'background', 'bgcolor', 'border', 'capture', 'cellpadding', 'cellspacing', 'checked', 'cite', 'class', 'clear', 'color', 'cols', 'colspan', 'controls', 'controlslist', 'coords', 'crossorigin', 'datetime', 'decoding', 'default', 'dir', 'disabled', 'disablepictureinpicture', 'disableremoteplayback', 'download', 'draggable', 'enctype', 'enterkeyhint', 'face', 'for', 'headers', 'height', 'hidden', 'high', 'href', 'hreflang', 'id', 'inputmode', 'integrity', 'ismap', 'kind', 'label', 'lang', 'list', 'loading', 'loop', 'low', 'max', 'maxlength', 'media', 'method', 'min', 'minlength', 'multiple', 'muted', 'name', 'nonce', 'noshade', 'novalidate', 'nowrap', 'open', 'optimum', 'pattern', 'placeholder', 'playsinline', 'poster', 'preload', 'pubdate', 'radiogroup', 'readonly', 'rel', 'required', 'rev', 'reversed', 'role', 'rows', 'rowspan', 'spellcheck', 'scope', 'selected', 'shape', 'size', 'sizes', 'span', 'srclang', 'start', 'src', 'srcset', 'step', 'style', 'summary', 'tabindex', 'title', 'translate', 'type', 'usemap', 'valign', 'value', 'width', 'xmlns', 'slot']);
  var svg = freeze(['accent-height', 'accumulate', 'additive', 'alignment-baseline', 'ascent', 'attributename', 'attributetype', 'azimuth', 'basefrequency', 'baseline-shift', 'begin', 'bias', 'by', 'class', 'clip', 'clippathunits', 'clip-path', 'clip-rule', 'color', 'color-interpolation', 'color-interpolation-filters', 'color-profile', 'color-rendering', 'cx', 'cy', 'd', 'dx', 'dy', 'diffuseconstant', 'direction', 'display', 'divisor', 'dur', 'edgemode', 'elevation', 'end', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'filterunits', 'flood-color', 'flood-opacity', 'font-family', 'font-size', 'font-size-adjust', 'font-stretch', 'font-style', 'font-variant', 'font-weight', 'fx', 'fy', 'g1', 'g2', 'glyph-name', 'glyphref', 'gradientunits', 'gradienttransform', 'height', 'href', 'id', 'image-rendering', 'in', 'in2', 'k', 'k1', 'k2', 'k3', 'k4', 'kerning', 'keypoints', 'keysplines', 'keytimes', 'lang', 'lengthadjust', 'letter-spacing', 'kernelmatrix', 'kernelunitlength', 'lighting-color', 'local', 'marker-end', 'marker-mid', 'marker-start', 'markerheight', 'markerunits', 'markerwidth', 'maskcontentunits', 'maskunits', 'max', 'mask', 'media', 'method', 'mode', 'min', 'name', 'numoctaves', 'offset', 'operator', 'opacity', 'order', 'orient', 'orientation', 'origin', 'overflow', 'paint-order', 'path', 'pathlength', 'patterncontentunits', 'patterntransform', 'patternunits', 'points', 'preservealpha', 'preserveaspectratio', 'primitiveunits', 'r', 'rx', 'ry', 'radius', 'refx', 'refy', 'repeatcount', 'repeatdur', 'restart', 'result', 'rotate', 'scale', 'seed', 'shape-rendering', 'specularconstant', 'specularexponent', 'spreadmethod', 'startoffset', 'stddeviation', 'stitchtiles', 'stop-color', 'stop-opacity', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke', 'stroke-width', 'style', 'surfacescale', 'systemlanguage', 'tabindex', 'targetx', 'targety', 'transform', 'transform-origin', 'text-anchor', 'text-decoration', 'text-rendering', 'textlength', 'type', 'u1', 'u2', 'unicode', 'values', 'viewbox', 'visibility', 'version', 'vert-adv-y', 'vert-origin-x', 'vert-origin-y', 'width', 'word-spacing', 'wrap', 'writing-mode', 'xchannelselector', 'ychannelselector', 'x', 'x1', 'x2', 'xmlns', 'y', 'y1', 'y2', 'z', 'zoomandpan']);
  var mathMl = freeze(['accent', 'accentunder', 'align', 'bevelled', 'close', 'columnsalign', 'columnlines', 'columnspan', 'denomalign', 'depth', 'dir', 'display', 'displaystyle', 'encoding', 'fence', 'frame', 'height', 'href', 'id', 'largeop', 'length', 'linethickness', 'lspace', 'lquote', 'mathbackground', 'mathcolor', 'mathsize', 'mathvariant', 'maxsize', 'minsize', 'movablelimits', 'notation', 'numalign', 'open', 'rowalign', 'rowlines', 'rowspacing', 'rowspan', 'rspace', 'rquote', 'scriptlevel', 'scriptminsize', 'scriptsizemultiplier', 'selection', 'separator', 'separators', 'stretchy', 'subscriptshift', 'supscriptshift', 'symmetric', 'voffset', 'width', 'xmlns']);
  var xml = freeze(['xlink:href', 'xml:id', 'xlink:title', 'xml:space', 'xmlns:xlink']);

  var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm); // Specify template detection regex for SAFE_FOR_TEMPLATES mode

  var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
  var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/); // eslint-disable-line no-useless-escape

  var ARIA_ATTR = seal(/^aria-[\-\w]+$/); // eslint-disable-line no-useless-escape

  var IS_ALLOWED_URI = seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i // eslint-disable-line no-useless-escape
  );
  var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
  var ATTR_WHITESPACE = seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g // eslint-disable-line no-control-regex
  );
  var DOCTYPE_NAME = seal(/^html$/i);

  var getGlobal = function getGlobal() {
    return typeof window === 'undefined' ? null : window;
  };
  /**
   * Creates a no-op policy for internal use only.
   * Don't export this function outside this module!
   * @param {?TrustedTypePolicyFactory} trustedTypes The policy factory.
   * @param {Document} document The document object (to determine policy name suffix)
   * @return {?TrustedTypePolicy} The policy created (or null, if Trusted Types
   * are not supported).
   */


  var _createTrustedTypesPolicy = function _createTrustedTypesPolicy(trustedTypes, document) {
    if (_typeof(trustedTypes) !== 'object' || typeof trustedTypes.createPolicy !== 'function') {
      return null;
    } // Allow the callers to control the unique policy name
    // by adding a data-tt-policy-suffix to the script element with the DOMPurify.
    // Policy creation with duplicate names throws in Trusted Types.


    var suffix = null;
    var ATTR_NAME = 'data-tt-policy-suffix';

    if (document.currentScript && document.currentScript.hasAttribute(ATTR_NAME)) {
      suffix = document.currentScript.getAttribute(ATTR_NAME);
    }

    var policyName = 'dompurify' + (suffix ? '#' + suffix : '');

    try {
      return trustedTypes.createPolicy(policyName, {
        createHTML: function createHTML(html) {
          return html;
        }
      });
    } catch (_) {
      // Policy creation failed (most likely another DOMPurify script has
      // already run). Skip creating the policy, as this will only cause errors
      // if TT are enforced.
      console.warn('TrustedTypes policy ' + policyName + ' could not be created.');
      return null;
    }
  };

  function createDOMPurify() {
    var window = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : getGlobal();

    var DOMPurify = function DOMPurify(root) {
      return createDOMPurify(root);
    };
    /**
     * Version label, exposed for easier checks
     * if DOMPurify is up to date or not
     */


    DOMPurify.version = '2.3.9';
    /**
     * Array of elements that DOMPurify removed during sanitation.
     * Empty if nothing was removed.
     */

    DOMPurify.removed = [];

    if (!window || !window.document || window.document.nodeType !== 9) {
      // Not running in a browser, provide a factory function
      // so that you can pass your own Window
      DOMPurify.isSupported = false;
      return DOMPurify;
    }

    var originalDocument = window.document;
    var document = window.document;
    var DocumentFragment = window.DocumentFragment,
        HTMLTemplateElement = window.HTMLTemplateElement,
        Node = window.Node,
        Element = window.Element,
        NodeFilter = window.NodeFilter,
        _window$NamedNodeMap = window.NamedNodeMap,
        NamedNodeMap = _window$NamedNodeMap === void 0 ? window.NamedNodeMap || window.MozNamedAttrMap : _window$NamedNodeMap,
        HTMLFormElement = window.HTMLFormElement,
        DOMParser = window.DOMParser,
        trustedTypes = window.trustedTypes;
    var ElementPrototype = Element.prototype;
    var cloneNode = lookupGetter(ElementPrototype, 'cloneNode');
    var getNextSibling = lookupGetter(ElementPrototype, 'nextSibling');
    var getChildNodes = lookupGetter(ElementPrototype, 'childNodes');
    var getParentNode = lookupGetter(ElementPrototype, 'parentNode'); // As per issue #47, the web-components registry is inherited by a
    // new document created via createHTMLDocument. As per the spec
    // (http://w3c.github.io/webcomponents/spec/custom/#creating-and-passing-registries)
    // a new empty registry is used when creating a template contents owner
    // document, so we use that as our parent document to ensure nothing
    // is inherited.

    if (typeof HTMLTemplateElement === 'function') {
      var template = document.createElement('template');

      if (template.content && template.content.ownerDocument) {
        document = template.content.ownerDocument;
      }
    }

    var trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, originalDocument);

    var emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML('') : '';
    var _document = document,
        implementation = _document.implementation,
        createNodeIterator = _document.createNodeIterator,
        createDocumentFragment = _document.createDocumentFragment,
        getElementsByTagName = _document.getElementsByTagName;
    var importNode = originalDocument.importNode;
    var documentMode = {};

    try {
      documentMode = clone(document).documentMode ? document.documentMode : {};
    } catch (_) {}

    var hooks = {};
    /**
     * Expose whether this browser supports running the full DOMPurify.
     */

    DOMPurify.isSupported = typeof getParentNode === 'function' && implementation && typeof implementation.createHTMLDocument !== 'undefined' && documentMode !== 9;
    var MUSTACHE_EXPR$1 = MUSTACHE_EXPR,
        ERB_EXPR$1 = ERB_EXPR,
        DATA_ATTR$1 = DATA_ATTR,
        ARIA_ATTR$1 = ARIA_ATTR,
        IS_SCRIPT_OR_DATA$1 = IS_SCRIPT_OR_DATA,
        ATTR_WHITESPACE$1 = ATTR_WHITESPACE;
    var IS_ALLOWED_URI$1 = IS_ALLOWED_URI;
    /**
     * We consider the elements and attributes below to be safe. Ideally
     * don't add any new ones but feel free to remove unwanted ones.
     */

    /* allowed element names */

    var ALLOWED_TAGS = null;
    var DEFAULT_ALLOWED_TAGS = addToSet({}, [].concat(_toConsumableArray(html$1), _toConsumableArray(svg$1), _toConsumableArray(svgFilters), _toConsumableArray(mathMl$1), _toConsumableArray(text)));
    /* Allowed attribute names */

    var ALLOWED_ATTR = null;
    var DEFAULT_ALLOWED_ATTR = addToSet({}, [].concat(_toConsumableArray(html), _toConsumableArray(svg), _toConsumableArray(mathMl), _toConsumableArray(xml)));
    /*
     * Configure how DOMPUrify should handle custom elements and their attributes as well as customized built-in elements.
     * @property {RegExp|Function|null} tagNameCheck one of [null, regexPattern, predicate]. Default: `null` (disallow any custom elements)
     * @property {RegExp|Function|null} attributeNameCheck one of [null, regexPattern, predicate]. Default: `null` (disallow any attributes not on the allow list)
     * @property {boolean} allowCustomizedBuiltInElements allow custom elements derived from built-ins if they pass CUSTOM_ELEMENT_HANDLING.tagNameCheck. Default: `false`.
     */

    var CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
      tagNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      attributeNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      allowCustomizedBuiltInElements: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: false
      }
    }));
    /* Explicitly forbidden tags (overrides ALLOWED_TAGS/ADD_TAGS) */

    var FORBID_TAGS = null;
    /* Explicitly forbidden attributes (overrides ALLOWED_ATTR/ADD_ATTR) */

    var FORBID_ATTR = null;
    /* Decide if ARIA attributes are okay */

    var ALLOW_ARIA_ATTR = true;
    /* Decide if custom data attributes are okay */

    var ALLOW_DATA_ATTR = true;
    /* Decide if unknown protocols are okay */

    var ALLOW_UNKNOWN_PROTOCOLS = false;
    /* Output should be safe for common template engines.
     * This means, DOMPurify removes data attributes, mustaches and ERB
     */

    var SAFE_FOR_TEMPLATES = false;
    /* Decide if document with <html>... should be returned */

    var WHOLE_DOCUMENT = false;
    /* Track whether config is already set on this instance of DOMPurify. */

    var SET_CONFIG = false;
    /* Decide if all elements (e.g. style, script) must be children of
     * document.body. By default, browsers might move them to document.head */

    var FORCE_BODY = false;
    /* Decide if a DOM `HTMLBodyElement` should be returned, instead of a html
     * string (or a TrustedHTML object if Trusted Types are supported).
     * If `WHOLE_DOCUMENT` is enabled a `HTMLHtmlElement` will be returned instead
     */

    var RETURN_DOM = false;
    /* Decide if a DOM `DocumentFragment` should be returned, instead of a html
     * string  (or a TrustedHTML object if Trusted Types are supported) */

    var RETURN_DOM_FRAGMENT = false;
    /* Try to return a Trusted Type object instead of a string, return a string in
     * case Trusted Types are not supported  */

    var RETURN_TRUSTED_TYPE = false;
    /* Output should be free from DOM clobbering attacks? */

    var SANITIZE_DOM = true;
    /* Keep element content when removing element? */

    var KEEP_CONTENT = true;
    /* If a `Node` is passed to sanitize(), then performs sanitization in-place instead
     * of importing it into a new Document and returning a sanitized copy */

    var IN_PLACE = false;
    /* Allow usage of profiles like html, svg and mathMl */

    var USE_PROFILES = {};
    /* Tags to ignore content of when KEEP_CONTENT is true */

    var FORBID_CONTENTS = null;
    var DEFAULT_FORBID_CONTENTS = addToSet({}, ['annotation-xml', 'audio', 'colgroup', 'desc', 'foreignobject', 'head', 'iframe', 'math', 'mi', 'mn', 'mo', 'ms', 'mtext', 'noembed', 'noframes', 'noscript', 'plaintext', 'script', 'style', 'svg', 'template', 'thead', 'title', 'video', 'xmp']);
    /* Tags that are safe for data: URIs */

    var DATA_URI_TAGS = null;
    var DEFAULT_DATA_URI_TAGS = addToSet({}, ['audio', 'video', 'img', 'source', 'image', 'track']);
    /* Attributes safe for values like "javascript:" */

    var URI_SAFE_ATTRIBUTES = null;
    var DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ['alt', 'class', 'for', 'id', 'label', 'name', 'pattern', 'placeholder', 'role', 'summary', 'title', 'value', 'style', 'xmlns']);
    var MATHML_NAMESPACE = 'http://www.w3.org/1998/Math/MathML';
    var SVG_NAMESPACE = 'http://www.w3.org/2000/svg';
    var HTML_NAMESPACE = 'http://www.w3.org/1999/xhtml';
    /* Document namespace */

    var NAMESPACE = HTML_NAMESPACE;
    var IS_EMPTY_INPUT = false;
    /* Parsing of strict XHTML documents */

    var PARSER_MEDIA_TYPE;
    var SUPPORTED_PARSER_MEDIA_TYPES = ['application/xhtml+xml', 'text/html'];
    var DEFAULT_PARSER_MEDIA_TYPE = 'text/html';
    var transformCaseFunc;
    /* Keep a reference to config to pass to hooks */

    var CONFIG = null;
    /* Ideally, do not touch anything below this line */

    /* ______________________________________________ */

    var formElement = document.createElement('form');

    var isRegexOrFunction = function isRegexOrFunction(testValue) {
      return testValue instanceof RegExp || testValue instanceof Function;
    };
    /**
     * _parseConfig
     *
     * @param  {Object} cfg optional config literal
     */
    // eslint-disable-next-line complexity


    var _parseConfig = function _parseConfig(cfg) {
      if (CONFIG && CONFIG === cfg) {
        return;
      }
      /* Shield configuration object from tampering */


      if (!cfg || _typeof(cfg) !== 'object') {
        cfg = {};
      }
      /* Shield configuration object from prototype pollution */


      cfg = clone(cfg);
      PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
      SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE; // HTML tags and attributes are not case-sensitive, converting to lowercase. Keeping XHTML as is.

      transformCaseFunc = PARSER_MEDIA_TYPE === 'application/xhtml+xml' ? function (x) {
        return x;
      } : stringToLowerCase;
      /* Set configuration parameters */

      ALLOWED_TAGS = 'ALLOWED_TAGS' in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
      ALLOWED_ATTR = 'ALLOWED_ATTR' in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
      URI_SAFE_ATTRIBUTES = 'ADD_URI_SAFE_ATTR' in cfg ? addToSet(clone(DEFAULT_URI_SAFE_ATTRIBUTES), // eslint-disable-line indent
      cfg.ADD_URI_SAFE_ATTR, // eslint-disable-line indent
      transformCaseFunc // eslint-disable-line indent
      ) // eslint-disable-line indent
      : DEFAULT_URI_SAFE_ATTRIBUTES;
      DATA_URI_TAGS = 'ADD_DATA_URI_TAGS' in cfg ? addToSet(clone(DEFAULT_DATA_URI_TAGS), // eslint-disable-line indent
      cfg.ADD_DATA_URI_TAGS, // eslint-disable-line indent
      transformCaseFunc // eslint-disable-line indent
      ) // eslint-disable-line indent
      : DEFAULT_DATA_URI_TAGS;
      FORBID_CONTENTS = 'FORBID_CONTENTS' in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
      FORBID_TAGS = 'FORBID_TAGS' in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
      FORBID_ATTR = 'FORBID_ATTR' in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
      USE_PROFILES = 'USE_PROFILES' in cfg ? cfg.USE_PROFILES : false;
      ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false; // Default true

      ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false; // Default true

      ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false; // Default false

      SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false; // Default false

      WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false; // Default false

      RETURN_DOM = cfg.RETURN_DOM || false; // Default false

      RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false; // Default false

      RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false; // Default false

      FORCE_BODY = cfg.FORCE_BODY || false; // Default false

      SANITIZE_DOM = cfg.SANITIZE_DOM !== false; // Default true

      KEEP_CONTENT = cfg.KEEP_CONTENT !== false; // Default true

      IN_PLACE = cfg.IN_PLACE || false; // Default false

      IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI$1;
      NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;

      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
      }

      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
      }

      if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === 'boolean') {
        CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
      }

      if (SAFE_FOR_TEMPLATES) {
        ALLOW_DATA_ATTR = false;
      }

      if (RETURN_DOM_FRAGMENT) {
        RETURN_DOM = true;
      }
      /* Parse profile info */


      if (USE_PROFILES) {
        ALLOWED_TAGS = addToSet({}, _toConsumableArray(text));
        ALLOWED_ATTR = [];

        if (USE_PROFILES.html === true) {
          addToSet(ALLOWED_TAGS, html$1);
          addToSet(ALLOWED_ATTR, html);
        }

        if (USE_PROFILES.svg === true) {
          addToSet(ALLOWED_TAGS, svg$1);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }

        if (USE_PROFILES.svgFilters === true) {
          addToSet(ALLOWED_TAGS, svgFilters);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }

        if (USE_PROFILES.mathMl === true) {
          addToSet(ALLOWED_TAGS, mathMl$1);
          addToSet(ALLOWED_ATTR, mathMl);
          addToSet(ALLOWED_ATTR, xml);
        }
      }
      /* Merge configuration parameters */


      if (cfg.ADD_TAGS) {
        if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
          ALLOWED_TAGS = clone(ALLOWED_TAGS);
        }

        addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
      }

      if (cfg.ADD_ATTR) {
        if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
          ALLOWED_ATTR = clone(ALLOWED_ATTR);
        }

        addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
      }

      if (cfg.ADD_URI_SAFE_ATTR) {
        addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
      }

      if (cfg.FORBID_CONTENTS) {
        if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
          FORBID_CONTENTS = clone(FORBID_CONTENTS);
        }

        addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
      }
      /* Add #text in case KEEP_CONTENT is set to true */


      if (KEEP_CONTENT) {
        ALLOWED_TAGS['#text'] = true;
      }
      /* Add html, head and body to ALLOWED_TAGS in case WHOLE_DOCUMENT is true */


      if (WHOLE_DOCUMENT) {
        addToSet(ALLOWED_TAGS, ['html', 'head', 'body']);
      }
      /* Add tbody to ALLOWED_TAGS in case tables are permitted, see #286, #365 */


      if (ALLOWED_TAGS.table) {
        addToSet(ALLOWED_TAGS, ['tbody']);
        delete FORBID_TAGS.tbody;
      } // Prevent further manipulation of configuration.
      // Not available in IE8, Safari 5, etc.


      if (freeze) {
        freeze(cfg);
      }

      CONFIG = cfg;
    };

    var MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ['mi', 'mo', 'mn', 'ms', 'mtext']);
    var HTML_INTEGRATION_POINTS = addToSet({}, ['foreignobject', 'desc', 'title', 'annotation-xml']); // Certain elements are allowed in both SVG and HTML
    // namespace. We need to specify them explicitly
    // so that they don't get erroneously deleted from
    // HTML namespace.

    var COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ['title', 'style', 'font', 'a', 'script']);
    /* Keep track of all possible SVG and MathML tags
     * so that we can perform the namespace checks
     * correctly. */

    var ALL_SVG_TAGS = addToSet({}, svg$1);
    addToSet(ALL_SVG_TAGS, svgFilters);
    addToSet(ALL_SVG_TAGS, svgDisallowed);
    var ALL_MATHML_TAGS = addToSet({}, mathMl$1);
    addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
    /**
     *
     *
     * @param  {Element} element a DOM element whose namespace is being checked
     * @returns {boolean} Return false if the element has a
     *  namespace that a spec-compliant parser would never
     *  return. Return true otherwise.
     */

    var _checkValidNamespace = function _checkValidNamespace(element) {
      var parent = getParentNode(element); // In JSDOM, if we're inside shadow DOM, then parentNode
      // can be null. We just simulate parent in this case.

      if (!parent || !parent.tagName) {
        parent = {
          namespaceURI: HTML_NAMESPACE,
          tagName: 'template'
        };
      }

      var tagName = stringToLowerCase(element.tagName);
      var parentTagName = stringToLowerCase(parent.tagName);

      if (element.namespaceURI === SVG_NAMESPACE) {
        // The only way to switch from HTML namespace to SVG
        // is via <svg>. If it happens via any other tag, then
        // it should be killed.
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === 'svg';
        } // The only way to switch from MathML to SVG is via
        // svg if parent is either <annotation-xml> or MathML
        // text integration points.


        if (parent.namespaceURI === MATHML_NAMESPACE) {
          return tagName === 'svg' && (parentTagName === 'annotation-xml' || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
        } // We only allow elements that are defined in SVG
        // spec. All others are disallowed in SVG namespace.


        return Boolean(ALL_SVG_TAGS[tagName]);
      }

      if (element.namespaceURI === MATHML_NAMESPACE) {
        // The only way to switch from HTML namespace to MathML
        // is via <math>. If it happens via any other tag, then
        // it should be killed.
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === 'math';
        } // The only way to switch from SVG to MathML is via
        // <math> and HTML integration points


        if (parent.namespaceURI === SVG_NAMESPACE) {
          return tagName === 'math' && HTML_INTEGRATION_POINTS[parentTagName];
        } // We only allow elements that are defined in MathML
        // spec. All others are disallowed in MathML namespace.


        return Boolean(ALL_MATHML_TAGS[tagName]);
      }

      if (element.namespaceURI === HTML_NAMESPACE) {
        // The only way to switch from SVG to HTML is via
        // HTML integration points, and from MathML to HTML
        // is via MathML text integration points
        if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }

        if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
          return false;
        } // We disallow tags that are specific for MathML
        // or SVG and should never appear in HTML namespace


        return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
      } // The code should never reach this place (this means
      // that the element somehow got namespace that is not
      // HTML, SVG or MathML). Return false just in case.


      return false;
    };
    /**
     * _forceRemove
     *
     * @param  {Node} node a DOM node
     */


    var _forceRemove = function _forceRemove(node) {
      arrayPush(DOMPurify.removed, {
        element: node
      });

      try {
        // eslint-disable-next-line unicorn/prefer-dom-node-remove
        node.parentNode.removeChild(node);
      } catch (_) {
        try {
          node.outerHTML = emptyHTML;
        } catch (_) {
          node.remove();
        }
      }
    };
    /**
     * _removeAttribute
     *
     * @param  {String} name an Attribute name
     * @param  {Node} node a DOM node
     */


    var _removeAttribute = function _removeAttribute(name, node) {
      try {
        arrayPush(DOMPurify.removed, {
          attribute: node.getAttributeNode(name),
          from: node
        });
      } catch (_) {
        arrayPush(DOMPurify.removed, {
          attribute: null,
          from: node
        });
      }

      node.removeAttribute(name); // We void attribute values for unremovable "is"" attributes

      if (name === 'is' && !ALLOWED_ATTR[name]) {
        if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
          try {
            _forceRemove(node);
          } catch (_) {}
        } else {
          try {
            node.setAttribute(name, '');
          } catch (_) {}
        }
      }
    };
    /**
     * _initDocument
     *
     * @param  {String} dirty a string of dirty markup
     * @return {Document} a DOM, filled with the dirty markup
     */


    var _initDocument = function _initDocument(dirty) {
      /* Create a HTML document */
      var doc;
      var leadingWhitespace;

      if (FORCE_BODY) {
        dirty = '<remove></remove>' + dirty;
      } else {
        /* If FORCE_BODY isn't used, leading whitespace needs to be preserved manually */
        var matches = stringMatch(dirty, /^[\r\n\t ]+/);
        leadingWhitespace = matches && matches[0];
      }

      if (PARSER_MEDIA_TYPE === 'application/xhtml+xml') {
        // Root of XHTML doc must contain xmlns declaration (see https://www.w3.org/TR/xhtml1/normative.html#strict)
        dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + '</body></html>';
      }

      var dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
      /*
       * Use the DOMParser API by default, fallback later if needs be
       * DOMParser not work for svg when has multiple root element.
       */

      if (NAMESPACE === HTML_NAMESPACE) {
        try {
          doc = new DOMParser().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
        } catch (_) {}
      }
      /* Use createHTMLDocument in case DOMParser is not available */


      if (!doc || !doc.documentElement) {
        doc = implementation.createDocument(NAMESPACE, 'template', null);

        try {
          doc.documentElement.innerHTML = IS_EMPTY_INPUT ? '' : dirtyPayload;
        } catch (_) {// Syntax error if dirtyPayload is invalid xml
        }
      }

      var body = doc.body || doc.documentElement;

      if (dirty && leadingWhitespace) {
        body.insertBefore(document.createTextNode(leadingWhitespace), body.childNodes[0] || null);
      }
      /* Work on whole document or just its body */


      if (NAMESPACE === HTML_NAMESPACE) {
        return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? 'html' : 'body')[0];
      }

      return WHOLE_DOCUMENT ? doc.documentElement : body;
    };
    /**
     * _createIterator
     *
     * @param  {Document} root document/fragment to create iterator for
     * @return {Iterator} iterator instance
     */


    var _createIterator = function _createIterator(root) {
      return createNodeIterator.call(root.ownerDocument || root, root, // eslint-disable-next-line no-bitwise
      NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT, null, false);
    };
    /**
     * _isClobbered
     *
     * @param  {Node} elm element to check for clobbering attacks
     * @return {Boolean} true if clobbered, false if safe
     */


    var _isClobbered = function _isClobbered(elm) {
      return elm instanceof HTMLFormElement && (typeof elm.nodeName !== 'string' || typeof elm.textContent !== 'string' || typeof elm.removeChild !== 'function' || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== 'function' || typeof elm.setAttribute !== 'function' || typeof elm.namespaceURI !== 'string' || typeof elm.insertBefore !== 'function');
    };
    /**
     * _isNode
     *
     * @param  {Node} obj object to check whether it's a DOM node
     * @return {Boolean} true is object is a DOM node
     */


    var _isNode = function _isNode(object) {
      return _typeof(Node) === 'object' ? object instanceof Node : object && _typeof(object) === 'object' && typeof object.nodeType === 'number' && typeof object.nodeName === 'string';
    };
    /**
     * _executeHook
     * Execute user configurable hooks
     *
     * @param  {String} entryPoint  Name of the hook's entry point
     * @param  {Node} currentNode node to work on with the hook
     * @param  {Object} data additional hook parameters
     */


    var _executeHook = function _executeHook(entryPoint, currentNode, data) {
      if (!hooks[entryPoint]) {
        return;
      }

      arrayForEach(hooks[entryPoint], function (hook) {
        hook.call(DOMPurify, currentNode, data, CONFIG);
      });
    };
    /**
     * _sanitizeElements
     *
     * @protect nodeName
     * @protect textContent
     * @protect removeChild
     *
     * @param   {Node} currentNode to check for permission to exist
     * @return  {Boolean} true if node was killed, false if left alive
     */


    var _sanitizeElements = function _sanitizeElements(currentNode) {
      var content;
      /* Execute a hook if present */

      _executeHook('beforeSanitizeElements', currentNode, null);
      /* Check if element is clobbered or can clobber */


      if (_isClobbered(currentNode)) {
        _forceRemove(currentNode);

        return true;
      }
      /* Check if tagname contains Unicode */


      if (regExpTest(/[\u0080-\uFFFF]/, currentNode.nodeName)) {
        _forceRemove(currentNode);

        return true;
      }
      /* Now let's check the element's type and name */


      var tagName = transformCaseFunc(currentNode.nodeName);
      /* Execute a hook if present */

      _executeHook('uponSanitizeElement', currentNode, {
        tagName: tagName,
        allowedTags: ALLOWED_TAGS
      });
      /* Detect mXSS attempts abusing namespace confusion */


      if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
        _forceRemove(currentNode);

        return true;
      }
      /* Mitigate a problem with templates inside select */


      if (tagName === 'select' && regExpTest(/<template/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);

        return true;
      }
      /* Remove element if anything forbids its presence */


      if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
        /* Check if we have a custom element to handle */
        if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) return false;
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) return false;
        }
        /* Keep content except for bad-listed elements */


        if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
          var parentNode = getParentNode(currentNode) || currentNode.parentNode;
          var childNodes = getChildNodes(currentNode) || currentNode.childNodes;

          if (childNodes && parentNode) {
            var childCount = childNodes.length;

            for (var i = childCount - 1; i >= 0; --i) {
              parentNode.insertBefore(cloneNode(childNodes[i], true), getNextSibling(currentNode));
            }
          }
        }

        _forceRemove(currentNode);

        return true;
      }
      /* Check whether element has a valid namespace */


      if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
        _forceRemove(currentNode);

        return true;
      }

      if ((tagName === 'noscript' || tagName === 'noembed') && regExpTest(/<\/no(script|embed)/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);

        return true;
      }
      /* Sanitize element content to be template-safe */


      if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
        /* Get the element's text content */
        content = currentNode.textContent;
        content = stringReplace(content, MUSTACHE_EXPR$1, ' ');
        content = stringReplace(content, ERB_EXPR$1, ' ');

        if (currentNode.textContent !== content) {
          arrayPush(DOMPurify.removed, {
            element: currentNode.cloneNode()
          });
          currentNode.textContent = content;
        }
      }
      /* Execute a hook if present */


      _executeHook('afterSanitizeElements', currentNode, null);

      return false;
    };
    /**
     * _isValidAttribute
     *
     * @param  {string} lcTag Lowercase tag name of containing element.
     * @param  {string} lcName Lowercase attribute name.
     * @param  {string} value Attribute value.
     * @return {Boolean} Returns true if `value` is valid, otherwise false.
     */
    // eslint-disable-next-line complexity


    var _isValidAttribute = function _isValidAttribute(lcTag, lcName, value) {
      /* Make sure attribute cannot clobber */
      if (SANITIZE_DOM && (lcName === 'id' || lcName === 'name') && (value in document || value in formElement)) {
        return false;
      }
      /* Allow valid data-* attributes: At least one character after "-"
          (https://html.spec.whatwg.org/multipage/dom.html#embedding-custom-non-visible-data-with-the-data-*-attributes)
          XML-compatible (https://html.spec.whatwg.org/multipage/infrastructure.html#xml-compatible and http://www.w3.org/TR/xml/#d0e804)
          We don't need to check the value; it's always URI safe. */


      if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR$1, lcName)) ; else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR$1, lcName)) ; else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
        if ( // First condition does a very basic check if a) it's basically a valid custom element tagname AND
        // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
        _basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
        // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        lcName === 'is' && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value))) ; else {
          return false;
        }
        /* Check value is safe. First, is attr inert? If so, is safe */

      } else if (URI_SAFE_ATTRIBUTES[lcName]) ; else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE$1, ''))) ; else if ((lcName === 'src' || lcName === 'xlink:href' || lcName === 'href') && lcTag !== 'script' && stringIndexOf(value, 'data:') === 0 && DATA_URI_TAGS[lcTag]) ; else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA$1, stringReplace(value, ATTR_WHITESPACE$1, ''))) ; else if (!value) ; else {
        return false;
      }

      return true;
    };
    /**
     * _basicCustomElementCheck
     * checks if at least one dash is included in tagName, and it's not the first char
     * for more sophisticated checking see https://github.com/sindresorhus/validate-element-name
     * @param {string} tagName name of the tag of the node to sanitize
     */


    var _basicCustomElementTest = function _basicCustomElementTest(tagName) {
      return tagName.indexOf('-') > 0;
    };
    /**
     * _sanitizeAttributes
     *
     * @protect attributes
     * @protect nodeName
     * @protect removeAttribute
     * @protect setAttribute
     *
     * @param  {Node} currentNode to sanitize
     */


    var _sanitizeAttributes = function _sanitizeAttributes(currentNode) {
      var attr;
      var value;
      var lcName;
      var l;
      /* Execute a hook if present */

      _executeHook('beforeSanitizeAttributes', currentNode, null);

      var attributes = currentNode.attributes;
      /* Check if we have attributes; if not we might have a text node */

      if (!attributes) {
        return;
      }

      var hookEvent = {
        attrName: '',
        attrValue: '',
        keepAttr: true,
        allowedAttributes: ALLOWED_ATTR
      };
      l = attributes.length;
      /* Go backwards over all attributes; safely remove bad ones */

      while (l--) {
        attr = attributes[l];
        var _attr = attr,
            name = _attr.name,
            namespaceURI = _attr.namespaceURI;
        value = name === 'value' ? attr.value : stringTrim(attr.value);
        lcName = transformCaseFunc(name);
        /* Execute a hook if present */

        hookEvent.attrName = lcName;
        hookEvent.attrValue = value;
        hookEvent.keepAttr = true;
        hookEvent.forceKeepAttr = undefined; // Allows developers to see this is a property they can set

        _executeHook('uponSanitizeAttribute', currentNode, hookEvent);

        value = hookEvent.attrValue;
        /* Did the hooks approve of the attribute? */

        if (hookEvent.forceKeepAttr) {
          continue;
        }
        /* Remove attribute */


        _removeAttribute(name, currentNode);
        /* Did the hooks approve of the attribute? */


        if (!hookEvent.keepAttr) {
          continue;
        }
        /* Work around a security issue in jQuery 3.0 */


        if (regExpTest(/\/>/i, value)) {
          _removeAttribute(name, currentNode);

          continue;
        }
        /* Sanitize attribute content to be template-safe */


        if (SAFE_FOR_TEMPLATES) {
          value = stringReplace(value, MUSTACHE_EXPR$1, ' ');
          value = stringReplace(value, ERB_EXPR$1, ' ');
        }
        /* Is `value` valid for this attribute? */


        var lcTag = transformCaseFunc(currentNode.nodeName);

        if (!_isValidAttribute(lcTag, lcName, value)) {
          continue;
        }
        /* Handle invalid data-* attribute set by try-catching it */


        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name, value);
          } else {
            /* Fallback to setAttribute() for browser-unrecognized namespaces e.g. "x-schema". */
            currentNode.setAttribute(name, value);
          }

          arrayPop(DOMPurify.removed);
        } catch (_) {}
      }
      /* Execute a hook if present */


      _executeHook('afterSanitizeAttributes', currentNode, null);
    };
    /**
     * _sanitizeShadowDOM
     *
     * @param  {DocumentFragment} fragment to iterate over recursively
     */


    var _sanitizeShadowDOM = function _sanitizeShadowDOM(fragment) {
      var shadowNode;

      var shadowIterator = _createIterator(fragment);
      /* Execute a hook if present */


      _executeHook('beforeSanitizeShadowDOM', fragment, null);

      while (shadowNode = shadowIterator.nextNode()) {
        /* Execute a hook if present */
        _executeHook('uponSanitizeShadowNode', shadowNode, null);
        /* Sanitize tags and elements */


        if (_sanitizeElements(shadowNode)) {
          continue;
        }
        /* Deep shadow DOM detected */


        if (shadowNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(shadowNode.content);
        }
        /* Check attributes, sanitize if necessary */


        _sanitizeAttributes(shadowNode);
      }
      /* Execute a hook if present */


      _executeHook('afterSanitizeShadowDOM', fragment, null);
    };
    /**
     * Sanitize
     * Public method providing core sanitation functionality
     *
     * @param {String|Node} dirty string or DOM node
     * @param {Object} configuration object
     */
    // eslint-disable-next-line complexity


    DOMPurify.sanitize = function (dirty, cfg) {
      var body;
      var importedNode;
      var currentNode;
      var oldNode;
      var returnNode;
      /* Make sure we have a string to sanitize.
        DO NOT return early, as this will return the wrong type if
        the user has requested a DOM object rather than a string */

      IS_EMPTY_INPUT = !dirty;

      if (IS_EMPTY_INPUT) {
        dirty = '<!-->';
      }
      /* Stringify, in case dirty is an object */


      if (typeof dirty !== 'string' && !_isNode(dirty)) {
        // eslint-disable-next-line no-negated-condition
        if (typeof dirty.toString !== 'function') {
          throw typeErrorCreate('toString is not a function');
        } else {
          dirty = dirty.toString();

          if (typeof dirty !== 'string') {
            throw typeErrorCreate('dirty is not a string, aborting');
          }
        }
      }
      /* Check we can run. Otherwise fall back or ignore */


      if (!DOMPurify.isSupported) {
        if (_typeof(window.toStaticHTML) === 'object' || typeof window.toStaticHTML === 'function') {
          if (typeof dirty === 'string') {
            return window.toStaticHTML(dirty);
          }

          if (_isNode(dirty)) {
            return window.toStaticHTML(dirty.outerHTML);
          }
        }

        return dirty;
      }
      /* Assign config vars */


      if (!SET_CONFIG) {
        _parseConfig(cfg);
      }
      /* Clean up removed elements */


      DOMPurify.removed = [];
      /* Check if dirty is correctly typed for IN_PLACE */

      if (typeof dirty === 'string') {
        IN_PLACE = false;
      }

      if (IN_PLACE) {
        /* Do some early pre-sanitization to avoid unsafe root nodes */
        if (dirty.nodeName) {
          var tagName = transformCaseFunc(dirty.nodeName);

          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            throw typeErrorCreate('root node is forbidden and cannot be sanitized in-place');
          }
        }
      } else if (dirty instanceof Node) {
        /* If dirty is a DOM element, append to an empty document to avoid
           elements being stripped by the parser */
        body = _initDocument('<!---->');
        importedNode = body.ownerDocument.importNode(dirty, true);

        if (importedNode.nodeType === 1 && importedNode.nodeName === 'BODY') {
          /* Node is already a body, use as is */
          body = importedNode;
        } else if (importedNode.nodeName === 'HTML') {
          body = importedNode;
        } else {
          // eslint-disable-next-line unicorn/prefer-dom-node-append
          body.appendChild(importedNode);
        }
      } else {
        /* Exit directly if we have nothing to do */
        if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
        dirty.indexOf('<') === -1) {
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
        }
        /* Initialize the document to work on */


        body = _initDocument(dirty);
        /* Check we have a DOM node from the data */

        if (!body) {
          return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : '';
        }
      }
      /* Remove first element node (ours) if FORCE_BODY is set */


      if (body && FORCE_BODY) {
        _forceRemove(body.firstChild);
      }
      /* Get node iterator */


      var nodeIterator = _createIterator(IN_PLACE ? dirty : body);
      /* Now start iterating over the created document */


      while (currentNode = nodeIterator.nextNode()) {
        /* Fix IE's strange behavior with manipulated textNodes #89 */
        if (currentNode.nodeType === 3 && currentNode === oldNode) {
          continue;
        }
        /* Sanitize tags and elements */


        if (_sanitizeElements(currentNode)) {
          continue;
        }
        /* Shadow DOM detected, sanitize it */


        if (currentNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(currentNode.content);
        }
        /* Check attributes, sanitize if necessary */


        _sanitizeAttributes(currentNode);

        oldNode = currentNode;
      }

      oldNode = null;
      /* If we sanitized `dirty` in-place, return it. */

      if (IN_PLACE) {
        return dirty;
      }
      /* Return sanitized string or DOM */


      if (RETURN_DOM) {
        if (RETURN_DOM_FRAGMENT) {
          returnNode = createDocumentFragment.call(body.ownerDocument);

          while (body.firstChild) {
            // eslint-disable-next-line unicorn/prefer-dom-node-append
            returnNode.appendChild(body.firstChild);
          }
        } else {
          returnNode = body;
        }

        if (ALLOWED_ATTR.shadowroot) {
          /*
            AdoptNode() is not used because internal state is not reset
            (e.g. the past names map of a HTMLFormElement), this is safe
            in theory but we would rather not risk another attack vector.
            The state that is cloned by importNode() is explicitly defined
            by the specs.
          */
          returnNode = importNode.call(originalDocument, returnNode, true);
        }

        return returnNode;
      }

      var serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
      /* Serialize doctype if allowed */

      if (WHOLE_DOCUMENT && ALLOWED_TAGS['!doctype'] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
        serializedHTML = '<!DOCTYPE ' + body.ownerDocument.doctype.name + '>\n' + serializedHTML;
      }
      /* Sanitize final string template-safe */


      if (SAFE_FOR_TEMPLATES) {
        serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR$1, ' ');
        serializedHTML = stringReplace(serializedHTML, ERB_EXPR$1, ' ');
      }

      return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
    };
    /**
     * Public method to set the configuration once
     * setConfig
     *
     * @param {Object} cfg configuration object
     */


    DOMPurify.setConfig = function (cfg) {
      _parseConfig(cfg);

      SET_CONFIG = true;
    };
    /**
     * Public method to remove the configuration
     * clearConfig
     *
     */


    DOMPurify.clearConfig = function () {
      CONFIG = null;
      SET_CONFIG = false;
    };
    /**
     * Public method to check if an attribute value is valid.
     * Uses last set config, if any. Otherwise, uses config defaults.
     * isValidAttribute
     *
     * @param  {string} tag Tag name of containing element.
     * @param  {string} attr Attribute name.
     * @param  {string} value Attribute value.
     * @return {Boolean} Returns true if `value` is valid. Otherwise, returns false.
     */


    DOMPurify.isValidAttribute = function (tag, attr, value) {
      /* Initialize shared config vars if necessary. */
      if (!CONFIG) {
        _parseConfig({});
      }

      var lcTag = transformCaseFunc(tag);
      var lcName = transformCaseFunc(attr);
      return _isValidAttribute(lcTag, lcName, value);
    };
    /**
     * AddHook
     * Public method to add DOMPurify hooks
     *
     * @param {String} entryPoint entry point for the hook to add
     * @param {Function} hookFunction function to execute
     */


    DOMPurify.addHook = function (entryPoint, hookFunction) {
      if (typeof hookFunction !== 'function') {
        return;
      }

      hooks[entryPoint] = hooks[entryPoint] || [];
      arrayPush(hooks[entryPoint], hookFunction);
    };
    /**
     * RemoveHook
     * Public method to remove a DOMPurify hook at a given entryPoint
     * (pops it from the stack of hooks if more are present)
     *
     * @param {String} entryPoint entry point for the hook to remove
     * @return {Function} removed(popped) hook
     */


    DOMPurify.removeHook = function (entryPoint) {
      if (hooks[entryPoint]) {
        return arrayPop(hooks[entryPoint]);
      }
    };
    /**
     * RemoveHooks
     * Public method to remove all DOMPurify hooks at a given entryPoint
     *
     * @param  {String} entryPoint entry point for the hooks to remove
     */


    DOMPurify.removeHooks = function (entryPoint) {
      if (hooks[entryPoint]) {
        hooks[entryPoint] = [];
      }
    };
    /**
     * RemoveAllHooks
     * Public method to remove all DOMPurify hooks
     *
     */


    DOMPurify.removeAllHooks = function () {
      hooks = {};
    };

    return DOMPurify;
  }

  var purify = createDOMPurify();

  return purify;

}));
//# sourceMappingURL=purify.js.map


/***/ }),
/* 44 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE__44__;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isEditingCell = exports.isFocusedCell = void 0;
function isFocusedCell(focus, rowKey, columnName) {
    return rowKey === focus.rowKey && columnName === focus.columnName;
}
exports.isFocusedCell = isFocusedCell;
function isEditingCell(focus, rowKey, columnName) {
    var editingAddress = focus.editingAddress;
    return !!(editingAddress &&
        editingAddress.rowKey === rowKey &&
        editingAddress.columnName === columnName);
}
exports.isEditingCell = isEditingCell;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createSortEvent = exports.isCancelSort = void 0;
var tslib_1 = __webpack_require__(1);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var common_1 = __webpack_require__(0);
function isCancelSort(_a, columnName, ascending, cancelable) {
    var data = _a.data, column = _a.column;
    var index = common_1.findPropIndex('columnName', columnName, data.sortState.columns);
    var defaultAscending = column.allColumnMap[columnName].sortingType === 'asc';
    return cancelable && ascending === defaultAscending && index !== -1;
}
exports.isCancelSort = isCancelSort;
function createSortEvent(eventType, eventParams) {
    var columnName = eventParams.columnName, multiple = eventParams.multiple, ascending = eventParams.ascending;
    var sortState = common_1.deepCopy(eventParams.sortState);
    var props = {};
    /* eslint-disable no-fallthrough */
    switch (eventType) {
        /**
         * Occurs before sorting.
         * @event Grid#beforeSort
         * @property {Object} sortState - Current sort state
         * @property {string} columnName - Target column name
         * @property {boolean} ascending - Next ascending state of a column.
         * If the event is not stopped this ascending state will be applied to grid.
         * @property {boolean} multiple - Whether to use multiple sort
         * @property {Grid} instance - Current grid instance
         */
        case 'beforeSort':
            props = {
                sortState: sortState,
                columnName: columnName,
                ascending: ascending,
                multiple: multiple,
            };
            break;
        /**
         * Occurs before unsorting.
         * @event Grid#beforeUnsort
         * @property {Object} sortState - Current sort state of the grid
         * @property {string} columnName - Target column name
         * @property {boolean} multiple - Whether to use multiple sort
         * @property {Grid} instance - Current grid instance
         */
        case 'beforeUnsort':
            props = {
                sortState: sortState,
                columnName: columnName,
                multiple: multiple,
            };
            break;
        /**
         * Occurs after sorting.
         * @deprecated
         * @event Grid#sort
         * @property {Object} sortState - sort state
         * @property {string} columnName - Target column name
         * @property {Grid} instance - Current grid instance
         */
        case 'sort':
        /**
         * Occurs after sorting.
         * @event Grid#afterSort
         * @property {Object} sortState - sort state
         * @property {string} columnName - Target column name
         * @property {Grid} instance - Current grid instance
         */
        case 'afterSort':
        /**
         * Occurs after unsorting.
         * @event Grid#afterUnsort
         * @property {Object} sortState - sort state
         * @property {string} columnName - Target column name
         * @property {Grid} instance - Current grid instance
         */
        case 'afterUnsort':
            props = {
                sortState: sortState,
                columnName: columnName,
            };
            break;
        default: // do nothing
    }
    /* eslint-disable no-fallthrough */
    return new gridEvent_1.default(props);
}
exports.createSortEvent = createSortEvent;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.extractSummaryColumnContent = exports.castToSummaryColumnContent = exports.calculate = exports.getSummaryValue = void 0;
var tslib_1 = __webpack_require__(1);
function assignFilteredSummaryValue(summaryValue) {
    var sum = summaryValue.sum, min = summaryValue.min, max = summaryValue.max, avg = summaryValue.avg, cnt = summaryValue.cnt;
    return {
        filtered: {
            sum: sum,
            min: min,
            max: max,
            avg: avg,
            cnt: cnt,
        },
    };
}
function getSummaryValue(columnName, rawData, filteredRawData) {
    var columnValues = rawData.map(function (row) { return row[columnName]; });
    var summaryValue = calculate(columnValues);
    if (rawData.length === filteredRawData.length) {
        return tslib_1.__assign(tslib_1.__assign({}, summaryValue), assignFilteredSummaryValue(summaryValue));
    }
    var filteredColumnValues = filteredRawData.map(function (row) { return row[columnName]; });
    return tslib_1.__assign(tslib_1.__assign({}, summaryValue), assignFilteredSummaryValue(calculate(filteredColumnValues)));
}
exports.getSummaryValue = getSummaryValue;
function calculate(values) {
    var cnt = values.length;
    var min = Number.MAX_VALUE;
    var max = Number.MIN_VALUE;
    var sum = 0;
    var avg = 0;
    for (var i = 0; i < cnt; i += 1) {
        var value = Number(values[i]);
        if (isNaN(value)) {
            value = 0;
        }
        sum += value;
        if (min > value) {
            min = value;
        }
        if (max < value) {
            max = value;
        }
    }
    if (!cnt) {
        max = min = avg = 0;
    }
    else {
        avg = sum / cnt;
    }
    return { sum: sum, min: min, max: max, avg: avg, cnt: cnt };
}
exports.calculate = calculate;
function castToSummaryColumnContent(content) {
    if (!content) {
        return null;
    }
    return typeof content === 'string'
        ? { template: content, useAutoSummary: false }
        : {
            template: content.template,
            useAutoSummary: typeof content.useAutoSummary === 'undefined' ? true : content.useAutoSummary,
        };
}
exports.castToSummaryColumnContent = castToSummaryColumnContent;
function extractSummaryColumnContent(content, defaultContent) {
    var summaryColumnContent = null;
    if (content) {
        summaryColumnContent = content;
    }
    else if (!content && defaultContent) {
        summaryColumnContent = defaultContent;
    }
    return summaryColumnContent;
}
exports.extractSummaryColumnContent = extractSummaryColumnContent;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.createSummaryValue = void 0;
var observable_1 = __webpack_require__(5);
var summary_1 = __webpack_require__(47);
var common_1 = __webpack_require__(0);
function createSummaryValue(content, columnName, data) {
    if (content && content.useAutoSummary) {
        return summary_1.getSummaryValue(columnName, data.rawData, data.filteredRawData);
    }
    return {
        sum: 0,
        min: 0,
        max: 0,
        avg: 0,
        cnt: 0,
        filtered: {
            sum: 0,
            min: 0,
            max: 0,
            avg: 0,
            cnt: 0,
        },
    };
}
exports.createSummaryValue = createSummaryValue;
function create(_a) {
    var column = _a.column, data = _a.data, summary = _a.summary;
    var summaryColumnContents = {};
    var summaryValues = {};
    var orgColumnContent = summary.columnContent, defaultContent = summary.defaultContent;
    if (Object.keys(summary).length) {
        var castedDefaultContent_1 = summary_1.castToSummaryColumnContent(defaultContent || '');
        var columnContent_1 = orgColumnContent || {};
        var summaryColumns = Object.keys(columnContent_1);
        var filteredSummaryColumns = summaryColumns.filter(function (columnName) { return !common_1.someProp('name', columnName, column.allColumns); });
        var targetColumns = castedDefaultContent_1
            ? column.allColumns.map(function (_a) {
                var name = _a.name;
                return name;
            }).concat(filteredSummaryColumns)
            : summaryColumns;
        targetColumns.forEach(function (columnName) {
            var castedColumnContent = summary_1.castToSummaryColumnContent(columnContent_1[columnName]);
            var content = summary_1.extractSummaryColumnContent(castedColumnContent, castedDefaultContent_1);
            summaryColumnContents[columnName] = content;
            summaryValues[columnName] = createSummaryValue(content, columnName, data);
        });
    }
    return observable_1.observable({ summaryColumnContents: summaryColumnContents, summaryValues: summaryValues, defaultContent: defaultContent });
}
exports.create = create;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createFilterEvent = exports.getFilterState = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
function getFilterState(store) {
    var filters = store.data.filters;
    if (filters) {
        common_1.deepCopyArray(filters);
    }
    return filters;
}
exports.getFilterState = getFilterState;
function createFilterEvent(_a, eventType, eventParams) {
    var data = _a.data;
    var columnName = eventParams.columnName, type = eventParams.type, conditionFn = eventParams.conditionFn, state = eventParams.state, operator = eventParams.operator;
    var filterState = data.filters ? common_1.deepCopyArray(data.filters) : null;
    var props = {};
    /* eslint-disable no-fallthrough */
    switch (eventType) {
        /**
         * Occurs before filtering.
         * @event Grid#beforeFilter
         * @property {Grid} instance - Current grid instance
         * @property {Object} filterState - Current filter state
         * @property {string} columnName - Target column name
         * @property {string} type - Column Filter type
         * @property {string} operator - Column filter Operator('AND' | 'OR')
         * @property {function} conditionFn - Original function to filter the data in grid.
         * @property {Array} columnFilterState - Next filter state of column which triggers the event.
         * If the event is not stopped this state will be applied to grid.
         */
        case 'beforeFilter':
            props = {
                filterState: filterState,
                columnFilterState: common_1.deepCopyArray(state),
                conditionFn: conditionFn,
                type: type,
                columnName: columnName,
                operator: operator,
            };
            break;
        /**
         * Occurs before unfiltering
         * @event Grid#beforeUnfilter
         * @property {Grid} instance - Current grid instance
         * @property {string} columnName - Target column name
         * @property {Object} filterState - Current filter state
         */
        case 'beforeUnfilter':
        /**
         * Occurs after filtering
         * @deprecated
         * @event Grid#filter
         * @property {Grid} instance - Current grid instance
         * @property {string} columnName - Target column name
         * @property {Object} filterState - Current filter state
         */
        case 'filter':
        /**
         * Occurs after filtering
         * @event Grid#afterFilter
         * @property {Grid} instance - Current grid instance
         * @property {string} columnName - Target column name
         * @property {Object} filterState - Current filter state
         */
        case 'afterFilter':
        /**
         * Occurs after unfiltering
         * @event Grid#afterUnfilter
         * @property {Grid} instance - Current grid instance
         * @property {string} columnName - Target column name
         * @property {Object} filterState - Current filter state
         */
        case 'afterUnfilter':
            props = {
                filterState: filterState,
                columnName: columnName,
            };
            break;
        default: // do nothing
    }
    /* eslint-disable no-fallthrough */
    return new gridEvent_1.default(props);
}
exports.createFilterEvent = createFilterEvent;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.fitRowHeightWhenMovingRow = exports.refreshRowHeight = exports.removeRowHeight = exports.setCellHeight = exports.setHoveredRowKeyByPosition = exports.setHoveredRowKey = void 0;
var tslib_1 = __webpack_require__(1);
var observable_1 = __webpack_require__(5);
var mouse_1 = __webpack_require__(38);
var common_1 = __webpack_require__(0);
function setHoveredRowKey(_a, rowKey) {
    var renderState = _a.renderState;
    renderState.hoveredRowKey = rowKey;
}
exports.setHoveredRowKey = setHoveredRowKey;
function setHoveredRowKeyByPosition(store, viewInfo) {
    var renderState = store.renderState, data = store.data, viewport = store.viewport;
    var scrollLeft = viewport.scrollLeft, scrollTop = viewport.scrollTop;
    var rowIndex = mouse_1.findRowIndexByPosition(store, tslib_1.__assign(tslib_1.__assign({}, viewInfo), { scrollLeft: scrollLeft, scrollTop: scrollTop }));
    var rowKey = data.filteredRawData[rowIndex].rowKey;
    if (renderState.hoveredRowKey !== rowKey) {
        setHoveredRowKey(store, rowKey);
    }
}
exports.setHoveredRowKeyByPosition = setHoveredRowKeyByPosition;
function setCellHeight(_a, columnName, rowIndex, height, defaultRowHeight) {
    var renderState = _a.renderState;
    var cellHeightMap = renderState.cellHeightMap;
    if (!cellHeightMap[rowIndex]) {
        cellHeightMap[rowIndex] = {};
    }
    cellHeightMap[rowIndex][columnName] = Math.max(height, defaultRowHeight);
}
exports.setCellHeight = setCellHeight;
function removeRowHeight(_a, rowIndex) {
    var renderState = _a.renderState;
    var cellHeightMap = renderState.cellHeightMap;
    delete cellHeightMap[rowIndex];
}
exports.removeRowHeight = removeRowHeight;
function refreshRowHeight(store, rowIndex, rowHeight) {
    var data = store.data, rowCoords = store.rowCoords, renderState = store.renderState;
    var cellHeightMap = renderState.cellHeightMap;
    var cellHeights = cellHeightMap[rowIndex];
    if (common_1.isUndefined(cellHeights)) {
        return;
    }
    var highestHeight = Object.keys(cellHeights).reduce(function (acc, columnName) { return Math.max(acc, cellHeights[columnName]); }, -1);
    if (rowHeight !== highestHeight) {
        data.rawData[rowIndex]._attributes.height = highestHeight;
        rowCoords.heights[rowIndex] = highestHeight;
        observable_1.notify(rowCoords, 'heights');
    }
}
exports.refreshRowHeight = refreshRowHeight;
function fitRowHeightWhenMovingRow(store, currentIndex, targetIndex) {
    var rowCoords = store.rowCoords, renderState = store.renderState;
    var cellHeightMap = renderState.cellHeightMap;
    if (Object.keys(cellHeightMap).length === 0) {
        return;
    }
    var direction = targetIndex > currentIndex ? 1 : -1;
    var _loop_1 = function (i) {
        var target = i + direction;
        var temp = cellHeightMap[i];
        cellHeightMap[i] = cellHeightMap[target];
        cellHeightMap[target] = temp;
        var highestHeight = Object.keys(cellHeightMap[i]).reduce(function (acc, columnName) { return Math.max(acc, cellHeightMap[i][columnName]); }, -1);
        var targetHighestHeight = Object.keys(cellHeightMap[target]).reduce(function (acc, columnName) { return Math.max(acc, cellHeightMap[target][columnName]); }, -1);
        if (highestHeight !== targetHighestHeight) {
            rowCoords.heights[i] = highestHeight;
            rowCoords.heights[target] = targetHighestHeight;
        }
    };
    for (var i = currentIndex; i !== targetIndex; i += direction) {
        _loop_1(i);
    }
    observable_1.notify(rowCoords, 'heights');
}
exports.fitRowHeightWhenMovingRow = fitRowHeightWhenMovingRow;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.setAutoBodyHeight = exports.refreshLayout = exports.setHeaderHeight = exports.setOffsetLeft = exports.setOffsetTop = exports.setBodyHeight = exports.setHeight = exports.setWidth = void 0;
function setWidth(_a, width, autoWidth) {
    var dimension = _a.dimension;
    dimension.autoWidth = autoWidth;
    dimension.width = width;
}
exports.setWidth = setWidth;
function setHeight(_a, height) {
    var dimension = _a.dimension;
    var headerHeight = dimension.headerHeight, summaryHeight = dimension.summaryHeight, tableBorderWidth = dimension.tableBorderWidth;
    dimension.bodyHeight = height - headerHeight - summaryHeight - tableBorderWidth;
}
exports.setHeight = setHeight;
function setBodyHeight(_a, bodyHeight) {
    var dimension = _a.dimension;
    dimension.autoHeight = false;
    dimension.bodyHeight = Math.max(bodyHeight, dimension.minBodyHeight);
}
exports.setBodyHeight = setBodyHeight;
function setOffsetTop(store, offsetTop) {
    store.dimension.offsetTop = offsetTop;
}
exports.setOffsetTop = setOffsetTop;
function setOffsetLeft(store, offsetLeft) {
    store.dimension.offsetLeft = offsetLeft;
}
exports.setOffsetLeft = setOffsetLeft;
function setHeaderHeight(store, height) {
    store.dimension.headerHeight = height;
}
exports.setHeaderHeight = setHeaderHeight;
function refreshLayout(store, containerEl, parentEl) {
    var dimension = store.dimension;
    var autoWidth = dimension.autoWidth, fitToParentHeight = dimension.fitToParentHeight;
    var clientHeight = containerEl.clientHeight, clientWidth = containerEl.clientWidth, scrollTop = containerEl.scrollTop, scrollLeft = containerEl.scrollLeft;
    var _a = containerEl.getBoundingClientRect(), top = _a.top, left = _a.left;
    setOffsetTop(store, top + scrollTop);
    setOffsetLeft(store, left + scrollLeft);
    setWidth(store, clientWidth, autoWidth);
    if (fitToParentHeight && parentEl && parentEl.clientHeight !== clientHeight) {
        var _b = getComputedStyle(parentEl), paddingTop = _b.paddingTop, paddingBottom = _b.paddingBottom;
        setHeight(store, parentEl.clientHeight - (parseFloat(paddingTop) + parseFloat(paddingBottom)));
    }
}
exports.refreshLayout = refreshLayout;
function setAutoBodyHeight(_a) {
    var dimension = _a.dimension, rowCoords = _a.rowCoords;
    var totalRowHeight = rowCoords.totalRowHeight;
    var autoHeight = dimension.autoHeight, scrollXHeight = dimension.scrollXHeight, minBodyHeight = dimension.minBodyHeight;
    if (autoHeight) {
        dimension.bodyHeight = Math.max(totalRowHeight + scrollXHeight, minBodyHeight);
    }
}
exports.setAutoBodyHeight = setAutoBodyHeight;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderArea = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var colGroup_1 = __webpack_require__(39);
var dom_1 = __webpack_require__(2);
var hoc_1 = __webpack_require__(4);
var columnResizer_1 = __webpack_require__(93);
var instance_1 = __webpack_require__(9);
var column_1 = __webpack_require__(12);
var complexHeader_1 = __webpack_require__(94);
var columnHeader_1 = __webpack_require__(53);
var constant_1 = __webpack_require__(8);
var draggable_1 = __webpack_require__(54);
var common_1 = __webpack_require__(0);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var eventBus_1 = __webpack_require__(7);
var DRAGGING_CLASS = 'dragging';
var HeaderAreaComp = /** @class */ (function (_super) {
    tslib_1.__extends(HeaderAreaComp, _super);
    function HeaderAreaComp() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.container = null;
        _this.dragColumnInfo = null;
        _this.floatingColumnWidth = null;
        _this.startSelectedName = null;
        _this.offsetLeft = null;
        _this.movedIndexInfo = null;
        _this.handleDblClick = function (ev) {
            ev.stopPropagation();
        };
        _this.handleMouseMove = function (ev) {
            var store = _this.context.store;
            _this.offsetLeft = ev.offsetX;
            var posInfo = _this.getPosInfo(ev, _this.el);
            var pageX = posInfo.pageX, pageY = posInfo.pageY, scrollTop = posInfo.scrollTop, top = posInfo.top;
            var currentColumnName = draggable_1.getMovedPosAndIndexOfColumn(store, posInfo, _this.offsetLeft).targetColumn.name;
            if (currentColumnName === _this.startSelectedName &&
                column_1.isDraggableColumn(store, currentColumnName) &&
                common_1.findOffsetIndex(store.rowCoords.offsets, pageY - top + scrollTop) > 0) {
                _this.startToDragColumn(posInfo);
                return;
            }
            _this.props.dispatch('dragMoveHeader', { pageX: pageX, pageY: pageY }, _this.startSelectedName);
        };
        _this.handleMouseDown = function (ev) {
            var _a = _this.props, dispatch = _a.dispatch, complexColumnHeaders = _a.complexColumnHeaders;
            var target = ev.target;
            if (dom_1.findParentByClassName(target, 'cell-row-header') ||
                dom_1.hasClass(target, 'btn-sorting') ||
                dom_1.hasClass(target, 'btn-filter') ||
                ev.button === constant_1.RIGHT_MOUSE_BUTTON) {
                return;
            }
            var name = target.getAttribute('data-column-name');
            if (!name) {
                var parent = dom_1.findParentByClassName(target, 'cell-header');
                if (parent) {
                    name = parent.getAttribute('data-column-name');
                }
            }
            var parentHeader = column_1.isParentColumnHeader(complexColumnHeaders, name);
            _this.startSelectedName = name;
            dispatch('mouseDownHeader', name, parentHeader);
            document.addEventListener('mousemove', _this.handleMouseMove);
            document.addEventListener('mouseup', _this.clearDocumentEvents);
            document.addEventListener('selectstart', _this.handleSelectStart);
        };
        _this.clearDocumentEvents = function () {
            _this.props.dispatch('dragEnd');
            dom_1.setCursorStyle('');
            document.removeEventListener('mousemove', _this.handleMouseMove);
            document.removeEventListener('mouseup', _this.clearDocumentEvents);
            document.removeEventListener('selectstart', _this.handleSelectStart);
        };
        _this.handleSelectStart = function (ev) {
            ev.preventDefault();
        };
        _this.startToDragColumn = function (posInfo) {
            var _a, _b;
            var dispatch = _this.props.dispatch;
            _this.container = (_b = (_a = _this.el) === null || _a === void 0 ? void 0 : _a.parentElement) === null || _b === void 0 ? void 0 : _b.parentElement;
            posInfo.container = _this.container;
            var draggableInfo = draggable_1.createDraggableColumnInfo(_this.context.store, posInfo);
            var column = draggableInfo.column, columnName = draggableInfo.columnName;
            var gridEvent = new gridEvent_1.default({ columnName: columnName, floatingColumn: column });
            /**
             * Occurs when starting to drag the column
             * @event Grid#dragStart
             * @property {Grid} instance - Current grid instance
             * @property {string} columnName - The column name of the column to drag
             * @property {HTMLElement} floatingColumn - The floating column DOM element
             */
            _this.props.eventBus.trigger('dragStart', gridEvent);
            if (!gridEvent.isStopped()) {
                _this.container.appendChild(column);
                _this.floatingColumnWidth = column.clientWidth;
                _this.dragColumnInfo = draggableInfo;
                dispatch('addColumnClassName', columnName, DRAGGING_CLASS);
                dispatch('setFocusInfo', null, null, false);
                dispatch('initSelection');
                document.removeEventListener('mousemove', _this.handleMouseMove);
                document.addEventListener('mousemove', _this.dragColumn);
                document.addEventListener('mouseup', _this.dropColumn);
            }
        };
        _this.dragColumn = function (ev) {
            var posInfo = _this.getPosInfo(ev, _this.el);
            var _a = draggable_1.getMovedPosAndIndexOfColumn(_this.context.store, posInfo, _this.offsetLeft, _this.floatingColumnWidth), index = _a.index, offsetLeft = _a.offsetLeft, targetColumn = _a.targetColumn;
            var _b = _this.dragColumnInfo, column = _b.column, columnName = _b.columnName;
            column.style.left = offsetLeft + "px";
            _this.movedIndexInfo = { index: index, columnName: targetColumn.name };
            _this.props.dispatch('moveColumn', columnName, index);
            var gridEvent = new gridEvent_1.default({
                columnName: columnName,
                targetColumnName: targetColumn.name,
            });
            /**
             * Occurs when dragging the column
             * @event Grid#drag
             * @property {Grid} instance - Current grid instance
             * @property {string} columnName - The column name of the dragging column
             * @property {string} targetColumnName - The column name of the column at current dragging position
             */
            _this.props.eventBus.trigger('drag', gridEvent);
        };
        _this.dropColumn = function () {
            var columnName = _this.dragColumnInfo.columnName;
            if (_this.movedIndexInfo) {
                var _a = _this.movedIndexInfo, index = _a.index, targetColumnName = _a.columnName;
                var gridEvent = new gridEvent_1.default({
                    columnName: columnName,
                    targetColumnName: targetColumnName,
                });
                /**
                 * Occurs when dropping the column
                 * @event Grid#drop
                 * @property {Grid} instance - Current grid instance
                 * @property {string} columnName - The column name of the dragging column
                 * @property {string} targetColumnName - The column name of the column at current dragging position
                 */
                _this.props.eventBus.trigger('drop', gridEvent);
                if (!gridEvent.isStopped()) {
                    _this.props.dispatch('moveColumn', columnName, index);
                }
            }
            _this.props.dispatch('removeColumnClassName', _this.dragColumnInfo.columnName, DRAGGING_CLASS);
            _this.clearDraggableInfo();
        };
        _this.clearDraggableInfo = function () {
            _this.container.removeChild(_this.dragColumnInfo.column);
            _this.dragColumnInfo = null;
            _this.container = null;
            _this.floatingColumnWidth = null;
            _this.offsetLeft = null;
            _this.movedIndexInfo = null;
            document.removeEventListener('mousemove', _this.dragColumn);
            document.removeEventListener('mouseup', _this.dropColumn);
        };
        return _this;
    }
    HeaderAreaComp.prototype.getPosInfo = function (ev, el) {
        var _a = dom_1.getCoordinateWithOffset(ev.pageX, ev.pageY), pageX = _a[0], pageY = _a[1];
        var scrollTop = el.scrollTop, scrollLeft = el.scrollLeft;
        var _b = el.getBoundingClientRect(), top = _b.top, left = _b.left;
        return { pageX: pageX, pageY: pageY, left: left, top: top, scrollLeft: scrollLeft, scrollTop: scrollTop };
    };
    HeaderAreaComp.prototype.isSelected = function (index) {
        var columnSelectionRange = this.props.columnSelectionRange;
        if (!columnSelectionRange) {
            return false;
        }
        var start = columnSelectionRange[0], end = columnSelectionRange[1];
        return index >= start && index <= end;
    };
    HeaderAreaComp.prototype.componentDidUpdate = function () {
        this.el.scrollLeft = this.props.scrollLeft;
    };
    HeaderAreaComp.prototype.render = function () {
        var _this = this;
        var _a = this.props, columns = _a.columns, headerHeight = _a.headerHeight, side = _a.side, complexColumnHeaders = _a.complexColumnHeaders, grid = _a.grid;
        var headerHeightStyle = { height: headerHeight };
        return (preact_1.h("div", { class: dom_1.cls('header-area'), style: headerHeightStyle, ref: function (el) {
                _this.el = el;
            } },
            preact_1.h("table", { class: dom_1.cls('table'), onMouseDown: this.handleMouseDown },
                preact_1.h(colGroup_1.ColGroup, { side: side, useViewport: false }),
                complexColumnHeaders.length ? (preact_1.h(complexHeader_1.ComplexHeader, { side: side, grid: grid })) : (preact_1.h("tbody", null,
                    preact_1.h("tr", { style: headerHeightStyle, onDblClick: this.handleDblClick }, columns.map(function (columnInfo, index) { return (preact_1.h(columnHeader_1.ColumnHeader, { key: columnInfo.name, columnInfo: columnInfo, selected: _this.isSelected(index), grid: grid })); }))))),
            preact_1.h(columnResizer_1.ColumnResizer, { side: side })));
    };
    return HeaderAreaComp;
}(preact_1.Component));
exports.HeaderArea = hoc_1.connect(function (store, _a) {
    var side = _a.side;
    var _b = store.column, visibleColumnsBySideWithRowHeader = _b.visibleColumnsBySideWithRowHeader, complexColumnHeaders = _b.complexColumnHeaders, _c = store.dimension, headerHeight = _c.headerHeight, cellBorderWidth = _c.cellBorderWidth, rangeBySide = store.selection.rangeBySide, viewport = store.viewport, id = store.id;
    return {
        headerHeight: headerHeight,
        cellBorderWidth: cellBorderWidth,
        columns: visibleColumnsBySideWithRowHeader[side],
        scrollLeft: side === 'L' ? 0 : viewport.scrollLeft,
        grid: instance_1.getInstance(id),
        columnSelectionRange: rangeBySide && rangeBySide[side].column ? rangeBySide[side].column : null,
        complexColumnHeaders: complexColumnHeaders,
        eventBus: eventBus_1.getEventBus(id),
    };
})(HeaderAreaComp);


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ColumnHeader = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var dom_1 = __webpack_require__(2);
var headerCheckbox_1 = __webpack_require__(95);
var sortingButton_1 = __webpack_require__(96);
var sortingOrder_1 = __webpack_require__(97);
var filterButton_1 = __webpack_require__(98);
var column_1 = __webpack_require__(11);
var common_1 = __webpack_require__(0);
var column_2 = __webpack_require__(12);
var ColumnHeader = /** @class */ (function (_super) {
    tslib_1.__extends(ColumnHeader, _super);
    function ColumnHeader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ColumnHeader.prototype.getElement = function (type) {
        var columnInfo = this.props.columnInfo;
        var name = columnInfo.name, sortable = columnInfo.sortable, sortingType = columnInfo.sortingType, filter = columnInfo.filter, headerRenderer = columnInfo.headerRenderer, header = columnInfo.header, customHeader = columnInfo.customHeader;
        if (headerRenderer) {
            return null;
        }
        switch (type) {
            case 'checkbox': {
                if (column_1.isCheckboxColumn(name)) {
                    return preact_1.h(headerCheckbox_1.HeaderCheckbox, null);
                }
                if (this.el && customHeader) {
                    this.el.appendChild(customHeader);
                    return null;
                }
                return header;
            }
            case 'sortingBtn':
                return sortable && preact_1.h(sortingButton_1.SortingButton, { columnName: name, sortingType: sortingType });
            case 'sortingOrder':
                return sortable && preact_1.h(sortingOrder_1.SortingOrder, { columnName: name });
            case 'filter':
                return filter && preact_1.h(filterButton_1.FilterButton, { columnName: name });
            default:
                return null;
        }
    };
    ColumnHeader.prototype.componentDidMount = function () {
        var _a = this.props, columnInfo = _a.columnInfo, grid = _a.grid;
        var headerRenderer = columnInfo.headerRenderer;
        if (!headerRenderer || !this.el) {
            return;
        }
        var HeaderRendererClass = headerRenderer;
        var renderer = new HeaderRendererClass({ grid: grid, columnInfo: columnInfo });
        var rendererEl = renderer.getElement();
        this.el.appendChild(rendererEl);
        this.renderer = renderer;
        if (common_1.isFunction(renderer.mounted)) {
            renderer.mounted(this.el);
        }
    };
    ColumnHeader.prototype.componentWillReceiveProps = function (nextProps) {
        if (this.renderer) {
            this.renderer.render({ columnInfo: nextProps.columnInfo, grid: nextProps.grid });
        }
    };
    ColumnHeader.prototype.componentWillUnmount = function () {
        if (this.renderer && common_1.isFunction(this.renderer.beforeDestroy)) {
            this.renderer.beforeDestroy();
        }
    };
    ColumnHeader.prototype.render = function () {
        var _this = this;
        var _a = this.props, columnInfo = _a.columnInfo, colspan = _a.colspan, rowspan = _a.rowspan, selected = _a.selected, _b = _a.height, height = _b === void 0 ? null : _b;
        var name = columnInfo.name, textAlign = columnInfo.headerAlign, verticalAlign = columnInfo.headerVAlign, headerRenderer = columnInfo.headerRenderer;
        return (preact_1.h("th", tslib_1.__assign({ ref: function (el) {
                _this.el = el;
            }, "data-column-name": name, style: { textAlign: textAlign, verticalAlign: verticalAlign, padding: headerRenderer ? 0 : null, height: height }, class: dom_1.cls('cell', 'cell-header', [!column_1.isRowHeader(name) && selected, 'cell-selected'], [column_1.isRowHeader(name), 'cell-row-header'], [column_2.isDraggableColumn(this.context.store, name) && !column_1.isRowHeader(name), 'header-draggable']) }, (!!colspan && { colspan: colspan }), (!!rowspan && { rowspan: rowspan })), ['checkbox', 'sortingBtn', 'sortingOrder', 'filter'].map(function (type) { return _this.getElement(type); })));
    };
    return ColumnHeader;
}(preact_1.Component));
exports.ColumnHeader = ColumnHeader;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getResolvedOffsets = exports.createFloatingLine = exports.getMovedPosAndIndexOfColumn = exports.getMovedPosAndIndexOfRow = exports.createDraggableColumnInfo = exports.createDraggableRowInfo = exports.createCells = void 0;
var common_1 = __webpack_require__(0);
var dom_1 = __webpack_require__(2);
var data_1 = __webpack_require__(6);
var mouse_1 = __webpack_require__(38);
var EXCEED_RATIO = 0.8;
var ADDITIONAL_HEIGHT = 10;
function createRow(height) {
    var row = document.createElement('div');
    row.className = dom_1.cls('floating-row');
    row.style.height = height;
    row.style.lineHeight = height;
    row.style.width = 'auto';
    return row;
}
function createColumn(height, width) {
    var column = document.createElement('div');
    column.className = dom_1.cls('floating-column');
    column.style.width = width + "px";
    column.style.lineHeight = height + "px";
    return column;
}
function createCells(cell) {
    var childLen = cell.childNodes.length;
    var el = document.createElement('div');
    el.className = dom_1.cls('floating-cell', 'cell-header');
    el.style.width = window.getComputedStyle(cell).width;
    for (var i = 0; i < childLen; i += 1) {
        // the cell is not complex structure, so there is no the performance problem
        el.appendChild(cell.childNodes[i].cloneNode(true));
    }
    return el;
}
exports.createCells = createCells;
function createTreeCell(treeColumnName, viewRow) {
    var cell = document.createElement('div');
    var iconStyle = viewRow.treeInfo.leaf ? '' : 'background-position: -39px -35px';
    var span = document.createElement('span');
    span.className = dom_1.cls('floating-tree-cell-content');
    span.textContent = String(viewRow.valueMap[treeColumnName].value);
    cell.className = dom_1.cls('floating-tree-cell');
    cell.innerHTML = "\n    <span class=\"" + dom_1.cls('tree-icon') + "\">\n      <i style=\"" + iconStyle + "\"></i>\n    </span>\n  ";
    cell.appendChild(span);
    return cell;
}
function createFloatingDraggableRow(store, rowKey, offsetLeft, offsetTop, posInfo) {
    var data = store.data, column = store.column, id = store.id;
    var treeColumnName = column.treeColumnName;
    var cells = common_1.fromArray(posInfo.container.querySelectorAll("[data-row-key=\"" + rowKey + "\"]"));
    // get original table row height
    var height = cells[0].parentElement.clientHeight + "px";
    var row = createRow(height);
    row.style.left = offsetLeft + "px";
    row.style.top = offsetTop + "px";
    if (treeColumnName) {
        var index = data_1.findIndexByRowKey(data, column, id, rowKey);
        var viewRow = data.viewData[index];
        row.appendChild(createTreeCell(treeColumnName, viewRow));
    }
    else {
        cells.forEach(function (cell) {
            row.appendChild(createCells(cell));
        });
    }
    return row;
}
function createFloatingDraggableColumn(store, colunmName, posInfo) {
    var cell = posInfo.container.querySelector("[data-column-name=\"" + colunmName + "\"]");
    var clientHeight = cell.clientHeight, clientWidth = cell.clientWidth;
    var left = cell.getBoundingClientRect().left;
    var column = createColumn(clientHeight, clientWidth);
    column.className = dom_1.cls('floating-column');
    column.style.left = left - store.dimension.offsetLeft + "px";
    column.appendChild(createCells(cell));
    return column;
}
function createDraggableRowInfo(store, posInfo) {
    var data = store.data, dimension = store.dimension;
    var rawData = data.rawData, filters = data.filters;
    // if there is any filter condition, cannot drag the row
    if (!rawData.length || (filters === null || filters === void 0 ? void 0 : filters.length)) {
        return null;
    }
    var _a = getMovedPosAndIndexOfRow(store, posInfo), offsetLeft = _a.offsetLeft, offsetTop = _a.offsetTop, index = _a.index;
    var _b = rawData[index], rowKey = _b.rowKey, _attributes = _b._attributes;
    var row = createFloatingDraggableRow(store, rowKey, offsetLeft, offsetTop, posInfo);
    return _attributes.disabled
        ? null
        : {
            row: row,
            rowKey: rowKey,
            line: createFloatingLine(dimension.scrollYWidth),
        };
}
exports.createDraggableRowInfo = createDraggableRowInfo;
function createDraggableColumnInfo(store, posInfo) {
    var targetColumn = getMovedPosAndIndexOfColumn(store, posInfo).targetColumn;
    var columnName = targetColumn.name;
    var column = createFloatingDraggableColumn(store, columnName, posInfo);
    return { column: column, columnName: columnName, targetColumn: targetColumn };
}
exports.createDraggableColumnInfo = createDraggableColumnInfo;
function getMovedPosAndIndexOfRow(store, _a) {
    var pageX = _a.pageX, pageY = _a.pageY, left = _a.left, top = _a.top, scrollTop = _a.scrollTop;
    var rowCoords = store.rowCoords, dimension = store.dimension, column = store.column, data = store.data;
    var heights = rowCoords.heights, offsets = rowCoords.offsets;
    var rawData = data.rawData;
    var headerHeight = dimension.headerHeight;
    var offsetLeft = pageX - left;
    var offsetTop = pageY - top + scrollTop;
    var index = common_1.findOffsetIndex(rowCoords.offsets, offsetTop);
    // move to next index when exceeding the height with ratio
    if (!column.treeColumnName) {
        if (index < rawData.length - 1 && offsetTop - offsets[index] > heights[index] * EXCEED_RATIO) {
            index += 1;
        }
    }
    var height = offsets[index] - scrollTop + headerHeight;
    var moveToLast = false;
    // resolve the height for moving to last index with tree data
    if (column.treeColumnName) {
        if (rawData.length - 1 === index && offsetTop > offsets[index] + heights[index]) {
            height += heights[index];
            moveToLast = true;
        }
    }
    return {
        index: index,
        height: height,
        offsetLeft: offsetLeft,
        offsetTop: offsetTop - scrollTop + headerHeight,
        targetRow: rawData[index],
        moveToLast: moveToLast,
    };
}
exports.getMovedPosAndIndexOfRow = getMovedPosAndIndexOfRow;
function getMovedPosAndIndexOfColumn(store, _a, offsetLeftOfDragColumn, floatingColumnWidth) {
    var pageX = _a.pageX, pageY = _a.pageY, scrollTop = _a.scrollTop, scrollLeft = _a.scrollLeft;
    var dimension = store.dimension, column = store.column;
    var containerLeft = dimension.offsetLeft, containerWidth = dimension.width;
    var floatingWidth = floatingColumnWidth || 0;
    var offsetLeftOfFloatingColumn = offsetLeftOfDragColumn || 0;
    var viewInfo = { pageX: pageX, pageY: pageY, scrollTop: scrollTop, scrollLeft: scrollLeft };
    var index = mouse_1.findColumnIndexByPosition(store, viewInfo);
    var targetColumn = column.allColumns[index];
    var offsetLeft = pageX - offsetLeftOfFloatingColumn - containerLeft;
    if (offsetLeft < 0) {
        offsetLeft = 0;
    }
    else if (offsetLeft + floatingWidth > containerWidth) {
        offsetLeft = containerWidth - floatingWidth;
    }
    return {
        index: index,
        offsetLeft: offsetLeft,
        targetColumn: targetColumn,
    };
}
exports.getMovedPosAndIndexOfColumn = getMovedPosAndIndexOfColumn;
function createFloatingLine(scrollYWidth) {
    var line = document.createElement('div');
    line.className = dom_1.cls('floating-line');
    line.style.width = "calc(100% - " + scrollYWidth + "px)";
    return line;
}
exports.createFloatingLine = createFloatingLine;
function getResolvedOffsets(_a, _b, _c) {
    var dimension = _a.dimension;
    var offsetLeft = _b.offsetLeft, offsetTop = _b.offsetTop;
    var width = _c.width;
    var bodyWidth = dimension.width, bodyHeight = dimension.bodyHeight, scrollXHeight = dimension.scrollXHeight;
    return {
        offsetLeft: common_1.clamp(offsetLeft, 0, bodyWidth - width),
        offsetTop: common_1.clamp(offsetTop, 0, bodyHeight + scrollXHeight + ADDITIONAL_HEIGHT),
    };
}
exports.getResolvedOffsets = getResolvedOffsets;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.BodyArea = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var draggable_1 = __webpack_require__(54);
var bodyRows_1 = __webpack_require__(99);
var colGroup_1 = __webpack_require__(39);
var dom_1 = __webpack_require__(2);
var hoc_1 = __webpack_require__(4);
var focusLayer_1 = __webpack_require__(105);
var selectionLayer_1 = __webpack_require__(106);
var common_1 = __webpack_require__(0);
var editingLayer_1 = __webpack_require__(107);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var eventBus_1 = __webpack_require__(7);
var constant_1 = __webpack_require__(8);
var focus_1 = __webpack_require__(45);
// only updates when these props are changed
// for preventing unnecessary rendering when scroll changes
var PROPS_FOR_UPDATE = [
    'bodyHeight',
    'totalRowHeight',
    'offsetLeft',
    'offsetTop',
    'totalColumnWidth',
    'visibleTotalWidth',
];
// Minimum distance (pixel) to detect if user wants to drag when moving mouse with button pressed.
var MIN_DISTANCE_FOR_DRAG = 10;
var ADDITIONAL_RANGE = 3;
var DRAGGING_CLASS = 'dragging';
var PARENT_CELL_CLASS = 'parent-cell';
var DRAGGABLE_COLUMN_NAME = '_draggable';
var BodyAreaComp = /** @class */ (function (_super) {
    tslib_1.__extends(BodyAreaComp, _super);
    function BodyAreaComp() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dragStartData = {
            pageX: null,
            pageY: null,
        };
        _this.prevScrollLeft = 0;
        // draggable info when start to move the row
        _this.draggableInfo = null;
        // floating row width and height for dragging
        _this.floatingRowSize = null;
        // the index info to move row through drag
        _this.movedIndexInfo = null;
        _this.scrollToNextDebounced = common_1.debounce(function () {
            _this.props.dispatch('scrollToNext');
        }, 200);
        _this.handleWheel = function (ev) {
            var _a = _this.props, scrollX = _a.scrollX, scrollY = _a.scrollY;
            var currentTarget = ev.currentTarget;
            var deltaX = ev.deltaX, deltaY = ev.deltaY;
            if (scrollX || scrollY) {
                var _b = dom_1.isElementScrollable(currentTarget), canScrollUp = _b.canScrollUp, canScrollDown = _b.canScrollDown, canScrollRight = _b.canScrollRight, canScrollLeft = _b.canScrollLeft;
                if ((canScrollUp && deltaY < 0) ||
                    (canScrollDown && deltaY > 0) ||
                    (canScrollRight && deltaX > 0) ||
                    (canScrollLeft && deltaX < 0)) {
                    ev.preventDefault();
                }
            }
            currentTarget.scrollTop += ev.deltaY;
            currentTarget.scrollLeft += ev.deltaX;
        };
        _this.handleScroll = function (ev) {
            var _a = ev.target, scrollLeft = _a.scrollLeft, scrollTop = _a.scrollTop, scrollHeight = _a.scrollHeight, clientHeight = _a.clientHeight;
            var _b = _this.props, dispatch = _b.dispatch, eventBus = _b.eventBus, side = _b.side;
            dispatch('setScrollTop', scrollTop);
            if (side === 'R') {
                dispatch('setScrollLeft', scrollLeft);
                if (scrollTop > 0 &&
                    scrollHeight - scrollTop === clientHeight &&
                    _this.prevScrollLeft === scrollLeft) {
                    var gridEvent = new gridEvent_1.default();
                    /**
                     * Occurs when scroll at the bottommost
                     * @event Grid#scrollEnd
                     * @property {Grid} instance - Current grid instance
                     */
                    eventBus.trigger('scrollEnd', gridEvent);
                    _this.scrollToNextDebounced();
                }
                _this.prevScrollLeft = scrollLeft;
            }
        };
        _this.dragRow = function (ev) {
            var _a = dom_1.getCoordinateWithOffset(ev.pageX, ev.pageY), pageX = _a[0], pageY = _a[1];
            if (_this.moveEnoughToTriggerDragEvent({ pageX: pageX, pageY: pageY })) {
                var _b = _this, el = _b.el, boundingRect = _b.boundingRect, props = _b.props;
                var _c = el, scrollTop = _c.scrollTop, scrollLeft = _c.scrollLeft;
                var movedPosAndIndex = draggable_1.getMovedPosAndIndexOfRow(_this.context.store, {
                    scrollLeft: scrollLeft,
                    scrollTop: scrollTop,
                    left: boundingRect.left,
                    top: boundingRect.top,
                    pageX: pageX,
                    pageY: pageY,
                });
                var index = movedPosAndIndex.index, targetRow = movedPosAndIndex.targetRow;
                var rowKeyToMove = targetRow.rowKey;
                var _d = _this.draggableInfo, row = _d.row, rowKey = _d.rowKey;
                var _e = draggable_1.getResolvedOffsets(_this.context.store, movedPosAndIndex, _this.floatingRowSize), offsetLeft = _e.offsetLeft, offsetTop = _e.offsetTop;
                row.style.left = offsetLeft + "px";
                row.style.top = offsetTop + "px";
                if (props.hasTreeColumn) {
                    _this.setTreeMovedIndexInfo(movedPosAndIndex);
                }
                else {
                    // move the row to next index
                    _this.movedIndexInfo = { index: index, rowKey: rowKeyToMove, appended: false };
                    _this.props.dispatch('moveRow', rowKey, index);
                }
                var gridEvent = new gridEvent_1.default({
                    rowKey: rowKey,
                    targetRowKey: _this.movedIndexInfo.rowKey,
                    appended: _this.movedIndexInfo.appended,
                });
                /**
                 * Occurs when dragging the row
                 * @event Grid#drag
                 * @property {Grid} instance - Current grid instance
                 * @property {RowKey} rowKey - The rowKey of the dragging row
                 * @property {RowKey} targetRowKey - The rowKey of the row at current dragging position
                 * @property {boolean} appended - Whether the row is appended to other row as the child in tree data.
                 */
                _this.props.eventBus.trigger('drag', gridEvent);
            }
        };
        _this.startToDragRow = function (posInfo) {
            var container = _this.el.parentElement.parentElement;
            posInfo.container = container;
            _this.props.dispatch('resetRowSpan');
            var draggableInfo = draggable_1.createDraggableRowInfo(_this.context.store, posInfo);
            if (draggableInfo) {
                var row = draggableInfo.row, rowKey = draggableInfo.rowKey, line = draggableInfo.line;
                var gridEvent = new gridEvent_1.default({ rowKey: rowKey, floatingRow: row });
                /**
                 * Occurs when starting to drag the row
                 * @event Grid#dragStart
                 * @property {Grid} instance - Current grid instance
                 * @property {RowKey} rowKey - The rowKey of the row to drag
                 * @property {HTMLElement} floatingRow - The floating row DOM element
                 */
                _this.props.eventBus.trigger('dragStart', gridEvent);
                if (!gridEvent.isStopped()) {
                    container.appendChild(row);
                    var clientWidth = row.clientWidth, clientHeight = row.clientHeight;
                    _this.floatingRowSize = { width: clientWidth, height: clientHeight };
                    _this.draggableInfo = draggableInfo;
                    if (_this.props.hasTreeColumn) {
                        container.appendChild(line);
                    }
                    _this.props.dispatch('addRowClassName', rowKey, DRAGGING_CLASS);
                    _this.props.dispatch('setFocusInfo', null, null, false);
                    _this.props.dispatch('initSelection');
                    document.addEventListener('mousemove', _this.dragRow);
                    document.addEventListener('mouseup', _this.dropRow);
                    document.addEventListener('selectstart', _this.handleSelectStart);
                }
            }
        };
        _this.handleMouseDown = function (ev) {
            var _a;
            var targetElement = ev.target;
            if (!_this.el ||
                targetElement === _this.el ||
                (ev.button === constant_1.RIGHT_MOUSE_BUTTON && _this.isSelectedCell(targetElement))) {
                return;
            }
            var _b = _this.props, side = _b.side, dispatch = _b.dispatch;
            if (dom_1.hasClass(targetElement, 'cell-dummy')) {
                dispatch('saveAndFinishEditing');
                dispatch('initFocus');
                dispatch('initSelection');
                return;
            }
            var el = _this.el;
            var shiftKey = ev.shiftKey;
            var _c = dom_1.getCoordinateWithOffset(ev.pageX, ev.pageY), pageX = _c[0], pageY = _c[1];
            var scrollTop = el.scrollTop, scrollLeft = el.scrollLeft;
            var _d = el.getBoundingClientRect(), top = _d.top, left = _d.left;
            _this.boundingRect = { top: top, left: left };
            if (((_a = dom_1.getCellAddress(targetElement)) === null || _a === void 0 ? void 0 : _a.columnName) === DRAGGABLE_COLUMN_NAME) {
                _this.startToDragRow({ pageX: pageX, pageY: pageY, left: left, top: top, scrollLeft: scrollLeft, scrollTop: scrollTop });
                return;
            }
            if (!dom_1.isDatePickerElement(targetElement) &&
                !dom_1.findParentByClassName(targetElement, 'layer-editing')) {
                dispatch('mouseDownBody', tslib_1.__assign({ scrollTop: scrollTop, scrollLeft: scrollLeft, side: side }, _this.boundingRect), { pageX: pageX, pageY: pageY, shiftKey: shiftKey });
            }
            _this.dragStartData = { pageX: pageX, pageY: pageY };
            dom_1.setCursorStyle('default');
            document.addEventListener('mousemove', _this.handleMouseMove);
            document.addEventListener('mouseup', _this.clearDocumentEvents);
            document.addEventListener('selectstart', _this.handleSelectStart);
        };
        _this.moveEnoughToTriggerDragEvent = function (current) {
            var dx = Math.abs(_this.dragStartData.pageX - current.pageX);
            var dy = Math.abs(_this.dragStartData.pageY - current.pageY);
            var movedDistance = Math.round(Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2)));
            return movedDistance >= MIN_DISTANCE_FOR_DRAG;
        };
        _this.handleSelectStart = function (ev) {
            ev.preventDefault();
        };
        _this.handleMouseMove = function (ev) {
            var _a = dom_1.getCoordinateWithOffset(ev.pageX, ev.pageY), pageX = _a[0], pageY = _a[1];
            if (_this.moveEnoughToTriggerDragEvent({ pageX: pageX, pageY: pageY })) {
                var _b = _this, el = _b.el, boundingRect = _b.boundingRect, props = _b.props;
                var _c = el, scrollTop = _c.scrollTop, scrollLeft = _c.scrollLeft;
                var side = props.side, dispatch = props.dispatch;
                dispatch('dragMoveBody', _this.dragStartData, { pageX: pageX, pageY: pageY }, tslib_1.__assign({ scrollTop: scrollTop, scrollLeft: scrollLeft, side: side }, boundingRect));
            }
        };
        _this.dropRow = function () {
            var _a;
            var hasTreeColumn = _this.props.hasTreeColumn;
            var rowKey = _this.draggableInfo.rowKey;
            if (_this.movedIndexInfo) {
                var _b = _this.movedIndexInfo, index = _b.index, targetRowKey = _b.rowKey, appended = _b.appended, _c = _b.moveToLast, moveToLast = _c === void 0 ? false : _c;
                var gridEvent = new gridEvent_1.default({ rowKey: rowKey, targetRowKey: targetRowKey, appended: appended });
                /**
                 * Occurs when dropping the row
                 * @event Grid#drop
                 * @property {Grid} instance - Current grid instance
                 * @property {RowKey} rowKey - The rowKey of the dragging row
                 * @property {RowKey} targetRowKey - The rowKey of the row at current dragging position
                 * @property {boolean} appended - Whether the row is appended to other row as the child in tree data.
                 */
                _this.props.eventBus.trigger('drop', gridEvent);
                if (!gridEvent.isStopped()) {
                    if (hasTreeColumn) {
                        _this.props.dispatch('moveTreeRow', rowKey, index, { appended: appended, moveToLast: moveToLast });
                    }
                    else {
                        _this.props.dispatch('moveRow', rowKey, index);
                    }
                }
            }
            _this.props.dispatch('removeRowClassName', rowKey, DRAGGING_CLASS);
            if (!common_1.isNil((_a = _this.movedIndexInfo) === null || _a === void 0 ? void 0 : _a.rowKey)) {
                _this.props.dispatch('removeRowClassName', _this.movedIndexInfo.rowKey, PARENT_CELL_CLASS);
            }
            // clear floating element and draggable info
            _this.clearDraggableInfo();
            _this.props.dispatch('updateRowSpan');
        };
        _this.clearDocumentEvents = function () {
            _this.dragStartData = { pageX: null, pageY: null };
            _this.props.dispatch('dragEnd');
            dom_1.setCursorStyle('');
            document.removeEventListener('mousemove', _this.handleMouseMove);
            document.removeEventListener('mouseup', _this.clearDocumentEvents);
            document.removeEventListener('selectstart', _this.handleSelectStart);
        };
        return _this;
    }
    BodyAreaComp.prototype.setTreeMovedIndexInfo = function (movedPosAndIndex) {
        var _a;
        var line = this.draggableInfo.line;
        var index = movedPosAndIndex.index, offsetTop = movedPosAndIndex.offsetTop, height = movedPosAndIndex.height, targetRow = movedPosAndIndex.targetRow, moveToLast = movedPosAndIndex.moveToLast;
        var rowKey = targetRow.rowKey;
        if (!common_1.isNil((_a = this.movedIndexInfo) === null || _a === void 0 ? void 0 : _a.rowKey)) {
            this.props.dispatch('removeRowClassName', this.movedIndexInfo.rowKey, PARENT_CELL_CLASS);
        }
        var targetRowKey = moveToLast ? null : rowKey;
        // display line border to mark the index to move
        if (Math.abs(height - offsetTop) < ADDITIONAL_RANGE || moveToLast) {
            line.style.top = height + "px";
            line.style.display = 'block';
            this.movedIndexInfo = { index: index, rowKey: targetRowKey, moveToLast: moveToLast, appended: false };
            // show the background color to mark parent row
        }
        else {
            line.style.display = 'none';
            this.movedIndexInfo = { index: index, rowKey: targetRowKey, appended: true };
            this.props.dispatch('addRowClassName', rowKey, PARENT_CELL_CLASS);
        }
    };
    BodyAreaComp.prototype.isSelectedCell = function (element) {
        var cellAddress = dom_1.getCellAddress(element);
        if (cellAddress) {
            var rowKey = cellAddress.rowKey, columnName = cellAddress.columnName;
            return focus_1.isFocusedCell(this.context.store.focus, rowKey, columnName);
        }
        return !!dom_1.findParentByClassName(element, 'layer-selection');
    };
    BodyAreaComp.prototype.clearDraggableInfo = function () {
        var _a = this.draggableInfo, row = _a.row, line = _a.line;
        row.parentElement.removeChild(row);
        if (this.props.hasTreeColumn) {
            line.parentElement.removeChild(line);
        }
        this.draggableInfo = null;
        this.movedIndexInfo = null;
        document.removeEventListener('mousemove', this.dragRow);
        document.removeEventListener('mouseup', this.dropRow);
        document.removeEventListener('selectstart', this.handleSelectStart);
    };
    BodyAreaComp.prototype.shouldComponentUpdate = function (nextProps) {
        var currProps = this.props;
        return common_1.some(function (propName) { return nextProps[propName] !== currProps[propName]; }, PROPS_FOR_UPDATE);
    };
    BodyAreaComp.prototype.componentWillReceiveProps = function (nextProps) {
        var scrollTop = nextProps.scrollTop, scrollLeft = nextProps.scrollLeft;
        this.el.scrollTop = scrollTop;
        this.el.scrollLeft = scrollLeft;
    };
    BodyAreaComp.prototype.render = function (_a) {
        var _this = this;
        var side = _a.side, bodyHeight = _a.bodyHeight, totalRowHeight = _a.totalRowHeight, totalColumnWidth = _a.totalColumnWidth, scrollXHeight = _a.scrollXHeight, offsetTop = _a.offsetTop, offsetLeft = _a.offsetLeft, dummyRowCount = _a.dummyRowCount, scrollX = _a.scrollX, scrollY = _a.scrollY, cellBorderWidth = _a.cellBorderWidth, visibleTotalWidth = _a.visibleTotalWidth;
        var areaStyle = { height: bodyHeight };
        if (!scrollX) {
            areaStyle.overflowX = 'hidden';
        }
        if (!scrollY && side === 'R') {
            areaStyle.overflowY = 'hidden';
        }
        var tableContainerStyle = {
            width: visibleTotalWidth,
            top: offsetTop,
            left: offsetLeft,
            height: dummyRowCount ? bodyHeight - scrollXHeight : '',
            overflow: dummyRowCount ? 'hidden' : 'visible',
        };
        var containerStyle = {
            width: totalColumnWidth + (side === 'R' ? 0 : cellBorderWidth),
            height: totalRowHeight ? totalRowHeight + cellBorderWidth : '100%',
        };
        return (preact_1.h("div", { class: dom_1.cls('body-area'), style: areaStyle, onScroll: this.handleScroll, onMouseDown: this.handleMouseDown, onWheel: this.handleWheel, ref: function (el) {
                _this.el = el;
            } },
            preact_1.h("div", { class: dom_1.cls('body-container'), style: containerStyle },
                preact_1.h("div", { class: dom_1.cls('table-container'), style: tableContainerStyle },
                    preact_1.h("table", { class: dom_1.cls('table') },
                        preact_1.h(colGroup_1.ColGroup, { side: side, useViewport: true }),
                        preact_1.h(bodyRows_1.BodyRows, { side: side }))),
                preact_1.h(focusLayer_1.FocusLayer, { side: side }),
                preact_1.h(selectionLayer_1.SelectionLayer, { side: side }),
                preact_1.h(editingLayer_1.EditingLayer, { side: side }))));
    };
    return BodyAreaComp;
}(preact_1.Component));
exports.BodyArea = hoc_1.connect(function (store, _a) {
    var _b;
    var side = _a.side;
    var columnCoords = store.columnCoords, rowCoords = store.rowCoords, dimension = store.dimension, viewport = store.viewport, id = store.id, column = store.column;
    var totalRowHeight = rowCoords.totalRowHeight;
    var totalColumnWidth = columnCoords.totalColumnWidth, widths = columnCoords.widths;
    var bodyHeight = dimension.bodyHeight, scrollXHeight = dimension.scrollXHeight, scrollX = dimension.scrollX, scrollY = dimension.scrollY, cellBorderWidth = dimension.cellBorderWidth;
    var offsetLeft = viewport.offsetLeft, offsetTop = viewport.offsetTop, scrollTop = viewport.scrollTop, scrollLeft = viewport.scrollLeft, dummyRowCount = viewport.dummyRowCount, colRange = viewport.colRange, columns = viewport.columns;
    var visibleWidths = side === 'R' ? (_b = widths[side]).slice.apply(_b, colRange) : widths[side];
    var visibleColumns = side === 'R' ? columns : column.visibleColumnsBySideWithRowHeader[side];
    var visibleTotalWidth = visibleColumns.reduce(function (acc, _, idx) { return acc + visibleWidths[idx] + cellBorderWidth; }, 0);
    return {
        bodyHeight: bodyHeight,
        totalRowHeight: totalRowHeight,
        offsetTop: offsetTop,
        scrollTop: scrollTop,
        totalColumnWidth: totalColumnWidth[side],
        offsetLeft: side === 'L' ? 0 : offsetLeft,
        scrollLeft: side === 'L' ? 0 : scrollLeft,
        scrollXHeight: scrollXHeight,
        dummyRowCount: dummyRowCount,
        scrollX: scrollX,
        scrollY: scrollY,
        cellBorderWidth: cellBorderWidth,
        eventBus: eventBus_1.getEventBus(id),
        hasTreeColumn: !!column.treeColumnName,
        visibleTotalWidth: visibleTotalWidth,
    };
})(BodyAreaComp);


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SummaryArea = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var colGroup_1 = __webpack_require__(39);
var summaryBodyRow_1 = __webpack_require__(108);
var dom_1 = __webpack_require__(2);
var hoc_1 = __webpack_require__(4);
var SummaryAreaComp = /** @class */ (function (_super) {
    tslib_1.__extends(SummaryAreaComp, _super);
    function SummaryAreaComp() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.handleScroll = function (ev) {
            var scrollLeft = ev.target.scrollLeft;
            var _a = _this.props, dispatch = _a.dispatch, side = _a.side;
            if (side === 'R') {
                dispatch('setScrollLeft', scrollLeft);
            }
        };
        return _this;
    }
    SummaryAreaComp.prototype.componentWillReceiveProps = function (nextProps) {
        if (this.el) {
            this.el.scrollLeft = nextProps.scrollLeft;
        }
    };
    SummaryAreaComp.prototype.render = function (_a) {
        var _this = this;
        var height = _a.height, columns = _a.columns, side = _a.side;
        var tableStyle = { height: height };
        return (height > 0 && (preact_1.h("div", { class: dom_1.cls('summary-area'), onScroll: this.handleScroll, ref: function (el) {
                _this.el = el;
            } },
            preact_1.h("table", { class: dom_1.cls('table'), style: tableStyle },
                preact_1.h(colGroup_1.ColGroup, { side: side, useViewport: false }),
                preact_1.h(summaryBodyRow_1.SummaryBodyRow, { columns: columns })))));
    };
    return SummaryAreaComp;
}(preact_1.Component));
exports.SummaryArea = hoc_1.connect(function (store, _a) {
    var side = _a.side;
    var column = store.column, dimension = store.dimension, viewport = store.viewport;
    var summaryHeight = dimension.summaryHeight;
    var scrollLeft = viewport.scrollLeft;
    return {
        height: summaryHeight,
        columns: column.visibleColumnsBySideWithRowHeader[side],
        scrollLeft: scrollLeft,
    };
})(SummaryAreaComp);


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ContextMenu = exports.ContextMenuComp = void 0;
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var hoc_1 = __webpack_require__(4);
var dom_1 = __webpack_require__(2);
var contextMenuItem_1 = __webpack_require__(118);
var ContextMenuComp = /** @class */ (function (_super) {
    tslib_1.__extends(ContextMenuComp, _super);
    function ContextMenuComp() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.container = null;
        return _this;
    }
    ContextMenuComp.prototype.adjustPos = function () {
        var pos = this.props.pos;
        var _a = pos, left = _a.left, top = _a.top, right = _a.right, bottom = _a.bottom;
        var _b = this.container, offsetHeight = _b.offsetHeight, offsetWidth = _b.offsetWidth;
        var computedTop = offsetHeight > bottom ? top + bottom - offsetHeight : top;
        var computedLeft = offsetWidth > right ? left + right - offsetWidth : left;
        this.container.style.top = computedTop + "px";
        this.container.style.left = computedLeft + "px";
    };
    ContextMenuComp.prototype.componentDidMount = function () {
        if (this.props.pos) {
            this.adjustPos();
        }
    };
    ContextMenuComp.prototype.componentDidUpdate = function () {
        if (this.props.pos) {
            this.adjustPos();
        }
    };
    ContextMenuComp.prototype.render = function () {
        var _this = this;
        var _a = this.props, pos = _a.pos, menuItems = _a.menuItems;
        if (pos) {
            return (preact_1.h("ul", { ref: function (ref) {
                    _this.container = ref;
                }, class: dom_1.cls('context-menu') }, menuItems.map(function (menuItem) { return (preact_1.h(contextMenuItem_1.ContextMenuItem, { key: menuItem.name, menuItem: menuItem })); })));
        }
        return null;
    };
    return ContextMenuComp;
}(preact_1.Component));
exports.ContextMenuComp = ContextMenuComp;
exports.ContextMenu = hoc_1.connect(function (_a, _b) {
    var _c, _d;
    var contextMenu = _a.contextMenu;
    var menuItems = _b.menuItems, pos = _b.pos;
    return ({
        pos: pos || ((_d = (_c = contextMenu === null || contextMenu === void 0 ? void 0 : contextMenu.posInfo) === null || _c === void 0 ? void 0 : _c.pos) !== null && _d !== void 0 ? _d : null),
        menuItems: menuItems || (contextMenu === null || contextMenu === void 0 ? void 0 : contextMenu.flattenTopMenuItems),
    });
})(ContextMenuComp);


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.execCopy = void 0;
var dom_1 = __webpack_require__(2);
var clipboard_1 = __webpack_require__(41);
var instance_1 = __webpack_require__(9);
function execCopy(store, ranges) {
    var el = instance_1.getInstance(store.id).el;
    var targetText = clipboard_1.getText(store, ranges);
    var clipboard = el.querySelector("." + dom_1.cls('clipboard'));
    clipboard.innerHTML = targetText;
    if (dom_1.isSupportWindowClipboardData()) {
        dom_1.setClipboardSelection(clipboard.childNodes[0]);
    }
    // Accessing the clipboard is a security concern on chrome
    document.execCommand('copy');
}
exports.execCopy = execCopy;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.execExport = void 0;
var tslib_1 = __webpack_require__(1);
var XLSX = tslib_1.__importStar(__webpack_require__(129));
var common_1 = __webpack_require__(0);
var export_1 = __webpack_require__(130);
var eventBus_1 = __webpack_require__(7);
var browser_1 = __webpack_require__(40);
function getExportDataAndColumnsAndOptions(store, options) {
    var _a = options || {}, _b = _a.includeHeader, includeHeader = _b === void 0 ? true : _b, _c = _a.includeHiddenColumns, includeHiddenColumns = _c === void 0 ? false : _c, _d = _a.onlySelected, onlySelected = _d === void 0 ? false : _d, _e = _a.onlyFiltered, onlyFiltered = _e === void 0 ? true : _e, _f = _a.delimiter, delimiter = _f === void 0 ? ',' : _f, _g = _a.fileName, fileName = _g === void 0 ? 'grid-export' : _g, _h = _a.useFormattedValue, useFormattedValue = _h === void 0 ? false : _h;
    var _j = store.data, rawData = _j.rawData, filteredRawData = _j.filteredRawData, column = store.column, originalRange = store.selection.originalRange, excelCompatibilityMode = store.exports.excelCompatibilityMode;
    var _k = export_1.getNamesAndHeadersOfColumnsByOptions(column, (options === null || options === void 0 ? void 0 : options.columnNames) || [], includeHiddenColumns, onlySelected, originalRange), columnHeaders = _k.targetColumnHeaders, columnNames = _k.targetColumnNames;
    var data = export_1.getTargetData(store, onlyFiltered ? filteredRawData : rawData, columnNames, onlySelected, useFormattedValue);
    var exportOptions = {
        includeHeader: includeHeader,
        includeHiddenColumns: includeHiddenColumns,
        onlySelected: onlySelected,
        onlyFiltered: onlyFiltered,
        delimiter: delimiter,
        fileName: fileName,
        columnNames: columnNames,
    };
    return { data: data, columnHeaders: columnHeaders, columnNames: columnNames, exportOptions: exportOptions, excelCompatibilityMode: excelCompatibilityMode };
}
function emitExportEvent(store, eventType, eventParams) {
    var eventBus = eventBus_1.getEventBus(store.id);
    var gridEvent = export_1.createExportEvent(eventType, eventParams);
    eventBus.trigger(eventType, gridEvent);
    return gridEvent;
}
function getMergeRelationship(complexColumnHeaderData) {
    var merges = [];
    var numOfRow = complexColumnHeaderData.length;
    var numOfColumn = complexColumnHeaderData[0].length;
    complexColumnHeaderData.forEach(function (row, rowIndex) {
        row.forEach(function (currentName, colIndex) {
            if (currentName) {
                var merge = { s: { r: rowIndex, c: colIndex }, e: { r: rowIndex, c: colIndex } };
                var mergeRowNum = void 0, mergeColNum = void 0;
                for (mergeRowNum = rowIndex + 1; mergeRowNum < numOfRow; mergeRowNum += 1) {
                    if (complexColumnHeaderData[mergeRowNum][colIndex] === currentName) {
                        complexColumnHeaderData[mergeRowNum][colIndex] = '';
                        merge.e.r += 1;
                    }
                    else {
                        break;
                    }
                }
                for (mergeColNum = colIndex + 1; mergeColNum < numOfColumn; mergeColNum += 1) {
                    if (complexColumnHeaderData[mergeRowNum - 1][mergeColNum] === currentName) {
                        complexColumnHeaderData[mergeRowNum - 1][mergeColNum] = '';
                        merge.e.c += 1;
                    }
                    else {
                        break;
                    }
                }
                complexColumnHeaderData[rowIndex][colIndex] = '';
                if (merge.s.r !== merge.e.r || merge.s.c !== merge.e.c) {
                    merges.push(merge);
                }
            }
        });
    });
    return merges;
}
function exportText(format, fileName, targetText) {
    var targetBlob = format === 'txt'
        ? new Blob([targetText])
        : new Blob(["\uFEFF" + targetText], { type: 'text/csv;charset=utf-8;' });
    browser_1.downloadBlob(targetBlob, format, fileName);
}
function exportExcel(format, fileName, targetArray, complexColumnHeaderData) {
    var wb = XLSX.utils.book_new();
    var ws = XLSX.utils.aoa_to_sheet(targetArray);
    if (complexColumnHeaderData) {
        ws['!merges'] = getMergeRelationship(complexColumnHeaderData);
    }
    XLSX.utils.book_append_sheet(wb, ws);
    XLSX.writeFile(wb, fileName + "." + format);
}
function exportCallback(data, format, options, complexHeaderData) {
    var _a = options || {}, _b = _a.delimiter, delimiter = _b === void 0 ? ',' : _b, _c = _a.fileName, fileName = _c === void 0 ? 'grid-export' : _c;
    if (format !== 'xlsx' && format !== 'xls') {
        var targetText = common_1.convertDataToText(data, delimiter);
        exportText(format, fileName, targetText);
    }
    else {
        if (!(XLSX === null || XLSX === void 0 ? void 0 : XLSX.writeFile)) {
            // eslint-disable-next-line no-console
            console.error('[tui/grid] - Not found the dependency "xlsx". You should install the "xlsx" to export the data as Excel format');
            return;
        }
        exportExcel(format, fileName, data, complexHeaderData);
    }
}
function execExport(store, format, options) {
    var _a = getExportDataAndColumnsAndOptions(store, options), data = _a.data, columnHeaders = _a.columnHeaders, columnNames = _a.columnNames, exportOptions = _a.exportOptions, excelCompatibilityMode = _a.excelCompatibilityMode;
    var includeHeader = exportOptions.includeHeader, delimiter = exportOptions.delimiter, fileName = exportOptions.fileName;
    var column = store.column;
    if ((format === 'xlsx' || format === 'xls') && !(XLSX === null || XLSX === void 0 ? void 0 : XLSX.writeFile)) {
        // eslint-disable-next-line no-console
        console.error('[tui/grid] - Not found the dependency "xlsx". You should install the "xlsx" to export the data as Excel format');
        return;
    }
    var targetData = data.slice(0);
    var complexHeaderData = null;
    if (includeHeader) {
        if (column.complexColumnHeaders.length > 0) {
            complexHeaderData = export_1.getHeaderDataFromComplexColumn(column, columnNames);
        }
        else {
            targetData.unshift(columnHeaders);
        }
    }
    if (complexHeaderData && format !== 'csv') {
        targetData = complexHeaderData.concat(targetData);
    }
    var exportFn = function (exportingData) {
        return exportCallback(exportingData, format, exportOptions, complexHeaderData);
    };
    var gridEvent = emitExportEvent(store, 'beforeExport', {
        exportFormat: format,
        exportOptions: exportOptions,
        data: targetData,
        complexHeaderData: complexHeaderData,
        exportFn: exportFn,
    });
    if (gridEvent.isStopped()) {
        return;
    }
    if (format === 'xlsx' || format === 'xls') {
        exportExcel(excelCompatibilityMode ? 'xls' : format, fileName, targetData, complexHeaderData);
    }
    else {
        var targetText = common_1.convertDataToText(targetData, delimiter);
        exportText(format, fileName, targetText);
    }
    emitExportEvent(store, 'afterExport', {
        exportFormat: format,
        exportOptions: exportOptions,
        data: targetData,
        complexHeaderData: complexHeaderData,
    });
}
exports.execExport = execExport;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.gridAjax = void 0;
var tslib_1 = __webpack_require__(1);
var serializer_1 = __webpack_require__(138);
var gridEvent_1 = tslib_1.__importDefault(__webpack_require__(10));
var common_1 = __webpack_require__(0);
var ENCODED_SPACE_REGEXP = /%20/g;
var QS_DELIM_REGEXP = /\?/;
function hasRequestBody(method) {
    return /^(?:POST|PUT|PATCH)$/.test(method.toUpperCase());
}
function getSerialized(params, serializer) {
    return common_1.isFunction(serializer) ? serializer(params) : serializer_1.serialize(params);
}
function handleReadyStateChange(xhr, options) {
    var eventBus = options.eventBus, success = options.success, preCallback = options.preCallback, postCallback = options.postCallback;
    // eslint-disable-next-line eqeqeq
    if (xhr.readyState != XMLHttpRequest.DONE) {
        return;
    }
    preCallback();
    var gridEvent = new gridEvent_1.default({ xhr: xhr });
    /**
     * Occurs when the response is received from the server
     * @event Grid#response
     * @type {module:event/gridEvent}
     * @property {XmlHttpRequest} xhr - XmlHttpRequest
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('response', gridEvent);
    if (gridEvent.isStopped()) {
        return;
    }
    if (xhr.status === 200) {
        var response = JSON.parse(xhr.responseText);
        if (response.result) {
            /**
             * Occurs after the response event, if the result is true
             * @event Grid#successResponse
             * @type {module:event/gridEvent}
             * @property {XmlHttpRequest} xhr - XmlHttpRequest
             * @property {Grid} instance - Current grid instance
             */
            eventBus.trigger('successResponse', gridEvent);
            if (gridEvent.isStopped()) {
                return;
            }
            success(response);
        }
        else if (!response.result) {
            /**
             * Occurs after the response event, if the result is false
             * @event Grid#failResponse
             * @type {module:event/gridEvent}
             * @property {XmlHttpRequest} xhr - XmlHttpRequest
             * @property {Grid} instance - Current grid instance
             */
            eventBus.trigger('failResponse', gridEvent);
            if (gridEvent.isStopped()) {
                return;
            }
        }
    }
    else {
        /**
         * Occurs after the response event, if the response is Error
         * @event Grid#errorResponse
         * @type {module:event/gridEvent}
         * @property {XmlHttpRequest} xhr - XmlHttpRequest
         * @property {Grid} instance - Current grid instance
         */
        eventBus.trigger('errorResponse', gridEvent);
        if (gridEvent.isStopped()) {
            return;
        }
    }
    postCallback();
}
function open(xhr, options) {
    var url = options.url, method = options.method, serializer = options.serializer, _a = options.params, params = _a === void 0 ? {} : _a;
    var requestUrl = url;
    if (!hasRequestBody(method)) {
        // serialize query string
        var qs = (QS_DELIM_REGEXP.test(url) ? '&' : '?') + getSerialized(params, serializer);
        requestUrl = "" + url + qs;
    }
    xhr.open(method, requestUrl);
}
function applyConfig(xhr, options) {
    var method = options.method, contentType = options.contentType, mimeType = options.mimeType, headers = options.headers, _a = options.withCredentials, withCredentials = _a === void 0 ? false : _a;
    // set withCredentials
    xhr.withCredentials = withCredentials;
    // overide MIME type
    if (mimeType) {
        xhr.overrideMimeType(mimeType);
    }
    // set user defined request headers
    if (common_1.isObject(headers)) {
        Object.keys(headers).forEach(function (name) {
            if (headers[name]) {
                xhr.setRequestHeader(name, headers[name]);
            }
        });
    }
    // set 'Content-Type' when request has body
    if (hasRequestBody(method)) {
        xhr.setRequestHeader('Content-Type', contentType + "; charset=UTF-8");
    }
    // set 'x-requested-with' header to prevent CSRF in old browser
    xhr.setRequestHeader('x-requested-with', 'XMLHttpRequest');
}
function send(xhr, options) {
    var method = options.method, eventBus = options.eventBus, serializer = options.serializer, preCallback = options.preCallback, _a = options.params, params = _a === void 0 ? {} : _a, _b = options.contentType, contentType = _b === void 0 ? 'application/x-www-form-urlencoded' : _b;
    var body = null;
    if (hasRequestBody(method)) {
        // The space character '%20' is replaced to '+', because application/x-www-form-urlencoded follows rfc-1866
        body =
            contentType.indexOf('application/x-www-form-urlencoded') !== -1
                ? getSerialized(params, serializer).replace(ENCODED_SPACE_REGEXP, '+')
                : JSON.stringify(params);
    }
    xhr.onreadystatechange = function () { return handleReadyStateChange(xhr, options); };
    var gridEvent = new gridEvent_1.default({ xhr: xhr });
    /**
     * Occurs before the http request is sent
     * @event Grid#beforeRequest
     * @type {module:event/gridEvent}
     * @property {XMLHttpRequest} xhr - Current XMLHttpRequest instance
     * @property {Grid} instance - Current grid instance
     */
    eventBus.trigger('beforeRequest', gridEvent);
    if (gridEvent.isStopped()) {
        preCallback();
        return;
    }
    xhr.send(body);
}
function gridAjax(options) {
    var xhr = new XMLHttpRequest();
    [open, applyConfig, send].forEach(function (fn) { return fn(xhr, options); });
}
exports.gridAjax = gridAjax;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createManager = exports.getDataWithOptions = void 0;
var tslib_1 = __webpack_require__(1);
var common_1 = __webpack_require__(0);
var observable_1 = __webpack_require__(5);
var data_1 = __webpack_require__(6);
var paramNameMap = {
    CREATE: 'createdRows',
    UPDATE: 'updatedRows',
    DELETE: 'deletedRows',
};
// @TODO: fix 'Row' type with record(Dictionary) type to use negate type or other type utility
function getDataWithOptions(targetRows, options) {
    if (options === void 0) { options = {}; }
    var _a = options.checkedOnly, checkedOnly = _a === void 0 ? false : _a, _b = options.withRawData, withRawData = _b === void 0 ? false : _b, _c = options.rowKeyOnly, rowKeyOnly = _c === void 0 ? false : _c, _d = options.ignoredColumns, ignoredColumns = _d === void 0 ? [] : _d;
    var rows = targetRows.map(function (row) { return observable_1.getOriginObject(row); });
    if (checkedOnly) {
        rows = rows.filter(function (row) { return row._attributes.checked; });
    }
    if (ignoredColumns.length) {
        // @ts-ignore
        rows = rows.map(function (row) { return common_1.omit.apply(void 0, tslib_1.__spreadArrays([row], ignoredColumns)); });
    }
    if (!withRawData) {
        rows = rows.map(function (row) { return data_1.getOmittedInternalProp(row); });
    }
    if (rowKeyOnly) {
        return rows.map(function (row) { return row.rowKey; });
    }
    return rows;
}
exports.getDataWithOptions = getDataWithOptions;
function createManager() {
    var originData = [];
    var mixedOrder = false;
    var dataMap = {
        CREATE: [],
        UPDATE: [],
        DELETE: [],
    };
    var splice = function (type, rowKeys, rows) {
        var sortedContinuousIndexedRows = rowKeys
            .map(function (rowKey, i) { return ({
            rowIndex: common_1.findIndex(function (createdRow) { return createdRow.rowKey === rowKey; }, dataMap[type]),
            row: rows === null || rows === void 0 ? void 0 : rows[i],
        }); })
            .sort(function (prev, current) { return prev.rowIndex - current.rowIndex; })
            .reduce(function (acc, indexedRow) {
            var _a, _b;
            var rowIndex = indexedRow.rowIndex;
            if (rowIndex === -1) {
                return acc;
            }
            var lastContinuousRowIndices = (_a = common_1.last(acc)) !== null && _a !== void 0 ? _a : [];
            var lastRowIndex = (_b = common_1.last(lastContinuousRowIndices)) === null || _b === void 0 ? void 0 : _b.rowIndex;
            if (common_1.isUndefined(lastContinuousRowIndices) ||
                common_1.isUndefined(lastRowIndex) ||
                rowIndex - lastRowIndex !== 1) {
                acc.push([indexedRow]);
            }
            else {
                lastContinuousRowIndices.push(indexedRow);
            }
            return acc;
        }, []);
        var accumulatedLength = 0;
        sortedContinuousIndexedRows.forEach(function (indexedRows) {
            var _a;
            var startIndex = indexedRows[0].rowIndex;
            var currentLength = common_1.last(indexedRows).rowIndex - startIndex + 1;
            if (common_1.isUndefined(rows)) {
                dataMap[type].splice(startIndex - accumulatedLength, currentLength);
            }
            else {
                (_a = dataMap[type]).splice.apply(_a, tslib_1.__spreadArrays([startIndex,
                    currentLength], indexedRows.reduce(function (acc, _a) {
                    var row = _a.row;
                    return (!row ? acc : tslib_1.__spreadArrays(acc, [row]));
                }, [])));
            }
            accumulatedLength += currentLength;
        });
    };
    var spliceAll = function (rowKey, row) {
        splice('CREATE', [rowKey], !row ? row : [row]);
        splice('UPDATE', [rowKey], !row ? row : [row]);
        splice('DELETE', [rowKey], !row ? row : [row]);
    };
    return {
        // only for restore
        setOriginData: function (data) {
            originData = data_1.changeRawDataToOriginDataForTree(data);
        },
        getOriginData: function () {
            return originData;
        },
        getModifiedData: function (type, options) {
            var _a;
            return _a = {}, _a[paramNameMap[type]] = getDataWithOptions(dataMap[type], options), _a;
        },
        getAllModifiedData: function (options) {
            var _this = this;
            return Object.keys(dataMap)
                .map(function (key) { return _this.getModifiedData(key, options); })
                .reduce(function (acc, data) { return (tslib_1.__assign(tslib_1.__assign({}, acc), data)); }, {});
        },
        isModified: function () {
            return !!(dataMap.CREATE.length || dataMap.UPDATE.length || dataMap.DELETE.length);
        },
        isModifiedByType: function (type) {
            return !!dataMap[type].length;
        },
        push: function (type, rows, mixed) {
            var _a;
            if (mixed === void 0) { mixed = false; }
            var rowKeys = rows.map(function (row) { return row.rowKey; });
            mixedOrder = mixedOrder || mixed;
            if (type === 'UPDATE' || type === 'DELETE') {
                splice('UPDATE', rowKeys);
                var registeredRows = rows.filter(function (_a) {
                    var rowKey = _a.rowKey;
                    return common_1.someProp('rowKey', rowKey, dataMap.CREATE);
                });
                // if the row was already registered in createdRows,
                // would update it in createdRows and not add it to updatedRows or deletedRows
                if (!common_1.isEmpty(registeredRows)) {
                    var registeredRowKeys = registeredRows.map(function (row) { return row.rowKey; });
                    if (type === 'UPDATE') {
                        splice('CREATE', registeredRowKeys, registeredRows);
                    }
                    else {
                        splice('CREATE', registeredRowKeys);
                    }
                    return;
                }
            }
            var notModifiedRows = rows.filter(function (_a) {
                var rowKey = _a.rowKey;
                return !common_1.someProp('rowKey', rowKey, dataMap[type]);
            });
            if (!common_1.isEmpty(notModifiedRows)) {
                (_a = dataMap[type]).push.apply(_a, notModifiedRows);
            }
        },
        clearSpecificRows: function (rowsMap) {
            common_1.forEachObject(function (_, key) {
                rowsMap[key].forEach(function (row) {
                    spliceAll(common_1.isObject(row) ? row.rowKey : row);
                });
            }, rowsMap);
        },
        clear: function (requestTypeCode) {
            if (requestTypeCode === 'MODIFY') {
                this.clearAll();
                return;
            }
            dataMap[requestTypeCode] = [];
        },
        clearAll: function () {
            dataMap.CREATE = [];
            dataMap.UPDATE = [];
            dataMap.DELETE = [];
        },
        isMixedOrder: function () {
            return mixedOrder;
        },
    };
}
exports.createManager = createManager;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getAlertMessage = exports.getConfirmMessage = void 0;
var tslib_1 = __webpack_require__(1);
var _1 = tslib_1.__importDefault(__webpack_require__(19));
var confirmMessageMap = {
    CREATE: 'net.confirmCreate',
    UPDATE: 'net.confirmUpdate',
    DELETE: 'net.confirmDelete',
    MODIFY: 'net.confirmModify',
};
var alertMessageMap = {
    CREATE: 'net.noDataToCreate',
    UPDATE: 'net.noDataToUpdate',
    DELETE: 'net.noDataToDelete',
    MODIFY: 'net.noDataToModify',
};
function getConfirmMessage(type, count) {
    return _1.default.get(confirmMessageMap[type], { count: String(count) });
}
exports.getConfirmMessage = getConfirmMessage;
function getAlertMessage(type) {
    return _1.default.get(alertMessageMap[type]);
}
exports.getAlertMessage = getAlertMessage;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var tslib_1 = __webpack_require__(1);
var grid_1 = tslib_1.__importDefault(__webpack_require__(64));
__webpack_require__(143);
grid_1.default.setLanguage('en');
module.exports = grid_1.default;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = __webpack_require__(1);
var preact_1 = __webpack_require__(3);
var create_1 = __webpack_require__(65);
var root_1 = __webpack_require__(90);
var create_2 = __webpack_require__(124);
var manager_1 = tslib_1.__importDefault(__webpack_require__(131));
var instance_1 = __webpack_require__(9);
var i18n_1 = tslib_1.__importDefault(__webpack_require__(19));
var validation_1 = __webpack_require__(135);
var dom_1 = __webpack_require__(2);
var common_1 = __webpack_require__(0);
var observable_1 = __webpack_require__(5);
var eventBus_1 = __webpack_require__(7);
var data_1 = __webpack_require__(6);
var column_1 = __webpack_require__(11);
var serverSideDataProvider_1 = __webpack_require__(136);
var modifiedDataManager_1 = __webpack_require__(61);
var message_1 = __webpack_require__(62);
var paginationManager_1 = __webpack_require__(141);
var tree_1 = __webpack_require__(21);
var rowSpan_1 = __webpack_require__(13);
var googleAnalytics_1 = __webpack_require__(142);
var filter_1 = __webpack_require__(29);
var filter_2 = __webpack_require__(49);
var clipboard_1 = __webpack_require__(58);
var tree_2 = __webpack_require__(20);
/* eslint-disable global-require */
if (false) {}
/**
 * Grid public API
 * @param {Object} options
 *      @param {HTMLElement} el - The target element to create grid.
 *      @param {Array|Object} [options.data] - Grid data for making rows. When using the data source, sets to object.
 *      @param {Object} [options.pageOptions={}] The object for the pagination options.
 *      @param {Object} [options.header] - Options object for header.
 *      @param {number} [options.header.height=40] - The height of the header area.
 *      @param {number} [options.header.align=center] - Horizontal alignment of the header content.
 *              Available values are 'left', 'center', 'right'.
 *      @param {number} [options.header.valign=middle] - Vertical alignment of the row header content.
 *              Available values are 'top', 'middle', 'bottom'.
 *      @param {Array} [options.header.complexColumns] - This options creates new parent headers of the multiple columns
 *          which includes the headers of specified columns, and sets up the hierarchy.
 *          @param {string} [options.header.complexColumns.header] - The header of the complex column to be shown on the header.
 *          @param {string} [options.header.complexColumns.name] - The name of column that makes tree column.
 *          @param {Array} [options.header.complexColumns.childNames] - The name of the child header(subheader).
 *          @param {function} [options.header.complexColumns.renderer] - Sets the custom renderer to customize the header content.
 *          @param {string} [options.header.complexColumns.headerAlign=center] - Horizontal alignment of the header content.
 *              Available values are 'left', 'center', 'right'.
 *          @param {string} [options.header.complexColumns.headerVAlign=middle] - Vertical alignment of the row header content.
 *              Available values are 'top', 'middle', 'bottom'.
 *          @param {boolean} [options.header.complexColumns.hideChildHeaders=false] - If set to true, the child columns header are hidden.
 *          @param {boolean} [options.header.complexColumns.resizable=false] - If set to true, resize-handles of each complex columns will be shown.
 *      @param {string|number} [options.width='auto'] - Options for grid width.
 *      @param {string|number} [options.rowHeight=40] - The height of each rows.
 *          The height of each rows expands to dom's height. If set to number, the height is fixed and the minimum is 9.
 *      @param {number} [options.minRowHeight=40] - The minimum height of each rows.
 *      @param {string|number} [options.bodyHeight] - The height of body area. The default value is 'auto',
 *          the height of body area expands to total height of rows. If set to 'fitToParent', the height of the grid
 *          will expand to fit the height of parent element. If set to number, the height is fixed.
 *      @param {number} [options.minBodyHeight=130] - The minimum height of body area. When this value
 *          is larger than the body's height, it set to the body's height.
 *      @param {Object} [options.columnOptions] - Option object for all columns
 *      @param {number} [options.columnOptions.minWidth=50] - Minimum width of each columns
 *      @param {boolean} [options.columnOptions.resizable=false] - If set to true, resize-handles of each columns
 *          will be shown.
 *      @param {number} [options.columnOptions.frozenCount=0] - The number of frozen columns.
 *          The columns indexed from 0 to this value will always be shown on the left side.
 *          {@link Grid#setFrozenColumnCount} can be used for setting this value dynamically.
 *      @param {number} [options.columnOptions.frozenBorderWidth=1] - The value of frozen border width.
 *          When the frozen columns are created by "frozenCount" option, the frozen border width set.
 *      @param {Object} [options.treeColumnOptions] - Option object for the tree column.
 *      @param {string} [options.treeColumnOptions.name] - The name of column that makes tree column.
 *      @param {boolean} [options.treeColumnOptions.useIcon=true] - If set to true, the folder or file icon is created on
 *          the left side of the tree cell data.
 *      @param {boolean} [options.treeColumnOptions.useCascadingCheckbox] - If set to true, a cascading relationship is
 *          created in the checkbox between parent and child rows.
 *      @param {boolean} [options.treeColumnOptions.indentWidth=22] - Base indent width to set for child nodes
 *      @param {Object} [options.copyOptions] - Option object for clipboard copying
 *      @param {boolean} [options.copyOptions.useFormattedValue] - Whether to use formatted values or original values
 *          as a string to be copied to the clipboard
 *      @param {boolean} [options.copyOptions.useListItemText] - Copy select or checkbox cell values to 'text'
 *          rather than 'value' of the listItem option.
 *      @param {string|function} [options.copyOptions.customValue] - Copy text with 'formatter' in cell.
 *      @param {boolean} [options.useClientSort=true] - If set to true, sorting will be executed by client itself
 *          without server.
 *      @param {string} [options.editingEvent='dblclick'] - If set to 'click', editable cell in the view-mode will be
 *          changed to edit-mode by a single click.
 *      @param {boolean} [options.scrollX=true] - Specifies whether to show horizontal scrollbar.
 *      @param {boolean} [options.scrollY=true] - Specifies whether to show vertical scrollbar.
 *      @param {boolean} [options.showDummyRows=false] - If set to true, empty area will be filled with dummy rows.
 *      @param {string} [options.keyColumnName] - The name of the column to be used to identify each rows.
 *          If not specified, unique value for each rows will be created internally.
 *      @param {boolean} [options.heightResizable=false] - If set to true, a handle for resizing height will be shown.
 *      @param {string} [options.selectionUnit='cell'] - The unit of selection on Grid. ('cell', 'row')
 *      @param {Array} [options.rowHeaders] - Options for making the row header. The row header content is number of
 *          each row or input element. The value of each item is enable to set string type. (ex: ['rowNum', 'checkbox'])
 *          @param {string} [options.rowHeaders.type] - The type of the row header. ('rowNum', 'checkbox')
 *          @param {string} [options.rowHeaders.header] - The header of the row header.
 *          @param {number} [options.rowHeaders.width] - The width of the row header column. The unit is pixel.
 *              If this value isn't set, the column's width sets to default value.
 *          @param {string} [options.rowHeaders.align=left] - Horizontal alignment of the row header content.
 *              Available values are 'left', 'center', 'right'.
 *          @param {string} [options.rowHeaders.valign=middle] - Vertical alignment of the row header content.
 *              Available values are 'top', 'middle', 'bottom'.
 *          @param {function} [options.rowHeaders.renderer] - Sets the custom renderer to customize the header content.
 *      @param {Array} options.columns - The configuration of the grid columns.
 *          @param {string} options.columns.name - The name of the column.
 *          @param {boolean} [options.columns.ellipsis=false] - If set to true, ellipsis will be used
 *              for overflowing content.(This option will be deprecated)
 *          @param {string} [options.columns.align=left] - Horizontal alignment of the column content.
 *              Available values are 'left', 'center', 'right'.
 *          @param {string} [options.columns.valign=middle] - Vertical alignment of the column content.
 *              Available values are 'top', 'middle', 'bottom'.
 *          @param {string} [options.columns.className] - The name of the class to be used for all cells of
 *              the column.
 *          @param {string} [options.columns.header] - The header of the column to be shown on the header.
 *          @param {number} [options.columns.width] - The width of the column. The unit is pixel. If this value
 *              isn't set, the column's width is automatically resized.
 *          @param {number} [options.columns.minWidth=50] - The minimum width of the column. The unit is pixel.
 *          @param {boolean} [options.columns.hidden] - If set to true, the column will not be shown.
 *          @param {boolean} [options.columns.resizable] - If set to false, the width of the column
 *              will not be changed.
 *          @param {Object} [options.columns.validation] - The options to be used for validation.
 *              Validation is executed whenever data is changed or the {@link Grid#validate} is called.
 *          @param {boolean} [options.columns.validation.required=false] - If set to true, the data of the column
 *              will be checked to be not empty.
 *          @param {number|string} [options.columns.validation.dataType='string'] - Specifies the type of the cell value.
 *              Available types are 'string' and 'number'.
 *          @param {number} [options.columns.validation.min] - If set to numeric value, the data of the column
 *              will be checked to be greater than 'min' value.
 *              Available types are 'string' and 'number'.
 *          @param {number} [options.columns.validation.max] - If set to numeric value, the data of the column
 *              will be checked to be less than 'max' value.
 *          @param {RegExp} [options.columns.validation.regExp] - If set to regular expression, the data of the column
 *              will be checked using the regular expression.
 *          @param {function} [options.columns.validation.validatorFn] - If set to function, the data of the column
 *              will be checked using the result of the custom validator.
 *          @param {boolean} [options.columns.validation.unique] - If set to true, check the uniqueness on the data of the column.
 *          @param {string} [options.columns.defaultValue] - The default value to be shown when the column
 *              doesn't have a value.
 *          @param {function|string} [options.columns.formatter] - The function that formats the value of the cell.
 *              The return value of the function will be shown as the value of the cell. If set to 'listItemText',
 *              the value will be shown the text.
 *          @param {boolean} [options.columns.escapeHTML=false] - If set to true, the value of the cell
 *              will be encoded as HTML entities.
 *          @param {boolean} [options.columns.ignored=false] - If set to true, the value of the column will be
 *               ignored when setting up the list of modified rows.
 *          @param {boolean} [options.columns.sortable=false] - If set to true, sort button will be shown on
 *              the right side of the column header, which executes the sort action when clicked.
 *          @param {string} [options.columns.sortingType='asc'] - If set to 'desc', will execute descending sort initially
 *              when sort button is clicked.
 *          @param {function} [options.columns.comparator] - The custom comparator that sorts the data of the column.
 *              The return value should be same as the result of general 'compareFunction'.
 *          @param {function} [options.columns.onBeforeChange] - The function that will be
 *              called before changing the value of the cell. If stop() method in event object is called,
 *              the changing will be canceled.
 *          @param {function} [options.columns.onAfterChange] - The function that will be
 *              called after changing the value of the cell.
 *          @param {Object} [options.columns.editor] - The object for configuring editing UI.
 *              @param {string|function} [options.columns.editor.type='text'] - The string value that specifies
 *                  the type of the editing UI. Available values are 'text', 'password', 'select', 'radio', 'checkbox'.
 *                  When using the custom editor, sets to the customized renderer constructor.
 *              @param {Object} [options.columns.editor.options] - Option object using editor
 *                  @param {Array} [options.columns.editor.options.listItems] - Specifies the option items for the
 *                       'select', 'radio', 'checkbox' type. The item of the array must contain properties named
 *                       'text' and 'value'. (e.g. [{text: 'option1', value: 1}, {...}])
 *              @param {Object} [options.columns.copyOptions] - Option object for clipboard copying.
 *                  This option is column specific, and overrides the global copyOptions.
 *              @param {boolean} [options.columns.copyOptions.useFormattedValue] - Whether to use
 *                  formatted values or original values as a string to be copied to the clipboard
 *              @param {boolean} [options.columns.copyOptions.useListItemText] - Whether to use
 *                  concatenated text or original values as a string to be copied to the clipboard
 *              @param {function} [options.columns.copyOptions.customValue] - Whether to use
 *                  customized value from "customValue" callback or original values as a string to be copied to the clipboard
 *          @param {Array} [options.columns.relations] - Specifies relation between this and other column.
 *              @param {Array} [options.columns.relations.targetNames] - Array of the names of target columns.
 *              @param {function} [options.columns.relations.disabled] - If returns true, target columns
 *                  will be disabled.
 *              @param {function} [options.columns.relations.editable] - If returns true, target columns
 *                  will be editable.
 *              @param {function} [options.columns.relations.listItems] - The function whose return
 *                  value specifies the option list for the 'select', 'radio', 'checkbox' type.
 *                  The options list of target columns will be replaced with the return value of this function.
 *          @param {string} [options.columns.whiteSpace='nowrap'] - If set to 'normal', the text line is broken
 *              by fitting to the column's width. If set to 'pre', spaces are preserved and the text is braken by
 *              new line characters. If set to 'pre-wrap', spaces are preserved, the text line is broken by
 *              fitting to the column's width and new line characters. If set to 'pre-line', spaces are merged,
 *              the text line is broken by fitting to the column's width and new line characters.(This option will be deprecated)
 *          @param {boolean} [options.columns.rowSpan=false] - If set to true, apply dynamic rowspan to column data.
 *              If it is not a top-level relational column of a column relationship or the grid has tree data, dynamic rowspan is not applied.
 *          @param {HTMLElement} [options.columns.customHeader] - If set HTML element, the element will render in header cell.
 *              If set without header property, the text content of element will be set to header property.
 *      @param {Object} [options.summary] - The object for configuring summary area.
 *          @param {number} [options.summary.height] - The height of the summary area.
 *          @param {string} [options.summary.position='bottom'] - The position of the summary area. ('bottom', 'top')
 *          @param {(string|Object)} [options.summary.defaultContent]
 *              The configuring of summary cell for every column.
 *              This options can be overriden for each column by columnContent options.
 *              If type is string, the value is used as HTML of summary cell for every columns
 *              without auto-calculation.
 *              @param {boolean} [options.summary.defaultContent.useAutoSummary=true]
 *                  If set to true, the summary value of every column is served as a parameter to the template
 *                  function whenever data is changed.
 *              @param {function} [options.summary.defaultContent.template] - Template function which returns the
 *                  content(HTML) of the column of the summary. This function takes an K-V object as a parameter
 *                  which contains a summary values keyed by 'sum', 'avg', 'min', 'max' and 'cnt'.
 *          @param {Object} [options.summary.columnContent]
 *              The configuring of summary cell for each column.
 *              Sub options below are keyed by each column name.
 *              If type of value of this object is string, the value is used as HTML of summary cell for
 *              the column without auto-calculation.
 *              @param {boolean} [options.summary.columnContent.useAutoSummary=true]
 *                  If set to true, the summary value of each column is served as a parameter to the template
 *                  function whenever data is changed.
 *              @param {function} [options.summary.columnContent.template] - Template function which returns the
 *                  content(HTML) of the column of the summary. This function takes an K-V object as a parameter
 *                  which contains a summary values keyed by 'sum', 'avg', 'min', 'max' and 'cnt'.
 *      @param {boolean} [options.usageStatistics=true] Send the hostname to google analytics.
 *          If you do not want to send the hostname, this option set to false.
 *      @param {function} [options.onGridMounted] - The function that will be called after rendering the grid.
 *      @param {function} [options.onGridUpdated] - The function that will be called after updating the all data of the grid and rendering the grid.
 *      @param {function} [options.onGridBeforeDestroy] - The function that will be called before destroying the grid.
 *      @param {boolean} [options.draggable] - Whether to enable to drag the row for changing the order of rows.
 *      @param {Array} [options.contextMenu] - Option array for the context menu.
 *      @param {string} [options.moveDirectionOnEnter] - Define moving focus direction on Enter. If not set, the focus does not move.
 */
var Grid = /** @class */ (function () {
    function Grid(options) {
        var _this = this;
        var el = options.el, _a = options.usageStatistics, usageStatistics = _a === void 0 ? true : _a;
        var id = instance_1.register(this);
        var store = create_1.createStore(id, options);
        var dispatch = create_2.createDispatcher(store);
        var eventBus = eventBus_1.createEventBus(id);
        var dataProvider = serverSideDataProvider_1.createProvider(store, dispatch, options.data);
        var dataManager = modifiedDataManager_1.createManager();
        var paginationManager = paginationManager_1.createPaginationManager();
        this.el = el;
        this.store = store;
        this.dispatch = dispatch;
        this.eventBus = eventBus;
        this.dataProvider = dataProvider;
        this.dataManager = dataManager;
        this.paginationManager = paginationManager;
        this.usageStatistics = usageStatistics;
        if (this.usageStatistics) {
            googleAnalytics_1.sendHostname();
        }
        instance_1.registerDataSources(id, dataProvider, dataManager, paginationManager);
        if (!manager_1.default.isApplied()) {
            manager_1.default.apply('default');
        }
        if (Array.isArray(options.data)) {
            this.dataManager.setOriginData(options.data);
        }
        var lifeCycleEvent = common_1.pick(options, 'onGridMounted', 'onGridBeforeDestroy', 'onGridUpdated');
        Object.keys(lifeCycleEvent).forEach(function (eventName) {
            _this.eventBus.on(eventName, lifeCycleEvent[eventName]);
        });
        this.gridEl = preact_1.render(preact_1.h(root_1.Root, { store: store, dispatch: dispatch, rootElement: el }), el);
        this.dispatch('setColumnWidthsByText');
        this.dispatch('updateRowSpan');
    }
    /**
     * Apply theme to all grid instances with the preset options of a given name.
     * @static
     * @param {string} presetName - preset theme name. Available values are 'default', 'striped' and 'clean'.
     * @param {Object} [extOptions] - if exist, extend preset options with this object.
     *     @param {Object} [extOptions.outline] - Styles for the table outline.
     *         @param {string} [extOptions.outline.border] - Color of the table outline.
     *         @param {boolean} [extOptions.outline.showVerticalBorder] - Whether vertical outlines of
     *             the table are visible.
     *     @param {Object} [extOptions.selection] - Styles for a selection layer.
     *         @param {string} [extOptions.selection.background] - Background color of a selection layer.
     *         @param {string} [extOptions.selection.border] - Border color of a selection layer.
     *     @param {Object} [extOptions.scrollbar] - Styles for scrollbars.
     *         @param {string} [extOptions.scrollbar.border] - Border color of scrollbars.
     *         @param {string} [extOptions.scrollbar.background] - Background color of scrollbars.
     *         @param {string} [extOptions.scrollbar.emptySpace] - Color of extra spaces except scrollbar.
     *         @param {string} [extOptions.scrollbar.thumb] - Color of thumbs in scrollbars.
     *         @param {string} [extOptions.scrollbar.active] - Color of arrows(for IE) or
     *              thumb:hover(for other browsers) in scrollbars.
     *     @param {Object} [extOptions.frozenBorder] - Styles for a frozen border.
     *         @param {string} [extOptions.frozenBorder.border] - Border color of a frozen border.
     *     @param {Object} [extOptions.area] - Styles for the table areas.
     *         @param {Object} [extOptions.area.header] - Styles for the header area in the table.
     *             @param {string} [extOptions.area.header.background] - Background color of the header area
     *                 in the table.
     *             @param {string} [extOptions.area.header.border] - Border color of the header area
     *                 in the table.
     *         @param {Object} [extOptions.area.body] - Styles for the body area in the table.
     *             @param {string} [extOptions.area.body.background] - Background color of the body area
     *                 in the table.
     *         @param {Object} [extOptions.area.summary] - Styles for the summary area in the table.
     *             @param {string} [extOptions.area.summary.background] - Background color of the summary area
     *                 in the table.
     *             @param {string} [extOptions.area.summary.border] - Border color of the summary area
     *                 in the table.
     *     @param {Object} [extOptions.row] - Styles for the table rows.
     *         @param {Object} [extOptions.row.even] - Styles for even row.
     *             @param {string} [extOptions.row.even.background] - background color of even row.
     *             @param {string} [extOptions.row.even.text] - text color of even row.
     *         @param {Object} [extOptions.row.odd] - Styles for odd row.
     *             @param {string} [extOptions.row.odd.background] - background color of cells in odd row.
     *             @param {string} [extOptions.row.odd.text] - text color of odd row.
     *         @param {Object} [extOptions.row.dummy] - Styles of dummy row.
     *             @param {string} [extOptions.row.dummy.background] - background color of dummy row.
     *         @param {Object} [extOptions.row.hover] - Styles of hovered row.
     *             @param {string} [extOptions.row.hover.background] - background color of hovered row.
     *     @param {Object} [extOptions.cell] - Styles for the table cells.
     *         @param {Object} [extOptions.cell.normal] - Styles for normal cells.
     *             @param {string} [extOptions.cell.normal.background] - Background color of normal cells.
     *             @param {string} [extOptions.cell.normal.border] - Border color of normal cells.
     *             @param {string} [extOptions.cell.normal.text] - Text color of normal cells.
     *             @param {boolean} [extOptions.cell.normal.showVerticalBorder] - Whether vertical borders of
     *                 normal cells are visible.
     *             @param {boolean} [extOptions.cell.normal.showHorizontalBorder] - Whether horizontal borders of
     *                 normal cells are visible.
     *         @param {Object} [extOptions.cell.header] - Styles for header cells.
     *             @param {string} [extOptions.cell.header.background] - Background color of header cells.
     *             @param {string} [extOptions.cell.header.border] - border color of header cells.
     *             @param {string} [extOptions.cell.header.text] - text color of header cells.
     *             @param {boolean} [extOptions.cell.header.showVerticalBorder] - Whether vertical borders of
     *                 header cells are visible.
     *             @param {boolean} [extOptions.cell.header.showHorizontalBorder] - Whether horizontal borders of
     *                 header cells are visible.
     *         @param {Object} [extOptions.cell.selectedHeader] - Styles for selected header cells.
     *             @param {string} [extOptions.cell.selectedHeader.background] - background color of selected header cells.
     *         @param {Object} [extOptions.cell.rowHeader] - Styles for row's header cells.
     *             @param {string} [extOptions.cell.rowHeader.background] - Background color of row's header cells.
     *             @param {string} [extOptions.cell.rowHeader.border] - border color of row's header cells.
     *             @param {string} [extOptions.cell.rowHeader.text] - text color of row's header cells.
     *             @param {boolean} [extOptions.cell.rowHeader.showVerticalBorder] - Whether vertical borders of
     *                 row's header cells are visible.
     *             @param {boolean} [extOptions.cell.rowHeader.showHorizontalBorder] - Whether horizontal borders of
     *                 row's header cells are visible.
     *         @param {Object} [extOptions.cell.selectedRowHeader] - Styles for selected row's header cells.
     *             @param {string} [extOptions.cell.selectedRowHeader.background] - background color of selected row's haed cells.
     *         @param {Object} [extOptions.cell.summary] - Styles for cells in the summary area.
     *             @param {string} [extOptions.cell.summary.background] - Background color of cells in the summary area.
     *             @param {string} [extOptions.cell.summary.border] - border color of cells in the summary area.
     *             @param {string} [extOptions.cell.summary.text] - text color of cells in the summary area.
     *             @param {boolean} [extOptions.cell.summary.showVerticalBorder] - Whether vertical borders of
     *                 cells in the summary area are visible.
     *             @param {boolean} [extOptions.cell.summary.showHorizontalBorder] - Whether horizontal borders of
     *                 cells in the summary area are visible.
     *         @param {Object} [extOptions.cell.focused] - Styles for a focused cell.
     *             @param {string} [extOptions.cell.focused.background] - background color of a focused cell.
     *             @param {string} [extOptions.cell.focused.border] - border color of a focused cell.
     *         @param {Object} [extOptions.cell.focusedInactive] - Styles for a inactive focus cell.
     *             @param {string} [extOptions.cell.focusedInactive.border] - border color of a inactive focus cell.
     *         @param {Object} [extOptions.cell.required] - Styles for required cells.
     *             @param {string} [extOptions.cell.required.background] - background color of required cells.
     *             @param {string} [extOptions.cell.required.text] - text color of required cells.
     *         @param {Object} [extOptions.cell.editable] - Styles for editable cells.
     *             @param {string} [extOptions.cell.editable.background] - background color of the editable cells.
     *             @param {string} [extOptions.cell.editable.text] - text color of the selected editable cells.
     *         @param {Object} [extOptions.cell.disabled] - Styles for disabled cells.
     *             @param {string} [extOptions.cell.disabled.background] - background color of disabled cells.
     *             @param {string} [extOptions.cell.disabled.text] - text color of disabled cells.
     *         @param {Object} [extOptions.cell.invalid] - Styles for invalid cells.
     *             @param {string} [extOptions.cell.invalid.background] - background color of invalid cells.
     *             @param {string} [extOptions.cell.invalid.text] - text color of invalid cells.
     *         @param {Object} [extOptions.cell.currentRow] - Styles for cells in a current row.(deprecated since version 4.4.0)
     *             @param {string} [extOptions.cell.currentRow.background] - background color of cells in a current row.
     *             @param {string} [extOptions.cell.currentRow.text] - text color of cells in a current row.
     *         @param {Object} [extOptions.cell.evenRow] - Styles for cells in even rows.(deprecated since version 4.4.0)
     *             @param {string} [extOptions.cell.evenRow.background] - background color of cells in even rows.
     *             @param {string} [extOptions.cell.evenRow.text] - text color of cells in even rows.
     *         @param {Object} [extOptions.cell.oddRow] - Styles for cells in even rows.(deprecated since version 4.4.0)
     *             @param {string} [extOptions.cell.oddRow.background] - background color of cells in odd rows.
     *             @param {string} [extOptions.cell.oddRow.text] - text color of cells in odd rows.
     *         @param {Object} [extOptions.cell.dummy] - Styles for dummy cells.(deprecated since version 4.4.0)
     *             @param {string} [extOptions.cell.dummy.background] - background color of dummy cells.
     * @example
     * var Grid = tui.Grid; // or require('tui-grid')
     *
     * Grid.applyTheme('striped', {
     *     grid: {
     *         border: '#aaa',
     *         text: '#333'
     *     },
     *     cell: {
     *         disabled: {
     *             text: '#999'
     *         }
     *     }
     * });
     */
    Grid.applyTheme = function (presetName, extOptions) {
        manager_1.default.apply(presetName, extOptions);
    };
    /**
     * Set language
     * @static
     * @param {string} localeCode - Code to set locale messages and
     *     this is the language or language-region combination (ex: en-US)
     * @param {Object} [data] - Messages using in Grid
     * @example
     * var Grid = tui.Grid; // or require('tui-grid')
     *
     * Grid.setLanguage('en'); // default and set English
     * Grid.setLanguage('ko'); // set Korean
     * Grid.setLanguage('en-US', { // set new language
     *      display: {
     *          noData: 'No data.',
     *          loadingData: 'Loading data.',
     *          resizeHandleGuide: 'You can change the width of the column by mouse drag, ' +
     *                              'and initialize the width by double-clicking.'
     *      },
     *      net: {
     *          confirmCreate: 'Are you sure you want to create {{count}} data?',
     *          confirmUpdate: 'Are you sure you want to update {{count}} data?',
     *          confirmDelete: 'Are you sure you want to delete {{count}} data?',
     *          confirmModify: 'Are you sure you want to modify {{count}} data?',
     *          noDataToCreate: 'No data to create.',
     *          noDataToUpdate: 'No data to update.',
     *          noDataToDelete: 'No data to delete.',
     *          noDataToModify: 'No data to modify.',
     *          failResponse: 'An error occurred while requesting data.\nPlease try again.'
     *      }
     * });
     */
    Grid.setLanguage = function (localeCode, data) {
        i18n_1.default.setLanguage(localeCode, data);
    };
    /**
     * Set the width of the dimension.
     * @param {number} width - The width of the dimension
     */
    Grid.prototype.setWidth = function (width) {
        this.dispatch('setWidth', width, false);
    };
    /**
     * Set the height of the dimension.
     * @param {number} height - The height of the dimension
     */
    Grid.prototype.setHeight = function (height) {
        this.dispatch('setHeight', height);
    };
    /**
     * Set the height of body-area.
     * @param {number} bodyHeight - The number of pixel
     */
    Grid.prototype.setBodyHeight = function (bodyHeight) {
        this.dispatch('setBodyHeight', bodyHeight);
    };
    /**
     * Set options for header.
     * @param {Object} options - Options for header
     * @param {number} [options.height] -  The height value
     * @param {Array} [options.complexColumns] - The complex columns info
     */
    Grid.prototype.setHeader = function (_a) {
        var height = _a.height, complexColumns = _a.complexColumns;
        if (height) {
            this.dispatch('setHeaderHeight', height);
        }
        if (complexColumns) {
            this.dispatch('setComplexColumnHeaders', complexColumns);
        }
    };
    /**
     * Set the count of frozen columns.
     * @param {number} count - The count of columns to be frozen
     */
    Grid.prototype.setFrozenColumnCount = function (count) {
        this.dispatch('setFrozenColumnCount', count);
    };
    /**
     * Hide columns
     * @param {...string} arguments - Column names to hide
     */
    Grid.prototype.hideColumn = function (columnName) {
        this.dispatch('hideColumn', columnName);
    };
    /**
     * Show columns
     * @param {...string} arguments - Column names to show
     */
    Grid.prototype.showColumn = function (columnName) {
        this.dispatch('showColumn', columnName);
    };
    /**
     * Select cells or rows by range
     * @param {Object} range - Selection range
     *     @param {Array} [range.start] - Index info of start selection (ex: [rowIndex, columnIndex])
     *     @param {Array} [range.end] - Index info of end selection (ex: [rowIndex, columnIndex])
     */
    Grid.prototype.setSelectionRange = function (range) {
        this.dispatch('setSelection', range);
    };
    /**
     * get Selection range
     * @returns {Object | null} range - Selection range
     *     @returns {Array} [range.start] - Index info of start selection (ex: [rowIndex, columnIndex])
     *     @returns {Array} [range.end] - Index info of end selection (ex: [rowIndex, columnIndex])
     */
    Grid.prototype.getSelectionRange = function () {
        var rangeWithRowHeader = this.store.selection.rangeWithRowHeader;
        if (rangeWithRowHeader) {
            var column = rangeWithRowHeader.column, row = rangeWithRowHeader.row;
            return {
                start: [row[0], column[0]],
                end: [row[1], column[1]],
            };
        }
        return null;
    };
    /**
     * Return data of currently focused cell
     * @returns {number|string} rowKey - The unique key of the row
     * @returns {string} columnName - The name of the column
     * @returns {string} value - The value of the cell
     */
    Grid.prototype.getFocusedCell = function () {
        var _a = this.store.focus, columnName = _a.columnName, rowKey = _a.rowKey;
        var value = null;
        if (rowKey !== null && columnName !== null) {
            value = this.getValue(rowKey, columnName);
        }
        return { rowKey: rowKey, columnName: columnName, value: value };
    };
    /**
     * Remove focus from the focused cell.
     */
    Grid.prototype.blur = function () {
        this.dispatch('setFocusInfo', null, null, false);
    };
    /**
     * Focus to the cell identified by given rowKey and columnName.
     * @param {Number|String} rowKey - rowKey
     * @param {String} columnName - columnName
     * @param {Boolean} [setScroll=true] - if set to true, move scroll position to focused position
     * @returns {Boolean} true if focused cell is changed
     */
    Grid.prototype.focus = function (rowKey, columnName, setScroll) {
        var _this = this;
        if (setScroll === void 0) { setScroll = true; }
        var row = this.getRow(rowKey);
        if (!row || !data_1.getRowHeight(row, this.store.dimension.rowHeight)) {
            return false;
        }
        this.dispatch('setFocusInfo', rowKey, columnName, true);
        if (setScroll) {
            // Use setTimeout to wait until the DOM element is actually mounted or updated.
            // For example, when expands the tree row at bottom of the grid area with scroll,
            // grid needs to wait for mounting the expanded tree DOM element to detect the accurate scrolling position.
            setTimeout(function () {
                _this.dispatch('setScrollToFocus');
            });
        }
        return true;
    };
    /**
     * Focus to the cell identified by given rowIndex and columnIndex.
     * @param {Number} rowIndex - rowIndex
     * @param {Number} columnIndex - columnIndex
     * @param {boolean} [setScroll=true] - if set to true, scroll to focused cell
     * @returns {Boolean} true if success
     */
    Grid.prototype.focusAt = function (rowIndex, columnIndex, setScroll) {
        var _a = data_1.getCellAddressByIndex(this.store, rowIndex, columnIndex), rowKey = _a.rowKey, columnName = _a.columnName;
        if (!common_1.isUndefined(rowKey) && columnName) {
            return this.focus(rowKey, columnName, setScroll);
        }
        return false;
    };
    /**
     * Make view ready to get keyboard input.
     */
    Grid.prototype.activateFocus = function () {
        this.dispatch('setNavigating', true);
    };
    /**
     * Set focus on the cell at the specified index of row and column and starts to edit.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @param {boolean} [setScroll=true] - If set to true, the view will scroll to the cell element.
     */
    Grid.prototype.startEditing = function (rowKey, columnName, setScroll) {
        if (this.focus(rowKey, columnName, setScroll)) {
            if (this.store.focus.rowKey === rowKey && this.store.focus.columnName === columnName) {
                this.dispatch('startEditing', rowKey, columnName);
            }
        }
    };
    /**
     * Set focus on the cell at the specified index of row and column and starts to edit.
     * @param {number|string} rowIndex - The index of the row
     * @param {string} columnIndex - The index of the column
     * @param {boolean} [setScroll=true] - If set to true, the view will scroll to the cell element.
     */
    Grid.prototype.startEditingAt = function (rowIndex, columnIndex, setScroll) {
        var _a = data_1.getCellAddressByIndex(this.store, rowIndex, columnIndex), rowKey = _a.rowKey, columnName = _a.columnName;
        this.startEditing(rowKey, columnName, setScroll);
    };
    /**
     * Save editing value and finishes to edit.
     */
    Grid.prototype.finishEditing = function (rowKey, columnName, value) {
        // @TODO: should change the function signature as removing all current paramaters.
        // The signature will be as below.
        // ex) finishEditing()
        this.dispatch('saveAndFinishEditing', value);
    };
    /**
     * Cancel the editing.
     */
    Grid.prototype.cancelEditing = function () {
        var editingAddress = this.store.focus.editingAddress;
        if (editingAddress) {
            var rowKey = editingAddress.rowKey, columnName = editingAddress.columnName;
            var value = this.getValue(rowKey, columnName);
            this.dispatch('finishEditing', rowKey, columnName, value, { save: false });
        }
    };
    /**
     * Set the value of the cell identified by the specified rowKey and columnName.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @param {number|string} value - The value to be set
     * @param {boolean} [checkCellState=false] - If set to true, only editable and not disabled cells will be affected.
     */
    Grid.prototype.setValue = function (rowKey, columnName, value, checkCellState) {
        this.dispatch('setValue', rowKey, columnName, value, checkCellState);
    };
    /**
     * Return the value of the cell identified by the rowKey and columnName.
     * @param {number|string} rowKey - The unique key of the target row.
     * @param {string} columnName - The name of the column
     * @returns {number|string|boolean|null} - The value of the cell
     */
    Grid.prototype.getValue = function (rowKey, columnName) {
        var _a;
        var _b = this.store, data = _b.data, column = _b.column, id = _b.id;
        var targetRow = data_1.findRowByRowKey(data, column, id, rowKey, false);
        if (targetRow) {
            return (_a = targetRow[columnName]) !== null && _a !== void 0 ? _a : null;
        }
        return null;
    };
    /**
     * Set the all values in the specified column.
     * @param {string} columnName - The name of the column
     * @param {number|string} columnValue - The value to be set
     * @param {boolean} [checkCellState=false] - If set to true, only editable and not disabled cells will be affected.
     */
    Grid.prototype.setColumnValues = function (columnName, columnValue, checkCellState) {
        this.dispatch('setColumnValues', columnName, columnValue, checkCellState);
    };
    /**
     * Return the HTMLElement of the cell identified by the rowKey and columnName.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @returns {HTMLElement} - The HTMLElement of the cell element
     */
    Grid.prototype.getElement = function (rowKey, columnName) {
        return this.el.querySelector("." + dom_1.cls('cell') + "[" + dom_1.dataAttr.ROW_KEY + "=\"" + rowKey + "\"][" + dom_1.dataAttr.COLUMN_NAME + "=\"" + columnName + "\"]");
    };
    /**
     * Set the HTML string of given column summary.
     * The type of content is the same as the options.summary.columnContent of the constructor.
     * @param {string} columnName - column name
     * @param {string|object} columnContent - HTML string or options object.
     */
    Grid.prototype.setSummaryColumnContent = function (columnName, columnContent) {
        this.dispatch('setSummaryColumnContent', columnName, columnContent);
    };
    /**
     * Return the values of given column summary.
     * If the column name is not specified, all values of available columns are returned.
     * The shape of returning object looks like the example below.
     * @param {string} [columnName] - column name
     * @returns {Object}
     * @example
     * {
     *     sum: 1000,
     *     avg: 200,
     *     max: 300,
     *     min: 50,
     *     cnt: 5,
     *     filtered: {
     *       sum: 1000,
     *       avg: 200,
     *       max: 300,
     *       min: 50,
     *       cnt: 5
     *     }
     * }
     */
    Grid.prototype.getSummaryValues = function (columnName) {
        var summary = this.store.summary;
        var content = summary.summaryColumnContents[columnName];
        if (content && content.useAutoSummary) {
            return summary.summaryValues[columnName];
        }
        return null;
    };
    /**
     * Return a specific column model.
     * @param {string} columnName - The name of the column
     * @returns {Object|null} - A column model.
     */
    Grid.prototype.getColumn = function (columnName) {
        var column = common_1.find(function (_a) {
            var name = _a.name;
            return name === columnName;
        }, this.store.column.allColumns);
        return column ? observable_1.getOriginObject(column) : null;
    };
    /**
     * Return a list of the column model.
     * @returns {Array} - A list of the column model.
     */
    Grid.prototype.getColumns = function () {
        return this.store.column.allColumns
            .filter(function (_a) {
            var name = _a.name;
            return !column_1.isRowHeader(name);
        })
            .map(function (column) { return observable_1.getOriginObject(column); });
    };
    /**
     * Set the list of column model.
     * @param {Array} columns - A new list of column model
     */
    Grid.prototype.setColumns = function (columns) {
        this.dispatch('setColumns', columns);
    };
    /**
     * Set columns title
     * @param {Object} columnsMap - columns map to be change
     * @example
     * {
     *      columnName1: 'title1',
     *      columnName2: 'title2',
     *      columnName3: 'title3'
     * }
     */
    Grid.prototype.setColumnHeaders = function (columnsMap) {
        this.dispatch('changeColumnHeadersByName', columnsMap);
    };
    /**
     * Reset the width of each column by using initial setting of column models.
     * @param {Array.<number>} [widths] - An array of column widths to set. If there's no parameter, it reset auto-resizing column width.
     */
    Grid.prototype.resetColumnWidths = function (widths) {
        if (widths) {
            this.dispatch('resetColumnWidths', widths);
        }
        else {
            this.dispatch('setAutoResizingColumnWidths');
        }
    };
    /**
     * Return a list of all values in the specified column.
     * @param {string} columnName - The name of the column
     * @returns {(Array|string)} - A List of all values in the specified column. (or JSON string of the list)
     */
    Grid.prototype.getColumnValues = function (columnName) {
        return common_1.mapProp(columnName, this.store.data.rawData);
    };
    /**
     * Return the index of the column indentified by the column name.
     * @param {string} columnName - The unique key of the column
     * @returns {number} - The index of the column
     */
    Grid.prototype.getIndexOfColumn = function (columnName) {
        return common_1.findPropIndex('name', columnName, this.store.column.allColumns.filter(function (_a) {
            var name = _a.name;
            return !column_1.isRowHeader(name);
        }));
    };
    /**
     * Check the row identified by the specified rowKey.
     * @param {number|string} rowKey - The unique key of the row
     */
    Grid.prototype.check = function (rowKey) {
        this.dispatch('check', rowKey);
    };
    /**
     * Uncheck the row identified by the specified rowKey.
     * @param {number|string} rowKey - The unique key of the row
     */
    Grid.prototype.uncheck = function (rowKey) {
        this.dispatch('uncheck', rowKey);
    };
    /**
     * Check the rows between the specified rowKeys. If endRowKey is not passed, perform 'check' on the row of startRowKey.
     * @param {number|string} startRowKey - The unique key of the row
     * @param {number|string} [endRowKey] - The unique key of the row
     */
    Grid.prototype.checkBetween = function (startRowKey, endRowKey) {
        this.dispatch('setCheckboxBetween', true, startRowKey, endRowKey);
    };
    /**
     * Uncheck the rows between the specified rowKeys. If endRowKey is not passed, perform 'uncheck' on the row of startRowKey.
     * @param {number|string} startRowKey - The unique key of the row
     * @param {number|string} [endRowKey] - The unique key of the row
     */
    Grid.prototype.uncheckBetween = function (startRowKey, endRowKey) {
        this.dispatch('setCheckboxBetween', false, startRowKey, endRowKey);
    };
    /**
     * Check all rows.
     * @param {boolean} [allPage] - check all rows when using pagination. The default value is 'true'.
     */
    Grid.prototype.checkAll = function (allPage) {
        this.dispatch('checkAll', allPage);
    };
    /**
     * Uncheck all rows.
     * @param {boolean} [allPage] - Uncheck all rows when using pagination. The default value is 'true'.
     */
    Grid.prototype.uncheckAll = function (allPage) {
        this.dispatch('uncheckAll', allPage);
    };
    /**
     * Return a list of the rowKey of checked rows.
     * @returns {Array.<string|number>} - A list of the rowKey.
     */
    Grid.prototype.getCheckedRowKeys = function () {
        var rows = data_1.getCheckedRowInfoList(this.store).rows;
        return rows.map(function (_a) {
            var rowKey = _a.rowKey;
            return rowKey;
        });
    };
    /**
     * Return a list of the checked rows.
     * @returns {Array.<object>} - A list of the checked rows.
     */
    Grid.prototype.getCheckedRows = function () {
        var rows = data_1.getCheckedRowInfoList(this.store).rows;
        return rows.map(function (row) { return observable_1.getOriginObject(row); });
    };
    /**
     * Find rows by conditions
     * @param {Object|Function} conditions - object (key: column name, value: column value) or
     *     function that check the value and returns true/false result to find rows
     * @returns {Array} Row list
     * @example <caption>Conditions type is object.</caption>
     * grid.findRows({
     *     artist: 'Birdy',
     *     price: 10000
     * });
     * @example <caption>Conditions type is function.</caption>
     * grid.findRows((row) => {
     *     return (/b/ig.test(row.artist) && row.price > 10000);
     * });
     */
    Grid.prototype.findRows = function (conditions) {
        return data_1.getConditionalRows(this.store, conditions);
    };
    /**
     * Sort all rows by the specified column.
     * @param {string} columnName - The name of the column to be used to compare the rows
     * @param {boolean} [ascending] - Whether the sort order is ascending.
     *        If not specified, use the negative value of the current order.
     * @param {boolean} [multiple] - Whether using multiple sort
     */
    Grid.prototype.sort = function (columnName, ascending, multiple) {
        if (this.store.data.sortState.useClient) {
            this.dispatch('sort', columnName, ascending, multiple, false);
        }
        else {
            // @TODO: apply multi sort to dataSource
            this.dataProvider.sort(columnName, ascending, false);
        }
    };
    /**
     * If the parameter exists, unsort only column with columnName. If not exist, unsort all rows
     * @param {string} [columnName] - The name of the column to be used to compare the rows
     */
    Grid.prototype.unsort = function (columnName) {
        if (this.store.data.sortState.useClient) {
            this.dispatch('unsort', columnName);
        }
        else {
            this.dataProvider.unsort(columnName);
        }
    };
    /**
     * Get state of the sorted column in rows
     * @returns {{columns: [{columnName: string, ascending: boolean}], useClient: boolean}} Sorted column's state
     */
    Grid.prototype.getSortState = function () {
        return common_1.deepCopy(this.store.data.sortState);
    };
    /**
     * Copy to clipboard
     */
    Grid.prototype.copyToClipboard = function () {
        clipboard_1.execCopy(this.store);
    };
    /**
     * Validate all data and returns the result.
     * Return value is an array which contains only rows which have invalid cell data.
     * @param {Array<number|string>} [rowKeys] - Array of rowKeys to validate.
     *        Validate only for the given rows, but validations that should be performed on all rows, such as unique, may not work correctly.
     * @returns {Array.<Object>} An array of error object
     * @example
     * // return value example
     * [
     *     {
     *         rowKey: 1,
     *         errors: [
     *             {
     *                 columnName: 'c1',
     *                 errorCode: ['REQUIRED'],
     *                 errorInfo: [{ code: 'REQUIRED' }]
     *             },
     *             {
     *                 columnName: 'c2',
     *                 errorCode: ['VALIDATOR_FN'],
     *                 errorInfo: [{ code: 'VALIDATOR_FN', customCode: 'CUSTOM_CODE' }]
     *             }
     *         ]
     *     },
     *     {
     *         rowKey: 3,
     *         errors: [
     *             {
     *                 columnName: 'c2',
     *                 errorCode: ['MIN'],
     *                 errorInfo: [{ code: 'MIN', min: 1000 }]
     *             }
     *         ]
     *     }
     * ]
     */
    Grid.prototype.validate = function (rowKeys) {
        return validation_1.getInvalidRows(this.store, rowKeys);
    };
    /**
     * Enable all rows.
     */
    Grid.prototype.enable = function () {
        this.dispatch('setDisabled', false);
    };
    /**
     * Disable all rows.
     */
    Grid.prototype.disable = function () {
        this.dispatch('setDisabled', true);
    };
    /**
     * Disable the row identified by the rowkey.
     * @param {number|string} rowKey - The unique key of the target row
     * @param {boolean} [withCheckbox] - change including checkbox. The default value is 'true'
     */
    Grid.prototype.disableRow = function (rowKey, withCheckbox) {
        if (withCheckbox === void 0) { withCheckbox = true; }
        this.dispatch('setRowDisabled', true, rowKey, withCheckbox);
    };
    /**
     * Enable the row identified by the rowKey.
     * @param {number|string} rowKey - The unique key of the target row
     * @param {boolean} [withCheckbox] - change including checkbox. The default value is 'true'
     */
    Grid.prototype.enableRow = function (rowKey, withCheckbox) {
        if (withCheckbox === void 0) { withCheckbox = true; }
        this.dispatch('setRowDisabled', false, rowKey, withCheckbox);
    };
    /**
     * Disable the row identified by the specified rowKey to not be able to check.
     * @param {number|string} rowKey - The unique key of the row.
     */
    Grid.prototype.disableRowCheck = function (rowKey) {
        this.dispatch('setRowCheckDisabled', true, rowKey);
    };
    /**
     * Enable the row identified by the rowKey to be able to check.
     * @param {number|string} rowKey - The unique key of the row
     */
    Grid.prototype.enableRowCheck = function (rowKey) {
        this.dispatch('setRowCheckDisabled', false, rowKey);
    };
    /**
     * Disable the column identified by the column name.
     * @param {string} columnName - column name
     */
    Grid.prototype.disableColumn = function (columnName) {
        this.dispatch('setColumnDisabled', true, columnName);
    };
    /**
     * Enable the column identified by the column name.
     * @param {string} columnName - column name
     */
    Grid.prototype.enableColumn = function (columnName) {
        this.dispatch('setColumnDisabled', false, columnName);
    };
    /**
     * Disable the cell identified by the row key and column name.
     * @param {number|string} rowKey - The unique key of the row.
     * @param {string} columnName - column name
     */
    Grid.prototype.disableCell = function (rowKey, columnName) {
        this.dispatch('setCellDisabled', true, rowKey, columnName);
    };
    /**
     * Enable the cell identified by the row key and column name.
     * @param {number|string} rowKey - The unique key of the row.
     * @param {string} columnName - column name
     */
    Grid.prototype.enableCell = function (rowKey, columnName) {
        this.dispatch('setCellDisabled', false, rowKey, columnName);
    };
    /**
     * Insert the new row with specified data to the end of table.
     * @param {Object} [row] - The data for the new row
     * @param {Object} [options] - Options
     * @param {number} [options.at] - The index at which new row will be inserted
     * @param {boolean} [options.extendPrevRowSpan] - If set to true and the previous row at target index
     *        has a rowspan data, the new row will extend the existing rowspan data.
     * @param {boolean} [options.focus] - If set to true, move focus to the new row after appending
     * @param {number|string} [options.parentRowKey] - Deprecated: Tree row key of the parent which appends given rows
     */
    Grid.prototype.appendRow = function (row, options) {
        if (row === void 0) { row = {}; }
        if (options === void 0) { options = {}; }
        var treeColumnName = this.store.column.treeColumnName;
        if (treeColumnName) {
            var offset = options.at, focus = options.focus, parentRowKey = options.parentRowKey;
            this.dispatch('appendTreeRow', row, { offset: offset, focus: focus, parentRowKey: parentRowKey });
        }
        else {
            this.dispatch('appendRow', row, options);
        }
        if (options.focus) {
            var rowIdx = common_1.isUndefined(options.at) ? this.getRowCount() - 1 : options.at;
            this.focusAt(rowIdx, 0);
        }
    };
    /**
     * Insert the new row with specified data to the beginning of table.
     * @param {Object} [row] - The data for the new row
     * @param {Object} [options] - Options
     * @param {boolean} [options.focus] - If set to true, move focus to the new row after appending
     */
    Grid.prototype.prependRow = function (row, options) {
        if (options === void 0) { options = {}; }
        this.appendRow(row, tslib_1.__assign(tslib_1.__assign({}, options), { at: 0 }));
    };
    /**
     * Remove the row identified by the specified rowKey.
     * @param {number|string} rowKey - The unique key of the row
     * @param {boolean} [options.removeOriginalData] - If set to true, the original data will be removed.
     * @param {boolean} [options.keepRowSpanData] - If set to true, the value of the merged cells will not be
     *     removed although the target is first cell of them.
     */
    Grid.prototype.removeRow = function (rowKey, options) {
        if (options === void 0) { options = {}; }
        var treeColumnName = this.store.column.treeColumnName;
        if (treeColumnName) {
            this.removeTreeRow(rowKey);
        }
        else {
            this.dispatch('removeRow', rowKey, options);
        }
    };
    /**
     * Remove the rows identified by the specified rowKeys.
     * @param {Array<RowKey>} rowKeys - The array of unique keys of the row
     */
    Grid.prototype.removeRows = function (rowKeys) {
        var removeRowInfoList = data_1.getRemoveRowInfoList(this.store, rowKeys);
        var removeRowsCount = removeRowInfoList.rows.length;
        if (removeRowsCount > 0) {
            this.dispatch('removeRows', removeRowInfoList);
        }
    };
    /**
     * Return the object that contains all values in the specified row.
     * @param {number|string} rowKey - The unique key of the target row
     * @returns {Object} - The object that contains all values in the row.
     */
    Grid.prototype.getRow = function (rowKey) {
        return this.getRowAt(this.getIndexOfRow(rowKey));
    };
    /**
     * Return the object that contains all values in the row at specified index.
     * @param {number} rowIdx - The index of the row
     * @returns {Object} - The object that contains all values in the row.
     */
    Grid.prototype.getRowAt = function (rowIdx) {
        var row = this.store.data.rawData[rowIdx];
        return row ? observable_1.getOriginObject(row) : null;
    };
    /**
     * Return the index of the row indentified by the rowKey.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {number} - The index of the row
     */
    Grid.prototype.getIndexOfRow = function (rowKey) {
        var _a = this.store, data = _a.data, column = _a.column, id = _a.id;
        return data_1.findIndexByRowKey(data, column, id, rowKey, false);
    };
    /**
     * Return a list of all rows.
     * @returns {Array} - A list of all rows
     */
    Grid.prototype.getData = function () {
        return this.store.data.rawData.map(function (row) { return data_1.getOmittedInternalProp(row); });
    };
    /**
     * Return a list of filtered rows.
     * @returns {Array} - A list of filtered rows
     */
    Grid.prototype.getFilteredData = function () {
        return this.store.data.filteredRawData.map(function (row) { return data_1.getOmittedInternalProp(row); });
    };
    /**
     * Return the total number of the rows.
     * @returns {number} - The total number of the rows
     */
    Grid.prototype.getRowCount = function () {
        return this.store.data.rawData.length;
    };
    /**
     * Remove all rows.
     */
    Grid.prototype.clear = function () {
        this.dispatch('clearData');
    };
    /**
     * Replace all rows with the specified list. This will not change the original data.
     * @param {Array} data - A list of new rows
     * @param {Object} [options] - Options
     *     @param {Object} [options.sortState] - If set the sortState, the sort state will be applied when the new rows are set.
     *       It is recommended that you do not use it unless you are getting the sorted data by communicating with the server without DataSource.
     *         @param {string} [options.sortState.columnName] - Target column name.
     *         @param {boolean} [options.sortState.ascending] - The ascending state of specific column which will apply to the grid.
     *         @param {boolean} [options.sortState.multiple] - Whether to use multiple sorting.
     *     @param {Object} [options.filterState] - If set the filterState, the filter state will be applied when the new rows are set.
     *       It is recommended that you do not use it unless you are getting the filtered data by communicating with the server without DataSource.
     *         @param {string} [options.filterState.columnName] - Target column name.
     *         @param {Object} [options.filterState.columnFilterState] - The column filter state of column which will apply to the grid.
     *             @param {string} [options.filterState.columnFilterState.code] - Code for column filter(ex. 'eq', 'gt').
     *             @param {string} [options.filterState.columnFilterState.value] - Input value for column filter.
     *     @param {Object} [options.pageState] - If set the pageState, the pagination state will be applied when the new rows are set.
     *       It is recommended that you do not use it unless you are getting the paginated data by communicating with the server without DataSource.
     *         @param {number} [options.pageState.page] - Target page number.
     *         @param {number} [options.pageState.totalCount] - The total pagination count.
     *         @param {number} [options.pageState.perPage] - Number of rows per page.
     */
    Grid.prototype.resetData = function (data, options) {
        if (options === void 0) { options = {}; }
        this.dispatch('resetData', data, options);
    };
    /**
     * Add the specified css class to cell element identified by the rowKey and className
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @param {string} className - The css class name to add
     */
    Grid.prototype.addCellClassName = function (rowKey, columnName, className) {
        this.dispatch('addCellClassName', rowKey, columnName, className);
    };
    /**
     * Add the specified css class to all cell elements in the row identified by the rowKey
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} className - The css class name to add
     */
    Grid.prototype.addRowClassName = function (rowKey, className) {
        this.dispatch('addRowClassName', rowKey, className);
    };
    /**
     * Remove the specified css class from the cell element indentified by the rowKey and columnName.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @param {string} className - The css class name to be removed
     */
    Grid.prototype.removeCellClassName = function (rowKey, columnName, className) {
        this.dispatch('removeCellClassName', rowKey, columnName, className);
    };
    /**
     * Remove the specified css class from all cell elements in the row identified by the rowKey.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} className - The css class name to be removed
     */
    Grid.prototype.removeRowClassName = function (rowKey, className) {
        this.dispatch('removeRowClassName', rowKey, className);
    };
    /**
     * Return a list of class names of specific cell.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @returns {Array} - A list of class names
     */
    Grid.prototype.getCellClassName = function (rowKey, columnName) {
        var _a;
        var targetRow = this.getRow(rowKey);
        var isExistColumnName = this.store.column.allColumns.some(function (_a) {
            var name = _a.name;
            return name === columnName;
        });
        if (!common_1.isNil(targetRow) && isExistColumnName) {
            var _b = targetRow._attributes.className, row = _b.row, column = _b.column;
            return tslib_1.__spreadArrays(row, ((_a = column[columnName]) !== null && _a !== void 0 ? _a : []));
        }
        return [];
    };
    /**
     * Return a list of class names of specific row.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {Array} - A list of class names
     */
    Grid.prototype.getRowClassName = function (rowKey) {
        var targetRow = this.getRow(rowKey);
        return common_1.isNil(targetRow) ? [] : targetRow._attributes.className.row;
    };
    /**
     * Add custom event to grid.
     * @param {string} eventName - custom event name
     * @param {function} fn - event handler
     */
    Grid.prototype.on = function (eventName, fn) {
        this.eventBus.on(eventName, fn);
    };
    /**
     * Remove custom event to grid.
     * @param {string} eventName - custom event name
     * @param {function} fn - event handler
     */
    Grid.prototype.off = function (eventName, fn) {
        this.eventBus.off(eventName, fn);
    };
    /**
     * Return an instance of tui.Pagination.
     * @deprecated
     * @returns {tui.Pagination}
     */
    Grid.prototype.getPagination = function () {
        return this.paginationManager.getPagination();
    };
    /**
     * Set number of rows per page and reload current page
     * @param {number} perPage - Number of rows per page
     * @param {Params} data - Data(parameters) to send to the server
     */
    Grid.prototype.setPerPage = function (perPage, data) {
        var pagination = this.getPagination();
        if (pagination) {
            var pageOptions = this.store.data.pageOptions;
            if (pageOptions.useClient) {
                this.dispatch('updatePageOptions', { perPage: perPage, page: 1 });
                this.dispatch('updateHeights');
            }
            else {
                this.readData(1, tslib_1.__assign(tslib_1.__assign({}, data), { perPage: perPage }));
            }
        }
    };
    /**
     * Return true if there are at least one row modified.
     * @returns {boolean} - True if there are at least one row modified.
     */
    Grid.prototype.isModified = function () {
        return this.dataManager.isModified();
    };
    /**
     * Return the object that contains the lists of changed data compared to the original data.
     * The object has properties 'createdRows', 'updatedRows', 'deletedRows'.
     * @param {Object} [options] Options
     *     @param {boolean} [options.checkedOnly=false] - If set to true, only checked rows will be considered.
     *     @param {boolean} [options.withRawData=false] - If set to true, the data will contains
     *         the row data for internal use.
     *     @param {boolean} [options.rowKeyOnly=false] - If set to true, only keys of the changed
     *         rows will be returned.
     *     @param {Array} [options.ignoredColumns] - A list of column name to be excluded.
     * @returns {{createdRows: Array, updatedRows: Array, deletedRows: Array}} - Object that contains the result list.
     */
    Grid.prototype.getModifiedRows = function (options) {
        if (options === void 0) { options = {}; }
        var ignoredColumns = options.ignoredColumns;
        var originIgnoredColumns = this.store.column.ignoredColumns;
        options.ignoredColumns = Array.isArray(ignoredColumns)
            ? ignoredColumns.concat(originIgnoredColumns)
            : originIgnoredColumns;
        return this.dataManager.getAllModifiedData(options);
    };
    /**
     * Request 'readData' to the server. The last requested data will be extended with new data.
     * @param {Number} page - Page number
     * @param {Object} data - Data(parameters) to send to the server
     * @param {Boolean} resetData - If set to true, last requested data will be ignored.
     */
    Grid.prototype.readData = function (page, data, resetData) {
        if (data && data.sortColumn) {
            this.dataProvider.sort(data.sortColumn, data.sortAscending, false);
        }
        else {
            this.dataProvider.readData(page, data, resetData);
        }
    };
    /**
     * Send request to server to sync data
     * @param {String} requestType - 'createData|updateData|deleteData|modifyData'
     * @param {object} options - Options
     *      @param {String} [options.url] - URL to send the request
     *      @param {String} [options.method] - method to send the request
     *      @param {boolean} [options.checkedOnly=false] - Whether the request param only contains checked rows
     *      @param {boolean} [options.modifiedOnly=true] - Whether the request param only contains modified rows
     *      @param {boolean} [options.showConfirm=true] - Whether to show confirm dialog before sending request
     *      @param {boolean} [options.withCredentials=false] - Use withCredentials flag of XMLHttpRequest for ajax requests if true
     */
    Grid.prototype.request = function (requestType, options) {
        if (options === void 0) { options = {}; }
        this.dataProvider.request(requestType, options);
    };
    /**
     * Request 'readData' with last requested data.
     */
    Grid.prototype.reloadData = function () {
        this.dataProvider.reloadData();
    };
    /**
     * Restore the data to the original data.
     * (Original data is set by {@link Grid#resetData|resetData}
     */
    Grid.prototype.restore = function () {
        this.resetData(this.dataManager.getOriginData());
    };
    /**
     * Insert the new tree row with specified data.
     * @param {Object} [row] - The tree data for the new row
     * @param {Object} [options] - Options
     * @param {number|string} [options.parentRowKey] - Tree row key of the parent which appends given rows
     * @param {number} [options.offset] - The offset value to insert new tree row
     * @param {boolean} [options.focus] - If set to true, move focus to the new tree row after appending
     */
    Grid.prototype.appendTreeRow = function (row, options) {
        if (row === void 0) { row = {}; }
        if (options === void 0) { options = {}; }
        var treeColumnName = this.store.column.treeColumnName;
        var parentRowKey = options.parentRowKey;
        if (!treeColumnName || common_1.isUndefined(parentRowKey)) {
            return;
        }
        this.dispatch('appendTreeRow', row, options);
        if (options.focus) {
            var offset = options.offset;
            var childRows = tree_1.getChildRows(this.store, parentRowKey);
            if (childRows.length) {
                var rowKey = (common_1.isUndefined(offset)
                    ? childRows[childRows.length - 1]
                    : childRows[offset]).rowKey;
                var rowIdx = this.getIndexOfRow(rowKey);
                this.focusAt(rowIdx, 0);
            }
        }
    };
    /**
     * Remove the tree row identified by the specified rowKey.
     * @param {number|string} rowKey - The unique key of the row
     */
    Grid.prototype.removeTreeRow = function (rowKey) {
        var treeColumnName = this.store.column.treeColumnName;
        if (treeColumnName) {
            this.dispatch('removeTreeRow', rowKey);
        }
    };
    /**
     * Expand tree row.
     * @param {number|string} rowKey - The unique key of the row
     * @param {boolean} recursive - true for recursively expand all descendant
     */
    Grid.prototype.expand = function (rowKey, recursive) {
        this.dispatch('expandByRowKey', rowKey, recursive);
    };
    /**
     * Expand all tree row.
     */
    Grid.prototype.expandAll = function () {
        this.dispatch('expandAll');
    };
    /**
     * Expand tree row.
     * @param {number|string} rowKey - The unique key of the row
     * @param {boolean} recursive - true for recursively expand all descendant
     */
    Grid.prototype.collapse = function (rowKey, recursive) {
        this.dispatch('collapseByRowKey', rowKey, recursive);
    };
    /**
     * Collapse all tree row.
     */
    Grid.prototype.collapseAll = function () {
        this.dispatch('collapseAll');
    };
    /**
     * Get the parent of the row which has the given row key.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {Object} - the parent row
     */
    Grid.prototype.getParentRow = function (rowKey) {
        return tree_1.getParentRow(this.store, rowKey, true);
    };
    /**
     * Get the children of the row which has the given row key.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {Array.<Object>} - the children rows
     */
    Grid.prototype.getChildRows = function (rowKey) {
        return tree_1.getChildRows(this.store, rowKey, true);
    };
    /**
     * Get the ancestors of the row which has the given row key.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {Array.<TreeRow>} - the ancestor rows
     */
    Grid.prototype.getAncestorRows = function (rowKey) {
        return tree_1.getAncestorRows(this.store, rowKey);
    };
    /**
     * Get the descendants of the row which has the given row key.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {Array.<Object>} - the descendant rows
     */
    Grid.prototype.getDescendantRows = function (rowKey) {
        return tree_1.getDescendantRows(this.store, rowKey);
    };
    /**
     * Get the depth of the row which has the given row key.
     * @param {number|string} rowKey - The unique key of the row
     * @returns {number} - the depth
     */
    Grid.prototype.getDepth = function (rowKey) {
        var _a = this.store, data = _a.data, column = _a.column, id = _a.id;
        var rawData = data.rawData;
        var row = data_1.findRowByRowKey(data, column, id, rowKey);
        return row ? tree_1.getDepth(rawData, row) : 0;
    };
    /**
     * Return the rowspan data of the cell identified by the rowKey and columnName.
     * @param {number|string} rowKey - The unique key of the row
     * @param {string} columnName - The name of the column
     * @returns {Object} - Row span data
     */
    Grid.prototype.getRowSpanData = function (rowKey, columnName) {
        return rowSpan_1.getRowSpanByRowKey(rowKey, columnName, this.store.data.rawData);
    };
    /**
     * reset original data to current data.
     * (Original data is set by {@link Grid#resetData|resetData}
     */
    Grid.prototype.resetOriginData = function () {
        this.dataManager.setOriginData(this.store.data.rawData);
    };
    /** Remove all checked rows.
     * @param {boolean} [showConfirm] - If set to true, confirm message will be shown before remove.
     * @returns {boolean} - True if there's at least one row removed.
     */
    Grid.prototype.removeCheckedRows = function (showConfirm) {
        var checkedRowInfoList = data_1.getCheckedRowInfoList(this.store);
        var deletedCount = checkedRowInfoList.rows.length;
        var confirmMessage = message_1.getConfirmMessage('DELETE', deletedCount);
        if (deletedCount > 0 && (!showConfirm || confirm(confirmMessage))) {
            this.dispatch('removeRows', checkedRowInfoList);
            return true;
        }
        return false;
    };
    /**
     * Refresh the layout view. Use this method when the view was rendered while hidden.
     */
    Grid.prototype.refreshLayout = function () {
        var containerEl = this.el.querySelector("." + dom_1.cls('container'));
        var parentElement = this.el.parentElement;
        this.dispatch('refreshLayout', containerEl, parentElement);
    };
    /**
     * Destroy the instance.
     */
    Grid.prototype.destroy = function () {
        preact_1.render('', this.el, this.gridEl);
        tree_2.clearTreeRowKeyMap(this.store.id);
        for (var key in this) {
            if (common_1.hasOwnProp(this, key)) {
                delete this[key];
            }
        }
    };
    /**
     * Set the option of column filter.
     * @param {string} columnName - columnName
     * @param {string | FilterOpt} filterOpt - filter type
     */
    Grid.prototype.setFilter = function (columnName, filterOpt) {
        this.dispatch('setFilter', columnName, filterOpt);
    };
    /**
     * Get filter state.
     * @returns {Array.<FilterState>} - filter state
     */
    Grid.prototype.getFilterState = function () {
        // @TODO: unify the structure to ResetOptions.filterState type definition
        return filter_2.getFilterState(this.store);
    };
    /**
     * Filter the data.
     * @param {string} columnName - column name to filter
     * @param {Array.<FilterState>} state - filter state
     * @example
     * grid.filter('name', [{code: 'eq', value: 3}, {code: 'eq', value: 4}]);
     */
    Grid.prototype.filter = function (columnName, state) {
        var filter = this.store.column.allColumnMap[columnName].filter;
        if (filter) {
            var type_1 = filter.type, operator = filter.operator;
            var conditionFn = state.map(function (_a) {
                var code = _a.code, value = _a.value;
                return filter_1.getFilterConditionFn(code, value, type_1);
            });
            this.dispatch('filter', columnName, filter_1.composeConditionFn(conditionFn, operator), state);
        }
    };
    /**
     * Remove filter state of specific column.
     * @param {string} columnName - column name to unfilter
     */
    Grid.prototype.unfilter = function (columnName) {
        this.dispatch('unfilter', columnName);
    };
    /**
     * Add class name to all cell data of specific column.
     * @param {string} columnName - column name to add className
     * @param {string} className - class name
     */
    Grid.prototype.addColumnClassName = function (columnName, className) {
        this.dispatch('addColumnClassName', columnName, className);
    };
    /**
     * Remove class name to all cell data of specific column.
     * @param {string} columnName - column name to add className
     * @param {string} className - class name
     */
    Grid.prototype.removeColumnClassName = function (columnName, className) {
        this.dispatch('removeColumnClassName', columnName, className);
    };
    /**
     * Return a list of class names of specific column.
     * @param {string} columnName - The name of the column
     * @returns {Array} - A list of class names
     */
    Grid.prototype.getColumnClassName = function (columnName) {
        var rawData = this.store.data.rawData;
        var classNamesOfFirstRow = rawData[0]._attributes.className.column[columnName];
        if (common_1.isEmpty(classNamesOfFirstRow)) {
            return [];
        }
        return rawData.slice(1).reduce(function (acc, row, _, arr) {
            var classNames = row._attributes.className.column[columnName];
            if (common_1.isEmpty(classNames) || common_1.isEmpty(acc)) {
                arr.splice(0);
                return [];
            }
            return acc.filter(function (className) { return common_1.includes(classNames, className); });
        }, classNamesOfFirstRow);
    };
    /**
     * Set new data to the row identified by the specified rowKey.
     * @param {number|string} rowKey - The unique key of the row
     * @param {object} row - The object that contains all values in the row.
     */
    Grid.prototype.setRow = function (rowKey, row) {
        var _a = this.store, data = _a.data, column = _a.column, id = _a.id;
        var rowIndex = data_1.findIndexByRowKey(data, column, id, rowKey, false);
        this.dispatch('setRow', rowIndex, row);
    };
    /**
     * Set new data to the all rows identified by the specified rowKey.
     * Use setRows for a lot of data, as using setRow can cause performance issues.
     * @param {object} rows - The object that contains all values in the row with rowKey.
     */
    Grid.prototype.setRows = function (rows) {
        this.dispatch('setRows', rows);
    };
    /**
     * Move the row identified by the specified rowKey to target index.
     * Use setRows for a lot of data, as using setRow can cause performance issues.
     * If data is sorted or filtered, this couldn't be used.
     * @param {number|string} rowKey - The unique key of the row
     * @param {number} targetIndex - Target index for moving
     * @param {Object} [options] - Options
     * @param {number} [options.appended] - This option for only tree data. Whether the row is appended to other row as the child.
     */
    Grid.prototype.moveRow = function (rowKey, targetIndex, options) {
        if (options === void 0) { options = { appended: false }; }
        var _a = this.store, column = _a.column, data = _a.data;
        if (column.treeColumnName) {
            var moveToLast = false;
            if (!options.appended) {
                if (targetIndex === data.rawData.length - 1) {
                    moveToLast = true;
                }
                else if (this.getIndexOfRow(rowKey) < targetIndex) {
                    targetIndex += 1;
                }
            }
            this.dispatch('moveTreeRow', rowKey, targetIndex, tslib_1.__assign(tslib_1.__assign({}, options), { moveToLast: moveToLast }));
        }
        else {
            this.dispatch('moveRow', rowKey, targetIndex);
        }
        this.dispatch('updateRowSpan');
    };
    /**
     * Set parameters to be sent with the request to communicate with the server.
     * @param {Object} params - parameters to send to the server
     */
    Grid.prototype.setRequestParams = function (params) {
        this.dataProvider.setRequestParams(params);
    };
    /**
     * clear the modified data that is returned as the result of 'getModifiedRows' method.
     * If the 'type' parameter is undefined, all modified data is cleared.
     * @param {string} type - The modified type
     */
    Grid.prototype.clearModifiedData = function (type) {
        if (type) {
            this.dataManager.clear(type);
        }
        else {
            this.dataManager.clearAll();
        }
    };
    /**
     * append rows.
     * @param {Array} data - A list of new rows
     */
    Grid.prototype.appendRows = function (data) {
        this.dispatch('appendRows', data);
    };
    /**
     * Return the formatted value of the cell identified by the rowKey and columnName.
     * @param {number|string} rowKey - The unique key of the target row.
     * @param {string} columnName - The name of the column
     * @returns {string|null} - The formatted value of the cell
     */
    Grid.prototype.getFormattedValue = function (rowKey, columnName) {
        return data_1.getFormattedValue(this.store, rowKey, columnName);
    };
    /**
     * Set total count of items for calculating the pagination.
     * @param {number} totalCount - total count
     */
    Grid.prototype.setPaginationTotalCount = function (totalCount) {
        this.dispatch('updatePageOptions', { totalCount: totalCount });
    };
    /**
     * Get total count of items with the current pagination
     * @returns {number} - total count
     */
    Grid.prototype.getPaginationTotalCount = function () {
        return this.store.data.pageOptions.totalCount;
    };
    /**
     * Export a file in the specified format
     * @param {string} format - Format of export file
     * @param {Object} [options] - Options for export
     *    @param {boolean} [options.includeHeader=true] - Whether to include headers
     *    @param {boolean} [options.includeHiddenColumns=false] - Whether to include hidden columns
     *    @param {string[]} [options.columnNames=[...allVisibleColumnNames]] - Columns names to export
     *    @param {boolean} [options.onlySelected=false] - Whether to export only the selected range
     *    @param {boolean} [options.onlyFiltered=true] - Whether to export only the filtered data
     *    @param {boolean} [options.useFormattedValue=false] - Whether to export formatted values or original values
     *    @param {','|';'|'\\t'|'|'} [options.delimiter=','] - Delimiter to export CSV
     *    @param {string} [options.fileName='grid-export'] - File name to export
     */
    Grid.prototype.export = function (format, options) {
        this.dispatch('execExport', format, options);
    };
    /**
     * Move the column identified by the specified column name to target index.
     * If there is hidden columns or use complex columns, this couldn't be used.
     * If the column of column name is row header column or tree column, this couldn't be used.
     * @param {string} columnName - The column name of the column
     * @param {number} targetIndex - Target index for moving
     */
    Grid.prototype.moveColumn = function (columnName, targetIndex) {
        var allColumns = this.store.column.allColumns;
        var column = common_1.find(function (_a) {
            var name = _a.name;
            return name === columnName;
        }, allColumns);
        if (!column ||
            targetIndex < 0 ||
            targetIndex >= allColumns.length ||
            column_1.isRowHeader(columnName) ||
            tree_1.isTreeColumnName(this.store.column, columnName)) {
            return;
        }
        this.dispatch('moveColumn', columnName, targetIndex);
    };
    return Grid;
}());
exports.default = Grid;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createStore = void 0;
var observable_1 = __webpack_require__(5);
var data_1 = __webpack_require__(15);
var column_1 = __webpack_require__(33);
var dimension_1 = __webpack_require__(80);
var viewport_1 = __webpack_require__(81);
var columnCoords_1 = __webpack_require__(82);
var rowCoords_1 = __webpack_require__(83);
var focus_1 = __webpack_require__(84);
var summary_1 = __webpack_require__(48);
var selection_1 = __webpack_require__(85);
var renderState_1 = __webpack_require__(86);
var filterLayerState_1 = __webpack_require__(87);
var contextMenu_1 = __webpack_require__(88);
var exports_1 = __webpack_require__(89);
var dimension_2 = __webpack_require__(51);
var lazyObservable_1 = __webpack_require__(31);
var validation_1 = __webpack_require__(27);
function createStore(id, options) {
    validation_1.createNewValidationMap(id);
    var el = options.el, width = options.width, rowHeight = options.rowHeight, bodyHeight = options.bodyHeight, heightResizable = options.heightResizable, minRowHeight = options.minRowHeight, minBodyHeight = options.minBodyHeight, _a = options.columnOptions, columnOptions = _a === void 0 ? {} : _a, keyColumnName = options.keyColumnName, _b = options.rowHeaders, rowHeaders = _b === void 0 ? [] : _b, _c = options.copyOptions, copyOptions = _c === void 0 ? {} : _c, _d = options.summary, summaryOptions = _d === void 0 ? {} : _d, _e = options.selectionUnit, selectionUnit = _e === void 0 ? 'cell' : _e, _f = options.showDummyRows, showDummyRows = _f === void 0 ? false : _f, _g = options.editingEvent, editingEvent = _g === void 0 ? 'dblclick' : _g, _h = options.tabMode, tabMode = _h === void 0 ? 'moveAndEdit' : _h, scrollX = options.scrollX, scrollY = options.scrollY, _j = options.useClientSort, useClientSort = _j === void 0 ? true : _j, _k = options.pageOptions, pageOptions = _k === void 0 ? {} : _k, _l = options.treeColumnOptions, treeColumnOptions = _l === void 0 ? { name: '' } : _l, _m = options.header, header = _m === void 0 ? {} : _m, _o = options.disabled, disabled = _o === void 0 ? false : _o, _p = options.draggable, draggable = _p === void 0 ? false : _p, createMenuGroups = options.contextMenu, moveDirectionOnEnter = options.moveDirectionOnEnter, _q = options.exportOptions, exportOptions = _q === void 0 ? {} : _q;
    var frozenBorderWidth = columnOptions.frozenBorderWidth;
    var summaryHeight = summaryOptions.height, summaryPosition = summaryOptions.position;
    var _r = header.height, headerHeight = _r === void 0 ? 40 : _r, _s = header.complexColumns, complexColumns = _s === void 0 ? [] : _s, _t = header.align, align = _t === void 0 ? 'center' : _t, _u = header.valign, valign = _u === void 0 ? 'middle' : _u, _v = header.columns, columnHeaders = _v === void 0 ? [] : _v;
    var column = column_1.create({
        columns: options.columns,
        columnOptions: columnOptions,
        rowHeaders: rowHeaders,
        copyOptions: copyOptions,
        keyColumnName: keyColumnName,
        treeColumnOptions: treeColumnOptions,
        complexColumns: complexColumns,
        align: align,
        valign: valign,
        columnHeaders: columnHeaders,
        disabled: disabled,
        draggable: draggable,
    });
    var data = data_1.create({
        data: Array.isArray(options.data) ? options.data : [],
        column: column,
        pageOptions: pageOptions,
        useClientSort: useClientSort,
        id: id,
        disabled: disabled,
    });
    var dimension = dimension_1.create({
        column: column,
        width: width,
        domWidth: el.clientWidth,
        rowHeight: rowHeight,
        bodyHeight: bodyHeight,
        minBodyHeight: minBodyHeight,
        minRowHeight: minRowHeight,
        heightResizable: heightResizable,
        frozenBorderWidth: frozenBorderWidth,
        summaryHeight: summaryHeight,
        summaryPosition: summaryPosition,
        scrollX: scrollX,
        scrollY: scrollY,
        headerHeight: headerHeight,
    });
    var columnCoords = columnCoords_1.create({ column: column, dimension: dimension });
    var rowCoords = rowCoords_1.create({ data: data, dimension: dimension });
    var viewport = viewport_1.create({
        data: data,
        column: column,
        dimension: dimension,
        rowCoords: rowCoords,
        columnCoords: columnCoords,
        showDummyRows: showDummyRows,
    });
    var focus = focus_1.create({
        data: data,
        column: column,
        dimension: dimension,
        columnCoords: columnCoords,
        rowCoords: rowCoords,
        editingEvent: editingEvent,
        tabMode: tabMode,
        id: id,
        moveDirectionOnEnter: moveDirectionOnEnter,
    });
    var summary = summary_1.create({ column: column, data: data, summary: summaryOptions });
    var selection = selection_1.create({
        selectionUnit: selectionUnit,
        columnCoords: columnCoords,
        column: column,
        dimension: dimension,
        rowCoords: rowCoords,
        data: data,
    });
    var filterLayerState = filterLayerState_1.create();
    var renderState = renderState_1.create();
    var contextMenu = contextMenu_1.create({ createMenuGroups: createMenuGroups });
    var exports = exports_1.create(exportOptions);
    var store = observable_1.observable({
        id: id,
        data: data,
        column: column,
        dimension: dimension,
        columnCoords: columnCoords,
        rowCoords: rowCoords,
        viewport: viewport,
        focus: focus,
        summary: summary,
        selection: selection,
        renderState: renderState,
        filterLayerState: filterLayerState,
        contextMenu: contextMenu,
        exports: exports,
    });
    // manual observe to resolve circular references
    observable_1.observe(function () {
        dimension_2.setAutoBodyHeight(store);
    });
    // makes the data observable as changes viewport
    observable_1.observe(function () {
        lazyObservable_1.createObservableData(store);
    }, false, 'lazyObservable');
    return store;
}
exports.createStore = createStore;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.patchArrayMethods = void 0;
var observable_1 = __webpack_require__(5);
var common_1 = __webpack_require__(0);
var methods = ['splice', 'push', 'pop', 'shift', 'unshift'];
function patchArrayMethods(arr, obj, key) {
    methods.forEach(function (method) {
        var patchedMethod = common_1.hasOwnProp(arr, method) ? arr[method] : Array.prototype[method];
        var derivedPatchedMethod = !patchedMethod.registered && common_1.hasOwnProp(arr, method);
        // To prevent to stack the patched method recursively
        if (derivedPatchedMethod || !common_1.hasOwnProp(arr, method)) {
            arr[method] = function patch() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var result = patchedMethod.apply(this, args);
                observable_1.notify(obj, key);
                return result;
            };
            if (derivedPatchedMethod) {
                arr[method].registered = true;
            }
        }
    });
    return arr;
}
exports.patchArrayMethods = patchArrayMethods;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.listItemText = void 0;
var common_1 = __webpack_require__(0);
function getListItemText(listItems, value) {
    var item = common_1.findProp('value', value, listItems);
    return item ? item.text : '';
}
function listItemText(_a, relationListItems) {
    var column = _a.column, value = _a.value;
    var type = column.editor.options.type;
    var listItems = column.editor.options.listItems;
    if (Array.isArray(relationListItems)) {
        listItems = relationListItems;
    }
    if (type === 'checkbox') {
        return String(value)
            .split(',')
            .map(getListItemText.bind(null, listItems))
            .filter(function (text) { return Boolean(text); })
            .join(',');
    }
    return getListItemText(listItems, value);
}
exports.listItemText = listItemText;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultRenderer = void 0;
var dom_1 = __webpack_require__(2);
var common_1 = __webpack_require__(0);
var dompurify_1 = __webpack_require__(43);
var DefaultRenderer = /** @class */ (function () {
    function DefaultRenderer(props) {
        var el = document.createElement('div');
        var _a = props.columnInfo, ellipsis = _a.ellipsis, whiteSpace = _a.whiteSpace, renderer = _a.renderer;
        var className = '';
        this.props = props;
        this.el = el;
        if (renderer) {
            var attributes = renderer.attributes, styles = renderer.styles, classNames = renderer.classNames;
            if (attributes) {
                this.setAttrsOrStyles('attrs', attributes);
            }
            if (styles) {
                this.setAttrsOrStyles('styles', styles);
            }
            if (classNames) {
                className = " " + classNames.join(' ');
            }
        }
        el.className = dom_1.cls('cell-content') + className;
        // @TODO: we should remove below options and consider common the renderer option for style, attribute and class names
        if (ellipsis) {
            el.style.textOverflow = 'ellipsis';
        }
        if (whiteSpace) {
            el.style.whiteSpace = whiteSpace;
        }
        this.render(props);
    }
    DefaultRenderer.prototype.setAttrsOrStyles = function (type, targets) {
        var _this = this;
        Object.keys(targets).forEach(function (name) {
            var value = common_1.isFunction(targets[name]) ? targets[name](_this.props) : targets[name];
            if (type === 'attrs') {
                _this.el.setAttribute(name, value);
            }
            else {
                _this.el.style[name] = value;
            }
        });
    };
    DefaultRenderer.prototype.getElement = function () {
        return this.el;
    };
    DefaultRenderer.prototype.render = function (props) {
        this.el.innerHTML = dompurify_1.sanitize("" + props.formattedValue);
    };
    return DefaultRenderer;
}());
exports.DefaultRenderer = DefaultRenderer;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.editorMap = void 0;
var text_1 = __webpack_require__(70);
var checkbox_1 = __webpack_require__(71);
var select_1 = __webpack_require__(72);
var datePicker_1 = __webpack_require__(75);
exports.editorMap = {
    text: [text_1.TextEditor, { type: 'text' }],
    password: [text_1.TextEditor, { type: 'password' }],
    checkbox: [checkbox_1.CheckboxEditor, { type: 'checkbox' }],
    radio: [checkbox_1.CheckboxEditor, { type: 'radio' }],
    select: [select_1.SelectEditor],
    datePicker: [datePicker_1.DatePickerEditor],
};


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TextEditor = void 0;
var dom_1 = __webpack_require__(2);
var common_1 = __webpack_require__(0);
var TextEditor = /** @class */ (function () {
    function TextEditor(props) {
        var el = document.createElement('input');
        var options = props.columnInfo.editor.options;
        el.className = dom_1.cls('content-text');
        el.type = options.type;
        el.value = String(common_1.isNil(props.value) ? '' : props.value);
        if (!common_1.isUndefined(props.height)) {
            el.style.height = props.height + "px";
        }
        this.el = el;
    }
    TextEditor.prototype.getElement = function () {
        return this.el;
    };
    TextEditor.prototype.getValue = function () {
        return this.el.value;
    };
    TextEditor.prototype.mounted = function () {
        this.el.select();
    };
    return TextEditor;
}());
exports.TextEditor = TextEditor;


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckboxEditor = void 0;
var editor_1 = __webpack_require__(34);
var dom_1 = __webpack_require__(2);
var keyboard_1 = __webpack_require__(17);
var common_1 = __webpack_require__(0);
var dom_2 = __webpack_require__(35);
var LAYER_CLASSNAME = dom_1.cls('editor-checkbox-list-layer');
var LIST_ITEM_CLASSNAME = dom_1.cls('editor-checkbox');
var HOVERED_LIST_ITEM_CLASSNAME = dom_1.cls('editor-checkbox-hovered') + " " + LIST_ITEM_CLASSNAME;
var UNCHECKED_RADIO_LABEL_CLASSNAME = dom_1.cls('editor-label-icon-radio');
var CHECKED_RADIO_LABEL_CLASSNAME = dom_1.cls('editor-label-icon-radio-checked');
var UNCHECKED_CHECKBOX_LABEL_CLASSNAME = dom_1.cls('editor-label-icon-checkbox');
var CHECKED_CHECKBOX_LABEL_CLASSNAME = dom_1.cls('editor-label-icon-checkbox-checked');
var CheckboxEditor = /** @class */ (function () {
    function CheckboxEditor(props) {
        var _this = this;
        var _a, _b;
        this.isMounted = false;
        this.hoveredItemId = '';
        this.elementIds = [];
        this.initLayerPos = null;
        this.instantApplyCallback = null;
        this.onMouseover = function (ev) {
            var targetId = _this.getItemId(ev.target);
            if (targetId && targetId !== _this.hoveredItemId) {
                _this.highlightItem(targetId);
            }
        };
        this.onChange = function (ev) {
            var _a;
            var value = ev.target.value;
            _this.setLabelClass(value);
            // eslint-disable-next-line no-unused-expressions
            (_a = _this.instantApplyCallback) === null || _a === void 0 ? void 0 : _a.call(_this);
        };
        this.onKeydown = function (ev) {
            var keyName = keyboard_1.getKeyStrokeString(ev);
            if (keyboard_1.isArrowKey(keyName)) {
                ev.preventDefault();
                var elementIdx = common_1.findIndex(function (id) { return id === _this.hoveredItemId; }, _this.elementIds);
                var totalCount = _this.elementIds.length;
                var offset = totalCount + (keyName === 'down' || keyName === 'right' ? 1 : -1);
                var id = _this.elementIds[(elementIdx + offset) % totalCount];
                _this.highlightItem(id);
            }
            else {
                // except arrow key, pass the event to editing layer for using existing editing keyMap
                _this.portalEditingKeydown(ev);
            }
        };
        var columnInfo = props.columnInfo, width = props.width, formattedValue = props.formattedValue, portalEditingKeydown = props.portalEditingKeydown, instantApplyCallback = props.instantApplyCallback;
        var _c = (_b = (_a = columnInfo.editor) === null || _a === void 0 ? void 0 : _a.options) !== null && _b !== void 0 ? _b : {}, inputType = _c.type, instantApply = _c.instantApply;
        var el = document.createElement('div');
        var value = String(common_1.isNil(props.value) ? '' : props.value);
        el.className = dom_1.cls('layer-editing-inner');
        el.innerText = formattedValue;
        this.inputType = inputType;
        var listItems = editor_1.getListItems(props);
        var layer = this.createLayer(listItems, width);
        this.portalEditingKeydown = portalEditingKeydown;
        this.el = el;
        this.layer = layer;
        this.setValue(value);
        if (instantApply && inputType === 'radio') {
            this.instantApplyCallback = instantApplyCallback;
        }
    }
    CheckboxEditor.prototype.createLayer = function (listItems, width) {
        var _this = this;
        var layer = document.createElement('ul');
        layer.className = LAYER_CLASSNAME;
        layer.style.minWidth = width + "px";
        // To hide the initial layer which is having the position which is not calculated properly
        dom_2.setOpacity(layer, 0);
        listItems.forEach(function (_a) {
            var text = _a.text, value = _a.value;
            var id = "checkbox-" + value;
            var listItemEl = document.createElement('li');
            listItemEl.id = id;
            listItemEl.className = LIST_ITEM_CLASSNAME;
            listItemEl.appendChild(_this.createCheckboxLabel(value, text));
            _this.elementIds.push(id);
            layer.appendChild(listItemEl);
        });
        layer.addEventListener('change', this.onChange);
        layer.addEventListener('mouseover', this.onMouseover);
        layer.addEventListener('keydown', this.onKeydown);
        return layer;
    };
    CheckboxEditor.prototype.createCheckboxLabel = function (value, text) {
        var input = document.createElement('input');
        var label = document.createElement('label');
        var span = document.createElement('span');
        label.className =
            this.inputType === 'radio'
                ? UNCHECKED_RADIO_LABEL_CLASSNAME
                : UNCHECKED_CHECKBOX_LABEL_CLASSNAME;
        input.type = this.inputType;
        input.name = 'checkbox';
        input.value = String(value);
        span.innerText = text;
        label.appendChild(input);
        label.appendChild(span);
        return label;
    };
    CheckboxEditor.prototype.getItemId = function (target) {
        return target.id || target.parentElement.id;
    };
    CheckboxEditor.prototype.highlightItem = function (targetId) {
        if (this.hoveredItemId) {
            this.layer.querySelector("#" + this.hoveredItemId).className = LIST_ITEM_CLASSNAME;
        }
        this.hoveredItemId = targetId;
        var item = this.layer.querySelector("#" + targetId);
        item.className = HOVERED_LIST_ITEM_CLASSNAME;
        item.querySelector('input').focus();
    };
    CheckboxEditor.prototype.setLabelClass = function (inputValue) {
        var label = this.layer.querySelector("#checkbox-" + inputValue + " label");
        if (this.inputType === 'checkbox') {
            label.className = dom_1.hasClass(label, 'editor-label-icon-checkbox-checked')
                ? UNCHECKED_CHECKBOX_LABEL_CLASSNAME
                : CHECKED_CHECKBOX_LABEL_CLASSNAME;
        }
        else {
            var checkedLabel = this.layer.querySelector("." + CHECKED_RADIO_LABEL_CLASSNAME);
            if (checkedLabel) {
                checkedLabel.className = UNCHECKED_RADIO_LABEL_CLASSNAME;
            }
            label.className = CHECKED_RADIO_LABEL_CLASSNAME;
        }
    };
    CheckboxEditor.prototype.getCheckedInput = function () {
        return (this.layer.querySelector('input:checked') ||
            this.layer.querySelector('input'));
    };
    CheckboxEditor.prototype.moveDropdownLayer = function (gridRect) {
        if (this.initLayerPos) {
            dom_2.moveLayer(this.layer, this.initLayerPos, gridRect);
        }
    };
    CheckboxEditor.prototype.getElement = function () {
        return this.el;
    };
    CheckboxEditor.prototype.setValue = function (value) {
        var _this = this;
        String(value)
            .split(',')
            .forEach(function (inputValue) {
            var input = _this.layer.querySelector("input[value=\"" + inputValue + "\"]");
            if (input) {
                input.checked = true;
                _this.setLabelClass(inputValue);
            }
        });
    };
    CheckboxEditor.prototype.getValue = function () {
        var checkedInputs = this.layer.querySelectorAll('input:checked');
        var checkedValues = [];
        for (var i = 0, len = checkedInputs.length; i < len; i += 1) {
            checkedValues.push(checkedInputs[i].value);
        }
        return checkedValues.join(',');
    };
    CheckboxEditor.prototype.mounted = function () {
        // To prevent wrong stacked z-index context, layer append to grid container
        dom_2.getContainerElement(this.el).appendChild(this.layer);
        // @ts-ignore
        dom_2.setLayerPosition(this.el, this.layer);
        this.initLayerPos = {
            top: common_1.pixelToNumber(this.layer.style.top),
            left: common_1.pixelToNumber(this.layer.style.left),
        };
        var checkedInput = this.getCheckedInput();
        if (checkedInput) {
            this.highlightItem("checkbox-" + checkedInput.value);
        }
        this.isMounted = true;
        // To show the layer which has appropriate position
        dom_2.setOpacity(this.layer, 1);
    };
    CheckboxEditor.prototype.beforeDestroy = function () {
        this.layer.removeEventListener('change', this.onChange);
        this.layer.removeEventListener('mouseover', this.onMouseover);
        this.layer.removeEventListener('keydown', this.onKeydown);
        dom_2.getContainerElement(this.el).removeChild(this.layer);
        this.initLayerPos = null;
        this.isMounted = false;
    };
    return CheckboxEditor;
}());
exports.CheckboxEditor = CheckboxEditor;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectEditor = void 0;
var tslib_1 = __webpack_require__(1);
var select_box_1 = tslib_1.__importDefault(__webpack_require__(73));
__webpack_require__(74);
var editor_1 = __webpack_require__(34);
var dom_1 = __webpack_require__(2);
var dom_2 = __webpack_require__(35);
var keyboard_1 = __webpack_require__(17);
var common_1 = __webpack_require__(0);
var SelectEditor = /** @class */ (function () {
    function SelectEditor(props) {
        var _this = this;
        var _a, _b;
        this.isMounted = false;
        this.selectFinish = false;
        this.initLayerPos = null;
        this.instantApplyCallback = null;
        this.onKeydown = function (ev) {
            var passingKeyNames = ['esc', 'shift-tab', 'tab'];
            var keyName = keyboard_1.getKeyStrokeString(ev);
            if (_this.selectFinish || common_1.includes(passingKeyNames, keyName)) {
                // with passingKeyNames, pass the event to editing layer for using existing editing keyMap
                _this.portalEditingKeydown(ev);
            }
            else {
                ev.preventDefault();
            }
        };
        var width = props.width, formattedValue = props.formattedValue, portalEditingKeydown = props.portalEditingKeydown, columnInfo = props.columnInfo, instantApplyCallback = props.instantApplyCallback;
        var instantApply = ((_b = (_a = columnInfo.editor) === null || _a === void 0 ? void 0 : _a.options) !== null && _b !== void 0 ? _b : {}).instantApply;
        var el = document.createElement('div');
        var value = String(common_1.isNil(props.value) ? '' : props.value);
        el.className = dom_1.cls('layer-editing-inner');
        el.innerText = formattedValue;
        var listItems = editor_1.getListItems(props);
        var layer = this.createLayer(listItems, width, value);
        this.portalEditingKeydown = portalEditingKeydown;
        this.el = el;
        this.layer = layer;
        this.layer.addEventListener('keydown', this.onKeydown);
        if (instantApply) {
            this.instantApplyCallback = instantApplyCallback;
            this.selectBoxEl.on('close', this.instantApplyCallback);
        }
    }
    SelectEditor.prototype.setSelectFinish = function (selectFinish) {
        var _this = this;
        setTimeout(function () {
            _this.selectFinish = selectFinish;
        });
    };
    SelectEditor.prototype.createLayer = function (listItems, width, value) {
        var _this = this;
        var layer = document.createElement('div');
        layer.className = dom_1.cls('editor-select-box-layer');
        layer.style.minWidth = width + "px";
        // To hide the initial layer which is having the position which is not calculated properly
        dom_2.setOpacity(layer, 0);
        var data = listItems.map(function (item) { return ({ value: String(item.value), label: item.text }); });
        this.selectBoxEl = new select_box_1.default(layer, { data: data });
        this.selectBoxEl.on('close', function () {
            _this.focusSelectBox();
            _this.setSelectFinish(true);
            // @ts-ignore
            dom_2.setLayerPosition(_this.el, _this.layer, _this.selectBoxEl.dropdown.el);
        });
        this.selectBoxEl.on('open', function () {
            _this.setSelectFinish(false);
            if (_this.isMounted) {
                // @ts-ignore
                dom_2.setLayerPosition(_this.el, _this.layer, _this.selectBoxEl.dropdown.el);
            }
        });
        if (value) {
            this.selectBoxEl.select(value);
        }
        return layer;
    };
    SelectEditor.prototype.focusSelectBox = function () {
        // https://github.com/nhn/toast-ui.select-box/issues/3
        // @TODO: need to change after apply this issue
        // @ts-ignore
        this.selectBoxEl.input.focus();
    };
    SelectEditor.prototype.moveDropdownLayer = function (gridRect) {
        if (this.initLayerPos) {
            dom_2.moveLayer(this.layer, this.initLayerPos, gridRect);
        }
    };
    SelectEditor.prototype.getElement = function () {
        return this.el;
    };
    SelectEditor.prototype.getValue = function () {
        var _a, _b;
        return (_b = (_a = this.selectBoxEl.getSelectedItem()) === null || _a === void 0 ? void 0 : _a.getValue()) !== null && _b !== void 0 ? _b : '';
    };
    SelectEditor.prototype.mounted = function () {
        this.selectBoxEl.open();
        // To prevent wrong stacked z-index context, layer append to grid container
        dom_2.getContainerElement(this.el).appendChild(this.layer);
        // @ts-ignore
        dom_2.setLayerPosition(this.el, this.layer, this.selectBoxEl.dropdown.el);
        this.initLayerPos = {
            top: common_1.pixelToNumber(this.layer.style.top),
            left: common_1.pixelToNumber(this.layer.style.left),
        };
        this.focusSelectBox();
        this.isMounted = true;
        // To show the layer which has appropriate position
        dom_2.setOpacity(this.layer, 1);
    };
    SelectEditor.prototype.beforeDestroy = function () {
        this.selectBoxEl.destroy();
        this.layer.removeEventListener('keydown', this.onKeydown);
        dom_2.getContainerElement(this.el).removeChild(this.layer);
        this.initLayerPos = null;
        this.isMounted = false;
    };
    return SelectEditor;
}());
exports.SelectEditor = SelectEditor;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

/*!
 * TOAST UI Select Box
 * @version 1.0.0 | Thu Oct 24 2019
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 * @license MIT
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(true)
		module.exports = factory();
	else {}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	function hotDisposeChunk(chunkId) {
/******/ 		delete installedChunks[chunkId];
/******/ 	}
/******/ 	var parentHotUpdateCallback = window["webpackHotUpdate"];
/******/ 	window["webpackHotUpdate"] = // eslint-disable-next-line no-unused-vars
/******/ 	function webpackHotUpdateCallback(chunkId, moreModules) {
/******/ 		hotAddUpdateChunk(chunkId, moreModules);
/******/ 		if (parentHotUpdateCallback) parentHotUpdateCallback(chunkId, moreModules);
/******/ 	} ;
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotDownloadUpdateChunk(chunkId) {
/******/ 		var script = document.createElement("script");
/******/ 		script.charset = "utf-8";
/******/ 		script.src = __webpack_require__.p + "" + chunkId + "." + hotCurrentHash + ".hot-update.js";
/******/ 		if (null) {}
/******/ 		document.head.appendChild(script);
/******/ 	}
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotDownloadManifest(requestTimeout) {
/******/ 		requestTimeout = requestTimeout || 10000;
/******/ 		return new Promise(function(resolve, reject) {
/******/ 			if (typeof XMLHttpRequest === "undefined") {
/******/ 				return reject(new Error("No browser support"));
/******/ 			}
/******/ 			try {
/******/ 				var request = new XMLHttpRequest();
/******/ 				var requestPath = __webpack_require__.p + "" + hotCurrentHash + ".hot-update.json";
/******/ 				request.open("GET", requestPath, true);
/******/ 				request.timeout = requestTimeout;
/******/ 				request.send(null);
/******/ 			} catch (err) {
/******/ 				return reject(err);
/******/ 			}
/******/ 			request.onreadystatechange = function() {
/******/ 				if (request.readyState !== 4) return;
/******/ 				if (request.status === 0) {
/******/ 					// timeout
/******/ 					reject(
/******/ 						new Error("Manifest request to " + requestPath + " timed out.")
/******/ 					);
/******/ 				} else if (request.status === 404) {
/******/ 					// no update available
/******/ 					resolve();
/******/ 				} else if (request.status !== 200 && request.status !== 304) {
/******/ 					// other failure
/******/ 					reject(new Error("Manifest request to " + requestPath + " failed."));
/******/ 				} else {
/******/ 					// success
/******/ 					try {
/******/ 						var update = JSON.parse(request.responseText);
/******/ 					} catch (e) {
/******/ 						reject(e);
/******/ 						return;
/******/ 					}
/******/ 					resolve(update);
/******/ 				}
/******/ 			};
/******/ 		});
/******/ 	}
/******/
/******/ 	var hotApplyOnUpdate = true;
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	var hotCurrentHash = "fbd02ae0ea88b9f7e886";
/******/ 	var hotRequestTimeout = 10000;
/******/ 	var hotCurrentModuleData = {};
/******/ 	var hotCurrentChildModule;
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	var hotCurrentParents = [];
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	var hotCurrentParentsTemp = [];
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotCreateRequire(moduleId) {
/******/ 		var me = installedModules[moduleId];
/******/ 		if (!me) return __webpack_require__;
/******/ 		var fn = function(request) {
/******/ 			if (me.hot.active) {
/******/ 				if (installedModules[request]) {
/******/ 					if (installedModules[request].parents.indexOf(moduleId) === -1) {
/******/ 						installedModules[request].parents.push(moduleId);
/******/ 					}
/******/ 				} else {
/******/ 					hotCurrentParents = [moduleId];
/******/ 					hotCurrentChildModule = request;
/******/ 				}
/******/ 				if (me.children.indexOf(request) === -1) {
/******/ 					me.children.push(request);
/******/ 				}
/******/ 			} else {
/******/ 				console.warn(
/******/ 					"[HMR] unexpected require(" +
/******/ 						request +
/******/ 						") from disposed module " +
/******/ 						moduleId
/******/ 				);
/******/ 				hotCurrentParents = [];
/******/ 			}
/******/ 			return __webpack_require__(request);
/******/ 		};
/******/ 		var ObjectFactory = function ObjectFactory(name) {
/******/ 			return {
/******/ 				configurable: true,
/******/ 				enumerable: true,
/******/ 				get: function() {
/******/ 					return __webpack_require__[name];
/******/ 				},
/******/ 				set: function(value) {
/******/ 					__webpack_require__[name] = value;
/******/ 				}
/******/ 			};
/******/ 		};
/******/ 		for (var name in __webpack_require__) {
/******/ 			if (
/******/ 				Object.prototype.hasOwnProperty.call(__webpack_require__, name) &&
/******/ 				name !== "e" &&
/******/ 				name !== "t"
/******/ 			) {
/******/ 				Object.defineProperty(fn, name, ObjectFactory(name));
/******/ 			}
/******/ 		}
/******/ 		fn.e = function(chunkId) {
/******/ 			if (hotStatus === "ready") hotSetStatus("prepare");
/******/ 			hotChunksLoading++;
/******/ 			return __webpack_require__.e(chunkId).then(finishChunkLoading, function(err) {
/******/ 				finishChunkLoading();
/******/ 				throw err;
/******/ 			});
/******/
/******/ 			function finishChunkLoading() {
/******/ 				hotChunksLoading--;
/******/ 				if (hotStatus === "prepare") {
/******/ 					if (!hotWaitingFilesMap[chunkId]) {
/******/ 						hotEnsureUpdateChunk(chunkId);
/******/ 					}
/******/ 					if (hotChunksLoading === 0 && hotWaitingFiles === 0) {
/******/ 						hotUpdateDownloaded();
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 		fn.t = function(value, mode) {
/******/ 			if (mode & 1) value = fn(value);
/******/ 			return __webpack_require__.t(value, mode & ~1);
/******/ 		};
/******/ 		return fn;
/******/ 	}
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotCreateModule(moduleId) {
/******/ 		var hot = {
/******/ 			// private stuff
/******/ 			_acceptedDependencies: {},
/******/ 			_declinedDependencies: {},
/******/ 			_selfAccepted: false,
/******/ 			_selfDeclined: false,
/******/ 			_disposeHandlers: [],
/******/ 			_main: hotCurrentChildModule !== moduleId,
/******/
/******/ 			// Module API
/******/ 			active: true,
/******/ 			accept: function(dep, callback) {
/******/ 				if (dep === undefined) hot._selfAccepted = true;
/******/ 				else if (typeof dep === "function") hot._selfAccepted = dep;
/******/ 				else if (typeof dep === "object")
/******/ 					for (var i = 0; i < dep.length; i++)
/******/ 						hot._acceptedDependencies[dep[i]] = callback || function() {};
/******/ 				else hot._acceptedDependencies[dep] = callback || function() {};
/******/ 			},
/******/ 			decline: function(dep) {
/******/ 				if (dep === undefined) hot._selfDeclined = true;
/******/ 				else if (typeof dep === "object")
/******/ 					for (var i = 0; i < dep.length; i++)
/******/ 						hot._declinedDependencies[dep[i]] = true;
/******/ 				else hot._declinedDependencies[dep] = true;
/******/ 			},
/******/ 			dispose: function(callback) {
/******/ 				hot._disposeHandlers.push(callback);
/******/ 			},
/******/ 			addDisposeHandler: function(callback) {
/******/ 				hot._disposeHandlers.push(callback);
/******/ 			},
/******/ 			removeDisposeHandler: function(callback) {
/******/ 				var idx = hot._disposeHandlers.indexOf(callback);
/******/ 				if (idx >= 0) hot._disposeHandlers.splice(idx, 1);
/******/ 			},
/******/
/******/ 			// Management API
/******/ 			check: hotCheck,
/******/ 			apply: hotApply,
/******/ 			status: function(l) {
/******/ 				if (!l) return hotStatus;
/******/ 				hotStatusHandlers.push(l);
/******/ 			},
/******/ 			addStatusHandler: function(l) {
/******/ 				hotStatusHandlers.push(l);
/******/ 			},
/******/ 			removeStatusHandler: function(l) {
/******/ 				var idx = hotStatusHandlers.indexOf(l);
/******/ 				if (idx >= 0) hotStatusHandlers.splice(idx, 1);
/******/ 			},
/******/
/******/ 			//inherit from previous dispose call
/******/ 			data: hotCurrentModuleData[moduleId]
/******/ 		};
/******/ 		hotCurrentChildModule = undefined;
/******/ 		return hot;
/******/ 	}
/******/
/******/ 	var hotStatusHandlers = [];
/******/ 	var hotStatus = "idle";
/******/
/******/ 	function hotSetStatus(newStatus) {
/******/ 		hotStatus = newStatus;
/******/ 		for (var i = 0; i < hotStatusHandlers.length; i++)
/******/ 			hotStatusHandlers[i].call(null, newStatus);
/******/ 	}
/******/
/******/ 	// while downloading
/******/ 	var hotWaitingFiles = 0;
/******/ 	var hotChunksLoading = 0;
/******/ 	var hotWaitingFilesMap = {};
/******/ 	var hotRequestedFilesMap = {};
/******/ 	var hotAvailableFilesMap = {};
/******/ 	var hotDeferred;
/******/
/******/ 	// The update info
/******/ 	var hotUpdate, hotUpdateNewHash;
/******/
/******/ 	function toModuleId(id) {
/******/ 		var isNumber = +id + "" === id;
/******/ 		return isNumber ? +id : id;
/******/ 	}
/******/
/******/ 	function hotCheck(apply) {
/******/ 		if (hotStatus !== "idle") {
/******/ 			throw new Error("check() is only allowed in idle status");
/******/ 		}
/******/ 		hotApplyOnUpdate = apply;
/******/ 		hotSetStatus("check");
/******/ 		return hotDownloadManifest(hotRequestTimeout).then(function(update) {
/******/ 			if (!update) {
/******/ 				hotSetStatus("idle");
/******/ 				return null;
/******/ 			}
/******/ 			hotRequestedFilesMap = {};
/******/ 			hotWaitingFilesMap = {};
/******/ 			hotAvailableFilesMap = update.c;
/******/ 			hotUpdateNewHash = update.h;
/******/
/******/ 			hotSetStatus("prepare");
/******/ 			var promise = new Promise(function(resolve, reject) {
/******/ 				hotDeferred = {
/******/ 					resolve: resolve,
/******/ 					reject: reject
/******/ 				};
/******/ 			});
/******/ 			hotUpdate = {};
/******/ 			var chunkId = "main";
/******/ 			// eslint-disable-next-line no-lone-blocks
/******/ 			{
/******/ 				/*globals chunkId */
/******/ 				hotEnsureUpdateChunk(chunkId);
/******/ 			}
/******/ 			if (
/******/ 				hotStatus === "prepare" &&
/******/ 				hotChunksLoading === 0 &&
/******/ 				hotWaitingFiles === 0
/******/ 			) {
/******/ 				hotUpdateDownloaded();
/******/ 			}
/******/ 			return promise;
/******/ 		});
/******/ 	}
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotAddUpdateChunk(chunkId, moreModules) {
/******/ 		if (!hotAvailableFilesMap[chunkId] || !hotRequestedFilesMap[chunkId])
/******/ 			return;
/******/ 		hotRequestedFilesMap[chunkId] = false;
/******/ 		for (var moduleId in moreModules) {
/******/ 			if (Object.prototype.hasOwnProperty.call(moreModules, moduleId)) {
/******/ 				hotUpdate[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if (--hotWaitingFiles === 0 && hotChunksLoading === 0) {
/******/ 			hotUpdateDownloaded();
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotEnsureUpdateChunk(chunkId) {
/******/ 		if (!hotAvailableFilesMap[chunkId]) {
/******/ 			hotWaitingFilesMap[chunkId] = true;
/******/ 		} else {
/******/ 			hotRequestedFilesMap[chunkId] = true;
/******/ 			hotWaitingFiles++;
/******/ 			hotDownloadUpdateChunk(chunkId);
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotUpdateDownloaded() {
/******/ 		hotSetStatus("ready");
/******/ 		var deferred = hotDeferred;
/******/ 		hotDeferred = null;
/******/ 		if (!deferred) return;
/******/ 		if (hotApplyOnUpdate) {
/******/ 			// Wrap deferred object in Promise to mark it as a well-handled Promise to
/******/ 			// avoid triggering uncaught exception warning in Chrome.
/******/ 			// See https://bugs.chromium.org/p/chromium/issues/detail?id=465666
/******/ 			Promise.resolve()
/******/ 				.then(function() {
/******/ 					return hotApply(hotApplyOnUpdate);
/******/ 				})
/******/ 				.then(
/******/ 					function(result) {
/******/ 						deferred.resolve(result);
/******/ 					},
/******/ 					function(err) {
/******/ 						deferred.reject(err);
/******/ 					}
/******/ 				);
/******/ 		} else {
/******/ 			var outdatedModules = [];
/******/ 			for (var id in hotUpdate) {
/******/ 				if (Object.prototype.hasOwnProperty.call(hotUpdate, id)) {
/******/ 					outdatedModules.push(toModuleId(id));
/******/ 				}
/******/ 			}
/******/ 			deferred.resolve(outdatedModules);
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotApply(options) {
/******/ 		if (hotStatus !== "ready")
/******/ 			throw new Error("apply() is only allowed in ready status");
/******/ 		options = options || {};
/******/
/******/ 		var cb;
/******/ 		var i;
/******/ 		var j;
/******/ 		var module;
/******/ 		var moduleId;
/******/
/******/ 		function getAffectedStuff(updateModuleId) {
/******/ 			var outdatedModules = [updateModuleId];
/******/ 			var outdatedDependencies = {};
/******/
/******/ 			var queue = outdatedModules.map(function(id) {
/******/ 				return {
/******/ 					chain: [id],
/******/ 					id: id
/******/ 				};
/******/ 			});
/******/ 			while (queue.length > 0) {
/******/ 				var queueItem = queue.pop();
/******/ 				var moduleId = queueItem.id;
/******/ 				var chain = queueItem.chain;
/******/ 				module = installedModules[moduleId];
/******/ 				if (!module || module.hot._selfAccepted) continue;
/******/ 				if (module.hot._selfDeclined) {
/******/ 					return {
/******/ 						type: "self-declined",
/******/ 						chain: chain,
/******/ 						moduleId: moduleId
/******/ 					};
/******/ 				}
/******/ 				if (module.hot._main) {
/******/ 					return {
/******/ 						type: "unaccepted",
/******/ 						chain: chain,
/******/ 						moduleId: moduleId
/******/ 					};
/******/ 				}
/******/ 				for (var i = 0; i < module.parents.length; i++) {
/******/ 					var parentId = module.parents[i];
/******/ 					var parent = installedModules[parentId];
/******/ 					if (!parent) continue;
/******/ 					if (parent.hot._declinedDependencies[moduleId]) {
/******/ 						return {
/******/ 							type: "declined",
/******/ 							chain: chain.concat([parentId]),
/******/ 							moduleId: moduleId,
/******/ 							parentId: parentId
/******/ 						};
/******/ 					}
/******/ 					if (outdatedModules.indexOf(parentId) !== -1) continue;
/******/ 					if (parent.hot._acceptedDependencies[moduleId]) {
/******/ 						if (!outdatedDependencies[parentId])
/******/ 							outdatedDependencies[parentId] = [];
/******/ 						addAllToSet(outdatedDependencies[parentId], [moduleId]);
/******/ 						continue;
/******/ 					}
/******/ 					delete outdatedDependencies[parentId];
/******/ 					outdatedModules.push(parentId);
/******/ 					queue.push({
/******/ 						chain: chain.concat([parentId]),
/******/ 						id: parentId
/******/ 					});
/******/ 				}
/******/ 			}
/******/
/******/ 			return {
/******/ 				type: "accepted",
/******/ 				moduleId: updateModuleId,
/******/ 				outdatedModules: outdatedModules,
/******/ 				outdatedDependencies: outdatedDependencies
/******/ 			};
/******/ 		}
/******/
/******/ 		function addAllToSet(a, b) {
/******/ 			for (var i = 0; i < b.length; i++) {
/******/ 				var item = b[i];
/******/ 				if (a.indexOf(item) === -1) a.push(item);
/******/ 			}
/******/ 		}
/******/
/******/ 		// at begin all updates modules are outdated
/******/ 		// the "outdated" status can propagate to parents if they don't accept the children
/******/ 		var outdatedDependencies = {};
/******/ 		var outdatedModules = [];
/******/ 		var appliedUpdate = {};
/******/
/******/ 		var warnUnexpectedRequire = function warnUnexpectedRequire() {
/******/ 			console.warn(
/******/ 				"[HMR] unexpected require(" + result.moduleId + ") to disposed module"
/******/ 			);
/******/ 		};
/******/
/******/ 		for (var id in hotUpdate) {
/******/ 			if (Object.prototype.hasOwnProperty.call(hotUpdate, id)) {
/******/ 				moduleId = toModuleId(id);
/******/ 				/** @type {TODO} */
/******/ 				var result;
/******/ 				if (hotUpdate[id]) {
/******/ 					result = getAffectedStuff(moduleId);
/******/ 				} else {
/******/ 					result = {
/******/ 						type: "disposed",
/******/ 						moduleId: id
/******/ 					};
/******/ 				}
/******/ 				/** @type {Error|false} */
/******/ 				var abortError = false;
/******/ 				var doApply = false;
/******/ 				var doDispose = false;
/******/ 				var chainInfo = "";
/******/ 				if (result.chain) {
/******/ 					chainInfo = "\nUpdate propagation: " + result.chain.join(" -> ");
/******/ 				}
/******/ 				switch (result.type) {
/******/ 					case "self-declined":
/******/ 						if (options.onDeclined) options.onDeclined(result);
/******/ 						if (!options.ignoreDeclined)
/******/ 							abortError = new Error(
/******/ 								"Aborted because of self decline: " +
/******/ 									result.moduleId +
/******/ 									chainInfo
/******/ 							);
/******/ 						break;
/******/ 					case "declined":
/******/ 						if (options.onDeclined) options.onDeclined(result);
/******/ 						if (!options.ignoreDeclined)
/******/ 							abortError = new Error(
/******/ 								"Aborted because of declined dependency: " +
/******/ 									result.moduleId +
/******/ 									" in " +
/******/ 									result.parentId +
/******/ 									chainInfo
/******/ 							);
/******/ 						break;
/******/ 					case "unaccepted":
/******/ 						if (options.onUnaccepted) options.onUnaccepted(result);
/******/ 						if (!options.ignoreUnaccepted)
/******/ 							abortError = new Error(
/******/ 								"Aborted because " + moduleId + " is not accepted" + chainInfo
/******/ 							);
/******/ 						break;
/******/ 					case "accepted":
/******/ 						if (options.onAccepted) options.onAccepted(result);
/******/ 						doApply = true;
/******/ 						break;
/******/ 					case "disposed":
/******/ 						if (options.onDisposed) options.onDisposed(result);
/******/ 						doDispose = true;
/******/ 						break;
/******/ 					default:
/******/ 						throw new Error("Unexception type " + result.type);
/******/ 				}
/******/ 				if (abortError) {
/******/ 					hotSetStatus("abort");
/******/ 					return Promise.reject(abortError);
/******/ 				}
/******/ 				if (doApply) {
/******/ 					appliedUpdate[moduleId] = hotUpdate[moduleId];
/******/ 					addAllToSet(outdatedModules, result.outdatedModules);
/******/ 					for (moduleId in result.outdatedDependencies) {
/******/ 						if (
/******/ 							Object.prototype.hasOwnProperty.call(
/******/ 								result.outdatedDependencies,
/******/ 								moduleId
/******/ 							)
/******/ 						) {
/******/ 							if (!outdatedDependencies[moduleId])
/******/ 								outdatedDependencies[moduleId] = [];
/******/ 							addAllToSet(
/******/ 								outdatedDependencies[moduleId],
/******/ 								result.outdatedDependencies[moduleId]
/******/ 							);
/******/ 						}
/******/ 					}
/******/ 				}
/******/ 				if (doDispose) {
/******/ 					addAllToSet(outdatedModules, [result.moduleId]);
/******/ 					appliedUpdate[moduleId] = warnUnexpectedRequire;
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// Store self accepted outdated modules to require them later by the module system
/******/ 		var outdatedSelfAcceptedModules = [];
/******/ 		for (i = 0; i < outdatedModules.length; i++) {
/******/ 			moduleId = outdatedModules[i];
/******/ 			if (
/******/ 				installedModules[moduleId] &&
/******/ 				installedModules[moduleId].hot._selfAccepted &&
/******/ 				// removed self-accepted modules should not be required
/******/ 				appliedUpdate[moduleId] !== warnUnexpectedRequire
/******/ 			) {
/******/ 				outdatedSelfAcceptedModules.push({
/******/ 					module: moduleId,
/******/ 					errorHandler: installedModules[moduleId].hot._selfAccepted
/******/ 				});
/******/ 			}
/******/ 		}
/******/
/******/ 		// Now in "dispose" phase
/******/ 		hotSetStatus("dispose");
/******/ 		Object.keys(hotAvailableFilesMap).forEach(function(chunkId) {
/******/ 			if (hotAvailableFilesMap[chunkId] === false) {
/******/ 				hotDisposeChunk(chunkId);
/******/ 			}
/******/ 		});
/******/
/******/ 		var idx;
/******/ 		var queue = outdatedModules.slice();
/******/ 		while (queue.length > 0) {
/******/ 			moduleId = queue.pop();
/******/ 			module = installedModules[moduleId];
/******/ 			if (!module) continue;
/******/
/******/ 			var data = {};
/******/
/******/ 			// Call dispose handlers
/******/ 			var disposeHandlers = module.hot._disposeHandlers;
/******/ 			for (j = 0; j < disposeHandlers.length; j++) {
/******/ 				cb = disposeHandlers[j];
/******/ 				cb(data);
/******/ 			}
/******/ 			hotCurrentModuleData[moduleId] = data;
/******/
/******/ 			// disable module (this disables requires from this module)
/******/ 			module.hot.active = false;
/******/
/******/ 			// remove module from cache
/******/ 			delete installedModules[moduleId];
/******/
/******/ 			// when disposing there is no need to call dispose handler
/******/ 			delete outdatedDependencies[moduleId];
/******/
/******/ 			// remove "parents" references from all children
/******/ 			for (j = 0; j < module.children.length; j++) {
/******/ 				var child = installedModules[module.children[j]];
/******/ 				if (!child) continue;
/******/ 				idx = child.parents.indexOf(moduleId);
/******/ 				if (idx >= 0) {
/******/ 					child.parents.splice(idx, 1);
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// remove outdated dependency from module children
/******/ 		var dependency;
/******/ 		var moduleOutdatedDependencies;
/******/ 		for (moduleId in outdatedDependencies) {
/******/ 			if (
/******/ 				Object.prototype.hasOwnProperty.call(outdatedDependencies, moduleId)
/******/ 			) {
/******/ 				module = installedModules[moduleId];
/******/ 				if (module) {
/******/ 					moduleOutdatedDependencies = outdatedDependencies[moduleId];
/******/ 					for (j = 0; j < moduleOutdatedDependencies.length; j++) {
/******/ 						dependency = moduleOutdatedDependencies[j];
/******/ 						idx = module.children.indexOf(dependency);
/******/ 						if (idx >= 0) module.children.splice(idx, 1);
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// Now in "apply" phase
/******/ 		hotSetStatus("apply");
/******/
/******/ 		hotCurrentHash = hotUpdateNewHash;
/******/
/******/ 		// insert new code
/******/ 		for (moduleId in appliedUpdate) {
/******/ 			if (Object.prototype.hasOwnProperty.call(appliedUpdate, moduleId)) {
/******/ 				modules[moduleId] = appliedUpdate[moduleId];
/******/ 			}
/******/ 		}
/******/
/******/ 		// call accept handlers
/******/ 		var error = null;
/******/ 		for (moduleId in outdatedDependencies) {
/******/ 			if (
/******/ 				Object.prototype.hasOwnProperty.call(outdatedDependencies, moduleId)
/******/ 			) {
/******/ 				module = installedModules[moduleId];
/******/ 				if (module) {
/******/ 					moduleOutdatedDependencies = outdatedDependencies[moduleId];
/******/ 					var callbacks = [];
/******/ 					for (i = 0; i < moduleOutdatedDependencies.length; i++) {
/******/ 						dependency = moduleOutdatedDependencies[i];
/******/ 						cb = module.hot._acceptedDependencies[dependency];
/******/ 						if (cb) {
/******/ 							if (callbacks.indexOf(cb) !== -1) continue;
/******/ 							callbacks.push(cb);
/******/ 						}
/******/ 					}
/******/ 					for (i = 0; i < callbacks.length; i++) {
/******/ 						cb = callbacks[i];
/******/ 						try {
/******/ 							cb(moduleOutdatedDependencies);
/******/ 						} catch (err) {
/******/ 							if (options.onErrored) {
/******/ 								options.onErrored({
/******/ 									type: "accept-errored",
/******/ 									moduleId: moduleId,
/******/ 									dependencyId: moduleOutdatedDependencies[i],
/******/ 									error: err
/******/ 								});
/******/ 							}
/******/ 							if (!options.ignoreErrored) {
/******/ 								if (!error) error = err;
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// Load self accepted modules
/******/ 		for (i = 0; i < outdatedSelfAcceptedModules.length; i++) {
/******/ 			var item = outdatedSelfAcceptedModules[i];
/******/ 			moduleId = item.module;
/******/ 			hotCurrentParents = [moduleId];
/******/ 			try {
/******/ 				__webpack_require__(moduleId);
/******/ 			} catch (err) {
/******/ 				if (typeof item.errorHandler === "function") {
/******/ 					try {
/******/ 						item.errorHandler(err);
/******/ 					} catch (err2) {
/******/ 						if (options.onErrored) {
/******/ 							options.onErrored({
/******/ 								type: "self-accept-error-handler-errored",
/******/ 								moduleId: moduleId,
/******/ 								error: err2,
/******/ 								originalError: err
/******/ 							});
/******/ 						}
/******/ 						if (!options.ignoreErrored) {
/******/ 							if (!error) error = err2;
/******/ 						}
/******/ 						if (!error) error = err;
/******/ 					}
/******/ 				} else {
/******/ 					if (options.onErrored) {
/******/ 						options.onErrored({
/******/ 							type: "self-accept-errored",
/******/ 							moduleId: moduleId,
/******/ 							error: err
/******/ 						});
/******/ 					}
/******/ 					if (!options.ignoreErrored) {
/******/ 						if (!error) error = err;
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// handle errors in accept handlers and self accepted module load
/******/ 		if (error) {
/******/ 			hotSetStatus("fail");
/******/ 			return Promise.reject(error);
/******/ 		}
/******/
/******/ 		hotSetStatus("idle");
/******/ 		return new Promise(function(resolve) {
/******/ 			resolve(outdatedModules);
/******/ 		});
/******/ 	}
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {},
/******/ 			hot: hotCreateModule(moduleId),
/******/ 			parents: (hotCurrentParentsTemp = hotCurrentParents, hotCurrentParents = [], hotCurrentParentsTemp),
/******/ 			children: []
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, hotCreateRequire(moduleId));
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "dist";
/******/
/******/ 	// __webpack_hash__
/******/ 	__webpack_require__.h = function() { return hotCurrentHash; };
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return hotCreateRequire("./src/js/index.js")(__webpack_require__.s = "./src/js/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/tui-code-snippet/array/inArray.js":
/*!********************************************************!*\
  !*** ./node_modules/tui-code-snippet/array/inArray.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* eslint-disable complexity */
/**
 * @fileoverview Returns the first index at which a given element can be found in the array.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isArray = __webpack_require__(/*! ../type/isArray */ "./node_modules/tui-code-snippet/type/isArray.js");

/**
 * @module array
 */

/**
 * Returns the first index at which a given element can be found in the array
 * from start index(default 0), or -1 if it is not present.
 * It compares searchElement to elements of the Array using strict equality
 * (the same method used by the ===, or triple-equals, operator).
 * @param {*} searchElement Element to locate in the array
 * @param {Array} array Array that will be traversed.
 * @param {number} startIndex Start index in array for searching (default 0)
 * @returns {number} the First index at which a given element, or -1 if it is not present
 * @memberof module:array
 * @example
 * var inArray = require('tui-code-snippet/array/inArray'); // node, commonjs
 *
 * var arr = ['one', 'two', 'three', 'four'];
 * var idx1 = inArray('one', arr, 3); // -1
 * var idx2 = inArray('one', arr); // 0
 */
function inArray(searchElement, array, startIndex) {
    var i;
    var length;
    startIndex = startIndex || 0;

    if (!isArray(array)) {
        return -1;
    }

    if (Array.prototype.indexOf) {
        return Array.prototype.indexOf.call(array, searchElement, startIndex);
    }

    length = array.length;
    for (i = startIndex; startIndex >= 0 && i < length; i += 1) {
        if (array[i] === searchElement) {
            return i;
        }
    }

    return -1;
}

module.exports = inArray;


/***/ }),

/***/ "./node_modules/tui-code-snippet/collection/forEach.js":
/*!*************************************************************!*\
  !*** ./node_modules/tui-code-snippet/collection/forEach.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Execute the provided callback once for each property of object(or element of array) which actually exist.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isArray = __webpack_require__(/*! ../type/isArray */ "./node_modules/tui-code-snippet/type/isArray.js");
var forEachArray = __webpack_require__(/*! ../collection/forEachArray */ "./node_modules/tui-code-snippet/collection/forEachArray.js");
var forEachOwnProperties = __webpack_require__(/*! ../collection/forEachOwnProperties */ "./node_modules/tui-code-snippet/collection/forEachOwnProperties.js");

/**
 * @module collection
 */

/**
 * Execute the provided callback once for each property of object(or element of array) which actually exist.
 * If the object is Array-like object(ex-arguments object), It needs to transform to Array.(see 'ex2' of example).
 * If the callback function returns false, the loop will be stopped.
 * Callback function(iteratee) is invoked with three arguments:
 *  - The value of the property(or The value of the element)
 *  - The name of the property(or The index of the element)
 *  - The object being traversed
 * @param {Object} obj The object that will be traversed
 * @param {function} iteratee Callback function
 * @param {Object} [context] Context(this) of callback function
 * @memberof module:collection
 * @example
 * var forEach = require('tui-code-snippet/collection/forEach'); // node, commonjs
 *
 * var sum = 0;
 *
 * forEach([1,2,3], function(value){
 *     sum += value;
 * });
 * alert(sum); // 6
 *
 * // In case of Array-like object
 * var array = Array.prototype.slice.call(arrayLike); // change to array
 * forEach(array, function(value){
 *     sum += value;
 * });
 */
function forEach(obj, iteratee, context) {
    if (isArray(obj)) {
        forEachArray(obj, iteratee, context);
    } else {
        forEachOwnProperties(obj, iteratee, context);
    }
}

module.exports = forEach;


/***/ }),

/***/ "./node_modules/tui-code-snippet/collection/forEachArray.js":
/*!******************************************************************!*\
  !*** ./node_modules/tui-code-snippet/collection/forEachArray.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Execute the provided callback once for each element present in the array(or Array-like object) in ascending order.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Execute the provided callback once for each element present
 * in the array(or Array-like object) in ascending order.
 * If the callback function returns false, the loop will be stopped.
 * Callback function(iteratee) is invoked with three arguments:
 *  - The value of the element
 *  - The index of the element
 *  - The array(or Array-like object) being traversed
 * @param {Array} arr The array(or Array-like object) that will be traversed
 * @param {function} iteratee Callback function
 * @param {Object} [context] Context(this) of callback function
 * @memberof module:collection
 * @example
 * var forEachArray = require('tui-code-snippet/collection/forEachArray'); // node, commonjs
 *
 * var sum = 0;
 *
 * forEachArray([1,2,3], function(value){
 *     sum += value;
 * });
 * alert(sum); // 6
 */
function forEachArray(arr, iteratee, context) {
    var index = 0;
    var len = arr.length;

    context = context || null;

    for (; index < len; index += 1) {
        if (iteratee.call(context, arr[index], index, arr) === false) {
            break;
        }
    }
}

module.exports = forEachArray;


/***/ }),

/***/ "./node_modules/tui-code-snippet/collection/forEachOwnProperties.js":
/*!**************************************************************************!*\
  !*** ./node_modules/tui-code-snippet/collection/forEachOwnProperties.js ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Execute the provided callback once for each property of object which actually exist.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Execute the provided callback once for each property of object which actually exist.
 * If the callback function returns false, the loop will be stopped.
 * Callback function(iteratee) is invoked with three arguments:
 *  - The value of the property
 *  - The name of the property
 *  - The object being traversed
 * @param {Object} obj The object that will be traversed
 * @param {function} iteratee  Callback function
 * @param {Object} [context] Context(this) of callback function
 * @memberof module:collection
 * @example
 * var forEachOwnProperties = require('tui-code-snippet/collection/forEachOwnProperties'); // node, commonjs
 *
 * var sum = 0;
 *
 * forEachOwnProperties({a:1,b:2,c:3}, function(value){
 *     sum += value;
 * });
 * alert(sum); // 6
 */
function forEachOwnProperties(obj, iteratee, context) {
    var key;

    context = context || null;

    for (key in obj) {
        if (obj.hasOwnProperty(key)) {
            if (iteratee.call(context, obj[key], key, obj) === false) {
                break;
            }
        }
    }
}

module.exports = forEachOwnProperties;


/***/ }),

/***/ "./node_modules/tui-code-snippet/collection/toArray.js":
/*!*************************************************************!*\
  !*** ./node_modules/tui-code-snippet/collection/toArray.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Transform the Array-like object to Array.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var forEachArray = __webpack_require__(/*! ./forEachArray */ "./node_modules/tui-code-snippet/collection/forEachArray.js");

/**
 * Transform the Array-like object to Array.
 * In low IE (below 8), Array.prototype.slice.call is not perfect. So, try-catch statement is used.
 * @param {*} arrayLike Array-like object
 * @returns {Array} Array
 * @memberof module:collection
 * @example
 * var toArray = require('tui-code-snippet/collection/toArray'); // node, commonjs
 *
 * var arrayLike = {
 *     0: 'one',
 *     1: 'two',
 *     2: 'three',
 *     3: 'four',
 *     length: 4
 * };
 * var result = toArray(arrayLike);
 *
 * alert(result instanceof Array); // true
 * alert(result); // one,two,three,four
 */
function toArray(arrayLike) {
    var arr;
    try {
        arr = Array.prototype.slice.call(arrayLike);
    } catch (e) {
        arr = [];
        forEachArray(arrayLike, function(value) {
            arr.push(value);
        });
    }

    return arr;
}

module.exports = toArray;


/***/ }),

/***/ "./node_modules/tui-code-snippet/customEvents/customEvents.js":
/*!********************************************************************!*\
  !*** ./node_modules/tui-code-snippet/customEvents/customEvents.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview This module provides some functions for custom events. And it is implemented in the observer design pattern.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var extend = __webpack_require__(/*! ../object/extend */ "./node_modules/tui-code-snippet/object/extend.js");
var isExisty = __webpack_require__(/*! ../type/isExisty */ "./node_modules/tui-code-snippet/type/isExisty.js");
var isString = __webpack_require__(/*! ../type/isString */ "./node_modules/tui-code-snippet/type/isString.js");
var isObject = __webpack_require__(/*! ../type/isObject */ "./node_modules/tui-code-snippet/type/isObject.js");
var isArray = __webpack_require__(/*! ../type/isArray */ "./node_modules/tui-code-snippet/type/isArray.js");
var isFunction = __webpack_require__(/*! ../type/isFunction */ "./node_modules/tui-code-snippet/type/isFunction.js");
var forEach = __webpack_require__(/*! ../collection/forEach */ "./node_modules/tui-code-snippet/collection/forEach.js");

var R_EVENTNAME_SPLIT = /\s+/g;

/**
 * @class
 * @example
 * // node, commonjs
 * var CustomEvents = require('tui-code-snippet/customEvents/customEvents');
 */
function CustomEvents() {
    /**
     * @type {HandlerItem[]}
     */
    this.events = null;

    /**
     * only for checking specific context event was binded
     * @type {object[]}
     */
    this.contexts = null;
}

/**
 * Mixin custom events feature to specific constructor
 * @param {function} func - constructor
 * @example
 * var CustomEvents = require('tui-code-snippet/customEvents/customEvents'); // node, commonjs
 *
 * var model;
 * function Model() {
 *     this.name = '';
 * }
 * CustomEvents.mixin(Model);
 *
 * model = new Model();
 * model.on('change', function() { this.name = 'model'; }, this);
 * model.fire('change');
 * alert(model.name); // 'model';
 */
CustomEvents.mixin = function(func) {
    extend(func.prototype, CustomEvents.prototype);
};

/**
 * Get HandlerItem object
 * @param {function} handler - handler function
 * @param {object} [context] - context for handler
 * @returns {HandlerItem} HandlerItem object
 * @private
 */
CustomEvents.prototype._getHandlerItem = function(handler, context) {
    var item = {handler: handler};

    if (context) {
        item.context = context;
    }

    return item;
};

/**
 * Get event object safely
 * @param {string} [eventName] - create sub event map if not exist.
 * @returns {(object|array)} event object. if you supplied `eventName`
 *  parameter then make new array and return it
 * @private
 */
CustomEvents.prototype._safeEvent = function(eventName) {
    var events = this.events;
    var byName;

    if (!events) {
        events = this.events = {};
    }

    if (eventName) {
        byName = events[eventName];

        if (!byName) {
            byName = [];
            events[eventName] = byName;
        }

        events = byName;
    }

    return events;
};

/**
 * Get context array safely
 * @returns {array} context array
 * @private
 */
CustomEvents.prototype._safeContext = function() {
    var context = this.contexts;

    if (!context) {
        context = this.contexts = [];
    }

    return context;
};

/**
 * Get index of context
 * @param {object} ctx - context that used for bind custom event
 * @returns {number} index of context
 * @private
 */
CustomEvents.prototype._indexOfContext = function(ctx) {
    var context = this._safeContext();
    var index = 0;

    while (context[index]) {
        if (ctx === context[index][0]) {
            return index;
        }

        index += 1;
    }

    return -1;
};

/**
 * Memorize supplied context for recognize supplied object is context or
 *  name: handler pair object when off()
 * @param {object} ctx - context object to memorize
 * @private
 */
CustomEvents.prototype._memorizeContext = function(ctx) {
    var context, index;

    if (!isExisty(ctx)) {
        return;
    }

    context = this._safeContext();
    index = this._indexOfContext(ctx);

    if (index > -1) {
        context[index][1] += 1;
    } else {
        context.push([ctx, 1]);
    }
};

/**
 * Forget supplied context object
 * @param {object} ctx - context object to forget
 * @private
 */
CustomEvents.prototype._forgetContext = function(ctx) {
    var context, contextIndex;

    if (!isExisty(ctx)) {
        return;
    }

    context = this._safeContext();
    contextIndex = this._indexOfContext(ctx);

    if (contextIndex > -1) {
        context[contextIndex][1] -= 1;

        if (context[contextIndex][1] <= 0) {
            context.splice(contextIndex, 1);
        }
    }
};

/**
 * Bind event handler
 * @param {(string|{name:string, handler:function})} eventName - custom
 *  event name or an object {eventName: handler}
 * @param {(function|object)} [handler] - handler function or context
 * @param {object} [context] - context for binding
 * @private
 */
CustomEvents.prototype._bindEvent = function(eventName, handler, context) {
    var events = this._safeEvent(eventName);
    this._memorizeContext(context);
    events.push(this._getHandlerItem(handler, context));
};

/**
 * Bind event handlers
 * @param {(string|{name:string, handler:function})} eventName - custom
 *  event name or an object {eventName: handler}
 * @param {(function|object)} [handler] - handler function or context
 * @param {object} [context] - context for binding
 * //-- #1. Get Module --//
 * var CustomEvents = require('tui-code-snippet/customEvents/customEvents'); // node, commonjs
 *
 * //-- #2. Use method --//
 * // # 2.1 Basic Usage
 * CustomEvents.on('onload', handler);
 *
 * // # 2.2 With context
 * CustomEvents.on('onload', handler, myObj);
 *
 * // # 2.3 Bind by object that name, handler pairs
 * CustomEvents.on({
 *     'play': handler,
 *     'pause': handler2
 * });
 *
 * // # 2.4 Bind by object that name, handler pairs with context object
 * CustomEvents.on({
 *     'play': handler
 * }, myObj);
 */
CustomEvents.prototype.on = function(eventName, handler, context) {
    var self = this;

    if (isString(eventName)) {
        // [syntax 1, 2]
        eventName = eventName.split(R_EVENTNAME_SPLIT);
        forEach(eventName, function(name) {
            self._bindEvent(name, handler, context);
        });
    } else if (isObject(eventName)) {
        // [syntax 3, 4]
        context = handler;
        forEach(eventName, function(func, name) {
            self.on(name, func, context);
        });
    }
};

/**
 * Bind one-shot event handlers
 * @param {(string|{name:string,handler:function})} eventName - custom
 *  event name or an object {eventName: handler}
 * @param {function|object} [handler] - handler function or context
 * @param {object} [context] - context for binding
 */
CustomEvents.prototype.once = function(eventName, handler, context) {
    var self = this;

    if (isObject(eventName)) {
        context = handler;
        forEach(eventName, function(func, name) {
            self.once(name, func, context);
        });

        return;
    }

    function onceHandler() { // eslint-disable-line require-jsdoc
        handler.apply(context, arguments);
        self.off(eventName, onceHandler, context);
    }

    this.on(eventName, onceHandler, context);
};

/**
 * Splice supplied array by callback result
 * @param {array} arr - array to splice
 * @param {function} predicate - function return boolean
 * @private
 */
CustomEvents.prototype._spliceMatches = function(arr, predicate) {
    var i = 0;
    var len;

    if (!isArray(arr)) {
        return;
    }

    for (len = arr.length; i < len; i += 1) {
        if (predicate(arr[i]) === true) {
            arr.splice(i, 1);
            len -= 1;
            i -= 1;
        }
    }
};

/**
 * Get matcher for unbind specific handler events
 * @param {function} handler - handler function
 * @returns {function} handler matcher
 * @private
 */
CustomEvents.prototype._matchHandler = function(handler) {
    var self = this;

    return function(item) {
        var needRemove = handler === item.handler;

        if (needRemove) {
            self._forgetContext(item.context);
        }

        return needRemove;
    };
};

/**
 * Get matcher for unbind specific context events
 * @param {object} context - context
 * @returns {function} object matcher
 * @private
 */
CustomEvents.prototype._matchContext = function(context) {
    var self = this;

    return function(item) {
        var needRemove = context === item.context;

        if (needRemove) {
            self._forgetContext(item.context);
        }

        return needRemove;
    };
};

/**
 * Get matcher for unbind specific hander, context pair events
 * @param {function} handler - handler function
 * @param {object} context - context
 * @returns {function} handler, context matcher
 * @private
 */
CustomEvents.prototype._matchHandlerAndContext = function(handler, context) {
    var self = this;

    return function(item) {
        var matchHandler = (handler === item.handler);
        var matchContext = (context === item.context);
        var needRemove = (matchHandler && matchContext);

        if (needRemove) {
            self._forgetContext(item.context);
        }

        return needRemove;
    };
};

/**
 * Unbind event by event name
 * @param {string} eventName - custom event name to unbind
 * @param {function} [handler] - handler function
 * @private
 */
CustomEvents.prototype._offByEventName = function(eventName, handler) {
    var self = this;
    var andByHandler = isFunction(handler);
    var matchHandler = self._matchHandler(handler);

    eventName = eventName.split(R_EVENTNAME_SPLIT);

    forEach(eventName, function(name) {
        var handlerItems = self._safeEvent(name);

        if (andByHandler) {
            self._spliceMatches(handlerItems, matchHandler);
        } else {
            forEach(handlerItems, function(item) {
                self._forgetContext(item.context);
            });

            self.events[name] = [];
        }
    });
};

/**
 * Unbind event by handler function
 * @param {function} handler - handler function
 * @private
 */
CustomEvents.prototype._offByHandler = function(handler) {
    var self = this;
    var matchHandler = this._matchHandler(handler);

    forEach(this._safeEvent(), function(handlerItems) {
        self._spliceMatches(handlerItems, matchHandler);
    });
};

/**
 * Unbind event by object(name: handler pair object or context object)
 * @param {object} obj - context or {name: handler} pair object
 * @param {function} handler - handler function
 * @private
 */
CustomEvents.prototype._offByObject = function(obj, handler) {
    var self = this;
    var matchFunc;

    if (this._indexOfContext(obj) < 0) {
        forEach(obj, function(func, name) {
            self.off(name, func);
        });
    } else if (isString(handler)) {
        matchFunc = this._matchContext(obj);

        self._spliceMatches(this._safeEvent(handler), matchFunc);
    } else if (isFunction(handler)) {
        matchFunc = this._matchHandlerAndContext(handler, obj);

        forEach(this._safeEvent(), function(handlerItems) {
            self._spliceMatches(handlerItems, matchFunc);
        });
    } else {
        matchFunc = this._matchContext(obj);

        forEach(this._safeEvent(), function(handlerItems) {
            self._spliceMatches(handlerItems, matchFunc);
        });
    }
};

/**
 * Unbind custom events
 * @param {(string|object|function)} eventName - event name or context or
 *  {name: handler} pair object or handler function
 * @param {(function)} handler - handler function
 * @example
 * //-- #1. Get Module --//
 * var CustomEvents = require('tui-code-snippet/customEvents/customEvents'); // node, commonjs
 *
 * //-- #2. Use method --//
 * // # 2.1 off by event name
 * CustomEvents.off('onload');
 *
 * // # 2.2 off by event name and handler
 * CustomEvents.off('play', handler);
 *
 * // # 2.3 off by handler
 * CustomEvents.off(handler);
 *
 * // # 2.4 off by context
 * CustomEvents.off(myObj);
 *
 * // # 2.5 off by context and handler
 * CustomEvents.off(myObj, handler);
 *
 * // # 2.6 off by context and event name
 * CustomEvents.off(myObj, 'onload');
 *
 * // # 2.7 off by an Object.<string, function> that is {eventName: handler}
 * CustomEvents.off({
 *   'play': handler,
 *   'pause': handler2
 * });
 *
 * // # 2.8 off the all events
 * CustomEvents.off();
 */
CustomEvents.prototype.off = function(eventName, handler) {
    if (isString(eventName)) {
        // [syntax 1, 2]
        this._offByEventName(eventName, handler);
    } else if (!arguments.length) {
        // [syntax 8]
        this.events = {};
        this.contexts = [];
    } else if (isFunction(eventName)) {
        // [syntax 3]
        this._offByHandler(eventName);
    } else if (isObject(eventName)) {
        // [syntax 4, 5, 6]
        this._offByObject(eventName, handler);
    }
};

/**
 * Fire custom event
 * @param {string} eventName - name of custom event
 */
CustomEvents.prototype.fire = function(eventName) {  // eslint-disable-line
    this.invoke.apply(this, arguments);
};

/**
 * Fire a event and returns the result of operation 'boolean AND' with all
 *  listener's results.
 *
 * So, It is different from {@link CustomEvents#fire}.
 *
 * In service code, use this as a before event in component level usually
 *  for notifying that the event is cancelable.
 * @param {string} eventName - Custom event name
 * @param {...*} data - Data for event
 * @returns {boolean} The result of operation 'boolean AND'
 * @example
 * var map = new Map();
 * map.on({
 *     'beforeZoom': function() {
 *         // It should cancel the 'zoom' event by some conditions.
 *         if (that.disabled && this.getState()) {
 *             return false;
 *         }
 *         return true;
 *     }
 * });
 *
 * if (this.invoke('beforeZoom')) {    // check the result of 'beforeZoom'
 *     // if true,
 *     // doSomething
 * }
 */
CustomEvents.prototype.invoke = function(eventName) {
    var events, args, index, item;

    if (!this.hasListener(eventName)) {
        return true;
    }

    events = this._safeEvent(eventName);
    args = Array.prototype.slice.call(arguments, 1);
    index = 0;

    while (events[index]) {
        item = events[index];

        if (item.handler.apply(item.context, args) === false) {
            return false;
        }

        index += 1;
    }

    return true;
};

/**
 * Return whether at least one of the handlers is registered in the given
 *  event name.
 * @param {string} eventName - Custom event name
 * @returns {boolean} Is there at least one handler in event name?
 */
CustomEvents.prototype.hasListener = function(eventName) {
    return this.getListenerLength(eventName) > 0;
};

/**
 * Return a count of events registered.
 * @param {string} eventName - Custom event name
 * @returns {number} number of event
 */
CustomEvents.prototype.getListenerLength = function(eventName) {
    var events = this._safeEvent(eventName);

    return events.length;
};

module.exports = CustomEvents;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domEvent/_safeEvent.js":
/*!**************************************************************!*\
  !*** ./node_modules/tui-code-snippet/domEvent/_safeEvent.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Get event collection for specific HTML element
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var EVENT_KEY = '_feEventKey';

/**
 * Get event collection for specific HTML element
 * @param {HTMLElement} element - HTML element
 * @param {string} type - event type
 * @returns {array}
 * @private
 */
function safeEvent(element, type) {
    var events = element[EVENT_KEY];
    var handlers;

    if (!events) {
        events = element[EVENT_KEY] = {};
    }

    handlers = events[type];
    if (!handlers) {
        handlers = events[type] = [];
    }

    return handlers;
}

module.exports = safeEvent;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domEvent/getTarget.js":
/*!*************************************************************!*\
  !*** ./node_modules/tui-code-snippet/domEvent/getTarget.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Get a target element from an event object.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Get a target element from an event object.
 * @param {Event} e - event object
 * @returns {HTMLElement} - target element
 * @memberof module:domEvent
 */
function getTarget(e) {
    return e.target || e.srcElement;
}

module.exports = getTarget;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domEvent/off.js":
/*!*******************************************************!*\
  !*** ./node_modules/tui-code-snippet/domEvent/off.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Unbind DOM events
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isString = __webpack_require__(/*! ../type/isString */ "./node_modules/tui-code-snippet/type/isString.js");
var forEach = __webpack_require__(/*! ../collection/forEach */ "./node_modules/tui-code-snippet/collection/forEach.js");

var safeEvent = __webpack_require__(/*! ./_safeEvent */ "./node_modules/tui-code-snippet/domEvent/_safeEvent.js");

/**
 * Unbind DOM events
 * If a handler function is not passed, remove all events of that type.
 * @param {HTMLElement} element - element to unbindbind events
 * @param {(string|object)} types - Space splitted events names or
 *  eventName:handler object
 * @param {function} [handler] - handler function
 * @memberof module:domEvent
 */
function off(element, types, handler) {
    if (isString(types)) {
        forEach(types.split(/\s+/g), function(type) {
            unbindEvent(element, type, handler);
        });

        return;
    }

    forEach(types, function(func, type) {
        unbindEvent(element, type, func);
    });
}

/**
 * Unbind DOM events
 * If a handler function is not passed, remove all events of that type.
 * @param {HTMLElement} element - element to unbind events
 * @param {string} type - events name
 * @param {function} [handler] - handler function
 * @private
 */
function unbindEvent(element, type, handler) {
    var events = safeEvent(element, type);
    var index;

    if (!handler) {
        forEach(events, function(item) {
            removeHandler(element, type, item.wrappedHandler);
        });
        events.splice(0, events.length);
    } else {
        forEach(events, function(item, idx) {
            if (handler === item.handler) {
                removeHandler(element, type, item.wrappedHandler);
                index = idx;

                return false;
            }

            return true;
        });
        events.splice(index, 1);
    }
}

/**
 * Remove an event handler
 * @param {HTMLElement} element - An element to remove an event
 * @param {string} type - event type
 * @param {function} handler - event handler
 * @private
 */
function removeHandler(element, type, handler) {
    if ('removeEventListener' in element) {
        element.removeEventListener(type, handler);
    } else if ('detachEvent' in element) {
        element.detachEvent('on' + type, handler);
    }
}

module.exports = off;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domEvent/on.js":
/*!******************************************************!*\
  !*** ./node_modules/tui-code-snippet/domEvent/on.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Bind DOM events
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isString = __webpack_require__(/*! ../type/isString */ "./node_modules/tui-code-snippet/type/isString.js");
var forEach = __webpack_require__(/*! ../collection/forEach */ "./node_modules/tui-code-snippet/collection/forEach.js");

var safeEvent = __webpack_require__(/*! ./_safeEvent */ "./node_modules/tui-code-snippet/domEvent/_safeEvent.js");

/**
 * Bind DOM events
 * @param {HTMLElement} element - element to bind events
 * @param {(string|object)} types - Space splitted events names or
 *  eventName:handler object
 * @param {(function|object)} handler - handler function or context for handler
 *  method
 * @param {object} [context] context - context for handler method.
 * @memberof module:domEvent
 */
function on(element, types, handler, context) {
    if (isString(types)) {
        forEach(types.split(/\s+/g), function(type) {
            bindEvent(element, type, handler, context);
        });

        return;
    }

    forEach(types, function(func, type) {
        bindEvent(element, type, func, handler);
    });
}

/**
 * Bind DOM events
 * @param {HTMLElement} element - element to bind events
 * @param {string} type - events name
 * @param {function} handler - handler function or context for handler
 *  method
 * @param {object} [context] context - context for handler method.
 * @private
 */
function bindEvent(element, type, handler, context) {
    /**
     * Event handler
     * @param {Event} e - event object
     */
    function eventHandler(e) {
        handler.call(context || element, e || window.event);
    }

    if ('addEventListener' in element) {
        element.addEventListener(type, eventHandler);
    } else if ('attachEvent' in element) {
        element.attachEvent('on' + type, eventHandler);
    }
    memorizeHandler(element, type, handler, eventHandler);
}

/**
 * Memorize DOM event handler for unbinding.
 * @param {HTMLElement} element - element to bind events
 * @param {string} type - events name
 * @param {function} handler - handler function that user passed at on() use
 * @param {function} wrappedHandler - handler function that wrapped by domevent for implementing some features
 * @private
 */
function memorizeHandler(element, type, handler, wrappedHandler) {
    var events = safeEvent(element, type);
    var existInEvents = false;

    forEach(events, function(obj) {
        if (obj.handler === handler) {
            existInEvents = true;

            return false;
        }

        return true;
    });

    if (!existInEvents) {
        events.push({
            handler: handler,
            wrappedHandler: wrappedHandler
        });
    }
}

module.exports = on;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domEvent/preventDefault.js":
/*!******************************************************************!*\
  !*** ./node_modules/tui-code-snippet/domEvent/preventDefault.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Prevent default action
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Prevent default action
 * @param {Event} e - event object
 * @memberof module:domEvent
 */
function preventDefault(e) {
    if (e.preventDefault) {
        e.preventDefault();

        return;
    }

    e.returnValue = false;
}

module.exports = preventDefault;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/_setClassName.js":
/*!****************************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/_setClassName.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Set className value
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isArray = __webpack_require__(/*! ../type/isArray */ "./node_modules/tui-code-snippet/type/isArray.js");
var isUndefined = __webpack_require__(/*! ../type/isUndefined */ "./node_modules/tui-code-snippet/type/isUndefined.js");

/**
 * Set className value
 * @param {(HTMLElement|SVGElement)} element - target element
 * @param {(string|string[])} cssClass - class names
 * @private
 */
function setClassName(element, cssClass) {
    cssClass = isArray(cssClass) ? cssClass.join(' ') : cssClass;

    cssClass = cssClass.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');

    if (isUndefined(element.className.baseVal)) {
        element.className = cssClass;

        return;
    }

    element.className.baseVal = cssClass;
}

module.exports = setClassName;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/addClass.js":
/*!***********************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/addClass.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Add css class to element
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var forEach = __webpack_require__(/*! ../collection/forEach */ "./node_modules/tui-code-snippet/collection/forEach.js");
var inArray = __webpack_require__(/*! ../array/inArray */ "./node_modules/tui-code-snippet/array/inArray.js");
var getClass = __webpack_require__(/*! ./getClass */ "./node_modules/tui-code-snippet/domUtil/getClass.js");
var setClassName = __webpack_require__(/*! ./_setClassName */ "./node_modules/tui-code-snippet/domUtil/_setClassName.js");

/**
 * domUtil module
 * @module domUtil
 */

/**
 * Add css class to element
 * @param {(HTMLElement|SVGElement)} element - target element
 * @param {...string} cssClass - css classes to add
 * @memberof module:domUtil
 */
function addClass(element) {
    var cssClass = Array.prototype.slice.call(arguments, 1);
    var classList = element.classList;
    var newClass = [];
    var origin;

    if (classList) {
        forEach(cssClass, function(name) {
            element.classList.add(name);
        });

        return;
    }

    origin = getClass(element);

    if (origin) {
        cssClass = [].concat(origin.split(/\s+/), cssClass);
    }

    forEach(cssClass, function(cls) {
        if (inArray(cls, newClass) < 0) {
            newClass.push(cls);
        }
    });

    setClassName(element, newClass);
}

module.exports = addClass;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/closest.js":
/*!**********************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/closest.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Find parent element recursively
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var matches = __webpack_require__(/*! ./matches */ "./node_modules/tui-code-snippet/domUtil/matches.js");

/**
 * Find parent element recursively
 * @param {HTMLElement} element - base element to start find
 * @param {string} selector - selector string for find
 * @returns {HTMLElement} - element finded or null
 * @memberof module:domUtil
 */
function closest(element, selector) {
    var parent = element.parentNode;

    if (matches(element, selector)) {
        return element;
    }

    while (parent && parent !== document) {
        if (matches(parent, selector)) {
            return parent;
        }

        parent = parent.parentNode;
    }

    return null;
}

module.exports = closest;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/getClass.js":
/*!***********************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/getClass.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Get HTML element's design classes.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isUndefined = __webpack_require__(/*! ../type/isUndefined */ "./node_modules/tui-code-snippet/type/isUndefined.js");

/**
 * Get HTML element's design classes.
 * @param {(HTMLElement|SVGElement)} element target element
 * @returns {string} element css class name
 * @memberof module:domUtil
 */
function getClass(element) {
    if (!element || !element.className) {
        return '';
    }

    if (isUndefined(element.className.baseVal)) {
        return element.className;
    }

    return element.className.baseVal;
}

module.exports = getClass;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/matches.js":
/*!**********************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/matches.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check element match selector
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var inArray = __webpack_require__(/*! ../array/inArray */ "./node_modules/tui-code-snippet/array/inArray.js");
var toArray = __webpack_require__(/*! ../collection/toArray */ "./node_modules/tui-code-snippet/collection/toArray.js");

var elProto = Element.prototype;
var matchSelector = elProto.matches ||
    elProto.webkitMatchesSelector ||
    elProto.mozMatchesSelector ||
    elProto.msMatchesSelector ||
    function(selector) {
        var doc = this.document || this.ownerDocument;

        return inArray(this, toArray(doc.querySelectorAll(selector))) > -1;
    };

/**
 * Check element match selector
 * @param {HTMLElement} element - element to check
 * @param {string} selector - selector to check
 * @returns {boolean} is selector matched to element?
 * @memberof module:domUtil
 */
function matches(element, selector) {
    return matchSelector.call(element, selector);
}

module.exports = matches;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/removeClass.js":
/*!**************************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/removeClass.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Remove css class from element
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var forEachArray = __webpack_require__(/*! ../collection/forEachArray */ "./node_modules/tui-code-snippet/collection/forEachArray.js");
var inArray = __webpack_require__(/*! ../array/inArray */ "./node_modules/tui-code-snippet/array/inArray.js");
var getClass = __webpack_require__(/*! ./getClass */ "./node_modules/tui-code-snippet/domUtil/getClass.js");
var setClassName = __webpack_require__(/*! ./_setClassName */ "./node_modules/tui-code-snippet/domUtil/_setClassName.js");

/**
 * Remove css class from element
 * @param {(HTMLElement|SVGElement)} element - target element
 * @param {...string} cssClass - css classes to remove
 * @memberof module:domUtil
 */
function removeClass(element) {
    var cssClass = Array.prototype.slice.call(arguments, 1);
    var classList = element.classList;
    var origin, newClass;

    if (classList) {
        forEachArray(cssClass, function(name) {
            classList.remove(name);
        });

        return;
    }

    origin = getClass(element).split(/\s+/);
    newClass = [];
    forEachArray(origin, function(name) {
        if (inArray(name, cssClass) < 0) {
            newClass.push(name);
        }
    });

    setClassName(element, newClass);
}

module.exports = removeClass;


/***/ }),

/***/ "./node_modules/tui-code-snippet/domUtil/removeElement.js":
/*!****************************************************************!*\
  !*** ./node_modules/tui-code-snippet/domUtil/removeElement.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Remove element from parent node.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Remove element from parent node.
 * @param {HTMLElement} element - element to remove.
 * @memberof module:domUtil
 */
function removeElement(element) {
    if (element && element.parentNode) {
        element.parentNode.removeChild(element);
    }
}

module.exports = removeElement;


/***/ }),

/***/ "./node_modules/tui-code-snippet/object/extend.js":
/*!********************************************************!*\
  !*** ./node_modules/tui-code-snippet/object/extend.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Extend the target object from other objects.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * @module object
 */

/**
 * Extend the target object from other objects.
 * @param {object} target - Object that will be extended
 * @param {...object} objects - Objects as sources
 * @returns {object} Extended object
 * @memberof module:object
 */
function extend(target, objects) { // eslint-disable-line no-unused-vars
    var hasOwnProp = Object.prototype.hasOwnProperty;
    var source, prop, i, len;

    for (i = 1, len = arguments.length; i < len; i += 1) {
        source = arguments[i];
        for (prop in source) {
            if (hasOwnProp.call(source, prop)) {
                target[prop] = source[prop];
            }
        }
    }

    return target;
}

module.exports = extend;


/***/ }),

/***/ "./node_modules/tui-code-snippet/request/imagePing.js":
/*!************************************************************!*\
  !*** ./node_modules/tui-code-snippet/request/imagePing.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Request image ping.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var forEachOwnProperties = __webpack_require__(/*! ../collection/forEachOwnProperties */ "./node_modules/tui-code-snippet/collection/forEachOwnProperties.js");

/**
 * @module request
 */

/**
 * Request image ping.
 * @param {String} url url for ping request
 * @param {Object} trackingInfo infos for make query string
 * @returns {HTMLElement}
 * @memberof module:request
 * @example
 * var imagePing = require('tui-code-snippet/request/imagePing'); // node, commonjs
 *
 * imagePing('https://www.google-analytics.com/collect', {
 *     v: 1,
 *     t: 'event',
 *     tid: 'trackingid',
 *     cid: 'cid',
 *     dp: 'dp',
 *     dh: 'dh'
 * });
 */
function imagePing(url, trackingInfo) {
    var trackingElement = document.createElement('img');
    var queryString = '';
    forEachOwnProperties(trackingInfo, function(value, key) {
        queryString += '&' + key + '=' + value;
    });
    queryString = queryString.substring(1);

    trackingElement.src = url + '?' + queryString;

    trackingElement.style.display = 'none';
    document.body.appendChild(trackingElement);
    document.body.removeChild(trackingElement);

    return trackingElement;
}

module.exports = imagePing;


/***/ }),

/***/ "./node_modules/tui-code-snippet/request/sendHostname.js":
/*!***************************************************************!*\
  !*** ./node_modules/tui-code-snippet/request/sendHostname.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Send hostname on DOMContentLoaded.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isUndefined = __webpack_require__(/*! ../type/isUndefined */ "./node_modules/tui-code-snippet/type/isUndefined.js");
var imagePing = __webpack_require__(/*! ./imagePing */ "./node_modules/tui-code-snippet/request/imagePing.js");

var ms7days = 7 * 24 * 60 * 60 * 1000;

/**
 * Check if the date has passed 7 days
 * @param {number} date - milliseconds
 * @returns {boolean}
 * @private
 */
function isExpired(date) {
    var now = new Date().getTime();

    return now - date > ms7days;
}

/**
 * Send hostname on DOMContentLoaded.
 * To prevent hostname set tui.usageStatistics to false.
 * @param {string} appName - application name
 * @param {string} trackingId - GA tracking ID
 * @ignore
 */
function sendHostname(appName, trackingId) {
    var url = 'https://www.google-analytics.com/collect';
    var hostname = location.hostname;
    var hitType = 'event';
    var eventCategory = 'use';
    var applicationKeyForStorage = 'TOAST UI ' + appName + ' for ' + hostname + ': Statistics';
    var date = window.localStorage.getItem(applicationKeyForStorage);

    // skip if the flag is defined and is set to false explicitly
    if (!isUndefined(window.tui) && window.tui.usageStatistics === false) {
        return;
    }

    // skip if not pass seven days old
    if (date && !isExpired(date)) {
        return;
    }

    window.localStorage.setItem(applicationKeyForStorage, new Date().getTime());

    setTimeout(function() {
        if (document.readyState === 'interactive' || document.readyState === 'complete') {
            imagePing(url, {
                v: 1,
                t: hitType,
                tid: trackingId,
                cid: hostname,
                dp: hostname,
                dh: appName,
                el: appName,
                ec: eventCategory
            });
        }
    }, 1000);
}

module.exports = sendHostname;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isArray.js":
/*!*******************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isArray.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is an instance of Array or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is an instance of Array or not.
 * If the given variable is an instance of Array, return true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is array instance?
 * @memberof module:type
 */
function isArray(obj) {
    return obj instanceof Array;
}

module.exports = isArray;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isBoolean.js":
/*!*********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isBoolean.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is a string or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is a boolean or not.
 *  If the given variable is a boolean, return true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is boolean?
 * @memberof module:type
 */
function isBoolean(obj) {
    return typeof obj === 'boolean' || obj instanceof Boolean;
}

module.exports = isBoolean;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isExisty.js":
/*!********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isExisty.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is existing or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



var isUndefined = __webpack_require__(/*! ./isUndefined */ "./node_modules/tui-code-snippet/type/isUndefined.js");
var isNull = __webpack_require__(/*! ./isNull */ "./node_modules/tui-code-snippet/type/isNull.js");

/**
 * Check whether the given variable is existing or not.
 * If the given variable is not null and not undefined, returns true.
 * @param {*} param - Target for checking
 * @returns {boolean} Is existy?
 * @memberof module:type
 * @example
 * var isExisty = require('tui-code-snippet/type/isExisty'); // node, commonjs
 *
 * isExisty(''); //true
 * isExisty(0); //true
 * isExisty([]); //true
 * isExisty({}); //true
 * isExisty(null); //false
 * isExisty(undefined); //false
*/
function isExisty(param) {
    return !isUndefined(param) && !isNull(param);
}

module.exports = isExisty;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isFunction.js":
/*!**********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isFunction.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is a function or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is a function or not.
 * If the given variable is a function, return true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is function?
 * @memberof module:type
 */
function isFunction(obj) {
    return obj instanceof Function;
}

module.exports = isFunction;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isHTMLNode.js":
/*!**********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isHTMLNode.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is a instance of HTMLNode or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is a instance of HTMLNode or not.
 * If the given variables is a instance of HTMLNode, return true.
 * @param {*} html - Target for checking
 * @returns {boolean} Is HTMLNode ?
 * @memberof module:type
 */
function isHTMLNode(html) {
    if (typeof HTMLElement === 'object') {
        return (html && (html instanceof HTMLElement || !!html.nodeType));
    }

    return !!(html && html.nodeType);
}

module.exports = isHTMLNode;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isNull.js":
/*!******************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isNull.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is null or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is null or not.
 * If the given variable(arguments[0]) is null, returns true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is null?
 * @memberof module:type
 */
function isNull(obj) {
    return obj === null;
}

module.exports = isNull;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isNumber.js":
/*!********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isNumber.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is a number or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is a number or not.
 * If the given variable is a number, return true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is number?
 * @memberof module:type
 */
function isNumber(obj) {
    return typeof obj === 'number' || obj instanceof Number;
}

module.exports = isNumber;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isObject.js":
/*!********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isObject.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is an object or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is an object or not.
 * If the given variable is an object, return true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is object?
 * @memberof module:type
 */
function isObject(obj) {
    return obj === Object(obj);
}

module.exports = isObject;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isString.js":
/*!********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isString.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is a string or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is a string or not.
 * If the given variable is a string, return true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is string?
 * @memberof module:type
 */
function isString(obj) {
    return typeof obj === 'string' || obj instanceof String;
}

module.exports = isString;


/***/ }),

/***/ "./node_modules/tui-code-snippet/type/isUndefined.js":
/*!***********************************************************!*\
  !*** ./node_modules/tui-code-snippet/type/isUndefined.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * @fileoverview Check whether the given variable is undefined or not.
 * @author NHN FE Development Lab <dl_javascript@nhn.com>
 */



/**
 * Check whether the given variable is undefined or not.
 * If the given variable is undefined, returns true.
 * @param {*} obj - Target for checking
 * @returns {boolean} Is undefined?
 * @memberof module:type
 */
function isUndefined(obj) {
    return obj === undefined; // eslint-disable-line no-undefined
}

module.exports = isUndefined;


/***/ }),

/***/ "./src/css/selectBox.css":
/*!*******************************!*\
  !*** ./src/css/selectBox.css ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ "./src/js/constants.js":
/*!*****************************!*\
  !*** ./src/js/constants.js ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/collection/forEachOwnProperties */ "./node_modules/tui-code-snippet/collection/forEachOwnProperties.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _forEachOwnProperties) {
  "use strict";

  _exports.__esModule = true;
  _exports.cls = void 0;
  _forEachOwnProperties = _interopRequireDefault(_forEachOwnProperties);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /**
   * @fileoverview The static values
   * @author NHN. FE dev team.<dl_javascript@nhn.com>
   */
  var CSS_PREFIX = 'tui-select-box';
  var classNames = {
    SELECT_BOX: '',
    ITEM: 'item',
    ITEM_GROUP: 'item-group',
    ITEM_GROUP_LABEL: 'item-group-label',
    DROPDOWN: 'dropdown',
    INPUT: 'input',
    PLACEHOLDER: 'placeholder',
    ICON: 'icon',
    OPEN: 'open',
    HIDDEN: 'hidden',
    DISABLED: 'disabled',
    SELECTED: 'selected',
    HIGHLIGHT: 'highlight'
  };

  var cls = function () {
    (0, _forEachOwnProperties["default"])(classNames, function (value, key) {
      if (value) {
        classNames[key] = CSS_PREFIX + "-" + value;
      } else {
        classNames[key] = CSS_PREFIX;
      }
    });
    return classNames;
  }();

  _exports.cls = cls;
});

/***/ }),

/***/ "./src/js/dropdown.js":
/*!****************************!*\
  !*** ./src/js/dropdown.js ***!
  \****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/collection/forEachArray */ "./node_modules/tui-code-snippet/collection/forEachArray.js"), __webpack_require__(/*! tui-code-snippet/type/isExisty */ "./node_modules/tui-code-snippet/type/isExisty.js"), __webpack_require__(/*! tui-code-snippet/type/isNumber */ "./node_modules/tui-code-snippet/type/isNumber.js"), __webpack_require__(/*! tui-code-snippet/domUtil/addClass */ "./node_modules/tui-code-snippet/domUtil/addClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeClass */ "./node_modules/tui-code-snippet/domUtil/removeClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeElement */ "./node_modules/tui-code-snippet/domUtil/removeElement.js"), __webpack_require__(/*! ./utils */ "./src/js/utils.js"), __webpack_require__(/*! ./constants */ "./src/js/constants.js"), __webpack_require__(/*! ./itemGroup */ "./src/js/itemGroup.js"), __webpack_require__(/*! ./item */ "./src/js/item.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _forEachArray, _isExisty, _isNumber, _addClass, _removeClass, _removeElement, _utils, _constants, _itemGroup, _item) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _forEachArray = _interopRequireDefault(_forEachArray);
  _isExisty = _interopRequireDefault(_isExisty);
  _isNumber = _interopRequireDefault(_isNumber);
  _addClass = _interopRequireDefault(_addClass);
  _removeClass = _interopRequireDefault(_removeClass);
  _removeElement = _interopRequireDefault(_removeElement);
  _itemGroup = _interopRequireDefault(_itemGroup);
  _item = _interopRequireDefault(_item);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  /**
   * @class
   * @ignore
   * @param {object} options - options
   *   @param {string} [options.placeholder] - placeholder for an input
   *   @param {array<itemData|itemGroupData>} options.data - data for ItemGroups and Items
   *   @param {boolean} [options.disabled=false] - whether a dropdown should be disabled or not
   */
  var Dropdown =
  /*#__PURE__*/
  function () {
    function Dropdown(_ref) {
      var placeholder = _ref.placeholder,
          data = _ref.data,
          _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? false : _ref$disabled;

      /**
       * @type {HTMLElement}
       * @private
       */
      this.el = (0, _utils.createElement)('ul', '', {
        className: _constants.cls.DROPDOWN + " " + _constants.cls.HIDDEN
      });
      /**
       * @type {HTMLElement}
       * @private
       */

      this.nativeEl = (0, _utils.createElement)('select', '', {
        className: _constants.cls.HIDDEN,
        tabIndex: -1
      });
      /**
       * Items and ItemGroups
       * @type {Array.<Item|ItemGroup>}
       * @private
       */

      this.items = [];
      /**
       * the number of Item
       * @type {number}
       * @private
       */

      this.itemLength = 0;
      /**
       * @type {Item}
       * @private
       */

      this.selectedItem = null;
      /**
       * @type {Item}
       * @private
       */

      this.highlightedItem = null;
      this.initialize(data, disabled, placeholder);
    }
    /**
     * Create Items and ItemGroups and calculate the number of Items
     * @return {array<Item|ItemGroup>}
     * @private
     */


    var _proto = Dropdown.prototype;

    _proto.initializeItems = function initializeItems(data) {
      var _this = this;

      var item;
      var itemIndex = 0;
      var itemGroupIndex = 0;
      data.forEach(function (datum) {
        if (datum.data) {
          item = new _itemGroup["default"](_objectSpread({
            index: itemIndex,
            itemGroupIndex: itemGroupIndex
          }, datum));
          itemIndex += datum.data.length - 1;
          itemGroupIndex += 1;
        } else {
          item = new _item["default"](_objectSpread({
            index: itemIndex
          }, datum));
        }

        _this.items.push(item);

        item.appendToContainer(_this.el, _this.nativeEl);
        itemIndex += 1;
      });
      this.itemLength = itemIndex;
    }
    /**
     * Initialize
     * @private
     */
    ;

    _proto.initialize = function initialize(data, disabled, placeholder) {
      var _this2 = this;

      if (placeholder) {
        (0, _utils.createElement)('option', '', {
          label: placeholder,
          value: ''
        }, this.nativeEl);
      }

      this.initializeItems(data);
      this.iterateItems(function (item) {
        if (!_this2.selectedItem && item.isSelected()) {
          _this2.selectedItem = item;
        } else if (_this2.selectedItem && item.isSelected()) {
          item.deselect();
        }
      });

      if (disabled) {
        this.disable();
      }
    }
    /**
     * Execute a function while iterating items
     * @param {function} callback - function to execute
     * @param  {...any} args - arguments
     * @private
     */
    ;

    _proto.iterateItems = function iterateItems(callback) {
      var _this3 = this;

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var index = 0;
      (0, _forEachArray["default"])(this.items, function (item) {
        var result = true;

        if (item instanceof _itemGroup["default"]) {
          (0, _forEachArray["default"])(item.getItems(), function (itemInGroup) {
            result = callback.apply(_this3, [itemInGroup, index].concat(args)) || false;
            index += 1;
            return result;
          });
          return result;
        }

        result = callback.apply(_this3, [item, index].concat(args));
        index += 1;
        return result;
      });
    }
    /**
     * Open a dropdown list
     */
    ;

    _proto.open = function open() {
      (0, _removeClass["default"])(this.el, _constants.cls.HIDDEN);
      var highlightedItem = !this.selectedItem || this.selectedItem.isDisabled() ? this.getItems(function (item) {
        return !item.isDisabled();
      })[0] : this.selectedItem;
      this.highlight(highlightedItem);
    }
    /**
     * Close a dropdown list
     */
    ;

    _proto.close = function close() {
      (0, _addClass["default"])(this.el, _constants.cls.HIDDEN);
      this.dehighlight();
    }
    /**
     * Disable an dropdown
     */
    ;

    _proto.disable = function disable() {
      this.nativeEl.disabled = true;
      (0, _addClass["default"])(this.el, _constants.cls.DISABLED);
    }
    /**
     * Enable an dropdown
     */
    ;

    _proto.enable = function enable() {
      this.nativeEl.disabled = false;
      (0, _removeClass["default"])(this.el, _constants.cls.DISABLED);
    }
    /**
     * Select an Item
     * @param {string|number|Item} value - if string, find an Item by its value. if number, find an Item by its index.
     * @return {Item} result of selection
     */
    ;

    _proto.select = function select(value) {
      var selectedItem = value instanceof _item["default"] ? value : this.getItem(value);
      this.deselect();

      if (!selectedItem || selectedItem && selectedItem.isDisabled()) {
        return null;
      }

      selectedItem.select();
      this.selectedItem = selectedItem;
      return selectedItem;
    }
    /**
     * Deselect an Item
     */
    ;

    _proto.deselect = function deselect() {
      if (this.selectedItem) {
        this.selectedItem.deselect();
        this.selectedItem = null;
      }
    }
    /**
     * Highlight an Item
     * @param {number|string|Item} value - if string, find an Item by its value. if number, find an Item by its index.
     */
    ;

    _proto.highlight = function highlight(value) {
      var highlightedItem;

      if (value instanceof _item["default"]) {
        highlightedItem = value;
      } else if ((0, _isExisty["default"])(value)) {
        highlightedItem = this.getItem(value);
      }

      if (highlightedItem && highlightedItem !== this.highlightedItem) {
        this.dehighlight();
        highlightedItem.highlight();
        this.highlightedItem = highlightedItem;
      }
    }
    /**
     * Dehighlight an Item
     */
    ;

    _proto.dehighlight = function dehighlight() {
      if (this.highlightedItem) {
        this.highlightedItem.dehighlight();
        this.highlightedItem = null;
      }
    }
    /**
     * Move a highlighted Item
     * @param {number} direction - direction to move
     */
    ;

    _proto.moveHighlightedItem = function moveHighlightedItem(direction) {
      var highlightedItem = this.getHighlightedItem();
      var items = this.getItems();
      var index = items.indexOf(highlightedItem);

      if (index > -1) {
        index += direction;

        for (; index < items.length && index >= 0; index += direction) {
          if (!items[index].isDisabled()) {
            this.highlight(items[index]);
            break;
          }
        }
      }
    }
    /**
     * Get all Items that pass the test implemented by the provided function
     * If filter function is not passed, it returns all Items
     * @param {function} callback - callback function to filter items
     * @param {number} number - the number of items to find. -1 means all items.
     * @return {array<Item>}
     */
    ;

    _proto.getItems = function getItems(callback, number) {
      if (callback === void 0) {
        callback = function callback() {
          return true;
        };
      }

      if (number === void 0) {
        number = -1;
      }

      var items = [];
      this.iterateItems(function (item) {
        if (callback(item)) {
          items.push(item);
          number -= 1;
          return number !== 0;
        }

        return true;
      });
      return items;
    }
    /**
     * Get an Item by its index or value
     * @param {number|string} value - if string, the Item's value. if number, the Item's index.
     * @return {Item}
     */
    ;

    _proto.getItem = function getItem(value) {
      var isValidItem = (0, _isNumber["default"])(value) ? function (comparedItem) {
        return comparedItem.getIndex() === value;
      } : function (comparedItem) {
        return comparedItem.getValue() === value;
      };
      return this.getItems(isValidItem, 1)[0];
    }
    /**
     * Get all ItemGroups that pass the test implemented by the provided function
     * If filter function is not passed, it returns all ItemGroups
     * @param {function} callback - callback function to filter item groups
     * @param {number} number - the number of item groups to find. -1 means all item groups.
     * @return {array<ItemGroup>}
     */
    ;

    _proto.getItemGroups = function getItemGroups(callback, number) {
      if (callback === void 0) {
        callback = function callback() {
          return true;
        };
      }

      if (number === void 0) {
        number = -1;
      }

      var itemGroups = [];
      (0, _forEachArray["default"])(this.items, function (itemGroup) {
        if (itemGroup instanceof _itemGroup["default"] && callback(itemGroup)) {
          itemGroups.push(itemGroup);
          number -= 1;
          return number !== 0;
        }

        return true;
      });
      return itemGroups;
    }
    /**
     * Get an ItemGroup by its index
     * @param {number} index - groupIndex of the ItemGroup
     * @return {ItemGroup}
     */
    ;

    _proto.getItemGroup = function getItemGroup(index) {
      return this.getItemGroups(function (itemGroup) {
        return itemGroup.getIndex() === index;
      }, 1)[0];
    }
    /**
     * Return the number of Items
     * @return {number}
     */
    ;

    _proto.getItemLength = function getItemLength() {
      return this.itemLength;
    }
    /**
     * Return the selected Item
     * @return {Item}
     */
    ;

    _proto.getSelectedItem = function getSelectedItem() {
      return this.selectedItem;
    }
    /**
     * Return the highlighted Item
     * @return {Item}
     */
    ;

    _proto.getHighlightedItem = function getHighlightedItem() {
      return this.highlightedItem;
    }
    /**
     * Append the element and native element to the container
     * @param {HTMLElement} container - container element
     */
    ;

    _proto.appendToContainer = function appendToContainer(container) {
      container.appendChild(this.el);
      container.appendChild(this.nativeEl);
    }
    /**
     * Destory a dropdown
     */
    ;

    _proto.destroy = function destroy() {
      this.items.forEach(function (item) {
        return item.destroy();
      });
      (0, _removeElement["default"])(this.el);
      (0, _removeElement["default"])(this.nativeEl);
      this.el = this.nativeEl = this.items = this.selectedItem = this.highlightedItem = null;
    };

    return Dropdown;
  }();

  _exports["default"] = Dropdown;
});

/***/ }),

/***/ "./src/js/index.js":
/*!*************************!*\
  !*** ./src/js/index.js ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! ./selectBox */ "./src/js/selectBox.js"), __webpack_require__(/*! ../css/selectBox.css */ "./src/css/selectBox.css")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _selectBox, _selectBox2) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _selectBox = _interopRequireDefault(_selectBox);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /**
   * @fileoverview
   * @author NHN FE Development Lab <dl_javascript@nhn.com>
   */
  var _default = _selectBox["default"];
  _exports["default"] = _default;
});

/***/ }),

/***/ "./src/js/input.js":
/*!*************************!*\
  !*** ./src/js/input.js ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/domUtil/addClass */ "./node_modules/tui-code-snippet/domUtil/addClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeClass */ "./node_modules/tui-code-snippet/domUtil/removeClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeElement */ "./node_modules/tui-code-snippet/domUtil/removeElement.js"), __webpack_require__(/*! ./utils */ "./src/js/utils.js"), __webpack_require__(/*! ./constants */ "./src/js/constants.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _addClass, _removeClass, _removeElement, _utils, _constants) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _addClass = _interopRequireDefault(_addClass);
  _removeClass = _interopRequireDefault(_removeClass);
  _removeElement = _interopRequireDefault(_removeElement);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /**
   * @fileoverview Input
   * @author NHN FE Development Lab <dl_javascript@nhn.com>
   */

  /**
   * @class
   * @ignore
   * @param {object} options - options
   *   @param {string} [options.placeholder] - placeholder for a select box
   *   @param {string} [options.disabled] - whether an input should be disabled or not
   *   @param {boolean} [options.showIcon] - whether an arrow icon in the input should be shown
   */
  var Input =
  /*#__PURE__*/
  function () {
    function Input(_ref) {
      var placeholder = _ref.placeholder,
          disabled = _ref.disabled,
          showIcon = _ref.showIcon;

      /**
       * text for a placeholder
       * @type {string}
       * @private
       */
      this.placeholderText = placeholder;
      /**
       * @type {HTMLElement}
       * @private
       */

      this.el = (0, _utils.createElement)('div', '', {
        className: _constants.cls.INPUT,
        tabIndex: 0
      });
      /**
       * @type {HTMLElement}
       * @private
       */

      this.placeholderEl = (0, _utils.createElement)('p', this.placeholderText, {
        className: _constants.cls.PLACEHOLDER
      }, this.el);
      this.initialize(disabled, showIcon);
    }
    /**
     * Initialize
     * @private
     */


    var _proto = Input.prototype;

    _proto.initialize = function initialize(disabled, showIcon) {
      if (showIcon) {
        (0, _utils.createElement)('span', 'select', {
          className: _constants.cls.ICON
        }, this.el);
      } else {
        this.placeholderEl.width = '100%';
      }

      if (disabled) {
        this.disable();
      }
    }
    /**
     * Disable an input
     */
    ;

    _proto.disable = function disable() {
      (0, _addClass["default"])(this.el, _constants.cls.DISABLED);
    }
    /**
     * Enable an input
     */
    ;

    _proto.enable = function enable() {
      (0, _removeClass["default"])(this.el, _constants.cls.DISABLED);
    }
    /**
     * Open an input
     */
    ;

    _proto.open = function open() {
      (0, _addClass["default"])(this.el, _constants.cls.OPEN);
    }
    /**
     * Close an input
     */
    ;

    _proto.close = function close() {
      (0, _removeClass["default"])(this.el, _constants.cls.OPEN);
    }
    /**
     * Focus
     */
    ;

    _proto.focus = function focus() {
      this.el.focus();
    }
    /**
     * Change the text in the placeholder
     * @param {Item} item - selected Item
     */
    ;

    _proto.changeText = function changeText(item) {
      if (item) {
        this.placeholderEl.innerText = item.getLabel();
      } else {
        this.placeholderEl.innerText = this.placeholderText;
      }
    }
    /**
     * Append the element to the container
     * @param {HTMLElement} container - container element
     */
    ;

    _proto.appendToContainer = function appendToContainer(container) {
      container.appendChild(this.el);
    }
    /**
     * Destroy an input
     */
    ;

    _proto.destroy = function destroy() {
      (0, _removeElement["default"])(this.el);
      this.el = this.placeholderEl = null;
    };

    return Input;
  }();

  _exports["default"] = Input;
});

/***/ }),

/***/ "./src/js/item.js":
/*!************************!*\
  !*** ./src/js/item.js ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/domUtil/addClass */ "./node_modules/tui-code-snippet/domUtil/addClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeClass */ "./node_modules/tui-code-snippet/domUtil/removeClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeElement */ "./node_modules/tui-code-snippet/domUtil/removeElement.js"), __webpack_require__(/*! ./utils */ "./src/js/utils.js"), __webpack_require__(/*! ./constants */ "./src/js/constants.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _addClass, _removeClass, _removeElement, _utils, _constants) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _addClass = _interopRequireDefault(_addClass);
  _removeClass = _interopRequireDefault(_removeClass);
  _removeElement = _interopRequireDefault(_removeElement);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /**
   * @fileoverview Item
   * @author NHN FE Development Lab <dl_javascript@nhn.com>
   */

  /**
   * @class
   * @description
   * An item.
   * You can get Item by {@link SelectBox#getItem SelectBox.getItem()} and {@link SelectBox#getItems SelectBox.getItems()}.
   */
  var Item =
  /*#__PURE__*/
  function () {
    /**
     * @hideconstructor
     * @param {object} options - options
     *   @param {string} [options.label] - label to be displayed in the drop-down list
     *   @param {string} options.value - value of an item
     *   @param {boolean} [options.disabled=false] - whether an Item should be disabled or not
     *   @param {boolean} [options.selected=false] - whether an Item should be pre-selected or not
     *   @param {number} options.index - Item's index
     */
    function Item(_ref) {
      var value = _ref.value,
          label = _ref.label,
          disabled = _ref.disabled,
          selected = _ref.selected,
          index = _ref.index;

      /**
       * value of an item
       * @type {string}
       * @private
       */
      this.value = "" + value;
      /**
       * label to be displayed in the drop-down list
       * if label is an empty string, it should be same as its value
       * @type {string}
       * @private
       */

      this.label = label || this.value;
      /**
       * @type {number}
       * @private
       */

      this.index = index;
      /**
       * whether an ItemGroup of the Item is disabled or not
       * @type {boolean}
       * @private
       */

      this.itemGroupDisabled = false;
      /**
       * whether an Item is disabled or not
       * @type {boolean}
       * @private
       */

      this.itemDisabled = false;
      /**
       * @type {boolean}
       * @private
       */

      this.selected = false;
      /**
       * <li> element for a custom dropdown item
       * @type {HTMLElement}
       * @private
       */

      this.el = (0, _utils.createElement)('li', this.label, {
        className: _constants.cls.ITEM,
        tabIndex: -1,
        'data-value': this.value,
        'data-index': this.index
      });
      /**
       * <option> element for a select element
       * @type {HTMLElement}
       * @private
       */

      this.nativeEl = (0, _utils.createElement)('option', '', {
        value: this.value,
        label: this.label
      });
      this.initialize(disabled, selected);
    }
    /**
     * Initialize
     * @private
     */


    var _proto = Item.prototype;

    _proto.initialize = function initialize(disabled, selected) {
      if (selected) {
        this.select();
      }

      if (disabled) {
        this.disable();
      }
    }
    /**
     * Make an Item disable
     * @private
     */
    ;

    _proto.makeDisable = function makeDisable() {
      this.nativeEl.disabled = true;
      (0, _addClass["default"])(this.el, _constants.cls.DISABLED);
    }
    /**
     * Make an Item enable
     * @private
     */
    ;

    _proto.makeEnable = function makeEnable() {
      this.nativeEl.disabled = false;
      (0, _removeClass["default"])(this.el, _constants.cls.DISABLED);
    }
    /**
     * Disable an Item due to an ItemGroup
     * @ignore
     */
    ;

    _proto.disableItemGroup = function disableItemGroup() {
      this.itemGroupDisabled = true;
      this.makeDisable();
    }
    /**
     * Enable an Item due to an ItemGroup
     * @ignore
     */
    ;

    _proto.enableItemGroup = function enableItemGroup() {
      this.itemGroupDisabled = false;

      if (!this.isDisabled()) {
        this.makeEnable();
      }
    }
    /**
     * Disable an Item
     * @ignore
     */
    ;

    _proto.disable = function disable() {
      this.itemDisabled = true;
      this.makeDisable();
    }
    /**
     * Enable an Item
     * @ignore
     */
    ;

    _proto.enable = function enable() {
      this.itemDisabled = false;

      if (!this.isDisabled()) {
        this.makeEnable();
      }
    }
    /**
     * Select an Item
     * @ignore
     */
    ;

    _proto.select = function select() {
      if (!this.isDisabled()) {
        this.selected = this.nativeEl.selected = true;
        (0, _addClass["default"])(this.el, _constants.cls.SELECTED);
      }
    }
    /**
     * Deselect an Item
     * @ignore
     */
    ;

    _proto.deselect = function deselect() {
      this.selected = this.nativeEl.selected = false;
      (0, _removeClass["default"])(this.el, _constants.cls.SELECTED);
    }
    /**
     * Highlight an Item
     * @ignore
     */
    ;

    _proto.highlight = function highlight() {
      if (!this.isDisabled()) {
        (0, _addClass["default"])(this.el, _constants.cls.HIGHLIGHT);
        this.el.focus();
      }
    }
    /**
     * Remove a highlight from an Item
     * @ignore
     */
    ;

    _proto.dehighlight = function dehighlight() {
      (0, _removeClass["default"])(this.el, _constants.cls.HIGHLIGHT);
      this.el.blur();
    }
    /**
     * Return an item's value.
     * @return {string}
     */
    ;

    _proto.getValue = function getValue() {
      return this.value;
    }
    /**
     * Return an item's label.
     * @return {string}
     */
    ;

    _proto.getLabel = function getLabel() {
      return this.label;
    }
    /**
     * Return an item's index.
     * @return {number}
     */
    ;

    _proto.getIndex = function getIndex() {
      return this.index;
    }
    /**
     * Return whether an item is selected or not.
     * @return {boolean}
     */
    ;

    _proto.isSelected = function isSelected() {
      return this.selected;
    }
    /**
     * Return whether an item is disabled or not.
     * The result is true if any of the items and item groups are disabled.
     * @return {boolean}
     */
    ;

    _proto.isDisabled = function isDisabled() {
      return this.itemDisabled || this.itemGroupDisabled;
    }
    /**
     * Append the element and native element to the containers
     * @param {HTMLElement} container - container element
     * @param {HTMLElement} nativeContainer - native container element
     * @ignore
     */
    ;

    _proto.appendToContainer = function appendToContainer(container, nativeContainer) {
      container.appendChild(this.el);
      nativeContainer.appendChild(this.nativeEl);
    }
    /**
     * Destroy an Item
     * @ignore
     */
    ;

    _proto.destroy = function destroy() {
      (0, _removeElement["default"])(this.el);
      (0, _removeElement["default"])(this.nativeEl);
      this.el = this.nativeEl = null;
    };

    return Item;
  }();

  _exports["default"] = Item;
});

/***/ }),

/***/ "./src/js/itemGroup.js":
/*!*****************************!*\
  !*** ./src/js/itemGroup.js ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/domUtil/addClass */ "./node_modules/tui-code-snippet/domUtil/addClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeClass */ "./node_modules/tui-code-snippet/domUtil/removeClass.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeElement */ "./node_modules/tui-code-snippet/domUtil/removeElement.js"), __webpack_require__(/*! ./utils */ "./src/js/utils.js"), __webpack_require__(/*! ./constants */ "./src/js/constants.js"), __webpack_require__(/*! ./item */ "./src/js/item.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _addClass, _removeClass, _removeElement, _utils, _constants, _item) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _addClass = _interopRequireDefault(_addClass);
  _removeClass = _interopRequireDefault(_removeClass);
  _removeElement = _interopRequireDefault(_removeElement);
  _item = _interopRequireDefault(_item);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  /**
   * @class
   * @description
   * A group of items.
   * You can get ItemGroup by {@link SelectBox#getItemGroup SelectBox.getItemGroup()} and {@link SelectBox#getItemGroups SelectBox.getItemGroups()}.
   */
  var ItemGroup =
  /*#__PURE__*/
  function () {
    /**
     * @hideconstructor
     * @param {object} options - options
     *   @param {string} [options.label] - label to be displayed in the dropdown list
     *   @param {array<itemData>} options.data - data for Items to be included in the ItemGroup
     *   @param {boolean} [options.disabled=false] - whether an ItemGroup should be disabled or not
     *   @param {number} options.index - index of the first Item in the ItemGroup
     *   @param {number} options.itemGroupIndex - index of the ItemGroup
     */
    function ItemGroup(_ref) {
      var _ref$label = _ref.label,
          label = _ref$label === void 0 ? '' : _ref$label,
          data = _ref.data,
          _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? false : _ref$disabled,
          index = _ref.index,
          itemGroupIndex = _ref.itemGroupIndex;

      /**
       * @type {HTMLElement}
       * @private
       */
      this.el = (0, _utils.createElement)('li', '', {
        'data-group-index': itemGroupIndex
      });
      /**
       * @type {HTMLElement}
       * @private
       */

      this.labelEl = (0, _utils.createElement)('span', label, {
        className: _constants.cls.ITEM_GROUP_LABEL
      }, this.el);
      /**
       * @type {HTMLElement}
       * @private
       */

      this.itemContainerEl = (0, _utils.createElement)('ul', '', {
        className: _constants.cls.ITEM_GROUP
      }, this.el);
      /**
       * @type {HTMLElement}
       * @private
       */

      this.nativeEl = (0, _utils.createElement)('optgroup', label);
      /**
       * @type {array<Item>}
       * @private
       */

      this.items = this.createItems(data, index);
      /**
       * @type {number}
       * @private
       */

      this.index = itemGroupIndex;
      /**
       * @type {string}
       * @private
       */

      this.label = label;
      /**
       * whether an ItemGroup is disabled or not
       * @type {boolean}
       * @private
       */

      this.disabled = false;
      this.initialize(disabled);
    }
    /**
     * Create Items to be included in the ItemGroup
     * @return {array<Item>}
     * @private
     */


    var _proto = ItemGroup.prototype;

    _proto.createItems = function createItems(data, index) {
      var _this = this;

      return data.map(function (datum, itemIndex) {
        var item = new _item["default"](_objectSpread({
          index: index + itemIndex
        }, datum));
        item.appendToContainer(_this.itemContainerEl, _this.nativeEl);
        return item;
      });
    }
    /**
     * Initialize
     * @private
     */
    ;

    _proto.initialize = function initialize(disabled) {
      if (disabled) {
        this.disable();
      }
    }
    /**
     * Disable an ItemGroup
     * @ignore
     */
    ;

    _proto.disable = function disable() {
      this.disabled = this.nativeEl.disabled = true;
      (0, _addClass["default"])(this.labelEl, _constants.cls.DISABLED);
      this.items.forEach(function (item) {
        return item.disableItemGroup();
      });
    }
    /**
     * Enable an ItemGroup
     * @ignore
     */
    ;

    _proto.enable = function enable() {
      this.disabled = this.nativeEl.disabled = false;
      (0, _removeClass["default"])(this.labelEl, _constants.cls.DISABLED);
      this.items.forEach(function (item) {
        return item.enableItemGroup();
      });
    }
    /**
     * Get {@link Item items} in the item group.
     * @return {array<Item>}
     * @example
     * const items = itemGroup.getItems();
     * console.log(items[0]); // first item in the item group
     * console.log(items.length); // the number of items in the item group
     */
    ;

    _proto.getItems = function getItems() {
      return this.items;
    }
    /**
     * Return an item group's index.
     * @return {number}
     */
    ;

    _proto.getIndex = function getIndex() {
      return this.index;
    }
    /**
     * Return an item group's label.
     * @return {string}
     */
    ;

    _proto.getLabel = function getLabel() {
      return this.label;
    }
    /**
     * Return whether an ItemGroup is disabled or not.
     * @return {boolean}
     */
    ;

    _proto.isDisabled = function isDisabled() {
      return this.disabled;
    }
    /**
     * Append the element and native element to the containers
     * @param {HTMLElement} container - container element
     * @param {HTMLElement} nativeContainer - native container element
     * @ignore
     */
    ;

    _proto.appendToContainer = function appendToContainer(container, nativeContainer) {
      container.appendChild(this.el);
      nativeContainer.appendChild(this.nativeEl);
    }
    /**
     * Destory an ItemGroup
     * @ignore
     */
    ;

    _proto.destroy = function destroy() {
      this.items.forEach(function (item) {
        return item.destroy();
      });
      (0, _removeElement["default"])(this.el);
      (0, _removeElement["default"])(this.nativeEl);
      this.el = this.labelEl = this.itemContainerEl = this.nativeEl = this.items = null;
    };

    return ItemGroup;
  }();

  _exports["default"] = ItemGroup;
});

/***/ }),

/***/ "./src/js/keyEventUtils.js":
/*!*********************************!*\
  !*** ./src/js/keyEventUtils.js ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports) {
  "use strict";

  _exports.__esModule = true;
  _exports.identifyKey = void 0;

  /**
   * @fileoverview Utility functions related to key events
   * @author NHN. FE dev team.<dl_javascript@nhn.com>
   */
  var keyCodeMap = {
    38: 'arrowUp',
    40: 'arrowDown',
    32: 'space',
    13: 'enter',
    27: 'escape',
    61: 'tab'
  };
  var keyMap = {
    ArrowUp: 'arrowUp',
    Up: 'arrowUp',
    ArrowDown: 'arrowDown',
    Down: 'arrowDown',
    ' ': 'space',
    Spacebar: 'space',
    Enter: 'enter',
    Escape: 'escape',
    Esc: 'escape',
    Tab: 'tab'
  };
  /**
   * Identify the key (polyfill for IE)
   * @param {string} ev - keyboard event
   * @return {string} - key
   */

  var identifyKey = function identifyKey(ev) {
    var key = ev.key,
        keyCode = ev.keyCode;

    if (key) {
      return keyMap[key] || key;
    }

    return keyCodeMap[keyCode] || keyCode;
  };

  _exports.identifyKey = identifyKey;
});

/***/ }),

/***/ "./src/js/selectBox.js":
/*!*****************************!*\
  !*** ./src/js/selectBox.js ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/customEvents/customEvents */ "./node_modules/tui-code-snippet/customEvents/customEvents.js"), __webpack_require__(/*! tui-code-snippet/domEvent/on */ "./node_modules/tui-code-snippet/domEvent/on.js"), __webpack_require__(/*! tui-code-snippet/domEvent/off */ "./node_modules/tui-code-snippet/domEvent/off.js"), __webpack_require__(/*! tui-code-snippet/domEvent/preventDefault */ "./node_modules/tui-code-snippet/domEvent/preventDefault.js"), __webpack_require__(/*! tui-code-snippet/domEvent/getTarget */ "./node_modules/tui-code-snippet/domEvent/getTarget.js"), __webpack_require__(/*! tui-code-snippet/domUtil/closest */ "./node_modules/tui-code-snippet/domUtil/closest.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeElement */ "./node_modules/tui-code-snippet/domUtil/removeElement.js"), __webpack_require__(/*! tui-code-snippet/type/isObject */ "./node_modules/tui-code-snippet/type/isObject.js"), __webpack_require__(/*! tui-code-snippet/type/isExisty */ "./node_modules/tui-code-snippet/type/isExisty.js"), __webpack_require__(/*! tui-code-snippet/type/isHTMLNode */ "./node_modules/tui-code-snippet/type/isHTMLNode.js"), __webpack_require__(/*! tui-code-snippet/request/sendHostname */ "./node_modules/tui-code-snippet/request/sendHostname.js"), __webpack_require__(/*! ./utils */ "./src/js/utils.js"), __webpack_require__(/*! ./keyEventUtils */ "./src/js/keyEventUtils.js"), __webpack_require__(/*! ./constants */ "./src/js/constants.js"), __webpack_require__(/*! ./input */ "./src/js/input.js"), __webpack_require__(/*! ./dropdown */ "./src/js/dropdown.js"), __webpack_require__(/*! ./itemGroup */ "./src/js/itemGroup.js"), __webpack_require__(/*! ./item */ "./src/js/item.js"), __webpack_require__(/*! ./theme */ "./src/js/theme.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _customEvents, _on, _off, _preventDefault, _getTarget, _closest, _removeElement, _isObject, _isExisty, _isHTMLNode, _sendHostname, _utils, _keyEventUtils, _constants, _input, _dropdown, _itemGroup, _item, _theme) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _customEvents = _interopRequireDefault(_customEvents);
  _on = _interopRequireDefault(_on);
  _off = _interopRequireDefault(_off);
  _preventDefault = _interopRequireDefault(_preventDefault);
  _getTarget = _interopRequireDefault(_getTarget);
  _closest = _interopRequireDefault(_closest);
  _removeElement = _interopRequireDefault(_removeElement);
  _isObject = _interopRequireDefault(_isObject);
  _isExisty = _interopRequireDefault(_isExisty);
  _isHTMLNode = _interopRequireDefault(_isHTMLNode);
  _sendHostname = _interopRequireDefault(_sendHostname);
  _input = _interopRequireDefault(_input);
  _dropdown = _interopRequireDefault(_dropdown);
  _itemGroup = _interopRequireDefault(_itemGroup);
  _item = _interopRequireDefault(_item);
  _theme = _interopRequireDefault(_theme);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /**
   * @fileoverview SelectBox
   * @author NHN FE Development Lab <dl_javascript@nhn.com>
   */

  /**
   * @class
   * @param {HTMLElement|string} container - container element or selector
   * @mixes CustomEvents
   * @param {object} options
   *   @param {array<itemData|itemGroupData>} options.data - array of {@link itemData} and {@link itemGroupData}
   *   @param {string} [options.placeholder] - placeholder for an input
   *   @param {boolean} [options.disabled] - whether an Item should be disabled or not
   *   @param {boolean} [options.autofocus] - whether a selectbox should get focus when the select box appends to the container
   *   @param {boolean} [options.autoclose] - whether a selectbox should close after selection
   *   @param {boolean} [options.showIcon] - whether an arrow icon in the input should be shown
   *   @param {object} [options.theme] - {@link themeConfig} for custom style
   *   @param {boolean} [options.usageStatistics] - whether send hostname to google analytics. If you don't want to send the hostname, please set to false.
   * @example
   * import SelectBox from '@toast-ui/select-box';
   * // or const SelectBox = require('@toast-ui/select-box');
   * // or const SelectBox = tui.SelectBox;
   *
   * const selectBox = new SelectBox('#select-box', {
   *   placeholder: 'Please select an option.',
   *   data: [
   *     {
   *       label: 'Fruits',
   *       data: [ { label: 'Apple', value: 'apple' }, { label: 'Banana', value: 'banana' } ]
   *     },
   *     { label: 'The quick brown fox jumps over the lazy dog.', value: 'none' },
   *     {
   *       label: 'Colors',
   *       data: [
   *         { label: 'Red', value: 'red' },
   *         { label: 'Yellow', value: 'yellow' },
   *         { label: 'Green', value: 'green', disabled: true },
   *         { label: 'Blue', value: 'blue', disabled: true },
   *         { label: 'Purple', value: 'purple' }
   *       ]
   *     }
   *   ],
   *   autofocus: true,
   *   showIcon: false,
   *   theme: {
   *     'common.border': '1px solid black',
   *     'common.color': 'black',
   *     'item.highlighted.background': 'yellow'
   *   }
   * });
   */

  /**
   * SelectBox provides some custom events: ({@link SelectBox#event-open open}, {@link SelectBox#event-close close}, {@link SelectBox#event-disable disable}, {@link SelectBox#event-enable enable}, {@link SelectBox#event-change change}).
   * You can bind event handlers by {@link https://nhn.github.io/tui.code-snippet/latest/CustomEvents#on selectBox.on(eventName, handler)} and unbind by {@link https://nhn.github.io/tui.code-snippet/latest/CustomEvents#off selectBox.off(eventName, handler)}.
   * Refer to the {@link https://nhn.github.io/tui.code-snippet/latest/CustomEvents CustomEvents} document at {@link https://github.com/nhn/tui.code-snippet tui-code-snippet} to know how to bind, and unbind custom events.
   * The example using custom events can be found {@link tutorial-example03-custom-events here}.
   * @typedef {class} CustomEvents
   * @example
   * // bind 'change' event
   * selectBox.on('change', ev => {
   *   console.log(`selected item is changed from ${ev.prev.getLabel()} to ${ev.curr.getLabel()}.`);
   * });
   *
   * // bind 'disable' and enable event
   * const print = ev => {
   *   let target = '';
   *   if (ev.target instanceof SelectBox) {
   *     target = 'Select box';
   *   } else {
   *     target = ev.target.getLabel();
   *   }
   *   console.log(`${target} is ${ev.type}.`);
   * }
   * selectBox.on({
   *   disable: print,
   *   enable: print
   * });
   *
   * // unbind change event
   * selectBox.off('change');
   *
   * // unbind disable event
   * selectBox.off(disable, print);
   *
   * // unbind all events
   * selectBox.off();
   */

  /**
   * Data of an {@link Item item}.
   * It is used for creating a {@link SelectBox}.
   * @typedef {object} itemData - data for {@link Item item}
   * @property {string} label - label to be displayed
   * @property {string} value - value of an item
   * @property {boolean} [disabled=false] - whether an item should be disabled or not
   * @property {boolean} [selected=false] - whether an item should be pre-selected or not
   * @example
   * const itemData = {
   *   label: 'disabled item',
   *   value: '0',
   *   disabled: true,
   *   selected: false
   * };
   */

  /**
   * Data of an {@link ItemGroup item group}.
   * It is used for creating a {@link SelectBox}.
   * ItemGroup supports only 1 level choices, so it does not work to add item groups in the item group.
   * The example using item groups can be found {@link tutorial-example01-basic here}.
   * @typedef {object} itemGroupData - data for {@link ItemGroup item group}
   * @property {string} label - label to be displayed
   * @property {array} data - {@link itemData data for item}
   * @property {boolean} [disabled=false] - whether an item group should be disabled or not
   * @example
   * const itemGroupData = {
   *   label: 'disabled items',
   *   data: [
   *     { label: 'disable', value: 'disable' },
   *     { label: 'none', value: '0' }
   *   ],
   *   disabled: true
   * };
   */
  var SelectBox =
  /*#__PURE__*/
  function () {
    function SelectBox(container, _ref) {
      var data = _ref.data,
          _ref$placeholder = _ref.placeholder,
          placeholder = _ref$placeholder === void 0 ? '' : _ref$placeholder,
          _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? false : _ref$disabled,
          _ref$autofocus = _ref.autofocus,
          autofocus = _ref$autofocus === void 0 ? false : _ref$autofocus,
          _ref$autoclose = _ref.autoclose,
          autoclose = _ref$autoclose === void 0 ? true : _ref$autoclose,
          _ref$showIcon = _ref.showIcon,
          showIcon = _ref$showIcon === void 0 ? true : _ref$showIcon,
          theme = _ref.theme,
          _ref$usageStatistics = _ref.usageStatistics,
          usageStatistics = _ref$usageStatistics === void 0 ? true : _ref$usageStatistics;

      /**
       * @type {HTMLElement}
       * @private
       */
      this.el = (0, _utils.createElement)('div', '', {
        className: _constants.cls.SELECT_BOX
      });
      /**
       * @type {Input}
       * @private
       */

      this.input = new _input["default"]({
        placeholder: placeholder,
        disabled: disabled,
        showIcon: showIcon
      });
      /**
       * @type {Dropdown}
       * @private
       */

      this.dropdown = new _dropdown["default"]({
        placeholder: placeholder,
        disabled: disabled,
        data: data
      });
      /**
       * @type {boolean}
       * @private
       */

      this.opened = false;
      /**
       * @type {boolean}
       * @private
       */

      this.diabled = false;
      /**
       * @type {boolean}
       */

      this.autoclose = autoclose;
      /**
       * @type {Theme}
       * @private
       */

      this.theme = (0, _isObject["default"])(theme) ? new _theme["default"](theme, container) : null;
      this.initialize({
        placeholder: placeholder,
        disabled: disabled
      });
      this.appendToContainer(container);

      if (autofocus) {
        this.input.focus();
      }

      if (usageStatistics) {
        (0, _sendHostname["default"])('select-box', 'UA-129987462-1');
      }
    }
    /**
     * Append the select box element to the container
     * @param {HTMLElement|string} container - container element or selector
     * @private
     */


    var _proto = SelectBox.prototype;

    _proto.appendToContainer = function appendToContainer(container) {
      var containerEl = (0, _isHTMLNode["default"])(container) ? container : document.querySelector(container);
      containerEl.appendChild(this.el);
    }
    /**
     * Initialize
     * @param {object} options - options
     * @private
     */
    ;

    _proto.initialize = function initialize(options) {
      var selectedItem = this.getSelectedItem();

      if (selectedItem) {
        this.input.changeText(selectedItem);
      } else if (!options.placeholder) {
        this.select(0);
      }

      if (options.disabled) {
        this.disable();
      }

      this.bindEvents();
      this.input.appendToContainer(this.el);
      this.dropdown.appendToContainer(this.el);
    }
    /**
     * Bind events
     * @private
     */
    ;

    _proto.bindEvents = function bindEvents() {
      var _this = this;

      (0, _on["default"])(document, 'click', function (ev) {
        var target = (0, _getTarget["default"])(ev);

        if (!(0, _closest["default"])(target, "." + _constants.cls.SELECT_BOX) && _this.opened) {
          _this.close();
        }
      }, this);
      (0, _on["default"])(this.el, 'click', function (ev) {
        return _this.handleClick(ev, _constants.cls);
      });
      (0, _on["default"])(this.el, 'mouseover', function (ev) {
        return _this.handleMouseover(ev, _constants.cls);
      });
      (0, _on["default"])(this.el, 'keydown', function (ev) {
        return _this.handleKeydown(ev, _constants.cls);
      });
    }
    /**
     * Unbind events
     * @private
     */
    ;

    _proto.unbindEvents = function unbindEvents() {
      (0, _off["default"])(document, 'click');
      (0, _off["default"])(this.el, 'click mouseover keydown');
    }
    /**
     * Handle click events
     * @param {Event} ev - an event
     * @param {object} cls - cls
     * @private
     */
    ;

    _proto.handleClick = function handleClick(ev, _ref2) {
      var INPUT = _ref2.INPUT,
          ITEM = _ref2.ITEM;
      var target = (0, _getTarget["default"])(ev);
      var itemEl = (0, _closest["default"])(target, "." + ITEM);

      if (itemEl) {
        this.select(itemEl.getAttribute('data-value'));
      } else if ((0, _closest["default"])(target, "." + INPUT)) {
        this.toggle();
      }
    }
    /**
     * Handle mouseover events
     * @param {Event} ev - an event
     * @param {object} cls - cls
     * @private
     */
    ;

    _proto.handleMouseover = function handleMouseover(ev, _ref3) {
      var ITEM = _ref3.ITEM;

      if (this.checkMousemove(ev.clientX, ev.clientY)) {
        var target = (0, _getTarget["default"])(ev);
        var itemEl = (0, _closest["default"])(target, "." + ITEM);

        if (itemEl) {
          this.dropdown.highlight(itemEl.getAttribute('data-value'));
        }
      }
    }
    /**
     * Check if a pointer is moved
     * @param {number} x - mouseEvent.clientX
     * @param {number} y - mouseEvent.clientY
     * @return {boolean}
     * @private
     */
    ;

    _proto.checkMousemove = function checkMousemove(x, y) {
      if (this.prevX !== x || this.prevY !== y) {
        this.prevX = x;
        this.prevY = y;
        return true;
      }

      return false;
    }
    /**
     * Handle keydown events
     * @param {Event} ev - an event
     * @param {object} classNames - cls
     * @private
     */
    ;

    _proto.handleKeydown = function handleKeydown(ev, classNames) {
      var key = (0, _keyEventUtils.identifyKey)(ev);
      var closeKeys = ['tab', 'escape'];
      var activeKeys = ['arrowUp', 'arrowDown', 'space', 'enter'];

      if (closeKeys.indexOf(key) > -1 && this.opened) {
        this.close();

        if (key === 'escape') {
          this.input.focus();
        }
      } else if (activeKeys.indexOf(key) > -1) {
        (0, _preventDefault["default"])(ev);
        this.activateKeydown(ev, key, classNames);
      }
    }
    /**
     * Activate keydown events
     * @param {Event} ev - an event
     * @param {string} key - key pressed
     * @param {object} classNames - cls
     * @private
     */
    ;

    _proto.activateKeydown = function activateKeydown(ev, key, _ref4) {
      var ITEM = _ref4.ITEM,
          INPUT = _ref4.INPUT;
      var target = (0, _getTarget["default"])(ev);
      var itemEl = (0, _closest["default"])(target, "." + ITEM);

      if (key === 'escape' && this.opened) {
        this.close();
        this.input.focus();
      } else if (itemEl) {
        this.pressKeyOnItem(key, itemEl);
      } else if ((0, _closest["default"])(target, "." + INPUT)) {
        this.pressKeyOnInput(key);
      }
    }
    /**
     * Handle keydown events when it occurs on the Input
     * @param {string} key - key
     * @private
     */
    ;

    _proto.pressKeyOnInput = function pressKeyOnInput(key) {
      if (!this.opened) {
        this.open();
      } else if (key === 'arrowUp' || key === 'arrowDown') {
        this.dropdown.moveHighlightedItem(key === 'arrowUp' ? -1 : 1);
      }
    }
    /**
     * Handle keydown events when it occurs on the Item
     * @param {string} key - key
     * @param {HTMLElement} itemEl - Item.el
     * @private
     */
    ;

    _proto.pressKeyOnItem = function pressKeyOnItem(key, itemEl) {
      if (key === 'enter' || key === 'space') {
        this.selectByKeydown(itemEl);
      } else if (key === 'arrowUp' || key === 'arrowDown') {
        this.dropdown.moveHighlightedItem(key === 'arrowUp' ? -1 : 1);
      }
    }
    /**
     * Select an Item by space or enter
     * @param {HTMLElement} itemEl - Item.el
     * @private
     */
    ;

    _proto.selectByKeydown = function selectByKeydown(itemEl) {
      this.select(itemEl.getAttribute('data-value'));
      this.close();
      this.input.focus();
    }
    /**
     * Disable a select box, {@link ItemGroup item group} or {@link Item item}.
     * If it takes no arguments, a select box is disabled.
     * If it takes string, an item with the same value as the argument is disabled.
     * If it takes number, an item with the same index as the argument is disabled.
     * If it takes Item or ItemGroup, an argument itself is disabled.
     * @param {string|number|Item|ItemGroup} value - if string, find an Item by its value. if number, find an Item by its index.
     * @example
     * selectBox.disable(); // select box is disabled.
     * selectBox.disable(1); // second item is disabled.
     * selectBox.disable('value') // item which of value is 'value' is disabled.
     * selectBox.disable(selectBox.getSelectedItem()); // selected item is disabled.
     */
    ;

    _proto.disable = function disable(value) {
      if (!(0, _isExisty["default"])(value)) {
        this.disabled = true;
        this.input.disable();
        this.dropdown.disable();
        /**
         * Occurs when a select box, {@link ItemGroup item group} or {@link Item item} is disabled.
         * @event SelectBox#disable
         * @type {object} ev
         * @property {string} type - event name ('disable')
         * @property {SelectBox|ItemGroup|Item} target - disabled target
         * @example
         * selectBox.on('disable', ev => {
         *   console.log(ev.target);
         * });
         */

        this.fire('disable', {
          type: 'disable',
          target: this
        });
      } else if (value instanceof _item["default"] || value instanceof _itemGroup["default"]) {
        value.disable();
        this.fire('disable', {
          type: 'disable',
          target: value
        });
      } else {
        var disabledItem = this.dropdown.getItem(value);

        if (disabledItem) {
          disabledItem.disable();
          this.fire('disable', {
            type: 'disable',
            target: disabledItem
          });
        }
      }
    }
    /**
     * Enable a select box, {@link ItemGroup item group} or {@link Item item}.
     * If it takes no arguments, a select box is enabled.
     * If it takes string, an item with the same value as the argument is enabled.
     * If it takes number, an item with the same index as the argument is enabled.
     * If it takes Item or ItemGroup, an argument itself is enabled.
     * @param {string|number|Item|ItemGroup} value - if string, find an Item by its value. if number, find an Item by its index.
     * @example
     * selectBox.enable(); // select box is enabled.
     * selectBox.enable(1); // second item is enabled.
     * selectBox.enable('value') // item which of value is 'value' is enabled.
     * selectBox.enable(selectBox.getSelectedItem()); // selected item is enabled.
     */
    ;

    _proto.enable = function enable(value) {
      if (!(0, _isExisty["default"])(value)) {
        this.disabled = false;
        this.input.enable();
        this.dropdown.enable();
        /**
         * Occurs when a select box, {@link ItemGroup item group} or {@link Item item} is enabled.
         * @event SelectBox#enable
         * @type {object} ev
         * @property {string} type - event name ('enable')
         * @property {SelectBox|ItemGroup|Item} target - enable target
         * @example
         * selectBox.on('enable', ev => {
         *   console.log(ev.target);
         * });
         */

        this.fire('enable', {
          type: 'enable',
          target: this
        });
      } else if (value instanceof _item["default"] || value instanceof _itemGroup["default"]) {
        value.enable();
        this.fire('enable', {
          type: 'enable',
          target: value
        });
      } else {
        var disabledItem = this.dropdown.getItem(value);

        if (disabledItem) {
          disabledItem.enable();
          this.fire('enable', {
            type: 'enable',
            target: disabledItem
          });
        }
      }
    }
    /**
     * Open a dropdown list.
     * @example
     * selectBox.open();
     */
    ;

    _proto.open = function open() {
      if (!this.disabled) {
        this.opened = true;
        this.dropdown.open();
        this.input.open();
        /**
         * Occurs when a select box opens.
         * @event SelectBox#open
         * @property {string} type - event name ('open')
         * @example
         * selectBox.on('open', ev => {
         *   console.log('open');
         * });
         */

        this.fire('open', {
          type: 'open'
        });
      }
    }
    /**
     * Close a dropdown list.
     * @example
     * selectBox.close();
     */
    ;

    _proto.close = function close() {
      this.opened = false;
      this.dropdown.close();
      this.input.close();
      /**
       * Occurs when a select box closes.
       * @event SelectBox#close
       * @property {string} type - event name ('close')
       * @example
       * selectBox.on('close', ev => {
       *   console.log('close');
       * });
       */

      this.fire('close', {
        type: 'close'
      });
    }
    /**
     * Toggle a dropdown list.
     * @example
     * selectBox.toggle();
     */
    ;

    _proto.toggle = function toggle() {
      if (this.opened) {
        this.close();
      } else {
        this.open();
      }
    }
    /**
     * Select an {@link Item item}.
     * If it takes string, an item with the same value as the argument is selected.
     * If it takes number, an item with the same index as the argument is selected.
     * If it takes Item, an argument itself is selected.
     * @param {string|number|Item} value - if string, find an Item by its value. if number, find an Item by its index.
     * @return {Item} - selected Item.
     * @example
     * selectBox.select(1); // second item is selected.
     * selectBox.select('value') // item which of value is 'value' is selected.
     */
    ;

    _proto.select = function select(value) {
      var selectedItem = null;
      var prevSelectedItem = this.getSelectedItem();

      if (!this.disabled) {
        selectedItem = this.dropdown.select(value);

        if (selectedItem) {
          this.input.changeText(selectedItem);
          /**
           * Occurs when an {@link Item item} is selected.
           * @event SelectBox#select
           * @type {object} ev
           * @property {string} type - event name ('select')
           * @property {Item} target - selected item
           * @ignore
           * @example
           * selectBox.on('select', ev => {
           *   console.log(`${ev.target.getLabel()} is selected.`);
           * });
           */

          this.fire('select', {
            type: 'select',
            target: selectedItem
          });

          if (prevSelectedItem !== selectedItem) {
            /**
             * Occurs when a selected {@link Item item} is changed.
             * @event SelectBox#change
             * @type {object} ev
             * @property {string} type - event name ('change')
             * @property {Item} prev - previous selected item
             * @property {Item} curr - current selected item
             * @example
             * selectBox.on('change', ev => {
             *   console.log(`selected item is changed from ${ev.prev.getLabel()} to ${ev.curr.getLabel()}.`);
             * });
             */
            this.fire('change', {
              type: 'change',
              prev: prevSelectedItem,
              curr: selectedItem
            });
          }

          if (this.autoclose && this.opened) {
            this.close();
          }
        }
      }

      return selectedItem;
    }
    /**
     * Deselect an item.
     * If selectBox has a placeholder, the input's text is a placeholder.
     * If no placeholder, ths input is empty.
     * @example
     * selectBox.deselect();
     */
    ;

    _proto.deselect = function deselect() {
      if (!this.disabled) {
        this.dropdown.deselect();
        this.input.changeText();
      }
    }
    /**
     * Return the selected {@link Item item}.
     * @return {Item}
     */
    ;

    _proto.getSelectedItem = function getSelectedItem() {
      return this.dropdown.getSelectedItem();
    }
    /**
     * Get all {@link Item items} that pass the test implemented by the provided function.
     * If filter function is not passed, it returns all items.
     * @param {function} callback - callback function to filter items
     * @param {number} number - the number of items to find. If it is not passed, iterate all items.
     * @return {array<Item>}
     * @example
     * selectBox.getItems(); // all items
     * selectBox.getItems(item => {
     *  return !item.isDisabled();
     * }); // all enabled items
     */
    ;

    _proto.getItems = function getItems(callback, number) {
      return this.dropdown.getItems(callback, number);
    }
    /**
     * Get an {@link Item item} by its index or value.
     * @param {number|string} value - if string, the Item's value. if number, the Item's index.
     * @return {Item}
     * @example
     * selectBox.getItem(0); // first item
     * selectBox.getItem('value') // item which of value is 'value'
     */
    ;

    _proto.getItem = function getItem(value) {
      return this.dropdown.getItem(value);
    }
    /**
     * Get all {@link ItemGroup item groups} that pass the test implemented by the provided function.
     * If filter function is not passed, it returns all item groups.
     * @param {function} callback - callback function to filter item groups
     * @param {number} number - the number of items to find. If it is not passed, iterate all item groups.
     * @return {array<ItemGroup>}
     * @example
     * selectBox.getItemGroups(); // all item groups
     * selectBox.getItemGroups(itemGroup => {
     *  return !itemGroup.isDisabled();
     * }); // all enabled item groups
     */
    ;

    _proto.getItemGroups = function getItemGroups(callback, number) {
      return this.dropdown.getItemGroups(callback, number);
    }
    /**
     * Get an {@link ItemGroup item group} by its index.
     * @param {number} index - groupIndex of the ItemGroup
     * @return {ItemGroup}
     * @example
     * selectBox.getItemGroup(0); // first item group
     */
    ;

    _proto.getItemGroup = function getItemGroup(index) {
      return this.dropdown.getItemGroup(index);
    }
    /**
     * Destory a select box.
     * @example
     * selectBox.destroy();
     */
    ;

    _proto.destroy = function destroy() {
      this.unbindEvents();
      this.input.destroy();
      this.dropdown.destroy();

      if (this.theme) {
        this.theme.destroy();
      }

      (0, _removeElement["default"])(this.el);
      this.container = this.el = this.input = this.dropdown = this.theme = null;
    };

    return SelectBox;
  }();

  _customEvents["default"].mixin(SelectBox);

  var _default = SelectBox;
  _exports["default"] = _default;
});

/***/ }),

/***/ "./src/js/theme.js":
/*!*************************!*\
  !*** ./src/js/theme.js ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/collection/forEachOwnProperties */ "./node_modules/tui-code-snippet/collection/forEachOwnProperties.js"), __webpack_require__(/*! tui-code-snippet/domUtil/removeElement */ "./node_modules/tui-code-snippet/domUtil/removeElement.js"), __webpack_require__(/*! tui-code-snippet/type/isArray */ "./node_modules/tui-code-snippet/type/isArray.js"), __webpack_require__(/*! tui-code-snippet/type/isBoolean */ "./node_modules/tui-code-snippet/type/isBoolean.js"), __webpack_require__(/*! tui-code-snippet/type/isString */ "./node_modules/tui-code-snippet/type/isString.js"), __webpack_require__(/*! ./utils */ "./src/js/utils.js"), __webpack_require__(/*! ./constants */ "./src/js/constants.js"), __webpack_require__(/*! ./themeConfig */ "./src/js/themeConfig.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _forEachOwnProperties, _removeElement, _isArray, _isBoolean, _isString, _utils, _constants, _themeConfig) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;
  _forEachOwnProperties = _interopRequireDefault(_forEachOwnProperties);
  _removeElement = _interopRequireDefault(_removeElement);
  _isArray = _interopRequireDefault(_isArray);
  _isBoolean = _interopRequireDefault(_isBoolean);
  _isString = _interopRequireDefault(_isString);
  _themeConfig = _interopRequireDefault(_themeConfig);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

  function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  /**
   * @class
   * @ignore
   * @param {object} customTheme - theme object for custom style
   * @param {HTMLElement|string} container - container element or selector
   */
  var Theme =
  /*#__PURE__*/
  function () {
    function Theme(customTheme, container) {
      this.containerSelector = (0, _utils.getSelector)(container);
      this.cssString = this.buildAll((0, _utils.transform)(customTheme));
      this.styleEl = this.createStyleElement();
      document.getElementsByTagName('head')[0].appendChild(this.styleEl);
    }
    /**
     * Create a style element
     * @return {HTMLElement}
     * @private
     */


    var _proto = Theme.prototype;

    _proto.createStyleElement = function createStyleElement() {
      var styleEl = document.createElement('style');
      styleEl.type = 'text/css';

      if (styleEl.styleSheet) {
        styleEl.styleSheet.cssText = this.cssString;
      } else {
        styleEl.appendChild(document.createTextNode(this.cssString));
      }

      return styleEl;
    }
    /**
     * Build css strings for Input, Dropdown, ItemGroup, and Item.
     * @param {object} theme - theme object
     * @return {string}
     * @private
     */
    ;

    _proto.buildAll = function buildAll(theme) {
      var exclude = {
        border: '',
        background: ''
      };
      return this.buildInput(_objectSpread({}, theme.common, {}, theme.input)) + this.buildDropdown(_objectSpread({}, theme.common, {
        borderTop: '0'
      }, theme.dropdown, {
        height: ''
      })) + this.buildItemGroup(theme.itemGroup ? _objectSpread({}, theme.common, {}, exclude, {}, theme.itemGroup.label) : _objectSpread({}, theme.common, {}, exclude)) + this.buildItem(theme.itemGroup ? _objectSpread({}, theme.common, {}, exclude, {}, theme.item, {
        inItemGroup: theme.itemGroup.items
      }) : _objectSpread({}, theme.common, {}, exclude, {}, theme.item));
    }
    /**
     * Build css strings for Input
     * @param {object} theme - theme object
     * @return {string}
     * @private
     */
    ;

    _proto.buildInput = function buildInput(theme) {
      theme.placeholder = {};

      if (theme.height) {
        theme.placeholder.lineHeight = theme.height;
      }

      if ((0, _isBoolean["default"])(theme.showIcon) && !theme.showIcon) {
        theme.icon = {
          display: 'none'
        };
        theme.placeholder.width = '100%';
      }

      return this.buildCssString(_constants.cls.INPUT, theme) + this.buildCssString([_constants.cls.INPUT, _constants.cls.OPEN], theme.open) + this.buildCssString([_constants.cls.INPUT, _constants.cls.DISABLED], theme.disabled) + this.buildCssString(_constants.cls.PLACEHOLDER, theme.placeholder) + this.buildCssString(_constants.cls.ICON, theme.icon);
    }
    /**
     * Build css strings for Dropdown
     * @param {object} theme - theme object
     * @return {string}
     * @private
     */
    ;

    _proto.buildDropdown = function buildDropdown(theme) {
      return this.buildCssString(_constants.cls.DROPDOWN, theme);
    }
    /**
     * Build css strings for ItemGroup
     * @param {object} theme - theme object
     * @return {string}
     * @private
     */
    ;

    _proto.buildItemGroup = function buildItemGroup(theme) {
      if (theme.height) {
        theme.lineHeight = theme.height;
      }

      return this.buildCssString(_constants.cls.ITEM_GROUP_LABEL, theme) + this.buildCssString([_constants.cls.ITEM_GROUP_LABEL, _constants.cls.DISABLED], theme.disabled);
    }
    /**
     * Build css strings for Item
     * @param {object} theme - theme object
     * @return {string}
     * @private
     */
    ;

    _proto.buildItem = function buildItem(theme) {
      if (theme.height) {
        theme.lineHeight = theme.height;
      }

      if (theme.selected) {
        var base = (0, _utils.transform)(_themeConfig["default"]);
        theme.selected = _objectSpread({}, base.item.selected, {}, theme.selected);
        theme.disabled = _objectSpread({}, base.item.disabled, {}, theme.disabled);
        theme.highlighted = _objectSpread({}, base.item.highlighted, {}, theme.highlighted);
      }

      return this.buildCssString(_constants.cls.ITEM, theme) + this.buildCssString([_constants.cls.ITEM, _constants.cls.SELECTED], theme.selected) + this.buildCssString([_constants.cls.ITEM, _constants.cls.DISABLED], theme.disabled) + this.buildCssString([_constants.cls.ITEM, _constants.cls.HIGHLIGHT], theme.highlighted) + this.buildCssString(_constants.cls.ITEM_GROUP + ">." + _constants.cls.ITEM, theme.inItemGroup);
    }
    /**
     * Build css strings
     * @param {string} className - className
     * @param {object} theme - theme object
     * @return {string}
     * @private
     */
    ;

    _proto.buildCssString = function buildCssString(className, theme) {
      if ((0, _isArray["default"])(className)) {
        className = className.join('.');
      }

      className = "." + className;
      var cssString = '';
      (0, _forEachOwnProperties["default"])(theme, function (value, key) {
        if ((0, _isString["default"])(value) && value) {
          key = key.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase();
          cssString += key + ":" + value + ";";
        }
      });
      return cssString ? this.containerSelector + " " + className + "{" + cssString + "}" : '';
    }
    /**
     * Destory a theme
     */
    ;

    _proto.destroy = function destroy() {
      (0, _removeElement["default"])(this.styleEl);
      this.styleEl = null;
    };

    return Theme;
  }();

  _exports["default"] = Theme;
});

/***/ }),

/***/ "./src/js/themeConfig.js":
/*!*******************************!*\
  !*** ./src/js/themeConfig.js ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports) {
  "use strict";

  _exports.__esModule = true;
  _exports["default"] = void 0;

  /**
   * @fileoverview Theme configuration
   * @author NHN FE Development Lab <dl_javascript@nhn.com>
   */

  /**
   * Theme configuration.
   * "common" prefix is for the entire select box. Its properties are overriden by "input", "dropdown", "itemGroup", and "item".
   * The example using theme can be found {@link tutorial-example02-theme here}.
   * @typedef {object} themeConfig
   * @example
   * const themeConfig = {
   *   'common.border': '1px solid #ddd', // border for input and dropdown (not itemGroup and item)
   *   'common.background': '#fff',
   *   'common.color': '#333',
   *   'common.width': '100%',
   *   'common.height': '29px', // height for item and itemGroup label (not entire select box)
   *
   *   'common.disabled.background': '#f9f9f9',
   *   'common.disabled.color': 'c8c8c8',
   *
   *   // Input
   *   'input.border': '1px solid #ddd',
   *   'input.borderBottom': '',
   *   'input.background': 'inherit',
   *   'input.color': '#333',
   *   'input.width': '100%',
   *   'input.height': '29px',
   *
   *   // Input when dropdown is open
   *   'input.open.border': '1px solid #aaa',
   *   'input.open.background': 'inherit',
   *   'input.open.color': '#333',
   *
   *   // Input when selectbox is disabled
   *   'input.disabled.border': '1px solid #aaa',
   *   'input.disabled.background': '#f9f9f9',
   *   'input.disabled.color': '#c8c8c8',
   *
   *   // Dropdown
   *   'dropdown.border': '1px solid #aaa',
   *   'dropdown.borderTop': '0',
   *   'dropdown.background': 'inherit',
   *   'dropdown.width': '100%',
   *   'dropdown.maxHeight': '',
   *
   *   // ItemGroup's items
   *   // if you want to set the same padding value as the itemGroup.label, set to '8px'.
   *   'itemGroup.items.paddingLeft': '20px',
   *
   *   // ItemGroup's label
   *   'itemGroup.label.border': '0',
   *   'itemGroup.label.background': 'inherit',
   *   'itemGroup.label.color': '#333',
   *   'itemGroup.label.fontWeight': 'bold',
   *   'itemGroup.label.height': '29px',
   *
   *   // disabled ItemGroup's label
   *   'itemGroup.label.disabled.border': '0',
   *   'itemGroup.label.disabled.background': 'inherit',
   *   'itemGroup.label.disabled.color': '#333',
   *
   *   // Item
   *   'item.border': '0',
   *   'item.background': 'inherit',
   *   'item.color': '#333',
   *   'item.height': '29px',
   *
   *   // selected Item
   *   'item.selected.border': '0',
   *   'item.selected.background': '#f4f4f4',
   *   'item.selected.color': '#333',
   *
   *   // disabled Item
   *   'item.disabled.border': '0',
   *   'item.disabled.background': '#f9f9f9',
   *   'item.disabled.color': '#c8c8c8',
   *
   *   // highlighted Item
   *   'item.highlighted.border': '0',
   *   'item.highlighted.background': '#e5f6ff',
   *   'item.highlighted.color': '#333'
   * };
   */
  var _default = {
    'common.border': '1px solid #ddd',
    // border for input and dropdown (not itemGroup and item)
    'common.background': '#fff',
    'common.color': '#333',
    'common.width': '100%',
    'common.height': '29px',
    // height for item and itemGroup label (not entire select box)
    'common.disabled.background': '#f9f9f9',
    'common.disabled.color': 'c8c8c8',
    // Input
    'input.border': '1px solid #ddd',
    'input.borderBottom': '',
    'input.background': 'inherit',
    'input.color': '#333',
    'input.width': '100%',
    'input.height': '29px',
    // Input when dropdown is open
    'input.open.border': '1px solid #aaa',
    'input.open.background': 'inherit',
    'input.open.color': '#333',
    // Input when selectbox is disabled
    'input.disabled.border': '1px solid #aaa',
    'input.disabled.background': '#f9f9f9',
    'input.disabled.color': '#c8c8c8',
    // Dropdown
    'dropdown.border': '1px solid #aaa',
    'dropdown.borderTop': '0',
    'dropdown.background': 'inherit',
    'dropdown.width': '100%',
    'dropdown.maxHeight': '',
    // ItemGroup's items
    'itemGroup.items.paddingLeft': '20px',
    // ItemGroup's label
    'itemGroup.label.border': '0',
    'itemGroup.label.background': 'inherit',
    'itemGroup.label.color': '#333',
    'itemGroup.label.fontWeight': 'bold',
    'itemGroup.label.height': '29px',
    // disabled ItemGroup's label
    'itemGroup.label.disabled.border': '0',
    'itemGroup.label.disabled.background': 'inherit',
    'itemGroup.label.disabled.color': '#333',
    // Item
    'item.border': '0',
    'item.background': 'inherit',
    'item.color': '#333',
    'item.height': '29px',
    // selected Item
    'item.selected.border': '0',
    'item.selected.background': '#f4f4f4',
    'item.selected.color': '#333',
    // disabled Item
    'item.disabled.border': '0',
    'item.disabled.background': '#f9f9f9',
    'item.disabled.color': '#c8c8c8',
    // highlighted Item
    'item.highlighted.border': '0',
    'item.highlighted.background': '#e5f6ff',
    'item.highlighted.color': '#333'
  };
  _exports["default"] = _default;
});

/***/ }),

/***/ "./src/js/utils.js":
/*!*************************!*\
  !*** ./src/js/utils.js ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (global, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports, __webpack_require__(/*! tui-code-snippet/collection/forEachOwnProperties */ "./node_modules/tui-code-snippet/collection/forEachOwnProperties.js"), __webpack_require__(/*! tui-code-snippet/type/isString */ "./node_modules/tui-code-snippet/type/isString.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else { var mod; }
})(this, function (_exports, _forEachOwnProperties, _isString) {
  "use strict";

  _exports.__esModule = true;
  _exports.getSelector = _exports.createElement = _exports.transform = void 0;
  _forEachOwnProperties = _interopRequireDefault(_forEachOwnProperties);
  _isString = _interopRequireDefault(_isString);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  /**
   * @fileoverview Utility functions
   * @author NHN. FE dev team.<dl_javascript@nhn.com>
   */

  /**
   * Transform an object using dot notation
   * @param {object} obj - object to transform
   * @return {object}
   */
  var transform = function transform(obj) {
    var result = {};
    (0, _forEachOwnProperties["default"])(obj, function (value, prop) {
      var keys = prop.split('.');
      var curr = result;
      keys.forEach(function (key, index) {
        if (index === keys.length - 1) {
          curr[key] = value;
        } else if (!curr[key]) {
          curr[key] = {};
        }

        curr = curr[key];
      });
    });
    return result;
  };
  /**
   * Create a HTML element
   * @param {string} tagName - tag name
   * @param {string} content - content in the element
   * @param {object} options - other properties for the element
   * @param {HTMLElement} container - parent element for the element
   * @return {HTMLElement}
   */


  _exports.transform = transform;

  var createElement = function createElement(tagName, content, options, container) {
    var el = document.createElement(tagName);

    if (content) {
      el.innerText = content;
    }

    (0, _forEachOwnProperties["default"])(options, function (value, key) {
      if (key.indexOf('data-') > -1) {
        el.setAttribute(key, value);
      } else {
        el[key] = value;
      }
    });

    if (container) {
      container.appendChild(el);
    }

    return el;
  };
  /**
   * Get selectors for an element
   * @param {HTMLElement} el - element
   * @return {string}
   */


  _exports.createElement = createElement;

  var getSelector = function getSelector(el) {
    if ((0, _isString["default"])(el)) {
      return el;
    }

    if (el.id) {
      return "#" + el.id;
    }

    var className = "." + el.className.replace(/\s+/g, '.');

    if (className) {
      var elems = document.querySelectorAll(className);

      if (elems.length === 1) {
        return className;
      }
    }

    var tagName = el.tagName.toLowerCase();
    return "" + tagName + className;
  };

  _exports.getSelector = getSelector;
});

/***/ })

/******/ })["default"];
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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