<?php

// include_once '../include/Config.php';  // Configuration Rest Api

/**
 *
 * @About:      Gestión de Datos Electorales de la Comunidad de Madrid
 * @File:       DbElecciones.php
 * @Date:       $Date:$ Ene 2025
 * @Version:    $Rev:$ 1.0
 * @Developer:  fernando humanes
 **/

    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Selective\BasePath\BasePathMiddleware;
    use Slim\Factory\AppFactory;

class DbIncidentes
{

    private $connDB;

    function __construct()
    {
        /* You should enable error reporting for mysqli before attempting to make a connection */
        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        /* Set the desired charset after establishing a connection */
        $mysqli->set_charset('utf8mb4');
        
        $this->connDB = $mysqli;      // No se usa esta conexión si está integrado con PHPRunner
    }
    
    private function responseKO ($data_arr) {
        global $errorMessages;
        $data_arr['error'] = true;
        $data_arr["message_num"] = '005';
        $data_arr["message"] = str_replace("?",$this->connDB->error,$errorMessages['005']);
        $this->connDB->close();
        return $data_arr;
    }
    private function responseOK ($data_arr) {
        global $errorMessages;
        $data_arr['error'] = false;
        $data_arr["message_num"] = '006';
        $data_arr["message"] = $errorMessages['006'];
        $this->connDB->close();
        return $data_arr;
    }
    private function diffDates ($date_from, $date_to) {
        // $date1 = DateTimeImmutable::createFromFormat('d/m/Y', $date_from);
        // $date2 = DateTimeImmutable::createFromFormat('d/m/Y', $date_to);
        // Calculation of the days
        $sql = "Select
        DATEDIFF('$date_to','$date_from') NaturalWorkingDays,
        workdaydiff('$date_to','$date_from') WorkingDays
        from dual";
        $data_arr = array();
        $rs = $this->connDB->query($sql);
        $data = $rs->fetch_assoc();
        $data['NaturalWorkingDays'] += 1; // se incluyen los dias desde y hasta en la fecha
        $data_arr['NaturalWorkingDays'] = $data['NaturalWorkingDays'];
        $data_arr['DaysWeekend'] = $data['NaturalWorkingDays'] - $data['WorkingDays'];
        return $data_arr;      
    }
    // ---------------------------------------------------------------------------
    /*
    * Listado de Tipos
    */
    public function tipoList(Request $request,Response $response)
    {
        global $errorMessages;
        
        $sql = "
        SELECT
            id_incidente_tipo id,
            titulo,
            color
        FROM incidente_tipo
        ORDER BY titulo ";
        $data_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data_arr[] = $data; 
        }
        $data = ["error" => '' ,"message_num" => '',"message"=> '', "data" => $data_arr];
        return $this->responseOK($data);
        
    }
    /*
    * ADD de Tipos
    */
    public function addTipo($param, Request $request,Response $response)
    {
        global $errorMessages;
        $titulo = $param['titulo'];
        $color = $param['color'];
        
        $sql = "
        INSERT INTO incidente_tipo (titulo, color)
        VALUES (?,?)";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);
        /*
        if ( $stmt <> true ) { // Error access database
            return $this->responseKO($data_arr);
        }
         */
        $stmt->bind_param('ss',$titulo, $color);
        $stmt->execute();  
        return $this->responseOK($data_arr);     
    }
    /*
    * View de Tipos
    */
    public function viewTipo($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        SELECT
        id_incidente_tipo id,
        titulo,
        color
        FROM incidente_tipo
        WHERE id_incidente_tipo = ?";
        
        $data_arr = array();
        $data_all = array();
        
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($data = $result->fetch_array(MYSQLI_ASSOC)) 
        {
           $data_arr[] = $data; 
        }

        $data = ["error" => '' ,"message_num" => '',"message"=> '', "data" => $data_arr];
        return $this->responseOK($data);  
    }
    /*
    * UPDATE de Tipos
    */
    public function updateTipo($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        $titulo = $param['titulo'];
        $color = $param['color'];
        
        $sql = "
        UPDATE incidente_tipo
        SET
        titulo = ?,
        color = ?
        WHERE id_incidente_tipo = ?";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('ssi',$titulo, $color, $id);
        $stmt->execute();
        
        $data_arr = $this->viewTipo($param, $request, $response);  // Visualizar resultado
        
        return $data_arr;     
    }
    /*
    * Delete de Tipos
    */
    public function deleteTipo($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        DELETE FROM incidente_tipo
        WHERE id_incidente_tipo = ?";
        
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        
        $data = ["error" => '' ,"message_num" => '',"message"=> ''];
        return $this->responseOK($data);   
    }
    
    // ---------------------------------------------------------------------------
    /*
    * Listado de Casos
    */
    public function casoList(Request $request,Response $response)
    {
        global $errorMessages;
        
        $sql = "
        SELECT
            id_incidente_caso id,
            incidente_usuario_id,
            login,
            nombre_apellidos,
            incidente_tipo_id,
            incidente_tipo.titulo titulo_tipo,
            incidente_tipo.color,
            fechaDesde,
            fechaHasta,
            incidente_caso.titulo,
            descripcion,
            diasLaborables,
            diasFinSemana
        FROM incidente_caso
        JOIN incidente_tipo on (id_incidente_tipo = incidente_tipo_id )
        JOIN incidente_usuario on ( incidente_usuario_id = id_incidente_usuario )
        ORDER BY id_incidente_caso";
        $data1_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data1_arr[] = $data; 
        }
        // Tipo LIST
        $sql = "
        SELECT
            id_incidente_tipo id,
            titulo,
            color
        FROM incidente_tipo
        ORDER BY id_incidente_tipo ";
        $data2_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data2_arr[] = $data; 
        }
        // Usuarios LIST
        $sql = "
        SELECT
            id_incidente_usuario id,
            login,
            nombre_apellidos
        FROM incidente_usuario
        ORDER BY id_incidente_usuario ";
        $data3_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data3_arr[] = $data; 
        }
              
        $data = ["error" => '' ,"message_num" => '',"message"=> '', "data"=> $data1_arr, "dataTipo"=> $data2_arr, "dataUsuario" => $data3_arr];
        return $this->responseOK($data); 
        
    }
    /*
    * ADD de Casos
    */
    public function addCaso($param, Request $request,Response $response)
    {
        global $errorMessages;
        // field: id,incidente_usuario_id,incidente_tipo_id,fechaDesde,fechaHasta,titulo,descripcion,diasLaborables,diasFinSemana
        $incidente_usuario_id = $param['incidente_usuario_id'];
        $incidente_tipo_id = $param['incidente_tipo_id'];
        $fechaDesde = $param['fechaDesde'];
        $fechaHasta = $param['fechaHasta'];
        $titulo = $param['titulo'];
        $descripcion = $param['descripcion'];
        $calc_array = $this->diffDates ($fechaDesde, $fechaHasta);  // Calculo de días
        $diasLaborables = $calc_array['NaturalWorkingDays'];
        $diasFinSemana = $calc_array['DaysWeekend'];
     
        $sql = "
        INSERT INTO incidente_caso (incidente_usuario_id,incidente_tipo_id,fechaDesde,fechaHasta,titulo,descripcion,diasLaborables,diasFinSemana)
        VALUES (?,?,?,?,?,?,?,?)";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);

        $stmt->bind_param('iissssii',$incidente_usuario_id,$incidente_tipo_id,$fechaDesde,$fechaHasta,$titulo,$descripcion,$diasLaborables,$diasFinSemana);
        $stmt->execute();  
        return $this->responseOK($data_arr);     
    }
    /*
    * View de Casos
    */
    public function viewCaso($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        SELECT
            id_incidente_caso id,
            incidente_usuario_id,
            login,
            nombre_apellidos,
            incidente_tipo_id,
            incidente_tipo.titulo titulo_tipo,
            incidente_tipo.color,
            fechaDesde,
            fechaHasta,
            incidente_caso.titulo,
            descripcion,
            diasLaborables,
            diasFinSemana
        FROM incidente_caso
        JOIN incidente_tipo on (id_incidente_tipo = incidente_tipo_id )
        JOIN incidente_usuario on ( incidente_usuario_id = id_incidente_usuario ) 
        WHERE id_incidente_caso = ?";
        
        $data_arr = array();
        $data_all = array();
        
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($data = $result->fetch_array(MYSQLI_ASSOC)) 
        {
           $data_arr[] = $data; 
        }
        $data_all['data'] = $data_arr;
        return $this->responseOK($data_all);     
    }
    /*
    * UPDATE de Casos
    */
    public function updateCaso($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        // field: id,incidente_usuario_id,incidente_tipo_id,fechaDesde,fechaHasta,titulo,descripcion,diasLaborables,diasFinSemana
        $incidente_usuario_id = $param['incidente_usuario_id'];
        $incidente_tipo_id = $param['incidente_tipo_id'];
        $fechaDesde = $param['fechaDesde'];
        $fechaHasta = $param['fechaHasta'];
        $titulo = $param['titulo'];
        $descripcion = $param['descripcion'];
        $calc_array = $this->diffDates ($fechaDesde, $fechaHasta);  // Calculo de días
        $diasLaborables = $calc_array['NaturalWorkingDays'];
        $diasFinSemana = $calc_array['DaysWeekend'];

        $sql = "
        UPDATE incidente_caso
        SET
        incidente_usuario_id = ?,
        incidente_tipo_id = ?,
        fechaDesde = ?,
        fechaHasta = ?,
        titulo = ?,
        descripcion = ?,
        diasLaborables = ?,
        diasFinSemana  = ?
        WHERE id_incidente_caso = ?";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);

        $stmt->bind_param('iissssiii',$incidente_usuario_id,$incidente_tipo_id,$fechaDesde,$fechaHasta,$titulo,$descripcion,$diasLaborables,$diasFinSemana,$id);
        $stmt->execute();
        
        $data_arr = $this->viewCaso($param, $request, $response);  // Visualizar resultado
        
        return $data_arr;     
    }
    /*
    * Delete de Casos
    */
    public function deleteCaso($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        DELETE FROM incidente_caso
        WHERE id_incidente_caso = ?";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('i',$id);
        $stmt->execute();  
        return $this->responseOK($data_arr);     
    }
    // ---------------------------------------------------------------------------
    /*
    * Listado de Usuarios
    */
    public function usuarioList(Request $request,Response $response)
    {
        global $errorMessages;
        
        $sql = "
        SELECT
            id_incidente_usuario id,
            login,
            nombre_apellidos
        FROM incidente_usuario
        ORDER BY login ";
        $data_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data_arr[] = $data; 
        }
        $data = ["error" => '' ,"message_num" => '',"message"=> '', "data" => $data_arr];
        return $this->responseOK($data);
        
    }
    /*
    * ADD de Usuarios
    */
    public function addUsuario($param, Request $request,Response $response)
    {
        global $errorMessages;
        $login = $param['login'];
        $nombre_apellidos = $param['nombre_apellidos'];
        
        $sql = "
        INSERT INTO incidente_usuario (login, nombre_apellidos)
        VALUES (?,?)";
        
        $stmt = $this->connDB->prepare($sql);

        $stmt->bind_param('ss',$login, $nombre_apellidos);
        $stmt->execute();

        /*
         * Falta controlar si está duplicado el usuario
         */
          
        $data = ["error" => '' ,"message_num" => '',"message"=> ''];
        return $this->responseOK($data);
    
    }
    /*
    * View de Usuario
    */
    public function viewUsuario($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        SELECT
            id_incidente_usuario id,
            login,
            nombre_apellidos
        FROM incidente_usuario
        WHERE id_incidente_usuario = ?";
        
        $data_arr = array();
        $data_all = array();
        
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('i',$id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($data = $result->fetch_array(MYSQLI_ASSOC)) 
        {
           $data_arr[] = $data; 
        }
        $data = ["error" => '' ,"message_num" => '',"message"=> '', "data" => $data_arr];
        return $this->responseOK($data);    
    }
    /*
    * UPDATE de Usuario
    */
    public function updateUsuario($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        $login = $param['login'];
        $nombre_apellidos = $param['nombre_apellidos'];
        
        $sql = "
        UPDATE incidente_usuario
        SET
        login = ?,
        nombre_apellidos = ?
        WHERE id_incidente_usuario = ?";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('ssi',$login, $nombre_apellidos, $id);
        $stmt->execute();
        
        $data_arr = $this->viewUsuario($param, $request, $response);  // Visualizar resultado
        
        return $data_arr;     
    }
    /*
    * Delete de Usuario
    */
    public function deleteUsuario($param, Request $request,Response $response)
    {
        global $errorMessages;
        $id = $param['id'];
        
        $sql = "
        DELETE FROM incidente_usuario
        WHERE id_incidente_usuario = ?";
        
        $stmt = $this->connDB->prepare($sql);
        $stmt->bind_param('i',$id);
        $stmt->execute();  
        $data = ["error" => '' ,"message_num" => '',"message"=> ''];
        return $this->responseOK($data);    
    }
    // ---------------------------------------------------------------------------
    /*
    * Listado de Casos para Calendar
    */
    public function casoCalendar($param, Request $request,Response $response)
    {
        global $errorMessages;
        
        $id_user = $param['id_user'];
        $start = $param['start'].' 00:00:00';
        $end = $param['end'].' 23:59:59';
        
        $sql = "
        SELECT
            id_incidente_caso id,
            incidente_usuario_id,
            login,
            nombre_apellidos,
            incidente_tipo_id,
            incidente_tipo.titulo titulo_tipo,
            incidente_tipo.color,
            fechaDesde ,
            DATE_ADD(fechaHasta, INTERVAL 1 DAY) end,
            fechaHasta,
            incidente_caso.titulo,
            descripcion,
            diasLaborables,
            diasFinSemana
        FROM incidente_caso
        JOIN incidente_tipo on (id_incidente_tipo = incidente_tipo_id )
        JOIN incidente_usuario on ( incidente_usuario_id = id_incidente_usuario )
        WHERE incidente_usuario_id = $id_user 
            AND fechaHasta >= '$start' AND FechaDesde <= '$end' 
        ORDER BY id_incidente_caso";
        $data1_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
            // $data['allDay'] = true;

            $data1_arr[] = $data; 
        }
        // Tipo LIST
        $sql = "
        SELECT
            id_incidente_tipo id,
            titulo,
            color
        FROM incidente_tipo
        ORDER BY id_incidente_tipo ";
        $data2_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data2_arr[] = $data; 
        }
        // Usuarios LIST
        $sql = "
        SELECT
            id_incidente_usuario id,
            login,
            nombre_apellidos
        FROM incidente_usuario
        ORDER BY id_incidente_usuario ";
        $data3_arr = array();
        $rs = $this->connDB->query($sql);
        while( $data = $rs->fetch_assoc() )
        {
           $data3_arr[] = $data; 
        }
              
        $data = ["error" => '' ,"message_num" => '',"message"=> '', "data"=> $data1_arr, "dataTipo"=> $data2_arr, "dataUsuario" => $data3_arr];
        return $this->responseOK($data); 
        
    }


}
