<?php
/**
 *
 * @About:      API Interface
 * @File:       index.php
 * @Date:       $Date:$ Ene 2025
 * @Version:    $Rev:$ 1.0
 * @Developer:  Federico Guzman || Modificado por Fernando Humanes para PHP 8.1
 **/

/* Los headers permiten acceso desde otro dominio (CORS) a nuestro REST API o desde un cliente remoto via HTTP
 * Removiendo las lineas header() limitamos el acceso a nuestro RESTfull API a el mismo dominio
 * Nótese los métodos permitidos en Access-Control-Allow-Methods. Esto nos permite limitar los métodos de consulta a nuestro RESTfull API
 * Mas información: https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS
 **/

// $dominioPermitido = "http://localhost:3000";

// header("Access-Control-Allow-Origin: $dominioPermitido"); // Para restringir desde dónde se pueden hacer peticines
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, authorization, Authorization, token-user ");
// header("Access-Control-Allow-Headers: *");

header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: PUT, GET, POST, DELETE, OPTIONS');
// header("Access-Control-Allow-Headers: X-Requested-With");
header('Content-Type: text/html; charset=utf-8');
header('Content-Type: multipart/form-data');
header('Content-Type: application/x-www-form-urlencoded');
header('Content-Type: application/json');
header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');

// session_cache_limiter(false);

include_once '../include/Config.php';  // Configuration Rest Api
//     require_once("../../include/dbcommon.php"); // DataBase PHPRunner

// Debug
// $debugCode = false;
// custom_error(1,"URL ejecutada: ".$_SERVER["REQUEST_URI"]); // To debug
// $debugCode = false;

// use App\Models\Db;  // Utilizamos la conexión de PHPRunner
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Selective\BasePath\BasePathMiddleware;
use Slim\Factory\AppFactory;

require_once __DIR__ . '/../libs/autoload.php';   // Library SLIM v4

$app = AppFactory::create();

$app->addRoutingMiddleware();
// $app->add(new BasePathMiddleware($app)); // No usar si se ejecuta en subdirectorio
$app->addErrorMiddleware(true, true, true);
$app->addBodyParsingMiddleware();

$app->setBasePath(SCRIPTS_DIR);             // Indica el directorio desde donde está trabajando

// --------------------------------------------------------------------------------------

/* Usando POST pata obtener los Tipos de la Base de datos */

$app->post('/tipoList', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    /* Obtener el listado de Tipo */
    $responseBody = $db->tipoList($request, $response);

    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update, delete de Tipos de Incidentes
*/
$app->post('/tipo/{action}/{id}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id'] = $args['id'];

    $verify = verifyRequiredParams(array('action','id'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add','view','update','delete')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '004';
        $responseBody["message"] = $errorMessages['004'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
        
    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('titulo','color'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addTipo($param2,$request, $response );
        break;
    case 'view':
        $data = $db->viewTipo($param,$request, $response );
        break;
    case 'update':
        // check for required params
        $param2 = $request->getParsedBody();
        $param2['action'] = $args['action'];
        $param2['id'] = $args['id'];

        $verify = verifyRequiredParams(array('id','titulo','color'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->updateTipo($param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteTipo($param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});
// --------------------------------------------------------------------------------------

/* Usando POST pata obtener las Usuarios de la Base de datos */

$app->post('/usuarioList', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    /* Obtener el listado de Tipo */
    $responseBody = $db->usuarioList($request, $response);

    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});
// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update, delete de Usuarios de Incidentes
*/
$app->post('/usuario/{action}/{id}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id'] = $args['id'];

    $verify = verifyRequiredParams(array('action','id'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add','view','update','delete')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '004';
        $responseBody["message"] = $errorMessages['004'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
        
    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('login','nombre_apellidos'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addUsuario($param2,$request, $response );
        break;
    case 'view':
        $data = $db->viewUsuario($param,$request, $response );
        break;
    case 'update':
        // check for required params
        $param2 = $request->getParsedBody();
        $param2['action'] = $args['action'];
        $param2['id'] = $args['id'];

        $verify = verifyRequiredParams(array('id','login','nombre_apellidos'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->updateUsuario($param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteUsuario($param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});

// --------------------------------------------------------------------------------------
/* Usando POST pata obtener los Casos de la Base de datos */

$app->post('/casoList', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    
    /* Obtener el listado de Tipo */
    $responseBody = $db->casoList($request, $response);

    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});

// --------------------------------------------------------------------------------------
/* Usando POST para add, view, update, delete de Casos de Incidentes
*/
$app->post('/caso/{action}/{id}', function(Request $request, Response $response, array $args) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // check for required params
    $param = array();
    $param['action'] = $args['action'];
    $param['id'] = $args['id'];

    $verify = verifyRequiredParams(array('action','id'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // Verificación de los valores de los parámetros || attributes
    if( !in_array($param['action'],array('add','view','update','delete')) )  { // Si la acción no es correcta
        $responseBody["error"] = true;
        $responseBody["message_num"] = '004';
        $responseBody["message"] = $errorMessages['004'];
        $response->getBody()->write(json_encode($responseBody));
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
    }
        
    switch ($param['action']) {
    case 'add':
        // check for required params
        $param2 = $request->getParsedBody();

        $verify = verifyRequiredParams(array('incidente_usuario_id','incidente_tipo_id','fechaDesde','fechaHasta','titulo','descripcion'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->addCaso($param2,$request, $response );
        break;
    case 'view':
        $data = $db->viewCaso($param,$request, $response );
        break;
    case 'update':
        // check for required params
        $param2 = $request->getParsedBody();
        $param2['action'] = $args['action'];
        $param2['id'] = $args['id'];

        $verify = verifyRequiredParams(array('id','incidente_usuario_id','incidente_tipo_id','fechaDesde','fechaHasta','titulo','descripcion'), $param2, $request, $response);
        if (is_array($verify)) { // Si es una array, es que hay error
            $response->getBody()->write(json_encode($verify));
            return $response
                ->withHeader('content-type', 'application/json')
                ->withStatus(200);
        }
        $data = $db->updateCaso($param2,$request, $response );
        break;
    case 'delete':
        $data = $db->deleteCaso($param,$request, $response );
        break;
    }
    // $response->getBody()->write($data);
    $response->getBody()->write(json_encode($data,JSON_NUMERIC_CHECK));
    
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);  
});

// --------------------------------------------------------------------------------------

$app->post('/casoCalendar', function(Request $request, Response $response) {
    global $errorMessages;
    /* Include functions required for the execution of the actions */
    include_once '../include/Function.php';
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbIncidentes.php';
    $db = new DbIncidentes();
    
    $param = $request->getParsedBody();
    
    // Verify Token Authenticate Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    }
    // check for required params
    $verify = verifyRequiredParams(array('id_user','start','end'), $param, $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    } 
    
    /* Obtener el listado de Tipo */
    $responseBody = $db->casoCalendar($param,$request, $response);

    $response->getBody()->write(json_encode($responseBody,JSON_NUMERIC_CHECK));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});







/* Runner the aplication */
$app->run();


