import { BrowserRouter as Router, Route, Routes } from "react-router-dom";
import * as React from 'react';

import Config from './components/config';

import NotFound from "./components/notFound";
import TipoList from "./components/tipoList";
import CasosList from "./components/casosList";
import UsuarioList from "./components/usuarioList";
import Fullcalendar from "./components/fullcalendar";

function App() {

  return (
    <div className="App">
      <Router>
  
          <Routes>
            <Route path={`${Config.URL_APP}/`} element={<CasosList  />} />
            <Route path={`${Config.URL_APP}/tipoList`} element={<TipoList />} />
            <Route path={`${Config.URL_APP}/casosList`} element={<CasosList />} />
            <Route path={`${Config.URL_APP}/usuarioList`} element={<UsuarioList />} />
            <Route path={`${Config.URL_APP}/fullcalendar/:id`} element={<Fullcalendar />} />
            {/* Other routes  */}
            <Route path="*" element={<NotFound />} />        
          </Routes>

      </Router>
    </div>
  );
}

export default App;
