import * as React from 'react';
import './style.css';

import {
  DataGrid,
  GridToolbarContainer,
  GridToolbarColumnsButton,
  GridToolbarFilterButton,
  GridToolbarDensitySelector,
  GridToolbarExport,
  GridActionsCellItem,
  // GridToolbar,
} from '@mui/x-data-grid';

import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
import EditIcon from '@mui/icons-material/Edit';
import CachedIcon from '@mui/icons-material/Cached';
import DeleteIcon from '@mui/icons-material/Delete';
import MoreVertIcon from '@mui/icons-material/MoreVert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import axios from 'axios';
import {useEffect, useState} from 'react';

// import { esES } from '@mui/material/locale';
import { esES } from '@mui/x-data-grid/locales';

// import 'dayjs/locale/es';
// import dayjs from 'dayjs';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';
import CasosAdd from '../casosAdd';
import CasosEdit from '../casosEdit';
import CasosView from '../casosView';


const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function  CasosList(props) {
 
  const [rows, setRows] = useState(null);
  const [row, setRow] = useState(null);
  const [rowsTipo, setRowsTipo] = useState(null);
  const [rowsUser, setRowsUser] = useState(null);

   const [rowSelectionModel, setRowSelectionModel] = React.useState([]); // Para control del registro seleccionado en el GRID
  const [action, setAction] = useState(''); // Acción sobre el registro (row) - add, edit, view -

  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);
  const [isDouble, setIsDouble] = useState(true);
  const [viewList, setViewList] = useState(true);

  // Notificación error grave
  function errorNotification(code, message) {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    // props.navigate(Config.URL_APP+'/');
  }

  // Cargar los datos del Server cuando se carga y recarga la página
  const fetchCasos = async () => {
    if (refresh) {        // Para intentar que sólo sea una vez
      setRefresh(false);
      var formWitdh = window.innerWidth;
      // console.log("Ancho de pantalla: ",formWitdh);
      if (formWitdh < 768) {
        // console.log("pone isMobile a 'true'");
        setIsMobile(true);
      }
      if (formWitdh < 1390) { // Para ver si tenemos que ocultar el GRID
        setIsDouble(false);
      }

      const url = Config.RUTA_API + "/casoList";
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      try {  
        const response = await axios.post(url,formData,config)     
            var msg = response.data;
            // console.log("Respuesta del fetch: ",msg); 
            if (msg.error === true )  { 
              console.log("Hay un error: ",msg.message);
              errorNotification(msg.error, msg.message);
            } else {
              setRows(msg.data);
              setRowsTipo(msg.dataTipo);
              setRowsUser(msg.dataUsuario);
              // console.log("Casos: ",msg.data);
              // console.log("Tipos: ",msg.dataTipo);
              // console.log("Usuarios: ",msg.dataUsuario);

            }           
          }
      catch(error) {
            console.error("Error get Lista Casos ", error);
            errorNotification('000', error);
          }
    }
  };

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutándose 'useEffect");
    fetchCasos();
    setAction('');
     }, [refresh]);


// CallBack de Delete registro
  const deleteRow = React.useCallback(
    (id)  => () =>
    {
      // console.log("Registro a eliminar: ",id);

      setAction('');   // Elimina ventanas de Add o Edit

      const row = rows.find((rowid) => Number(rowid.id) === Number(id));


      var msg = `¿Quieres <b>ELIMINAR el Caso:</b> id:${row.id} de ${row.nombre_apellidos}? `;

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        html: msg,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {
            // console.log("Comfirmed OK",response);

             // Acceso al server y status de la operación
            const url = Config.RUTA_API + "/caso/delete/"+id;
            const formData = new FormData();
            const config = {
              headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Authorization": Config.AUTHORIZATION
                },
              };  
            axios.post(url, formData, config)
        
              .then((response) => {
                const res = response.data;
                // console.log("Respuesta del fetch: ",res);
                if (res.error === false) {
                    setRows((prevRows) => prevRows.filter((row) => Number(row.id) !== Number(id)));
                    // console.log("Delete row ID: ",id);
      
                    MySwal.fire({
                      icon: 'info',
                      title: 'Caso eliminado!!!!',
                      text: '',
                      timer: 1000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                  } else {
                    errorNotification(res.code, res.message);
                }
              })
            .catch((error) => {
              console.error("Error delete Caso: ", error);
              setRefresh(true);  // Reload Data from Server
            })
          }
        })
      },[rows],
    );
  

 
  const editRow = React.useCallback(
    (id) => () => {
      const row = rows.find((rowid) => rowid.id === id);
      if (action === '') {
          setRow(row);
          setAction('edit');
          if (isMobile) {setViewList(false)}
      } else {
          setAction('');
      }
    },
    [rows,action],
  );

   
  const viewRow = React.useCallback(
    (id)=> {
      const row = rows.find((rowid) => rowid.id === id);
      // console.log("El ID selecionado: ",id);
      // console.log("estamos en VIEW, record: ",rows);
      if (action === '') {
          setRow(row);
          setAction('view');
          if (isMobile) {setViewList(false)}
      } else {
          setAction('');
      }
    },
    [rows,action],
  );

  const addRow = React.useCallback(
    () => {
      if (action === '') {
          setAction('add');
          if (isMobile) {setViewList(false)}
      } else {
          setAction('');
      }
    },
    [action],
  );

  const handleButtonClickFromItem = (actionRb,newAction = '') => {
    console.log("Regreso formulario remoto: ",actionRb);
    setAction('');
    
    if (actionRb === 'add') {
      setRefresh(true);
      if (isMobile) { setViewList(true)}
    }
    
    if (actionRb === 'edit') {
      setRefresh(true);
      if (isMobile) { setViewList(true)}
    }
    
    if (actionRb === 'view') {
      // console.log("Valor de Nueva Acción: ",newAction);
      if (newAction !== '') {
        switch (newAction) {
          case "edit":
            setAction(newAction);
            break;
          case "delete":
            // console.log("Registro eliminado:");
            // deleteRow(id)(); // Proceso de eliminación del registro. Require +(), por el tipo de Callaback
            setRefresh(true);
            // fetchCasos();  // Recuperando nuevos registros
            // console.log("En 'delete', después de Refresh");
            if (isMobile) { setViewList(true)}
            break;
          default:
            // console.log("Pasó por default");
          }
        } else {
          if (isMobile) { setViewList(true)}
        }
    }    
  };

  function CustomToolbar() {
    if (isMobile) {
      return (
          <GridToolbarContainer>
          <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
          <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
          <MoreVertIcon sx={{ color:"#1976d2" }} />
          <GridToolbarExport />
        </GridToolbarContainer>
      )
    } else {
    return (
      <GridToolbarContainer>
        <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
        <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
        <MoreVertIcon sx={{ color:"#1976d2" }} />
      
        <GridToolbarColumnsButton />
        <GridToolbarFilterButton />
        <GridToolbarDensitySelector />
        <GridToolbarExport />             
      </GridToolbarContainer>
      );
    }
  }

  const columns = React.useMemo(
    () => [
      {
        field: 'actions',
        hideable: false,
        headerName: 'Acciones',
        type: 'actions',
        flex: 0.5,
        minWidth:74,
        getActions: ({ id, row }) => {
   
        return [

            <GridActionsCellItem
              icon={<EditIcon />}
              label="Edit"
              // className="textPrimary"
              onClick={editRow(id)}
              color="inherit"
            />,
            <GridActionsCellItem
              icon={<DeleteIcon />}
              label="Delete"
              // className="textPrimary"
              onClick={deleteRow(id)}
              color="inherit"
          />,
        ];   
        }
      },
      // { field: 'incidente_usuario_id', hideable: false, headerName: 'Usuario', type: 'singleSelect',
      //  getOptionValue: (key) => key.id, getOptionLabel: (value) => value.nombre_apellidos,  valueOptions: rowsUser , flex: 0.7, minWidth: 100 },
      { field: 'nombre_apellidos', hideable: false, headerName: 'Usuario', type: 'string', flex: 0.7, minWidth: 100 },
      { field: 'titulo_tipo', hideable: false, headerName: 'Tipo permiso', type: 'string',flex: 0.7, minWidth: 100 },
      
      /* 
      { field: 'fechaDesde', hideable: true, headerName: 'Fecha Inicial', type: 'date', valueGetter: (value) => value && new Date(value),renderCell: renderDate, flex: 0.6, minWidth:100 },
      { field: 'fechaHasta', hideable: true, headerName: 'Fecha final',type: 'date', valueGetter: (value) => value && new Date(value),renderCell: renderDate, flex: 0.6, minWidth: 100 },
       */
      { field: 'fechaDesde', hideable: true, headerName: 'Fecha Inicial', type: 'date', valueGetter: (value) => value && new Date(value), flex: 0.6, minWidth:100 },
      { field: 'fechaHasta', hideable: true, headerName: 'Fecha final',type: 'date', valueGetter: (value) => value && new Date(value) , flex: 0.6, minWidth: 100 },

      { field: 'diasLaborables', hideable: true, headerName: 'Laborables', type: 'int',  flex: 0.3, minWidth: 30, align: 'right' },
      { field: 'diasFinSemana', hideable: true, headerName: 'Festivos', type: 'int',  flex: 0.3, minWidth: 30, align: 'right' },

    ],
    [deleteRow, editRow],
  );


  return (
    <>
    <Nav />

    <ThemeProvider theme={theme}>
      <div className='contenedor'>

      {viewList?
        <div className={`panel ${ viewList ? "" : "hide_div"}`}>
          <div className='box-itemList'>
            <div className='titlePage'>
                <h3 className="head_title">Estos son los Casos de los Incidentes </h3>
            </div>

           <DataGrid  columns={columns} rows={rows}
              initialState={{
                pagination: {
                  paginationModel: { page: 0, pageSize: 5 },
                },
                columns: {
                  columnVisibilityModel: {
                  },
                },
              }}
              autosizeOptions={{
                columns: ['incidente_usuario_id', 'incidente_tipo_id','fechaDesde','fechaHasta','diasLaborables','diasFinSemana'],
                includeOutliers: true,
                includeHeaders: true,
              }}
              pageSizeOptions={[2,5 , 10, 15, 20, 100]}
              hideFooterSelectedRowCount={true}
              // enableRowNumbers
              // disableRowSelectionOnClick
              onRowSelectionModelChange={(newRowSelectionModel) => {
                    // Aquí el control del registro seleccionado. 
                    setRowSelectionModel(newRowSelectionModel);
                    // console.log("Array de registros seleccionados: ",newRowSelectionModel);
                    const idSelected = newRowSelectionModel[0];
                    // console.log("Id seleccionado: ",idSelected);
                    viewRow(idSelected);
                    // props.navigate(Config.URL_APP+'/compraView/'+idSelected);
              }}
              slots={{
                toolbar: CustomToolbar
              }}

            />
          </div>  
        </div>
        :''}
        { action === 'add'? <CasosAdd  rowsTipo={rowsTipo}  rowsUser={rowsUser}  onButtonClick={handleButtonClickFromItem} /> :''}
        { action === 'edit'? <CasosEdit  row={row} rowsUser={rowsUser} rowsTipo={rowsTipo} onButtonClick={handleButtonClickFromItem}/> :''}
        { action === 'view' && row !== undefined? <CasosView row={row} rowsUser={rowsUser} rowsTipo={rowsTipo} onButtonClick={handleButtonClickFromItem}/> :''}
      </div>

        
      </ThemeProvider>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( CasosList );