import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import 'dayjs/locale/es';
import dayjs from 'dayjs';
// import { DateField } from '@mui/x-date-pickers/DateField';
// import { DatePicker } from '@mui/x-date-pickers/DatePicker';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import Dialog from '@mui/material/Dialog';
import DialogActions from '@mui/material/DialogActions';
import DialogContent from '@mui/material/DialogContent';
import DialogContentText from '@mui/material/DialogContentText';
import DialogTitle from '@mui/material/DialogTitle';

import axios from 'axios';

import Config from '../config';
import { DateField } from '@mui/x-date-pickers/DateField';

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

function CasoView({row,rowsUser,rowsTipo,onButtonClick}) {

  const [open, setOpen] = React.useState(false);
 
 //  const [validacionForms, setValidacionForms] = useState(true);
 //  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
      "incidente_usuario_id": '',
      "incidente_tipo_id": '',
      "fechaDesde":null,
      "fechaHasta":null,
      "titulo":'',
      "descripcion": ''
  });
  /*
    const [errorUsuario, setErrorUsuario] = useState(false);
    const [helperUsuario, setHelperUsuario] = useState('');
  
    const [errorTipo, setErrorTipo] = useState(false);
    const [helperTipo, setHelperTipo] = useState('');
  
    const [errorFechaDesde, setErrorFechaDesde] = useState(false);
    const [helperFechaDesde, setHelperFechaDesde] = useState('');
  
    const [errorFechaHasta, setErrorFechaHasta] = useState(false);
    const [helperFechaHasta, setHelperFechaHasta] = useState('');
  
    const [errorTitulo, setErrorTitulo] = useState(false);
    const [helperTitulo, setHelperTitulo] = useState('');
  
    const [errorDescripcion, setErrorDescripcion] = useState(false);
    const [helperDescripcion, setHelperDescripcion] = useState('');
  */

  // Notificación error grave
    function errorNotification(code, message) {
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
    }

    
  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Estoy en useEfect. Valor de row: ",row);

      setInput(row);
    
    
    // console.log("Ejecutando 'useEffect() en grupoAdd", auth);
  }, []);

  // Delete registro
  const deleteRow = () =>
    {
      // console.log("Registro a eliminar: ",row);

      const id = row.id;

        // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/caso/delete/"+id;
      const formData = new FormData();
      const config = {
        headers: {
          "Content-Type": "application/x-www-form-urlencoded",
          "Authorization": Config.AUTHORIZATION
          },
        };  
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {
              // setRows((prevRows) => prevRows.filter((row) => row.id !== id));
              // console.log("Delete row ID: ",id);
              const MySwal = withReactContent(Swal); 
              MySwal.fire({
                icon: 'info',
                title: 'Caso eliminado!!!!',
                text: '',
                timer: 1000,
                timerProgressBar: true,
                toast: true,
                position: "center",
                footer: ''
              })
              setOpen(false); // Elimina popup de confirmación
              // Especial desde View
              onButtonClick('view','delete') // Devolución del control a página LIST

            } else {
              errorNotification(res.code, res.message);
          }
        })
      .catch((error) => {
        console.error("Error delete Caso: ", error);
        // setRefresh(true);  // Reload Data from Server
      })

  };

const handleClickOpenDialog = () => {
  setOpen(true);
};

  const handleCloseDialog = () => {
    setOpen(false);
  };
  
  return (
    <>

    <ThemeProvider theme={theme}>
    <div className='panel-itemEdit'>
      <div className='box-itemEdit'>
        <Box component="form" noValidate autoComplete="off" >  
          <div className='titlePage'>
            <h3 className="head_title">Visualizar Caso</h3>
          </div>
          <Grid container spacing={2}>
          <Grid xs={12}>
                <InputLabel id="select-label">Selecciona el Usuario *</InputLabel>
                <Select 
                  // error={errorUsuario} 
                  id="incidente_usuario_id" 
                  name="incidente_usuario_id"
                  label="Usuario" 
                  required={false}
                  variant="standard"   
                  className= 'CustomField'  
                  value={input.incidente_usuario_id || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  // onChange={handleValidationField}
                >
                {rowsUser.map((row, index) => (
                  <MenuItem key={row.id}  value={row.id}> {row.nombre_apellidos} 
                  </MenuItem> 
                ))}
                </Select>
                {/* {errorUsuario && <FormHelperText>{helperUsuario}</FormHelperText>} */}
            </Grid>

            <Grid xs={12}>
                <InputLabel id="select-label">Selecciona el Tipo *</InputLabel>
                <Select 
                  // error={errorTipo} 
                  id="incidente_tipo_id" 
                  name="incidente_tipo_id"
                  label="Tipo" 
                  required={false}
                  variant="standard"   
                  className= 'CustomField'  
                  value={input.incidente_tipo_id || ''}
                  slotProps={{ input: { readOnly: true, }, }}
                  // onChange={handleValidationField}
                >
                {rowsTipo.map((row, index) => (
                  <MenuItem key={row.id}  value={row.id}> {row.titulo} 
                  </MenuItem> 
                ))}
                </Select>
                {/* {errorTipo && <FormHelperText>{helperTipo}</FormHelperText>} */}
            </Grid>
            <Grid xs={12}>
            <LocalizationProvider dateAdapter={AdapterDayjs} adapterLocale="es">
                <DateField
                  // error={errorFechaDesde} 
                  required={false}
                  id="fechaDesde"
                  name="FechaDesde" 
                  label="Fecha Desde" 
                  slotProps={{ textField: { variant: "standard" , readOnly: true } }}
                  //variant="standard"
                  className= 'CustomField'
                  // helperText={helperFechaDesde}
                  value={dayjs(input.fechaDesde)}
                  // onChange={(e) => handleValidationFechaDesde(e)} 
                  />
            </LocalizationProvider>
            </Grid>
            <Grid xs={12}>
            <LocalizationProvider dateAdapter={AdapterDayjs} adapterLocale="es">
                <DateField
                  // error={errorFechaHasta} 
                  required={false}
                  id="fechaHasta"
                  name="FechaHasta" 
                  label="FechaHasta" 
                  slotProps={{ textField: { variant: "standard" , readOnly: true } }}
                  //variant="standard"
                  className= 'CustomField'
                  // helperText={helperFechaHasta}
                  value={dayjs(input.fechaHasta)}
                  // onChange={(e) => handleValidationFechaHasta(e)} 
                  />
            </LocalizationProvider>
            </Grid>
            <Grid xs={12}>
              <TextField  
                  // error={errorTitulo} 
                  required={false}
                  id="titulo"
                  name="titulo" 
                  label="Título" 
                  variant="standard" 
                  type= 'text'
                  className= 'CustomField'  
                  // helperText={helperTitulo}
                  value={input.titulo }
                  slotProps={{ input: { readOnly: true, }, }}
                  // onChange={(e) => handleValidationField(e)}
                  />
            </Grid>
            <Grid xs={12}>
              <TextField  
                  // error={errorDescripcion} 
                  required={false}
                  id="descripcion"
                  name="descripcion" 
                  label="Descripción" 
                  variant="standard" 
                  type= 'text' 
                  multiline = {true}
                  rows = {2}
                  className= 'CustomField'  
                  // helperText={helperDescripcion}
                  value={input.descripcion}
                  slotProps={{ input: { readOnly: true, }, }}
                  // onChange={(e) => handleValidationField(e)}
                  />
            </Grid>
          </Grid>
          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              {/*<Button variant="contained" type='submit'  onClick={(e) =>  onButtonClick('view')}>Cerrar</Button> */}
              <Button variant="outlined"                onClick={(e) =>  onButtonClick('view')}>Cerrar</Button>
              <Button variant="outlined"                onClick={(e) =>  onButtonClick('view','edit')}>Editar</Button>
              <Button variant="outlined" color="error"  onClick={(e) =>  handleClickOpenDialog()}>Eliminar</Button>
          </Stack>
          <Stack sx={{ width: '100%' }} spacing={2}>
            {/* { validacionForms? '': <Alert severity="error">{errorForms}</Alert>} */}
          </Stack>
        </Box>
      </div>
      {/* Diálogo para confirmar la baja del registro */}
      <Dialog
        open={open}
        onClose={handleCloseDialog}
        aria-labelledby="alert-dialog-title"
        aria-describedby="alert-dialog-description"
      >
        <DialogTitle id="alert-dialog-title">
          {"Estas seguro que deseas eliminar este registro?"}
        </DialogTitle>
        <DialogContent>
          <DialogContentText id="alert-dialog-description">
            ¿Quieres <b>ELIMINAR el Caso:</b> id: {row.id} del usuario:  {row.nombre_apellidos}?  
          </DialogContentText>
        </DialogContent>
        <DialogActions>
          <Button variant="outlined"  onClick={handleCloseDialog}>Cancelar</Button>
          <Button variant="outlined" color="error"  onClick={deleteRow} autoFocus>
            Confirmar Eliminación
          </Button>
        </DialogActions>
      </Dialog>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default (CasoView);