import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

import { HexColorPicker } from "react-colorful";

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import Config from '../config';

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

function TipoEdit({row,onButtonClick}) {

 
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
    id: 0,
    titulo: "",
    color: "#ff002d"
  });

  const [errorTitulo, setErrorTitulo] = useState(false);
  const [helperTitulo, setHelperTitulo] = useState('');

  // Notificación error grave
    function errorNotification(code, message) {
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
    }

    
  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    setInput(row);
    // console.log("Ejecutando 'useEffect() en grupoAdd", auth);
  }, []);


     // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';
  
    if (input.titulo === '' || errorTitulo ) {
      setHelperTitulo('Hay que facilitar un Titulo Válido');
      setErrorTitulo(true);
      existeError = true;
      Error += ' (Título) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");

      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/tipo/update/"+input.id;
      const formData = new FormData();
        formData.append('titulo', input.titulo);
        formData.append('color', input.color);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {       
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Tipo: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Tipo: ", error); 
          errorNotification('000', error)

        });
  
    } else {
    
      setValidacionForms(false); // Ponemos los errores del formulario 
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Cambios de Tipo salvados!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })

     onButtonClick('edit'); // Devuelve el control a la pantalla "MASTER"

  }

  const handleValidationTitulo = (e) => {
    const { name, value } = e.target;
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));

    const reg = new RegExp("^([a-zA-Z0-9_áéíóúüñÑ -]){3,50}$");
    if (! reg.test(e.target.value)) {
      setHelperTitulo('Entrada inválida para "Nombre de Tipo"');
    } else {
      setHelperTitulo('');
    }
    setErrorTitulo(!reg.test(e.target.value));

  };

  const handleValidationColor = (value) => {
    const name = "color";
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));
  };

  
  return (
    <>

    <ThemeProvider theme={theme}>
    <div className='panel-itemEdit'>
      <div className='box-itemEdit'>
        <Box component="form" noValidate autoComplete="off" >  
          <div className='titlePage'>
            <h3 className="head_title">Editar Tipo</h3>
          </div>
          <Grid container spacing={2}>
            <Grid xs={12}>
              <TextField  
                  error={errorTitulo} 
                  required={false}
                  id="titulo"
                  name="titulo" 
                  label="Título" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperTitulo}
                  value={input.titulo }
                  onChange={(e) => handleValidationTitulo(e)}
                  />
            </Grid>
          </Grid>
          <div>
             &nbsp;
          </div>
          <div className="label-field">Color</div>
          <div className="value" style={{ backgroundColor: input.color }}> </div> 
          <div className="TextColor"> {input.color} </div>
          <div className="colorPicker"><HexColorPicker color={input.color} onChange={handleValidationColor} /></div>

          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
          </Stack>
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
        </Box>
      </div>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default (TipoEdit);