import * as React from 'react';
import './style.css';

import {
  DataGrid,
  GridToolbarContainer,
  GridToolbarColumnsButton,
  GridToolbarFilterButton,
  GridToolbarDensitySelector,
  GridToolbarExport,
  GridActionsCellItem,
  // GridToolbar,
} from '@mui/x-data-grid';

import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
import EditIcon from '@mui/icons-material/Edit';
import CachedIcon from '@mui/icons-material/Cached';
import DeleteIcon from '@mui/icons-material/Delete';
import MoreVertIcon from '@mui/icons-material/MoreVert';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import axios from 'axios';
import {useEffect, useState} from 'react';

// import { esES } from '@mui/material/locale';
import { esES } from '@mui/x-data-grid/locales';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';
import TipoAdd from '../tipoAdd';
import TipoEdit from '../tipoEdit';


const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function renderColor(params) {
  var color = params.value;
  return (
    <>
      <div className="color" style={{ backgroundColor: color }}> </div> 
      <div className="TextColor"> {color} </div>
    </>
  );
}

function  TipoList(props) {
 
  const [rows, setRows] = useState(null);
  const [row, setRow] = useState(null);
  const [action, setAction] = useState(''); // Acción sobre el registro (row) - add, edit, view -

  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);

  // Notificación error grave
  function errorNotification(code, message) {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    // props.navigate(Config.URL_APP+'/');
  }

  // Cargar los datos del Server cuando se carga y recarga la página
  const fetchTipo= async () => {
    if (refresh) {        // Para intentar que sólo sea una vez
      setRefresh(false);
      var formWitdh = window.innerWidth;
      // console.log("Ancho de pantalla: ",formWitdh);
      if (formWitdh < 768) {
        setIsMobile(true);
      }
      const url = Config.RUTA_API + "/tipoList";
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      try {  
        const response = await axios.post(url,formData,config)     
            var data = response.data;
            // console.log("Respuesta del fetch: ",data); 
            if (data.error === true )  { 
              console.log("Hay un error: ",data.message);
              errorNotification(data.error, data.message);
            } else {
              setRows(data.data);
            }           
          }
      catch(error) {
            console.error("Error get Lista Tipos ", error);
            errorNotification('000', error);
          }
    }
  };

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutándose 'useEffect");
    fetchTipo();
    setAction('');
     }, [refresh]);

  const deleteRow = React.useCallback((id) => () => 
    {
      // console.log("Registro a eliminar: ",id);

      setAction('');   // Elimina ventanas de Add o Edit

      const row = rows.find((rowid) => rowid.id === id);


      var msg = `¿Quieres <b>ELIMINAR el Tipo:</b> ${row.titulo}? `;

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        html: msg,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {
            // console.log("Comfirmed OK",response);

             // Acceso al server y status de la operación
            const url = Config.RUTA_API + "/tipo/delete/"+id;
            const formData = new FormData();
            const config = {
              headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Authorization": Config.AUTHORIZATION
                },
              };  
            axios.post(url, formData, config)
        
              .then((response) => {
                const res = response.data;
                // console.log("Respuesta del fetch: ",res);
                if (res.error === false) {
                    setRows((prevRows) => prevRows.filter((row) => row.id !== id));
                    // console.log("Delete row ID: ",id);
      
                    MySwal.fire({
                      icon: 'info',
                      title: 'Tipo eliminado!!!!',
                      text: '',
                      timer: 1000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                  } else {
                    errorNotification(res.code, res.message);
                }
              })
            .catch((error) => {
              console.error("Error delete Tipo: ", error);
              setRefresh(true);  // Reload Data from Server
            })
          }
        })
    },
    [rows],
  );

 
  const editRow = React.useCallback(
    (id) => () => {
      const row = rows.find((rowid) => rowid.id === id);
      if (action === '') {
          setRow(row);
          setAction('edit');
      } else {
          setAction('');
      }
    },
    [rows,action],
  );

  const addRow = React.useCallback(
    () => {
      if (action === '') {
          setAction('add');
      } else {
          setAction('');
      }
    },
    [action],
  );

  const handleButtonClickFromItem = (action) => {
    console.log("Regreso formulario remoto: ",action);
    if (action === 'add') {
      setAction('');
      setRefresh(true);
    }
    if (action === 'edit') {
      setAction('');
      setRefresh(true);
    }
  };

  function CustomToolbar() {
    if (isMobile) {
      return (
          <GridToolbarContainer>
          <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
          <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
          <MoreVertIcon sx={{ color:"#1976d2" }} />
          <GridToolbarExport />
        </GridToolbarContainer>
      )
    } else {
    return (

      <GridToolbarContainer>
        <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
        <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
        <MoreVertIcon sx={{ color:"#1976d2" }} />
      
        <GridToolbarColumnsButton />
        <GridToolbarFilterButton />
        <GridToolbarDensitySelector />
        <GridToolbarExport />             
      </GridToolbarContainer>
      );
    }
  }

  const columns = React.useMemo(
    () => [
      {
        field: 'actions',
        hideable: false,
        headerName: 'Acciones',
        type: 'actions',
        flex: 1,
        minWidth: 100,
        getActions: ({ id, row }) => {
   
        return [
            <GridActionsCellItem
              icon={<EditIcon />}
              label="Edit"
              // className="textPrimary"
              onClick={editRow(id)}
              color="inherit"
            />,
            <GridActionsCellItem
              icon={<DeleteIcon />}
              label="Delete"
              // className="textPrimary"
              onClick={deleteRow(id)}
              color="inherit"
          />,
        ];   
        }
      },
      { field: 'titulo', hideable: false, headerName: 'Título', type: 'string',  flex: 2 }, 
      { field: 'color', headerName: 'Color', type: 'string', flex: 1, renderCell: renderColor, sortable: false},
    ],
    [deleteRow, editRow],
  );


  return (
    <>
    <Nav />

    <ThemeProvider theme={theme}>

      <div className='contenedor'>
        <div className='panel'>
          <div className='box-itemList'>
            <div className='titlePage'>
                <h3 className="head_title">Estos son los Tipos de Incidentes </h3>
            </div>
            {/*
            <div className='titleButtons' >
              <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
              <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>
                  Nuevo
              </Button>
            </div>
            */}
           <DataGrid  columns={columns} rows={rows}
              initialState={{
                pagination: {
                  paginationModel: { page: 0, pageSize: 4 },
                },
                columns: {
                  columnVisibilityModel: {

                  },
                },
              }}
              autosizeOptions={{
                columns: ['titulo', 'color'],
                includeOutliers: true,
                includeHeaders: true,
              }}
              pageSizeOptions={[2,4,7, 10, 15, 20, 100]}
              // enableRowNumbers
              disableRowSelectionOnClick
              slots={{
                toolbar: CustomToolbar,
              }}

            />
          </div>  
        </div>
        { action === 'add'? <TipoAdd  onButtonClick={handleButtonClickFromItem}/> :''}
        { action === 'edit'? <TipoEdit  row={row} onButtonClick={handleButtonClickFromItem}/> :''}
      </div>

        
      </ThemeProvider>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( TipoList );