import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
// import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

// import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
// import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
// import 'dayjs/locale/es';
// import dayjs from 'dayjs';
// import { DateField } from '@mui/x-date-pickers/DateField';
// import { DatePicker } from '@mui/x-date-pickers/DatePicker';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import Config from '../config';

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

function UsuarioEdit({row,rows,onButtonClick}) {

  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
      "login": '',
      "nombre_apellidos": ''
  });

  const [login, setLogin] = useState('');

  const [errorLogin, setErrorLogin] = useState(false);
  const [helperLogin, setHelperLogin] = useState('');

  const [errorNombre_apellidos, setErrorNombre_apellidos] = useState(false);
  const [helperNombre_apellidos, setHelperNombre_apellidos] = useState('');

  // Notificación error grave
    function errorNotification(code, message) {
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
    }

    
  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    setInput(row);
    setLogin(row.login);
    // console.log("Ejecutando 'useEffect() en grupoAdd", auth);
  }, []);


  // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    // console.log("Valores del registro Input: ",input);
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';

    if (input.login === '' || errorLogin ) {
      setHelperLogin('Hay que facilitar un Login Válido');
      setErrorLogin(true);
      existeError = true;
      Error += ' (Login) ';
    }

    const row = rows.find((rowid) => rowid.login === input.login);
    // console.log("Busqueda de duplicado: ",row);
    if(typeof row !== 'undefined' && login !== input.login){
      setHelperLogin('El login facilitado está duplicado');
      setErrorLogin(true);
      existeError = true;
      Error += ' (Login) ';
    }

    if (input.nombre_apellidos === '' || errorNombre_apellidos ) {
      setHelperNombre_apellidos('Hay que facilitar un Nombre y Apellidos válido');
      setErrorNombre_apellidos(true);
      existeError = true;
      Error += ' (Nombre y Apellidos) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");

      // Acceso al server y status de la operación
      const url = Config.RUTA_API + "/usuario/update/"+input.id;
      const formData = new FormData();
        formData.append('login', input.login);
        formData.append('nombre_apellidos', input.nombre_apellidos);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {       
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Usuario: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Usuario: ", error); 
          errorNotification('000', error)

        });
  
    } else {   
      setValidacionForms(false); // Ponemos los errores del formulario 
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };


  const postSave = (e) => {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Cambios de Usuario salvados!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })

     onButtonClick('edit'); // Devuelve el control a la pantalla "MASTER"

  }

  const handleValidationField = (e) => {
    // console.log("Cambio en campo: ",e);
    var { name, value } = e.target;
    if (name === 'login') {  value = value.trim(); } // Login no puede tener espacios
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));
    if (name === 'login' && ( value.length < 4 || value.length > 12 )) {
      setHelperLogin('Entrada inválida para "Login"')
      setErrorLogin(true);
    }else{
      setHelperLogin('')
      setErrorLogin(false);
    }
    if (name === 'nombre_apellidos' && ( value.length < 6 || value.length > 100 )) {
      setHelperNombre_apellidos('Entrada inválida para "Nombre y Apellidos"')
      setErrorNombre_apellidos(true);
    }else{
      setHelperNombre_apellidos('')
      setErrorNombre_apellidos(false);
    }
    
  };

  
  return (
   <>
    <ThemeProvider theme={theme}>
    <div className='panel-itemEdit'>
      <div className='box-itemEdit'>
        <Box component="form" noValidate autoComplete="off" > 
        <div className='titlePage'>
          <h3 className="head_title">Editar Usuario</h3>
        </div> 
          <Grid container spacing={2}>
            <Grid xs={12}>
              <TextField  
                  error={errorLogin} 
                  required={false}
                  id="login"
                  name="login" 
                  label="Login" 
                  variant="standard" 
                  type= 'text'
                  className= 'CustomField'  
                  helperText={helperLogin}
                  value={input.login }
                  onChange={(e) => handleValidationField(e)}
                  />
            </Grid>
            <Grid xs={12}>
              <TextField  
                  error={errorNombre_apellidos} 
                  required={false}
                  id="nombre_apellidos"
                  name="nombre_apellidos" 
                  label="Nombre y Apellidos" 
                  variant="standard" 
                  type= 'text' 
                  className= 'CustomField'  
                  helperText={helperNombre_apellidos}
                  value={input.nombre_apellidos}
                  onChange={(e) => handleValidationField(e)}
                  />
            </Grid>
          </Grid>


          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"                onClick={(e) =>  onButtonClick('edit')}>Cancelar</Button>
          </Stack>
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
        </Box>
      </div>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default (UsuarioEdit);