import * as React from 'react';
import './style.css';

import {
  DataGrid,
  GridToolbarContainer,
  GridToolbarColumnsButton,
  GridToolbarFilterButton,
  GridToolbarDensitySelector,
  GridToolbarExport,
  GridActionsCellItem,
  // GridToolbar,
} from '@mui/x-data-grid';

import Button from '@mui/material/Button';

import AddIcon from '@mui/icons-material/Add';
import EditIcon from '@mui/icons-material/Edit';
import CachedIcon from '@mui/icons-material/Cached';
import DeleteIcon from '@mui/icons-material/Delete';
import MoreVertIcon from '@mui/icons-material/MoreVert';
import CalendarMonthIcon from '@mui/icons-material/CalendarMonth';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import { createTheme, ThemeProvider } from '@mui/material/styles';
import axios from 'axios';
import {useEffect, useState} from 'react';

import Box from '@mui/material/Box';
import Modal from '@mui/material/Modal';

// import { esES } from '@mui/material/locale';
import { esES } from '@mui/x-data-grid/locales';

import { useNavigate } from 'react-router-dom';

import Nav from '../nav';
import Config from '../config';
import UsuarioAdd from '../usuarioAdd';
import UsuarioEdit from '../usuarioEdit';

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

const styleModal = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: 555,
  bgcolor: 'background.paper',
  // border: '2px solid #000',
  // boxShadow: 24,
  p: 4,
};
const styleModalMobile = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: '100%',
  bgcolor: 'background.paper',
  // border: '2px solid #000',
  // boxShadow: 24,
  // p: 1,
};

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function  UsuarioList(props) {
 
  const [rows, setRows] = useState(null);
  const [row, setRow] = useState(null);

  // const [rowSelectionModel, setRowSelectionModel] = React.useState([]); // Para control del registro seleccionado en el GRID
  const [action, setAction] = useState(''); // Acción sobre el registro (row) - add, edit, view 
  
  const [open, setOpen] = React.useState(false);   // Open / Close Modal window

  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);

  // Notificación error grave
  function errorNotification(code, message) {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    // props.navigate(Config.URL_APP+'/');
  }

  // Cargar los datos del Server cuando se carga y recarga la página
  const fetchUsuarios= async () => {
    if (refresh) {        // Para intentar que sólo sea una vez
      setRefresh(false);
      var formWitdh = window.innerWidth;
      // console.log("Ancho de pantalla: ",formWitdh);
      if (formWitdh < 768) {
        setIsMobile(true);
      }

      const url = Config.RUTA_API + "/usuarioList";
      const formData = new FormData();
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      try {  
        const response = await axios.post(url,formData,config)     
            var msg = response.data;
            // console.log("Respuesta del fetch: ",msg); 
            if (msg.error === true )  { 
              console.log("Hay un error: ",msg.message);
              errorNotification(msg.error, msg.message);
            } else {
              setRows(msg.data);
            }           
          }
      catch(error) {
            console.error("Error get Lista Usuarios ", error);
            errorNotification('000', error);
          }
    }
  };

  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutándose 'useEffect");
    fetchUsuarios();
    setAction('');
     }, [refresh]);

  const deleteRow = React.useCallback((id) => () => 
    {
      // console.log("Registro a eliminar: ",id);
      setAction('');   // Elimina ventanas de Add o Edit
      const row = rows.find((rowid) => rowid.id === id);

      var msg = `¿Quieres <b>ELIMINAR el Usuario:</b> id:${row.id} de ${row.nombre_apellidos}? `;

      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        title: 'Confirmación',
        html: msg,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3298dc',
        cancelButtonColor: '#f14668',
        cancelButtonText: 'No',
        confirmButtonText: 'Sí, eliminar'
      })

        .then(response => {
          if (response.isConfirmed) {

             // Acceso al server y status de la operación
            const url = Config.RUTA_API + "/usuario/delete/"+id;
            const formData = new FormData();
            const config = {
              headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                "Authorization": Config.AUTHORIZATION
                },
              };  
            axios.post(url, formData, config)
        
              .then((response) => {
                const res = response.data;
                // console.log("Respuesta del fetch: ",res);
                if (res.error === false) {
                    setRows((prevRows) => prevRows.filter((row) => row.id !== id));
                    // console.log("Delete row ID: ",id);
      
                    MySwal.fire({
                      icon: 'info',
                      title: 'Usuario eliminado!!!!',
                      text: '',
                      timer: 1000,
                      timerProgressBar: true,
                      toast: true,
                      position: "center",
                      footer: ''
                    })
                  } else {
                    errorNotification(res.code, res.message);
                }
              })
            .catch((error) => {
              console.error("Error delete Usuario: ", error);
              errorNotification('000', error);
              setRefresh(true);  // Reload Data from Server
            })
          }
        })
    },
    [rows],
  );

  const calendarRow = React.useCallback(
    (id) => () => {
      props.navigate(Config.URL_APP+'/fullcalendar/'+id);
    },
    [rows,action],
  );

 
  const editRow = React.useCallback(
    (id) => () => {
      const row = rows.find((rowid) => rowid.id === id);
      if (action === '') {
          setRow(row);
          setAction('edit');
          setOpen(true);
      } else {
          setAction('');
          setOpen(false);
      }
    },
    [rows,action],
  );

  const addRow = React.useCallback(
    () => {
      if (action === '') {
          setAction('add');
          setOpen(true);
      } else {
          setAction('');
          setOpen(false);
      }
    },
    [action],
  );

  // Gestión de respuesta de páginas modales
  const handleButtonClickFromItem = (action,newAction = '') => {
    console.log("Regreso formulario remoto: ",action);
    setOpen(false);
    if (action === 'add') {
      setAction('');
      setRefresh(true);
    }
    if (action === 'edit') {
      setAction('');
      setRefresh(true);
    }
  };

  function CustomToolbar() {
    if (isMobile) {
      return (
          <GridToolbarContainer>
          <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
          <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
          <MoreVertIcon sx={{ color:"#1976d2" }} />
          <GridToolbarExport />
        </GridToolbarContainer>
      )
    } else {
    return (
      <GridToolbarContainer>
        <Button color="primary"  startIcon={<CachedIcon />} onClick={(event) => setRefresh(true)}></Button>
        <Button color="primary"  startIcon={<AddIcon />} onClick={(event) => addRow(event)}>Nuevo</Button>
        <MoreVertIcon sx={{ color:"#1976d2" }} />
      
        <GridToolbarColumnsButton />
        <GridToolbarFilterButton />
        <GridToolbarDensitySelector />
        <GridToolbarExport />             
      </GridToolbarContainer>
      );
    }
  }

  const columns = React.useMemo(
    () => [
      {
        field: 'actions',
        hideable: false,
        headerName: 'Acciones',
        type: 'actions',
        flex: 0.5,
        minWidth:74,
        getActions: ({ id, row }) => {
   
        return [
            <GridActionsCellItem
              icon={<CalendarMonthIcon color="primary"/>}
              label="Calendar"
              // className="textPrimary"
              onClick={calendarRow(id)}
              color="inherit"
            />,
            <GridActionsCellItem
              icon={<EditIcon />}
              label="Edit"
              // className="textPrimary"
              onClick={editRow(id)}
              color="inherit"
            />,
            <GridActionsCellItem
              icon={<DeleteIcon />}
              label="Delete"
              // className="textPrimary"
              onClick={deleteRow(id)}
              color="inherit"
          />,
        ];   
        }
      },
      // { field: 'incidente_usuario_id', hideable: false, headerName: 'Usuario', type: 'singleSelect',
      //  getOptionValue: (key) => key.id, getOptionLabel: (value) => value.nombre_apellidos,  valueOptions: rowsUser , flex: 0.7, minWidth: 100 },
      { field: 'login', hideable: false, headerName: 'login', type: 'string',flex: 0.7, minWidth: 100 },
      { field: 'nombre_apellidos', hideable: false, headerName: 'Usuario', type: 'string', flex: 1.5, minWidth: 100 },
    ],
    [deleteRow, editRow, calendarRow],
  );


  return (
    <>
    <Nav />

    <ThemeProvider theme={theme}>
      <div className='contenedor'>

        <div className='panel'>
          <div className='box-itemList'>
            <div className='titlePage'>
                <h3 className="head_title">Listado de los Usuarios</h3>
            </div>

           <DataGrid  columns={columns} rows={rows}
              initialState={{
                pagination: {
                  paginationModel: { page: 0, pageSize: 5 },
                },
                columns: {
                  columnVisibilityModel: {
                  },
                },
              }}
              autosizeOptions={{
                columns: ['login', 'nombre_apellidos'],
                includeOutliers: true,
                includeHeaders: true,
              }}
              pageSizeOptions={[2,5 , 10, 15, 20, 100]}
              hideFooterSelectedRowCount={true}
              // enableRowNumbers
              disableRowSelectionOnClick
              /*
              onRowSelectionModelChange={(newRowSelectionModel) => {
                    // Aquí el control del registro seleccionado. 
                    setRowSelectionModel(newRowSelectionModel);
                    // console.log("Array de registros seleccionados: ",newRowSelectionModel);
                    const idSelected = newRowSelectionModel[0];
                    // console.log("Id seleccionado: ",idSelected);
                    viewRow(idSelected);
                    // props.navigate(Config.URL_APP+'/compraView/'+idSelected);
              }}
              */
              slots={{
                toolbar: CustomToolbar
              }}

            />
          </div>  
        </div>
      </div>
    </ThemeProvider>
        <Modal
          open={open}
          // onClose={handleButtonClickFromItem('add')}
          // aria-labelledby="modal-modal-title"
          // aria-describedby="modal-modal-description"
        >
          { isMobile?
         <Box sx={styleModalMobile}>
          { action === 'add'?<UsuarioAdd  rows={rows} onButtonClick={handleButtonClickFromItem} />:''}
          { action === 'edit'? <UsuarioEdit  row={row} rows={rows} onButtonClick={handleButtonClickFromItem}/> :''}
        </Box>
        :
        <Box sx={styleModal}>
        { action === 'add'?<UsuarioAdd  rows={rows} onButtonClick={handleButtonClickFromItem} />:''}
        { action === 'edit'? <UsuarioEdit  row={row} rows={rows} onButtonClick={handleButtonClickFromItem}/> :''}
      </Box>
          }
        </Modal>
    </>
  );
}
// IMPORTANT ----------------------------------------
export default withRouter( UsuarioList );