import * as React from 'react';
import {useEffect, useState} from 'react';
import './style.css';

import { createTheme, ThemeProvider } from '@mui/material/styles';
import { esES } from '@mui/material/locale';

import Grid from '@mui/material/Grid2';

import Box from '@mui/material/Box';
import TextField from '@mui/material/TextField';
import { Select, MenuItem, InputLabel, FormHelperText } from '@mui/material';
import Stack from '@mui/material/Stack';
import Button from '@mui/material/Button';

import Alert from '@mui/material/Alert';

import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import 'dayjs/locale/es';
import dayjs from 'dayjs';
// import { DateField } from '@mui/x-date-pickers/DateField';
import { DatePicker } from '@mui/x-date-pickers/DatePicker';

import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'

import axios from 'axios';

import Config from '../config';

const theme = createTheme(
  {
    palette: {
      primary: { main: '#1976d2' },
    },
  },
  esES,
);

function CasoAdd({onButtonClick,rowsUser,rowsTipo,row=null}) {
  
  const [validacionForms, setValidacionForms] = useState(true);
  const [errorForms, setErrorForms] = useState('');

  const [input, setInput] = useState({
      "incidente_usuario_id": '',
      "incidente_tipo_id": '',
      "fechaDesde":null,
      "fechaHasta":null,
      "titulo":'',
      "descripcion": ''
  });

  const [errorUsuario, setErrorUsuario] = useState(false);
  const [helperUsuario, setHelperUsuario] = useState('');

  const [errorTipo, setErrorTipo] = useState(false);
  const [helperTipo, setHelperTipo] = useState('');

  const [errorFechaDesde, setErrorFechaDesde] = useState(false);
  const [helperFechaDesde, setHelperFechaDesde] = useState('');

  const [errorFechaHasta, setErrorFechaHasta] = useState(false);
  const [helperFechaHasta, setHelperFechaHasta] = useState('');

  const [errorTitulo, setErrorTitulo] = useState(false);
  const [helperTitulo, setHelperTitulo] = useState('');

  const [errorDescripcion, setErrorDescripcion] = useState(false);
  const [helperDescripcion, setHelperDescripcion] = useState('');

  // Notificación error grave
    function errorNotification(code, message) {
      const MySwal = withReactContent(Swal); 
      MySwal.fire({
        icon: 'error',
        title: message,
        text: '',
        timer: 5000,
        timerProgressBar: true,
        toast: true,
        position: "center",
        footer: ''
      })
    }


  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutando 'useEffect() en grupoAdd", auth);
    if (row===null) {
      setInput({
        "incidente_usuario_id": '',
        "incidente_tipo_id": '',
        "fechaDesde":null,
        "fechaHasta":null,
        "titulo":'',
        "descripcion": ''
    });
    } else {
      setInput(row);
    }
  }, []);


     // Envío del Formulario
  const saveForms = (e) => { 
    e.preventDefault();
    // console.log("Valores del registro Input: ",input);
    setValidacionForms(true); // Quitamos errores del formulario
    setErrorForms('');

    var existeError = false;
    var Error = '';

    if (input.incidente_usuario_id === '' || errorUsuario ) {
      setHelperUsuario('Hay que facilitar un Usuario Válido');
      setErrorUsuario(true);
      existeError = true;
      Error += ' (Usuario) ';
    }

    if (input.incidente_tipo_id === '' || errorTipo ) {
      setHelperTipo('Hay que facilitar un Tipo de Incidente');
      setErrorTipo(true);
      existeError = true;
      Error += ' (Tipo) ';
    }

    if (input.fechaDesde === null) {
      setHelperFechaDesde('Hay que facilitar una Fecha Desde válida');
      setErrorFechaDesde(true);
      existeError = true;
      Error += ' (Fecha Desde) ';
    }

    if (input.fechaHasta === null ) {
      setHelperFechaHasta('Hay que facilitar una Fecha Hasta válida');
      setErrorFechaHasta(true);
      existeError = true;
      Error += ' (Fecha Hasta) ';
    }
  
    if (input.titulo === '' || errorTitulo ) {
      setHelperTitulo('Hay que facilitar un Titulo Válido');
      setErrorTitulo(true);
      existeError = true;
      Error += ' (Título) ';
    }
    if (input.fechaDesde !== null && input.fechaHasta !== null && dayjs(input.fechaDesde) > dayjs(input.fechaHasta)) {
      // setHelperFechaDesde('Fecha Desde debe ser menor que Fecha Hasta');
      // setErrorFechaDesde(true);
      existeError = true;
      Error += ' (Fecha Desde debe ser menor que Fecha Hasta) ';
    }

    if (!(existeError)) { // se han introducido los valores de los campos
      // console.log("accediendo al Server");

      // Acceso al server y status de la operación
      // console.log("ADD de Casos, antes de enviar: ",input);
      const url = Config.RUTA_API + "/caso/add/0";
      const formData = new FormData();
        formData.append('incidente_usuario_id', input.incidente_usuario_id);
        formData.append('incidente_tipo_id', input.incidente_tipo_id);
        formData.append('fechaDesde', input.fechaDesde);
        formData.append('fechaHasta', input.fechaHasta);
        formData.append('titulo', input.titulo);
        formData.append('descripcion', input.descripcion);
      const config = {
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
            "Authorization": Config.AUTHORIZATION
        },
      };
      axios.post(url, formData, config)
  
        .then((response) => {
          const res = response.data;
          // console.log("Respuesta del fetch: ",res);
          if (res.error === false) {       
            setValidacionForms(true); // Quitamos errores del formulario
            setErrorForms('');
            postSave();               // Alert y navegar a la aplicación
          } else {
            setValidacionForms(false); 
            setErrorForms(res.message);  
          }
        })
        .catch((error) => {
          console.error("Error send Caso: ", error);
          setValidacionForms(false); 
          setErrorForms("Error send Caso: ", error); 
          errorNotification('000', error)

        });
  
    } else {   
      setValidacionForms(false); // Ponemos los errores del formulario 
      Error = 'Falta la entrada de los datos o la información de estos campos está mal: '+ Error;
      setErrorForms(Error);
    }
  };

  const postSave = (e) => {

    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'info',
      title: 'Nuevo Caso creado!!!!',
      text: '',
      timer: 1000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
     })

     onButtonClick('add'); // Devuelve el control a la pantalla "MASTER"

  }

  const handleValidationField = (e) => {
    // console.log("Cambio en campo: ",e);
    const { name, value } = e.target;
    setInput((prev) => ({ ...prev, [name]: value,})); // Cambia el valor en el JSON

    if (name === 'titulo' && ( value.length < 3 || value.length > 50 )) {
      setHelperTitulo('Entrada inválida para "Título"')
      setErrorTitulo(true);
    }else{
      setHelperTitulo('')
      setErrorTitulo(false);
    }
    if (name === 'descripcion' && ( value.length < 0 || value.length > 500 )) {
      setHelperDescripcion('Entrada inválida para "Descripción"')
      setErrorDescripcion(true);
    }else{
      setHelperDescripcion('')
      setErrorDescripcion(false);
    }
    
  };
  
  const handleValidationFechaDesde = (e) => {
    // console.log("Cambio en FechaDesde: ",e);
    const name = 'fechaDesde'; 
    const value = dayjs(e).format('YYYY-MM-DD');
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));
    setInput((prev) => (
      { ...prev,
        ['fechaHasta']: value,
      }));


  };
   
  const handleValidationFechaHasta = (e) => {
    const name = 'fechaHasta'; 
    const value = dayjs(e).format('YYYY-MM-DD');
    setInput((prev) => (
    { ...prev,
      [name]: value,
    }));
  };

  
  return (
    <>

    <ThemeProvider theme={theme}>
    <div className='panel-itemAdd'>
      <div className='box-itemAdd'>
        <Box component="form" noValidate autoComplete="off" > 
        <div className='titlePage'>
          <h3 className="head_title">Añadir Caso</h3>
        </div> 
          <Grid container spacing={2}>
          <Grid xs={12}>
                <InputLabel id="select-label">Selecciona el Usuario *</InputLabel>
                <Select 
                  error={errorUsuario} 
                  id="incidente_usuario_id" 
                  name="incidente_usuario_id"
                  label="Usuario" 
                  required={false}
                  variant="standard"   
                  className= 'CustomField'  
                  value={input.incidente_usuario_id || ''}
                  onChange={handleValidationField}
                >
                {rowsUser.map((row, index) => (
                  <MenuItem key={row.id}  value={row.id}> {row.nombre_apellidos} 
                  </MenuItem> 
                ))}
                </Select>
                {errorUsuario && <FormHelperText>{helperUsuario}</FormHelperText>}
            </Grid>

            <Grid xs={12}>
                <InputLabel id="select-label">Selecciona el Tipo *</InputLabel>
                <Select 
                  error={errorTipo} 
                  id="incidente_tipo_id" 
                  name="incidente_tipo_id"
                  label="Tipo" 
                  required={false}
                  variant="standard"   
                  className= 'CustomField'  
                  value={input.incidente_tipo_id || ''}
                  onChange={handleValidationField}
                >
                {rowsTipo.map((row, index) => (
                  <MenuItem key={row.id}  value={row.id}> {row.titulo} 
                  </MenuItem> 
                ))}
                </Select>
                {errorTipo && <FormHelperText>{helperTipo}</FormHelperText>}
            </Grid>
            <Grid xs={12}>
            <LocalizationProvider dateAdapter={AdapterDayjs} adapterLocale="es">
                <DatePicker
                  error={errorFechaDesde} 
                  required={false}
                  id="fechaDesde"
                  name="fechaDesde" 
                  label="Fecha Desde" 
                  slotProps={{ textField: { variant: "standard" } }}
                  //variant="standard"
                  className= 'CustomField'
                  helperText={helperFechaDesde}
                  value={dayjs(input.fechaDesde)}
                  onChange={(e) => handleValidationFechaDesde(e)} 
                  />
            </LocalizationProvider>
            </Grid>
            <Grid xs={12}>
            <LocalizationProvider dateAdapter={AdapterDayjs} adapterLocale="es">
                <DatePicker
                  error={errorFechaHasta} 
                  required={false}
                  id="fechaHasta"
                  name="fechaHasta" 
                  label="FechaHasta" 
                  slotProps={{ textField: { variant: "standard" } }}
                  //variant="standard"
                  className= 'CustomField'
                  helperText={helperFechaHasta}
                  value={dayjs(input.fechaHasta)}
                  onChange={(e) => handleValidationFechaHasta(e)} 
                  />
            </LocalizationProvider>
            </Grid>
            <Grid xs={12}>
              <TextField  
                  error={errorTitulo} 
                  required={false}
                  id="titulo"
                  name="titulo" 
                  label="Título" 
                  variant="standard" 
                  type= 'text'
                  className= 'CustomField'  
                  helperText={helperTitulo}
                  value={input.titulo }
                  onChange={(e) => handleValidationField(e)}
                  />
            </Grid>
            <Grid xs={12}>
              <TextField  
                  error={errorDescripcion} 
                  required={false}
                  id="descripcion"
                  name="descripcion" 
                  label="Descripción" 
                  variant="standard" 
                  type= 'text' 
                  multiline = {true}
                  rows = {2}
                  className= 'CustomField'  
                  helperText={helperDescripcion}
                  value={input.descripcion}
                  onChange={(e) => handleValidationField(e)}
                  />
            </Grid>
          </Grid>


          <Stack spacing={2} direction="row" sx={{ width: '100%', padding: '15px 10px 15px 10px'}} >
              <Button variant="contained" type='submit'  onClick={(e) => saveForms(e)}>Guardar</Button>
              <Button variant="outlined"                onClick={(e) =>  onButtonClick('add')}>Cancelar</Button>
          </Stack>
          <Stack sx={{ width: '100%' }} spacing={2}>
            { validacionForms? '': <Alert severity="error">{errorForms}</Alert>}
          </Stack>
        </Box>
      </div>
    </div>
    </ThemeProvider>
    </>
  );
}

// IMPORTANT ----------------------------------------
export default (CasoAdd);