import {useEffect, useState, useCallback, useRef} from 'react';
import './style.css';

import Swal from 'sweetalert2';
import withReactContent from 'sweetalert2-react-content';

import { useNavigate } from 'react-router-dom';
import { useParams } from "react-router-dom";

import axios from 'axios';

import Config from '../config';
import Nav from '../nav';
import CasosAdd from '../casosAdd';
import CasosEdit from '../casosEdit';
import CasosView from '../casosView';

import Box from '@mui/material/Box';
import Modal from '@mui/material/Modal';

// import { formatDate } from '@fullcalendar/core'
import FullCalendar from '@fullcalendar/react'
import dayGridPlugin from '@fullcalendar/daygrid'
import timeGridPlugin from '@fullcalendar/timegrid'
import interactionPlugin from '@fullcalendar/interaction'
import multiMonthPlugin from '@fullcalendar/multimonth'
// import { INITIAL_EVENTS, createEventId } from './event-utils'
import esLocale from '@fullcalendar/core/locales/es';

import 'dayjs/locale/es';
import dayjs from 'dayjs';

import tippy from 'tippy.js'
import 'tippy.js/dist/tippy.css';
import 'tippy.js/themes/light.css'; // Opcional: tema adicional


const styleModal = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: 555,
  bgcolor: 'background.paper',
  // border: '2px solid #000',
  // boxShadow: 24,
  p: 4,
};
const styleModalMobile = {
  position: 'absolute',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: '100%',
  bgcolor: 'background.paper',
  // border: '2px solid #000',
  // boxShadow: 24,
  // p: 1,
};

const withRouter = (Component) => {
  const Wrapper = (props) => {
    const navigate = useNavigate();
    return <Component navigate={navigate} {...props} />;
  };
  return Wrapper;
};

function Calendario(props) {

  const calendarRef = useRef(null);

  const [weekendsVisible, setWeekendsVisible] = useState(true);
  const [currentEvents, setCurrentEvents] = useState([]);

  // const [isData,setIsData] = useState(false);  // Control de datos cargados
  const [startEvent, setStartEvent ]= useState('');
  const [endEvent, setEndEvent ]= useState('');
  // For ADD Event
  const [startAddEvent, setStartAddEvent ]= useState('');
  const [endAddEvent, setEndAddEvent ]= useState('');

  const [rows, setRows] = useState([]);
  const [row, setRow] = useState({});
  const [rowsTipo, setRowsTipo] = useState([]);
  const [rowsUser, setRowsUser] = useState([]);
  const [user, setUser] = useState({});


  const [rowSelectionModel, setRowSelectionModel] = useState([]); // Para control del registro seleccionado en el GRID
  const [action, setAction] = useState(''); // Acción sobre el registro (row) - add, edit, view -
   const [open, setOpen] = useState(false);   // Open / Close Modal window

  const [refresh, setRefresh] = useState(true);
  const [isMobile, setIsMobile] = useState(false);
  const [isDouble, setIsDouble] = useState(true);
  const [viewList, setViewList] = useState(true);

  const { id } = useParams();

  // Notificación error grave
  function errorNotification(code, message) {
    const MySwal = withReactContent(Swal); 
    MySwal.fire({
      icon: 'error',
      title: message,
      text: '',
      timer: 5000,
      timerProgressBar: true,
      toast: true,
      position: "center",
      footer: ''
    })
    // props.navigate(Config.URL_APP+'/');
  }
  // Cargar los datos del Server cuando se carga la página
  useEffect(() => {
    // console.log("Ejecutándose 'useEffect");
    setRefresh(false);
    setAction('');
    // console.log(" Valores iniciales de datos de prueba: ",INITIAL_EVENTS);

    var formWitdh = window.innerWidth;
    // console.log("Ancho de pantalla: ",formWitdh);
    if (formWitdh < 768) {
      // console.log("pone isMobile a 'true'");
      setIsMobile(true);
    }
    if (formWitdh < 1390) { // Para ver si tenemos que ocultar el GRID
      setIsDouble(false);
    }

    }, [refresh]);


    // Función auxiliar para formatear fechas
    const formatDate = (date) => {
      return new Date(date).toLocaleDateString('es-ES');
    };

  // Función para cargar eventos dinámicamente
  const fetchEvents = (start_fech, end_fech) => {

    console.log('Cargando eventos desde:', start_fech, ' hasta ', end_fech);
    // console.log(" Objeto fechInfo: ",fetchInfo);

    const url = Config.RUTA_API + "/casoCalendar";
    const formData = new FormData();
    formData.append('start',  start_fech);
    formData.append('end'  ,  end_fech);
    formData.append('id_user',  id);
    const config = {
      headers: {
          "Content-Type": "application/x-www-form-urlencoded",
          "Authorization": Config.AUTHORIZATION
      },
    };
           
    axios.post(url,formData,config) 
    .then((response) => {    
        var msg = response.data;
        // console.log("Respuesta del fetch: ",msg); 
        if (msg.error === true )  { 
          console.log("Hay un error: ",msg.message);
          errorNotification(msg.error, msg.message);
        } else {
          // Transforma los datos al formato que FullCalendar espera
          const formattedEvents = msg.data.map(event => (
            {
            id: event.id.toString(),
            title: event.titulo|| 'Sin título',
            start: event.fechaDesde,       // Asegúrate que estos campos existan
            // end: dayjs(event.FechaHasta, "YYYY-MM-DD").add(1, 'day').format('YYYY-MM-DD'),  // en tu respuesta del servidor
            end: event.end,
            allDay: true,             // Para eventos de varios días
            color: event.color,       // Opcional
            extendedProps: {          // Datos adicionales
              description: event.descripcion
            }
          }));
          setCurrentEvents(formattedEvents);
          // console.log("Datos formateados: ", formattedEvents);
          setRows(msg.data);
          setRowsTipo(msg.dataTipo);
          setRowsUser(msg.dataUsuario);

          userFind(id,msg.dataUsuario);

          // console.log("Casos: ",msg.data);
          // console.log("Tipos: ",msg.dataTipo);
          // console.log("Usuarios: ",msg.dataUsuario);
        }           
      })
      .catch((error) => {
        console.error("Error get Lista Casos ", error);
        errorNotification('000', error);
      })
      
  }; 
  // Función para buscar un usuario por ID y actualizar el estado
  const userFind = (id, rows) => {
    // Verifica si `rows` es un array y no está vacío
    if (!Array.isArray(rows) || rows.length === 0) {
      console.error("Error: 'rows' no es un array válido o está vacío");
      return;
    }
    const row = rows.find((row) => Number(row.id) === Number(id));
    /* console.log(
      "Datos de los usuarios:", rows,
      "ID del usuario:", id,
      "Datos del seleccionado:", row
    );
    */
    if (row !== undefined && row !== null) {
      setUser(row);
    }
  };

  // For Add Event with selection detes
  function handleDateSelect(selectInfo) {
    console.log("Selección de evento: ",selectInfo);
    const end = dayjs(selectInfo.endStr).subtract(1, 'day').format("YYYY-MM-DD");   // Paras visualizar día completo hay que añadir un día
    setRow({
      "incidente_usuario_id": id,
      "incidente_tipo_id": '',
      "fechaDesde": selectInfo.startStr,
      "fechaHasta": end ,
      "titulo":'',
      "descripcion": ''
  });

    setOpen(true);
    setAction('add');



    /*
    let title = prompt('Please enter a new title for your event')
    let calendarApi = selectInfo.view.calendar

    calendarApi.unselect() // clear date selection

    if (title) {
      calendarApi.addEvent({
        id: createEventId(),
        title,
        start: selectInfo.startStr,
        end: selectInfo.endStr,
        allDay: selectInfo.allDay
      })
    }
      */
  }

  function handleEventClick(clickInfo) {
   
    const id_caso = clickInfo.event.id;
    const row = rows.find((row) => Number(row.id) === Number(id_caso));
    setRow(row);
    setOpen(true);
    setAction('view');
  }

  // Manejar cambio de fecha/vista
  const handleDatesSet =  (dateInfo) => {
    /*
    console.log('Vista cambiada:', dateInfo.view.type, 
                'Fecha inicio:', dateInfo.start, 
                'Fecha fin:', dateInfo.end);
    */
    const start_fech = dateInfo.start.toISOString().split('T')[0];
    const end_fech = dateInfo.end.toISOString().split('T')[0];

    if ( start_fech !== startEvent || end_fech !== endEvent ) {
 
      setStartEvent(start_fech);
      setEndEvent(end_fech);

      fetchEvents(start_fech,end_fech);  // Carga los eventos del nuevo rango
    }
  };

  function renderEventContent(eventInfo) {
    return (
      <>
        <b>{eventInfo.timeText}</b>
        <i>{eventInfo.event.title}</i>
      </>
    )
  }
  
   // Actualizar tooltips cuando cambian los eventos Necesario para que los Tooltip se actualicen cuando se recargam los datos
   const handleEventSet = (events) => {
    // console.log("Estoy en EventSet: ",events);

    // Usamos el selector directamente ya que no necesitamos calendarApi aquí
    const eventElements = document.querySelectorAll('.fc-event');
        
    eventElements.forEach(el => {
      const eventId = el.getAttribute('data-event-id');
      const c_event = currentEvents.find(e => e.id === eventId);
      // console.log("Datos del Evento: ",c_event);
      tippy(el, {
        content: createTooltipContent(c_event),
        allowHTML: true,
        interactive: true,
        appendTo: () => document.body,
        theme: 'light',
        placement: 'top',
        delay: [300, 0],
        duration: [200, 0],
        zIndex: 9999
      });  
    })
  }

  const createTooltipContent = (event) => {
    // console.log('Event data for tooltip:', event); // Verifica que los datos sean correctos
    const end = dayjs(event.end).subtract(1, 'day');   // Paras visualizar día completo hay que añadir un día
    return `
      <div class="custom-tooltip">
        <h4>${event.title || 'Sin título'}</h4>
        ${event.extendedProps?.description ? 
          `<p>${event.extendedProps.description}</p>` : ''}
        <small>${formatDate(event.start)} - ${formatDate(end)}</small>
      </div>
    `;
  };


  const handleButtonClickFromItem = (actionRb,newAction = '') => {
    console.log("Regreso formulario remoto: ",action);
    setOpen(false);
    
    if (actionRb === 'add') {
      setAction('');
      fetchEvents(startEvent,endEvent);  // Carga los eventos del nuevo rango
    }
    
    if (actionRb === 'edit') {
      setAction('');
      fetchEvents(startEvent,endEvent);  // Carga los eventos del nuevo rango
    }
    
    if (actionRb === 'view') {
      setAction('');
      // console.log("Valor de Nueva Acción: ",newAction);
      if (newAction !== '') {
        switch (newAction) {
          case "edit":
            setOpen(true);
            setAction(newAction);
            break;
          case "delete":

            fetchEvents(startEvent,endEvent);  // Carga los eventos del nuevo rango
            // console.log("Después del 'FetchEvents' : ");
            break;
          default:
            // console.log("Pasó por default");
          }
        } 
    }    
  };

  /*
  // Gestión de respuesta de páginas modales
  const handleButtonClickFromItem = (action,newAction = '') => {
    console.log("Regreso formulario remoto: ",action);
    setOpen(false);
    if (action === 'add') {
      setAction('');
      fetchEvents(startEvent,endEvent);  // Carga los eventos del nuevo rango
    }
    if (action === 'edit') {
      setAction('');
      fetchEvents(startEvent,endEvent);  // Carga los eventos del nuevo rango
    }
    if (action === 'view') {
      setAction('');
      if (newAction !== '') {
        setOpen(true);
        setAction(newAction);
      }
    }
  };
  */

  return (
    <>
    <Nav />
    <div>
      <div className='panel_calendar'>
        <div className='box-itemList_calendar'>
              <div className='titlePage'>
                  <h3 className="head_title">Estos son los Casos de los Incidentes del usuario: {user.nombre_apellidos} </h3>
              </div>
        </div>
      </div>

      <div className='calendar'>
        <FullCalendar
          plugins={[dayGridPlugin, timeGridPlugin, interactionPlugin, multiMonthPlugin]}
          headerToolbar= {{ center: 'dayGridMonth Trimestre multiMonthYear' }} // buttons for switching between views

          locales= {[esLocale]}
          timeZone= 'UTC+1' 
          locale= 'es' // the initial locale. if not specified, uses the first one
          height= 'auto'

          views = {{
            Trimestre: {
             type: 'multiMonth' ,
             duration: { months: 3 },
            }
          }}
          // multiMonthMaxEvents={true}
          initialView='dayGridMonth'    
          multiMonthMinWidth= {50}
          multiMonthMaxColumns= {3}

          // nowIndicator={true}
          // displayEventTime={false} // Para eventos de todo el día
          // eventDisplay="block"    // Muestra como bloque sólido
          // dayMaxEventRows={3}     // Máximo de eventos por día
          dayHeaders={true}

          editable={false}
          selectable={true}
          selectMirror={false}
          dayMaxEvents={true}
          weekends={weekendsVisible}
          events={currentEvents} 
          select={handleDateSelect}
          eventContent={renderEventContent} // custom render function
          eventClick={handleEventClick}
          datesSet={handleDatesSet} // Para detectar cambios de vista/fecha
          eventsSet={handleEventSet} // Se ejecuta cuando -  events are initialized/added/changed/removed
          // eventDidMount={handleTooltip} // Event managment the Tooltip
          eventDidMount={(arg) => {
            arg.el.setAttribute('data-event-id', arg.event.id);
            arg.el.style.cursor = 'pointer';
            // console.log("Estoy en DidMount: ",arg);          
          }}

          /* you can update a remote database when these fire:
          eventAdd={function(){}}
          eventChange={function(){}}
          eventRemove={function(){}}
          */
        />

      </div>
        <Modal
            open={open}
            // onClose={handleButtonClickFromItem('add')}
            // aria-labelledby="modal-modal-title"
            // aria-describedby="modal-modal-description"
          >
            <Box sx={styleModal}>
              { action === 'add'?<CasosAdd  rowsTipo={rowsTipo}  rowsUser={rowsUser} row={row} onButtonClick={handleButtonClickFromItem} />:''}
              { action === 'edit'? <CasosEdit  row={row} rowsUser={rowsUser} rowsTipo={rowsTipo} onButtonClick={handleButtonClickFromItem}/> :''}
              { action === 'view'? <CasosView row={row} rowsUser={rowsUser} rowsTipo={rowsTipo}  onButtonClick={handleButtonClickFromItem}/> :''}
          </Box>
        </Modal>
    </div>
    </>
  )
}

// IMPORTANT ----------------------------------------
export default withRouter( Calendario);
