<?php

// include_once '../include/Config.php';  // Configuration Rest Api

/**
 *
 * @About:      Gestión de Datos de Gestión de firmas
 * @File:       Dbsignature.php
 * @Date:       $Date:$ April 2025
 * @Version:    $Rev:$ 1.0
 * @Developer:  fernando humanes
 **/

    use Psr\Http\Message\ResponseInterface as Response;
    use Psr\Http\Message\ServerRequestInterface as Request;
    use Selective\BasePath\BasePathMiddleware;
    use Slim\Factory\AppFactory;

class Dbsignature
{

    private $connDB;

    function __construct()
    {
        /* You should enable error reporting for mysqli before attempting to make a connection */
        mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
        $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        /* Set the desired charset after establishing a connection */
        $mysqli->set_charset('utf8mb4');
        
        $this->connDB = $mysqli;      // No se usa esta conexión si está integrado con PHPRunner
    }
    
    private function responseKO ($data_arr) {
        global $errorMessages;
        $data_arr['error'] = true;
        $data_arr["message_num"] = '005';
        $data_arr["message"] = str_replace("?",$this->connDB->error,$errorMessages['005']);
        $this->connDB->close();
        return $data_arr;
    }
    private function responseOK ($data_arr) {
        global $errorMessages;
        $data_arr['error'] = false;
        $data_arr["message_num"] = '006';
        $data_arr["message"] = $errorMessages['006'];
        $this->connDB->close();
        return $data_arr;
    }
    /*
    * ADD de Firmas
    */
    public function addSignature($param, Request $request,Response $response)
    {
        global $errorMessages;
                
        $signature = $param['signature'];
        $timestamp = $param['timestamp'];
        // Decodificar la cadena Base64
        $imageData = base64_decode($signature);
        
        $filename = uniqid('firma_') . '.png';
        
        // Convesión de fecha y adaptación a zona Horaria
        $dt_obj = new DateTime($timestamp ." UTC");                 // La fecha la recibimos en formato UTC
        $dt_obj->setTimezone(new DateTimeZone('Europe/Madrid'));    // La adaptamos al formato del servidor
        $timestamp = date_format($dt_obj, 'Y-m-d H:i:s');
   
        $sql = "
        INSERT INTO signature_react (`file`, `nameFile`, `creationDate`)
        VALUES (?,?,?)";
        
        $data_arr = array();
        $stmt = $this->connDB->prepare($sql);

        $stmt->bind_param('bss',$imageData, $filename, $timestamp);
        // Para enviar el BLOB en bloques (útil para archivos grandes)
        $stmt->send_long_data(0, $imageData);
        
        $stmt->execute();  
        
        return $this->responseOK($data_arr);     
    }
    


}
