import React from 'react';
import * as pdfMake from 'pdfmake/build/pdfmake'

// utils/loadFonts.js
export async function loadFonts() {
    const [normal, bold] = await Promise.all([
      fetch(`${process.env.PUBLIC_URL}/fonts/Roboto-Regular.ttf`).then(res => res.arrayBuffer()),
      fetch(`${process.env.PUBLIC_URL}/fonts/Roboto-Medium.ttf`).then(res => res.arrayBuffer())
    ]);
  
    pdfMake.vfs = {
      'Roboto-Regular.ttf': normal,
      'Roboto-Medium.ttf': bold
    };
  
    pdfMake.fonts = {
      Roboto: {
        normal: 'Roboto-Regular.ttf',
        bold: 'Roboto-Medium.ttf'
      }
    };
  }